var ASPx = ASPx || {};
var dx = dx || {};
(function () {
ASPx.EmptyObject = { };
ASPx.FalseFunction = function() { return false; };
ASPx.SSLSecureBlankUrl = '/DXR.axd?r=1_0-IizCn';
ASPx.EmptyImageUrl = '/DXR.axd?r=1_58-IizCn';
ASPx.VersionInfo = 'Version=\'17.2.3.0\', File Version=\'17.2.3.0\', Date Modified=\'2021/10/15 2:13:02\'';
ASPx.Platform = 'ASP';
ASPx.InvalidDimension = -10000;
ASPx.InvalidPosition = -10000;
ASPx.AbsoluteLeftPosition = -10000;
ASPx.EmptyGuid = "00000000-0000-0000-0000-000000000000";
ASPx.CallbackSeparator = ":";
ASPx.ItemIndexSeparator = "i";
ASPx.CallbackResultPrefix = "/*DX*/";
ASPx.AccessibilityEmptyUrl = "javascript:;";
ASPx.AccessibilityPronounceTimeout = 500;
ASPx.MaxMobileWindowWidth = 576;
ASPx.PossibleNumberDecimalSeparators = [",", "."];
ASPx.CultureInfo = {
 twoDigitYearMax: 2029,
 ts: ":",
 ds: "/",
 am: "AM",
 pm: "PM",
 monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""],
 genMonthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""],
 abbrMonthNames: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""],
 abbrDayNames: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
 dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
 invariantCultureDecimalPoint: ".",
 numDecimalPoint: ".",
 numPrec: 2,
 numGroupSeparator: ",", 
 numGroups: [ 3 ],
 numNegPattern: 1,
 numPosInf: "Infinity", 
 numNegInf: "-Infinity", 
 numNan: "NaN",
 currency: "$",
 currDecimalPoint: ".",
 currPrec: 2,
 currGroupSeparator: ",",
 currGroups: [ 3 ],
 currPosPattern: 0,
 currNegPattern: 0,
 percentPattern: 0,
 shortTime: "h:mm tt",
 longTime: "h:mm:ss tt",
 shortDate: "M/d/yyyy",
 longDate: "dddd, MMMM d, yyyy",
 monthDay: "MMMM d",
 yearMonth: "MMMM yyyy"
};
ASPx.CultureInfo.genMonthNames = ASPx.CultureInfo.monthNames;
ASPx.Position = {
 Left: "Left",
 Right: "Right",
 Top: "Top",
 Bottom: "Bottom"
};
var DateUtils = { };
DateUtils.GetInvariantDateString = function(date) {
 if(!date)
  return "01/01/0001";
 var day = date.getDate();
 var month = date.getMonth() + 1;
 var year = date.getFullYear();
 var result = "";
 if(month < 10)
  result += "0";
 result += month.toString() + "/";
 if(day < 10)
  result += "0";
 result += day.toString() + "/";
 if(year < 1000)
  result += "0";
 result += year.toString();
 return result;
};
DateUtils.GetInvariantDateTimeString = function(date) {
 var dateTimeString = DateUtils.GetInvariantDateString(date);
 var time = {
  h: date.getHours(),
  m: date.getMinutes(),
  s: date.getSeconds()
 };
 for(var key in time) {
  if(time.hasOwnProperty(key)) {
   var str = time[key].toString();
   if(str.length < 2)
    str = "0" + str;
   time[key] = str;
  }
 }
 dateTimeString += " " + time.h + ":" + time.m + ":" + time.s;
 var msec = date.getMilliseconds();
 if(msec > 0)
  dateTimeString += "." + ("000" + msec.toString()).substr(-3);
 return dateTimeString;
};
DateUtils.ExpandTwoDigitYear = function(value) {
 value += 1900;
 if(value + 99 < ASPx.CultureInfo.twoDigitYearMax)
  value += 100;
 return value;  
};
DateUtils.ToUtcTime = function(date) {
 var result = new Date();
 result.setTime(date.valueOf() + 60000 * date.getTimezoneOffset());
 return result;
};
DateUtils.ToLocalTime = function(date) {
 var result = new Date();
 result.setTime(date.valueOf() - 60000 * date.getTimezoneOffset());
 return result; 
};
DateUtils.AreDatesEqualExact = function(date1, date2) {
 if(date1 == null && date2 == null)
  return true;
 if(date1 == null || date2 == null)
  return false;
 return date1.getTime() == date2.getTime(); 
};
DateUtils.FixTimezoneGap = function(oldDate, newDate) {
 var diff = newDate.getHours() - oldDate.getHours();
 if(diff == 0)
  return;
 var sign = (diff == 1 || diff == -23) ? -1 : 1;
 var trial = new Date(newDate.getTime() + sign * 3600000);
 var isDateChangedAsExpected = newDate.getHours() - trial.getHours() === diff;
 if(isDateChangedAsExpected && (sign > 0 || trial.getDate() == newDate.getDate()))
  newDate.setTime(trial.getTime());
};
ASPx.DateUtils = DateUtils;
var Timer = { };
Timer.ClearTimer = function(timerID){
 if(timerID > -1)
  window.clearTimeout(timerID);
 return -1;
};
Timer.ClearInterval = function(timerID){
 if(timerID > -1)
  window.clearInterval(timerID);
 return -1;
};
var setControlBoundTimer = function(handler, control, setTimerFunction, clearTimerFunction, delay) {
 var timerId;
 var getTimerId = function() { return timerId; };
 var boundHandler = function() {
  var controlExists = control && ASPx.GetControlCollection().Get(control.name) === control;
  if(controlExists)
   handler.aspxBind(control)();
  else
   clearTimerFunction(getTimerId());
 };
 timerId = setTimerFunction(boundHandler, delay);
 return timerId;
};
Timer.SetControlBoundTimeout = function(handler, control, delay) {
 return setControlBoundTimer(handler, control, window.setTimeout, Timer.ClearTimer, delay);
};
Timer.SetControlBoundInterval = function(handler, control, delay) {
 return setControlBoundTimer(handler, control, window.setInterval, Timer.ClearInterval, delay);
};
Timer.Throttle = function(func, delay) {
 var isThrottled = false,
   savedArgs,
   savedThis = this;
 function wrapper() {
  if(isThrottled) {
   savedArgs = arguments;
   savedThis = this;
   return;
  }
  func.apply(this, arguments);
  isThrottled = true;
  setTimeout(function() {
   isThrottled = false;
   if(savedArgs) {
    wrapper.apply(savedThis, savedArgs);
    savedArgs = null;
   }
  }, delay);
 }
 wrapper.cancel = function() {
  clearTimeout(delay);
  delay = savedArgs = savedThis = null;
 };
 return wrapper;
};
ASPx.Timer = Timer;
var Browser = { };
Browser.UserAgent = navigator.userAgent.toLowerCase();
Browser.Mozilla = false;
Browser.IE = false;
Browser.Firefox = false;
Browser.Netscape = false;
Browser.Safari = false;
Browser.Chrome = false;
Browser.Opera = false;
Browser.Edge = false;
Browser.Version = undefined; 
Browser.MajorVersion = undefined; 
Browser.WindowsPlatform = false;
Browser.MacOSPlatform = false;
Browser.MacOSMobilePlatform = false;
Browser.AndroidMobilePlatform = false;
Browser.PlaformMajorVersion = false;
Browser.WindowsPhonePlatform = false;
Browser.AndroidDefaultBrowser = false;
Browser.AndroidChromeBrowser = false;
Browser.SamsungAndroidDevice = false;
Browser.WebKitTouchUI = false;
Browser.MSTouchUI = false;
Browser.TouchUI = false;
Browser.WebKitFamily = false; 
Browser.NetscapeFamily = false; 
Browser.HardwareAcceleration = false;
Browser.VirtualKeyboardSupported = false;
Browser.Info = "";
function indentPlatformMajorVersion(userAgent) {
 var regex = /(?:(?:windows nt|macintosh|mac os|cpu os|cpu iphone os|android|windows phone|linux) )(\d+)(?:[-0-9_.])*/;
 var matches = regex.exec(userAgent);
 if(matches)
  Browser.PlaformMajorVersion = matches[1];
}
function getIECompatibleVersionString() {
 if(document.compatible) {
  for(var i = 0; i < document.compatible.length; i++)
   if(document.compatible[i].userAgent === "IE" && document.compatible[i].version)
    return document.compatible[i].version.toLowerCase();
 }
 return "";
}
Browser.IdentUserAgent = function(userAgent, ignoreDocumentMode) {
 var browserTypesOrderedList = [ "Mozilla", "IE", "Firefox", "Netscape", "Safari", "Chrome", "Opera", "Opera10", "Edge" ];
 var defaultBrowserType = "IE";
 var defaultPlatform = "Win";
 var defaultVersions = { Safari: 2, Chrome: 0.1, Mozilla: 1.9, Netscape: 8, Firefox: 2, Opera: 9, IE: 6, Edge: 12 };
 if(!userAgent || userAgent.length == 0) {
  fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
  return;
 }
 userAgent = userAgent.toLowerCase();
 indentPlatformMajorVersion(userAgent);
 try {
  var platformIdentStrings = {
   "Windows": "Win",
   "Macintosh": "Mac",
   "Mac OS": "Mac",
   "Mac_PowerPC": "Mac",
   "cpu os": "MacMobile",
   "cpu iphone os": "MacMobile",
   "Android": "Android",
   "!Windows Phone": "WinPhone",
   "!WPDesktop": "WinPhone",
   "!ZuneWP": "WinPhone"
  };
  var optSlashOrSpace = "(?:/|\\s*)?";
  var version = "(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?";
  var optVersion = "(?:" + version + ")?";
  var patterns = {
   Safari: "applewebkit(?:.*?(?:version/" + version + "[\\.\\w\\d]*?(?:\\s+mobile\/\\S*)?\\s+safari))?",
   Chrome: "(?:chrome|crios)(?!frame)" + optSlashOrSpace + optVersion,
   Mozilla: "mozilla(?:.*rv:" + optVersion + ".*Gecko)?",
   Netscape: "(?:netscape|navigator)\\d*/?\\s*" + optVersion,
   Firefox: "firefox" + optSlashOrSpace + optVersion,
   Opera: "(?:opera|opr)" + optSlashOrSpace + optVersion,
   Opera10: "opera.*\\s*version" + optSlashOrSpace + optVersion,
   IE: "msie\\s*" + optVersion,
   Edge: "edge" + optSlashOrSpace + optVersion
  };
  var browserType;
  var version = -1;
  for(var i = 0; i < browserTypesOrderedList.length; i++) {
   var browserTypeCandidate = browserTypesOrderedList[i];
   var regExp = new RegExp(patterns[browserTypeCandidate], "i");
   if(regExp.compile)
    regExp.compile(patterns[browserTypeCandidate], "i");
   var matches = regExp.exec(userAgent);
   if(matches && matches.index >= 0) {
    if(browserType == "IE" && version >= 11 && browserTypeCandidate == "Safari") 
     continue;
    browserType = browserTypeCandidate;
    if(browserType == "Opera10")
     browserType = "Opera";
    var tridentPattern = "trident" + optSlashOrSpace + optVersion;
    version = Browser.GetBrowserVersion(userAgent, matches, tridentPattern, getIECompatibleVersionString());
    if(browserType == "Mozilla" && version >= 11)
     browserType = "IE";
   }
  }
  if(!browserType)
   browserType = defaultBrowserType;
  var browserVersionDetected = version != -1;
  if(!browserVersionDetected)
   version = defaultVersions[browserType];
  var platform;
  var minOccurenceIndex = Number.MAX_VALUE;
  for(var identStr in platformIdentStrings) {
   if(!platformIdentStrings.hasOwnProperty(identStr)) continue;
   var importantIdent = identStr.substr(0,1) == "!";
   var occurenceIndex = userAgent.indexOf((importantIdent ? identStr.substr(1) : identStr).toLowerCase());
   if(occurenceIndex >= 0 && (occurenceIndex < minOccurenceIndex || importantIdent)) {
    minOccurenceIndex = importantIdent ? 0 : occurenceIndex;
    platform = platformIdentStrings[identStr];
   }
  }
  var samsungPattern = "SM-[A-Z]";
  var matches = userAgent.toUpperCase().match(samsungPattern);
  var isSamsungAndroidDevice = matches && matches.length > 0;
  if(platform == "WinPhone" && version < 9)
   version = Math.floor(getVersionFromTrident(userAgent, "trident" + optSlashOrSpace + optVersion));
  if(!ignoreDocumentMode && browserType == "IE" && version > 7 && document.documentMode < version)
   version = document.documentMode;
  if(platform == "WinPhone")
   version = Math.max(9, version);
  if(!platform)
   platform = defaultPlatform;
  if(platform == platformIdentStrings["cpu os"] && !browserVersionDetected) 
   version = 4;
  fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice);
 } catch(e) {
  fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
 }
};
function getVersionFromMatches(matches) {
 var result = -1;
 var versionStr = "";
 if(matches[1]) {
  versionStr += matches[1];
  if(matches[2])
   versionStr += "." + matches[2];
 }
 if(versionStr != "") {
  result = parseFloat(versionStr);
  if(isNaN(result))
   result = -1;
 }
 return result;
}
function getVersionFromTrident(userAgent, tridentPattern) {
 var tridentDiffFromVersion = 4;
 var matches = new RegExp(tridentPattern, "i").exec(userAgent);
 return getVersionFromMatches(matches) + tridentDiffFromVersion;
}
Browser.GetBrowserVersion = function(userAgent, matches, tridentPattern, ieCompatibleVersionString) {
 var version = getVersionFromMatches(matches);
 if(ieCompatibleVersionString) {
  var versionFromTrident = getVersionFromTrident(userAgent, tridentPattern);
  if(ieCompatibleVersionString === "edge" || parseInt(ieCompatibleVersionString) === versionFromTrident)
   return versionFromTrident;
 }
 return version;
};
function fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice) {
 for(var i = 0; i < browserTypesOrderedList.length; i++) {
  var type = browserTypesOrderedList[i];
  Browser[type] = type == browserType;
 }
 Browser.Version = Math.floor(10.0 * version) / 10.0;
 Browser.MajorVersion = Math.floor(Browser.Version);
 Browser.WindowsPlatform = platform == "Win" || platform == "WinPhone";
 Browser.MacOSPlatform = platform == "Mac";
 Browser.MacOSMobilePlatform = platform == "MacMobile";
 Browser.AndroidMobilePlatform = platform == "Android";
 Browser.WindowsPhonePlatform = platform == "WinPhone";
 Browser.WebKitFamily = Browser.Safari || Browser.Chrome || Browser.Opera && Browser.MajorVersion >= 15;
 Browser.NetscapeFamily = Browser.Netscape || Browser.Mozilla || Browser.Firefox;
 Browser.HardwareAcceleration = (Browser.IE && Browser.MajorVersion >= 9) || (Browser.Firefox && Browser.MajorVersion >= 4) || 
  (Browser.AndroidMobilePlatform && Browser.Chrome) || (Browser.Chrome && Browser.MajorVersion >= 37) || 
  (Browser.Safari && !Browser.WindowsPlatform) || Browser.Edge || (Browser.Opera && Browser.MajorVersion >= 46);
 Browser.WebKitTouchUI = Browser.MacOSMobilePlatform || Browser.AndroidMobilePlatform;
 var isIETouchUI = Browser.IE && Browser.MajorVersion > 9 && Browser.WindowsPlatform && Browser.UserAgent.toLowerCase().indexOf("touch") >= 0;
 Browser.MSTouchUI = isIETouchUI || (Browser.Edge && !!window.navigator.maxTouchPoints);
 Browser.TouchUI = Browser.WebKitTouchUI || Browser.MSTouchUI;
 Browser.MobileUI = Browser.WebKitTouchUI || Browser.WindowsPhonePlatform;
 Browser.AndroidDefaultBrowser = Browser.AndroidMobilePlatform && !Browser.Chrome;
 Browser.AndroidChromeBrowser = Browser.AndroidMobilePlatform && Browser.Chrome;
 if(isSamsungAndroidDevice)
  Browser.SamsungAndroidDevice = isSamsungAndroidDevice;
 if(Browser.MSTouchUI) {
  var isARMArchitecture = Browser.UserAgent.toLowerCase().indexOf("arm;") > -1;    
  Browser.VirtualKeyboardSupported = isARMArchitecture || Browser.WindowsPhonePlatform;   
 } else {
  Browser.VirtualKeyboardSupported = Browser.WebKitTouchUI;
 }
 fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList);
}
function fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList) {
 var documentElementClassName = "";
 var browserTypeslist = browserTypesOrderedList.concat(["WindowsPlatform", "MacOSPlatform", "MacOSMobilePlatform", "AndroidMobilePlatform",
   "WindowsPhonePlatform", "WebKitFamily", "WebKitTouchUI", "MSTouchUI", "TouchUI", "AndroidDefaultBrowser"]);
 for(var i = 0; i < browserTypeslist.length; i++) {
  var type = browserTypeslist[i];
  if(Browser[type])
   documentElementClassName += "dx" + type + " ";
 }
 documentElementClassName += "dxBrowserVersion-" + Browser.MajorVersion;
 if(document && document.documentElement) {
  if(document.documentElement.className != "")
   documentElementClassName = " " + documentElementClassName;
  document.documentElement.className += documentElementClassName;
  Browser.Info = documentElementClassName;
 }
}
Browser.IdentUserAgent(Browser.UserAgent);
ASPx.Browser = Browser;
ASPx.BlankUrl = Browser.IE ? ASPx.SSLSecureBlankUrl : (Browser.Opera ? "about:blank" : "");
var Data = { };
Data.ArrayInsert = function(array, element, position){
 if(0 <= position && position < array.length){
  for(var i = array.length; i > position; i --)
   array[i] = array[i - 1];
  array[position] = element;
 }
 else
  array.push(element);
};
Data.ArrayRemove = function(array, element){
 var index = Data.ArrayIndexOf(array, element);
 if(index > -1) Data.ArrayRemoveAt(array, index);
};
Data.ArrayRemoveAt = function(array, index){
 if(index >= 0  && index < array.length){
  for(var i = index; i < array.length - 1; i++)
   array[i] = array[i + 1];
  array.pop();
 }
};
Data.ArrayClear = function(array){
 while(array.length > 0)
  array.pop();
};
Data.ArrayIndexOf = function(array, element, comparer) {
 if(!comparer) {
  for(var i = 0; i < array.length; i++) {
   if(array[i] == element)
    return i;
  }
 } else {
  for(var i = 0; i < array.length; i++) {
   if(comparer(array[i], element))
    return i;
  }
 }
 return -1;
};
Data.ArrayContains = function(array, element) { 
 return Data.ArrayIndexOf(array, element) >= 0;
};
Data.ArrayEqual = function(array1, array2) {
 var count1 = array1.length;
 var count2 = array2.length;
 if(count1 != count2)
  return false;
 for(var i = 0; i < count1; i++)
  if(array1[i] != array2[i])
   return false;
 return true;
};
Data.ArraySame = function(array1, array2) {
 if(array1.length !== array2.length)
  return false;
 return array1.every(function(elem) { return Data.ArrayContains(array2, elem); });
};
Data.ArrayGetIntegerEdgeValues = function(array) {
 var arrayToSort = Data.CollectionToArray(array);
 Data.ArrayIntegerAscendingSort(arrayToSort);
 return {
  start: arrayToSort[0],
  end: arrayToSort[arrayToSort.length - 1]
 };
};
Data.ArrayIntegerAscendingSort = function(array){
 Data.ArrayIntegerSort(array);
};
Data.ArrayIntegerSort = function(array, desc) {
 array.sort(function(i1, i2) {
  var res = 0;
  if(i1 > i2)
   res = 1;
  else if(i1 < i2)
   res = -1;
  if(desc)
   res *= -1;
  return res;
 });
};
Data.CollectionsUnionToArray = function(firstCollection, secondCollection) {
 var result = [];
 var firstCollectionLength = firstCollection.length;
 var secondCollectionLength = secondCollection.length;
 for(var i = 0; i < firstCollectionLength + secondCollectionLength; i++) {
  if(i < firstCollectionLength)
   result.push(firstCollection[i]);
  else
   result.push(secondCollection[i - firstCollectionLength]);
 }
 return result;
};
Data.CollectionToArray = function(collection) {
 var array = [];
 for(var i = 0; i < collection.length; i++)
  array.push(collection[i]);
 return array;
};
Data.CreateHashTableFromArray = function(array) {
 var hash = [];
 for(var i = 0; i < array.length; i++)
  hash[array[i]] = 1;
 return hash;
};
Data.CreateIndexHashTableFromArray = function(array) {
 var hash = [];
 for(var i = 0; i < array.length; i++)
  hash[array[i]] = i;
 return hash;
};
Data.ArrayToHash = function(array, getKeyFunc, getValueFunc) {
 if(!(array instanceof Array)) 
  return { };
 return array.reduce(function(map, element, index) { 
  var key = getKeyFunc(element, index);
  var value = getValueFunc(element, index);
  map[key] = value;
  return map; 
 }, { });
};
Data.Sum = function(array, getValueFunc) {
 if(!(array instanceof Array)) 
  return 0;
 return array.reduce(function(prevValue, item) {
  var value = getValueFunc ? getValueFunc(item) : item;
  if(!ASPx.IsNumber(value))
   value = 0;
  return prevValue + value;
 }, 0);
};
Data.Min = function(array, getValueFunc) { return CalculateArrayMinMax(array, getValueFunc, false); };
Data.Max = function(array, getValueFunc) { return CalculateArrayMinMax(array, getValueFunc, true); };
var CalculateArrayMinMax = function(array, getValueFunc, isMax) {
 if(!(array instanceof Array)) 
  return 0;
 var startValue = isMax ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY;
 return array.reduce(function(prevValue, item) {
  var value = getValueFunc ? getValueFunc(item) : item;
  if(!ASPx.IsNumber(value))
   value = startValue;
  var func = isMax ? Math.max : Math.min;
  return func(value, prevValue);
 }, startValue);
};
var defaultBinarySearchComparer = function(array, index, value) {
 var arrayElement = array[index];
 if(arrayElement == value)
  return 0;
 else
  return arrayElement < value ? -1 : 1;
};
Data.NearestLeftBinarySearchComparer = function(array, index, value) { 
 var arrayElement = array[index];
 var leftPoint = arrayElement < value;
 var lastLeftPoint = leftPoint && index == array.length - 1;
 var nearestLeftPoint = lastLeftPoint || (leftPoint && array[index + 1] >= value);
 if(nearestLeftPoint)
  return 0;
 else
  return arrayElement < value ? -1 : 1;
};
Data.ArrayBinarySearch = function(array, value, binarySearchComparer, startIndex, length) {
 if(!binarySearchComparer)
  binarySearchComparer = defaultBinarySearchComparer;
 if(!ASPx.IsExists(startIndex))
  startIndex = 0;
 if(!ASPx.IsExists(length))
  length = array.length - startIndex;
 var endIndex = (startIndex + length) - 1;
 while(startIndex <= endIndex) {
  var middle = (startIndex + ((endIndex - startIndex) >> 1));
  var compareResult = binarySearchComparer(array, middle, value);
  if(compareResult == 0)
   return middle;
  if(compareResult < 0)
   startIndex = middle + 1;
  else
   endIndex = middle - 1;
 }
 return -(startIndex + 1);
};
Data.ArrayFlatten = function(arrayOfArrays) {
 return [].concat.apply([], arrayOfArrays);
};
Data.GetDistinctArray = function(array) {
 var resultArray = [];
 for(var i = 0; i < array.length; i++) {
  var currentEntry = array[i];
  if(Data.ArrayIndexOf(resultArray, currentEntry) == -1) {
   resultArray.push(currentEntry);
  }
 }
 return resultArray;
};
Data.ForEach = function(arr, callback) {
 if(Array.prototype.forEach) {
  Array.prototype.forEach.call(arr, callback);
 } else {
  for(var i = 0, len = arr.length; i < len; i++) {
   callback(arr[i], i, arr);
  }
 }
};
Data.MergeHashTables = function(target, object) {
 if(!object || typeof (object) == "string")
  return target;
 if(!target)
  target = {};
 for(var key in object)
  if(key && !(key in target))
   target[key] = object[key];
 return target;
};
Data.Range = function(count, start) {
 count = parseInt(count) || 0;
 start = parseInt(start) || 0;
 if(count < 0) count = 0;
 if(start < 0) start = 0;
 return Array.apply(null, Array(count)).map(function(val, i) { return start + i; });
};
ASPx.Data = Data;
var Cookie = { };
Cookie.DelCookie = function(name){
 setCookieInternal(name, "", new Date(1970, 1, 1));
};
Cookie.GetCookie = function(name) {
 name = escape(name);
 var cookies = document.cookie.split(';');
 for(var i = 0; i < cookies.length; i++) {
  var cookie = Str.Trim(cookies[i]);
  if(cookie.indexOf(name + "=") == 0)
   return unescape(cookie.substring(name.length + 1, cookie.length));
  else if(cookie.indexOf(name + ";") == 0 || cookie === name)
   return "";
 }
 return null;
};
Cookie.SetCookie = function(name, value, expirationDate){
 if(!ASPx.IsExists(value)) {
  Cookie.DelCookie(name);
  return;
 }
 if(!ASPx.Ident.IsDate(expirationDate)) {
  expirationDate = new Date();
  expirationDate.setFullYear(expirationDate.getFullYear() + 1);
 }
 setCookieInternal(name, value, expirationDate);
};
function setCookieInternal(name, value, date){
 document.cookie = escape(name) + "=" + escape(value.toString()) + "; expires=" + date.toGMTString() + "; path=/";
}
ASPx.Cookie = Cookie;
ASPx.ImageUtils = {
 GetImageSrc: function (image){
  return image.src;
 },
 SetImageSrc: function(image, src){
  if(isSourceResetRequired())
   image.src = "";
  image.src = src;
 },
 SetSize: function(image, width, height){
  image.style.width = width + "px";
  image.style.height = height + "px";
 },
 GetSize: function(image, isWidth){
  return (isWidth ? image.offsetWidth : image.offsetHeight);
 }
};
var Str = { };
Str.ApplyReplacement = function(text, replecementTable) {
 if(typeof(text) != "string")
  text = text.toString();
 for(var i = 0; i < replecementTable.length; i++) {
  var replacement = replecementTable[i];
  text = text.replace(replacement[0], replacement[1]);
 }
 return text;
};
Str.CompleteReplace = function(text, regexp, newSubStr) {
 if(typeof(text) != "string")
  text = text.toString();
 var textPrev;
 do {
  textPrev = text;
  text = text.replace(regexp, newSubStr);
 } while(text != textPrev);
 return text;
};
Str.EncodeHtml = function(html) {
 return Str.ApplyReplacement(html, [
  [ /&amp;/g,  '&ampx;'  ], [ /&/g, '&amp;'  ],
  [ /&quot;/g, '&quotx;' ], [ /"/g, '&quot;' ],
  [ /&lt;/g,   '&ltx;'   ], [ /</g, '&lt;'   ],
  [ /&gt;/g,   '&gtx;'   ], [ />/g, '&gt;'   ]
 ]);
};
Str.DecodeHtml = function(html) {
 return Str.ApplyReplacement(html, [
  [ /&gt;/g,   '>' ], [ /&gtx;/g,  '&gt;'   ],
  [ /&lt;/g,   '<' ], [ /&ltx;/g,  '&lt;'   ],
  [ /&quot;/g, '"' ], [ /&quotx;/g,'&quot;' ],
  [ /&amp;/g,  '&' ], [ /&ampx;/g, '&amp;'  ]
 ]);
};
Str.DecodeHtmlViaTextArea = function(html) {
 var textArea = document.createElement("TEXTAREA");
 textArea.innerHTML = html;
 return textArea.value;
};
Str.TrimStart = function(str) { 
 return trimInternal(str, true);
};
Str.TrimEnd = function(str) { 
 return trimInternal(str, false, true);
};
Str.Trim = function(str) { 
 return trimInternal(str, true, true); 
};
var whiteSpaces = { 
 0x0009: 1, 0x000a: 1, 0x000b: 1, 0x000c: 1, 0x000d: 1, 0x0020: 1, 0x0085: 1, 
 0x00a0: 1, 0x1680: 1, 0x180e: 1, 0x2000: 1, 0x2001: 1, 0x2002: 1, 0x2003: 1, 
 0x2004: 1, 0x2005: 1, 0x2006: 1, 0x2007: 1, 0x2008: 1, 0x2009: 1, 0x200a: 1, 
 0x200b: 1, 0x2028: 1, 0x2029: 1, 0x202f: 1, 0x205f: 1, 0x3000: 1
};
var caretWidth = 1;
function trimInternal(source, trimStart, trimEnd) {
 var len = source.length;
 if(!len)
  return source;
 if(len < 0xBABA1) { 
  var result = source;
  if(trimStart) {
   result = result.replace(/^\s+/, "");
  }
  if(trimEnd) {
   result = result.replace(/\s+$/, "");
  }
  return result;  
 } else {
  var start = 0;
  if(trimEnd) {   
   while(len > 0 && whiteSpaces[source.charCodeAt(len - 1)]) {
    len--;
   }
  }
  if(trimStart && len > 0) {
   while(start < len && whiteSpaces[source.charCodeAt(start)]) { 
    start++; 
   }   
  }
  return source.substring(start, len);
 }
}
Str.Insert = function(str, subStr, index) { 
 var leftText = str.slice(0, index);
 var rightText = str.slice(index);
 return leftText + subStr + rightText;
};
Str.InsertEx = function(str, subStr, startIndex, endIndex) { 
 var leftText = str.slice(0, startIndex);
 var rightText = str.slice(endIndex);
 return leftText + subStr + rightText;
};
var greekSLFSigmaChar = String.fromCharCode(962);
var greekSLSigmaChar = String.fromCharCode(963);
Str.PrepareStringForFilter = function(s){
 s = s.toLowerCase();
 if(ASPx.Browser.WebKitFamily) {
  return s.replace(new RegExp(greekSLFSigmaChar, "g"), greekSLSigmaChar);
 }
 return s;
};
Str.GetCoincideCharCount = function(text, filter, textMatchingDelegate) {
 var coincideText = ASPx.Str.PrepareStringForFilter(filter);
 var originText = ASPx.Str.PrepareStringForFilter(text);
 while(coincideText != "" && !textMatchingDelegate(originText, coincideText)) {
  coincideText = coincideText.slice(0, -1);
 }
 return coincideText.length;
};
ASPx.Str = Str;
var Xml = { };
Xml.Parse = function(xmlStr) {
 if(window.DOMParser) {
  var parser = new DOMParser();
  return parser.parseFromString(xmlStr, "text/xml");
 }
 else if(window.ActiveXObject) {
  var xmlDoc = new window.ActiveXObject("Microsoft.XMLDOM");
  if(xmlDoc) {
   xmlDoc.async = false;
   xmlDoc.loadXML(xmlStr);
   return xmlDoc;
  }
 }
 return null;
};
ASPx.Xml = Xml;
ASPx.Key = {
 F1     : 112,
 F2     : 113,
 F3     : 114,
 F4     : 115,
 F5     : 116,
 F6     : 117,
 F7     : 118,
 F8     : 119,
 F9     : 120,
 F10    : 121,
 F11    : 122,
 F12    : 123,
 Ctrl   : 17,
 Shift  : 16,
 Alt    : 18,
 Enter  : 13,
 Home   : 36,
 End    : 35,
 Left   : 37,
 Right  : 39,
 Up     : 38,
 Down   : 40,
 PageUp    : 33,
 PageDown  : 34,
 Esc    : 27,
 Space  : 32,
 Tab    : 9,
 Backspace : 8,
 Delete    : 46,
 Insert    : 45,
 ContextMenu  : 93,
 Windows   : 91,
 Decimal   : 110
};
ASPx.KeyCode = {
 Backspace : 8,
 Tab    : 9,
 Enter  : 13,
 Pause  : 19,
 CapsLock  : 20,
 Esc    : 27,
 Space  : 32,
 PageUp    : 33,
 PageDown  : 34,
 End    : 35,
 Home   : 36,
 Left   : 37,
 Up     : 38,
 Right  : 39,
 Down   : 40,
 Insert    : 45,
 Delete    : 46,
 Key_0  : 48,
 Key_1  : 49,
 Key_2  : 50,
 Key_3  : 51,
 Key_4  : 52,
 Key_5  : 53,
 Key_6  : 54,
 Key_7  : 55,
 Key_8  : 56,
 Key_9  : 57,
 Key_a  : 65,
 Key_b  : 66,
 Key_c  : 67,
 Key_d  : 68,
 Key_e  : 69,
 Key_f  : 70,
 Key_g  : 71,
 Key_h  : 72,
 Key_i  : 73,
 Key_j  : 74,
 Key_k  : 75,
 Key_l  : 76,
 Key_m  : 77,
 Key_n  : 78,
 Key_o  : 79,
 Key_p  : 80,
 Key_q  : 81,
 Key_r  : 82,
 Key_s  : 83,
 Key_t  : 84,
 Key_u  : 85,
 Key_v  : 86,
 Key_w  : 87,
 Key_x  : 88,
 Key_y  : 89,
 Key_z  : 90,
 Windows   : 91,
 ContextMenu  : 93,
 Numpad_0  : 96,
 Numpad_1  : 97,
 Numpad_2  : 98,
 Numpad_3  : 99,
 Numpad_4  : 100,
 Numpad_5  : 101,
 Numpad_6  : 102,
 Numpad_7  : 103,
 Numpad_8  : 104,
 Numpad_9  : 105,
 Multiply  : 106,
 Add    : 107,
 Subtract  : 109,
 Decimal   : 110,
 Divide    : 111,
 F1     : 112,
 F2     : 113,
 F3     : 114,
 F4     : 115,
 F5     : 116,
 F6     : 117,
 F7     : 118,
 F8     : 119,
 F9     : 120,
 F10    : 121,
 F11    : 122,
 F12    : 123,
 NumLock   : 144,
 ScrollLock   : 145,
 Semicolon : 186,
 Equals    : 187,
 Comma  : 188,
 Dash   : 189,
 Period    : 190,
 ForwardSlash : 191,
 GraveAccent  : 192,
 OpenBracket  : 219,
 BackSlash : 220,
 CloseBracket : 221,
 SingleQuote  : 222
};
ASPx.ScrollBarMode = { Hidden: 0, Visible: 1, Auto: 2 };
ASPx.ColumnResizeMode = { None: 0, Control: 1, NextColumn: 2 };
var Selection = { };
Selection.Set = function(input, startPos, endPos, scrollToSelection) {
 if(!ASPx.IsExistsElement(input))
  return;
 if(Browser.VirtualKeyboardSupported && (ASPx.GetActiveElement() !== input || ASPx.VirtualKeyboardUI.getInputNativeFocusLocked()))
  return;
 var textLen = input.value.length;
 startPos = ASPx.GetDefinedValue(startPos, 0);
 endPos = ASPx.GetDefinedValue(endPos, textLen);
 if(startPos < 0)
  startPos = 0;
 if(endPos < 0 || endPos > textLen)
  endPos = textLen;
 if(startPos > endPos)
  startPos = endPos;
 var makeReadOnly = false;
 if(Browser.WebKitFamily && input.readOnly) {
  input.readOnly = false;
  makeReadOnly = true;
 }
 try {
  if(Browser.Firefox && Browser.Version >= 8) 
   input.setSelectionRange(startPos, endPos, "backward");
  else if(Browser.IE && input.createTextRange) {
   var range = input.createTextRange();
   range.collapse(true);
   range.moveStart("character", startPos);
   range.moveEnd("character", endPos - startPos);
   range.select();
  } else {
   forceScrollToSelectionRange(input, startPos, endPos);
   input.setSelectionRange(startPos, endPos);
  }
  if(Browser.Opera || Browser.Firefox || Browser.Chrome) 
   input.focus();
 } catch(e) { 
 }
 if(scrollToSelection && input.tagName == 'TEXTAREA') {
  var scrollHeight = input.scrollHeight;
  var approxCaretPos = startPos;
  var scrollTop = Math.max(Math.round(approxCaretPos * scrollHeight / textLen  - input.clientHeight / 2), 0);
  input.scrollTop = scrollTop;
 }
 if(makeReadOnly)
  input.readOnly = true;
};
var getTextWidthBeforePos = function(input, pos) {
 return ASPx.GetSizeOfText(input.value.toString().substr(0, pos), ASPx.GetCurrentStyle(input)).width;
};
var forceScrollToSelectionRange = function(input, startPos, endPos) {
 var widthBeforeStartPos = getTextWidthBeforePos(input, startPos) - caretWidth;
 var widthBeforeEndPos = getTextWidthBeforePos(input, endPos) + caretWidth;
 var inputRawWidth = input.offsetWidth - ASPx.GetLeftRightBordersAndPaddingsSummaryValue(input);
 if(input.scrollLeft < widthBeforeEndPos - inputRawWidth)
  input.scrollLeft = widthBeforeEndPos - inputRawWidth;
 else if(input.scrollLeft > widthBeforeStartPos)
  input.scrollLeft = widthBeforeStartPos;
};
Selection.GetInfo = function(input) {
 var start, end;
 if(Browser.IE && Browser.Version < 9) {
  var range = document.selection.createRange();
  var rangeCopy = range.duplicate();
  range.move('character', -input.value.length);
  range.setEndPoint('EndToStart', rangeCopy);
  start = range.text.length;
  end = start + rangeCopy.text.length;
 } else {
  try {
   start = input.selectionStart;
   end = input.selectionEnd;
  } catch (e) {
  }
 }
 return { startPos: start, endPos: end };
};
Selection.GetExtInfo = function(input) {
 var start = 0, end = 0, textLen = 0;
 if(Browser.IE && Browser.Version < 9) {
  var normalizedValue;
  var range, textInputRange, textInputEndRange;
  range = document.selection.createRange();
  if(range && range.parentElement() == input) {
   textLen = input.value.length;
   normalizedValue = input.value.replace(/\r\n/g, "\n");
   textInputRange = input.createTextRange();
   textInputRange.moveToBookmark(range.getBookmark());
   textInputEndRange = input.createTextRange();
   textInputEndRange.collapse(false);
   if(textInputRange.compareEndPoints("StartToEnd", textInputEndRange) > -1) {
    start = textLen;
    end = textLen;
   } else {
    start = normalizedValue.slice(0, start).split("\n").length - textInputRange.moveStart("character", -textLen) -1;
    if(textInputRange.compareEndPoints("EndToEnd", textInputEndRange) > -1)
     end = textLen;
    else
     end = normalizedValue.slice(0, end).split("\n").length - textInputRange.moveEnd("character", -textLen) - 1;    
   }
  }
  return {startPos: start, endPos: end};
 }
 try {
  start = input.selectionStart;
  end = input.selectionEnd;
 } catch (e) {
 }
 return {startPos: start, endPos: end}; 
};
Selection.SetCaretPosition = function(input, caretPos) {
 if(typeof caretPos === "undefined" || caretPos < 0)
  caretPos = input.value.length;
 Selection.Set(input, caretPos, caretPos, true);
};
Selection.GetCaretPosition = function(element, isDialogMode) {
 var pos = 0;
 if("selectionStart" in element) {
  pos = element.selectionStart;
 } else if("selection" in document) {
  element.focus();
  var sel = document.selection.createRange(),
   selLength = document.selection.createRange().text.length;
  sel.moveStart("character", -element.value.length);
  pos = sel.text.length - selLength;
 }
 if(isDialogMode && !pos) {
  pos = element.value.length - 1;
 }
 return pos;
};
Selection.Clear = function() {
 try {
  if(window.getSelection) {
   window.getSelection().removeAllRanges();
  }
  else if(document.selection) {
   if(document.selection.empty)
    document.selection.empty();
   else if(document.selection.clear)
    document.selection.clear();
  }
 } catch(e) {
 }
};
Selection.ClearOnMouseMove = function(evt) {
 if(!Browser.IE || (evt.button != 0)) 
  Selection.Clear();
};
Selection.SetElementSelectionEnabled = function(element, value) {
 var userSelectValue = value ? "" : "none";
 var func = value ? Evt.DetachEventFromElement : Evt.AttachEventToElement;
 if(Browser.Firefox)
  element.style.MozUserSelect = userSelectValue;
 else if(Browser.WebKitFamily)
  element.style.webkitUserSelect = userSelectValue;
 else if(Browser.Opera)
  func(element, "mousemove", Selection.Clear);
 else {
  func(element, "selectstart", ASPx.FalseFunction);
  func(element, "mousemove", Selection.Clear);
 }
};
Selection.SetElementAsUnselectable = function(element, isWithChild, recursive) {
 if(element && element.nodeType == 1) {
  element.unselectable = "on";
  if(Browser.NetscapeFamily)
   element.onmousedown = ASPx.FalseFunction;
  if((Browser.IE && Browser.Version >= 9) || Browser.WebKitFamily)
   Evt.AttachEventToElement(element, "mousedown", Evt.PreventEventAndBubble);
  if(isWithChild === true){
   for(var j = 0; j < element.childNodes.length; j ++)
    Selection.SetElementAsUnselectable(element.childNodes[j], (!!recursive ? true : false), (!!recursive));
  }
 }
};
Selection.AreEqual = function(selection1, selection2) {
 return selection1.startPos === selection2.startPos && selection1.endPos === selection2.endPos;
};
ASPx.Selection = Selection;
var MouseScroller = { };
MouseScroller.MinimumOffset = 10;
MouseScroller.Create = function(getElement, getScrollXElement, getScrollYElement, needPreventScrolling, vertRecursive, onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed) {
 var element = getElement();
 if(!element) 
  return;
 if(!element.dxMouseScroller)
  element.dxMouseScroller = new MouseScroller.Extender(getElement, getScrollXElement, getScrollYElement, needPreventScrolling, vertRecursive, onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed);
 return element.dxMouseScroller;
};
MouseScroller.Extender = function(getElement, getScrollXElement, getScrollYElement, needPreventScrolling, vertRecursive, onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed) {
 this.getElement = getElement;
 this.getScrollXElement = getScrollXElement;
 this.getScrollYElement = getScrollYElement;
 this.needPreventScrolling = needPreventScrolling;
 this.vertRecursive = !!vertRecursive;
 this.createHandlers(onMouseDown || function() { }, onMouseMove || function() { }, onMouseUp || function() { }, onMouseUpMissed || function() { });
 this.update();
};
MouseScroller.Extender.prototype = {
 update: function() {
  if(this.element)
   Evt.DetachEventFromElement(this.element, ASPx.TouchUIHelper.touchMouseDownEventName, this.mouseDownHandler);
  this.element = this.getElement();
  Evt.AttachEventToElement(this.element, ASPx.TouchUIHelper.touchMouseDownEventName, this.mouseDownHandler);  
  Evt.AttachEventToElement(this.element, "click", this.mouseClickHandler);   
  if(Browser.MSTouchUI && this.element.className.indexOf(ASPx.TouchUIHelper.msTouchDraggableClassName) < 0)
   this.element.className += " " + ASPx.TouchUIHelper.msTouchDraggableClassName;
  this.scrollXElement = this.getScrollXElement();
  this.scrollYElement = this.getScrollYElement();
 },
 createHandlers: function(onMouseDown, onMouseMove, onMouseUp, onMouseUpMissed) {
  var mouseDownCounter = 0;
  this.onMouseDown = onMouseDown;
  this.onMouseMove = onMouseMove;
  this.onMouseUp = onMouseUp;  
  this.mouseDownHandler = function(e) {
   if(mouseDownCounter++ > 0) {
    this.finishScrolling();
    onMouseUpMissed();
   }
   var eventSource = Evt.GetEventSource(e);
   var requirePreventCustonScroll = ASPx.IsExists(ASPx.TouchUIHelper.RequirePreventCustomScroll) && ASPx.TouchUIHelper.RequirePreventCustomScroll(eventSource, this.element);
   if(requirePreventCustonScroll || this.needPreventScrolling && this.needPreventScrolling(eventSource))
    return;
   this.scrollableTreeLine = this.GetScrollableElements();
   this.firstX = this.prevX = Evt.GetEventX(e);
   this.firstY = this.prevY = Evt.GetEventY(e);
   Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseMoveEventName, this.mouseMoveHandler);
   Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseUpEventName, this.mouseUpHandler);
   this.onMouseDown(e);
  }.aspxBind(this);
  this.mouseMoveHandler = function(e) {
   if(ASPx.TouchUIHelper.isGesture)
    return;
   var x = Evt.GetEventX(e);
   var y = Evt.GetEventY(e);
   var xDiff = this.prevX - x;
   var yDiff = this.prevY - y;
   if(this.vertRecursive) {
    var isTopDirection = yDiff < 0;
    this.scrollYElement = this.GetElementForVertScrolling(isTopDirection, this.prevIsTopDirection, this.scrollYElement);
    this.prevIsTopDirection = isTopDirection;
   }
   if(this.scrollXElement && xDiff != 0)
    this.scrollXElement.scrollLeft += xDiff;
   if(this.scrollYElement && yDiff != 0) {
    this.scrollYElement.scrollTop += yDiff;
    var isOuterScrollableElement = this.scrollableTreeLine[this.scrollableTreeLine.length - 1] == this.scrollYElement;
    if(isOuterScrollableElement)
     y += yDiff;
   }
   this.prevX = x;
   this.prevY = y;
   e.preventDefault();
   this.onMouseMove(e);
  }.aspxBind(this);
  this.mouseUpHandler = function(e) {
   this.finishScrolling();
   this.onMouseUp(e);
  }.aspxBind(this);
  this.mouseClickHandler = function(e){
   if(this.needPreventScrolling && this.needPreventScrolling(Evt.GetEventSource(e)))
    return;
   var xDiff = this.firstX - Evt.GetEventX(e);
   var yDiff = this.firstY - Evt.GetEventY(e);
   if(xDiff > MouseScroller.MinimumOffset || yDiff > MouseScroller.MinimumOffset)
    return Evt.PreventEventAndBubble(e);
  }.aspxBind(this);
  this.finishScrolling = function() {
   Evt.DetachEventFromDocument(ASPx.TouchUIHelper.touchMouseMoveEventName, this.mouseMoveHandler);
   Evt.DetachEventFromDocument(ASPx.TouchUIHelper.touchMouseUpEventName, this.mouseUpHandler);
   this.scrollableTreeLine = [];
   this.prevIsTopDirection = null;
   mouseDownCounter--;
  };
 },
 GetScrollableElements: function() {
  if(!this.vertRecursive) return [ ];
  var outerScrollableElementTag = ASPx.Browser.IE ? "HTML" : "BODY";
  return ASPx.GetElementTreeLine(this.element, null, function(el) { return el == document; })
   .filter(function(el) { return ASPx.IsScrollableElement(el, false, true) || el.tagName == outerScrollableElementTag; }.bind(this));
 },
 GetElementForVertScrolling: function(currentIsTop, prevIsTop, prevElement) {
  if(prevElement && currentIsTop === prevIsTop && this.GetVertScrollExcess(prevElement, currentIsTop) > 0)
   return prevElement;
  for(var i = 0; i < this.scrollableTreeLine.length; i++) {
   var element = this.scrollableTreeLine[i];
   var excess = this.GetVertScrollExcess(element, currentIsTop);
   if(excess > 0)
    return element;
  }
  return null;
 },
 GetVertScrollExcess: function(element, isTop) {
  if(isTop)
   return element.scrollTop;
  var isBodyElement = element.tagName == "BODY";
  var clientHeight = isBodyElement ? ASPx.GetDocumentClientHeight() : element.clientHeight;
  return element.scrollHeight - clientHeight - element.scrollTop;
 }
};
ASPx.MouseScroller = MouseScroller;
var Evt = { };
Evt.GetEvent = function(evt){
 return (typeof(event) != "undefined" && event != null && Browser.IE) ? event : evt; 
};
Evt.IsEventPrevented = function(evt) {
 return evt.defaultPrevented || evt.returnValue === false;
};
Evt.PreventEvent = function(evt){
 if(evt.preventDefault)
  evt.preventDefault();
 else
  evt.returnValue = false;
 return false;
};
Evt.PreventEventAndBubble = function(evt){
 Evt.PreventEvent(evt);
 if(evt.stopPropagation)
  evt.stopPropagation();
 evt.cancelBubble = true;
 return false;
};
Evt.CancelBubble = function(evt){
 evt.cancelBubble = true;
 return false;
};
Evt.PreventImageDragging = function(image) {
 if(image)
  image.ondragstart = function() { return false; };
};
Evt.PreventDragStart = function(evt) {
 evt = Evt.GetEvent(evt);
 var element = Evt.GetEventSource(evt);
 if(element.releaseCapture)
  element.releaseCapture(); 
 return false;
};
Evt.PreventElementDrag = function(element) {
 if(Browser.IE)
  Evt.AttachEventToElement(element, "dragstart", Evt.PreventEvent);
 else
  Evt.AttachEventToElement(element, "mousedown", Evt.PreventEvent);
};
Evt.PreventElementDragAndSelect = function(element, skipMouseMove, skipIESelect){
 if(Browser.WebKitFamily)
  Evt.AttachEventToElement(element, "selectstart", Evt.PreventEventAndBubble);
 if(Browser.IE){
  if(!skipIESelect)
   Evt.AttachEventToElement(element, "selectstart", ASPx.FalseFunction);
  if(!skipMouseMove)
   Evt.AttachEventToElement(element, "mousemove", Selection.ClearOnMouseMove);
  Evt.AttachEventToElement(element, "dragstart", Evt.PreventDragStart);
 }
};
Evt.GetEventSource = function(evt){
 if(!ASPx.IsExists(evt)) return null; 
 return evt.srcElement ? evt.srcElement : evt.target;
};
Evt.GetKeyCode = function(srcEvt) {
 return Browser.NetscapeFamily || Browser.Opera ? srcEvt.which : srcEvt.keyCode;
};
function clientEventRequiresDocScrollCorrection() {
 var isSafariVerLess3 = Browser.Safari && Browser.Version < 3,
  isMacOSMobileVerLess51 = Browser.MacOSMobilePlatform && Browser.Version < 5.1;
 return Browser.AndroidDefaultBrowser || Browser.AndroidChromeBrowser || !(isSafariVerLess3 || isMacOSMobileVerLess51);
}
Evt.GetEventX = function(evt){
 if(ASPx.TouchUIHelper.isTouchEvent(evt))
  return ASPx.TouchUIHelper.getEventX(evt);
 return evt.clientX + (clientEventRequiresDocScrollCorrection() ? ASPx.GetDocumentScrollLeft() : 0);
};
Evt.GetEventY = function(evt){
 if(ASPx.TouchUIHelper.isTouchEvent(evt))
  return ASPx.TouchUIHelper.getEventY(evt);
 return evt.clientY + (clientEventRequiresDocScrollCorrection() ? ASPx.GetDocumentScrollTop() : 0 );
};
Evt.IsLeftButtonPressed = function(evt) {
 if(ASPx.TouchUIHelper.isTouchEvent(evt))
  return true;
 evt = Evt.GetEvent(evt);
 if(!evt) return false;
 if(Browser.IE && Browser.Version < 11) {
  if(Browser.MSTouchUI)
   return true;
  return evt.button % 2 == 1; 
 } else if(Browser.WebKitFamily) {
  if(evt.type === "pointermove")
   return evt.buttons === 1;
  return evt.which == 1;
 } else if(Browser.NetscapeFamily || Browser.Edge || (Browser.IE && Browser.Version >= 11)) {
  if(evt.type === ASPx.TouchUIHelper.touchMouseMoveEventName)
   return evt.buttons === 1;
  return evt.which == 1;
 } else if(Browser.Opera)
  return evt.button == 0;
 return true;
};
Evt.IsRightButtonPressed = function(evt){
 evt = Evt.GetEvent(evt);
 if(!ASPx.IsExists(evt)) return false;
 if(Browser.IE || Browser.Edge) {
  if(evt.type === "pointermove")
   return evt.buttons === 2;
  return evt.button == 2;
 }
 else if(Browser.NetscapeFamily || Browser.WebKitFamily)
  return evt.which == 3;
 else if (Browser.Opera)
  return evt.button == 1;
 return true;
};
Evt.GetWheelDelta = function(evt) {
 var ret;
 if(Browser.NetscapeFamily && Browser.MajorVersion < 17)
  ret = -evt.detail;
 else if(Browser.Safari)
  ret = evt.wheelDelta;
 else
  ret = -evt.deltaY;
 if(Browser.Opera && Browser.Version < 9)
  ret = -ret;
 return ret;
};
Evt.IsWheelEventWithDirection = function(evt) {
 return ASPx.Data.ArrayContains(["wheel", "mousewheel"], evt.type);
};
Evt.GetWheelDeltaX = function(evt) {
 if(evt.type === "wheel")
  return -evt.deltaX;
 if(evt.type === "mousewheel")
  return evt.wheelDeltaX;
};
Evt.GetWheelDeltaY = function(evt) {
 if(evt.type === "wheel")
  return -evt.deltaY;
 if(evt.type === "mousewheel")
  return evt.wheelDeltaY;
};
Evt.AttachEventToElement = function(element, eventName, func, onlyBubbling) {
 if(element.addEventListener)
  element.addEventListener(eventName, func, !onlyBubbling);
 else
  element.attachEvent("on" + eventName, func);
};
Evt.DetachEventFromElement = function(element, eventName, func) {
 if(element.removeEventListener)
  element.removeEventListener(eventName, func, true);
 else
  element.detachEvent("on" + eventName, func);
};
Evt.AttachEventToDocument = function(eventName, func) {
 var attachingAllowed = ASPx.TouchUIHelper.onEventAttachingToDocument(eventName, func);
 if(attachingAllowed)
  Evt.AttachEventToDocumentCore(eventName, func);
};
Evt.AttachEventToDocumentCore = function(eventName, func) {
 Evt.AttachEventToElement(document, eventName, func);
};
Evt.DetachEventFromDocument = function(eventName, func) {
 Evt.DetachEventFromDocumentCore(eventName, func);
 ASPx.TouchUIHelper.onEventDettachedFromDocument(eventName, func);
};
Evt.DetachEventFromDocumentCore = function(eventName, func){
 Evt.DetachEventFromElement(document, eventName, func);
};
Evt.GetMouseWheelEventName = function() {
 if(Browser.Safari)
  return "mousewheel";
 if(Browser.NetscapeFamily && Browser.MajorVersion < 17)
  return "DOMMouseScroll";
 return "wheel";
};
Evt.AttachMouseEnterToElement = function (element, onMouseOverHandler, onMouseOutHandler) {
 Evt.AttachEventToElement(element, ASPx.TouchUIHelper.pointerEnabled ? ASPx.TouchUIHelper.pointerOverEventName : "mouseover", function (evt) { mouseEnterHandler(evt, element, onMouseOverHandler, onMouseOutHandler); });
 Evt.AttachEventToElement(element, ASPx.TouchUIHelper.pointerEnabled ? ASPx.TouchUIHelper.pointerOutEventName : "mouseout", function (evt) { mouseEnterHandler(evt, element, onMouseOverHandler, onMouseOutHandler); });
};
Evt.GetEventRelatedTarget = function(evt, isMouseOverEvent) {
 return evt.relatedTarget || (isMouseOverEvent ? evt.srcElement : evt.toElement);
};
function mouseEnterHandler(evt, element, onMouseOverHandler, onMouseOutHandler) {
 var isMouseOverExecuted = !!element.dxMouseOverExecuted;
 var isMouseOverEvent = (evt.type == "mouseover" || evt.type == ASPx.TouchUIHelper.pointerOverEventName);
 if(isMouseOverEvent && isMouseOverExecuted || !isMouseOverEvent && !isMouseOverExecuted)
  return;
 var source = Evt.GetEventRelatedTarget(evt, isMouseOverEvent);
 if(!ASPx.GetIsParent(element, source)) {
  element.dxMouseOverExecuted = isMouseOverEvent;
  if(isMouseOverEvent)
   onMouseOverHandler(element);
  else
   onMouseOutHandler(element);
 }
 else if(isMouseOverEvent && !isMouseOverExecuted) {
  element.dxMouseOverExecuted = true;
  onMouseOverHandler(element);
 }
}
Evt.DispatchEvent = function(target, eventName, canBubble, cancellable) {
 var event;
 if(Browser.IE && Browser.Version < 9) {
  eventName = "on" + eventName;
  if(eventName in target) {
   event = document.createEventObject();
   target.fireEvent("on" + eventName, event);
  }
 } else {
  event = document.createEvent("Event");
  event.initEvent(eventName, canBubble || false, cancellable || false);
  target.dispatchEvent(event);
 }
};
Evt.EmulateDocumentOnMouseDown = function(evt) {
 Evt.EmulateOnMouseDown(document, evt);
};
Evt.EmulateOnMouseDown = function(element, evt) {
 if(Browser.IE && Browser.Version < 9)
  element.fireEvent("onmousedown", evt);
 else if(!Browser.WebKitFamily){
  var emulatedEvt = document.createEvent("MouseEvents");
  emulatedEvt.initMouseEvent("mousedown", true, true, window, 0, evt.screenX, evt.screenY, 
   evt.clientX, evt.clientY, evt.ctrlKey, evt.altKey, evt.shiftKey, false, 0, null);
  element.dispatchEvent(emulatedEvt);
 }
};
Evt.EmulateOnMouseEvent = function (type, element, evt) {
 evt.type = type;
 var emulatedEvt = document.createEvent("MouseEvents");
 emulatedEvt.initMouseEvent(type, true, true, window, 0, evt.screenX, evt.screenY,
  evt.clientX, evt.clientY, evt.ctrlKey, evt.altKey, evt.shiftKey, false, 0, null);
 emulatedEvt.target = element;
 element.dispatchEvent(emulatedEvt);
};
Evt.EmulateMouseClick = function (element, evt) {
 var x = element.offsetWidth / 2;
 var y = element.offsetHeight / 2;
 if (!evt)
  evt = {
   bubbles: true,
   cancelable: true,
   view: window,
   detail: 1,
   screenX: 0,
   screenY: 0,
   clientX: x,
   clientY: y,
   ctrlKey: false,
   altKey: false,
   shiftKey: false,
   metaKey: false,
   button: 0,
   relatedTarget: null
  };
 Evt.EmulateOnMouseEvent("mousedown", element, evt);
 Evt.EmulateOnMouseEvent("mouseup", element, evt);
 Evt.EmulateOnMouseEvent("click", element, evt);
};
Evt.DoElementClick = function(element) {
 try{
  element.click();
 }
 catch(e){ 
 }
};
Evt.IsActionKeyPressed = function(evt) {
 return evt.keyCode === ASPx.Key.Space ||
     evt.keyCode === ASPx.Key.Enter ||
    (evt.keyCode === ASPx.Key.Down && evt.altKey);
};
Evt.InvokeMouseClickByKeyDown = function(evt, handler) {
 if(Evt.IsActionKeyPressed(evt)) {
  ASPx.Evt.PreventEvent(evt); 
  if(!handler)
   ASPx.Evt.GetEventSource(evt).onclick();
  else
   handler(evt);
 }
};
ASPx.Evt = Evt;
var Attr = { };
Attr.GetAttribute = function(obj, attrName){
 if(obj.getAttribute)
  return obj.getAttribute(attrName);
 else if(obj.getPropertyValue)
  return obj.getPropertyValue(attrName);
 return null;
};
Attr.SetAttribute = function(obj, attrName, value){
 if(obj.setAttribute) {
  if(isSourceResetRequired() && attrName.toLowerCase() === "src") 
   obj.setAttribute(attrName, "");
  obj.setAttribute(attrName, value);
 } else if(obj.setProperty)
  obj.setProperty(attrName, value, "");
};
Attr.RemoveAttribute = function(obj, attrName){
 if(obj.removeAttribute)
  obj.removeAttribute(attrName);
 else if(obj.removeProperty)
  obj.removeProperty(attrName);
};
Attr.IsExistsAttribute = function(obj, attrName){
 var value = Attr.GetAttribute(obj, attrName);
 return (value != null) && (value !== "");
};
Attr.SetOrRemoveAttribute = function(obj, attrName, value) {
 if(!value)
  Attr.RemoveAttribute(obj, attrName);
 else
  Attr.SetAttribute(obj, attrName, value);
};
Attr.SaveAttribute = function(obj, attrName, savedObj, savedAttrName){
 if(!Attr.IsExistsAttribute(savedObj, savedAttrName)){
  var oldValue = Attr.IsExistsAttribute(obj, attrName) ? Attr.GetAttribute(obj, attrName) : ASPx.EmptyObject;
  Attr.SetAttribute(savedObj, savedAttrName, oldValue);
 }
};
Attr.SaveStyleAttribute = function(obj, attrName){
 Attr.SaveAttribute(obj.style, attrName, obj, "saved" + attrName);
};
Attr.ChangeAttributeExtended = function(obj, attrName, savedObj, savedAttrName, newValue){
 Attr.SaveAttribute(obj, attrName, savedObj, savedAttrName);
 Attr.SetAttribute(obj, attrName, newValue);
};
Attr.ChangeAttribute = function(obj, attrName, newValue){
 Attr.ChangeAttributeExtended(obj, attrName, obj, "saved" + attrName, newValue);
};
Attr.ChangeStyleAttribute = function(obj, attrName, newValue){
 Attr.ChangeAttributeExtended(obj.style, attrName, obj, "saved" + attrName, newValue);
};
Attr.ResetAttributeExtended = function(obj, attrName, savedObj, savedAttrName){
 Attr.SaveAttribute(obj, attrName, savedObj, savedAttrName);
 Attr.SetAttribute(obj, attrName, "");
 Attr.RemoveAttribute(obj, attrName);
};
Attr.ResetAttribute = function(obj, attrName){
 Attr.ResetAttributeExtended(obj, attrName, obj, "saved" + attrName);
};
Attr.ResetStyleAttribute = function(obj, attrName){
 Attr.ResetAttributeExtended(obj.style, attrName, obj, "saved" + attrName);
};
Attr.RestoreAttributeExtended = function(obj, attrName, savedObj, savedAttrName){
 if(Attr.IsExistsAttribute(savedObj, savedAttrName)){
  var oldValue = Attr.GetAttribute(savedObj, savedAttrName);
  if(oldValue != ASPx.EmptyObject)
   Attr.SetAttribute(obj, attrName, oldValue);
  else
   Attr.RemoveAttribute(obj, attrName);
  Attr.RemoveAttribute(savedObj, savedAttrName);
  return true;
 }
 return false;
};
Attr.RestoreAttribute = function(obj, attrName){
 return Attr.RestoreAttributeExtended(obj, attrName, obj, "saved" + attrName);
};
Attr.RestoreStyleAttribute = function(obj, attrName){
 return Attr.RestoreAttributeExtended(obj.style, attrName, obj, "saved" + attrName);
};
Attr.CopyAllAttributes = function(sourceElem, destElement) {
 var attrs = sourceElem.attributes;
 for(var n = 0; n < attrs.length; n++) {
  var attr = attrs[n];
  if(attr.specified) {
   var attrName = attr.nodeName;
   var attrValue = sourceElem.getAttribute(attrName, 2);
   if(attrValue == null)
    attrValue = attr.nodeValue;
   destElement.setAttribute(attrName, attrValue, 0); 
  }
 }
 if(sourceElem.style.cssText !== '')
  destElement.style.cssText = sourceElem.style.cssText;
};
Attr.RemoveAllAttributes = function(element, excludedAttributes) {
 var excludedAttributesHashTable = {};
 if(excludedAttributes)
  excludedAttributesHashTable = Data.CreateHashTableFromArray(excludedAttributes);
 if(element.attributes) {
  var attrArray = element.attributes;
  for(var i = 0; i < attrArray.length; i++) {
   var attrName = attrArray[i].name;
   if(!ASPx.IsExists(excludedAttributesHashTable[attrName.toLowerCase()])) {
    try {
     attrArray.removeNamedItem(attrName);
    } catch (e) { }
   }
  }
 }
};
Attr.RemoveStyleAttribute = function(element, attrName) {
 if(element.style) {
  if(Browser.Firefox && element.style[attrName]) 
   element.style[attrName] = "";
  if(element.style.removeAttribute && element.style.removeAttribute != "")
   element.style.removeAttribute(attrName);
  else if(element.style.removeProperty && element.style.removeProperty != "")
   element.style.removeProperty(attrName);
 }
};
Attr.RemoveAllStyles = function(element) {
 if(element.style) {
  for(var key in element.style)
   Attr.RemoveStyleAttribute(element, key);
    Attr.RemoveAttribute(element, "style");
 }
};
Attr.GetTabIndexAttributeName = function(){
 return Browser.IE  ? "tabIndex" : "tabindex";
};
Attr.ChangeTabIndexAttribute = function(element){
 var attribute = Attr.GetTabIndexAttributeName(); 
 if(Attr.GetAttribute(element, attribute) != -1)
    Attr.ChangeAttribute(element, attribute, -1);
};
Attr.SaveTabIndexAttributeAndReset = function(element) {
 var attribute = Attr.GetTabIndexAttributeName();
 Attr.SaveAttribute(element, attribute, element, "saved" + attribute);
 Attr.SetAttribute(element, attribute, -1);
};
Attr.RestoreTabIndexAttribute = function(element){
 var attribute = Attr.GetTabIndexAttributeName();
 if(Attr.IsExistsAttribute(element, attribute)) {
  if(Attr.GetAttribute(element, attribute) == -1) {
   if(Attr.IsExistsAttribute(element, "saved" + attribute)){
    var oldValue = Attr.GetAttribute(element, "saved" + attribute);
    if(oldValue != ASPx.EmptyObject)
     Attr.SetAttribute(element, attribute, oldValue);
    else {
     if(Browser.WebKitFamily) 
      Attr.SetAttribute(element, attribute, 0); 
     Attr.RemoveAttribute(element, attribute);   
    }
    Attr.RemoveAttribute(element, "saved" + attribute); 
   }
  }
 }
};
Attr.ChangeAttributesMethod = function(enabled){
 return enabled ? Attr.RestoreAttribute : Attr.ResetAttribute;
};
Attr.InitiallyChangeAttributesMethod = function(enabled){
 return enabled ? Attr.ChangeAttribute : Attr.ResetAttribute;
};
Attr.ChangeStyleAttributesMethod = function(enabled){
 return enabled ? Attr.RestoreStyleAttribute : Attr.ResetStyleAttribute;
};
Attr.InitiallyChangeStyleAttributesMethod = function(enabled){
 return enabled ? Attr.ChangeStyleAttribute : Attr.ResetStyleAttribute;
};
Attr.ChangeEventsMethod = function(enabled){
 return enabled ? Evt.AttachEventToElement : Evt.DetachEventFromElement;
};
Attr.ChangeDocumentEventsMethod = function(enabled){
 return enabled ? Evt.AttachEventToDocument : Evt.DetachEventFromDocument;
};
Attr.ChangeCellSpanCount = function(cell, value, isColumnSpan) {
 if(!cell) return;
 var propertyKey = isColumnSpan ? "colSpan" : "rowSpan";
 var prevValue = cell[propertyKey];
 if(value > 1)
  cell[propertyKey] = value;
 else if(prevValue !== 1)
  Attr.RemoveAttribute(cell, propertyKey);
};
function isSourceResetRequired() {
 return Browser.IE && Browser.MajorVersion >= 11;
}
ASPx.Attr = Attr;
var Aria = {
 atomic: "aria-atomic",
 checked: "aria-checked",
 descendant: "aria-activedescendant",
 described: "aria-describedby",
 disabled: "aria-disabled",
 expanded: "aria-expanded",
 haspopup: "aria-haspopup",
 invalid: "aria-invalid",
 label: "aria-label",
 labelled: "aria-labelledby",
 level: "aria-level",
 owns: "aria-owns",
 posinset: "aria-posinset",
 role: "role",
 selected: "aria-selected",
 setsize: "aria-setsize",
 valuemax: "aria-valuemax",
 valuemin: "aria-valuemin",
 valuenow: "aria-valuenow"
};
Aria.SetOrRemoveDescendant = function(obj, value) {
 ASPx.Attr.SetOrRemoveAttribute(obj, Aria.descendant, value);
};
Aria.SetOrRemoveLabel = function(obj, value) {
 ASPx.Attr.SetOrRemoveAttribute(obj, Aria.label, value);
};
Aria.AppendLabel = function(obj, value, checkExists) {
 var currentValue = ASPx.Attr.GetAttribute(obj, Aria.label) || "";
 var resultParts = [ ];
 if(currentValue)
  resultParts.push(currentValue);
 var needAppendValue = value && (!checkExists || currentValue.indexOf(value) == -1);
 if(needAppendValue)
  resultParts.push(value);
 ASPx.Attr.SetAttribute(obj, Aria.label, resultParts.join(" "));
};
Aria.SetOrRemoveLabelled = function(obj, value) {
 ASPx.Attr.SetOrRemoveAttribute(obj, Aria.labelled, value);
};
Aria.SetApplicationRole = function(obj) {
  ASPx.Attr.SetAttribute(obj, Aria.role, "application");
};
Aria.SetSilence = function(obj) {
 ASPx.Attr.SetAttribute(obj, Aria.label, ";");
};
Aria.SetExpanded = function(obj, expanded) {
 if(!obj || !ASPx.Attr.GetAttribute(obj, Aria.expanded)) return;
 Aria.SetBoolAttribute(obj, Aria.expanded, expanded);
};
Aria.SetAtomic = function(obj, value) {
 Aria.SetBoolAttribute(obj, Aria.atomic, value);
};
Aria.SetBoolAttribute = function(obj, attribute, value) {
 if(value)
  ASPx.Attr.SetAttribute(obj, attribute, true);
 else 
  ASPx.Attr.SetAttribute(obj, attribute, false);
};
ASPx.Attr.Aria = Aria;
var Color = { };
function _aspxToHex(d) {
 return (d < 16) ? ("0" + d.toString(16)) : d.toString(16);
}
Color.RGBRegexp = /rgb\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*\)/;
Color.ColorToHexadecimal = function(colorValue) {
 if(typeof(colorValue) == "number") {
  var r = colorValue & 0xFF;
  var g = (colorValue >> 8) & 0xFF;
  var b = (colorValue >> 16) & 0xFF;
  return "#" + _aspxToHex(r) + _aspxToHex(g) + _aspxToHex(b);
 }
 if(colorValue && (colorValue.substr(0, 3).toLowerCase() == "rgb")) {
  var regResult = colorValue.toLowerCase().match(Color.RGBRegexp);
  if(regResult) {
   var r = parseInt(regResult[1]);
   var g = parseInt(regResult[2]);
   var b = parseInt(regResult[3]);
   return "#" + _aspxToHex(r) + _aspxToHex(g) + _aspxToHex(b);
  }
  return null;
 } 
 if(colorValue && (colorValue.charAt(0) == "#"))
  return colorValue;
 return null;
};
Color.Names = {
 AddColorNames: function(stringResourcesObj) {
  if(stringResourcesObj) {
   for(var key in stringResourcesObj)
    if(stringResourcesObj.hasOwnProperty(key))
     this[key] = stringResourcesObj[key];
  }
 }
};
ASPx.Color = Color;
var Url = { };
Url.Navigate = function(url, target) {
 var javascriptPrefix = "javascript:";
 if(!url || url === "")
  return;
 else if(url.indexOf(javascriptPrefix) != -1) 
  eval(url.substr(javascriptPrefix.length));
 else {
  try{
   if(target != "")
    navigateTo(url, target);
   else
    location.href = url;
  }
  catch(e){
  }
 }
};
Url.NavigateByLink = function(linkElement) {
 Url.Navigate(Attr.GetAttribute(linkElement, "href"), linkElement.target);
};
Url.GetAbsoluteUrl = function(url) {
 if(url)
  url = Url.getURLObject(url).href;
 return url;
};
Url.Redirect = function(url) {
 if(!ASPx.Browser.IE)
  window.location.href = url;
 else { 
  var fakeLink = document.createElement("a");
  fakeLink.href = url;
  document.body.appendChild(fakeLink);
  try { fakeLink.click(); } catch(e) { } 
 }
};
var absolutePathPrefixes = 
 [ "about:", "file:///", "ftp://", "gopher://", "http://", "https://", "javascript:", "mailto:", "news:", "res://", "telnet://", "view-source:" ];
Url.isAbsoluteUrl = function(url) {
 if (url) {
  for (var i = 0; i < absolutePathPrefixes.length; i++) {
   if(url.indexOf(absolutePathPrefixes[i]) == 0)
    return true;
  }
 }
 return false;
};
Url.getURLObject = function(url) {
 var link = document.createElement('A');
 link.href = url || "";
 return { 
  href: link.href,
  protocol: link.protocol,
  host: link.host,
  port: link.port,
  pathname: link.pathname,
  search: link.search,
  hash: link.hash
 }; 
};
Url.getRootRelativeUrl = function(url) {
 return getRelativeUrl(url, !Url.isRootRelativeUrl(url), true); 
};
Url.getPathRelativeUrl = function(url) {
 return getRelativeUrl(url, !Url.isPathRelativeUrl(url), false);
};
function getRelativeUrl(url, isValid, isRootRelative) {
 if(url && !(/data:([^;]+\/?[^;]*)(;charset=[^;]*)?(;base64,)/.test(url)) && isValid) {
  var urlObject = Url.getURLObject(url);
  var baseUrlObject = Url.getURLObject();
  if(!Url.isAbsoluteUrl(url) || urlObject.host === baseUrlObject.host && urlObject.protocol === baseUrlObject.protocol) {
   url = urlObject.pathname;
   if(!isRootRelative)
    url = getPathRelativeUrl(baseUrlObject.pathname, url);
   url = url + urlObject.search + urlObject.hash;
  }
 }
 return url;   
}
function getPathRelativeUrl(baseUrl, url) {
 var requestSegments = getSegments(baseUrl, false);
 var urlSegments = getSegments(url, true);
 return buildPathRelativeUrl(requestSegments, urlSegments, 0, 0, "");
}
function getSegments(url, addTail) {
 var segments = [];
 var startIndex = 0;
 var endIndex = -1;
 while ((endIndex = url.indexOf("/", startIndex)) != -1) {
  segments.push(url.substring(startIndex, ++endIndex));
  startIndex = endIndex;
 }
 if(addTail && startIndex < url.length)
  segments.push(url.substring(startIndex, url.length)); 
 return segments;
}
function buildPathRelativeUrl(requestSegments, urlSegments, reqIndex, urlIndex, buffer) {
 if(urlIndex >= urlSegments.length)
  return buffer;
 if(reqIndex >= requestSegments.length)
  return buildPathRelativeUrl(requestSegments, urlSegments, reqIndex, urlIndex + 1, buffer + urlSegments[urlIndex]);
 if(requestSegments[reqIndex] === urlSegments[urlIndex] && urlIndex === reqIndex)
  return buildPathRelativeUrl(requestSegments, urlSegments, reqIndex + 1, urlIndex + 1, buffer);
 return buildPathRelativeUrl(requestSegments, urlSegments, reqIndex + 1, urlIndex, buffer + "../");
}
Url.isPathRelativeUrl = function(url) {
 return !!url && !Url.isAbsoluteUrl(url) && url.indexOf("/") != 0;  
};
Url.isRootRelativeUrl = function(url) {
 return !!url && !Url.isAbsoluteUrl(url) && url.indexOf("/") == 0 && url.indexOf("//") != 0;
};
function navigateTo(url, target) {
 var lowerCaseTarget = target.toLowerCase();
 if("_top" == lowerCaseTarget)
  top.location.href = url;
 else if("_self" == lowerCaseTarget)
  location.href = url;
 else if("_search" == lowerCaseTarget)
  openInNewWindow(url);
 else if("_media" == lowerCaseTarget)
  openInNewWindow(url);
 else if("_parent" == lowerCaseTarget)
  window.parent.location.href = url;
 else if("_blank" == lowerCaseTarget)
  openInNewWindow(url);
 else {
  var frame = getFrame(top.frames, target);
  if(frame != null)
   frame.location.href = url;
  else
   openInNewWindow(url);
 }
}
function openInNewWindow(url) {
 if(ASPx.Browser.Safari)
  openInNewWindowViaIframe(url);
 else {
  var newWindow = window.open();
  newWindow.opener = null;
  newWindow.location = url;
 }
}
function openInNewWindowViaIframe(url) {
 var iframe = document.createElement('iframe');
 iframe.style.display = 'none';
 document.body.appendChild(iframe);
 var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
 var openArgs = '"' + url + '"';
 var script = iframeDoc.createElement('script');
 script.type = 'text/javascript';
 script.text = 'window.parent = null; ' +
  'window.top = null;' +
  'window.frameElement = null;' +
  'var child = window.open(' + openArgs + ');' +
  'child.opener = null';
 iframeDoc.body.appendChild(script);
 document.body.removeChild(iframe);
}
ASPx.Url = Url;
var Json = { };
function isValid(JsonString) {
 return !(/[^,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]/.test(JsonString.replace(/"(\\.|[^"\\])*"/g, '')));
}
Json.Eval = function(jsonString, controlName) {
 if(isValid(jsonString))
  return eval("(" + jsonString + ")");
 else
  throw new Error(controlName + " received incorrect JSON-data: " + jsonString);
};
Json.ToJson = function(param){
 var paramType = typeof(param);
 if((paramType == "undefined") || (param == null))
  return null;
 if((paramType == "object") && (typeof(param.__toJson) == "function"))
  return param.__toJson();
 if((paramType == "number") || (paramType == "boolean"))
  return param;
 if(param.constructor == Date)
  return dateToJson(param);
 if(paramType == "string") {
  var result = param.replace(/\\/g, "\\\\");
  result = result.replace(/"/g, "\\\"");
  result = result.replace(/\n/g, "\\n");
  result = result.replace(/\r/g, "\\r");
  result = result.replace(/</g, "\\u003c");
  result = result.replace(/>/g, "\\u003e");
  return "\"" + result + "\"";
 }
 if(param.constructor == Array){
  var values = [];
  for(var i = 0; i < param.length; i++) {
   var jsonValue = Json.ToJson(param[i]);
   if(jsonValue === null)
    jsonValue = "null";
   values.push(jsonValue);
  }
  return "[" + values.join(",") + "]";
 }
 var exceptKeys = {};
 if(ASPx.Ident.IsArray(param.__toJsonExceptKeys))
  exceptKeys = Data.CreateHashTableFromArray(param.__toJsonExceptKeys);
 exceptKeys["__toJsonExceptKeys"] = 1;
 var values = [];
 for(var key in param) {
  if(param.hasOwnProperty(key)) {
   if(ASPx.IsFunction(param[key]))
    continue;
   if(exceptKeys[key] == 1)
    continue;
   values.push(Json.ToJson(key) + ":" + Json.ToJson(param[key]));
  }
 }
 return "{" + values.join(",") + "}";
};
function dateToJson(date) {
 var result = [ 
  date.getFullYear(),
  date.getMonth(),
  date.getDate()
 ];
 var time = {
  h: date.getHours(),
  m: date.getMinutes(),
  s: date.getSeconds(),
  ms: date.getMilliseconds()
 };
 if(time.h || time.m || time.s || time.ms)
  result.push(time.h);
 if(time.m || time.s || time.ms)
  result.push(time.m);
 if(time.s || time.ms)
  result.push(time.s);
 if(time.ms)
  result.push(time.ms);
 return "new Date(" + result.join() + ")";
}
ASPx.Json = Json;
ASPx.CreateClass = function(parentClass, properties) {
 if(arguments.length == 1) {
  properties = parentClass;
  parentClass = null;
 }
 var ret = function() {
  if(ret.preparing) 
   return delete(ret.preparing);
  if(ret.constr) {
   this.constructor = ret;
   ret.constr.apply(this, arguments);
  }
 };
 ret.prototype = {};
 if(parentClass) {
  parentClass.preparing = true;
  for(var name in parentClass) {
   if(parentClass.hasOwnProperty(name) && name != 'constr' && ASPx.IsFunction(parentClass[name]) && !ret[name])
    ret[name] = parentClass[name].aspxBind(parentClass);
  }
  ret.prototype = new parentClass;
  ret.prototype.constructor = parentClass;
  ret.constr = parentClass;
 }
 if(properties) {
  var constructorName = "constructor";
  for(var name in properties) {
   if(!properties.hasOwnProperty(name)) 
    continue;
   var getter = Object.getOwnPropertyDescriptor(properties, name).get;
   var setter = Object.getOwnPropertyDescriptor(properties, name).set;
   if(getter || setter)
    Object.defineProperty(ret.prototype, name, {
     set: setter,
     get: getter,
     enumerable: true,
     configurable: true
    });
   if(name != constructorName && !getter && !setter)
    ret.prototype[name] = properties[name];
  }
  if(properties[constructorName] && properties[constructorName] != Object)
   ret.constr = properties[constructorName];
 }
 return ret;
};
ASPx.FormatCallbackArg = function(prefix, arg) {
 if(prefix == null && arg == null)
  return ""; 
 if(prefix == null) prefix = "";
 if(arg == null) arg = "";
 if(arg != null && !ASPx.IsExists(arg.length) && ASPx.IsExists(arg.value))
  arg = arg.value;
 arg = arg.toString();
 return [prefix, '|', arg.length, '|' , arg].join('');
};
ASPx.FormatCallbackArgs = function(callbackData) {
 var sb = [ ];
 for(var i = 0; i < callbackData.length; i++)
  sb.push(ASPx.FormatCallbackArg(callbackData[i][0], callbackData[i][1]));
 return sb.join("");
};
ASPx.ParseShortcutString = function(shortcutString) {
 if(!shortcutString)
  return 0;
 var isCtrlKey = false;
 var isShiftKey = false;
 var isAltKey = false;
 var isMetaKey = false;
 var keyCode = null;
 var shcKeys = shortcutString.toString().split("+");
 if(shcKeys.length > 0) {
  for(var i = 0; i < shcKeys.length; i++) {
   var key = Str.Trim(shcKeys[i].toUpperCase());
   switch (key) {
    case "CONTROL":
    case "CONTROLKEY":
    case "CTRL":
     isCtrlKey = true;
     break;
    case "SHIFT":
    case "SHIFTKEY":
     isShiftKey = true;
     break;
    case "ALT":
     isAltKey = true;
     break;
    case "CMD":
     isMetaKey = true;
     break;
    case "F1": keyCode = ASPx.Key.F1; break;
    case "F2": keyCode = ASPx.Key.F2; break;
    case "F3": keyCode = ASPx.Key.F3; break;
    case "F4": keyCode = ASPx.Key.F4; break;
    case "F5": keyCode = ASPx.Key.F5; break;
    case "F6": keyCode = ASPx.Key.F6; break;
    case "F7": keyCode = ASPx.Key.F7; break;
    case "F8": keyCode = ASPx.Key.F8; break;
    case "F9": keyCode = ASPx.Key.F9; break;
    case "F10":   keyCode = ASPx.Key.F10; break;
    case "F11":   keyCode = ASPx.Key.F11; break;
    case "F12":   keyCode = ASPx.Key.F12; break;
    case "RETURN":
    case "ENTER": keyCode = ASPx.Key.Enter; break;
    case "HOME":  keyCode = ASPx.Key.Home; break;
    case "END":   keyCode = ASPx.Key.End; break;
    case "LEFT":  keyCode = ASPx.Key.Left; break;
    case "RIGHT": keyCode = ASPx.Key.Right; break;
    case "UP": keyCode = ASPx.Key.Up; break;
    case "DOWN":  keyCode = ASPx.Key.Down; break;
    case "PAGEUP": keyCode = ASPx.Key.PageUp; break;
    case "PAGEDOWN": keyCode = ASPx.Key.PageDown; break;
    case "SPACE": keyCode = ASPx.Key.Space; break;
    case "TAB":   keyCode = ASPx.Key.Tab; break;
    case "BACKSPACE": 
    case "BACK": keyCode = ASPx.Key.Backspace; break;
    case "CONTEXT": keyCode = ASPx.Key.ContextMenu; break;
    case "ESCAPE":
    case "ESC":
     keyCode = ASPx.Key.Esc;
     break;
    case "DELETE":
    case "DEL":
     keyCode = ASPx.Key.Delete;
     break;
    case "INSERT":
    case "INS":
     keyCode = ASPx.Key.Insert;
     break;
    case "PLUS":
     keyCode = "+".charCodeAt(0);
     break;
    default:
     keyCode = key.charCodeAt(0);
     break;
   }
  }
 } else
  ASPx.ShowErrorAlert("Invalid shortcut");
 return ASPx.GetShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey);
};
ASPx.GetShortcutCode = function(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey) {
 var value = keyCode & 0xFFFF;
 var flags = 0;
 flags |= isCtrlKey ? 1 << 0 : 0;
 flags |= isShiftKey ? 1 << 2 : 0;
 flags |= isAltKey ? 1 << 4 : 0;
 flags |= isMetaKey ? 1 << 8 : 0;
 value |= flags << 16;
 return value;
};
ASPx.GetShortcutCodeByEvent = function(evt) {
 return ASPx.GetShortcutCode(Evt.GetKeyCode(evt), evt.ctrlKey, evt.shiftKey, evt.altKey, ASPx.Browser.MacOSPlatform ? evt.metaKey : false);
};
ASPx.IsPasteShortcut = function(evt) {
 if(evt.type === "paste")
  return true;
 var keyCode = Evt.GetKeyCode(evt);
 if(Browser.NetscapeFamily && evt.which == 0)  
  keyCode = evt.keyCode;
 return (evt.ctrlKey && (keyCode == 118  || (keyCode == 86))) ||
     (evt.shiftKey && !evt.ctrlKey && !evt.altKey &&
     (keyCode == ASPx.Key.Insert)) ;
};
var NotPrintableKeyCodes = null;
ASPx.IsPrintableKey = function(keyCode) {
 if (!NotPrintableKeyCodes)
  NotPrintableKeyCodes = Object.keys(ASPx.Key).map(function(key) { return ASPx.Key[key]; });
 return !ASPx.Data.ArrayContains(NotPrintableKeyCodes, keyCode);
};
ASPx.SetFocus = function(element, selectAction) {
 function focusCore(element, selectAction){
  try {
    element.focus();
    if(Browser.IE && document.activeElement != element)
     element.focus();
    if(selectAction) {
     var currentSelection = Selection.GetInfo(element);
     if(currentSelection.startPos == currentSelection.endPos) {
      switch(selectAction) {
       case "start":
        Selection.SetCaretPosition(element, 0);
        break;
       case "all":
        Selection.Set(element);
        break;
      }
     }
    }
   } catch (e) {
  }
 }
 if(ASPxClientUtils.iOSPlatform) 
  focusCore(element, selectAction);
 else {
  window.setTimeout(function() { 
   focusCore(element, selectAction);
  }, 100);
 }
};
ASPx.IsFocusableCore = function(element, skipContainerVisibilityCheck) {
 var current = element;
 while(current && current.nodeType == 1) {
  if(current == element || !skipContainerVisibilityCheck(current)) {
   if(current.tagName == "BODY")
    return true;
   if(current.disabled || !ASPx.GetElementDisplay(current) || !ASPx.GetElementVisibility(current))
    return false;
  }
  current = current.parentNode;
 }
 return true;
};
ASPx.IsFocusable = function(element) {
 return ASPx.IsFocusableCore(element, ASPx.FalseFunction);
};
ASPx.IsActionElement = function(element) {
 if(!ASPx.IsExistsElement(element))
  return false;
 var tabIndex = parseInt(ASPx.Attr.GetAttribute(element, ASPx.Attr.GetTabIndexAttributeName()));
 var hasTabIndex = !isNaN(tabIndex);
 var hasNonNegativeTabIndex = hasTabIndex && tabIndex > -1;
 var hasNegativeTabIndex = hasTabIndex && tabIndex < 0;
 var tagName = element.tagName;
 var focusableElementTags = ["BUTTON", "SELECT", "TEXTAREA", "OPTION", "IFRAME"];
 var isFocusableCore = ASPx.IsFocusable(element);
 var isFocusableTag = focusableElementTags.indexOf(tagName) !== -1;
 var isFocusableLink = tagName === "A" && (!!element.href || hasNonNegativeTabIndex);
 var isFocusableInput = tagName === "INPUT" && element.type.toLowerCase() !== "hidden";
 var isFocusableByTabIndex = tagName !== "INPUT" && hasNonNegativeTabIndex;
 return isFocusableCore && !hasNegativeTabIndex && (isFocusableTag || isFocusableLink || isFocusableInput || isFocusableByTabIndex);
};
ASPx.GetCanBeActiveElementsInContainer = function(container) {
 var canBeActiveTags = ["INPUT", "A", "UL", "BUTTON", "TEXTAREA", "SELECT", "IFRAME"],
  canBeActiveElements = [];
 Data.ForEach(canBeActiveTags, function(tag) {
  var elements = container.getElementsByTagName(tag);
  canBeActiveElements = canBeActiveElements.concat([].slice.call(elements));
 });
 return canBeActiveElements;
};
function isActionElementAllowedByPredicate(element, predicate) {
  var allowedByPredicate = !predicate || predicate(element);
  return allowedByPredicate && ASPx.IsActionElement(element);
}
ASPx.FindChildActionElements = function(container, predicate) {
 return ASPx.GetNodes(container, function(el) {
  return isActionElementAllowedByPredicate(el, predicate);
 });
};
ASPx.FindAllSortedActionElements = function(container, predicate) {
 var result = [ ];
 if(!container || !container.getElementsByTagName) return result;
 var actionElements = ASPx.FindChildActionElements(container, predicate);
 var getTabOrderValue = function(el) {
  var tabIndex = parseInt(ASPx.Attr.GetAttribute(el, ASPx.Attr.GetTabIndexAttributeName()));
  return isNaN(tabIndex) ? 0 : tabIndex;
 };
 var positiveTabIndexElements = actionElements.filter(function(x) { return getTabOrderValue(x) > 0; });
 var nonPositiveTabIndexElements = actionElements.filter(function(x) { return getTabOrderValue(x) === 0; });
 var sortedTabIndexElements = positiveTabIndexElements.sort(function(x, y) { return getTabOrderValue(x) - getTabOrderValue(y); });
 result = sortedTabIndexElements.concat(nonPositiveTabIndexElements);
 return result;
};
ASPx.FindFirstChildActionElement = function(container, predicate) {
 if(!container || isActionElementAllowedByPredicate(container, predicate))
  return !container ? null : container;
 var sortedActionElements = ASPx.FindAllSortedActionElements(container, predicate);
 return sortedActionElements[0];
};
ASPx.FindLastChildActionElement = function(container, predicate) {
 if(!container)
  return null;
 var sortedActionElements = ASPx.FindAllSortedActionElements(container, predicate);
 var actionElement = sortedActionElements[sortedActionElements.length - 1];
 if(!actionElement && isActionElementAllowedByPredicate(container, predicate))
  actionElement = container;
 return actionElement;
};
ASPx.GetParentClientControls = function(name) {
 var nameParts = name.split("_");
 var result = [ ];
 var controlCollection = ASPx.GetControlCollection();
 for(var i = 1; i <= nameParts.length; i++) {
  var controlName = nameParts.slice(0, i).join("_");
  var control = controlCollection.Get(controlName);
  if(control)
   result.push(control);
 }
 return result;
};
ASPx.GetRootClientControl = function(childControlName) {
 var parentControls = ASPx.GetParentClientControls(childControlName);
 return parentControls[0];
};
ASPx.GetClientControlByElementID = function(elementID) {
 var parentControls = ASPx.GetParentClientControls(elementID);
 return parentControls[parentControls.length - 1];
};
ASPx.IsExists = function(obj){
 return (typeof(obj) != "undefined") && (obj != null);
};
ASPx.IsFunction = function(obj){
 return typeof(obj) == "function";
};
ASPx.IsNumber = function(str) {
 return !isNaN(parseFloat(str)) && isFinite(str);
};
ASPx.GetDefinedValue = function(value, defaultValue){
 return (typeof(value) != "undefined") ? value : defaultValue;
};
ASPx.CorrectJSFloatNumber = function(number) {
 var ret = 21; 
 var numString = number.toPrecision(21);
 numString = numString.replace("-", ""); 
 var integerDigitsCount = numString.indexOf(ASPx.PossibleNumberDecimalSeparators[0]);
 if(integerDigitsCount < 0)
  integerDigitsCount = numString.indexOf(ASPx.PossibleNumberDecimalSeparators[1]);
 var floatDigitsCount = numString.length - integerDigitsCount - 1;
 if(floatDigitsCount < 10)
  return number;
 if(integerDigitsCount > 0) {
  ret = integerDigitsCount + 12;
 }
 var toPrecisionNumber = Math.min(ret, 21);
 var newValueString = number.toPrecision(toPrecisionNumber);
 return parseFloat(newValueString, 10);
};
ASPx.CorrectRounding = function(number, step) { 
 var regex = /[,|.](.*)/,
  isFloatValue = regex.test(number),
  isFloatStep = regex.test(step);
 if(isFloatValue || isFloatStep) {
  var valueAccuracy = (isFloatValue) ? regex.exec(number)[0].length - 1 : 0,
   stepAccuracy = (isFloatStep) ? regex.exec(step)[0].length - 1 : 0,
   accuracy = Math.max(valueAccuracy, stepAccuracy);
  var multiplier = Math.pow(10, accuracy);
  number = Math.round((number + step) * multiplier) / multiplier;
  return number;
 }
 return number + step;
};
ASPx.GetActiveElement = function() {
 try{ return document.activeElement; } catch(e) { return null; }
};
var verticalScrollBarWidth;
ASPx.GetVerticalScrollBarWidth = function() {
 if(typeof(verticalScrollBarWidth) == "undefined") {
  var container = document.createElement("DIV");
  container.style.cssText = "position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box";
  document.body.appendChild(container);
  var child = document.createElement("P");
  container.appendChild(child);
  child.style.cssText = "width: 100%; height: 200px;";
  var widthWithoutScrollBar = child.offsetWidth;
  container.style.overflow = "scroll";
  var widthWithScrollBar = child.offsetWidth;
  if(widthWithoutScrollBar == widthWithScrollBar)
   widthWithScrollBar = container.clientWidth;
  verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar;
  document.body.removeChild(container);
 }
 return verticalScrollBarWidth;
};
function hideScrollBarCore(element, scrollName) {
 if(element.tagName == "IFRAME") {
  if((element.scrolling == "yes") || (element.scrolling == "auto")) {
   Attr.ChangeAttribute(element, "scrolling", "no");
   return true;
  }
 }
 else if(element.tagName == "DIV") {
  if((element.style[scrollName] == "scroll") || (element.style[scrollName] == "auto")) {
   Attr.ChangeStyleAttribute(element, scrollName, "hidden");
   return true;
  }
 }
 return false;
}
function restoreScrollBarCore(element, scrollName) {
 if(element.tagName == "IFRAME")
  return Attr.RestoreAttribute(element, "scrolling");
 else if(element.tagName == "DIV")
  return Attr.RestoreStyleAttribute(element, scrollName);
 return false;
}
ASPx.SetScrollBarVisibilityCore = function(element, scrollName, isVisible) {
 return isVisible ? restoreScrollBarCore(element, scrollName) : hideScrollBarCore(element, scrollName);
};
ASPx.SetScrollBarVisibility = function(element, isVisible) {
 if(ASPx.SetScrollBarVisibilityCore(element, "overflow", isVisible)) 
  return true;
 var result = ASPx.SetScrollBarVisibilityCore(element, "overflowX", isVisible)
  || ASPx.SetScrollBarVisibilityCore(element, "overflowY", isVisible);
 return result;
};
ASPx.SetInnerHtml = function(element, html) {
 if(Browser.IE) {
  element.innerHTML = "<em>&nbsp;</em>" + html;
  element.removeChild(element.firstChild);
 } else
  element.innerHTML = html;
};
ASPx.GetInnerText = function(container) {
 if(Browser.Safari && Browser.MajorVersion <= 5) {
  var filter = getHtml2PlainTextFilter();
  filter.innerHTML = container.innerHTML;
  ASPx.SetElementDisplay(filter, true);
  var innerText = filter.innerText;
  ASPx.SetElementDisplay(filter, false);
  return innerText;
 } else if(Browser.NetscapeFamily || Browser.WebKitFamily || (Browser.IE && Browser.Version >= 9) || Browser.Edge) {
  return container.textContent;
 } else
  return container.innerText;
};
var html2PlainTextFilter = null;
function getHtml2PlainTextFilter() {
 if(html2PlainTextFilter == null) {
  html2PlainTextFilter = document.createElement("DIV");
  html2PlainTextFilter.style.width = "0";
  html2PlainTextFilter.style.height = "0";
  html2PlainTextFilter.style.overflow = "visible";
  ASPx.SetElementDisplay(html2PlainTextFilter, false);
  document.body.appendChild(html2PlainTextFilter);
 }
 return html2PlainTextFilter;
}
ASPx.CreateHiddenField = function(name, id) {
 var input = document.createElement("INPUT");
 input.setAttribute("type", "hidden");
 if(name)
  input.setAttribute("name", name);
 if(id)
  input.setAttribute("id", id);
 return input;
};
ASPx.CloneObject = function(srcObject) {
 if(typeof(srcObject) != 'object' || srcObject == null)
  return srcObject;
 var newObject = {};
 for(var i in srcObject)
  newObject[i] = srcObject[i];
 return newObject;
};
ASPx.IsPercentageSize = function(size) {
 return size && size.indexOf('%') != -1;
};
ASPx.GetElementById = function(id) {
 if(document.getElementById)
  return document.getElementById(id);
 else
  return document.all[id];
};
ASPx.GetInputElementById = function(id) {
 var elem = ASPx.GetElementById(id);
 if(!Browser.IE)
  return elem;
 if(elem) {
  if(elem.id == id)
   return elem;
  else {
   for(var i = 1; i < document.all[id].length; i++) {
    if(document.all[id][i].id == id)
     return document.all[id][i];
   }
  }
 }
 return null;
};
ASPx.GetElementByIdInDocument = function(documentObj, id) {
 if(documentObj.getElementById)
  return documentObj.getElementById(id);
 else
  return documentObj.all[id];
};
ASPx.GetIsParent = function(parentElement, element) {
 if(!parentElement || !element)
  return false;
 while(element){
  if(element === parentElement)
   return true;
  if(element.tagName === "BODY")
   return false;
  element = element.parentNode;
 }
 return false;
};
ASPx.GetParentById = function(element, id) {
 element = element.parentNode;
 while(element){
  if(element.id === id)
   return element;
  element = element.parentNode;
 }
 return null;
};
ASPx.GetParentByPartialId = function(element, idPart){
 while(element && element.tagName != "BODY") {
  if(element.id && element.id.match(idPart)) 
   return element;
  element = element.parentNode;
 }
 return null;
};
ASPx.GetParentByTagName = function(element, tagName) {
 tagName = tagName.toUpperCase();
 while(element) {
  if(element.tagName === "BODY")
   return null;
  if(element.tagName === tagName)
   return element;
  element = element.parentNode;
 }
 return null;
};
function getParentByClassNameInternal(element, className, selector) {
 while(element != null) {
  if(element.tagName == "BODY" || element.nodeName == "#document")
   return null;
  if(selector(element, className))
   return element;
  element = element.parentNode;
 }
 return null;
}
ASPx.GetParentByPartialClassName = function(element, className) {
 return getParentByClassNameInternal(element, className, ASPx.ElementContainsCssClass);
};
ASPx.GetParentByClassName = function(element, className) {
 return getParentByClassNameInternal(element, className, ASPx.ElementHasCssClass);
};
ASPx.GetParentByTagNameAndAttributeValue = function(element, tagName, attrName, attrValue) {
 tagName = tagName.toUpperCase();
 while(element != null) {
  if(element.tagName == "BODY")
   return null;
  if(element.tagName == tagName && element[attrName] == attrValue)
   return element;
  element = element.parentNode;
 }
 return null;
};
ASPx.GetParent = function(element, testFunc){
 if (!ASPx.IsExists(testFunc)) return null;
 while(element != null && element.tagName != "BODY"){
  if(testFunc(element))
   return element;
  element = element.parentNode;
 }
 return null;
};
ASPx.GetElementTreeLine = function(element, stopTagName, stopFunc) {
 var result = [];
 stopTagName = stopTagName || "BODY";
 while(element != null) {
  if(!stopFunc && element.tagName == stopTagName)
   break;
  if(stopFunc && stopFunc(element))
   break;
  result.push(element);
  element = element.parentNode;
 }
 return result;
};
ASPx.IsScrollableElement = function(element, isHorzScrollable, isVertScrollable) {
 isHorzScrollable = ASPx.IsExists(isHorzScrollable) ? isHorzScrollable : true;
 isVertScrollable = ASPx.IsExists(isVertScrollable) ? isVertScrollable : true;
 var style = ASPx.GetCurrentStyle(element);
 var overflowStyleNames = ["overflow"];
 if(isHorzScrollable)
  overflowStyleNames.push("overflowX");
 if(isVertScrollable)
  overflowStyleNames.push("overflowY");
 for(var i = 0; i < overflowStyleNames.length; i++)
  if(style[overflowStyleNames[i]] == "scroll" || style[overflowStyleNames[i]] == "auto")
   return true;
 return false;
};
ASPx.GetPreviousSibling = function(el) {
 if(el.previousElementSibling) {
  return el.previousElementSibling;
 } else {
  while(el = el.previousSibling) {
   if(el.nodeType === 1)
    return el;
  }
 }
};
ASPx.ElementHasCssClass = function(element, className) {
 try {
  var elementClasses;
  var classList = element.classList;
  if(!classList) {
   if(!element.className)
    return false;
   elementClasses = element.className.split(" ");
  }
  var classNames = className.split(" ");
  for(var i = classNames.length - 1; i >= 0; i--) {
   if(classList) {
    if(!classList.contains(classNames[i]))
     return false;
    continue;
   }
   if(Data.ArrayIndexOf(elementClasses, classNames[i]) < 0)
    return false;
  }
  return true;
 } catch(e) {
  return false;
 }
};
ASPx.ElementContainsCssClass = function(element, className) {
 try {
  if(!element.className)
   return false;
  return element.className.indexOf(className) != -1;
 } catch(e) {
  return false;
 }
};
ASPx.AddClassNameToElement = function (element, className) {
 if(!element || typeof(className) !== "string" ) return;
 className = className.trim();
 if(!ASPx.ElementHasCssClass(element, className) && className !== "")
  element.className = (element.className === "") ? className : element.className + " " + className;
};
ASPx.RemoveClassNameFromElement = function(element, className) {
 if(!element) return;
 var updClassName = " " + element.className + " ";
 var newClassName = updClassName.replace(" " + className + " ", " ");
 if(updClassName.length != newClassName.length)
  element.className = Str.Trim(newClassName);
};
ASPx.GetClassNameList = function(element) {
 if(element.classList)
  return [ ].slice.call(element.classList);
 return element.className.replace(/^\s+|\s+$/g, '').split(/\s+/);
};
function nodeListToArray(nodeList, filter) {
 var result = [];
 for(var i = 0, element; element = nodeList[i]; i++) {
  if(filter && !filter(element))
   continue;
  result.push(element);
 }
 return result;
}
ASPx.NodeListToArray = nodeListToArray;
function getItemByIndex(collection, index) {
 if(!index) index = 0;
 if(collection != null && collection.length > index)
  return collection[index];
 return null;
}
ASPx.GetChildNodesByQuerySelector = function (parent, selector) {
 return nodeListToArray(parent.querySelectorAll(selector), function (el) { return el.parentNode === parent; });
};
ASPx.GetChildNodesByClassName = function(parent, className) {
 if(!parent) return [];
 if(parent.querySelectorAll) {
  var children = parent.querySelectorAll('.' + className);
  return nodeListToArray(children, function(element) { 
   return element.parentNode === parent;
  });
 }
 return ASPx.GetChildNodes(parent, function(elem) { return elem.className && ASPx.ElementHasCssClass(elem, className); });
};
ASPx.GetChildNodesByPartialClassName = function(element, className) {
 return ASPx.GetChildElementNodesByPredicate(element,
  function(child) {
   return ASPx.ElementContainsCssClass(child, className);
  });
};
ASPx.GetChildByPartialClassName = function(element, className, index) {
 if(element != null){    
  var collection = ASPx.GetChildNodesByPartialClassName(element, className);
  return getItemByIndex(collection, index);
 }
 return null;
};
ASPx.GetChildByClassName = function(element, className, index) {
 if(element != null){    
  var collection = ASPx.GetChildNodesByClassName(element, className);
  return getItemByIndex(collection, index);
 }
 return null;
};
ASPx.GetNodesByPartialClassName = function(element, className) {
 if(element.querySelectorAll) {
  var list = element.querySelectorAll('*[class*=' + className + ']');
  return nodeListToArray(list);
 }
 var collection = element.all || element.getElementsByTagName('*');
 var ret = [ ];
 if(collection != null) {
  for(var i = 0; i < collection.length; i ++) {
   if(ASPx.ElementContainsCssClass(collection[i], className))
    ret.push(collection[i]);
  }
 }
 return ret;
};
ASPx.GetNodesByClassName = function(parent, className) {
 if(parent.querySelectorAll) {
  var children = parent.querySelectorAll('.' + className);
  return nodeListToArray(children);
 }
 return ASPx.GetNodes(parent, function(elem) { return elem.className && ASPx.ElementHasCssClass(elem, className); });
};
ASPx.GetNodeByClassName = function(element, className, index) {
 if(element != null){    
  var collection = ASPx.GetNodesByClassName(element, className);
  return getItemByIndex(collection, index);
 }
 return null;
};
ASPx.GetChildById = function(element, id) {
 if(element.all) {
  var child = element.all[id];
  if(!child) {
   child = element.all(id); 
   if(!child)
    return Browser.IE ? document.getElementById(id) : null; 
  } 
  if(!ASPx.IsExists(child.length)) 
   return child;
  else
   return ASPx.GetElementById(id);
 }
 else
  return ASPx.GetElementById(id);
};
ASPx.GetNodesByPartialId = function(element, partialName, list) {
 if(element.id && element.id.indexOf(partialName) > -1) 
  list.push(element);
 if(element.childNodes) {
  for(var i = 0; i < element.childNodes.length; i ++) 
   ASPx.GetNodesByPartialId(element.childNodes[i], partialName, list);
 }
};
ASPx.GetNodesByTagName = function(element, tagName) {
 tagName = tagName.toUpperCase();
 if(element) {
  if(element.getElementsByTagName) 
   return element.getElementsByTagName(tagName);
  else if(element.all && element.all.tags !== undefined)
   return Browser.Netscape ? element.all.tags[tagName] : element.all.tags(tagName);
 }
 return null;
};
ASPx.GetNodeByTagName = function(element, tagName, index) {
 if(element != null){    
  var collection = ASPx.GetNodesByTagName(element, tagName);
  return getItemByIndex(collection, index);
 }
 return null;
};
ASPx.GetChildNodesByTagName = function(parent, tagName) {
 return ASPx.GetChildNodes(parent, function (child) { return child.tagName === tagName; });
};
ASPx.GetChildByTagName = function(element, tagName, index) {
 if(element != null){    
  var collection = ASPx.GetChildNodesByTagName(element, tagName);
  return getItemByIndex(collection, index);
 }
 return null;
};
ASPx.RetrieveByPredicate = function(scourceCollection, predicate) {
 var result = [];
 for(var i = 0; i < scourceCollection.length; i++) {
  var element = scourceCollection[i];
  if(!predicate || predicate(element)) 
   result.push(element);
 }
 return result;
};
ASPx.GetChildNodes = function(parent, predicate) {
 return ASPx.RetrieveByPredicate(parent.childNodes, predicate);
};
ASPx.GetNodes = function(parent, predicate) {
 var c = parent.all || parent.getElementsByTagName('*');
 return ASPx.RetrieveByPredicate(c, predicate);
};
ASPx.GetChildElementNodes = function(parent) {
 if(!parent) return null;
 return ASPx.GetChildNodes(parent, function(e) { return e.nodeType == 1; });
};
ASPx.GetChildElementNodesByPredicate = function(parent, predicate) {
 if(!parent) return null;
 if(!predicate) return ASPx.GetChildElementNodes(parent);
 return ASPx.GetChildNodes(parent, function(e) { return e.nodeType == 1 && predicate(e); });
};
ASPx.GetTextNode = function(element, index) {
 if(element != null){
  var collection = [ ];
  ASPx.GetTextNodes(element, collection);
  return getItemByIndex(collection, index);
 }
 return null;
};
ASPx.GetTextNodes = function(element, collection) {
 for(var i = 0; i < element.childNodes.length; i ++){
  var childNode = element.childNodes[i];
  if(ASPx.IsExists(childNode.nodeValue))
   collection.push(childNode);
  ASPx.GetTextNodes(childNode, collection);
 }
};
ASPx.GetNormalizedTextNode = function(element, index) {
 var textNode = ASPx.GetTextNode(element, index);
 if(textNode != null)
  ASPx.MergeAdjacentTextNodes(textNode);
 return textNode;
};
ASPx.MergeAdjacentTextNodes = function(firstTextNode) {
 if(!ASPx.IsExists(firstTextNode.nodeValue))
  return;
 var textNode = firstTextNode;
 while(textNode.nextSibling && ASPx.IsExists(textNode.nextSibling.nodeValue)) {
  textNode.nodeValue += textNode.nextSibling.nodeValue;
  textNode.parentNode.removeChild(textNode.nextSibling);
 }
};
ASPx.GetElementDocument = function(element) {
 return element.document || element.ownerDocument;
};
ASPx.RemoveElement = function(element) {
 if(element && element.parentNode)
  element.parentNode.removeChild(element);
};
ASPx.ReplaceTagName = function(element, newTagName, cloneChilds) {
 if(element.nodeType != 1)
  return null;
 if(element.nodeName == newTagName)
  return element;
 cloneChilds = cloneChilds !== undefined ? cloneChilds : true;
 var doc = element.ownerDocument;
 var newElem = doc.createElement(newTagName);
 Attr.CopyAllAttributes(element, newElem);
 if(cloneChilds) {
  for(var i = 0; i < element.childNodes.length; i++)
   newElem.appendChild(element.childNodes[i].cloneNode(true));
 }
 else {
  for(var child; child = element.firstChild; )
   newElem.appendChild(child);
 }
 element.parentNode.replaceChild(newElem, element);
 return newElem;
};
ASPx.RemoveOuterTags = function(element) {
 if(ASPx.Browser.IE) {
  element.insertAdjacentHTML( 'beforeBegin', element.innerHTML ) ;
  ASPx.RemoveElement(element);
 } else {
  var docFragment = element.ownerDocument.createDocumentFragment();
  for(var i = 0; i < element.childNodes.length; i++)
   docFragment.appendChild(element.childNodes[i].cloneNode(true));
  element.parentNode.replaceChild(docFragment, element);
 }
};
ASPx.WrapElementInNewElement = function(element, newElementTagName) { 
 var wrapElement = null;
 if(Browser.IE) {
  var wrapElement = element.ownerDocument.createElement(newElementTagName);
  wrapElement.appendChild(element.cloneNode(true));
  element.parentNode.insertBefore(wrapElement, element);
  element.parentNode.removeChild(element);
 } else {
  var docFragment = element.ownerDocument.createDocumentFragment();
  wrapElement = element.ownerDocument.createElement(newElementTagName);
  docFragment.appendChild(wrapElement);
  wrapElement.appendChild(element.cloneNode(true));
  element.parentNode.replaceChild(docFragment, element);
 }
 return wrapElement;
};
ASPx.InsertElementAfter = function(newElement, targetElement) {
 var parentElem = targetElement.parentNode;
 if(parentElem.childNodes[parentElem.childNodes.length - 1] == targetElement)
  parentElem.appendChild(newElement);
 else
  parentElem.insertBefore(newElement, targetElement.nextSibling);
};
ASPx.SetElementOpacity = function(element, value) {
  var useOpacityStyle = !Browser.IE || Browser.Version > 8;
  if(useOpacityStyle){
   element.style.opacity = value;
  } else {
   if(typeof(element.filters) === "object" && element.filters["DXImageTransform.Microsoft.Alpha"])
    element.filters.item("DXImageTransform.Microsoft.Alpha").Opacity = value*100;
   else
   element.style.filter = "alpha(opacity=" + (value * 100) + ")";
  }
};
ASPx.GetElementOpacity = function(element) {
 var useOpacityStyle = !Browser.IE || Browser.Version > 8;
 if(useOpacityStyle)
  return parseFloat(ASPx.GetCurrentStyle(element).opacity);
 else {
  if(typeof(element.filters) === "object" && element.filters["DXImageTransform.Microsoft.Alpha"]){
   return element.filters.item("DXImageTransform.Microsoft.Alpha").Opacity / 100;
  } else {
   var alphaValue = ASPx.GetCurrentStyle(element).filter;
   var value = alphaValue.replace("alpha(opacity=", "");
   value = value.replace(")", "");
   return parseInt(value) / 100;
  }
  return 100;
 }
};
ASPx.GetElementDisplay = function(element, isCurrentStyle) {
 if (isCurrentStyle)
  return ASPx.GetCurrentStyle(element).display != "none";
 return element.style.display != "none";
};
ASPx.SetElementDisplay = function(element, value, checkCurrentStyle, makeInline) {
 if(!element) return;
 if(typeof(value) === "string")
  element.style.display = value;
 else if(!value)
  element.style.display = "none";
 else {
  element.style.display = "";
  if(checkCurrentStyle && ASPx.GetCurrentStyle(element).display === "none"){
   var displayAddon = makeInline ? "inline-" : "";
   switch(element.tagName){
    case "TABLE": {
     element.style.display = displayAddon + "table";
     break;
    }
    default: {
     element.style.display = displayAddon + "block";
     break;
    }
   }
  }
 }
};
ASPx.GetElementVisibility = function(element, isCurrentStyle) {
 if(isCurrentStyle)
  return ASPx.GetCurrentStyle(element).visibility != "hidden";
 return element.style.visibility != "hidden";
};
ASPx.SetElementVisibility = function(element, value) {
 if(!element) return;
 if(typeof(value) === "string")
  element.style.visibility = value;
 else
  element.style.visibility = value ? "visible" : "hidden";
};
ASPx.IsElementVisible = function(element, isCurrentStyle) {
 while(element && element.tagName != "BODY") {
  if(!ASPx.GetElementDisplay(element, isCurrentStyle) || (!ASPx.GetElementVisibility(element, isCurrentStyle) && !Attr.IsExistsAttribute(element, "errorFrame")))
     return false;
  element = element.parentNode;
 }
 return true;
};
ASPx.IsElementDisplayed = function(element) {
 while(element && element.tagName != "BODY") {
  if(!ASPx.GetElementDisplay(element))
     return false;
  element = element.parentNode;
 }
 return true;
};
ASPx.AddStyleSheetLinkToDocument = function(doc, linkUrl) {
 var newLink = createStyleLink(doc, linkUrl);
 var head = ASPx.GetHeadElementOrCreateIfNotExist(doc);
 head.appendChild(newLink);
};
ASPx.GetHeadElementOrCreateIfNotExist = function(doc) {
 var elements = ASPx.GetNodesByTagName(doc, "head");
 var head = null;
 if(elements.length == 0) {
  head = doc.createElement("head");
  head.visibility = "hidden";
  doc.insertBefore(head, doc.body);
 } else
  head = elements[0];
 return head;
};
function createStyleLink(doc, url) {
 var newLink = doc.createElement("link");
 Attr.SetAttribute(newLink, "href", url);
 Attr.SetAttribute(newLink, "type", "text/css");
 Attr.SetAttribute(newLink, "rel", "stylesheet");
 return newLink;
}
ASPx.GetCurrentStyle = function(element) {
 if(element.currentStyle)
  return element.currentStyle;
 else if(document.defaultView && document.defaultView.getComputedStyle) { 
  var result = document.defaultView.getComputedStyle(element, null);
  if(!result && Browser.Firefox && window.frameElement) {
   var changes = [];
   var curElement = window.frameElement;
   while(!(result = document.defaultView.getComputedStyle(element, null))) {
    changes.push([curElement, curElement.style.display]);
    ASPx.SetStylesCore(curElement, "display", "block", true);
    curElement = curElement.tagName == "BODY" ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
   }
   result = ASPx.CloneObject(result);
   for(var ch, i = 0; ch = changes[i]; i++)
    ASPx.SetStylesCore(ch[0], "display", ch[1]);
   var dummy = document.body.offsetWidth; 
  }
  return result;
 }
 return window.getComputedStyle(element, null);
};
ASPx.CreateStyleSheetInDocument = function(doc) {
 if(doc.createStyleSheet) {
  try {
   return doc.createStyleSheet();
  }
  catch(e) {
   var message = "The CSS link limit (31) has been exceeded. Please enable CSS merging or reduce the number of CSS files on the page. For details, see http://www.devexpress.com/Support/Center/p/K18487.aspx.";
   throw new Error(message);
  }
 }
 else {
  var styleSheet = doc.createElement("STYLE");
  ASPx.GetNodeByTagName(doc, "HEAD", 0).appendChild(styleSheet);
  return styleSheet.sheet;
 }
};
ASPx.currentStyleSheet = null;
ASPx.GetCurrentStyleSheet = function() {
 if(!ASPx.currentStyleSheet)
  ASPx.currentStyleSheet = ASPx.CreateStyleSheetInDocument(document);
 return ASPx.currentStyleSheet;
};
function getStyleSheetRules(styleSheet){
 try {
  return Browser.IE && Browser.Version == 8 ? styleSheet.rules : styleSheet.cssRules;
 }
 catch(e) {
  return null;
 }
}
ASPx.cachedCssRules = { };
ASPx.GetStyleSheetRules = function (className, stylesStorageDocument) {
 if(ASPx.cachedCssRules[className]) {
  if(ASPx.cachedCssRules[className] != ASPx.EmptyObject)
   return ASPx.cachedCssRules[className];
  return null;
 }
 var result = iterateStyleSheetRules(stylesStorageDocument, function(rule) {
  if(rule.selectorText == "." + className){
   ASPx.cachedCssRules[className] = rule;
   return rule;
  }
 });
 if(ASPx.IsExists(result))
  return result;
 ASPx.cachedCssRules[className] = ASPx.EmptyObject;
 return null;
};
function iterateStyleSheetRules(stylesStorageDocument, callback) {
 var doc = stylesStorageDocument || document;
 for(var i = 0; i < doc.styleSheets.length; i ++){
  var styleSheet = doc.styleSheets[i];
  var rules = getStyleSheetRules(styleSheet);
  if(rules != null){
   for(var j = 0; j < rules.length; j ++) {
    var result = callback(rules[j]);
    if(result !== undefined)
     return result;
   }
  }
 }
}
ASPx.ClearCachedCssRules = function(){
 ASPx.cachedCssRules = { };
};
var styleCount = 0;
var styleNameCache = { };
ASPx.CreateImportantStyleRule = function(styleSheet, cssText, postfix, prefix) {
 styleSheet = styleSheet || ASPx.GetCurrentStyleSheet();
 var cacheKey = (postfix ? postfix + "||" : "") + cssText + (prefix ? "||" + prefix : "");
 if(styleNameCache[cacheKey])
  return styleNameCache[cacheKey];
 prefix = prefix ? prefix + " " : "";
 var className = "dxh" + styleCount + (postfix ? postfix : "");
 ASPx.AddStyleSheetRule(styleSheet, prefix + "." + className, ASPx.CreateImportantCssText(cssText));
 styleCount++;
 styleNameCache[cacheKey] = className;
 return className; 
};
ASPx.CreateImportantCssText = function(cssText) {
 var newText = "";
 var attributes = cssText.split(";");
 for(var i = 0; i < attributes.length; i++){
  if(attributes[i] != "")
   newText += attributes[i] + " !important;";
 }
 return newText;
};
ASPx.AddStyleSheetRule = function(styleSheet, selector, cssText){
 if(!cssText) return;
 if(Browser.IE)
  styleSheet.addRule(selector, cssText);
 else
  styleSheet.insertRule(selector + " { " + cssText + " }", styleSheet.cssRules.length);
};
ASPx.GetPointerCursor = function() {
 return "pointer";
};
ASPx.SetPointerCursor = function(element) {
 if(element.style.cursor == "")
  element.style.cursor = ASPx.GetPointerCursor();
};
ASPx.SetElementFloat = function(element, value) {
 if(ASPx.IsExists(element.style.cssFloat))
  element.style.cssFloat = value;
 else if(ASPx.IsExists(element.style.styleFloat))
  element.style.styleFloat = value;
 else
  Attr.SetAttribute(element.style, "float", value);
};
ASPx.GetElementFloat = function(element) {
 var currentStyle = ASPx.GetCurrentStyle(element);
 if(ASPx.IsExists(currentStyle.cssFloat))
  return currentStyle.cssFloat;
 if(ASPx.IsExists(currentStyle.styleFloat))
  return currentStyle.styleFloat;
 return Attr.GetAttribute(currentStyle, "float");
};
function getElementDirection(element) {
 return ASPx.GetCurrentStyle(element).direction;
}
ASPx.IsElementRightToLeft = function(element) {
 return getElementDirection(element) == "rtl";
};
ASPx.AdjustVerticalMarginsInContainer = function(container) {
 var containerBorderAndPaddings = ASPx.GetTopBottomBordersAndPaddingsSummaryValue(container);
 var flowElements = [], floatElements = [], floatTextElements = [];
 var maxHeight = 0, maxFlowHeight = 0;
 for(var i = 0; i < container.childNodes.length; i++) {
  var element = container.childNodes[i];
  if(!element.offsetHeight) continue;
  ASPx.ClearVerticalMargins(element);
 }
 for(var i = 0; i < container.childNodes.length; i++) {
  var element = container.childNodes[i];
  if(!element.offsetHeight) continue;
  var float = ASPx.GetElementFloat(element);
  var isFloat = (float === "left" || float === "right");
  if(isFloat)
   floatElements.push(element);
  else {
   flowElements.push(element);
   if(element.tagName !== "IMG"){
    if(!ASPx.IsTextWrapped(element))
     element.style.verticalAlign = 'baseline'; 
    floatTextElements.push(element);
   }
   if(element.tagName === "DIV")
    Attr.ChangeStyleAttribute(element, "float", "left"); 
  }
  if(element.offsetHeight > maxHeight) 
   maxHeight = element.offsetHeight;
  if(!isFloat && element.offsetHeight > maxFlowHeight) 
   maxFlowHeight = element.offsetHeight;
 }
 for(var i = 0; i < flowElements.length; i++) 
  Attr.RestoreStyleAttribute(flowElements[i], "float");
 var containerBorderAndPaddings = ASPx.GetTopBottomBordersAndPaddingsSummaryValue(container);
 var containerHeight = container.offsetHeight - containerBorderAndPaddings;
 if(maxHeight == containerHeight) {
  var verticalAlign = ASPx.GetCurrentStyle(container).verticalAlign;
  for(var i = 0; i < floatTextElements.length; i++)
   floatTextElements[i].style.verticalAlign = '';
  containerHeight = container.offsetHeight - containerBorderAndPaddings;
  for(var i = 0; i < floatElements.length; i++)
   adjustVerticalMarginsCore(floatElements[i], containerHeight, verticalAlign, true);
  for(var i = 0; i < flowElements.length; i++) {
   if(maxFlowHeight != maxHeight)
    adjustVerticalMarginsCore(flowElements[i], containerHeight, verticalAlign);
  }
 }
};
ASPx.AdjustVerticalMargins = function(element) {
 ASPx.ClearVerticalMargins(element);
 var parentElement = element.parentNode;
 var parentHeight = parentElement.getBoundingClientRect().height - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(parentElement);
 adjustVerticalMarginsCore(element, parentHeight, ASPx.GetCurrentStyle(parentElement).verticalAlign);
};
function adjustVerticalMarginsCore(element, parentHeight, verticalAlign, toBottom) {
 var marginTop;
 if(verticalAlign == "top")
  marginTop = 0;
 else if(verticalAlign == "bottom")
  marginTop = parentHeight - element.getBoundingClientRect().height;
 else
  marginTop = (parentHeight - element.getBoundingClientRect().height) / 2;
 if(marginTop !== 0){
  element.style.marginTop = marginTop + "px";
 }
}
ASPx.ClearVerticalMargins = function(element) {
 element.style.marginTop = "";
 element.style.marginBottom = "";
};
ASPx.AdjustHeightInContainer = function(container) {
 var height = container.offsetHeight - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(container);
 for(var i = 0; i < container.childNodes.length; i++) {
  var element = container.childNodes[i];
  if(!element.offsetHeight) continue;
  ASPx.ClearHeight(element);
 }
 var elements = [];
 var childrenHeight = 0;
 for(var i = 0; i < container.childNodes.length; i++) {
  var element = container.childNodes[i];
  if(!element.offsetHeight) continue;
  childrenHeight += element.offsetHeight + ASPx.GetTopBottomMargins(element);
  elements.push(element);
 }
 if(elements.length > 0 && childrenHeight < height) {
  var correctedHeight = 0;
  for(var i = 0; i < elements.length; i++) {
   var elementHeight = 0;
   if(i < elements.length - 1){
    var elementHeight = Math.floor(height / elements.length);
    correctedHeight += elementHeight;
   }
   else{
    var elementHeight = height - correctedHeight;
    if(elementHeight < 0) elementHeight = 0;
   }
   adjustHeightCore(elements[i], elementHeight);
  }
 }
};
ASPx.AdjustHeight = function(element) {
 ASPx.ClearHeight(element);
 var parentElement = element.parentNode;
 var height = parentElement.getBoundingClientRect().height - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(parentElement);
 adjustHeightCore(element, height);
};
function adjustHeightCore(element, height) {
 var height = height - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(element);
 if(height < 0) height = 0;
 element.style.height = height + "px";
}
ASPx.ClearHeight = function(element) {
 element.style.height = "";
};
ASPx.ShrinkWrappedTextInContainer = function(container) {
 if(!container) return;
 for(var i = 0; i < container.childNodes.length; i++){
  var child = container.childNodes[i];
  if(child.style && ASPx.IsTextWrapped(child)) {
   Attr.ChangeStyleAttribute(child, "width", "1px");
   child.shrinkedTextContainer = true;
  }
 }
};
ASPx.AdjustWrappedTextInContainer = function(container) {
 if(!container) return;
 var textContainer, leftWidth = 0, rightWidth = 0;
 for(var i = 0; i < container.childNodes.length; i++){
  var child = container.childNodes[i];
  if(child.tagName === "BR")
   return;
  if(!child.tagName)
   continue;
  if(child.tagName !== "IMG"){
   textContainer = child;
   if(ASPx.IsTextWrapped(textContainer)){
    if(!textContainer.shrinkedTextContainer)
     textContainer.style.width = "";
    textContainer.style.marginRight = "";
   }
  }
  else {
   if(child.offsetWidth === 0)
    Evt.AttachEventToElement(child, "load", function(evt) { ASPx.AdjustWrappedTextInContainer(container); });
   else {
    var width = child.offsetWidth + ASPx.GetLeftRightMargins(child);
    if(textContainer)
     rightWidth += width;
    else
     leftWidth += width;
   }
  }
 }
 if(textContainer && ASPx.IsTextWrapped(textContainer)) {
  var containerWidth = container.offsetWidth - ASPx.GetLeftRightBordersAndPaddingsSummaryValue(container);
  if(textContainer.shrinkedTextContainer) {
   Attr.RestoreStyleAttribute(textContainer, "width");
   Attr.ChangeStyleAttribute(container, "width", containerWidth + "px");
  }
  if(textContainer.offsetWidth + leftWidth + rightWidth >= containerWidth) {
    if(rightWidth > 0 && !textContainer.shrinkedTextContainer)
    textContainer.style.width = (containerWidth - rightWidth) + "px";
   else if(leftWidth > 0){
    if(ASPx.IsElementRightToLeft(container))
     textContainer.style.marginLeft = leftWidth + "px";
    else
     textContainer.style.marginRight = leftWidth + "px";
   }
  }
 }
};
ASPx.IsTextWrapped = function(element) {
 return element && ASPx.GetCurrentStyle(element).whiteSpace !== "nowrap";
};
ASPx.IsValidPosition = function(pos){
 return pos != ASPx.InvalidPosition && pos != -ASPx.InvalidPosition;
};
ASPx.getSpriteMainElement = function(element) {
 var cssClassMarker = "dx-acc";
 if(ASPx.ElementContainsCssClass(element, cssClassMarker))
  return element;
 if(element.parentNode && ASPx.ElementContainsCssClass(element.parentNode, cssClassMarker))
  return element.parentNode;
 return element;
};
ASPx.GetAbsoluteX = function(curEl){
 return ASPx.GetAbsolutePositionX(curEl);
};
ASPx.GetAbsoluteY = function(curEl){
 return ASPx.GetAbsolutePositionY(curEl);
};
ASPx.SetAbsoluteX = function(element, x){
 element.style.left = ASPx.PrepareClientPosForElement(x, element, true) + "px";
};
ASPx.SetAbsoluteY = function(element, y){
 element.style.top = ASPx.PrepareClientPosForElement(y, element, false) + "px";
};
ASPx.GetAbsolutePositionX = function(element){
 if(Browser.IE)
  return getAbsolutePositionX_IE(element);
 else if(Browser.Firefox && Browser.Version >= 3)
  return getAbsolutePositionX_FF3(element);
 else if(Browser.Opera)
  return getAbsolutePositionX_Opera(element);
 else if(Browser.NetscapeFamily && (!Browser.Firefox || Browser.Version < 3))
  return getAbsolutePositionX_NS(element);
 else if(Browser.WebKitFamily && Browser.WebKitTouchUI)
  return getAbsolutePositionX_Opera(element);
 else if(Browser.WebKitFamily || Browser.Edge)
  return getAbsolutePositionX_FF3(element);
 else
  return getAbsolutePositionX_Other(element);
};
function getAbsolutePositionX_Opera(curEl){
 var isFirstCycle = true;
 var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
 while(curEl != null) {
  pos += curEl.offsetLeft;
  if(!isFirstCycle)
   pos -= curEl.scrollLeft;
  curEl = curEl.offsetParent;
  isFirstCycle = false;
 }
 pos += document.body.scrollLeft;
 return pos;
}
function getAbsolutePositionX_IE(element){
 if(element == null || Browser.IE && element.parentNode == null) return 0; 
 return element.getBoundingClientRect().left + ASPx.GetDocumentScrollLeft();
}
function getAbsolutePositionX_FF3(element){
 if(element == null) return 0;
 var x = element.getBoundingClientRect().left + ASPx.GetDocumentScrollLeft();
 return Math.round(x);
}
function getAbsolutePositionX_NS(curEl){
 var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
 var isFirstCycle = true;
 while(curEl != null) {
  pos += curEl.offsetLeft;
  if(!isFirstCycle && curEl.offsetParent != null)
   pos -= curEl.scrollLeft;
  if(!isFirstCycle && Browser.Firefox){
   var style = ASPx.GetCurrentStyle(curEl);
   if(curEl.tagName == "DIV" && style.overflow != "visible")
    pos += ASPx.PxToInt(style.borderLeftWidth);
  }
  isFirstCycle = false;
  curEl = curEl.offsetParent;
 }
 return pos;
}
function getAbsolutePositionX_Other(curEl){
 var pos = 0;
 var isFirstCycle = true;
 while(curEl != null) {
  pos += curEl.offsetLeft;
  if(!isFirstCycle && curEl.offsetParent != null)
   pos -= curEl.scrollLeft;
  isFirstCycle = false;
  curEl = curEl.offsetParent;
 }
 return pos;
}
ASPx.GetAbsolutePositionY = function(element){
 if(Browser.IE)
  return getAbsolutePositionY_IE(element);
 else if(Browser.Firefox && Browser.Version >= 3)
  return getAbsolutePositionY_FF3(element);
 else if(Browser.Opera)
  return getAbsolutePositionY_Opera(element);
 else if(Browser.NetscapeFamily && (!Browser.Firefox || Browser.Version < 3))
  return getAbsolutePositionY_NS(element);
 else if(Browser.WebKitFamily && Browser.WebKitTouchUI)
  return getAbsolutePositionY_Opera(element);
 else if(Browser.WebKitFamily || Browser.Edge)
  return getAbsolutePositionY_FF3(element);
 else
  return getAbsolutePositionY_Other(element);
};
function getAbsolutePositionY_Opera(curEl){
 var isFirstCycle = true;
 if(curEl && curEl.tagName == "TR" && curEl.cells.length > 0)
  curEl = curEl.cells[0];
 var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
 while(curEl != null) {
  pos += curEl.offsetTop;
  if(!isFirstCycle)
   pos -= curEl.scrollTop;
  curEl = curEl.offsetParent;
  isFirstCycle = false;
 }
 pos += document.body.scrollTop;
 return pos;
}
function getAbsolutePositionY_IE(element){
 if(element == null || Browser.IE && element.parentNode == null) return 0; 
 return element.getBoundingClientRect().top + ASPx.GetDocumentScrollTop();
}
function getAbsolutePositionY_FF3(element){
 if(element == null) return 0;
 var y = element.getBoundingClientRect().top + ASPx.GetDocumentScrollTop();
 return Math.round(y);
}
function getAbsolutePositionY_NS(curEl){
 var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
 var isFirstCycle = true;
 while(curEl != null) {
  pos += curEl.offsetTop;
  if(!isFirstCycle && curEl.offsetParent != null)
   pos -= curEl.scrollTop;
  if(!isFirstCycle && Browser.Firefox){
   var style = ASPx.GetCurrentStyle(curEl);
   if(curEl.tagName == "DIV" && style.overflow != "visible")
    pos += ASPx.PxToInt(style.borderTopWidth);
  }
  isFirstCycle = false;
  curEl = curEl.offsetParent;
 }
 return pos;
}
function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
 var pos = 0;   
 var isFirstCycle = true;
 while(curEl != null) {
  if(curEl.tagName == "BODY")
   break;
  var style = ASPx.GetCurrentStyle(curEl);
  if(style.position == "absolute")
   break;
  if(!isFirstCycle && curEl.tagName == "DIV" && (style.position == "" || style.position == "static"))
   pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
  curEl = curEl.parentNode;
  isFirstCycle = false;
 }
 return pos; 
}
function getAbsolutePositionY_Other(curEl){
 var pos = 0;
 var isFirstCycle = true;
 while(curEl != null) {
  pos += curEl.offsetTop;
  if(!isFirstCycle && curEl.offsetParent != null)
   pos -= curEl.scrollTop;
  isFirstCycle = false;
  curEl = curEl.offsetParent;
 }
 return pos;
}
function createElementMock(element) {
 var div = document.createElement('DIV');
 div.style.top = "0px";
 div.style.left = "0px";
 div.visibility = "hidden";
 div.style.position = ASPx.GetCurrentStyle(element).position;
 return div;
}
ASPx.PrepareClientPosElementForOtherParent = function(pos, element, otherParent, isX) {
 if(element.parentNode == otherParent)
  return ASPx.PrepareClientPosForElement(pos, element, isX);
 var elementMock = createElementMock(element);
 otherParent.appendChild(elementMock); 
 var preparedPos = ASPx.PrepareClientPosForElement(pos, elementMock, isX);
 otherParent.removeChild(elementMock);
 return preparedPos;
};
ASPx.PrepareClientPosForElement = function(pos, element, isX) {
 pos -= ASPx.GetPositionElementOffset(element, isX);
 return pos;
};
function getExperimentalPositionOffset(element, isX) {
 var div = createElementMock(element);
 if(div.style.position == "static")
  div.style.position = "absolute";
 element.parentNode.appendChild(div); 
 var realPos = isX ? ASPx.GetAbsoluteX(div) : ASPx.GetAbsoluteY(div);
 element.parentNode.removeChild(div);
 return Math.round(realPos);
}
ASPx.GetPositionElementOffset = function(element, isX) {
 return getExperimentalPositionOffset(element, isX);
};
ASPx.GetSizeOfText = function(text, textCss) {
 var testContainer = document.createElement("tester");
 var defaultLineHeight = ASPx.Browser.Firefox ? "1" : "";
 testContainer.style.fontSize = textCss.fontSize;
 testContainer.style.fontFamily = textCss.fontFamily;
 testContainer.style.fontWeight = textCss.fontWeight;
 testContainer.style.letterSpacing = textCss.letterSpacing;
 testContainer.style.lineHeight = textCss.lineHeight || defaultLineHeight;
 testContainer.style.position = "absolute";
 testContainer.style.top = ASPx.InvalidPosition + "px";
 testContainer.style.left = ASPx.InvalidPosition + "px";
 testContainer.style.width = "auto";
 testContainer.style.whiteSpace = "nowrap";
 testContainer.appendChild(document.createTextNode(text));
 var testElement = document.body.appendChild(testContainer);
 var size = {
  "width": testElement.offsetWidth,
  "height": testElement.offsetHeight
 };
 document.body.removeChild(testElement);
 return size;
};
ASPx.PointToPixel = function(points, addPx) {  
 var result = 0;
 try {
  var indexOfPt = points.toLowerCase().indexOf("pt");
  if(indexOfPt > -1)
   result = parseInt(points.substr(0, indexOfPt)) * 96 / 72;
  else
   result = parseInt(points) * 96 / 72;
  if(addPx)
   result = result + "px";
 } catch(e) {}
 return result;
};
ASPx.PixelToPoint = function(pixels, addPt) { 
 var result = 0;
 try {
  var indexOfPx = pixels.toLowerCase().indexOf("px");
  if(indexOfPx > -1)
   result = parseInt(pixels.substr(0, indexOfPx)) * 72 / 96;
  else
   result = parseInt(pixels) * 72 / 96;
  if(addPt)
   result = result + "pt";
 } catch(e) {}
 return result;         
};
ASPx.PxToInt = function(px) {
 return pxToNumber(px, parseInt);
};
ASPx.PxToFloat = function(px) {
 return pxToNumber(px, parseFloat);
};
function pxToNumber(px, parseFunction) {
 var result = 0;
 if(px != null && px != "") {
  try {
   var indexOfPx = px.indexOf("px");
   if(indexOfPx > -1)
    result = parseFunction(px.substr(0, indexOfPx));
  } catch(e) { }
 }
 return result;
}
ASPx.PercentageToFloat = function(perc) {
 var result = 0;
 if(perc != null && perc != "") {
  try {
   var indexOfPerc = perc.indexOf("%");
   if(indexOfPerc > -1)
    result = parseFloat(perc.substr(0, indexOfPerc)) / 100;
  } catch(e) { }
 }
 return result;
};
ASPx.CreateGuid = function() {
 return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) { 
   var r = Math.random()*16|0,v=c=='x'?r:r&0x3|0x8;
  return v.toString(16);
 });
};
ASPx.GetLeftRightBordersAndPaddingsSummaryValue = function(element, currentStyle) {
 return ASPx.GetLeftRightPaddings(element, currentStyle) + ASPx.GetHorizontalBordersWidth(element, currentStyle);
};
ASPx.GetTopBottomBordersAndPaddingsSummaryValue = function(element, currentStyle) {
 return ASPx.GetTopBottomPaddings(element, currentStyle) + ASPx.GetVerticalBordersWidth(element, currentStyle);
};
ASPx.GetVerticalBordersWidth = function(element, style) {
 if(!ASPx.IsExists(style))
  style = (Browser.IE && Browser.MajorVersion != 9 && window.getComputedStyle) ? window.getComputedStyle(element) : ASPx.GetCurrentStyle(element);
 var res = 0;
 if(style.borderTopStyle != "none") {
  res += ASPx.PxToFloat(style.borderTopWidth);
  if(Browser.IE && Browser.MajorVersion < 9)
   res += getIe8BorderWidthFromText(style.borderTopWidth);
 }
 if(style.borderBottomStyle != "none") {
  res += ASPx.PxToFloat(style.borderBottomWidth);
  if(Browser.IE && Browser.MajorVersion < 9)
   res += getIe8BorderWidthFromText(style.borderBottomWidth);
 }
 return res;
};
ASPx.GetHorizontalBordersWidth = function(element, style) {
 if(!ASPx.IsExists(style))
  style = (Browser.IE && window.getComputedStyle) ? window.getComputedStyle(element) : ASPx.GetCurrentStyle(element);
 var res = 0;
 if(style.borderLeftStyle != "none") {
  res += ASPx.PxToFloat(style.borderLeftWidth);
  if(Browser.IE && Browser.MajorVersion < 9)
   res += getIe8BorderWidthFromText(style.borderLeftWidth);
 }
 if(style.borderRightStyle != "none") {
  res += ASPx.PxToFloat(style.borderRightWidth);
  if(Browser.IE && Browser.MajorVersion < 9)
   res += getIe8BorderWidthFromText(style.borderRightWidth);
 }
 return res;
};
function getIe8BorderWidthFromText(textWidth) {
 var availableWidth = { "thin": 1, "medium" : 3, "thick": 5 };
 var width = availableWidth[textWidth];
 return width ? width : 0;
}
ASPx.GetTopBottomPaddings = function(element, style) {
 var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
 return ASPx.PxToInt(currentStyle.paddingTop) + ASPx.PxToInt(currentStyle.paddingBottom);
};
ASPx.GetLeftRightPaddings = function(element, style) {
 var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
 return ASPx.PxToInt(currentStyle.paddingLeft) + ASPx.PxToInt(currentStyle.paddingRight);
};
ASPx.GetTopBottomMargins = function(element, style) {
 var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
 return ASPx.PxToInt(currentStyle.marginTop) + ASPx.PxToInt(currentStyle.marginBottom);
};
ASPx.GetLeftRightMargins = function(element, style) {
 var currentStyle = style ? style : ASPx.GetCurrentStyle(element);
 return ASPx.PxToInt(currentStyle.marginLeft) + ASPx.PxToInt(currentStyle.marginRight);
};
ASPx.GetClearClientWidth = function(element) {
 return element.offsetWidth - ASPx.GetLeftRightBordersAndPaddingsSummaryValue(element);
};
ASPx.GetClearClientHeight = function(element) {
 return element.offsetHeight - ASPx.GetTopBottomBordersAndPaddingsSummaryValue(element);
};
ASPx.SetOffsetWidth = function(element, widthValue, currentStyle) {
 if(!ASPx.IsExists(currentStyle))
  currentStyle = ASPx.GetCurrentStyle(element);
 var value = widthValue - ASPx.PxToInt(currentStyle.marginLeft) - ASPx.PxToInt(currentStyle.marginRight);
  value -= ASPx.GetLeftRightBordersAndPaddingsSummaryValue(element, currentStyle);
 if(value > -1)
  element.style.width = value + "px";
};
ASPx.SetOffsetHeight = function(element, heightValue, currentStyle) {
 if(!ASPx.IsExists(currentStyle))
  currentStyle = ASPx.GetCurrentStyle(element);
 var value = heightValue - ASPx.PxToInt(currentStyle.marginTop) - ASPx.PxToInt(currentStyle.marginBottom);
  value -= ASPx.GetTopBottomBordersAndPaddingsSummaryValue(element, currentStyle);
 if(value > -1)
  element.style.height = value + "px";
};
ASPx.FindOffsetParent = function(element) {
 var currentElement = element.parentNode;
 while(ASPx.IsExistsElement(currentElement) && currentElement.tagName != "BODY") {
  if(currentElement.offsetWidth > 0 && currentElement.offsetHeight > 0)
   return currentElement;
  currentElement = currentElement.parentNode;
 }
 return document.body;
};
ASPx.GetDocumentScrollTop = function(){
 var isScrollBodyIE = Browser.IE && ASPx.GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollTop > 0;
 if(Browser.WebKitFamily || Browser.Edge || isScrollBodyIE) {
  if(Browser.MacOSMobilePlatform) 
   return window.pageYOffset;
  if(Browser.WebKitFamily)
   return document.documentElement.scrollTop || document.body.scrollTop;
  return document.body.scrollTop;
 }
 else
  return document.documentElement.scrollTop;
};
ASPx.SetDocumentScrollTop = function(scrollTop) {
 if(Browser.WebKitFamily && Browser.Version < 60 || Browser.Edge)
  document.body.scrollTop = scrollTop;
 else
  document.documentElement.scrollTop = scrollTop;
};
ASPx.GetDocumentScrollLeft = function(){
 var isScrollBodyIE = Browser.IE && ASPx.GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollLeft > 0;
 if(Browser.Edge || isScrollBodyIE || Browser.Opera)
  return document.body.scrollLeft;
 if(Browser.WebKitFamily)
  return document.documentElement.scrollLeft || document.body.scrollLeft;
 return document.documentElement.scrollLeft;
};
ASPx.SetDocumentScrollLeft = function (scrollLeft) {
 if(Browser.WebKitFamily && Browser.Version < 60 || Browser.Edge)
  document.body.scrollLeft = scrollLeft;
 else
  document.documentElement.scrollLeft = scrollLeft;
};
ASPx.GetDocumentClientWidth = function(){
 if(document.documentElement.clientWidth == 0)
  return document.body.clientWidth;
 else
  return document.documentElement.clientWidth;
};
ASPx.GetDocumentClientHeight = function() {
 if(Browser.Firefox && window.innerHeight - document.documentElement.clientHeight > ASPx.GetVerticalScrollBarWidth()) {
  return window.innerHeight;
 } else if(Browser.Opera && Browser.Version < 9.6 || document.documentElement.clientHeight == 0) {
   return document.body.clientHeight;
 }
 return document.documentElement.clientHeight;
};
ASPx.GetDocumentWidth = function(){
 var bodyWidth = document.body.offsetWidth;
 var docWidth = Browser.IE ? document.documentElement.clientWidth : document.documentElement.offsetWidth;
 var bodyScrollWidth = document.body.scrollWidth;
 var docScrollWidth = document.documentElement.scrollWidth;
 return getMaxDimensionOf(bodyWidth, docWidth, bodyScrollWidth, docScrollWidth);
};
ASPx.GetDocumentHeight = function(){
 var bodyHeight = document.body.offsetHeight;
 var docHeight = Browser.IE ? document.documentElement.clientHeight : document.documentElement.offsetHeight;
 var bodyScrollHeight = document.body.scrollHeight;
 var docScrollHeight = document.documentElement.scrollHeight;
 var maxHeight = getMaxDimensionOf(bodyHeight, docHeight, bodyScrollHeight, docScrollHeight);
 if(Browser.Opera && Browser.Version >= 9.6){
  if(Browser.Version < 10)
   maxHeight = getMaxDimensionOf(bodyHeight, docHeight, bodyScrollHeight);
  var visibleHeightOfDocument = document.documentElement.clientHeight;
  if(maxHeight > visibleHeightOfDocument)
   maxHeight = getMaxDimensionOf(window.outerHeight, maxHeight);
  else
   maxHeight = document.documentElement.clientHeight;
  return maxHeight;
 }
 return maxHeight;
};
ASPx.GetDocumentMaxClientWidth = function(){
 var bodyWidth = document.body.offsetWidth;
 var docWidth = document.documentElement.offsetWidth;
 var docClientWidth = document.documentElement.clientWidth;
 return getMaxDimensionOf(bodyWidth, docWidth, docClientWidth);
};
ASPx.GetDocumentMaxClientHeight = function(){
 var bodyHeight = document.body.offsetHeight;
 var docHeight = document.documentElement.offsetHeight;
 var docClientHeight = document.documentElement.clientHeight;
 return getMaxDimensionOf(bodyHeight, docHeight, docClientHeight);
};
ASPx.verticalScrollIsNotHidden = null;
ASPx.horizontalScrollIsNotHidden = null;
ASPx.GetVerticalScrollIsNotHidden = function() {
 if(!ASPx.IsExists(ASPx.verticalScrollIsNotHidden))
  ASPx.verticalScrollIsNotHidden = ASPx.GetCurrentStyle(document.body).overflowY !== "hidden"
   && ASPx.GetCurrentStyle(document.documentElement).overflowY !== "hidden";
 return ASPx.verticalScrollIsNotHidden;
};
ASPx.GetHorizontalScrollIsNotHidden = function() {
 if(!ASPx.IsExists(ASPx.horizontalScrollIsNotHidden))
  ASPx.horizontalScrollIsNotHidden = ASPx.GetCurrentStyle(document.body).overflowX !== "hidden"
   && ASPx.GetCurrentStyle(document.documentElement).overflowX !== "hidden";
 return ASPx.horizontalScrollIsNotHidden;
};
ASPx.GetCurrentDocumentWidth = function() {
 var result = ASPx.GetDocumentClientWidth();
 if(!ASPx.Browser.Safari && ASPx.GetVerticalScrollIsNotHidden() && ASPx.GetDocumentHeight() > ASPx.GetDocumentClientHeight())
  result += ASPx.GetVerticalScrollBarWidth();
 return result;
};
ASPx.GetCurrentDocumentHeight = function() {
 var result = ASPx.GetDocumentClientHeight();
 if(!ASPx.Browser.Safari && ASPx.GetHorizontalScrollIsNotHidden() && ASPx.GetDocumentWidth() > ASPx.GetDocumentClientWidth())
  result += ASPx.GetVerticalScrollBarWidth();
 return result;
};
function getMaxDimensionOf(){
 var max = ASPx.InvalidDimension;
 for(var i = 0; i < arguments.length; i++){
  if(max < arguments[i])
   max = arguments[i];
 }
 return max;
}
ASPx.GetClientLeft = function(element){
 return ASPx.IsExists(element.clientLeft) ? element.clientLeft : (element.offsetWidth - element.clientWidth) / 2;
};
ASPx.GetClientTop = function(element){
 return ASPx.IsExists(element.clientTop) ? element.clientTop : (element.offsetHeight - element.clientHeight) / 2;
};
ASPx.SetStyles = function(element, styles, makeImportant) {
 if(ASPx.IsExists(styles.cssText))
  element.style.cssText = styles.cssText;
 if(ASPx.IsExists(styles.className))
  element.className = styles.className;
 for(var property in styles) {
  if(!styles.hasOwnProperty(property))
   continue;
  var value = styles[property];
  switch (property) {
   case "cssText":
   case "className":
    break;
   case "float":
    ASPx.SetElementFloat(element, value);
    break;
   case "opacity":
    ASPx.SetElementOpacity(element, value);
    break;
   case "zIndex":
    ASPx.SetStylesCore(element, property, value, makeImportant);
    break;
   case "fontWeight":
    if(ASPx.Browser.IE && ASPx.Browser.Version < 9 && typeof(styles[property]) == "number")
     value = styles[property].toString();
   default:
    ASPx.SetStylesCore(element, property, value + (typeof (value) == "number" ? "px" : ""), makeImportant);
  }
 }
};
ASPx.SetStylesCore = function(element, property, value, makeImportant) {
 if(makeImportant) {
  var index = property.search("[A-Z]");
  if(index != -1)
   property = property.replace(property.charAt(index), "-" + property.charAt(index).toLowerCase());
  if(element.style.setProperty)
   element.style.setProperty(property, value, "important");
  else 
   element.style.cssText += ";" + property + ":" + value + "!important";
 }
 else
  element.style[property] = value;
};
ASPx.RemoveBordersAndShadows = function(el) {
 if(!el || !el.style)
  return;
 el.style.borderWidth = 0;
 if(ASPx.IsExists(el.style.boxShadow))
  el.style.boxShadow = "none";
 else if(ASPx.IsExists(el.style.MozBoxShadow))
  el.style.MozBoxShadow = "none";
 else if(ASPx.IsExists(el.style.webkitBoxShadow))
  el.style.webkitBoxShadow = "none";
};
ASPx.GetCellSpacing = function(element) {
 var val = parseInt(element.cellSpacing);
 if(!isNaN(val)) return val;
 val = parseInt(ASPx.GetCurrentStyle(element).borderSpacing);
 if(!isNaN(val)) return val;
 return 0;
};
ASPx.GetInnerScrollPositions = function(element) {
 var scrolls = [];
 getInnerScrollPositionsCore(element, scrolls);
 return scrolls;
};
function getInnerScrollPositionsCore(element, scrolls) {
 for(var child = element.firstChild; child; child = child.nextSibling) {
  var scrollTop = child.scrollTop,
   scrollLeft = child.scrollLeft;
  if(scrollTop > 0 || scrollLeft > 0)
   scrolls.push([child, scrollTop, scrollLeft]);
  getInnerScrollPositionsCore(child, scrolls);
 }
}
ASPx.RestoreInnerScrollPositions = function(scrolls) {
 for(var i = 0, scrollArr; scrollArr = scrolls[i]; i++) {
  if(scrollArr[1] > 0)
   scrollArr[0].scrollTop = scrollArr[1];
  if(scrollArr[2] > 0)
   scrollArr[0].scrollLeft = scrollArr[2];
 }
};
ASPx.GetOuterScrollPosition = function(element) {
 while(element.tagName !== "BODY") {
  var scrollTop = element.scrollTop,
   scrollLeft = element.scrollLeft;
  if(scrollTop > 0 || scrollLeft > 0) {
   return {
    scrollTop: scrollTop,
    scrollLeft: scrollLeft,
    element: element
   };
  }
  element = element.parentNode;
 }
 return {
  scrollTop: ASPx.GetDocumentScrollTop(),
  scrollLeft: ASPx.GetDocumentScrollLeft()
 };
};
ASPx.RestoreOuterScrollPosition = function(scrollInfo) {
 if(scrollInfo.element) {
  if(scrollInfo.scrollTop > 0)
   scrollInfo.element.scrollTop = scrollInfo.scrollTop;
  if(scrollInfo.scrollLeft > 0)
   scrollInfo.element.scrollLeft = scrollInfo.scrollLeft;
 }
 else {
  if(scrollInfo.scrollTop > 0)
   ASPx.SetDocumentScrollTop(scrollInfo.scrollTop);
  if(scrollInfo.scrollLeft > 0)
   ASPx.SetDocumentScrollLeft(scrollInfo.scrollLeft);
 }
};
ASPx.ChangeElementContainer = function(element, container, savePreviousContainer) {
 if(element.parentNode != container) {
  var parentNode = element.parentNode;
  parentNode.removeChild(element);
  container.appendChild(element);
  if(savePreviousContainer)
   element.previousContainer = parentNode;
 }
};
ASPx.RestoreElementContainer = function(element) {
 if(element.previousContainer) {
  ASPx.ChangeElementContainer(element, element.previousContainer, false);
  element.previousContainer = null;
 }
};
ASPx.MoveChildrenToElement = function(sourceElement, destinationElement){
 while(sourceElement.childNodes.length > 0)
  destinationElement.appendChild(sourceElement.childNodes[0]);
};
ASPx.GetScriptCode = function(script) {
 var useFirstChildElement = Browser.Chrome && Browser.Version < 11 || Browser.Safari && Browser.Version < 5; 
 var text = useFirstChildElement ? script.firstChild.data : script.text;
 var comment = "<!--";
 var pos = text.indexOf(comment);
 if(pos > -1)
  text = text.substr(pos + comment.length);
 return text;
};
ASPx.AppendScript = function(script) {
 var parent = document.getElementsByTagName("head")[0];
 if(!parent)
  parent = document.body;
 if(parent)
  parent.appendChild(script);
};
function getFrame(frames, name) {
 if(frames[name])
  return frames[name];
 for(var i = 0; i < frames.length; i++) {
  try {
   var frame = frames[i];
   if(frame.name == name) 
    return frame; 
   frame = getFrame(frame.frames, name);
   if(frame != null)   
    return frame; 
  } catch(e) {
  } 
 }
 return null;
}
ASPx.IsValidElement = function(element) {
 if(!element) 
  return false;
 if(!(Browser.Firefox && Browser.Version < 4)) {
  if(element.ownerDocument && element.ownerDocument.body && element.ownerDocument.body.compareDocumentPosition)
   return element.ownerDocument.body.compareDocumentPosition(element) % 2 === 0;
 }
 if(!Browser.Opera && !(Browser.IE && Browser.Version < 9) && element.offsetParent && element.parentNode.tagName)
  return true;
 while(element != null){
  if(element.tagName == "BODY")
   return true;
  element = element.parentNode;
 }
 return false;
};
ASPx.IsValidElements = function(elements) {
 if(!elements)
  return false; 
 for(var i = 0; i < elements.length; i++) {
  if(elements[i] && !ASPx.IsValidElement(elements[i]))
   return false;
 }
 return true;
};
ASPx.IsExistsElement = function(element) {
 return element && ASPx.IsValidElement(element);
};
ASPx.CreateHtmlElementFromString = function(str) {
 var dummy = ASPx.CreateHtmlElement();
 dummy.innerHTML = str;
 return dummy.firstChild;
};
ASPx.CreateHtmlElement = function(tagName, styles) {
 var element = document.createElement(tagName || "DIV");
 if(styles)
  ASPx.SetStyles(element, styles);
 return element;
};
ASPx.RestoreElementOriginalWidth = function(element) {
 if(!ASPx.IsExistsElement(element)) 
  return;
 element.style.width = element.dxOrigWidth = ASPx.GetElementOriginalWidth(element);
};
ASPx.GetElementOriginalWidth = function(element) {
 if(!ASPx.IsExistsElement(element)) 
  return null;
 var width;
 if(!ASPx.IsExists(element.dxOrigWidth)) {
   width = String(element.style.width).length > 0
  ? element.style.width
  : element.offsetWidth + "px";
 } else {
  width = element.dxOrigWidth;
 }
 return width;
};
ASPx.DropElementOriginalWidth = function(element) {
 if(ASPx.IsExists(element.dxOrigWidth))
  element.dxOrigWidth = null;
};
ASPx.GetObjectKeys = function(obj) {
 if(!obj) return [ ];
 if(Object.keys)
  return Object.keys(obj);
 var keys = [ ];
 for(var key in obj) {
  if(obj.hasOwnProperty(key))
   keys.push(key);
 }
 return keys;
};
ASPx.ShowErrorAlert = function(message) {
 message = ASPx.Str.DecodeHtmlViaTextArea(message);
 if(ASPx.IsExists(message) && message !== "")
  alert(message);
};
ASPx.ShowKBErrorMessage = function(text, kbid) {
 ASPx.ShowErrorMessage(text + "https://www.devexpress.com/kbid=" + kbid + ".");
};
ASPx.ShowErrorMessage = function(errorMessage) {
 var console = window.console;
 if(!console || !ASPx.IsFunction(console.error))
  return;
 console.error(errorMessage);
};
ASPx.IsInteractiveControl = function(element, extremeParent) { 
 return Data.ArrayIndexOf(["A", "INPUT", "SELECT", "OPTION", "TEXTAREA", "BUTTON", "IFRAME"], element.tagName) > -1;
};
ASPx.IsUrlContainsClientScript = function(url) {
 return url.toLowerCase().indexOf("javascript:") !== -1;
};
Function.prototype.aspxBind = function(scope) {
 var func = this;
 return function() {
  return func.apply(scope, arguments);
 };
};
var FilteringUtils = { };
FilteringUtils.EventKeyCodeChangesTheInput = function(evt) {
 if(ASPx.IsPasteShortcut(evt))
  return true;
 else if(evt.ctrlKey && !evt.altKey)
  return false;
 if(ASPx.Browser.AndroidMobilePlatform || ASPx.Browser.MacOSMobilePlatform) return true; 
 var keyCode = ASPx.Evt.GetKeyCode(evt);
 var isSystemKey = ASPx.Key.Windows <= keyCode && keyCode <= ASPx.Key.ContextMenu;
 var isFKey = ASPx.Key.F1 <= keyCode && keyCode <= 127; 
 return ASPx.Key.Delete <= keyCode && !isSystemKey && !isFKey || keyCode == ASPx.Key.Backspace || keyCode == ASPx.Key.Space;
};
FilteringUtils.FormatCallbackArg = function(prefix, arg) {
 return (ASPx.IsExists(arg) ? prefix + "|" + arg.length + ';' + arg + ';' : "");
};
ASPx.FilteringUtils = FilteringUtils;
var FormatStringHelper = { };
FormatStringHelper.PlaceHolderTemplateStruct = function(startIndex, length, index, placeHolderString){
 this.startIndex = startIndex;
 this.realStartIndex = 0;
 this.length = length;
 this.realLength = 0;
 this.index = index;
 this.placeHolderString = placeHolderString;
};
FormatStringHelper.GetPlaceHolderTemplates = function(formatString){
 formatString = this.CollapseDoubleBrackets(formatString);
 var templates = this.CreatePlaceHolderTemplates(formatString);
 return templates;
};
FormatStringHelper.CreatePlaceHolderTemplates = function(formatString){
 var templates = [];
 var templateStrings = formatString.match(/{[^}]+}/g);
 if(templateStrings != null){
  var pos = 0;
  for(var i = 0; i < templateStrings.length; i++){
   var tempString = templateStrings[i];
   var startIndex = formatString.indexOf(tempString, pos);
   var length = tempString.length;
   var indexString = tempString.slice(1).match(/^[0-9]+/);
   var index = parseInt(indexString);
   templates.push(new this.PlaceHolderTemplateStruct(startIndex, length, index, tempString));
   pos = startIndex + length;
  }
 }
 return templates;
};
FormatStringHelper.CollapseDoubleBrackets = function(formatString){
 formatString = this.CollapseOpenDoubleBrackets(formatString);
 formatString = this.CollapseCloseDoubleBrackets(formatString);
 return formatString;
};
FormatStringHelper.CollapseOpenDoubleBrackets = function(formatString){
 return formatString.replace(/{{/g, "_");
};
FormatStringHelper.CollapseCloseDoubleBrackets = function(formatString){
 while(true){
  var index = formatString.lastIndexOf("}}");
  if(index == -1) 
   break;
  else
   formatString = formatString.substr(0, index) + "_" + formatString.substr(index + 2);
 }
 return formatString;
};
ASPx.FormatStringHelper = FormatStringHelper;
var StartWithFilteringUtils = { };
StartWithFilteringUtils.HighlightSuggestedText = function(input, suggestedText, control){
 if(this.NeedToLockAndoidKeyEvents(control))
  control.LockAndroidKeyEvents();
 var selInfo = ASPx.Selection.GetInfo(input);
 var currentTextLenght = ASPx.Str.GetCoincideCharCount(suggestedText, input.value, 
  function(text, filter) { 
   return text.indexOf(filter) == 0;
  });
 var suggestedTextLenght = suggestedText.length;
 var isSelected = selInfo.startPos == 0 && selInfo.endPos == currentTextLenght && 
  selInfo.endPos == suggestedTextLenght && input.value == suggestedText;
 if(!isSelected) { 
  input.value = suggestedText;
  if(this.NeedToLockAndoidKeyEvents(control)) {
   window.setTimeout(function() {
    this.SelectText(input, currentTextLenght, suggestedTextLenght);
    control.UnlockAndroidKeyEvents();
   }.aspxBind(this), control.adroidSamsungBugTimeout);
  } else
   this.SelectText(input, currentTextLenght, suggestedTextLenght);
 }
};
StartWithFilteringUtils.SelectText = function(input, startPos, stopPos) {
 if(startPos < stopPos)
  ASPx.Selection.Set(input, startPos, stopPos);
};
StartWithFilteringUtils.RollbackOneSuggestedChar = function(input){
 var currentText = input.value;
 var cutText = currentText.slice(0, -1);
 if(cutText != currentText)
  input.value = cutText;
};
StartWithFilteringUtils.NeedToLockAndoidKeyEvents = function(control) {
 return ASPx.Browser.AndroidMobilePlatform && control && control.LockAndroidKeyEvents;
};
ASPx.StartWithFilteringUtils = StartWithFilteringUtils;
var ContainsFilteringUtils = { };
ContainsFilteringUtils.ColumnSelectionStruct = function(index, startIndex, length){
 this.index = index;
 this.length = length;
 this.startIndex = startIndex;
};
ContainsFilteringUtils.IsFilterCrossPlaseHolder = function(filterStartIndex, filterEndIndex, template) {
 var left = Math.max(filterStartIndex, template.realStartIndex);
 var right = Math.min(filterEndIndex,  template.realStartIndex + template.realLength);
 return left < right;
};
ContainsFilteringUtils.GetColumnSelectionsForItem = function(itemValues, formatString, filterString) {
 if(formatString == "") 
  return this.GetSelectionForSingleColumnItem(itemValues, filterString); 
 var result = [];
 var formatedString = ASPx.Formatter.Format(formatString, itemValues);
 var filterStartIndex = ASPx.Str.PrepareStringForFilter(formatedString).indexOf(ASPx.Str.PrepareStringForFilter(filterString));
 if(filterStartIndex == -1) return result;
 var filterEndIndex = filterStartIndex + filterString.length;
 var templates = FormatStringHelper.GetPlaceHolderTemplates(formatString);
 this.SupplyTemplatesWithRealValues(itemValues, templates);
 for(var i = 0; i < templates.length ; i++) {
  if(this.IsFilterCrossPlaseHolder(filterStartIndex, filterEndIndex, templates[i])) 
   result.push(this.GetColumnSelectionsForItemValue(templates[i], filterStartIndex, filterEndIndex));
 }
 return result;
};
ContainsFilteringUtils.GetColumnSelectionsForItemValue = function(template, filterStartIndex, filterEndIndex) {
 var selectedTextStartIndex = filterStartIndex < template.realStartIndex ? 0 :
  filterStartIndex - template.realStartIndex;
 var selectedTextEndIndex = filterEndIndex >  template.realStartIndex + template.realLength ? template.realLength :
  filterEndIndex - template.realStartIndex;
 var selectedTextLength = selectedTextEndIndex - selectedTextStartIndex;
 return new this.ColumnSelectionStruct(template.index, selectedTextStartIndex, selectedTextLength);
};
ContainsFilteringUtils.GetSelectionForSingleColumnItem = function(itemValues, filterString) {
 var selectedTextStartIndex = ASPx.Str.PrepareStringForFilter(itemValues[0]).indexOf(ASPx.Str.PrepareStringForFilter(filterString));
 var selectedTextLength = filterString.length;
 return [new this.ColumnSelectionStruct(0, selectedTextStartIndex, selectedTextLength)];
};
ContainsFilteringUtils.ResetFormatStringIndex = function(formatString, index) {
 if(index != 0)
  return formatString.replace(index.toString(), "0");
 return formatString;
};
ContainsFilteringUtils.SupplyTemplatesWithRealValues = function(itemValues, templates) {
 var shift = 0;
 for(var i = 0; i < templates.length; i++) {
  var formatString = this.ResetFormatStringIndex(templates[i].placeHolderString, templates[i].index);
  var currentItemValue = itemValues[templates[i].index];
  templates[i].realLength = ASPx.Formatter.Format(formatString, currentItemValue).length;
  templates[i].realStartIndex  += templates[i].startIndex + shift; 
  shift += templates[i].realLength - templates[i].placeHolderString.length; 
 }
};
ContainsFilteringUtils.PrepareElementText = function(itemText) {
 return itemText ? itemText.replace(/\&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;") : '';
};
ContainsFilteringUtils.UnselectContainsTextInElement = function(element, selection, highlightTagName) {
 var currentText =  ASPx.Attr.GetAttribute (element, "DXText");
 if(ASPx.IsExists(currentText)) {
  currentText = ContainsFilteringUtils.PrepareElementText(currentText);
  ASPx.SetInnerHtml(element, currentText === "" ? "&nbsp;" : currentText);
 }
};
ContainsFilteringUtils.ReselectContainsTextInElement = function(element, selection, highlightTagName) {
 var currentText = ASPx.GetInnerText(element);
 if(!highlightTagName)
  highlightTagName = "em";
 highlightTagName = highlightTagName.toLowerCase();
 if(currentText.indexOf("</" + highlightTagName + ">") != -1)
  ContainsFilteringUtils.UnselectContainsTextInElement(element, selection, highlightTagName);
 return ContainsFilteringUtils.SelectContainsTextInElement(element, selection, highlightTagName);
};
ContainsFilteringUtils.SelectContainsTextInElement = function(element, selection, highlightTagName) {
 if(selection.startIndex == -1)
  return;
 var currentText =  ASPx.Attr.GetAttribute (element, "DXText");
 if(!ASPx.IsExists(currentText)) ASPx.Attr.SetAttribute (element, "DXText", ASPx.GetInnerText(element));
 if(!highlightTagName)
  highlightTagName = "em";
 highlightTagName = highlightTagName.toLowerCase();
 var oldInnerText = ASPx.GetInnerText(element);
 var newInnerText = ContainsFilteringUtils.PrepareElementText(oldInnerText.substr(0, selection.startIndex)) + "<" + highlightTagName + ">" +
      oldInnerText.substr(selection.startIndex, selection.length) + "</" + highlightTagName + ">" +
      ContainsFilteringUtils.PrepareElementText(oldInnerText.substr(selection.startIndex + selection.length));
 ASPx.SetInnerHtml(element, newInnerText);
};
ASPx.ContainsFilteringUtils = ContainsFilteringUtils;
ASPx.MakeEqualControlsWidth = function(name1, name2){
 var control1 = ASPx.GetControlCollection().Get(name1);
 var control2 = ASPx.GetControlCollection().Get(name2);
 if(control1 && control2){
  var width = Math.max(control1.GetWidth(), control2.GetWidth());
  control1.SetWidth(width);
  control2.SetWidth(width);
 }
};
ASPx.HighContrastForeColorHighlightColorMap = {
 "#ffff00" : "#008000",
 "#00ff00" : "#0000ff",
 "#ffffff" : "#00838f",
 "#000000" : "#a347ff"
};
var AccessibilityUtils = {
 isInitialized: false,
 highContrastCssClassMarker: "dxHighContrast",
 highContrastBackgroundCssClassMarker: "dxHCB",
 highContrastDefaultBackgroundColor: "#a347ff",
 highContrastThemeActive: false,
 accessibleBackgroundCssMarker: ".dx-runtime-background",
 createAccessibleBackgrounds: function(control) {
  if(!this.highContrastThemeActive || control.accessibleBackgroundsCreated || !control.accessibilityCompliant)
   return;
  var className = this.accessibleBackgroundCssMarker;
  var styleSheetRuleNames = [];
  iterateStyleSheetRules(null, function(rule) {
   var selectorTxt = rule.selectorText;
   if(selectorTxt && selectorTxt.indexOf(className) > -1)
    styleSheetRuleNames.push(ASPx.Str.CompleteReplace(selectorTxt, className, "")); 
  });
  for(var i = 0; i < styleSheetRuleNames.length; i++) {
   var name = styleSheetRuleNames[i];
   var rule = ASPx.GetStyleSheetRules(name.substring(1));
   if(rule && rule.style && rule.style.backgroundImage)
    this.createAccessibleBackground(control.GetMainElement(), rule.style, name);
  }
  control.accessibleBackgroundsCreated = true;
 },
 createAccessibleBackground: function(container, style, selector) {
  if(!container)
   return;
  var backgroundUrl = style.backgroundImage.substring(5, style.backgroundImage.length - 2);
  var elements = container.querySelectorAll(selector);
  var accessibleBackgroundClassName = "dx-acc-bi";
  for(var i = 0; i < elements.length; i++) {
   var element = elements[i];
   if(ASPx.ElementHasCssClass(element, accessibleBackgroundClassName))
    continue;
   var image = null;
   if(element.tagName !== "IMG") {
    ASPx.AddClassNameToElement(element, accessibleBackgroundClassName);
    image = element.ownerDocument.createElement("IMG");
    ASPx.SetStyles(image, { width: "100%", height: "100%" });
    if(element.firstChild)
     element.insertBefore(image, element.firstChild);
    else
     element.appendChild(image);
   } else
    image = element;
   image.src = backgroundUrl;
  }
 },
 createHighContrastBackgroundStyle: function() {
  var style = document.createElement('style');
  style.type = 'text/css';
  var styleContent = [
   "." + this.highContrastCssClassMarker + " ." + this.highContrastBackgroundCssClassMarker + ":after {",
   "border-image: url(" + this.getHighContrastBackgroundUrl() + ") 0 1 0 0 round;",
   "}",
  ];
  style.innerHTML = styleContent.join('\n');
  document.getElementsByTagName('head')[0].appendChild(style);
 },
 getHighContrastBackgroundUrl: function() {
  var canvas = document.createElement("canvas"),
  ctx = canvas.getContext('2d');
  canvas.width = 1;
  canvas.height = 1;
  ctx.fillStyle = this.getHighContrastBackgroundColor();
  ctx.fillRect(0, 0, canvas.width, canvas.height);
  return canvas.toDataURL();
 },
 getHighContrastBackgroundColor: function() {
  var foreColor = ASPx.GetCurrentStyle(document.body).color;
  var hexColor = ASPx.Color.ColorToHexadecimal(foreColor);
  return ASPx.HighContrastForeColorHighlightColorMap[hexColor] || this.highContrastDefaultBackgroundColor;
 },
 initialize: function() {
  if(this.isInitialized)
   return;
  this.isInitialized = true;
  this.detectHighContrastTheme();
  if(this.highContrastThemeActive)
   this.createHighContrastBackgroundStyle();
 },
 detectHighContrastTheme: function() {
  var testElement = document.createElement("DIV");
  ASPx.SetStyles(testElement, {
   backgroundImage: "url('" + ASPx.EmptyImageUrl + "')",
   display: "none"
  }, true);
  var docElement = document.documentElement;
  docElement.appendChild(testElement);
  var actualBackgroundImg = ASPx.GetCurrentStyle(testElement).backgroundImage;
  docElement.removeChild(testElement);
  if(actualBackgroundImg === "none") {
   this.highContrastThemeActive = true;
   ASPx.AddClassNameToElement(docElement, this.highContrastCssClassMarker);
  }
 }
};
ASPx.AccessibilityUtils = AccessibilityUtils;
ASPx.AccessibilityUtils.SendMessageToAssistiveTechnology = function(message) {
 var messageParts = ASPx.Ident.IsArray(message) ? message : [message];
 var args = new ASPxClientControlBeforePronounceEventArgs(messageParts, null);
 ASPx.AccessibilityPronouncer.EnsureInitialize();
 ASPx.AccessibilityPronouncer.Pronounce(args, ASPx.AccessibilityPronouncerType.live);
};
ASPx.AccessibilityUtils.SetFocusAccessible = function(focusableElement) {
 if(!focusableElement)
  return;
 var elementId = focusableElement.id;
 if(!elementId) {
  var namedParent = ASPx.GetParent(focusableElement, function(element) {
   return !!element.id;
  });
  if(ASPx.IsExists(namedParent))
   elementId = namedParent.id;
 }
 var focusableControl = ASPx.GetClientControlByElementID(elementId);
 if(focusableControl && focusableControl.OnAssociatedLabelClick)
  focusableControl.OnAssociatedLabelClick(focusableElement);
 else
  window.setTimeout(function() {
   ASPx.AccessibilityUtils.SetFocusAccessibleCore(focusableElement);
  }, 0);
};
ASPx.AccessibilityUtils.SetFocusAccessibleCore = function(focusableElement) {
 if(!ASPx.IsExists(focusableElement))
  return;
 if(!ASPx.IsValidElement(focusableElement) && focusableElement.id)
  focusableElement = ASPx.GetElementById(focusableElement.id);
 if(!ASPx.IsActionElement(focusableElement))
  focusableElement = ASPx.RestoreFocusHelper.findNeighbourFocusElement(focusableElement, document.body);
 if(ASPx.IsExistsElement(focusableElement))
  focusableElement.focus();
};
ASPx.EnableCssAnimation = true;
var AnimationTransitionBase = ASPx.CreateClass(null, {
 constructor: function(element, options) {
  if(element) {
   AnimationTransitionBase.Cancel(element);
   this.element = element;
   this.element.aspxTransition = this;
  }
  this.duration = options.duration || AnimationConstants.Durations.DEFAULT;
  this.transition = options.transition || AnimationConstants.Transitions.SINE;
  this.property = options.property;
  this.unit = options.unit || "";
  this.onComplete = options.onComplete;
  this.to = null;
  this.from = null;
 },
 Start: function(from, to) {
  if(to != undefined) {
   this.to = to;
   this.from = from;
   this.SetValue(this.from);
  }
  else
   this.to = from;
 },
 Cancel: function() {
  if(!this.element)
   return;
  try {
   delete this.element.aspxTransition;
  } catch(e) {
   this.element.aspxTransition = undefined;
  }
 },
 GetValue: function() {
  return this.getValueInternal(this.element, this.property);
 },
 SetValue: function(value) {
  this.setValueInternal(this.element, this.property, this.unit, value);
 },
 setValueInternal: function(element, property, unit, value) {
  if(property == "opacity")
   AnimationUtils.setOpacity(element, value);
  else
   element.style[property] = value + unit;
 },
 getValueInternal: function(element, property) {
  if(property == "opacity")
   return ASPx.GetElementOpacity(element);
  var value = parseFloat(element.style[property]);
  return isNaN(value) ? 0 : value;
 },
 performOnComplete: function() {
  if(this.onComplete)
   this.onComplete(this.element);
 },
 getTransition: function() {
  return this.transition;
 }
});
AnimationTransitionBase.Cancel = function(element) {
 if(element.aspxTransition)
  element.aspxTransition.Cancel();
};
var AnimationConstants = {};
AnimationConstants.Durations = {
 SHORT: 200,
 DEFAULT: 400,
 LONG: 600
};
AnimationConstants.Transitions = {
 LINER: {
  Css: "cubic-bezier(0.250, 0.250, 0.750, 0.750)",
  Js: function(progress) { return progress; }
 },
 SINE: {
  Css: "cubic-bezier(0.470, 0.000, 0.745, 0.715)",
  Js: function(progress) { return Math.sin(progress * 1.57); }
 },
 POW: {
  Css: "cubic-bezier(0.755, 0.050, 0.855, 0.060)",
  Js: function(progress) { return Math.pow(progress, 4); }
 },
 POW_EASE_OUT: {
  Css: "cubic-bezier(0.165, 0.840, 0.440, 1.000)",
  Js: function(progress) { return 1 - AnimationConstants.Transitions.POW.Js(1 - progress); }
 },
 RIPPLE: {
  Css: "cubic-bezier(0.47, 0.06, 0.23, 0.99)",
  Js: function(progress) {
   return Math.pow((progress), 3) * 0.47 + 3 * progress * Math.pow((1 - progress), 2) * 0.06 + 3 * Math.pow(progress, 2) *
    (1 - progress) * 0.23 + 0.99 * Math.pow(progress, 3);
  }
 }
};
var JsAnimationTransition = ASPx.CreateClass(AnimationTransitionBase, {
 constructor: function(element, options) {
  this.constructor.prototype.constructor.call(this, element, options);
  this.onStep = options.onStep;
  this.fps = 60;
  this.startTime = null;
 },
 Start: function(from, to) {
  if(from == to) {
   this.from = this.to = from;
   setTimeout(this.complete.aspxBind(this), 0);
  }
  else {
   AnimationTransitionBase.prototype.Start.call(this, from, to);
   if(to == undefined)
    this.from = this.GetValue();
   this.initTimer();
  }
 },
 Cancel: function() {
  AnimationTransitionBase.prototype.Cancel.call(this);
  if(this.timerId)
   clearInterval(this.timerId);
 },
 initTimer: function() {
  this.startTime = new Date();
  this.timerId = window.setInterval(function() { this.onTick(); }.aspxBind(this), 1000 / this.fps);
 },
 onTick: function() {
  var progress = (new Date() - this.startTime) / this.duration;
  if(progress >= 1)
   this.complete();
  else {
   this.update(progress);
   if(this.onStep)
    this.onStep();
  }
 },
 update: function(progress) {
  this.SetValue(this.gatCalculatedValue(this.from, this.to, progress));
 },
 complete: function() {
  this.Cancel();
  this.update(1);
  this.performOnComplete();
 },
 gatCalculatedValue: function(from, to, progress) {
  if(progress == 1)
   return to;
  return from + (to - from) * this.getTransition()(progress);
 },
 getTransition: function() {
  return this.transition.Js;
 }
});
var SimpleAnimationTransition = ASPx.CreateClass(JsAnimationTransition, {
 constructor: function(options) {
  this.constructor.prototype.constructor.call(this, null, options);
  this.transition = options.transition || AnimationConstants.Transitions.POW_EASE_OUT;
  this.onUpdate = options.onUpdate;
  this.lastValue = 0;
 },
 SetValue: function(value) {
  this.onUpdate(value - this.lastValue);
  this.lastValue = value;
 },
 GetValue: function() {
  return this.lastValue;
 },
 performOnComplete: function() {
  if(this.onComplete)
   this.onComplete();
 }
});
var MultipleJsAnimationTransition = ASPx.CreateClass(JsAnimationTransition, {
 constructor: function(element, options) {
  this.constructor.prototype.constructor.call(this, element, options);
  this.properties = {};
 },
 Start: function(properties) {
  this.initProperties(properties);
  this.initTimer();
 },
 initProperties: function(properties) {
  this.properties = properties;
  for(var propName in this.properties)
   if(properties[propName].from == undefined)
    properties[propName].from = this.getValueInternal(this.element, propName);
 },
 update: function(progress) {
  for(var propName in this.properties) {
   if(this.properties.hasOwnProperty(propName)) {
    var property = this.properties[propName];
    if(property.from != property.to)
     this.setValueInternal(this.element, propName, property.unit, this.gatCalculatedValue(property.from, property.to, progress));
   }
  }
 }
});
var CssAnimationTransition = ASPx.CreateClass(AnimationTransitionBase, {
 constructor: function(element, options) {
  this.constructor.prototype.constructor.call(this, element, options);
  this.transitionPropertyName = AnimationUtils.CurrentTransition.property;
  this.eventName = AnimationUtils.CurrentTransition.event;
 },
 Start: function(from, to) {
  AnimationTransitionBase.prototype.Start.call(this, from, to);
  this.startTimerId = window.setTimeout(function() {
   if(this.from == this.to)
    this.onTransitionEnd();
   else {
    var isHidden = this.element.offsetHeight == 0 && this.element.offsetWidth == 0; 
    if(!isHidden)
     this.prepareElementBeforeAnimation();
    this.SetValue(this.to);
    if(isHidden)
     this.onTransitionEnd();
   }
  }.aspxBind(this), 0);
 },
 Cancel: function() {
  window.clearTimeout(this.startTimerId);
  AnimationTransitionBase.prototype.Cancel.call(this);
  ASPx.Evt.DetachEventFromElement(this.element, this.eventName, CssAnimationTransition.transitionEnd);
  this.setValueInternal(this.element, this.transitionPropertyName, "", "");
  this.stopAnimation();
 },
 prepareElementBeforeAnimation: function() {
  ASPx.Evt.AttachEventToElement(this.element, this.eventName, CssAnimationTransition.transitionEnd);
  var dummy = this.element.offsetHeight;
  this.element.style[this.transitionPropertyName] = this.getTransitionCssString();
  if(ASPx.Browser.Safari && ASPx.Browser.MacOSMobilePlatform && ASPx.Browser.MajorVersion >= 8) 
   setTimeout(function() {
    if(this.element && this.element.aspxTransition) {
     this.element.style[this.transitionPropertyName] = "";
     this.element.aspxTransition.onTransitionEnd();
    }
   }.aspxBind(this), this.duration + 100);
 },
 stopAnimation: function() {
  this.SetValue(ASPx.GetCurrentStyle(this.element)[this.property]);
 },
 onTransitionEnd: function() {
  this.Cancel();
  this.performOnComplete();
 },
 getTransition: function() {
  return this.transition.Css;
 },
 getTransitionCssString: function() {
  return this.getTransitionCssStringInternal(this.getCssName(this.property));
 },
 getTransitionCssStringInternal: function(cssProperty) {
  return cssProperty + " " + this.duration + "ms " + this.getTransition();
 },
 getCssName: function(property) {
  switch(property) {
   case "marginLeft":
    return "margin-left";
   case "marginTop":
    return "margin-top";
  }
  return property;
 }
});
var MultipleCssAnimationTransition = ASPx.CreateClass(CssAnimationTransition, {
 constructor: function(element, options) {
  this.constructor.prototype.constructor.call(this, element, options);
  this.properties = null;
 },
 Start: function(properties) {
  this.properties = properties;
  this.forEachProperties(function(property, propName) {
   if(property.from !== undefined)
    this.setValueInternal(this.element, propName, property.unit, property.from);
  }.aspxBind(this));
  this.prepareElementBeforeAnimation();
  window.setTimeout(function() {
   this.forEachProperties(function(property, propName) {
    this.setValueInternal(this.element, propName, property.unit, property.to);
   }.aspxBind(this));
  }.aspxBind(this), 0);
 },
 stopAnimation: function() {
  var style = ASPx.GetCurrentStyle(this.element);
  this.forEachProperties(function(property, propName) {
   this.setValueInternal(this.element, propName, "", style[propName]);
  }.aspxBind(this));
 },
 getTransitionCssString: function() {
  var str = "";
  this.forEachProperties(function(property, propName) {
   str += this.getTransitionCssStringInternal(this.getCssName(propName)) + ",";
  }.aspxBind(this));
  str = str.substring(0, str.length - 1);
  return str;
 },
 forEachProperties: function(func) {
  for(var propName in this.properties) {
   if(this.properties.hasOwnProperty(propName)) {
    var property = this.properties[propName];
    if(property.from == undefined)
     property.from = this.getValueInternal(this.element, propName);
    if(property.from != property.to)
     func(property, propName);
   }
  }
 }
});
CssAnimationTransition.transitionEnd = function(evt) {
 var element = evt.target;
 if(element && element.aspxTransition)
  element.aspxTransition.onTransitionEnd();
};
var AnimationUtils = {
 CanUseCssTransition: function() { return ASPx.EnableCssAnimation && this.CurrentTransition; },
 CanUseCssTransform: function() { return this.CanUseCssTransition() && this.CurrentTransform; },
 CurrentTransition: (function() {
  if(ASPx.Browser.IE) 
   return null;
  var transitions = [
   { property: "webkitTransition", event: "webkitTransitionEnd" },
   { property: "MozTransition", event: "transitionend" },
   { property: "OTransition", event: "oTransitionEnd" },
   { property: "transition", event: "transitionend" }
  ];
  var fakeElement = document.createElement("DIV");
  for(var i = 0; i < transitions.length; i++)
   if(transitions[i].property in fakeElement.style)
    return transitions[i];
 })(),
 CurrentTransform: (function() {
  var transforms = ["transform", "MozTransform", "-webkit-transform", "msTransform", "OTransform"];
  var fakeElement = document.createElement("DIV");
  for(var i = 0; i < transforms.length; i++)
   if(transforms[i] in fakeElement.style)
    return transforms[i];
 })(),
 SetTransformValue: function(element, position, isTop) {
  if(this.CanUseCssTransform())
   element.style[this.CurrentTransform] = this.GetTransformCssText(position, isTop);
  else
   element.style[!isTop ? "left" : "top"] = position + "px";
 },
 GetTransformValue: function(element, isTop) {
  if(this.CanUseCssTransform()) {
   var cssValue = element.style[this.CurrentTransform];
   return cssValue && cssValue != "none" ? Number(cssValue.replace('matrix(1, 0, 0, 1,', '').replace(')', '').split(',')[!isTop ? 0 : 1]) : 0;
  }
  else
   return !isTop ? element.offsetLeft : element.offsetTop;
 },
 GetTransformCssText: function(position, isTop) {
  if(!position)
   return "none";
  return "matrix(1, 0, 0, 1," + (!isTop ? position : 0) + ", " + (!isTop ? 0 : position) + ")";
 },
 createMultipleAnimationTransition: function (element, options) {
  return this.CanUseCssTransition() && !options.onStep ? new MultipleCssAnimationTransition(element, options) : new MultipleJsAnimationTransition(element, options);
 },
 createSimpleAnimationTransition: function(options) {
  return new SimpleAnimationTransition(options);
 },
 createJsAnimationTransition: function(element, options) {
  return new JsAnimationTransition(element, options);
 },
 createCssAnimationTransition: function(element, options) {
  return new CssAnimationTransition(element, options);
 },
 setOpacity: function(element, value) {
  ASPx.SetElementOpacity(element, value);
 }
};
var AsyncTracker = function() {
 var currentToken,
  lockedTokens,
  onDoneDelegates,
  lockedDelegates;
 function clearState() {
  currentToken = 1;
  lockedTokens = [];
  onDoneDelegates = [];
  lockedDelegates = {};
 }
 clearState();
 var log = function(msg) { };
 function setLog(delegate){
  log = delegate;
 }
 function getLockToken() {
  if(onDoneDelegates.length === 0)
   return -1;
  var token = currentToken++;
  lockedTokens.push(token);
  lockedDelegates[token] = [];
  for (var i = 0; i < onDoneDelegates.length; i++) {
   lockedDelegates[token].push(onDoneDelegates[i]);
  }
  log("module locks token " + token);
  return token;
 }
 function releaseToken(token) {
  if(token < 0) return;
  log("module releasing token " + token);
  ASPx.Data.ArrayRemove(lockedTokens, token);
  delete lockedDelegates[token];
  invokeUnlockedDelegates();
  if(lockedTokens.length === 0)
   clearState();
  log("module released token " + token);
 }
 function invokeUnlockedDelegates() {
  var onDoneDelegate;
  for (var i = onDoneDelegates.length - 1; i >= 0; i--) {
   if(onDoneDelegates[i] && !isDelegateLocked(onDoneDelegates[i])) {
    onDoneDelegate = onDoneDelegates[i];
    delete onDoneDelegates[i];
    onDoneDelegate();
   }
  }
 }
 function isDelegateLocked(delegate) {
  for (var i = lockedTokens.length - 1; i >= 0; i--) {
   var token = lockedTokens[i];
   var delegates = lockedDelegates[token];
   if(delegates) {
    for (var j = delegates.length - 1; j >= 0; j--) {
     if(delegates[j] && delegates[j] === delegate)
      return true;
    }
   }
  }
  return false;
 }
 function track(doDelegate, onDoneDelegate) {
  if(onDoneDelegate)
   onDoneDelegates.push(onDoneDelegate);
  doDelegate();
  if(onDoneDelegate)
   invokeUnlockedDelegates();
 }
 return {
  getLockToken: getLockToken,
  releaseToken: releaseToken,
  track: track,
  setLog:setLog,
 };
};
var GetEditorValuesInContainer = function(containerOrId, processInvisibleEditors, needSerialize) {
 var container = typeof(containerOrId) === "string" ? ASPx.GetElementById(containerOrId) : containerOrId;
 var result = {};
 ASPx.ProcessEditorsInContainer(container, function(editor){
  result[editor.name] = GetCorrectedByTypeValue(ASPx.GetEditorValueByControl(editor), needSerialize);
 }, null, null, processInvisibleEditors, false);
 return result;
};
var GetCorrectedByTypeValue = function(value, needSerialize){
 if(ASPx.Ident.IsArray(value))
  for(var i = 0; i < value.length; i++)
   value[i] = GetCorrectedByTypeValue(value[i]);
 if(needSerialize && ASPx.Ident.IsDate(value))
  return ASPx.DateUtils.GetInvariantDateTimeString(value);
 return value;
};
ASPx.GetEditorValueByControl = function(control, needSerialize) {
 var result;
 if(ASPx.IsMultipleValueOwner(control))
  result = control.GetSelectedValues();
 if(ASPx.IsTokenBox(control)) {
  if(needSerialize)
   result = control.GetTokenValuesCollection();
  else
   result = control.GetTokenCollection();
 }
 return result || control.GetValue();
};
ASPx.IsMultipleValueOwner = function(control) {
 return ASPx.IsListBox(control) || ASPx.IsCheckBoxList(control);
};
ASPx.IsCheckBoxList = function(control) {
 return control && typeof(ASPxClientCheckBoxList) != "undefined" && control instanceof ASPxClientCheckBoxList;
};
ASPx.IsListBox = function(control) {
 return control && typeof(ASPxClientListBox) != "undefined" && control instanceof ASPxClientListBox;
};
ASPx.IsComboBox = function(control) {
 return control && typeof(ASPxClientComboBox) != "undefined" && control instanceof ASPxClientComboBox;
};
ASPx.IsTokenBox = function(control) {
 return control && typeof(ASPxClientTokenBox) != "undefined" && control instanceof ASPxClientTokenBox;
};
ASPx.IsGridLookup = function(control) {
 return control && typeof(MVCxClientGridLookup) != "undefined" && control instanceof MVCxClientGridLookup;
};
ASPx.IsSpinEdit = function(control) {
 return control && typeof(ASPxClientSpinEdit) != "undefined" && control instanceof ASPxClientSpinEdit;
};
ASPxClientUtils = {};
ASPxClientUtils.agent = Browser.UserAgent;
ASPxClientUtils.opera = Browser.Opera;
ASPxClientUtils.opera9 = Browser.Opera && Browser.MajorVersion == 9;
ASPxClientUtils.safari = Browser.Safari;
ASPxClientUtils.safari3 = Browser.Safari && Browser.MajorVersion == 3;
ASPxClientUtils.safariMacOS = Browser.Safari && Browser.MacOSPlatform;
ASPxClientUtils.chrome = Browser.Chrome;
ASPxClientUtils.ie = Browser.IE;
ASPxClientUtils.ie7 = Browser.IE && Browser.MajorVersion == 7;
ASPxClientUtils.firefox = Browser.Firefox;
ASPxClientUtils.firefox3 = Browser.Firefox && Browser.MajorVersion == 3;
ASPxClientUtils.mozilla = Browser.Mozilla;
ASPxClientUtils.netscape = Browser.Netscape;
ASPxClientUtils.browserVersion = Browser.Version;
ASPxClientUtils.browserMajorVersion = Browser.MajorVersion;
ASPxClientUtils.macOSPlatform = Browser.MacOSPlatform;
ASPxClientUtils.windowsPlatform = Browser.WindowsPlatform;
ASPxClientUtils.webKitFamily = Browser.WebKitFamily;
ASPxClientUtils.netscapeFamily = Browser.NetscapeFamily;
ASPxClientUtils.touchUI = Browser.TouchUI;
ASPxClientUtils.webKitTouchUI = Browser.WebKitTouchUI;
ASPxClientUtils.msTouchUI = Browser.MSTouchUI;
ASPxClientUtils.iOSPlatform = Browser.MacOSMobilePlatform;
ASPxClientUtils.androidPlatform = Browser.AndroidMobilePlatform;
ASPxClientUtils.ArrayInsert = Data.ArrayInsert;
ASPxClientUtils.ArrayRemove = Data.ArrayRemove;
ASPxClientUtils.ArrayRemoveAt = Data.ArrayRemoveAt;
ASPxClientUtils.ArrayClear = Data.ArrayClear;
ASPxClientUtils.ArrayIndexOf = Data.ArrayIndexOf;
ASPxClientUtils.AttachEventToElement = Evt.AttachEventToElement;
ASPxClientUtils.DetachEventFromElement = Evt.DetachEventFromElement;
ASPxClientUtils.GetEventSource = Evt.GetEventSource;
ASPxClientUtils.GetEventX = Evt.GetEventX;
ASPxClientUtils.GetEventY = Evt.GetEventY;
ASPxClientUtils.GetKeyCode = Evt.GetKeyCode;
ASPxClientUtils.PreventEvent = Evt.PreventEvent;
ASPxClientUtils.PreventEventAndBubble = Evt.PreventEventAndBubble;
ASPxClientUtils.PreventDragStart = Evt.PreventDragStart;
ASPxClientUtils.ClearSelection = Selection.Clear;
ASPxClientUtils.IsExists = ASPx.IsExists;
ASPxClientUtils.IsFunction = ASPx.IsFunction;
ASPxClientUtils.GetAbsoluteX = ASPx.GetAbsoluteX;
ASPxClientUtils.GetAbsoluteY = ASPx.GetAbsoluteY;
ASPxClientUtils.SetAbsoluteX = ASPx.SetAbsoluteX;
ASPxClientUtils.SetAbsoluteY = ASPx.SetAbsoluteY;
ASPxClientUtils.GetDocumentScrollTop = ASPx.GetDocumentScrollTop;
ASPxClientUtils.GetDocumentScrollLeft = ASPx.GetDocumentScrollLeft;
ASPxClientUtils.GetDocumentClientWidth = ASPx.GetDocumentClientWidth;
ASPxClientUtils.GetDocumentClientHeight = ASPx.GetDocumentClientHeight;
ASPxClientUtils.GetIsParent = ASPx.GetIsParent;
ASPxClientUtils.GetParentById = ASPx.GetParentById;
ASPxClientUtils.GetParentByTagName = ASPx.GetParentByTagName;
ASPxClientUtils.GetParentByClassName = ASPx.GetParentByPartialClassName;
ASPxClientUtils.GetChildById = ASPx.GetChildById;
ASPxClientUtils.GetChildByTagName = ASPx.GetChildByTagName;
ASPxClientUtils.SetCookie = Cookie.SetCookie;
ASPxClientUtils.GetCookie = Cookie.GetCookie;
ASPxClientUtils.DeleteCookie = Cookie.DelCookie;
ASPxClientUtils.GetShortcutCode = ASPx.GetShortcutCode; 
ASPxClientUtils.GetShortcutCodeByEvent = ASPx.GetShortcutCodeByEvent;
ASPxClientUtils.StringToShortcutCode = ASPx.ParseShortcutString;
ASPxClientUtils.Trim = Str.Trim; 
ASPxClientUtils.TrimStart = Str.TrimStart;
ASPxClientUtils.TrimEnd = Str.TrimEnd;
ASPxClientUtils.GetEditorValuesInContainer = GetEditorValuesInContainer;
ASPxClientUtils.SendMessageToAssistiveTechnology = ASPx.AccessibilityUtils.SendMessageToAssistiveTechnology;
window.ASPxClientUtils = ASPxClientUtils;
ASPx.AnimationUtils = AnimationUtils;
ASPx.AnimationTransitionBase = AnimationTransitionBase;
ASPx.AnimationConstants = AnimationConstants;
ASPx.AsyncTracker = AsyncTracker;
})();

(function () {
ASPx.classesScriptParsed = false;
ASPx.documentLoaded = false; 
ASPx.CallbackType = {
 Data: "d",
 Common: "c"
};
ASPx.callbackState = {
 aborted: "aborted",
 inTurn: "inTurn",
 sent: "sent"
};
var ASPxClientEvent = ASPx.CreateClass(null, {
 constructor: function() {
  this.handlerInfoList = [];
  this.firingIndex = -1;
 },
 AddHandler: function(handler, executionContext) {
  if(typeof(executionContext) == "undefined")
   executionContext = null;
  this.RemoveHandler(handler, executionContext);
  var handlerInfo = ASPxClientEvent.CreateHandlerInfo(handler, executionContext);
  this.handlerInfoList.push(handlerInfo);
 },
 RemoveHandler: function(handler, executionContext) {
  this.removeHandlerByCondition(function(handlerInfo) {
   return handlerInfo.handler == handler && 
    (!executionContext || handlerInfo.executionContext == executionContext);
  });
 },
 removeHandlerByCondition: function(predicate) {
   for(var i = this.handlerInfoList.length - 1; i >= 0; i--) {
   var handlerInfo = this.handlerInfoList[i];
   if(predicate(handlerInfo)) {
    ASPx.Data.ArrayRemoveAt(this.handlerInfoList, i);
    if(i <= this.firingIndex)
     this.firingIndex--;
   }
  }
 },
 removeHandlerByControlName: function(controlName) {
  this.removeHandlerByCondition(function(handlerInfo) {
   return handlerInfo.executionContext &&  
    handlerInfo.executionContext.name === controlName;
  });
 },
 ClearHandlers: function() {
  this.handlerInfoList.length = 0;
 },
 FireEvent: function(obj, args) {
  for(this.firingIndex = 0; this.firingIndex < this.handlerInfoList.length; this.firingIndex++) {
   var handlerInfo = this.handlerInfoList[this.firingIndex];
   handlerInfo.handler.call(handlerInfo.executionContext, obj, args);
  }
 },
 InsertFirstHandler: function(handler, executionContext){
  if(typeof(executionContext) == "undefined")
   executionContext = null;
  var handlerInfo = ASPxClientEvent.CreateHandlerInfo(handler, executionContext);
  ASPx.Data.ArrayInsert(this.handlerInfoList, handlerInfo, 0);
 },
 IsEmpty: function() {
  return this.handlerInfoList.length == 0;
 }
});
ASPxClientEvent.CreateHandlerInfo = function(handler, executionContext) {
 return {
  handler: handler,
  executionContext: executionContext
 };
};
var ASPxClientEventArgs = ASPx.CreateClass(null, {
 constructor: function() {
 }
});
ASPxClientEventArgs.Empty = new ASPxClientEventArgs();
var ASPxClientCancelEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(){
  this.constructor.prototype.constructor.call(this);
  this.cancel = false;
 }
});
var ASPxClientProcessingModeEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(processOnServer){
  this.constructor.prototype.constructor.call(this);
  this.processOnServer = processOnServer;
 }
});
var ASPxClientProcessingModeCancelEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(processOnServer){
  this.constructor.prototype.constructor.call(this, processOnServer);
  this.cancel = false;
 }
});
var OrderedMap = ASPx.CreateClass(null, {
 constructor: function(){
  this.entries = {};
  this.firstEntry = null;
  this.lastEntry = null;
 },
 add: function(key, element) {
  var entry = this.addEntry(key, element);
  this.entries[key] = entry;
 },
 remove: function(key) {
  var entry = this.entries[key];
  if(entry === undefined)
   return;
  this.removeEntry(entry);
  delete this.entries[key];
 },
 clear: function() {
  this.markAllEntriesAsRemoved();
  this.entries = {};
  this.firstEntry = null;
  this.lastEntry = null;
 },
 get: function(key) {
  var entry = this.entries[key];
  return entry ? entry.value : undefined;
 },
 forEachEntry: function(processFunc, context) {
  context = context || this;
  for(var entry = this.firstEntry; entry; entry = entry.next) {
   if(entry.removed)
    continue;
   if(processFunc.call(context, entry.key, entry.value))
    return;
  }
 },
 addEntry: function(key, element) {
  var entry = { key: key, value: element, next: null, prev: null };
  if(!this.firstEntry)
   this.firstEntry = entry;
  else {
   entry.prev = this.lastEntry;
   this.lastEntry.next = entry;
  }
  this.lastEntry = entry;
  return entry;
 },
 removeEntry: function(entry) {
  if(this.firstEntry == entry)
   this.firstEntry = entry.next;
  if(this.lastEntry == entry)
   this.lastEntry = entry.prev;
  if(entry.prev)
   entry.prev.next = entry.next;
  if(entry.next)
   entry.next.prev = entry.prev;
  entry.removed = true;
 },
 markAllEntriesAsRemoved: function() {
  for(var entry = this.firstEntry; entry; entry = entry.next)
   entry.removed = true;
 }
});
var CollectionBase = ASPx.CreateClass(null, {
 constructor: function(){
  this.elementsMap = new OrderedMap();
  this.isASPxClientCollection = true;
 },
 Add: function(key, element) {
  this.elementsMap.add(key, element);
 },
 Remove: function(key) {
  this.elementsMap.remove(key);
 },
 Clear: function(){
  this.elementsMap.clear();
 },
 Get: function(key){
  return this.elementsMap.get(key);
 }
});
var GarbageCollector = ASPx.CreateClass(null, {
 constructor: function() {
  this.interval = 5000;
  this.intervalID = window.setInterval(function(){ this.CollectObjects(); }.aspxBind(this), this.interval);
 },
 CollectObjects: function(){
  if(ASPx.GetControlCollection().InCallback()) return;
  ASPx.GetControlCollectionCollection().RemoveDisposedControls();
  if(typeof(ASPx.GetStateController) != "undefined")
   ASPx.GetStateController().RemoveDisposedItems();
  if(ASPx.TableScrollHelperCollection)
   ASPx.TableScrollHelperCollection.RemoveDisposedObjects();
  if(ASPx.Ident.scripts.ASPxClientRatingControl)
   ASPxClientRatingControl.RemoveDisposedElementUnderCursor();
  var postHandler = aspxGetPostHandler();
  if(postHandler)
   postHandler.RemoveDisposedFormsFromCache();
 }
});
var dummyGcCollector = new GarbageCollector(); 
var ControlTree = ASPx.CreateClass(null, {
 constructor: function(controlCollection, container) {
  this.container = container;
  this.domMap = { };
  this.rootNode = this.createNode(null, null);
  this.createControlTree(controlCollection, container);
 },
 forEachControl: function(collapseControls, processFunc) {
  var observer = _aspxGetDomObserver();
  observer.pause(this.container, true);
  var documentScrollInfo;
  if(collapseControls) {
   documentScrollInfo = ASPx.GetOuterScrollPosition(document.body);
   this.collapseControls(this.rootNode);
  }
  var adjustNodes = [], 
   autoHeightNodes = [];
  var requireReAdjust = this.forEachControlCore(this.rootNode, collapseControls, processFunc, adjustNodes, autoHeightNodes);
  if(requireReAdjust)
   this.forEachControlsBackward(adjustNodes, collapseControls, processFunc);
  else {
   for(var i = 0, node; node = autoHeightNodes[i]; i++)
    node.control.AdjustAutoHeight();
  }
  if(collapseControls)
   ASPx.RestoreOuterScrollPosition(documentScrollInfo);
  observer.resume(this.container, true);
 },
 forEachControlCore: function(node, collapseControls, processFunc, adjustNodes, autoHeightNodes) {
  var requireReAdjust = false,
   size, newSize;
  if(node.control) {
   var checkReadjustment = collapseControls && node.control.IsControlCollapsed() && node.control.CanCauseReadjustment();
   if(checkReadjustment)
    size = node.control.GetControlPercentMarkerSize(false, true);
   if(node.control.IsControlCollapsed() && !node.control.IsExpandableByAdjustment())
    node.control.ExpandControl();
   node.control.isInsideHierarchyAdjustment = true;
   processFunc(node.control);
   node.control.isInsideHierarchyAdjustment = false;
   if(checkReadjustment) {
    newSize = node.control.GetControlPercentMarkerSize(false, true);
    requireReAdjust = size.width !== newSize.width;
   }
   if(node.control.sizingConfig.supportAutoHeight)
    autoHeightNodes.push(node);
   node.control.ResetControlPercentMarkerSize();
  }
  for(var childNode, i = 0; childNode = node.children[i]; i++)
   requireReAdjust = this.forEachControlCore(childNode, collapseControls, processFunc, adjustNodes, autoHeightNodes) || requireReAdjust;
  adjustNodes.push(node);
  return requireReAdjust;
 },
 forEachControlsBackward: function(adjustNodes, collapseControls, processFunc) {
  for(var i = 0, node; node = adjustNodes[i]; i++)
   this.forEachControlsBackwardCore(node, collapseControls, processFunc);
 },
 forEachControlsBackwardCore: function(node, collapseControls, processFunc) {
  if(node.control)
   processFunc(node.control);
  if(node.children.length > 1) {
   for(var i = 0, childNode; childNode = node.children[i]; i++) {
    if(childNode.control)
     processFunc(childNode.control);
   }
  }
 },
 collapseControls: function(node) {
  for(var childNode, i = 0; childNode = node.children[i]; i++)
   this.collapseControls(childNode);
  if(node.control && node.control.NeedCollapseControl())
   node.control.CollapseControl();
 },
 createControlTree: function(controlCollection, container) {
  controlCollection.ProcessControlsInContainer(container, function(control) {
   control.RegisterInControlTree(this);
  }.aspxBind(this));
  var fixedNodes = [];
  var fixedNodesChildren = [];
  for(var domElementID in this.domMap) {
   if(!this.domMap.hasOwnProperty(domElementID)) continue;
   var node = this.domMap[domElementID];
   var controlOwner = node.control ? node.control.controlOwner : null;
   if(controlOwner && this.domMap[controlOwner.name])
    continue;
   if(this.isFixedNode(node))
    fixedNodes.push(node);
   else {
    var parentNode = this.findParentNode(domElementID);
    parentNode = parentNode || this.rootNode;
    if(this.isFixedNode(parentNode))
     fixedNodesChildren.push(node);
    else {
     var childNode = node.mainNode || node;
     this.addChildNode(parentNode, childNode);
    }
   }
  }
  for(var i = fixedNodes.length - 1; i >= 0; i--)
   this.insertChildNode(this.rootNode, fixedNodes[i], 0);
  for(var i = fixedNodesChildren.length - 1; i >= 0; i--)
   this.insertChildNode(this.rootNode, fixedNodesChildren[i], 0);
 },
 findParentNode: function(id) {
  var element = document.getElementById(id).parentNode;
  while(element && element.tagName !== "BODY") {
   if(element.id) {
    var parentNode = this.domMap[element.id];
    if(parentNode)
     return parentNode;
   }
   element = element.parentNode;
  }
  return null;
 },
 addChildNode: function(node, childNode) {
  if(!childNode.parentNode) {
   node.children.push(childNode);
   childNode.parentNode = node;
  }
 },
 insertChildNode: function(node, childNode, index) {
  if(!childNode.parentNode) {
   ASPx.Data.ArrayInsert(node.children, childNode, index);
   childNode.parentNode = node;
  }
 },
 addRelatedNode: function(node, relatedNode) {
  this.addChildNode(node, relatedNode);
  relatedNode.mainNode = node;
 },
 isFixedNode: function(node) {
  var control = node.mainNode ? node.mainNode.control : node.control;
  return control && control.HasFixedPosition();
 },
 createNode: function(domElementID, control) {
  var node = {
   control: control,
   children: [],
   parentNode: null,
   mainNode: null
  };
  if(domElementID)
   this.domMap[domElementID] = node;
  return node;
 }
});
function _aspxFunctionIsInCallstack(currentCallee, targetFunction, depthLimit) {
 var candidate = currentCallee;
 var depth = 0;
 while(candidate && depth <= depthLimit) {
  candidate = candidate.caller;
  if(candidate == targetFunction)
   return true;
  depth++;
 }
 return false;
}
ASPx.Evt.AttachEventToElement(window, "load", aspxClassesWindowOnLoad);
function aspxClassesWindowOnLoad(evt){
 ASPx.documentLoaded = true;
 _aspxSweepDuplicatedLinks();
 ResourceManager.SynchronizeResources();
 var externalScriptProcessor = GetExternalScriptProcessor();
 if(externalScriptProcessor)
  externalScriptProcessor.ShowErrorMessages();
 ASPx.AccessibilityUtils.initialize();
 ASPx.GetControlCollection().Initialize();
 _aspxInitializeScripts();
 _aspxInitializeLinks();
 _aspxInitializeFocus();
}
Ident = { };
Ident.IsDate = function(obj) {
 return obj && obj.constructor == Date;
};
Ident.IsRegExp = function(obj) {
 return obj && obj.constructor === RegExp;
};
Ident.IsArray = function(obj) {
 return obj && obj.constructor == Array;
};
Ident.IsASPxClientCollection = function(obj) {
 return obj && obj.isASPxClientCollection;
};
Ident.IsASPxClientControl = function(obj) {
 return obj && obj instanceof ASPxClientControlBase;
};
Ident.IsASPxClientEdit = function(obj) {
 return obj && obj.isASPxClientEdit;
};
Ident.IsFocusableElementRegardlessTabIndex = function (element) {
 var tagName = element.tagName;
 return tagName == "TEXTAREA" || tagName == "INPUT" || tagName == "A" || 
  tagName == "SELECT" || tagName == "IFRAME" || tagName == "OBJECT";
};
Ident.isDialogInvisibleControl = function(control) {
 return !!ASPx.Dialog && ASPx.Dialog.isDialogInvisibleControl(control);
};
Ident.scripts = {};
if(ASPx.IsFunction(window.WebForm_InitCallbackAddField)) {
 (function() {
  var original = window.WebForm_InitCallbackAddField;
  window.WebForm_InitCallbackAddField = function(name, value) {
   if(typeof(name) == "string" && name)
    original.apply(null, arguments);
  };
 })();
}
ASPx.FireDefaultButton = function(evt, buttonID) {
 if(_aspxIsDefaultButtonEvent(evt, buttonID)) {
  var defaultButton = ASPx.GetElementById(buttonID);
  if(defaultButton && defaultButton.click) {
   if(ASPx.IsFocusable(defaultButton))
    defaultButton.focus();
   ASPx.Evt.DoElementClick(defaultButton);
   ASPx.Evt.PreventEventAndBubble(evt);
   return false;
  }
 }
 return true;
};
function _aspxIsDefaultButtonEvent(evt, defaultButtonID) {
 if(evt.keyCode != ASPx.Key.Enter)
  return false;
 var srcElement = ASPx.Evt.GetEventSource(evt);
 if(!srcElement || srcElement.id === defaultButtonID)
  return true;
 var tagName = srcElement.tagName;
 var type = srcElement.type;
 return tagName != "TEXTAREA" && tagName != "BUTTON" && tagName != "A" &&
  (tagName != "INPUT" || type != "checkbox" && type != "radio" && type != "button" && type != "submit" && type != "reset");
}
var PostHandler = ASPx.CreateClass(null, {
 constructor: function() {
  this.Post = new ASPxClientEvent();
  this.PostFinalization = new ASPxClientEvent();
  this.observableForms = [];
  this.dxCallbackTriggers = {};
  this.lastSubmitElementName = null;
  this.beforeOnSubmit = function() { };
  this.ReplaceGlobalPostFunctions();
  this.HandleDxCallbackBeginning();
  this.HandleMSAjaxRequestBeginning();
 },
 Update: function() {
  this.ReplaceFormsSubmit(true);
 },
 ProcessPostRequest: function(ownerID, isCallback, isMSAjaxRequest, isDXCallback) {
  this.cancelPostProcessing = false;
  this.isMSAjaxRequest = isMSAjaxRequest;
  if(this.SkipRaiseOnPost(ownerID, isCallback, isDXCallback))
   return;
  var args = new PostHandlerOnPostEventArgs(ownerID, isCallback, isMSAjaxRequest, isDXCallback);
  this.Post.FireEvent(this, args);
  this.cancelPostProcessing = args.cancel;
  if(!args.cancel)
   this.PostFinalization.FireEvent(this, args);
 },
 SkipRaiseOnPost: function(ownerID, isCallback, isDXCallback) { 
  if(!isCallback)
   return false;
  var dxOwner = isDXCallback && ASPx.GetControlCollection().GetByName(ownerID);
  if(dxOwner) {
   this.dxCallbackTriggers[dxOwner.uniqueID] = true;
   return false;
  }
  if(this.dxCallbackTriggers[ownerID]) {
   this.dxCallbackTriggers[ownerID] = false;
   return true;
  }
  return false;
 },
 ReplaceGlobalPostFunctions: function() {
  if(ASPx.IsFunction(window.__doPostBack))
   this.ReplaceDoPostBack();
  if(ASPx.IsFunction(window.WebForm_DoCallback))
   this.ReplaceDoCallback();
  this.ReplaceFormsSubmit();
 },
 HandleDxCallbackBeginning: function() {
  ASPx.GetControlCollection().BeforeInitCallback.AddHandler(function(s, e) {
   aspxRaisePostHandlerOnPost(e.callbackOwnerID, true, false, true); 
  });
 },
 HandleMSAjaxRequestBeginning: function() {
  if(window.Sys && Sys.WebForms && Sys.WebForms.PageRequestManager && Sys.WebForms.PageRequestManager.getInstance) {
   var pageRequestManager = Sys.WebForms.PageRequestManager.getInstance();
   if(pageRequestManager != null && Ident.IsArray(pageRequestManager._onSubmitStatements)) {
    pageRequestManager._onSubmitStatements.unshift(function() {
     var postbackSettings = Sys.WebForms.PageRequestManager.getInstance()._postBackSettings;
     var postHandler = aspxGetPostHandler();
     aspxRaisePostHandlerOnPost(postbackSettings.asyncTarget, true, true);
     return !postHandler.cancelPostProcessing;
    });
   }
  }
 },
 ReplaceDoPostBack: function() {
  var original = __doPostBack;
  __doPostBack = function(eventTarget, eventArgument) {
   var postHandler = aspxGetPostHandler();
   aspxRaisePostHandlerOnPost(eventTarget);
   if(postHandler.cancelPostProcessing)
    return;
   ASPxClientControl.postHandlingLocked = true;
   original(eventTarget, eventArgument);
   delete ASPxClientControl.postHandlingLocked;
  };
 },
 ReplaceDoCallback: function() {
  var original = WebForm_DoCallback;
  WebForm_DoCallback = function(eventTarget, eventArgument, eventCallback, context, errorCallback, useAsync) {
   var postHandler = aspxGetPostHandler();
   aspxRaisePostHandlerOnPost(eventTarget, true);
   if(postHandler.cancelPostProcessing)
    return;
   return original(eventTarget, eventArgument, eventCallback, context, errorCallback, useAsync);
  };
 },
 ReplaceFormsSubmit: function(checkObservableCollection) {
  for(var i = 0; i < document.forms.length; i++) { 
   var form = document.forms[i];
   if(checkObservableCollection && ASPx.Data.ArrayIndexOf(this.observableForms, form) >= 0)
    continue;
   if(form.submit)
    this.ReplaceFormSubmit(form);
   this.ReplaceFormOnSumbit(form);
   this.observableForms.push(form);
  }
 },
 ReplaceFormSubmit: function(form) {
  var originalSubmit = form.submit;
  form.submit = function() {
   var postHandler = aspxGetPostHandler();
   aspxRaisePostHandlerOnPost();
   if(postHandler.cancelPostProcessing)
    return false;
   var callee = arguments.callee;
   this.submit = originalSubmit;
   var submitResult = this.submit();
   this.submit = callee;
   return submitResult;
  };
  form = null;
 },
 ReplaceFormOnSumbit: function(form) {
  var originalSubmit = form.onsubmit;
  form.onsubmit = function() {
   var postHandler = aspxGetPostHandler();
   postHandler.beforeOnSubmit();
   if(postHandler.isMSAjaxRequest)
    postHandler.isMsAjaxRequest = false;
   else
    aspxRaisePostHandlerOnPost(postHandler.GetLastSubmitElementName());
   if(postHandler.cancelPostProcessing)
    return false;
   return ASPx.IsFunction(originalSubmit)
    ? originalSubmit.apply(this, arguments)
    : true;
  };
  form = null;
 },
 SetBeforeOnSubmit: function(action) {
  this.beforeOnSubmit = action;
 },
 SetLastSubmitElementName: function(elementName) {
  this.lastSubmitElementName = elementName;
 },
 GetLastSubmitElementName: function() {
  return this.lastSubmitElementName;
 },
 RemoveDisposedFormsFromCache: function(){
  for(var i = 0; this.observableForms && i < this.observableForms.length; i++){
   var form = this.observableForms[i];
   if(!ASPx.IsExistsElement(form)){
    ASPx.Data.ArrayRemove(this.observableForms, form);
    i--;
   }
  }
 }
});
function aspxRaisePostHandlerOnPost(ownerID, isCallback, isMSAjaxRequest, isDXCallback) {
 if(ASPxClientControl.postHandlingLocked) return;
 var postHandler = aspxGetPostHandler();
 if(postHandler)
  postHandler.ProcessPostRequest(ownerID, isCallback, isMSAjaxRequest, isDXCallback);
}
var aspxPostHandler;
function aspxGetPostHandler() {
 if(!aspxPostHandler)
  aspxPostHandler = new PostHandler();
 return aspxPostHandler;
}
var PostHandlerOnPostEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(ownerID, isCallback, isMSAjaxCallback, isDXCallback){
  this.constructor.prototype.constructor.call(this);
  this.ownerID = ownerID;
  this.isCallback = !!isCallback;
  this.isDXCallback = !!isDXCallback;
  this.isMSAjaxCallback = !!isMSAjaxCallback;
 }
});
var ResourceManager = {
 HandlerStr: "DXR.axd?r=",
 ResourceHashes: {},
 SynchronizeResources: function(method){
  if(!method){
   method = function(name, resource) { 
    this.UpdateInputElements(name, resource); 
   }.aspxBind(this);
  }
  var resources = this.GetResourcesData();
  for(var name in resources)
   if(resources.hasOwnProperty(name))
    method(name, resources[name]);
 },
 GetResourcesData: function(){
  return {
   DXScript: this.GetResourcesElementsString(_aspxGetIncludeScripts(), "src", "DXScript"),
   DXCss: this.GetResourcesElementsString(_aspxGetLinks(), "href", "DXCss")
  };
 },
 GetResourcesElementsString: function(elements, urlAttr, id){
  if(!this.ResourceHashes[id]) 
   this.ResourceHashes[id] = {};
  var hash = this.ResourceHashes[id];
  for(var i = 0; i < elements.length; i++) {
   var resourceUrl = ASPx.Attr.GetAttribute(elements[i], urlAttr);
   if(resourceUrl) {
    var pos = resourceUrl.indexOf(this.HandlerStr);
    if(pos > -1){
     var list = resourceUrl.substr(pos + this.HandlerStr.length);
     var ampPos = list.lastIndexOf("-");
     if(ampPos > -1)
      list = list.substr(0, ampPos);
     var indexes = list.split(",");
     for(var j = 0; j < indexes.length; j++)
      hash[indexes[j]] = indexes[j];
    }
    else
     hash[resourceUrl] = resourceUrl;
   }
  }
  var array = [];
  for(var key in hash)
   if(hash.hasOwnProperty(key))
    array.push(key);
  return array.join(",");
 },
 UpdateInputElements: function(typeName, list){
  for(var i = 0; i < document.forms.length; i++){
   var inputElement = document.forms[i][typeName];
   if(!inputElement)
    inputElement = this.CreateInputElement(document.forms[i], typeName);
   inputElement.value = list;
  }
 },
 CreateInputElement: function(form, typeName){
  var inputElement = ASPx.CreateHiddenField(typeName, typeName);
  form.appendChild(inputElement);
  return inputElement;
 }
};
ASPx.includeScriptPrefix = "dxis_";
ASPx.startupScriptPrefix = "dxss_";
var includeScriptsCache = {};
var createdIncludeScripts = [];
var appendedScriptsCount = 0;
var callbackOwnerNames = [];
var scriptsRestartHandlers = { };
function _aspxIsKnownIncludeScript(script) {
 return !!includeScriptsCache[script.src];
}
function _aspxCacheIncludeScript(script) {
 includeScriptsCache[script.src] = 1;
}
function _aspxProcessScriptsAndLinks(ownerName, isCallback) {
 if(!ASPx.documentLoaded) return; 
 _aspxProcessScripts(ownerName, isCallback);
 getLinkProcessor().process();
 ASPx.ClearCachedCssRules();
}
function _aspxGetStartupScripts() {
 return _aspxGetScriptsCore(ASPx.startupScriptPrefix);
}
function _aspxGetIncludeScripts() {
 return _aspxGetScriptsCore(ASPx.includeScriptPrefix);
}
function _aspxGetScriptsCore(prefix) {
 var result = [];
 var scripts = document.getElementsByTagName("SCRIPT");
 for(var i = 0; i < scripts.length; i++) {
  if(scripts[i].id.indexOf(prefix) == 0)
   result.push(scripts[i]);
 }
 return result;
}
function _aspxGetLinks() {
 var result = [];
 var links = document.getElementsByTagName("LINK");
 for(var i = 0; i < links.length; i++) 
  result[i] = links[i];
 return result;
}
function _aspxIsLinksLoaded() {
 var links = _aspxGetLinks();
 for(var i = 0, link; link = links[i]; i++)
  if(link.readyState && link.readyState.toLowerCase() == "loading")
    return false;
 return true;
}
function _aspxInitializeLinks() {
 var links = _aspxGetLinks();
 for(var i = 0; i < links.length; i++)
  links[i].loaded = true; 
}
var scriptExecutedAttrName = "data-executed";
function isScriptExecuted(script) {
 return ASPx.Attr.GetAttribute(script, scriptExecutedAttrName);
}
function markScriptAsExecuted(script) {
 ASPx.Attr.SetAttribute(script, scriptExecutedAttrName, true);
}
function _aspxInitializeScripts() {
 var scripts = _aspxGetIncludeScripts();
 for(var i = 0; i < scripts.length; i++)
  _aspxCacheIncludeScript(scripts[i]);   
 var startupScripts = _aspxGetStartupScripts();
 for(var i = 0; i < startupScripts.length; i++)
  markScriptAsExecuted(startupScripts[i]);
}
function _aspxSweepDuplicatedLinks() {
 var hash = { };
 var links = _aspxGetLinks();
 for(var i = 0; i < links.length; i++) {
  var href = links[i].href;
  if(!href)
   continue;
  if(hash[href]){
   if((ASPx.Browser.IE || !hash[href].loaded) && links[i].loaded) {
    ASPx.RemoveElement(hash[href]);
    hash[href] = links[i];
   }
   else
    ASPx.RemoveElement(links[i]);
  }
  else
   hash[href] = links[i];
 }
}
function _aspxSweepDuplicatedScripts() {
 var hash = { };
 var scripts = _aspxGetIncludeScripts();
 for(var i = 0; i < scripts.length; i++) {
  var src = scripts[i].src;
  if(!src) continue;
  if(hash[src])
   ASPx.RemoveElement(scripts[i]);
  else
   hash[src] = scripts[i];
 }
}
function _aspxAreScriptsEqual(script1, script2) {
 return script1.src == script2.src;
}
function _aspxProcessScripts(ownerName, isCallback) {
 var scripts = _aspxGetIncludeScripts();
 var previousCreatedScript = null;
 var firstCreatedScript = null;
 for(var i = 0; i < scripts.length; i++) {
  var script = scripts[i];
  if(script.src == "") continue; 
  if(_aspxIsKnownIncludeScript(script))
   continue;
  var createdScript = document.createElement("script");
  createdScript.type = "text/javascript";
  createdScript.src = script.src;
  createdScript.id = script.id;
  if(ASPx.Data.ArrayIndexOf(createdIncludeScripts, createdScript, _aspxAreScriptsEqual) >= 0)
   continue;
  createdIncludeScripts.push(createdScript);
  ASPx.RemoveElement(script);
  if(ASPx.Browser.IE && ASPx.Browser.Version < 9) {
   createdScript.onreadystatechange = new Function("ASPx.OnScriptReadyStateChangedCallback(this, " + isCallback + ");");
  } else if(ASPx.Browser.Edge || ASPx.Browser.WebKitFamily || (ASPx.Browser.Firefox && ASPx.Browser.Version >= 4) || ASPx.Browser.IE && ASPx.Browser.Version >= 9) {
   createdScript.onload = new Function("ASPx.OnScriptLoadCallback(this, " + isCallback + ");");
   if(firstCreatedScript == null)
    firstCreatedScript = createdScript;
   createdScript.nextCreatedScript = null;
   if(previousCreatedScript != null)
    previousCreatedScript.nextCreatedScript = createdScript;
   previousCreatedScript = createdScript;
  } else {
   createdScript.onload = new Function("ASPx.OnScriptLoadCallback(this);");
   ASPx.AppendScript(createdScript);
   _aspxCacheIncludeScript(createdScript);
  }
 }
 if(firstCreatedScript != null) {
  ASPx.AppendScript(firstCreatedScript);
  _aspxCacheIncludeScript(firstCreatedScript);
 }
 if(isCallback)
  callbackOwnerNames.push(ownerName);
 if(createdIncludeScripts.length == 0) {
  var newLinks = ASPx.GetNodesByTagName(document.body, "link");
  var needProcessLinks = isCallback && newLinks.length > 0;
  if(needProcessLinks)
   needProcessLinks = getLinkProcessor().addLinks(newLinks);
  if(!needProcessLinks)
   ASPx.FinalizeScriptProcessing(isCallback);
 }
}
ASPx.FinalizeScriptProcessing = function(isCallback) {
 createdIncludeScripts = [];
 appendedScriptsCount = 0;
 var linkProcessor = getLinkProcessor();
 if(linkProcessor.hasLinks())
  _aspxSweepDuplicatedLinks();
 linkProcessor.reset();
 _aspxSweepDuplicatedScripts();
 _aspxRunStartupScripts(isCallback);
 ResourceManager.SynchronizeResources();
};
var startupScriptsRunning = false;
function _aspxRunStartupScripts(isCallback) {
 startupScriptsRunning = true;
 try {
  _aspxRunStartupScriptsCore();
 }
 finally {
  startupScriptsRunning = false;
 }
 if(ASPx.documentLoaded) {
  ASPx.GetControlCollection().InitializeElements(isCallback);
  for(var key in scriptsRestartHandlers)
   if(scriptsRestartHandlers.hasOwnProperty(key))
    scriptsRestartHandlers[key]();
  _aspxRunEndCallbackScript();
 }
}
function _aspxIsStartupScriptsRunning(isCallback) {
 return startupScriptsRunning;
}
function _aspxRunStartupScriptsCore() {
 var scripts = _aspxGetStartupScripts();
 var code;
 for(var i = 0; i < scripts.length; i++){
  if(!isScriptExecuted(scripts[i])) {
   code = ASPx.GetScriptCode(scripts[i]);
   eval(code);
   markScriptAsExecuted(scripts[i]);
  }
 }
}
function _aspxRunEndCallbackScript() {
 while(callbackOwnerNames.length > 0) {
  var callbackOwnerName = callbackOwnerNames.pop();
  var callbackOwner = ASPx.GetControlCollection().Get(callbackOwnerName);
  if(callbackOwner)
   callbackOwner.DoEndCallback();
 }
}
ASPx.OnScriptReadyStateChangedCallback = function(scriptElement, isCallback) {
 if(scriptElement.readyState == "loaded") {
  _aspxCacheIncludeScript(scriptElement);
  for(var i = 0; i < createdIncludeScripts.length; i++) {
   var script = createdIncludeScripts[i];
   if(_aspxIsKnownIncludeScript(script)) {
    if(!isScriptExecuted(script)) {
     markScriptAsExecuted(script);
     ASPx.AppendScript(script);
     appendedScriptsCount++;
    }
   } else
    break;
  }
  if(createdIncludeScripts.length == appendedScriptsCount)
   ASPx.FinalizeScriptProcessing(isCallback);
 }
};
ASPx.OnScriptLoadCallback = function(scriptElement, isCallback) {
 appendedScriptsCount++;
 if(scriptElement.nextCreatedScript) {
  ASPx.AppendScript(scriptElement.nextCreatedScript);
  _aspxCacheIncludeScript(scriptElement.nextCreatedScript);
 }
 if(createdIncludeScripts.length == appendedScriptsCount)
  ASPx.FinalizeScriptProcessing(isCallback);
};
function _aspxAddScriptsRestartHandler(objectName, handler) {
 scriptsRestartHandlers[objectName] = handler;
}
function _aspxMoveLinkElements() {
 var head = ASPx.GetNodesByTagName(document, "head")[0];
 var bodyLinks = ASPx.GetNodesByTagName(document.body, "link");
 if(head && bodyLinks.length > 0){
  var headLinks = ASPx.GetNodesByTagName(head, "link");
  var dxLinkAnchor = head.firstChild;
  for(var i = 0; i < headLinks.length; i++){
   if(headLinks[i].href.indexOf(ResourceManager.HandlerStr) > -1)
    dxLinkAnchor = headLinks[i].nextSibling;
  }
  while(bodyLinks.length > 0) 
   head.insertBefore(bodyLinks[0], dxLinkAnchor);
 }
}
var LinkProcessor = ASPx.CreateClass(null, {
 constructor: function() {
  this.loadedLinkCount = 0;
  this.linkInfos = [];
  this.loadingObservationTimerID = -1;
 },
 process: function() {
  if(this.hasLinks()) {
   if(this.isLinkLoadEventSupported())
    this.processViaLoadEvent();
   else
    this.processViaTimer();
  }
  else
   _aspxSweepDuplicatedLinks();
  _aspxMoveLinkElements();
 },
 addLinks: function(links) {
  var prevLinkCount = this.linkInfos.length;
  for(var i = 0; i < links.length; i++) {
   var link = links[i];
   if(link.loaded || link.rel != "stylesheet" || link.type != "text/css" || link.href.toLowerCase().indexOf("dxr.axd?r=") == -1)
    continue;
   var linkInfo = {
    link: link,
    href: link.href
   };
   this.linkInfos.push(linkInfo);
  }
  return prevLinkCount != this.linkInfos.length;
 },
 hasLinks: function() {
  return this.linkInfos.length > 0;
 },
 reset: function() {
  this.linkInfos = [];
  this.loadedLinkCount = 0;
 },
 processViaLoadEvent: function() {
  var that = this;
  for(var i = 0, linkInfo; linkInfo = this.linkInfos[i]; i++) {
   if(ASPx.Browser.IE && ASPx.Browser.Version < 9)
    linkInfo.link.onreadystatechange = function() { that.onLinkReadyStateChanged(this); };
   else
    linkInfo.link.onload = this.onLinkLoad.aspxBind(this);
  }
 },
 isLinkLoadEventSupported: function() {
  return !(ASPx.Browser.Chrome && ASPx.Browser.MajorVersion < 19 || ASPx.Browser.Firefox && ASPx.Browser.MajorVersion < 9 ||
   ASPx.Browser.Safari && ASPx.Browser.MajorVersion < 6 || ASPx.Browser.AndroidDefaultBrowser && ASPx.Browser.MajorVersion < 4.4);
 },
 processViaTimer: function() {
  if(this.loadingObservationTimerID == -1)
   this.onLinksLoadingObserve();
 },
 onLinksLoadingObserve: function() {
  if(this.getIsAllLinksLoaded()) {
   this.loadingObservationTimerID = -1;
   this.onAllLinksLoad();
  }
  else
   this.loadingObservationTimerID = window.setTimeout(this.onLinksLoadingObserve.aspxBind(this), 100);
 },
 getIsAllLinksLoaded: function() {
  var styleSheets = document.styleSheets;
  var loadedLinkHrefs = { };
  for(var i = 0; i < styleSheets.length; i++) {
   var styleSheet = styleSheets[i];
   try {
    if(styleSheet.cssRules)
     loadedLinkHrefs[styleSheet.href] = 1;
   }
   catch(ex) { }
  }
  var loadedLinksCount = 0;
  for(var i = 0, linkInfo; linkInfo = this.linkInfos[i]; i++) {
   if(loadedLinkHrefs[linkInfo.href])
    loadedLinksCount++;
  }
  return loadedLinksCount == this.linkInfos.length;
 },
 onAllLinksLoad: function() {
  this.reset();
  _aspxSweepDuplicatedLinks();
  if(createdIncludeScripts.length == 0)
   ASPx.FinalizeScriptProcessing(true);
 },
 onLinkReadyStateChanged: function(linkElement) {
  if(linkElement.readyState == "complete")
   this.onLinkLoadCore(linkElement);
 },
 onLinkLoad: function(evt) {
  var linkElement = ASPx.Evt.GetEventSource(evt);
  this.onLinkLoadCore(linkElement);
 },
 onLinkLoadCore: function(linkElement) {
  if(!this.hasLinkElement(linkElement)) return;
  this.loadedLinkCount++;
  if(!ASPx.Browser.Firefox && this.loadedLinkCount == this.linkInfos.length || 
   ASPx.Browser.Firefox && this.loadedLinkCount == 2 * this.linkInfos.length) {
   this.onAllLinksLoad();
  }
 },
 hasLinkElement: function(linkElement) {
  for(var i = 0, linkInfo; linkInfo = this.linkInfos[i]; i++) {
   if(linkInfo.link == linkElement)
    return true;
  }
  return false;
 }
});
var linkProcessor = null;
function getLinkProcessor() {
 if(linkProcessor == null)
  linkProcessor = new LinkProcessor();
 return linkProcessor;
}
var IFrameHelper = ASPx.CreateClass(null, {
 constructor: function(params) {
  this.params = params || {};
  this.params.src = this.params.src || "";
  this.CreateElements();
 },
 CreateElements: function() {
  var elements = IFrameHelper.Create(this.params);
  this.containerElement = elements.container;
  this.iframeElement = elements.iframe;
  this.AttachOnLoadHandler(this, this.iframeElement);
  this.SetLoading(true);
  if(this.params.onCreate)
   this.params.onCreate(this.containerElement, this.iframeElement);
 },
 AttachOnLoadHandler: function(instance, element) {
  ASPx.Evt.AttachEventToElement(element, "load", function() {
   instance.OnLoad(element);
  });
 },
 OnLoad: function(element) {
  this.SetLoading(false, element);
  if(!element.preventCustomOnLoad && this.params.onLoad)
   this.params.onLoad();
 },
 IsLoading: function(element) {
  element = element || this.iframeElement;
  if(element)
   return element.loading;
  return false;
 },
 SetLoading: function(value, element) {
  element = element || this.iframeElement;
  if(element)
   element.loading = value;
 },
 GetContentUrl: function() {
  return this.params.src;
 },
 SetContentUrl: function(url, preventBrowserCaching) {
  if(url) {
   this.params.src = url;
   if(preventBrowserCaching)
    url = IFrameHelper.AddRandomParamToUrl(url);
   this.SetLoading(true);
   this.iframeElement.src = url;
  }
 },
 RefreshContentUrl: function() {
  if(this.IsLoading())
   return;
  this.SetLoading(true);
  var oldContainerElement = this.containerElement;
  var oldIframeElement = this.iframeElement;
  var postfix = "_del" + Math.floor(Math.random()*100000).toString();
  if(this.params.id)
   oldIframeElement.id = this.params.id + postfix;
  if(this.params.name)
   oldIframeElement.name = this.params.name + postfix;
  ASPx.SetStyles(oldContainerElement, { height: 0 });
  this.CreateElements();
  oldIframeElement.preventCustomOnLoad = true;
  oldIframeElement.src = ASPx.BlankUrl;
  window.setTimeout(function() {
   oldContainerElement.parentNode.removeChild(oldContainerElement);
  }, 10000); 
 }
});
IFrameHelper.Create = function(params) {
 var iframeHtmlStringParts = [ "<iframe frameborder='0'" ];
 if(params) {
  if(params.id)
   iframeHtmlStringParts.push(" id='", params.id, "'");
  if(params.name)
   iframeHtmlStringParts.push(" name='", params.name, "'");
  if(params.title)
   iframeHtmlStringParts.push(" title='", params.title, "'");
  if(params.scrolling)
   iframeHtmlStringParts.push(" scrolling='", params.scrolling, "'");
  if(params.src)
   iframeHtmlStringParts.push(" src='", params.src, "'");
 }
 iframeHtmlStringParts.push("></iframe>");
 var containerElement = ASPx.CreateHtmlElementFromString("<div style='border-width: 0px; padding: 0px; margin: 0px'></div>");
 var iframeElement = ASPx.CreateHtmlElementFromString(iframeHtmlStringParts.join(""));
 containerElement.appendChild(iframeElement);
 return {
  container: containerElement,
  iframe: iframeElement
 };
};
IFrameHelper.AddRandomParamToUrl = function(url) {
 var prefix = url.indexOf("?") > -1
  ? "&"
  : "?";
 var param = prefix + Math.floor(Math.random()*100000).toString();
 var anchorIndex = url.indexOf("#");
 return anchorIndex == -1
  ? url + param
  : url.substr(0, anchorIndex) + param + url.substr(anchorIndex);
};
IFrameHelper.GetWindow = function(name) {
 if(ASPx.Browser.IE)
  return window.frames[name].window;
 else{
  var frameElement = document.getElementById(name);
  return (frameElement != null) ? frameElement.contentWindow : null;
 }
};
IFrameHelper.GetDocument = function(name) {
 var frameElement;
 if(ASPx.Browser.IE) {
  frameElement = window.frames[name];
  return (frameElement != null) ? frameElement.document : null;
 }
 else {
  frameElement = document.getElementById(name);
  return (frameElement != null) ? frameElement.contentDocument : null;
 }
};
IFrameHelper.GetDocumentBody = function(name) {
 var doc = IFrameHelper.GetDocument(name);
 return (doc != null) ? doc.body : null;
};
IFrameHelper.GetDocumentHead = function (name) {
 var doc = IFrameHelper.GetDocument(name);
 return (doc != null) ? doc.head || doc.getElementsByTagName('head')[0] : null;
};
IFrameHelper.GetElement = function(name) {
 if(ASPx.Browser.IE)
  return window.frames[name].window.frameElement;
 else
  return document.getElementById(name);
};
var KbdHelper = ASPx.CreateClass(null, {
 constructor: function(control) {
  this.control = control;
 },
 Init: function() {
  KbdHelper.GlobalInit();
  var elements = this.getFocusableElements();
  for(var i = 0; i < elements.length; i++) {
   var element = elements[i];
   element.tabIndex = Math.max(element.tabIndex, 0);
   ASPx.Evt.AttachEventToElement(element, "click", function(e) { this.HandleClick(e); }.aspxBind(this));
   ASPx.Evt.AttachEventToElement(element, "focus", function(e) {    
    return this.onElementFocus(e);
   }.aspxBind(this));
   ASPx.Evt.AttachEventToElement(element, "blur", function () { this.onBlur(); }.aspxBind(this)); 
  }   
 },
 onElementFocus: function(e) {
  if(!this.CanFocus(e))
   return true;
  KbdHelper.active = this;
 },
 getFocusableElements: function() {
  return [this.GetFocusableElement()]; 
 },
 GetFocusableElement: function() { return this.control.GetMainElement(); },
 canHandleNoFocusAction: function() { 
  var focusableElements = this.getFocusableElements();
  for(var i = 0; i < focusableElements.length; i++) {
   if(focusableElements[i] === _aspxGetFocusedElement())
    return false;
  }
  return true;
 },
 CanFocus: function(e) {
  var tag = ASPx.Evt.GetEventSource(e).tagName;
  if(tag == "A" || tag == "TEXTAREA" || tag == "INPUT" || tag == "SELECT" || tag == "IFRAME" || tag == "OBJECT")
   return false; 
  return true;
 },
 HandleClick: function(e) {
  if(!this.CanFocus(e))
   return;
  this.Focus();
 },
 Focus: function() {
  try {
   this.GetFocusableElement().focus();   
  } catch(e) {
  }
 },
 onBlur: function(){
  delete KbdHelper.active;
 },
 HandleKeyDown: function(e) { }, 
 HandleKeyPress: function(e) { }, 
 HandleKeyUp: function (e) { },
 HandleNoFocusAction: function(e) { },
 FocusByAccessKey: function () { }
});
KbdHelper.GlobalInit = function() {
 if(KbdHelper.ready)
  return;
 ASPx.Evt.AttachEventToDocument("keydown", KbdHelper.OnKeyDown);
 ASPx.Evt.AttachEventToDocument("keypress", KbdHelper.OnKeyPress);
 ASPx.Evt.AttachEventToDocument("keyup", KbdHelper.OnKeyUp);
 KbdHelper.ready = true; 
};
KbdHelper.swallowKey = false;
KbdHelper.accessKeys = { };
KbdHelper.ProcessKey = function(e, actionName) {
 if(!KbdHelper.active) 
  return;
 if (KbdHelper.active.canHandleNoFocusAction()) {
  KbdHelper.active["HandleNoFocusAction"](e, actionName);
  return;
 }
 var ctl = KbdHelper.active.control;
 if(ctl !== ASPx.GetControlCollection().Get(ctl.name)) {
  delete KbdHelper.active;
  return;
 }
 if(!KbdHelper.swallowKey) 
  KbdHelper.swallowKey = KbdHelper.active[actionName](e);
 if(KbdHelper.swallowKey)
  ASPx.Evt.PreventEvent(e);
};
KbdHelper.OnKeyDown = function(e) {
 KbdHelper.swallowKey = false;
 if(KbdHelper.TryAccessKey(KbdHelper.getKeyName(e)))
  ASPx.Evt.PreventEvent(e);
 else 
  KbdHelper.ProcessKey(e, "HandleKeyDown"); 
};
KbdHelper.OnKeyPress = function(e) { KbdHelper.ProcessKey(e, "HandleKeyPress"); };
KbdHelper.OnKeyUp = function(e) { KbdHelper.ProcessKey(e, "HandleKeyUp"); };
KbdHelper.RegisterAccessKey = function(obj) {
 var key;
 if(obj.accessKey)
  key = "CtrlShift" + obj.accessKey;
 else if(obj.keyTipModeShortcut)
  key = obj.keyTipModeShortcut;
 if(!key) return;
 KbdHelper.accessKeys[key.toLowerCase()] = obj.name;
};
KbdHelper.TryAccessKey = function(code) {
 var key = code.toLowerCase ? code.toLowerCase() : String.fromCharCode(code).toLowerCase();
 var name = KbdHelper.accessKeys[key];
 if(!name) return false;
 var obj = ASPx.GetControlCollection().Get(name);
 return KbdHelper.ClickAccessKey(obj);
};
KbdHelper.ClickAccessKey = function (control) {
 if (!control) return false;
 var el = control.GetMainElement();
 if (!el) return false;
 el.focus();
 setTimeout(function () {
  if (KbdHelper.active && KbdHelper.active.FocusByAccessKey)
   KbdHelper.active.FocusByAccessKey();
 }.aspxBind(this), 100);
 return true;
};
KbdHelper.getKeyName = function(e) {
 var name = "";
 if(e.altKey)
  name += "Alt";
 if(e.ctrlKey)
  name += "Ctrl";
 if(e.shiftKey)
  name += "Shift";
 var keyCode = e.key || e.code || String.fromCharCode(ASPx.Evt.GetKeyCode(e));
 if(keyCode.match(/key/i))
  name += keyCode.replace(/key/i, "");
 else if(keyCode.match(/digit/i))
  name += keyCode.replace(/digit/i, "");
 else if(keyCode.match(/arrow/i))
  name += keyCode.replace(/arrow/i, "");
 else if(keyCode.match(/ins/i))
  name += "Ins";
 else if(keyCode.match(/del/i))
  name += "Del";
 else if(keyCode.match(/back/i))
  name += "Back";
 else if(!keyCode.match(/alt/i) && !keyCode.match(/control/i) && !keyCode.match(/shift/i))
  name += keyCode;
 return name.replace(/^a-zA-Z0-9/, "");
};
AccessKeysHelper = ASPx.CreateClass(KbdHelper, {
 constructor: function (control) {
  this.constructor.prototype.constructor.call(this, control);
  this.accessKeysVisible = false;
  this.activeKey = null;
  this.accessKey = new AccessKey(control.accessKey);
  this.accessKeys = this.accessKey.accessKeys;
  this.charIndex = 0;
  this.onFocusByAccessKey = null;
  this.onClose = null;
  this.manualStopProcessing = false;
  this.isActive = false;
 },
 Init: function (control) {
  KbdHelper.prototype.Init.call(this);
  KbdHelper.RegisterAccessKey(control);   
 },
 Add: function (accessKey) {
  this.accessKey.Add(accessKey);
 },
 HandleKeyDown: function (e) {
  var keyCode = ASPx.Evt.GetKeyCode(e);
  var stopProcessing = this.processKeyDown(keyCode);
  if (stopProcessing.value) {
   this.stopProcessing();
   if(this.onClosedOnEscape && (keyCode == ASPx.Key.Esc || stopProcessing.fireEvent))
    this.onClosedOnEscape();
  }
  return stopProcessing;
 },
 HandleNoFocusAction: function (e, actionName) {
  var keyCode = ASPx.Evt.GetKeyCode(e);
  if (this.onClosedOnEscape && keyCode == ASPx.Key.Esc && actionName == "HandleKeyDown")
   this.onClosedOnEscape();
 },
 Activate: function () {
  KbdHelper.ClickAccessKey(this.control);
 },
 Stop: function() {
  this.stopProcessing();
 },
 stopProcessing: function () {
  this.HideAccessKeys();
  if (KbdHelper.active && this.isActive) {
   this.isActive = false;
   KbdHelper.active.control.GetMainElement().blur();
   delete KbdHelper.active;
  }
 },
 onBlur: function () {
  if (this.manualStopProcessing) {
   this.manualStopProcessing = false;
   return;
  }
  this.HideAccessKeys();
  KbdHelper.prototype.onBlur.call(this);
 },
 processKeyDown: function (keyCode) {
  switch (keyCode) {
   case ASPx.Key.Left:
    this.TryMoveFocusLeft();
    return { value: false };
   case ASPx.Key.Right:
    this.TryMoveFocusRight();
    return { value: false };
   case ASPx.Key.Esc:
    if(this.control.hideAllPopups)
     this.control.hideAllPopups(true, true);
    if(this.activeKey)
     this.activeKey = this.activeKey.Return();
    this.charIndex = 0;
    if (!this.activeKey)
     return { value: true };
    break;
   case ASPx.Key.Enter:
    return { value: true };
   default:
    if (!ASPx.IsPrintableKey(keyCode))
     return { value: false };
    var char = String.fromCharCode(keyCode).toUpperCase();
    var needToContinue = { value: false };
    var keyResult;
    if(this.activeKey)
     keyResult = this.activeKey.TryAccessKey(char, this.charIndex, needToContinue);
    if (needToContinue.value) {
     this.charIndex++;
     return { value: false };
    }
    this.charIndex = 0;
    if(keyResult !== undefined)
     this.activeKey = keyResult;
    else
     return { value: true, fireEvent: true };
    if (!this.activeKey || !this.activeKey.accessKeys || this.activeKey.accessKeys.length == 0) {
     if (this.activeKey && this.activeKey.manualStopProcessing) {
      this.manualStopProcessing = true;
      break;
     }
     return { value: true, fireEvent: true };
    }
  }
  return { value: false };
 },
 TryMoveFocusLeft: function (modifier) {},
 TryMoveFocusRight: function (modifier) {},
 TryMoveFocusUp: function (modifier) {},
 TryMoveFocusDown: function (modifier) {},
 FocusByAccessKey: function () {
  if (this.onFocusByAccessKey)
   this.onFocusByAccessKey();
  this.HideAccessKeys();
  KbdHelper.prototype.FocusByAccessKey.call(this);
  this.activeKey = this.accessKey;
  this.activeKey.execute();
  this.isActive = true;
 },
 HideAccessKeys: function(){
  this.hideAccessKeys(this.accessKey);
 }, 
 hideAccessKeys: function (accessKey) {
  for (var i = 0, ak; ak = accessKey.accessKeys[i]; i++) {
   this.hideAccessKeys(ak);
  }
  if (accessKey)
   accessKey.hide();
 },
 HandleClick: function(e) {
  KbdHelper.prototype.HandleClick.call(this, e);
  this.stopProcessing();
 }
});
AccessKey = ASPx.CreateClass(null, {
 constructor: function (popupItem, getPopupElement, keyTipElement, key, onlyClick, manualStopProcessing) {
  this.key = key ? key : keyTipElement ? ASPxClientUtils.Trim(ASPx.GetInnerText(keyTipElement)) : null;
  this.popupItem = popupItem;
  this.getPopupElement = getPopupElement;
  this.keyTipElement = keyTipElement;
  this.accessKeys = [];
  this.needShowChilds = true;
  this.parent = null;
  this.onlyClick = onlyClick;
  this.manualStopProcessing = manualStopProcessing;
 },
 Add: function (accessKey) {
  this.accessKeys.push(accessKey);
  accessKey.parent = this;
 },
 TryAccessKey: function (char, index, needToContinue) {
  if (!this.accessKeys || this.accessKeys.length == 0)
   return;
  for (var i = 0, accessKey; accessKey = this.accessKeys[i]; i++) {
   if (accessKey.key[index] == char && accessKey.isVisible()) {
    if (accessKey.key[index + 1]) {
     needToContinue.value = true;
    }
    else {
     accessKey.execute();
     return accessKey;
    }
   } else {
    accessKey.hide();
   }
  }
  for (var i = 0, accessKey; accessKey = this.accessKeys[i]; i++) {
   var key = accessKey.TryAccessKey(char, index, needToContinue);
   if (key)
    return key;
  }
  return;
 },
 isVisible: function(){
  return ASPx.GetElementVisibility(this.keyTipElement);
 },
 Return: function () {
  this.hideChildAccessKeys();
  if (this.parent) {
   this.parent.showAccessKeys(true);
  }  
  return this.parent;
 },
 execute: function () {
  this.hideAll();
  if (this.popupItem && this.popupItem.accessKeyClick && !this.onlyClick)
   this.popupItem.accessKeyClick();
  if (this.getPopupElement && this.onlyClick)
   ASPx.Evt.EmulateMouseClick(this.getPopupElement(this.popupItem));
  if (this.accessKeys)
   setTimeout(function () {
    this.showAccessKeys(true);
   }.aspxBind(this), 100);
 },
 showAccessKeys: function (directShow) {
  if (!directShow && !this.needShowChilds)
   return;
  for (var i = 0; i < this.accessKeys.length; i++) {
   var accessKey = this.accessKeys[i];
   if (accessKey) {
    var popupElement = accessKey.getPopupElement ? accessKey.getPopupElement(accessKey.popupItem) : null;
    if (popupElement && ASPx.IsElementVisible(popupElement, true)) {
     this.show(accessKey);
    }
    accessKey.showAccessKeys();
   }
  }
 },
 show: function (accessKey) {
  var keyTipElement = accessKey.keyTipElement;
  var popupElement = accessKey.getPopupElement(accessKey.popupItem);
  var top = ASPx.GetAbsolutePositionY(popupElement);
  var left = ASPx.GetAbsolutePositionX(popupElement);
  if (accessKey.popupItem.getAccessKeyPosition)
   switch (accessKey.popupItem.getAccessKeyPosition()) {
    case "AboveRight":
     left = left + popupElement.offsetWidth - keyTipElement.offsetWidth / 3;
     top = top - keyTipElement.offsetHeight / 2;
     break;
    case "Right":
     left = left + popupElement.offsetWidth - keyTipElement.offsetWidth / 3;
     top = top + popupElement.offsetHeight / 2 - keyTipElement.offsetHeight / 2;
     break;
    case "BelowRight":
     left = left + popupElement.offsetWidth - keyTipElement.offsetWidth / 3;
     top = top + keyTipElement.offsetHeight / 2;
     break;
    default:
     top = top + popupElement.offsetHeight;
     left = left + popupElement.offsetWidth / 2 - keyTipElement.offsetWidth / 2;
     break;
   }
  else {
   top = top + popupElement.offsetHeight;
   left = left + popupElement.offsetWidth / 2 - keyTipElement.offsetWidth / 2;
  }
  ASPx.SetAbsoluteY(keyTipElement, top);
  ASPx.SetAbsoluteX(keyTipElement, left);
  ASPx.SetElementVisibility(keyTipElement, true); 
 },
 hide: function () {
  if (this.keyTipElement)
   ASPx.SetElementVisibility(this.keyTipElement, false);
 },
 hideChildAccessKeys: function () {
  this.hideAccessKeys(this.accessKeys);
 },
 hideAccessKeys: function (accessKeys) {
  if (accessKeys) {
   for (var i = 0, accessKey; accessKey = accessKeys[i]; i++) {
    if (accessKey.keyTipElement)
     accessKey.hide();
    accessKey.hideChildAccessKeys();
   }
  }
 },
 hideAll: function () {
  this.getRoot(this).hideChildAccessKeys();
 },
 getRoot: function (accessKey) {
  if (!accessKey.parent)
   return accessKey;
  return this.getRoot(accessKey.parent);
 }
});
var focusedElement = null;
function aspxOnElementFocused(evt) {
 evt = ASPx.Evt.GetEvent(evt);
 if(evt && evt.target)
  focusedElement = evt.target;
}
function _aspxInitializeFocus() {
 if(!ASPx.GetActiveElement())
  ASPx.Evt.AttachEventToDocument("focus", aspxOnElementFocused);
}
function _aspxGetFocusedElement() {
 var activeElement = ASPx.GetActiveElement();
 return activeElement ? activeElement : focusedElement;
}
CheckBoxCheckState = {
 Checked : "Checked",
 Unchecked : "Unchecked",
 Indeterminate : "Indeterminate"
};
CheckBoxInputKey = { 
 Checked : "C",
 Unchecked : "U",
 Indeterminate : "I"
};
var CheckableElementStateController = ASPx.CreateClass(null, {
 constructor: function(imageProperties) {
  this.checkBoxStates = [];
  this.imageProperties = imageProperties;
  this.customImageMarkerClassName = "dxcbCI";
 },
 GetValueByInputKey: function(inputKey) {
  return this.GetFirstValueBySecondValue("Value", "StateInputKey", inputKey);
 },
 GetInputKeyByValue: function(value) {
  return this.GetFirstValueBySecondValue("StateInputKey", "Value", value);
 },
 GetImagePropertiesNumByInputKey: function(value) {
  return this.GetFirstValueBySecondValue("ImagePropertiesNumber", "StateInputKey", value);
 },
 GetNextCheckBoxValue: function(currentValue, allowGrayed) {
  var currentInputKey = this.GetInputKeyByValue(currentValue);
  var nextInputKey = '';
  switch(currentInputKey) {
   case CheckBoxInputKey.Checked:
    nextInputKey = CheckBoxInputKey.Unchecked; break;
   case CheckBoxInputKey.Unchecked:
    nextInputKey = allowGrayed ? CheckBoxInputKey.Indeterminate : CheckBoxInputKey.Checked; break;
   case CheckBoxInputKey.Indeterminate:
    nextInputKey = CheckBoxInputKey.Checked; break;
  }
  return this.GetValueByInputKey(nextInputKey);
 },
 GetCheckStateByInputKey: function(inputKey) {
  switch(inputKey) {
   case CheckBoxInputKey.Checked: 
    return CheckBoxCheckState.Checked;
   case CheckBoxInputKey.Unchecked: 
    return CheckBoxCheckState.Unchecked;
   case CheckBoxInputKey.Indeterminate: 
    return CheckBoxCheckState.Indeterminate;
  }
 },
 GetValueByCheckState: function(checkState) {
  switch(checkState) {
   case CheckBoxCheckState.Checked: 
    return this.GetValueByInputKey(CheckBoxInputKey.Checked);
   case CheckBoxCheckState.Unchecked: 
    return this.GetValueByInputKey(CheckBoxInputKey.Unchecked);
   case CheckBoxCheckState.Indeterminate: 
    return this.GetValueByInputKey(CheckBoxInputKey.Indeterminate);
  }
 },
 GetFirstValueBySecondValue: function(firstValueName, secondValueName, secondValue) {
  return this.GetValueByFunc(firstValueName, 
   function(checkBoxState) { return checkBoxState[secondValueName] === secondValue; });
 },
 GetValueByFunc: function(valueName, func) {
  for(var i = 0; i < this.checkBoxStates.length; i++) {
   if(func(this.checkBoxStates[i]))
    return this.checkBoxStates[i][valueName];
  }  
 },
 AssignElementClassName: function(element, cssClassPropertyKey, disabledCssClassPropertyKey, assignedClassName) {
  var classNames = [ ];
  for(var i = 0; i < this.imageProperties[cssClassPropertyKey].length; i++) {
   classNames.push(this.imageProperties[disabledCssClassPropertyKey][i]);
   classNames.push(this.imageProperties[cssClassPropertyKey][i]);
  }
  var elementClassName = element.className;
  for(var i = 0; i < classNames.length; i++) {
   var className = classNames[i];
   var index = elementClassName.indexOf(className);
   if(index > -1)
    elementClassName = elementClassName.replace((index == 0 ? '' : ' ') + className, "");
  }
  elementClassName += " " + assignedClassName;
  element.className = elementClassName;
 },
 UpdateInternalCheckBoxDecoration: function(mainElement, inputKey, enabled) {
  var imagePropertiesNumber = this.GetImagePropertiesNumByInputKey(inputKey);
  for(var imagePropertyKey in this.imageProperties) {
   if(this.imageProperties.hasOwnProperty(imagePropertyKey)) {
    var propertyValue = this.imageProperties[imagePropertyKey][imagePropertiesNumber];
    propertyValue = propertyValue || !isNaN(propertyValue) ? propertyValue : "";
    switch(imagePropertyKey) {
     case "0" : mainElement.title = propertyValue; break;
     case "1" : mainElement.style.width = propertyValue + (propertyValue != "" ? "px" : ""); break;
     case "2" : mainElement.style.height = propertyValue + (propertyValue != "" ? "px" : ""); break;
    }
    if(enabled) {
     switch(imagePropertyKey) {
      case "3" : this.SetImageSrc(mainElement, propertyValue); break;
      case "4" : 
       this.AssignElementClassName(mainElement, "4", "8", propertyValue);
       break;
      case "5" : this.SetBackgroundPosition(mainElement, propertyValue, true); break;
      case "6" : this.SetBackgroundPosition(mainElement, propertyValue, false); break;
     }
    } else {
     switch(imagePropertyKey) {
      case "7" : this.SetImageSrc(mainElement, propertyValue); break;
      case "8" : 
       this.AssignElementClassName(mainElement, "4", "8", propertyValue);
       break;
      case "9" : this.SetBackgroundPosition(mainElement, propertyValue, true); break;
      case "10" : this.SetBackgroundPosition(mainElement, propertyValue, false); break;
     }
    }
   }
  }
 },
 SetImageSrc: function(mainElement, src) {
  if(src === ""){
   mainElement.style.backgroundImage = "";
   mainElement.style.backgroundPosition = "";
   ASPx.RemoveClassNameFromElement(mainElement, this.customImageMarkerClassName);
  }
  else{
   mainElement.style.backgroundImage = "url('" + src + "')";
   this.SetBackgroundPosition(mainElement, 0, true);
   this.SetBackgroundPosition(mainElement, 0, false);
   ASPx.AddClassNameToElement(mainElement, this.customImageMarkerClassName);
  }
 },
 SetBackgroundPosition: function(element, value, isX) {
  if(value === "") {
   element.style.backgroundPosition = value;
   return;
  }
  if(element.style.backgroundPosition === "")
   element.style.backgroundPosition = isX ? "-" + value.toString() + "px 0px" : "0px -" + value.toString() + "px";
  else {
   var position = element.style.backgroundPosition.split(' ');
   element.style.backgroundPosition = isX ? '-' + value.toString() + "px " + position[1] :  position[0] + " -" + value.toString() + "px";
  }
 },
 AddState: function(value, stateInputKey, imagePropertiesNumber) {
  this.checkBoxStates.push({
   "Value" : value, 
   "StateInputKey" : stateInputKey, 
   "ImagePropertiesNumber" : imagePropertiesNumber
  });
 },
 GetAriaCheckedValue: function(state) {
  switch(state) {
   case ASPx.CheckBoxCheckState.Checked: return "true";
   case ASPx.CheckBoxCheckState.Unchecked: return "false";
   case ASPx.CheckBoxCheckState.Indeterminate: return "mixed";
   default: return "";
  }
 }
});
CheckableElementStateController.Create = function(imageProperties, valueChecked, valueUnchecked, valueGrayed, allowGrayed) {
 var stateController = new CheckableElementStateController(imageProperties);
 stateController.AddState(valueChecked, CheckBoxInputKey.Checked, 0);
 stateController.AddState(valueUnchecked, CheckBoxInputKey.Unchecked, 1);
 if(typeof(valueGrayed) != "undefined")
  stateController.AddState(valueGrayed, CheckBoxInputKey.Indeterminate, allowGrayed ? 2 : 1);
 stateController.allowGrayed = allowGrayed;
 return stateController;
};
var CheckableElementHelper = ASPx.CreateClass(null, {
 InternalCheckBoxInitialize: function(internalCheckBox) {
  this.AttachToMainElement(internalCheckBox);
  this.AttachToInputElement(internalCheckBox);
 },
 AttachToMainElement: function(internalCheckBox) {
  var instance = this;
  if(internalCheckBox.mainElement) {
    var toggleEvent = internalCheckBox.displaySwitch ? ASPx.TouchUIHelper.touchMouseDownEventName : "click";
    ASPx.Evt.AttachEventToElement(internalCheckBox.mainElement, toggleEvent,
    function (evt) {
     if(ASPx.Evt.IsRightButtonPressed(evt))
      return;
     instance.InvokeClick(internalCheckBox, evt);
     if(!internalCheckBox.disableCancelBubble)
      return ASPx.Evt.PreventEventAndBubble(evt);
    }
   );
   ASPx.Evt.AttachEventToElement(internalCheckBox.mainElement, "mousedown",
    function (evt) {
     internalCheckBox.Refocus();
    }
   );
   ASPx.Evt.PreventElementDragAndSelect(internalCheckBox.mainElement, true);
  }
 },
 AttachToInputElement: function(internalCheckBox) {
  var instance = this;
  if(internalCheckBox.inputElement && internalCheckBox.mainElement) {
   var checkableElement = internalCheckBox.accessibilityCompliant ? internalCheckBox.mainElement : internalCheckBox.inputElement;
   ASPx.Evt.AttachEventToElement(checkableElement, "focus",
    function (evt) { 
     if(!internalCheckBox.enabled)
      checkableElement.blur();
     else
      internalCheckBox.OnFocus();
    }
   );
   ASPx.Evt.AttachEventToElement(checkableElement, "blur", 
    function (evt) { 
     internalCheckBox.OnLostFocus();
    }
   );
   ASPx.Evt.AttachEventToElement(checkableElement, "keyup",
    function (evt) { 
     if(ASPx.Evt.GetKeyCode(evt) == ASPx.Key.Space)
      instance.InvokeClick(internalCheckBox, evt);
    }
   );
   ASPx.Evt.AttachEventToElement(checkableElement, "keydown",
    function (evt) { 
     if(ASPx.Evt.GetKeyCode(evt) == ASPx.Key.Space)
      return ASPx.Evt.PreventEvent(evt);
    }
   );
  }
 },
 IsKBSInputWrapperExist: function() {
  return ASPx.Browser.Opera || ASPx.Browser.WebKitFamily;
 },
 GetICBMainElementByInput: function(icbInputElement) {
  return this.IsKBSInputWrapperExist() ? icbInputElement.parentNode.parentNode : icbInputElement.parentNode;
 },
 RequirePreventFocus: function() { return false; },
 InvokeClick: function(internalCheckBox, evt) {
   if(internalCheckBox.enabled && !internalCheckBox.readOnly) {
   var inputElementValue = internalCheckBox.inputElement.value;
   var focusableElement = internalCheckBox.accessibilityCompliant ? internalCheckBox.mainElement : internalCheckBox.inputElement; 
   if(!this.RequirePreventFocus())
    focusableElement.focus();
   if(!ASPx.Browser.IE) 
    internalCheckBox.inputElement.value = inputElementValue;
   this.InvokeClickCore(internalCheckBox, evt);
   }
 },
 InvokeClickCore: function(internalCheckBox, evt) {
  internalCheckBox.OnClick(evt);
 }
});
CheckableElementHelper.Instance = new CheckableElementHelper();
var CheckBoxInternal = ASPx.CreateClass(null, {
 constructor: function(inputElement, stateController, allowGrayed, allowGrayedByClick, helper, container, storeValueInInput, key, disableCancelBubble,
  accessibilityCompliant, displaySwitch) {
  this.inputElement = inputElement;
  this.mainElement = helper.GetICBMainElementByInput(this.inputElement);
  this.name = (key ? key : this.inputElement.id) + CheckBoxInternal.GetICBMainElementPostfix();
  this.mainElement.id = this.name;
  this.stateController = stateController;
  this.container = container;
  this.allowGrayed = allowGrayed;
  this.allowGrayedByClick = allowGrayedByClick;
  this.autoSwitchEnabled = true;
  this.displaySwitch = displaySwitch;
  this.storeValueInInput = !!storeValueInInput;
  this.storedInputKey = !this.storeValueInInput ? this.inputElement.value : null;
  this.disableCancelBubble = !!disableCancelBubble;
  this.accessibilityCompliant = accessibilityCompliant;
  this.focusDecoration = null;
  this.focused = false;
  this.focusLocked = false;
  this.enabled = !this.mainElement.className.match(/dxWeb_\w+Disabled(\b|_)/);
  this.readOnly = false;
  this.preventFocus = helper.RequirePreventFocus();
  this.CheckedChanged = new ASPxClientEvent();
  this.Focus = new ASPxClientEvent();
  this.LostFocus = new ASPxClientEvent();
  helper.InternalCheckBoxInitialize(this);
 },
 ChangeInputElementTabIndex: function() {  
  var changeMethod = this.enabled ? ASPx.Attr.RestoreTabIndexAttribute : ASPx.Attr.SaveTabIndexAttributeAndReset;
  changeMethod(this.inputElement);
 },
 CreateFocusDecoration: function(focusedStyle) {
   this.focusDecoration = new EditorStyleDecoration(this);
   this.focusDecoration.AddStyle('F', focusedStyle[0], focusedStyle[1]);
   this.focusDecoration.AddPostfix("");
 },
 UpdateFocusDecoration: function() {
  this.focusDecoration.Update();
 },  
 StoreInputKey: function(inputKey) {
  if(this.storeValueInInput)
   this.inputElement.value = inputKey;
  else
   this.storedInputKey = inputKey;
 },
 GetStoredInputKey: function() {
  if(this.storeValueInInput)
   return this.inputElement.value;
  else
   return this.storedInputKey;
 },
 OnClick: function(e) {
  if(this.autoSwitchEnabled) {
   var currentValue = this.GetValue();
   var value = this.stateController.GetNextCheckBoxValue(currentValue, this.allowGrayedByClick && this.allowGrayed);
   this.SetValue(value);
  }
  this.CheckedChanged.FireEvent(this, e);
 },
 OnFocus: function() {
  if(!this.IsFocusLocked()) {
   this.focused = true;
   this.UpdateFocusDecoration();
   this.Focus.FireEvent(this, null);
  } else
   this.UnlockFocus();
 },
 OnLostFocus: function() {
  if(!this.IsFocusLocked()) {
   this.focused = false;
   this.UpdateFocusDecoration();
   this.LostFocus.FireEvent(this, null);
  }
 },
 Refocus: function() {
  if(this.preventFocus) return;
  if(this.focused) {
   this.LockFocus();
   this.inputElement.blur();
   if(ASPx.Browser.MacOSMobilePlatform) {
    window.setTimeout(function() {
     ASPx.SetFocus(this.inputElement);
    }, 100);
   } else {
    ASPx.SetFocus(this.inputElement);
   }
  }
 },
 LockFocus: function() {
  this.focusLocked = true;
 },
 UnlockFocus: function() {
  this.focusLocked = false;
 },
 IsFocusLocked: function() {
  if(!!ASPx.Attr.GetAttribute(this.mainElement, ASPx.Attr.GetTabIndexAttributeName()))
   return false;
  return this.focusLocked;
 },
 SetValue: function(value) {
  var currentValue = this.GetValue();
  if(currentValue !== value) {
   var newInputKey = this.stateController.GetInputKeyByValue(value);
   if(newInputKey) {
    this.StoreInputKey(newInputKey);   
    this.stateController.UpdateInternalCheckBoxDecoration(this.mainElement, newInputKey, this.enabled);
   }
  }
  if(this.accessibilityCompliant) {
   var state = this.GetCurrentCheckState();
   var value = this.stateController.GetAriaCheckedValue(state);
   if(this.mainElement.attributes["aria-checked"] !== undefined)
    this.mainElement.setAttribute("aria-checked", value); 
   if(this.mainElement.attributes["aria-selected"] !== undefined)
    this.mainElement.setAttribute("aria-selected", value); 
  }
 },
 GetValue: function() {
  return this.stateController.GetValueByInputKey(this.GetCurrentInputKey());
 },
 GetCurrentCheckState: function() {
  return this.stateController.GetCheckStateByInputKey(this.GetCurrentInputKey());
 },
 GetCurrentInputKey: function() {
  return this.GetStoredInputKey();
 },
 GetChecked: function() {
  return this.GetCurrentInputKey() === CheckBoxInputKey.Checked;
 },
 SetChecked: function(checked) {
  var newValue = this.stateController.GetValueByCheckState(checked ? CheckBoxCheckState.Checked : CheckBoxCheckState.Unchecked);
  this.SetValue(newValue);
 },
 SetEnabled: function(enabled) {
  if(this.enabled != enabled) {
   this.enabled = enabled;
   this.stateController.UpdateInternalCheckBoxDecoration(this.mainElement, this.GetCurrentInputKey(), this.enabled);
   this.ChangeInputElementTabIndex();
  }
 },
 GetEnabled: function() {
  return this.enabled;
 }
});
CheckBoxInternal.GetICBMainElementPostfix = function() {
 return "_D";
};
var CheckBoxInternalCollection = ASPx.CreateClass(CollectionBase, {
 constructor: function(imageProperties, allowGrayed, storeValueInInput, helper, disableCancelBubble, accessibilityCompliant) {
  this.constructor.prototype.constructor.call(this);
  this.stateController = allowGrayed 
   ? CheckableElementStateController.Create(imageProperties, CheckBoxInputKey.Checked, CheckBoxInputKey.Unchecked, CheckBoxInputKey.Indeterminate, true)
   : CheckableElementStateController.Create(imageProperties, CheckBoxInputKey.Checked, CheckBoxInputKey.Unchecked);
  this.helper = helper || CheckableElementHelper.Instance;
  this.storeValueInInput = !!storeValueInInput;
  this.disableCancelBubble = !!disableCancelBubble;
  this.accessibilityCompliant = accessibilityCompliant;
 },
 Add: function(key, inputElement, container) {
  this.Remove(key);
  var checkBox = this.CreateInternalCheckBox(key, inputElement, container);
  CollectionBase.prototype.Add.call(this, key, checkBox);
  return checkBox;
 },
 SetImageProperties: function(imageProperties) {
  this.stateController.imageProperties = imageProperties;
 },
 CreateInternalCheckBox: function(key, inputElement, container) {
  return new CheckBoxInternal(inputElement, this.stateController, this.stateController.allowGrayed, false, this.helper, container, 
   this.storeValueInInput, key, this.disableCancelBubble, this.accessibilityCompliant);
 }
});
var EditorStyleDecoration = ASPx.CreateClass(null, {
 constructor: function(editor) {
  this.editor = editor;
  this.postfixList = [ ];
  this.styles = { };
  this.innerStyles = { };
  this.nullTextClassName = "";
  this.lockUpdate = false;
 },
 GetStyleSheet: function() {
  return ASPx.GetCurrentStyleSheet();
 },
 AddPostfix: function(value, applyClass, applyBorders, applyBackground) {
  this.postfixList.push(value);
 },
 AddStyle: function(key, className, cssText) {
  this.styles[key] = this.CreateRule(className, cssText);
  this.innerStyles[key] = this.CreateRule("", this.FilterInnerCss(cssText));
 },
 CreateRule: function(className, cssText) {
  return ASPx.Str.Trim(className + " " + ASPx.CreateImportantStyleRule(this.GetStyleSheet(), cssText));
 },
 GetElementByPostfix: function(postfix) {
  return ASPx.GetElementById(this.editor.name + postfix);
 },
 LockUpdate: function() {
  this.lockUpdate = true;
 },
 UnlockUpdate: function() {
  this.lockUpdate = false;
 },
 IsUpdateLocked: function() {
  return this.lockUpdate;
 },
 Update: function() {
  if(this.IsUpdateLocked())
   return;
  this.UpdateCore();
 },
 UpdateCore: function() {
  for(var i = 0; i < this.postfixList.length; i++) {
   var postfix = this.postfixList[i];
   var inner = postfix.length > 0;
   var element = this.GetElementByPostfix(postfix);
   this.ApplyStyles(element, inner);
  }
 },
 ApplyStyles: function(element, inner) {
  if(element) {
   this.ApplyInvalidStyle(element, inner);
   this.ApplyFocusedStyle(element, inner);
   this.ApplyNullTextStyle(element, inner);
  }
 },
 ApplyInvalidStyle: function(element, inner) {
  if(this.HasDecoration("I")) {
   var isValid = this.editor.GetIsValid();
   this.ApplyDecoration("I", element, inner, !isValid);
  }
 },
 ApplyFocusedStyle: function(element, inner) {
  if(this.HasDecoration("F"))
   this.ApplyDecoration("F", element, inner, this.editor.focused);
 },
 ApplyNullTextStyle: function(element, inner) {
  if(!this.HasDecoration("N"))
   return;  
  var apply = !this.editor.focused;
  if(apply) {
   if(this.editor.CanApplyNullTextDecoration) {
    apply = this.editor.CanApplyNullTextDecoration();
   } else {
    var value = this.editor.GetValue();
    apply = apply && (value == null || value === "");
   }
  }
  if(apply)
   ASPx.Attr.ChangeAttribute(element, "spellcheck", "false");
  else
   ASPx.Attr.RestoreAttribute(element, "spellcheck");
  this.ApplyDecoration("N", element, inner, apply);
 },
 HasDecoration: function(key) {
  return !!this.styles[key];
 },
 ApplyNullTextClassName: function(active) {
  var nullTextClassName = this.GetNullTextClassName();
  var editorMainElement = this.editor.GetMainElement();
  if (active)
   ASPx.AddClassNameToElement(editorMainElement, nullTextClassName);
  else
   ASPx.RemoveClassNameFromElement(editorMainElement, nullTextClassName);
 },
 GetNullTextClassName: function () {
  if (!this.nullTextClassName)
   this.InitializeNullTextClassName();
  return this.nullTextClassName;
 },
 InitializeNullTextClassName: function () {
  var nullTextStyle = this.styles["N"];
  if (nullTextStyle) {
   var nullTextStyleClassNames = nullTextStyle.split(" ");
   for (var i = 0; i < nullTextStyleClassNames.length; i++)
    if (nullTextStyleClassNames[i].match("dxeNullText"))
     this.nullTextClassName = nullTextStyleClassNames[i];
  }
 },
 ApplyDecoration: function(key, element, inner, active) {
  var value = inner ? this.innerStyles[key] : this.styles[key];
  ASPx.RemoveClassNameFromElement(element, value);
  if(ASPx.Browser.IE && ASPx.Browser.MajorVersion >= 11)
   var dummy = element.offsetWidth; 
  if(active) {
   ASPx.AddClassNameToElement(element, value);
   if(ASPx.Browser.IE && ASPx.Browser.Version > 10 && element.border != null) { 
    var border = parseInt(element.border) || 0;
    element.border = 1;
    element.border = border;
   }
  }
 },
 FilterInnerCss: function(css) {
  return css.replace(/(border|background-image)[^:]*:[^;]+/gi, "");
 }
});
var TouchUIHelper = {
 isGesture: false,
 isMouseEventFromScrolling: false,
 isNativeScrollingAllowed: true,
 clickSensetivity: 10,
 documentTouchHandlers: {},
 documentEventAttachingAllowed: true,
 msTouchDraggableClassName: "dxMSTouchDraggable",
 touchMouseDownEventName: ASPx.Browser.WebKitTouchUI ? "touchstart" : (ASPx.Browser.Edge && ASPx.Browser.MSTouchUI && window.PointerEvent ? "pointerdown" : "mousedown"),
 touchMouseUpEventName:   ASPx.Browser.WebKitTouchUI ? "touchend"   : (ASPx.Browser.Edge && ASPx.Browser.MSTouchUI && window.PointerEvent ? "pointerup" : "mouseup"),
 touchMouseMoveEventName: ASPx.Browser.WebKitTouchUI ? "touchmove"  : (ASPx.Browser.Edge && ASPx.Browser.MSTouchUI && window.PointerEvent ? "pointermove" : "mousemove"),
 isTouchEvent: function(evt) {
  if(!evt) return false;
  return ASPx.Browser.WebKitTouchUI && ASPx.IsExists(evt.changedTouches); 
 },
 isTouchEventName: function(eventName) {
  return ASPx.Browser.WebKitTouchUI && (eventName.indexOf("touch") > -1 || eventName.indexOf("gesture") > -1);
 },
 getEventX: function(evt) { 
  return ASPx.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX; 
 },
 getEventY: function (evt) { 
  return ASPx.Browser.IE ? evt.pageY :evt.changedTouches[0].pageY; 
 },
 getWebkitMajorVersion: function(){
  if(!this.webkitMajorVersion){
   var regExp = new RegExp("applewebkit/(\\d+)", "i");
   var matches = regExp.exec(ASPx.Browser.UserAgent);
   if(matches && matches.index >= 1)
    this.webkitMajorVersion = matches[1];
  }
  return this.webkitMajorVersion;
 },
 getIsLandscapeOrientation: function(){
  if(ASPx.Browser.MacOSMobilePlatform || ASPx.Browser.AndroidMobilePlatform)
   return Math.abs(window.orientation) == 90;
  return ASPx.GetDocumentClientWidth() > ASPx.GetDocumentClientHeight();
 },
 nativeScrollingSupported: function() {
  var allowedSafariVersion = ASPx.Browser.Version >= 5.1 && ASPx.Browser.Version < 8; 
  var allowedWebKitVersion = this.getWebkitMajorVersion() > 533 && (ASPx.Browser.Chrome || this.getWebkitMajorVersion() < 600);
  return (ASPx.Browser.MacOSMobilePlatform && (allowedSafariVersion || allowedWebKitVersion))
   || (ASPx.Browser.AndroidMobilePlatform && ASPx.Browser.PlaformMajorVersion >= 3) || (ASPx.Browser.MSTouchUI && (!ASPx.Browser.WindowsPhonePlatform || !ASPx.Browser.IE));
 },
 makeScrollableIfRequired: function(element, options) {
  if(ASPx.Browser.WebKitTouchUI && element) {
   var overflow = ASPx.GetCurrentStyle(element).overflow;
   if(element.tagName == "DIV" &&  overflow != "hidden" && overflow != "visible" ){
    return this.MakeScrollable(element);
   }
  }
 },
 preventScrollOnEvent: function(evt){
 },
 handleFastTapIfRequired: function(evt, action, preventCommonClickEvents) {
  if(ASPx.Browser.WebKitTouchUI && evt.type == 'touchstart' && action) {
   this.FastTapHelper.HandleFastTap(evt, action, preventCommonClickEvents);
   return true;
  }
  return false;
 },
 ensureDocumentSizesCorrect: function (){
  return (document.documentElement.clientWidth - document.documentElement.clientHeight) / (screen.width - screen.height) > 0;
 },
 ensureOrientationChanged: function(onOrientationChangedFunction){
  if(ASPxClientUtils.iOSPlatform || this.ensureDocumentSizesCorrect())
   onOrientationChangedFunction();
  else {
   window.setTimeout(function(){
    this.ensureOrientationChanged(onOrientationChangedFunction);
   }.aspxBind(this), 100);
  }
 },
 onEventAttachingToDocument: function(eventName, func){
  if(ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
   if(!this.documentTouchHandlers[eventName])
    this.documentTouchHandlers[eventName] = [];
   this.documentTouchHandlers[eventName].push(func);
   return this.documentEventAttachingAllowed;
  }
  return true;
 },
 onEventDettachedFromDocument: function(eventName, func){
  if(ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
   var handlers = this.documentTouchHandlers[eventName];
   if(handlers)
    ASPx.Data.ArrayRemove(handlers, func);
  }
 },
 processDocumentTouchEventHandlers: function(proc) {
  var touchEventNames = ["touchstart", "touchend", "touchmove", "gesturestart", "gestureend"];
  for(var i = 0; i < touchEventNames.length; i++) {
   var eventName = touchEventNames[i];
   var handlers = this.documentTouchHandlers[eventName];
   if(handlers) {
    for(var j = 0; j < handlers.length; j++) {
     proc(eventName,handlers[j]);
    }
   }
  }
 },
 removeDocumentTouchEventHandlers: function() {
  if(ASPx.Browser.MacOSMobilePlatform) {
   this.documentEventAttachingAllowed = false;
   this.processDocumentTouchEventHandlers(ASPx.Evt.DetachEventFromDocumentCore);
  }
 },
 restoreDocumentTouchEventHandlers: function () {
  if(ASPx.Browser.MacOSMobilePlatform) {
   this.documentEventAttachingAllowed = true;
   this.processDocumentTouchEventHandlers(ASPx.Evt.AttachEventToDocumentCore);
  }
 },
 IsNativeScrolling: function() {
  return TouchUIHelper.nativeScrollingSupported() && TouchUIHelper.isNativeScrollingAllowed;
 },
 pointerEnabled: !!(window.PointerEvent || window.MSPointerEvent),
 pointerDownEventName: window.PointerEvent ? "pointerdown" : "MSPointerDown",
 pointerUpEventName: window.PointerEvent ? "pointerup" : "MSPointerUp",
 pointerCancelEventName: window.PointerEvent ? "pointercancel" : "MSPointerCancel",
 pointerMoveEventName: window.PointerEvent ? "pointermove" : "MSPointerMove",
 pointerOverEventName: window.PointerEvent ? "pointerover" : "MSPointerOver",
 pointerOutEventName: window.PointerEvent ? "pointerout" : "MSPointerOut",
 pointerType: {
  Touch: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 2 : "touch",
  Pen: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 3 : "pen",
  Mouse: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 4 : "mouse"
 },
 msGestureEnabled: !!(window.PointerEvent || window.MSPointerEvent) && typeof(MSGesture) != "undefined",
 msTouchCreateGesturesWrapper: function(element, onTap){
  if(!TouchUIHelper.msGestureEnabled) 
   return;
  var gesture = new MSGesture();
  gesture.target = element;
  ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerDownEventName, function(evt){
   gesture.addPointer(evt.pointerId);
  });
  ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerUpEventName, function(evt){
   gesture.stop();
  });
  if(onTap)
   ASPx.Evt.AttachEventToElement(element, "MSGestureTap", onTap);
  return gesture;
 }
};
var CacheHelper = {};
CacheHelper.GetCachedValueCore = function(obj, key, func, cacheObj, fillValueMethod) {
 if(!cacheObj)
  cacheObj = obj;
 if(!cacheObj.cache)
  cacheObj.cache = {};
 if(!key) 
  key = "default";
 fillValueMethod(obj, key, func, cacheObj);
 return cacheObj.cache[key];
};
CacheHelper.GetCachedValue = function(obj, key, func, cacheObj) {
 return CacheHelper.GetCachedValueCore(obj, key, func, cacheObj, 
  function(obj, key, func, cacheObj) {
   if(!ASPx.IsExists(cacheObj.cache[key]))
    cacheObj.cache[key] = func.apply(obj, []);
  });
};
CacheHelper.GetCachedElement = function(obj, key, func, cacheObj) {
 return CacheHelper.GetCachedValueCore(obj, key, func, cacheObj, 
  function(obj, key, func, cacheObj) {
   if(!ASPx.IsValidElement(cacheObj.cache[key]))
    cacheObj.cache[key] = func.apply(obj, []);
  });
};
CacheHelper.GetCachedElements = function(obj, key, func, cacheObj) {
 return CacheHelper.GetCachedValueCore(obj, key, func, cacheObj, 
  function(obj, key, func, cacheObj) {
   if(!ASPx.IsValidElements(cacheObj.cache[key])){
    var elements = func.apply(obj, []);
    if(!Ident.IsArray(elements))
     elements = [elements];
    cacheObj.cache[key] = elements;
   }
  });
};
CacheHelper.GetCachedElementById = function(obj, id, cacheObj) {
 return CacheHelper.GetCachedElement(obj, id, function() { return ASPx.GetElementById(id); }, cacheObj);
};
CacheHelper.GetCachedChildById = function(obj, parent, id, cacheObj) {
 return CacheHelper.GetCachedElement(obj, id, function() { return ASPx.GetChildById(parent, id); }, cacheObj);
};
CacheHelper.DropCachedValue = function(cacheObj, key) {
 cacheObj.cache[key] = null;
};  
CacheHelper.DropCache = function(cacheObj) {
 cacheObj.cache = null;
};  
var DomObserver = ASPx.CreateClass(null, {
 constructor: function() {
  this.items = { };
 },
 subscribe: function(elementID, callbackFunc) {
  var item = this.items[elementID];
  if(item)
   this.unsubscribe(elementID);
  item = {
   elementID: elementID,
   callbackFunc: callbackFunc,
   pauseCount: 0
  };
  this.prepareItem(item);
  this.items[elementID] = item;
 },
 prepareItem: function(item) {
 },
 unsubscribe: function(elementID) {
  this.items[elementID] = null;
 },
 getItemElement: function(item) {
  var element = this.getElementById(item.elementID);
  if(element)
   return element;
  this.unsubscribe(item.elementID);
  return null;
 },
 getElementById: function(elementID) {
  var element = document.getElementById(elementID);
  return element && ASPx.IsValidElement(element) ? element : null;
 },
 pause: function(element, includeSubtree) {
  this.changeItemsState(element, includeSubtree, true);
 },
 resume: function(element, includeSubtree) {
  this.changeItemsState(element, includeSubtree, false);
 },
 forEachItem: function(processFunc, context) {
  context = context || this;
  for(var itemName in this.items) {
   if(!this.items.hasOwnProperty(itemName))
    continue;
   var item = this.items[itemName];
   if(item) {
    var needBreak = processFunc.call(context, item);
    if(needBreak)
     return;
   }
  }
 },
 changeItemsState: function(element, includeSubtree, pause) {
  this.forEachItem(function(item) {
   if(!element)
    this.changeItemState(item, pause);
   else {
    var itemElement = this.getItemElement(item);
    if(itemElement && (element == itemElement || (includeSubtree && ASPx.GetIsParent(element, itemElement)))) {
     this.changeItemState(item, pause);
     if(!includeSubtree)
      return true;
    }
   }
  }.aspxBind(this));
 },
 changeItemState: function(item, pause) {
  if(pause)
   this.pauseItem(item);
  else
   this.resumeItem(item);
 },
 pauseItem: function(item) {
  item.paused = true;
  item.pauseCount++;
 },
 resumeItem: function(item) {
  if(item.pauseCount > 0) {
   if(item.pauseCount == 1)
    item.paused = false;
   item.pauseCount--;
  }
 }
});
DomObserver.IsMutationObserverAvailable = function() {
 return !!window.MutationObserver;
};
var TimerObserver = ASPx.CreateClass(DomObserver, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
  this.timerID = -1;
  this.observationTimeout = 300;
 },
 subscribe: function(elementID, callbackFunc) {
  DomObserver.prototype.subscribe.call(this, elementID, callbackFunc);
  if(!this.isActivated())
   this.startObserving();
 },
 isActivated: function() {
  return this.timerID !== -1;
 },
 startObserving: function() {
  if(this.isActivated())
   window.clearTimeout(this.timerID);
  this.timerID = window.setTimeout(this.onTimeout, this.observationTimeout);
 },
 onTimeout: function() {
  var observer = _aspxGetDomObserver();
  observer.doObserve();
  observer.startObserving();
 },
 doObserve: function() {
  if(!ASPx.documentLoaded) return;
  this.forEachItem(function(item) {
   if(!item.paused)
    this.doObserveForItem(item);
  }.aspxBind(this));
 },
 doObserveForItem: function(item) {
  var element = this.getItemElement(item);
  if(element)
   item.callbackFunc.call(this, element);
 }
});
var MutationObserver = ASPx.CreateClass(DomObserver, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
  this.callbackTimeout = 10;
 },
 prepareItem: function(item) {
  item.callbackTimerID = -1;
  var target = this.getElementById(item.elementID);
  if(!target)
   return;
  var observerCallbackFunc = function() {
   if(item.callbackTimerID === -1) {
    var timeoutHander = function() {
     item.callbackTimerID = -1;
     item.callbackFunc.call(this, target);
    }.aspxBind(this);
    item.callbackTimerID = window.setTimeout(timeoutHander, this.callbackTimeout);
   }
  }.aspxBind(this);
  var observer = new window.MutationObserver(observerCallbackFunc);
  var config = { attributes: true, childList: true, characterData: true, subtree: true };
  observer.observe(target, config);
  item.observer = observer;
  item.config = config;
 },
 unsubscribe: function(elementID) {
  var item = this.items[elementID];
  if(item) {
   item.observer.disconnect();
   item.observer = null;
  }
  DomObserver.prototype.unsubscribe.call(this, elementID);
 },
 pauseItem: function(item) {
  DomObserver.prototype.pauseItem.call(this, item);
  item.observer.disconnect();
 },
 resumeItem: function(item) {
  DomObserver.prototype.resumeItem.call(this, item);
  if(!item.paused) {
   var target = this.getItemElement(item);
   if(target)
    item.observer.observe(target, item.config);
  }
 }
});
var domObserver = null;
function _aspxGetDomObserver() {
 if(domObserver == null)
  domObserver = DomObserver.IsMutationObserverAvailable() ? new MutationObserver() : new TimerObserver();
 return domObserver;
}
var ControlUpdateWatcher = ASPx.CreateClass(null, {
 constructor: function() {
  this.helpers = { };
  this.clearLockerTimerID = -1;
  this.clearLockerTimerDelay = 15;
  this.postProcessing = false;
  this.init();
 },
 init: function() {
  var postHandler = aspxGetPostHandler();
  postHandler.Post.AddHandler(this.OnPost, this);
 },
 Add: function(helper) {
  this.helpers[helper.GetName()] = helper;
 },
 CanSendCallback: function(dxCallbackOwner, arg) {
  this.LockConfirmOnBeforeWindowUnload();
  var modifiedHelpers = this.FilterModifiedHelpersByDXCallbackOwner(this.GetModifiedHelpers(), dxCallbackOwner, arg);
  if(modifiedHelpers.length === 0) return true;
  var modifiedHelpersInfo = this.GetToConfirmAndToResetLists(modifiedHelpers, dxCallbackOwner.name);
  if(!modifiedHelpersInfo) return true;
  if(modifiedHelpersInfo.toConfirm.length === 0) {
   this.ResetClientChanges(modifiedHelpersInfo.toReset);
   return true;
  }
  var helper = modifiedHelpersInfo.toConfirm[0];
  if(!confirm(helper.GetConfirmUpdateText()))
   return false;
  this.ResetClientChanges(modifiedHelpersInfo.toReset);
  return true;
 },
 OnPost: function(s, e) {
  if(e.isDXCallback) return;
  this.postProcessing = true;
  this.LockConfirmOnBeforeWindowUnload();
  var modifiedHelpersInfo = this.GetModifedHelpersInfo(e);
  if(!modifiedHelpersInfo) return;
  if(modifiedHelpersInfo.toConfirm.length === 0) {
   this.ResetClientChanges(modifiedHelpersInfo.toReset);
   return;
  }
  var helper = modifiedHelpersInfo.toConfirm[0];
  if(!confirm(helper.GetConfirmUpdateText())) {
   e.cancel = true;
   this.finishPostProcessing();
  }
  if(!e.cancel)
   this.ResetClientChanges(modifiedHelpersInfo.toReset);
 },
 finishPostProcessing: function() {
  this.postProcessing = false;
 },
 GetModifedHelpersInfo: function(e) {
  var modifiedHelpers = this.FilterModifiedHelpers(this.GetModifiedHelpers(), e);
  if(modifiedHelpers.length === 0) return;
  return this.GetToConfirmAndToResetLists(modifiedHelpers, e && e.ownerID);
 },
 GetToConfirmAndToResetLists: function(modifiedHelpers, ownerID) {
  var resetList = [ ];
  var confirmList = [ ];
  for(var i = 0; i < modifiedHelpers.length; i++) {
   var helper = modifiedHelpers[i];
   if(!helper.GetConfirmUpdateText()) { 
    resetList.push(helper);
    continue;
   }
   if(helper.CanShowConfirm(ownerID)) { 
    resetList.push(helper);
    confirmList.push(helper);
   }
  }
  return { toConfirm: confirmList, toReset: resetList };
 },
 FilterModifiedHelpers: function(modifiedHelpers, e) {
  if(modifiedHelpers.length === 0)
   return [ ];
  if(this.RequireProcessUpdatePanelCallback(e))
   return this.FilterModifiedHelpersByUpdatePanels(modifiedHelpers);
  if(this.postProcessing)
   return this.FilterModifiedHelpersByPostback(modifiedHelpers);
  return modifiedHelpers;
 },
 FilterModifiedHelpersByDXCallbackOwner: function(modifiedHelpers, dxCallbackOwner, arg) {
  var result = [ ];
  for(var i = 0; i < modifiedHelpers.length; i++) {
   var helper = modifiedHelpers[i];
   if(helper.NeedConfirmOnCallback(dxCallbackOwner, arg))
    result.push(helper);
  }
  return result;
 },
 FilterModifiedHelpersByUpdatePanels: function(modifiedHelpers) {
  var result = [ ];
  var updatePanels = this.GetUpdatePanelsWaitedForUpdate();
  for(var i = 0; i < updatePanels.length; i++) {
   var panelID = updatePanels[i].replace(/\$/g, "_");
   var panel = ASPx.GetElementById(panelID);
   if(!panel) continue;
   for(var j = 0; j < modifiedHelpers.length; j++) {
    var helper = modifiedHelpers[j];
    if(ASPx.GetIsParent(panel, helper.GetControlMainElement()))
     result.push(helper);
   }
  }
  return result;
 },
 FilterModifiedHelpersByPostback: function(modifiedHelpers) {
  var result = [ ];
  for(var i = 0; i < modifiedHelpers.length; i++) {
   var helper = modifiedHelpers[i];
   if(helper.NeedConfirmOnPostback())
    result.push(helper);
  }
  return result;
 },
 RequireProcessUpdatePanelCallback: function(e) {
  var rManager = this.GetMSRequestManager();
  if(rManager && e && e.isMSAjaxCallback)
   return rManager._postBackSettings.async;
  return false;
 },
 GetUpdatePanelsWaitedForUpdate: function() {
  var rManager = this.GetMSRequestManager();
  if(!rManager) return [ ];
  var panelUniqueIDs = rManager._postBackSettings.panelsToUpdate || [ ];
  var panelClientIDs = [ ];
  for(var i = 0; i < panelUniqueIDs.length; i++) {
   var index = ASPx.Data.ArrayIndexOf(rManager._updatePanelIDs, panelUniqueIDs[i]);
   if(index >= 0)
    panelClientIDs.push(rManager._updatePanelClientIDs[index]);
  }
  return panelClientIDs;
 },
 GetMSRequestManager: function() {
  if(window.Sys && Sys.WebForms && Sys.WebForms.PageRequestManager && Sys.WebForms.PageRequestManager.getInstance)
   return Sys.WebForms.PageRequestManager.getInstance();
  return null;
 },
 GetModifiedHelpers: function() {
  var result = [ ];
  for(var key in this.helpers) { 
   if(this.helpers.hasOwnProperty(key)) {
    var helper = this.helpers[key];
    if(helper.HasChanges())
     result.push(helper);
   }
  }
  return result;
 },
 ResetClientChanges: function(modifiedHelpers) {
  for(var i = 0; i < modifiedHelpers.length; i++)
   modifiedHelpers[i].ResetClientChanges();
 },
 GetConfirmUpdateMessage: function() {
  if(this.confirmOnWindowUnloadLocked) return;
  var modifiedHelpersInfo = this.GetModifedHelpersInfo();
  if(!modifiedHelpersInfo || modifiedHelpersInfo.toConfirm.length === 0) 
   return;
  var helper = modifiedHelpersInfo.toConfirm[0];
  return helper.GetConfirmUpdateText();
 },
 LockConfirmOnBeforeWindowUnload: function() {
  this.confirmOnWindowUnloadLocked = true;
  this.clearLockerTimerID = ASPx.Timer.ClearTimer(this.clearLockerTimerID);
  this.clearLockerTimerID = window.setTimeout(function() {
   this.confirmOnWindowUnloadLocked = false;
  }.aspxBind(this), this.clearLockerTimerDelay);
 },
 OnWindowBeforeUnload: function(e) {
  var confirmMessage = this.GetConfirmUpdateMessage();
  if(confirmMessage)
   e.returnValue = confirmMessage;
  this.finishPostProcessing();
  return confirmMessage;
 },
 OnWindowUnload: function(e) {
  if(this.confirmOnWindowUnloadLocked) return;
  var modifiedHelpersInfo = this.GetModifedHelpersInfo();
  if(!modifiedHelpersInfo) return;
  this.ResetClientChanges(modifiedHelpersInfo.toReset);
 },
 OnMouseDown: function(e) {
  if(ASPx.Browser.IE)
   this.PreventBeforeUnloadOnLinkClick(e);
 },
 OnFocusIn: function(e) {
  if(ASPx.Browser.IE)
   this.PreventBeforeUnloadOnLinkClick(e);
 },
 PreventBeforeUnloadOnLinkClick: function(e) {
  if(ASPx.GetObjectKeys(this.helpers).length == 0)
   return;
  var link = ASPx.GetParentByTagName(ASPx.Evt.GetEventSource(e), "A");
  if(!link || link.dxgvLinkClickHanlderAssigned)
   return;
  var url = ASPx.Attr.GetAttribute(link, "href");
  if(!url || url.indexOf("javascript:") < 0)
   return;
  ASPx.Evt.AttachEventToElement(link, "click", function(ev) { return ASPx.Evt.PreventEvent(ev); });
  link.dxgvLinkClickHanlderAssigned = true;
 }
});
ControlUpdateWatcher.Instance = null;
ControlUpdateWatcher.getInstance = function () {
 if (!ControlUpdateWatcher.Instance) {
  ControlUpdateWatcher.Instance = new ControlUpdateWatcher();
  ASPx.Evt.AttachEventToElement(window, "beforeunload", function(e) {
   return ControlUpdateWatcher.Instance.OnWindowBeforeUnload(e);
  });
  ASPx.Evt.AttachEventToElement(window, "unload", function(e) {
   ControlUpdateWatcher.Instance.OnWindowUnload(e);
  });
  ASPx.Evt.AttachEventToDocument("mousedown", function(e) {
   ControlUpdateWatcher.Instance.OnMouseDown(e);
  });
  ASPx.Evt.AttachEventToDocument("focusin", function(e) {
   ControlUpdateWatcher.Instance.OnFocusIn(e);
  });
 }
 return ControlUpdateWatcher.Instance;
};
var UpdateWatcherHelper = ASPx.CreateClass(null, {
 constructor: function(owner) {
  this.owner = owner;
  this.ownerWatcher = ControlUpdateWatcher.getInstance();
  this.ownerWatcher.Add(this);
 },
 GetName: function() {
  return this.owner.name;
 },
 GetControlMainElement: function() {
  return this.owner.GetMainElement();
 },
 GetControlParentForm: function(){
  return ASPx.GetParentByTagName(this.GetControlMainElement(), "FORM");
 },
 CanShowConfirm: function(requestOwnerID) {
  return true;
 },
 HasChanges: function() {
  return false;
 },
 GetConfirmUpdateText: function() {
  return "";
 },
 NeedConfirmOnCallback: function(dxCallbackOwner) {
  return true;
 },
 NeedConfirmOnPostback: function() {
  if(ASPx.IsUploadSubmitRequest)
   return !ASPx.IsUploadSubmitRequest(this.GetControlParentForm());
  return true;
 },
 ResetClientChanges: function() {
 },
 ConfirmOnCustomControlEvent: function() {
  var confirmMessage = this.GetConfirmUpdateText();
  if(confirmMessage)
   return confirm(confirmMessage);
  return false;
 }
});
var ControlCallbackHandlersQueue = ASPx.CreateClass(null, {
 constructor: function (owner) {
  this.owner = owner;
  this.handlerInfos = [];
 },
 addCallbackHandler: function(handlerInfo) {
  this.handlerInfos.push(handlerInfo);
 },
 executeCallbacksHandlers: function() {
  for(var i = 0, handlerInfo; handlerInfo = this.handlerInfos[i]; i++)
   handlerInfo.handler.call(this.owner, handlerInfo.result);
  this.handlerInfos = [];
 }
});
var ControlCallbackQueueHelper = ASPx.CreateClass(null, {
 constructor: function (owner) {
  this.owner = owner;
  this.pendingCallbacks = [];
  this.receivedCallbacks = [];
  this.attachEvents();
 },
 showLoadingElements: function () {
  this.owner.ShowLoadingDiv();
  if (this.owner.IsCallbackAnimationEnabled())
   this.owner.StartBeginCallbackAnimation();
  else
   this.owner.ShowLoadingElementsInternal();
 },
 attachEvents: function () {
  this.owner.EndCallback.AddHandler(this.onEndCallback.aspxBind(this));
  this.owner.CallbackError.AddHandler(this.onCallbackError.aspxBind(this));
 },
 detachEvents: function () {
  this.owner.EndCallback.RemoveHandler(this.onEndCallback);
  this.owner.CallbackError.RemoveHandler(this.onCallbackError);
 },
 onCallbackError: function (owner, result) {
  this.sendErrorToChildControl(result);
 },
 ignoreDuplicates: function () {
  return true;
 },
 hasDuplicate: function (arg) {
  for (var i in this.pendingCallbacks) {
   if (this.pendingCallbacks[i].arg == arg && this.pendingCallbacks[i].state != ASPx.callbackState.aborted)
    return true;
  }
  return false;
 },
 getToken: function (halperContext, callbackInfo) {
  return {
   cancel: function () {
    if (callbackInfo.state == ASPx.callbackState.sent) {
     callbackInfo.state = ASPx.callbackState.aborted;
     halperContext.sendNext();
    }
    if (callbackInfo.state == ASPx.callbackState.inTurn)
     ASPx.Data.ArrayRemove(halperContext.pendingCallbacks, callbackInfo);
   },
   callbackId: -1
  };
 },
 sendCallback: function (arg, handlerContext, handler, commandName) {
  if (this.ignoreDuplicates() && this.hasDuplicate(arg))
   return false;
  var handlerContext = handlerContext || this.owner;
  var callbackInfo = {
   arg: arg,
   handlerContext: handlerContext,
   handler: handler || handlerContext.OnCallback,
   state: ASPx.callbackState.inTurn, callbackId: -1
  };
  this.pendingCallbacks.push(callbackInfo);
  if (!this.hasActiveCallback()) {
   callbackInfo.callbackId = this.owner.CreateCallback(arg, commandName);
   callbackInfo.state = ASPx.callbackState.sent;
  }
  return this.getToken(this, callbackInfo);
 },
 hasActiveCallback: function () {
  return this.getCallbacksInfoByState(ASPx.callbackState.sent).length > 0;
 },
 sendNext: function () {
  var nextCallbackInfo = this.getCallbacksInfoByState(ASPx.callbackState.inTurn)[0];
  if (nextCallbackInfo) {
   nextCallbackInfo.callbackId = this.owner.CreateCallback(nextCallbackInfo.arg);
   nextCallbackInfo.state = ASPx.callbackState.sent;
   return nextCallbackInfo.callbackId;
  }
 },
 onEndCallback: function () {
  if (!this.owner.isErrorOnCallback && this.hasPendingCallbacks()) {
   var curCallbackId;
   var curCallbackInfo;
   var handlerContext;
   for (var i in this.receivedCallbacks) {
    if(this.receivedCallbacks.hasOwnProperty(i)) {
     curCallbackId = this.receivedCallbacks[i];
     curCallbackInfo = this.getCallbackInfoById(curCallbackId);
     if (curCallbackInfo.state != ASPx.callbackState.aborted) {
      handlerContext = curCallbackInfo.handlerContext;
      if (handlerContext.OnEndCallback)
       handlerContext.OnEndCallback();
      this.sendNext();
     }
     ASPx.Data.ArrayRemove(this.pendingCallbacks, curCallbackInfo);
    }
   }
   ASPx.Data.ArrayClear(this.receivedCallbacks);
  }
 },
 hasPendingCallbacks: function () {
  return this.pendingCallbacks && this.pendingCallbacks.length && this.pendingCallbacks.length > 0;
 },
 processCallback: function (result, callbackId) {
  this.receivedCallbacks.push(callbackId);
  if (this.hasPendingCallbacks()) {
   var callbackInfo = this.getCallbackInfoById(callbackId);
   if (callbackInfo.state != ASPx.callbackState.aborted)
    callbackInfo.handler.call(callbackInfo.handlerContext, result);
  }
 },
 getCallbackInfoById: function (id) {
  for (var i in this.pendingCallbacks) {
   if (this.pendingCallbacks[i].callbackId == id)
    return this.pendingCallbacks[i];
  }
 },
 getCallbacksInfoByState: function (state) {
  var result = [];
  for (var i in this.pendingCallbacks) {
   if (this.pendingCallbacks[i].state == state)
    result.push(this.pendingCallbacks[i]);
  }
  return result;
 },
 sendErrorToChildControl: function (callbackObj) {
  if (!this.hasPendingCallbacks())
   return;
  var callbackInfo = this.getCallbackInfoById(callbackObj.callbackId || 0);
  if (!callbackInfo)
   return;
  var hasChildControlHandler = (callbackInfo.handlerContext != this.owner) && callbackInfo.handlerContext.OnCallbackError;
  if (hasChildControlHandler)
   callbackInfo.handlerContext.OnCallbackError.call(callbackInfo.handlerContext, callbackObj.message, callbackObj.data);
 }
});
var AccessibilityHelperBase = ASPx.CreateClass(null, {
 constructor: function(control) {
  this.control = control;
  this.timerID = -1;
  this.pronounceMessageTimeout = 500;
  this.activeItem = this.getItems()[0];
  this.pronounceIsStarted = false;
 },
 PronounceMessage: function(text, activeItemArgs, inactiveItemArgs, mainElementArgs, ownerMainElement) {   
  this.timerID = ASPx.Timer.ClearTimer(this.timerID);
  this.pronounceIsStarted = true;
  this.timerID = window.setTimeout(function() {
   this.PronounceMessageCore(text, activeItemArgs, inactiveItemArgs, mainElementArgs, ownerMainElement);
  }.aspxBind(this), this.getPronounceTimeout());
 },
 PronounceMessageCore: function(text, activeItemArgs, inactiveItemArgs, mainElementArgs, ownerMainElement) {
  if(!this.getItems())
   return;
  this.toogleItem();
  var mainElement = this.getMainElement();
  var activeItem = this.getItem(true);
  var inactiveItem = this.getItem();
  if(ASPx.Attr.GetAttribute(mainElement, "role") != "application")
   mainElementArgs = this.addArguments(mainElementArgs, { "aria-activedescendant" : activeItem.id });
  var messageAttrObj = {};
  var activeItemRole = ASPx.Attr.GetAttribute(activeItem, "role");
  var attrName = activeItemRole == "combobox" ? "aria-label" : "innerHtml";
  messageAttrObj[attrName] = ASPx.Str.EncodeHtml(text);
  activeItemArgs = this.addArguments(activeItemArgs, messageAttrObj);
  messageAttrObj[attrName] = "";
  inactiveItemArgs = this.addArguments(inactiveItemArgs, messageAttrObj);
  var errorTextElement = null;
  if(this.control.GetErrorCell()) {
   errorTextElement = this.getAriaExplanatoryTextManager().GetErrorTextElement();
   activeItemArgs = this.addArguments(activeItemArgs,   {"aria-invalid"  : !this.control.isValid ? "true" : "" });
   mainElementArgs = this.addArguments(mainElementArgs, { "aria-invalid" : "" });
   inactiveItemArgs = this.addArguments(inactiveItemArgs,  { "aria-invalid" : "" });
  }
  this.changeActivityAttributes(activeItem, activeItemArgs);
  if(errorTextElement) {
   this.getAriaExplanatoryTextManager().SetOrRemoveText([activeItem], errorTextElement, !this.control.isValid, false, true);
   this.getAriaExplanatoryTextManager().SetOrRemoveText([mainElement, inactiveItem], errorTextElement, false, false, false);
  }
  this.changeActivityAttributes(mainElement, mainElementArgs);
  if(!!ownerMainElement && ASPx.Attr.GetAttribute(ownerMainElement, "role") != "application")
   this.changeActivityAttributes(ownerMainElement, { "aria-activedescendant": activeItem.id });
  this.changeActivityAttributes(inactiveItem, inactiveItemArgs);
  this.pronounceIsStarted = false;
 },
 GetActiveElement: function(inputIsMainElement) {
  if(this.pronounceIsStarted) return null;
  var mainElement = inputIsMainElement ? this.control.GetInputElement() : this.getMainElement();
  var activeElementId = ASPx.Attr.GetAttribute(mainElement, 'aria-activedescendant');
  return activeElementId ? ASPx.GetElementById(activeElementId) : mainElement;
 },
 getMainElement: function() {
  if(!ASPx.IsExistsElement(this.mainElement))
   this.mainElement = this.control.GetAccessibilityAssistantElement();
  return this.mainElement;
 },
 getItems: function() {
  if(!ASPx.IsExistsElement(this.items))
   this.items = ASPx.GetChildElementNodes(this.getMainElement());
  return this.items;
 },
 getItem: function(isActive) {
  if(isActive)
   return this.activeItem;
  var items = this.getItems();
  return items[0] === this.activeItem ? items[1] : items[0];
 },
 getAriaExplanatoryTextManager: function() { return this.control.ariaExplanatoryTextManager; },
 getPronounceTimeout: function() { return this.pronounceMessageTimeout; },
 toogleItem: function() {
  this.activeItem = this.getItem();
 },
 addArguments: function(targetArgs, newArgs) {
  if(!targetArgs) targetArgs = { };
  for(var key in newArgs) {
   if(newArgs.hasOwnProperty(key) && !targetArgs.hasOwnProperty(key))
    targetArgs[key] = newArgs[key];
  }
  return targetArgs;
 },
 changeActivityAttributes: function(element, args) {
  if(!element)
   return;
  for(var key in args) {
   if(args.hasOwnProperty(key)) {
    var value = args[key];
    if(key == "innerHtml")
     ASPx.SetInnerHtml(element, value);
    else {
     var action = value !== "" ? ASPx.Attr.SetAttribute : ASPx.Attr.RemoveAttribute;
     action(element, key, value);
    }
   }
  }
 }
});
var AccessibilityPronouncer = ASPx.CreateClass(null, {
 constructor: function() {
  this.pronouncerId = "dxPronouncer";
  this.initialized = false;
  this.focusableMessageElement = null;
  this.messageElement = null;
  this.pronouncers = {
   live: new AccessibilityLivePronouncer(this),
   descendant: new AccessibilityDescendantPronouncer(this)
  };
 },
 Pronounce: function(args, type) {
  this.pronouncers[type].Pronounce(args);
 },
 EnsureInitialize: function() {
  if(!this.initialized)
   this.initialize();
 },
 RemoveState: function() {
  for(var pronouncer in this.pronouncers)
   if(this.pronouncers.hasOwnProperty(pronouncer))
    pronouncer.RemoveState();
 },
 RestoreControlState: function(type, mainElement) {
  this.pronouncers[type].RestoreControlState(mainElement);
 },
 RestoreElementsState: function(type, elements) {
  this.pronouncers[type].RestoreElementsState(elements);
 },
 RestoreElementState: function(type, element) {
  this.pronouncers[type].RestoreElementState(element);
 },
 initialize: function() {
  this.createFocusableMessageElement();
  this.createMessageElement();
  this.prepareFocusableMessageElement();
  this.setAttributesForKeyboardNavigation();
  this.initialized = true;
 },
 createFocusableMessageElement: function() {
  var focusableMessageElement = document.createElement("DIV");
  document.body.appendChild(focusableMessageElement);
  this.focusableMessageElement = focusableMessageElement;   
 },
 prepareFocusableMessageElement: function() {
  this.focusableMessageElement.className = "dxAIFME";
 },
 setAttributesForKeyboardNavigation: function() {
  ASPx.Attr.Aria.SetApplicationRole(this.focusableMessageElement);
  ASPx.Attr.Aria.SetSilence(this.focusableMessageElement);
 },
 createMessageElement: function() {
  var messageElement = document.createElement("DIV");
  messageElement.id = this.pronouncerId;
  ASPx.Attr.SetAttribute(messageElement, "role", "note");
  this.focusableMessageElement.appendChild(messageElement);
  this.messageElement = messageElement;
 },
 getMessage: function(messagePartsArg) {
  var messageParts = messagePartsArg.filter(function(x) { return ASPx.IsExists(x); });
  return messageParts.join(", ");
 }
});
var AccessibilityPronouncerBase = ASPx.CreateClass(null, {
 constructor: function() {
  this.state = { };
 },
 Pronounce: function(args) {
  var messageElement = this.getMessageElement();
  ASPx.Attr.Aria.SetOrRemoveLabel(messageElement);
  ASPx.SetInnerHtml(messageElement, "");
  this.PronounceCore(args);
 },
 PronounceCore: function(args) { },
 SaveElementState: function(element) { 
  if(this.state[element.id])
   return;
  this.state[element.id] = {
   element: element,
   descendant: ASPx.Attr.GetAttribute(element, ASPx.Attr.Aria.descendant)
  };
 },
 RemoveState: function() {
  this.state = { };
 },
 RestoreControlState: function(mainElement) { 
  for(var elementInfo in this.state) {
   if(this.state.hasOwnProperty(elementInfo)) {
    var element = this.state[elementInfo].element;
    if(!mainElement || ASPx.GetIsParent(mainElement, element))
     this.RestoreElementState(element);
   }
  }
 },
 RestoreElementsState: function(elements) { 
  for(var i = 0; i < elements.length; i++)
   this.RestoreElementState(elements[i]);
 },
 RestoreElementState: function(element) {
  var elementState = this.state[element.id];
  if(!elementState)
   return;
  ASPx.Attr.Aria.SetOrRemoveDescendant(element, elementState.descendant);
  delete this.state[element.id];
 },
 getMessage: function(args) {
  return ASPx.AccessibilityPronouncer.getMessage(args.messageParts);
 },
 getMessageElement: function() {
  return ASPx.AccessibilityPronouncer.messageElement;
 },
 getFocusableMessageElement: function() {
   return ASPx.AccessibilityPronouncer.focusableMessageElement;
 }
});
var AccessibilityLivePronouncer = ASPx.CreateClass(AccessibilityPronouncerBase, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 PronounceCore: function(args) {
  var message = this.getMessage(args);
  var messageElement = this.getMessageElement();
  ASPx.Attr.SetAttribute(this.getFocusableMessageElement(), "aria-live", "assertive");
  ASPx.Attr.Aria.SetAtomic(this.getFocusableMessageElement(), "true");
  ASPx.SetInnerHtml(messageElement, ASPx.Str.EncodeHtml(message));
 }
});
var AccessibilityDescendantPronouncer = ASPx.CreateClass(AccessibilityPronouncerBase, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 PronounceCore: function(args) {
  var message = this.getMessage(args);
  var activeElement = ASPx.GetActiveElement();
  var messageElement = this.getMessageElement();
  this.SaveElementState(activeElement);
  ASPx.Attr.RemoveAttribute(this.getFocusableMessageElement(), "aria-live");
  ASPx.Attr.RemoveAttribute(this.getFocusableMessageElement(), "aria-atomic");
  ASPx.Attr.Aria.SetOrRemoveLabel(messageElement, message);
  ASPx.Attr.Aria.SetOrRemoveDescendant(activeElement, messageElement.id);
 }
});
ASPx.AccessibilityPronouncerType = {
 live: "live",
 descendant: "descendant"
};
ASPx.AccessibilityPronouncer = new AccessibilityPronouncer();
var RestoreFocusHelper = ASPx.CreateClass(null, {
 constructor: function() {
  this.excludedIDs = [ "DXCBtn" ]; 
  this.pronouncerType = ASPx.AccessibilityPronouncerType.live;
  this.callbackQueue = [];
  this.Initialize();
 },
 Initialize: function() {
  var that = this;
  ASPx.Evt.AttachEventToDocumentCore("DOMContentLoaded", function() {
   ASPxClientControl.GetControlCollection().BeginCallback.AddHandler(that.OnBeginCallback, that);
   ASPxClientControl.GetControlCollection().EndCallback.AddHandler(that.OnEndCallback, that);
  });
 },
 OnBeginCallback: function(s, e) {
  var control = e.control;
  if(!control.allowRestoreFocusOnCallbacks())
   return;
  control.accessibilityFocusTreeLine = this.getFocusTreeLine(control);
  var controlHasCallbackTreeLine = this.callbackQueueContainsTreeLine(control);
  this.pushTreeLineInfoIntoCallbackQueue(control);
  if(control.accessibilityFocusTreeLine && !controlHasCallbackTreeLine)
   control.SendMessageToAssistiveTechnology(this.getDefaultCallbackMessage());
 },
 OnEndCallback: function(s, e) {
  var control = e.control;
  if(!control.allowRestoreFocusOnCallbacks())
   return;
  var treeLineInfo = this.shiftTreeLineInfoFromCallbackQueue(control);
  if(treeLineInfo.queueLength == 0) {
   if(!control.accessibilityFocusTreeLine && treeLineInfo.treeLine)
    control.accessibilityFocusTreeLine = treeLineInfo.treeLine;
   var focusElement = this.findFocusElement(control);
   if(!this.handleActivePopupWindow(focusElement))
    ASPx.AccessibilityUtils.SetFocusAccessible(focusElement);
   delete control.accessibilityFocusTreeLine;
  }
 },
 pushTreeLineInfoIntoCallbackQueue: function(control) {
  var controlTreeLine = control.accessibilityFocusTreeLine ? control.accessibilityFocusTreeLine.slice(0) : null;
  if(!this.callbackQueue[control.name])
   this.callbackQueue[control.name] = [];
  this.callbackQueue[control.name].push(controlTreeLine);
 },
 shiftTreeLineInfoFromCallbackQueue: function(control) {
  var treeLineInfo = { queueLength: 0, treeLine: null };
  var treeLines = this.callbackQueue[control.name];
  if(treeLines && treeLines.length > 0) {
   treeLineInfo.treeLine = treeLines.shift();
   var linesCount = treeLines.length;
   treeLineInfo.queueLength = linesCount;
   if(linesCount > 0 && !treeLines[0] && treeLineInfo.treeLine)
    treeLines[0] = treeLineInfo.treeLine.slice(0);
  }
  return treeLineInfo;
 },
 callbackQueueContainsTreeLine: function(control) {
  var treeLines = this.callbackQueue[control.name];
  if(!treeLines || treeLines.length == 0) 
   return false;
  if(treeLines[treeLines.length - 1])
   return true;
  return false;
 },
 getDefaultCallbackMessage: function() {
  return ASPx.AccessibilitySR.DefaultCallbackMessage;
 },
 handleActivePopupWindow: function(focusElement) {
  if(!ASPx.GetPopupControlCollection)
   return false;
  var activePopupWindow = ASPx.GetPopupControlCollection().GetCurrentActiveWindowElement();
  if(activePopupWindow) {
   var popupInfo = ASPx.GetPopupControlCollection().GetPopupWindowFromID(activePopupWindow.id);
   if(popupInfo.popupControl.setFocusOnCallback && !popupInfo.popupControl.accessibleFocusElement) {
    popupInfo.popupControl.accessibleFocusElement = focusElement;
    return true;
   }
  }
  return false;
 },
 getFocusTreeLine: function(control) {
  var element = document.activeElement;
  var mainElement = control.GetMainElement();
  if(!ASPx.GetIsParent(mainElement, element)) {
   var treeInfo = this.findFocusedControlElement(mainElement, element);
   element = treeInfo.focusElement;
   mainElement = treeInfo.rootElement;
  }
  return this.getTreeLineCore(mainElement, element);
 },
 getTreeLineCore: function(mainElement, element) {
  if(!element) return null;
  treeLine = [ ];
  while(element) {
   treeLine.push({ 
    id: element.id,
    tagName: element.tagName,
    index: ASPx.Data.ArrayIndexOf(element.parentNode.childNodes, element)
   });
   if(element === mainElement || element === document.body)
    break;
   element = element.parentNode;
  }
  return treeLine;
 },
 findFocusedControlElement: function(mainElement, activeElement) {
  var element = null;
  var parentElement = mainElement;
  var focusedEditor = ASPx.IsExists(ASPx.GetFocusedEditor) ? ASPx.GetFocusedEditor() : null;
  if(focusedEditor && ASPx.GetIsParent(mainElement, focusedEditor.GetMainElement()))
   element = focusedEditor.GetFocusableInputElement();
  else {
   if(mainElement && activeElement) {
    var mainControl = ASPx.GetClientControlByElementID(mainElement.id);
    var parentControls = ASPx.GetParentClientControls(activeElement.id);
    for(var i = parentControls.length - 1; i > -1; i--) {   
     if(mainControl.name == parentControls[i].name) {
      element = activeElement;
      var rootIndex = i > 0 ? i - 1 : i;
      parentElement = parentControls[rootIndex].GetMainElement();
      if(!parentElement && parentControls[rootIndex].GetCurrentWindowElement)
       parentElement = parentControls[rootIndex].GetCurrentWindowElement();
      break;
     }
    }
   }
  }
  return { focusElement: element, rootElement: parentElement }; 
 },
 findFocusElement: function(control) {
  if(!control.accessibilityFocusTreeLine)
   return;
  var treeLine = control.accessibilityFocusTreeLine.slice(0);
  var focusElementParent = this.findFocusElementParentById(treeLine);
  if(!focusElementParent) 
   return;
  return this.findFocusElementFromDOMTree(treeLine, focusElementParent);
 },
 findFocusElementParentById: function(treeLine) {
  for(var i = 0; i < treeLine.length; i++) {
   var id = treeLine[i].id;
   if(!this.isValidId(id))
    continue;
   var element = document.getElementById(id);
   if(element) {
    treeLine.splice(i, treeLine.length - i);
    treeLine.reverse();
    return element;
   }
  }
  return null;
 },
 findFocusElementFromDOMTree: function(treeLine, focusElementParent) {
  var element = focusElementParent;
  for(var i = 0; i < treeLine.length; i++) {
   var info = treeLine[i];
   if(info.index >= element.childNodes.length) {
    element = element.childNodes.length > 0 ? element.childNodes[element.childNodes.length - 1] : null;
    return this.findNeighbourFocusElement(element, focusElementParent);
   }
   var child = element.childNodes[info.index];
   if(child.tagName !== info.tagName)
    return this.findNeighbourFocusElement(child, focusElementParent);
   element = child;
  }
  return element;
 },
 findNeighbourFocusElement: function(element, focusElementParent) {
  if(!element || !element.parentNode) return null;
  var neighbours = element.parentNode.childNodes;
  var indices = this.calcLeftRightIndices(ASPx.Data.ArrayIndexOf(neighbours, element), neighbours.length);
  for(var i = 0; i < indices.length; i++) {
   var index = indices[i];
   var actionElement = ASPx.FindFirstChildActionElement(neighbours[index]);
   if(actionElement)
    return actionElement;
  }
  if(element === focusElementParent)
   return null;
  return this.findNeighbourFocusElement(element.parentNode, focusElementParent);
 },
 calcLeftRightIndices: function(startIndex, count) {
  var indices = [ ];
  var incSides = [ 0, 0 ];
  var index = startIndex;
  for(var i = 0; i < count; i++) {
   indices.push(index);
   var even = i % 2 === 0;
   var nextIndex = this.calcNextIndex(startIndex, count, incSides, even);
   if(nextIndex < 0)
    nextIndex = this.calcNextIndex(startIndex, count, incSides, !even);
   index = nextIndex;
  }
  return indices;
 },
 calcNextIndex: function(startIndex, count, incSides, even) {
  var sideIndex = even ? 0 : 1;
  var inc = incSides[sideIndex];
  inc += even ? -1 : 1;
  var nextIndex = startIndex + inc;
  if(nextIndex >= 0 && nextIndex < count) {
   incSides[sideIndex] = inc;
   return nextIndex;
  }
  return -1;
 },
 isValidId: function(id) {
  return id && !this.isExcludedId(id);
 },
 isExcludedId: function(id) {
  var result = false;
  for(var i = 0; i < this.excludedIDs.length; i++) {
   if(id.indexOf(this.excludedIDs[i]) > -1) {
    result = true;
    break;
   }
  }
  return result;
 }
});
var EventStorage = ASPx.CreateClass(null, {
 constructor: function() {
  this.bag = { };
 },
 Save: function(e, data, overwrite) {
  var key = this.getEventKey(e);
  if(this.bag.hasOwnProperty(key) && !overwrite)
   return;
  this.bag[key] = data;
  window.setTimeout(function() { delete this.bag[key]; }.aspxBind(this), 100);
 },
 Load: function(e) {
  var key = this.getEventKey(e);
  return this.bag[key];
 },
 getEventKey: function(e) {
  if(ASPx.IsExists(e.timeStamp))
   return e.timeStamp.toString();
  var eventSource = ASPx.Evt.GetEventSource(e);
  var type = e.type.toString();
  return eventSource ? type + "_" + eventSource.uniqueID.toString() : type;
 }
});
ASPx.RestoreFocusHelper = new RestoreFocusHelper();
EventStorage.Instance = null;
EventStorage.getInstance = function() {
 if(!EventStorage.Instance)
  EventStorage.Instance = new EventStorage();
 return EventStorage.Instance;
};
var GetGlobalObject = function(objectName) {
 var fields = objectName.split('.');
 var obj = window[fields[0]];
 for(var i = 1; obj && i < fields.length; i++) {
  obj = obj[fields[i]];
 }
 return obj;
};
var GetExternalScriptProcessor = function() {
 return ASPx.ExternalScriptProcessor ? ASPx.ExternalScriptProcessor.getInstance() : null;
};
var SAVED_WIDTH_ATTR = "data-dx-ripple-saved-width";
var RIPPLE_FIXED_ROW_ATTR = "data-dx-ripple-locked";
var READ_ONLY_COMBOBOX_MARKER_CSS_CLASS = "dxICBReadonlyMarker";
var ThemesWithRipple = ['Material'];
var RippleHelper = {
 rippleTargetClassName: "dxRippleTarget",
 rippleTargetExternalClassName: "dxRippleTargetExternal",
 rippleContainerClassName: "dxRippleContainer",
 rippleClassName: "dxRipple",
 touchRadius: -1,
 isMobileExternalRipple: null,
 zoom: 1,
 Init: function() {
  if(this.getIsRippleFunctionalityEnabled()) {
   setTimeout(function() {
    this.calcTouchRadius();
   }.aspxBind(this), 0);
  }
 },
 calcTouchRadius: function() {
  var testBlock = document.createElement("DIV");
  ASPx.SetStyles(testBlock, {
   height: "1in",
   width: "1in",
   left: "-100%",
   top: "-100%",
   position: "absolute"
  });
  document.body.appendChild(testBlock);
  this.touchRadius = (1.8 / 2.54) * Math.max(testBlock.offsetWidth, testBlock.offsetHeight);
  document.body.removeChild(testBlock);
 },
 isRippleFunctionalityEnabled: null,
 checkRippleFunctionality: function() {
  if(ASPx.Browser.Safari && ASPx.Browser.Version <= 5.1)
   return false;
  try {
   if(document.styleSheets) {
    for(var i = 0; i < document.styleSheets.length; i++) {
     var styleSheet = document.styleSheets[i];
     if(styleSheet.cssRules) {
      for(var j = 0; j < styleSheet.cssRules.length; j++)
       for(var k = 0; k < ThemesWithRipple.length; k++)
        if(styleSheet.cssRules[j].cssText.indexOf(ThemesWithRipple[k]) !== -1)
         return true;
     }
    }
   }
  }
  catch(exc) { }
  return false;
 },
 ReInit: function() {
  this.isRippleFunctionalityEnabled = null;
  this.Init();
 },
 onDocumentMouseDown: function(evt) {
  if(RippleHelper.getIsRippleFunctionalityEnabled())
   RippleHelper.processMouseDown(evt);
 },
 getIsRippleFunctionalityEnabled: function() {
  if(!ASPx.IsExists(this.isRippleFunctionalityEnabled))
   this.isRippleFunctionalityEnabled = this.checkRippleFunctionality();
  return this.isRippleFunctionalityEnabled;
 },
   createTargetInfo: function(target) {
  return { 
   x: ASPx.GetAbsoluteX(target),
   y: ASPx.GetAbsoluteY(target),
   width: target.offsetWidth,
   height: target.offsetHeight,
   classNames: ASPx.GetClassNameList(target),
   getTarget: function() { return target; },
   getRect: function() { return {x: this.x, y: this.y, width: this.width, height: this.height }; }
  };
 },
 createEventInfo: function(evt) {
  return { x: this.getEventX(evt), y: this.getEventY(evt) };
 },
 processMouseDown: function(evt) {
  var evtSource = ASPx.Evt.GetEventSource(evt);
  var rippleTarget = this.getRippleTargetElement(evtSource);
  if(this.needToProcessRipple(rippleTarget, evtSource))
   this.processRipple(this.createTargetInfo(rippleTarget), this.createEventInfo(evt));
 },
 getRippleTargetElement: function(evtSource) {
  if(this.hasRippleMarker(evtSource))
   return evtSource;
  if(evtSource.tagName && evtSource.tagName.toLowerCase() == "input" && ASPx.ElementContainsCssClass(evtSource, "dxTI")) {
   var elements = ASPx.GetChildElementNodesByPredicate(evtSource.parentNode.parentNode, function(element) {
    return this.hasRippleMarker(element);
   }.aspxBind(this));
   return elements && elements[0];
  }
  return ASPx.GetParent(evtSource, function(element) {
   return this.hasRippleMarker(element);
  }.aspxBind(this));
 },
 hasRippleMarker: function(element) {
  if(!ASPx.IsExistsElement(element))
   return false;
  var computedStyles = window.getComputedStyle(element, ":before");
  if(ASPx.IsExists(computedStyles)) {
   var content = computedStyles.getPropertyValue("content");
   if(content.indexOf(this.rippleTargetExternalClassName) > -1) {
    ASPx.AddClassNameToElement(element, this.rippleTargetExternalClassName);
    return true;
   }
   return content.indexOf(this.rippleTargetClassName) > -1;
  }
  return false;
 },
 needToProcessRipple: function(rippleTarget, evtSource) {
  if(!rippleTarget || !ASPx.AnimationUtils)
   return false;
  var isClearButton = ASPx.ElementContainsCssClass(rippleTarget, "dxeButton") && rippleTarget.id && rippleTarget.id.indexOf("B-100") !== -1;
  var isEmptyCalendarDay = ASPx.ElementContainsCssClass(rippleTarget, "dxeCalendarDay") && ASPx.Str.Trim(rippleTarget.textContent) == "";
  var isReadonly = ASPx.ElementContainsCssClass(rippleTarget, READ_ONLY_COMBOBOX_MARKER_CSS_CLASS);
  var tempFixDisable = ASPx.ElementContainsCssClass(rippleTarget, "dxSwitcher") && ASPx.Browser.MacOSMobilePlatform;
  var rippleIsForbidden = isReadonly || isClearButton || isEmptyCalendarDay || ASPx.GetParentByPartialClassName(rippleTarget, "Disabled") ||
   ASPx.ElementContainsCssClass(rippleTarget, "dxgvBatchEditCell") || ASPx.ElementContainsCssClass(rippleTarget, "dxcvEditForm") ||
   ASPx.GetParentByPartialClassName(evtSource, "dxcvFocusedCell") || tempFixDisable;
  return !rippleIsForbidden;
 },
 hasBothOverflow: function(style) {
  return style.overflow == "scroll" || style.overflow == "auto" || style.overflow == "hidden";
 },
 hasOverflowX: function(style) {
  return style.overflowX == "scroll" || style.overflowX == "auto" || style.overflowX == "hidden";
 },
 hasOverflowY: function(style) {
  return style.overflowY == "scroll" || style.overflowY == "auto" || style.overflowY == "hidden";
 },
 getExternalRippleContainerSize: function(targetRect) {
  if(ASPx.Browser.MobileUI) {
   var origTouchRadius = this.getOriginTouchRadius();
   if(origTouchRadius < targetRect.width || origTouchRadius < targetRect.height)
    origTouchRadius = Math.max(targetRect.width, targetRect.height);
   return {x: targetRect.x + (targetRect.width - origTouchRadius) / 2, y: targetRect.y + (targetRect.height - origTouchRadius) / 2, width: origTouchRadius, height: origTouchRadius };
  }
  var result = { x: 0, y: 0, width: 0, height: 0 };
  var diff = targetRect.width - targetRect.height;
  if(diff > 0) {
   result.x = targetRect.x;
   result.y = targetRect.y - diff / 2;
   result.width = targetRect.width;
   result.height = targetRect.width;
  } else {
   result.x = targetRect.x + diff / 2;
   result.y = targetRect.y;
   result.width = targetRect.height;
   result.height = targetRect.height;
  }
  return result;
 },
 getInternalContainerSize: function(targetInfo) {
  var parentWithOverflow = RippleHelper.getParentWithOverflow(targetInfo.getTarget());
  if(!ASPx.IsExists(parentWithOverflow))
   return targetInfo;
  var parentWithOverflowStyle = ASPx.GetCurrentStyle(parentWithOverflow);
  var bothOverflow = this.hasBothOverflow(parentWithOverflowStyle);
  var overflowX = this.hasOverflowX(parentWithOverflowStyle);
  var overflowY = this.hasOverflowY(parentWithOverflowStyle);
  var parentRect = {
   x: ASPx.GetAbsoluteX(parentWithOverflow),
   y: ASPx.GetAbsoluteY(parentWithOverflow),
   width: parentWithOverflow.offsetWidth,
   height: parentWithOverflow.offsetHeight
  };
  return this.getInternalContainerSizeCore(targetInfo, parentRect, bothOverflow, overflowX, overflowY);
 },
 getInternalContainerSizeCore: function(targetRect, parentRect, bothOverflow, overflowX, overflowY) {
  var result = {};
  ASPx.Data.MergeHashTables(result, targetRect);
  if(bothOverflow || overflowX) {
   result.x = targetRect.x < parentRect.x ? parentRect.x : targetRect.x;
   if(targetRect.x + targetRect.width > parentRect.x + parentRect.width)
    result.width = parentRect.x + parentRect.width - targetRect.x;
   if(parentRect.x > targetRect.x)
    result.width -= (parentRect.x - targetRect.x);
  }
  if(bothOverflow || overflowY) {
   result.y = targetRect.y < parentRect.y ? parentRect.y : targetRect.y;
   if(targetRect.y + targetRect.height > parentRect.y + parentRect.height)
    result.height = parentRect.y + parentRect.height - targetRect.y;
   if(parentRect.y > targetRect.y)
    result.height -= (parentRect.y - targetRect.y);
  }
  return result;
 },
 calculateRippleContainerSize: function(targetInfo, isExternalRipple) {
  return isExternalRipple ? this.getExternalRippleContainerSize(targetInfo) : this.getInternalContainerSize(targetInfo);
 },
 getParentWithOverflow: function(rippleTarget) {
  var result = ASPx.GetParent(rippleTarget, function(element) {
   var elementStyle = ASPx.GetCurrentStyle(element);
   return this.hasBothOverflow(elementStyle) || this.hasOverflowX(elementStyle) || this.hasOverflowY(elementStyle);
  }.aspxBind(this));
  return result;
 },
 getDuration: function(targetInfo) {
  return this.IsExternalRipple(targetInfo) || ASPx.Browser.MobileUI ? 650 : 450;
 },
 createRippleTransition: function(container, rippleElement, radius, targetInfo) {
  var rippleSize = 2 * radius;
  var transitionEndIsAborted = true;
  var transitionProperties = {
   width: { from: 0, to: rippleSize, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "width", unit: "px" },
   height: { from: 0, to: rippleSize, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "height", unit: "px" },
   marginLeft: { from: 0, to: -rippleSize / 2, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "marginLeft", unit: "px" },
   marginTop: { from: 0, to: -rippleSize / 2, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "marginTop", unit: "px" },
   opacity: { from: 1, to: 0.05, transition: ASPx.AnimationConstants.Transitions.RIPPLE, propName: "opacity", unit: "%" }
  };
  var rippleTransition = ASPx.AnimationUtils.createMultipleAnimationTransition(rippleElement, {
   transition: ASPx.AnimationConstants.Transitions.RIPPLE,
   duration: this.getDuration(targetInfo),
   onComplete: function() {
    this.RemoveRippleContainer(container.parentElement);
    transitionEndIsAborted = false;
   }.bind(this)
  });
  rippleTransition.Start(transitionProperties);
  window.setTimeout(function() {
   if(transitionEndIsAborted)
    this.RemoveRippleContainer(container.parentElement);
  }.bind(this), 500);
 },
 calculateRadius: function(isExternalRipple, posX, posY, containerRect) {
  var radius = -1;
  if(isExternalRipple) {
   if(ASPx.Browser.MobileUI)
    radius = this.getOriginTouchRadius() / 2;
   else
    radius = Math.max(containerRect.height, containerRect.width);
  } else {
   var width1 = posX - containerRect.x;
   var width2 = containerRect.width - width1;
   var height1 = posY - containerRect.y;
   var height2 = containerRect.height - height1;
   var rippleWidth = Math.max(width1, width2);
   var rippleHeight = Math.max(height1, height2);
   radius = Math.sqrt(Math.pow(rippleHeight, 2) + Math.pow(rippleWidth, 2));
  }
  return radius;
 },
 createRippleElement: function(container, rippleCenter) {
  var rippleElement = document.createElement("DIV");
  rippleElement.className = this.rippleClassName;
  container.appendChild(rippleElement);
  ASPxClientUtils.SetAbsoluteX(rippleElement, rippleCenter.x);
  ASPxClientUtils.SetAbsoluteY(rippleElement, rippleCenter.y);
  return rippleElement;
 },
 processRipple: function(targetInfo, eventInfo) {
  this.initRippleProcess();
  var isExternalRipple = this.IsExternalRipple(targetInfo);
  var rippleCenter = this.getRippleCenter(targetInfo.getRect(), eventInfo, isExternalRipple);
  var container = this.createRippleContainer(targetInfo, isExternalRipple);
  var rippleElement = this.createRippleElement(container, rippleCenter);
  var radius = this.calculateRadius(isExternalRipple, rippleCenter.x, rippleCenter.y, this.getElementRect(container));
  this.createRippleTransition(container, rippleElement, radius, targetInfo);
 },
 initRippleProcess: function() {
  this.isMobileExternalRipple = null;
  this.zoom = screen.width / window.innerWidth;
 },
 getRippleCenter: function(targetInfo, eventInfo, isExternalRipple) {
  var posX = 0;
  var posY = 0;
  if(isExternalRipple) {
   posX = targetInfo.x + targetInfo.width / 2;
   posY = targetInfo.y + targetInfo.height / 2;
  } else {
   posX = eventInfo.x;
   posY = eventInfo.y;
  }
  return {x: posX, y: posY};
 },
 createRippleContainer: function(targetInfo, isExternalRipple) {
  var containerParent = targetInfo.getTarget();
  if(!containerParent)
   return;
  var containerTagName = containerParent.tagName == "TR" ? "TD" : "DIV";
  var container = document.createElement(containerTagName);
  container.className = this.rippleContainerClassName;
  if(containerParent.parentNode && containerParent.tagName == "IMG")
   containerParent = containerParent.parentNode;
  if(this.isARowInFixedLayoutTable(containerParent))
   this.lockFixedLayoutTableSizes(containerParent);
  containerParent.appendChild(container);
  if(isExternalRipple)
   container.style.borderRadius = "50%";
  var containerRect = this.calculateRippleContainerSize(targetInfo, isExternalRipple);
  this.assignContainerSettings(container, containerRect);
  return container;
 },
 isARowInFixedLayoutTable: function(containerParent) {
  if(containerParent.tagName !== "TR")
   return false;
  var parentTable = this.getParentTable(containerParent);
  return parentTable && ASPx.GetCurrentStyle(parentTable)["table-layout"] === "fixed";
 },
 processFirstRowOfFixedTable: function(containerRow, rowAction, cellAction) {
  var firstRow = this.getFirstRow(containerRow);
  rowAction(firstRow);
  var cells = ASPx.Data.CollectionToArray(firstRow.cells);
  cells.forEach(cellAction);
 },
 getParentTable: function(element) {
  var parentTable = element;
  while(parentTable && parentTable.tagName !== "TABLE")
   parentTable = parentTable.parentElement;
  return parentTable;
 },
 lockFixedLayoutTableSizes: function(containerRow) {
  var firstRow = this.getFirstRow(containerRow);
  if(this.incLockCount(firstRow) === 1) {
   var cells = ASPx.Data.CollectionToArray(firstRow.cells);
   var widths = cells.map(function(cell) { return cell.style.width; });
   var computedWidths = cells.map(function(cell) {
    if(ASPx.Browser.IE && ASPx.ElementHasCssClass(cell, "dxeCM"))
     return cell.offsetWidth + "px";
    return window.getComputedStyle(cell).width;
   });
   var fixWidth = function(cell, i) {
    if(ASPx.Attr.IsExistsAttribute(cell, SAVED_WIDTH_ATTR))
     return;
    if(widths[i])
     ASPx.Attr.SetAttribute(cell, SAVED_WIDTH_ATTR, widths[i]);
    cell.style.width = computedWidths[i];
   };
   cells.forEach(fixWidth);
  }
 }, 
 unlockFixedLayoutTableSizes: function(containerRow) {
  var firstRow = this.getFirstRow(containerRow);   
  if(this.decLockCount(firstRow) === 0) {
   var cells = ASPx.Data.CollectionToArray(firstRow.cells);
   var restoreState = function(cell) {
    if(ASPx.Attr.IsExistsAttribute(cell, SAVED_WIDTH_ATTR)) {
     cell.style.width = ASPx.Attr.GetAttribute(cell, SAVED_WIDTH_ATTR);
     ASPx.Attr.RemoveAttribute(cell, SAVED_WIDTH_ATTR);
    } else {
     cell.style.width = null;
    }
   };
   cells.forEach(restoreState);
  }
 },
 getFirstRow: function(containerRow) { return ASPx.GetChildByTagName(containerRow.parentElement, "TR", 0); },
 incLockCount: function(elem) { return this.changeLockCount(elem, 1); },
 decLockCount: function(elem) { return this.changeLockCount(elem, -1); },
 changeLockCount: function(elem, diff) {
  var lockCounter = this.getLockCount(elem);
  lockCounter += diff;
  lockCounter = Math.max(0, lockCounter);
  if(lockCounter === 0)
   ASPx.Attr.RemoveAttribute(elem, RIPPLE_FIXED_ROW_ATTR);
  else
   ASPx.Attr.SetAttribute(elem, RIPPLE_FIXED_ROW_ATTR, lockCounter);
  return lockCounter;
 },
 getLockCount: function(lockElement) {
  var attrValue = ASPx.Attr.GetAttribute(lockElement, RIPPLE_FIXED_ROW_ATTR);
  return parseInt(attrValue) || 0;
 },
 assignContainerSettings: function(container, containerRect) {
  var properties = {
   height: containerRect.height,
   width: containerRect.width,
   left: ASPx.PrepareClientPosForElement(containerRect.x, container, true),
   top: ASPx.PrepareClientPosForElement(containerRect.y, container, false)
  };
  if(ASPx.Browser.MobileUI)
   ASPx.Data.MergeHashTables(properties, {marginTop: 0, marginLeft: 0 });
  ASPx.SetStyles(container, properties, ASPx.Browser.MobileUI);
 },
 IsExternalRipple: function(targetInfo) {
  var hasExternalRippleClassName = ASPx.ElementContainsCssClass(targetInfo.getTarget(), this.rippleTargetExternalClassName);
  if(!ASPx.Browser.MobileUI)
   return hasExternalRippleClassName;
  return hasExternalRippleClassName || this.IsMobileExternalRipple(targetInfo);
 },
 IsMobileExternalRipple: function(targetInfo) {
  if(this.isMobileExternalRipple == null) {
   var originTouchRadius = this.getOriginTouchRadius();
   this.isMobileExternalRipple = ASPx.Browser.MobileUI && targetInfo.width < originTouchRadius && targetInfo.height < originTouchRadius;
  }
  return this.isMobileExternalRipple;
 },
 RemoveRippleContainer: function(element) {
  if(!element)
   return;
  var childs = ASPx.GetChildNodesByClassName(element, this.rippleContainerClassName);
  var rippleContainer = childs.length > 0 ? childs[0] : null;
  if(rippleContainer != null) {
   var containerParent = rippleContainer.parentNode;
   containerParent.removeChild(rippleContainer);
   if(this.isARowInFixedLayoutTable(containerParent))
    this.unlockFixedLayoutTableSizes(containerParent);
  }
 },
 getEventX: function(evt) {
  return ASPxClientUtils.GetEventX(evt);
 },
 getEventY: function(evt) {
  return ASPxClientUtils.GetEventY(evt);
 },
 getOriginTouchRadius: function() {
  return this.touchRadius / this.zoom;
 },
 getElementRect: function(element) {
  return { x: ASPx.GetAbsoluteX(element), y: ASPx.GetAbsoluteY(element), width: element.offsetWidth, height: element.offsetHeight };
 }
};
var AccessibilitySR = {
 AddStringResources: function(stringResourcesObj) {
  if(stringResourcesObj) {
   for(var key in stringResourcesObj)
    if(stringResourcesObj.hasOwnProperty(key))
     this[key] = stringResourcesObj[key];
  }
 }
};
ASPx.CollectionBase = CollectionBase;
ASPx.FunctionIsInCallstack = _aspxFunctionIsInCallstack;
ASPx.RaisePostHandlerOnPost = aspxRaisePostHandlerOnPost;
ASPx.GetPostHandler = aspxGetPostHandler;
ASPx.ProcessScriptsAndLinks = _aspxProcessScriptsAndLinks;
ASPx.InitializeLinks = _aspxInitializeLinks;
ASPx.InitializeScripts = _aspxInitializeScripts;
ASPx.RunStartupScripts = _aspxRunStartupScripts;
ASPx.IsStartupScriptsRunning = _aspxIsStartupScriptsRunning;
ASPx.AddScriptsRestartHandler = _aspxAddScriptsRestartHandler;
ASPx.GetFocusedElement = _aspxGetFocusedElement;
ASPx.GetDomObserver = _aspxGetDomObserver;
ASPx.CacheHelper = CacheHelper;
ASPx.ControlTree = ControlTree;
ASPx.ControlCallbackHandlersQueue = ControlCallbackHandlersQueue;
ASPx.ResourceManager = ResourceManager;
ASPx.UpdateWatcherHelper = UpdateWatcherHelper;
ASPx.EventStorage = EventStorage;
ASPx.GetGlobalObject = GetGlobalObject;
ASPx.GetExternalScriptProcessor = GetExternalScriptProcessor;
ASPx.CheckBoxCheckState = CheckBoxCheckState;
ASPx.CheckBoxInputKey = CheckBoxInputKey;
ASPx.CheckableElementStateController = CheckableElementStateController;
ASPx.CheckableElementHelper = CheckableElementHelper;
ASPx.CheckBoxInternal = CheckBoxInternal;
ASPx.CheckBoxInternalCollection = CheckBoxInternalCollection;
ASPx.ControlCallbackQueueHelper = ControlCallbackQueueHelper;
ASPx.EditorStyleDecoration = EditorStyleDecoration;
ASPx.AccessibilitySR = AccessibilitySR;
ASPx.KbdHelper = KbdHelper;
ASPx.AccessKeysHelper = AccessKeysHelper;
ASPx.AccessKey = AccessKey;
ASPx.IFrameHelper = IFrameHelper;
ASPx.Ident = Ident;
ASPx.TouchUIHelper = TouchUIHelper;
ASPx.ControlUpdateWatcher = ControlUpdateWatcher;
ASPx.AccessibilityHelperBase = AccessibilityHelperBase;
ASPx.RippleHelper = RippleHelper;
ASPx.ThemesWithRipple = ThemesWithRipple;
window.ASPxClientEvent = ASPxClientEvent;
window.ASPxClientEventArgs = ASPxClientEventArgs;
window.ASPxClientCancelEventArgs = ASPxClientCancelEventArgs;
window.ASPxClientProcessingModeEventArgs = ASPxClientProcessingModeEventArgs;
window.ASPxClientProcessingModeCancelEventArgs = ASPxClientProcessingModeCancelEventArgs;
ASPx.Evt.AttachEventToDocument(TouchUIHelper.touchMouseDownEventName, RippleHelper.onDocumentMouseDown);
ASPx.classesScriptParsed = true;
})();

(function () {
ASPx.StateItemsExist = false;
ASPx.FocusedItemKind = "FocusedStateItem";
ASPx.HoverItemKind = "HoverStateItem";
ASPx.PressedItemKind = "PressedStateItem";
ASPx.SelectedItemKind = "SelectedStateItem";
ASPx.DisabledItemKind = "DisabledStateItem";
ASPx.CachedStatePrefix = "cached";
ASPxStateItem = ASPx.CreateClass(null, {
 constructor: function(name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, kind, disableApplyingStyleToLink){
  this.name = name;
  this.classNames = classNames;
  this.customClassNames = [];
  this.resultClassNames = [];
  this.cssTexts = cssTexts;
  this.postfixes = postfixes;
  this.imageObjs = imageObjs;
  this.imagePostfixes = imagePostfixes;
  this.kind = kind;
  this.classNamePostfix = kind.substr(0, 1).toLowerCase();
  this.enabled = true;
  this.needRefreshBetweenElements = false;
  this.elements = null;
  this.images = null;
  this.links = [];
  this.linkColor = null;
  this.linkTextDecoration = null;
  this.disableApplyingStyleToLink = !!disableApplyingStyleToLink; 
 },
 GetCssText: function(index){
  if(ASPx.IsExists(this.cssTexts[index]))
   return this.cssTexts[index];
  return this.cssTexts[0];
 },
 CreateStyleRule: function(index){
  if(this.GetCssText(index) == "") return "";
  var styleSheet = ASPx.GetCurrentStyleSheet();
  if(styleSheet)
   return ASPx.CreateImportantStyleRule(styleSheet, this.GetCssText(index), this.classNamePostfix);  
  return ""; 
 },
 GetClassName: function(index){
  if(ASPx.IsExists(this.classNames[index]))
   return this.classNames[index];
  return this.classNames[0];
 },
 GetResultClassName: function(index){
  if(!ASPx.IsExists(this.resultClassNames[index])) {
   if(!ASPx.IsExists(this.customClassNames[index]))
    this.customClassNames[index] = this.CreateStyleRule(index);
   if(this.GetClassName(index) != "" && this.customClassNames[index] != "")
    this.resultClassNames[index] = this.GetClassName(index) + " " + this.customClassNames[index];
   else if(this.GetClassName(index) != "")
    this.resultClassNames[index] = this.GetClassName(index);
   else if(this.customClassNames[index] != "")
    this.resultClassNames[index] = this.customClassNames[index];
   else
    this.resultClassNames[index] = "";
  }
  return this.resultClassNames[index];
 },
 GetElements: function(element){
  if(!this.elements || !ASPx.IsValidElements(this.elements)){
   if(this.postfixes && this.postfixes.length > 0){
    this.elements = [ ];
    var parentNode = element.parentNode;
    if(parentNode){
     for(var i = 0; i < this.postfixes.length; i++){
      var id = this.name + this.postfixes[i];
      this.elements[i] = ASPx.GetChildById(parentNode, id);
      if(!this.elements[i])
       this.elements[i] = ASPx.GetElementById(id);
     }
    }
   }
   else
    this.elements = [element];
  }
  return this.elements;
 },
 GetImages: function(element){
  if(!this.images || !ASPx.IsValidElements(this.images)){
   this.images = [ ];
   if(this.imagePostfixes && this.imagePostfixes.length > 0){
    var elements = this.GetElements(element);
    for(var i = 0; i < this.imagePostfixes.length; i++){
     var id = this.name + this.imagePostfixes[i];
     for(var j = 0; j < elements.length; j++){
      if(!elements[j]) continue;
      if(elements[j].id == id)
       this.images[i] = elements[j];
      else
       this.images[i] = ASPx.GetChildById(elements[j], id);
      if(this.images[i])
       break;
     }
    }
   }
  }
  return this.images;
 },
 Apply: function(element){
  if(!this.enabled) return;
  try{
   this.ApplyStyle(element);
   if(this.imageObjs && this.imageObjs.length > 0)
    this.ApplyImage(element);
   if(ASPx.Browser.IE && ASPx.Browser.MajorVersion >= 11)
    this.ForceRedrawAppearance(element);
  }
  catch(e){
  }
 },
 ApplyStyle: function(element){
  var elements = this.GetElements(element);
  for(var i = 0; i < elements.length; i++){
   if(!elements[i]) continue;
   if(this.GetResultClassName(i) != "") {
    var className = elements[i].className.replace(this.GetResultClassName(i), "");
    elements[i].className = ASPx.Str.Trim(className) + " " + this.GetResultClassName(i);
   }
   if(!ASPx.Browser.Opera || ASPx.Browser.Version >= 9)
    this.ApplyStyleToLinks(elements, i);
  }
 },
 ApplyStyleToLinks: function(elements, index){
  if(this.disableApplyingStyleToLink)
   return;
  if(!ASPx.IsValidElements(this.links[index]))
   this.links[index] = ASPx.GetNodesByTagName(elements[index], "A");
  for(var i = 0; i < this.links[index].length; i++)
   this.ApplyStyleToLinkElement(this.links[index][i], index);
 },
 ApplyStyleToLinkElement: function(link, index){
  if(this.GetLinkColor(index) != "")
   ASPx.Attr.ChangeAttributeExtended(link.style, "color", link, "saved" + this.kind + "Color", this.GetLinkColor(index));
  if(this.GetLinkTextDecoration(index) != "")
   ASPx.Attr.ChangeAttributeExtended(link.style, "textDecoration", link, "saved" + this.kind + "TextDecoration", this.GetLinkTextDecoration(index));
 },
 ApplyImage: function(element){
  var images = this.GetImages(element);
  for(var i = 0; i < images.length; i++){
   if(!images[i] || !this.imageObjs[i]) continue;
   var useSpriteImage = typeof(this.imageObjs[i]) != "string";
   var newUrl = "", newCssClass = "", newBackground = "";
   if(useSpriteImage){
    newUrl = ASPx.EmptyImageUrl;           
    if(this.imageObjs[i].spriteCssClass) 
     newCssClass = this.imageObjs[i].spriteCssClass;
    if(this.imageObjs[i].spriteBackground)
     newBackground = this.imageObjs[i].spriteBackground;
   }
   else{
    newUrl = this.imageObjs[i];
    if(ASPx.Attr.IsExistsAttribute(images[i].style, "background"))   
     newBackground = " ";
   }
   if(newUrl != "")
    ASPx.Attr.ChangeAttributeExtended(images[i], "src", images[i], "saved" + this.kind + "Src", newUrl);
   if(newCssClass != "")
    this.ApplyImageClassName(images[i], newCssClass);
   if(newBackground != ""){
    if(ASPx.Browser.WebKitFamily) {
     var savedBackground = ASPx.Attr.GetAttribute(images[i].style, "background");
     if(!useSpriteImage)
      savedBackground += " " + images[i].style["backgroundPosition"];
     ASPx.Attr.SetAttribute(images[i], "saved" + this.kind + "Background", savedBackground);
     ASPx.Attr.SetAttribute(images[i].style, "background", newBackground);
    }
    else
     ASPx.Attr.ChangeAttributeExtended(images[i].style, "background", images[i], "saved" + this.kind + "Background", newBackground);
   }     
  }
 },
 ApplyImageClassName: function(element, newClassName){
  if(ASPx.Attr.GetAttribute(element, "saved" + this.kind + "ClassName"))
   this.CancelImageClassName(element);
  var className = element.className;
  ASPx.Attr.SetAttribute(element, "saved" + this.kind + "ClassName", className);
  element.className = className + " " + newClassName;
 },
 Cancel: function(element){
  if(!this.enabled) return;
  try{  
   if(this.imageObjs && this.imageObjs.length > 0)
    this.CancelImage(element);
   this.CancelStyle(element);
  }
  catch(e){
  }
 },
 CancelStyle: function(element){
  var elements = this.GetElements(element);
  for(var i = 0; i < elements.length; i++){
   if(!elements[i]) continue;
   if(this.GetResultClassName(i) != "") {
    var className = ASPx.Str.Trim(elements[i].className.replace(this.GetResultClassName(i), ""));
    elements[i].className = className;
   }
   if(!ASPx.Browser.Opera || ASPx.Browser.Version >= 9)
    this.CancelStyleFromLinks(elements, i);
  }
 },
 CancelStyleFromLinks: function(elements, index){
  if(this.disableApplyingStyleToLink)
   return;
  if(!ASPx.IsValidElements(this.links[index]))
   this.links[index] = ASPx.GetNodesByTagName(elements[index], "A");
  for(var i = 0; i < this.links[index].length; i++)
   this.CancelStyleFromLinkElement(this.links[index][i], index);
 },
 CancelStyleFromLinkElement: function(link, index){
  if(this.GetLinkColor(index) != "")
   ASPx.Attr.RestoreAttributeExtended(link.style, "color", link, "saved" + this.kind + "Color");
  if(this.GetLinkTextDecoration(index) != "")
   ASPx.Attr.RestoreAttributeExtended(link.style, "textDecoration", link, "saved" + this.kind + "TextDecoration");
 },
 CancelImage: function(element){
  var images = this.GetImages(element);
  for(var i = 0; i < images.length; i++){
   if(!images[i] || !this.imageObjs[i]) continue;
   ASPx.Attr.RestoreAttributeExtended(images[i], "src", images[i], "saved" + this.kind + "Src");
   this.CancelImageClassName(images[i]);
   ASPx.Attr.RestoreAttributeExtended(images[i].style, "background", images[i], "saved" + this.kind + "Background");
  }
 },
 CancelImageClassName: function(element){
  var savedClassName = ASPx.Attr.GetAttribute(element, "saved" + this.kind + "ClassName");
  if(ASPx.IsExists(savedClassName)) {
   element.className = savedClassName;
   ASPx.Attr.RemoveAttribute(element, "saved" + this.kind + "ClassName");
  }
 },
 Clone: function(){
  return new ASPxStateItem(this.name, this.classNames, this.cssTexts, this.postfixes, 
   this.imageObjs, this.imagePostfixes, this.kind, this.disableApplyingStyleToLink);
 },
 IsChildElement: function(element){
  if(element != null){
   var elements = this.GetElements(element);
   for(var i = 0; i < elements.length; i++){
    if(!elements[i]) continue;
    if(ASPx.GetIsParent(elements[i], element)) 
     return true;
   }
  }
  return false;
 },
 ForceRedrawAppearance: function(element) {
  if(!aspxGetStateController().IsForceRedrawAppearanceLocked()) {
   var value = element.style.opacity;
   element.style.opacity = "0.7777";
   var dummy = element.offsetWidth;
   element.style.opacity = value;
  }
 },
 GetLinkColor: function(index){
  if(!ASPx.IsExists(this.linkColor)){
   var rule = ASPx.GetStyleSheetRules(this.customClassNames[index]);
   this.linkColor = rule ? rule.style.color : null;
   if(!ASPx.IsExists(this.linkColor)){
    var rule = ASPx.GetStyleSheetRules(this.GetClassName(index));
    this.linkColor = rule ? rule.style.color : null;
   }
   if(this.linkColor == null) 
    this.linkColor = "";
  }
  return this.linkColor;
 },
 GetLinkTextDecoration: function(index){
  if(!ASPx.IsExists(this.linkTextDecoration)){
   var rule = ASPx.GetStyleSheetRules(this.customClassNames[index]);
   this.linkTextDecoration = rule ? rule.style.textDecoration : null;
   if(!ASPx.IsExists(this.linkTextDecoration)){
    var rule = ASPx.GetStyleSheetRules(this.GetClassName(index));
    this.linkTextDecoration = rule ? rule.style.textDecoration : null;
   }
   if(this.linkTextDecoration == null) 
    this.linkTextDecoration = "";
  }
  return this.linkTextDecoration;
 }
});
ASPxClientStateEventArgs = ASPx.CreateClass(null, {
 constructor: function(item, element){
  this.item = item;
  this.element = element;
  this.toElement = null;
  this.fromElement = null;
  this.htmlEvent = null;
 }
});
ASPxStateController = ASPx.CreateClass(null, {
 constructor: function(){
  this.focusedItems = { };
  this.hoverItems = { };
  this.pressedItems = { };
  this.selectedItems = { };
  this.disabledItems = { };
  this.disabledScheme = {};
  this.currentFocusedElement = null;
  this.currentFocusedItemName = null;
  this.currentHoverElement = null;
  this.currentHoverItemName = null;
  this.currentPressedElement = null;
  this.currentPressedItemName = null;
  this.savedCurrentPressedElement = null;
  this.savedCurrentMouseMoveSrcElement = null;
  this.forceRedrawAppearanceLockCount = 0;
  this.AfterSetFocusedState = new ASPxClientEvent();
  this.AfterClearFocusedState = new ASPxClientEvent();
  this.AfterSetHoverState = new ASPxClientEvent();
  this.AfterClearHoverState = new ASPxClientEvent();
  this.AfterSetPressedState = new ASPxClientEvent();
  this.AfterClearPressedState = new ASPxClientEvent();
  this.AfterDisabled = new ASPxClientEvent();
  this.AfterEnabled = new ASPxClientEvent();
  this.BeforeSetFocusedState = new ASPxClientEvent();
  this.BeforeClearFocusedState = new ASPxClientEvent();
  this.BeforeSetHoverState = new ASPxClientEvent();
  this.BeforeClearHoverState = new ASPxClientEvent();
  this.BeforeSetPressedState = new ASPxClientEvent();
  this.BeforeClearPressedState = new ASPxClientEvent();
  this.BeforeDisabled = new ASPxClientEvent();
  this.BeforeEnabled = new ASPxClientEvent();
  this.FocusedItemKeyDown = new ASPxClientEvent();
 }, 
 AddHoverItem: function(name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, disableApplyingStyleToLink){
  this.AddItem(this.hoverItems, name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, ASPx.HoverItemKind, disableApplyingStyleToLink);
  this.AddItem(this.focusedItems, name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, ASPx.FocusedItemKind, disableApplyingStyleToLink);
 },
 AddPressedItem: function(name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes ,disableApplyingStyleToLink){
  this.AddItem(this.pressedItems, name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, ASPx.PressedItemKind, disableApplyingStyleToLink);
 },
 AddSelectedItem: function(name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, disableApplyingStyleToLink){
  this.AddItem(this.selectedItems, name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, ASPx.SelectedItemKind, disableApplyingStyleToLink);
 },
 AddDisabledItem: function (name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, disableApplyingStyleToLink, rootId) {
  this.AddItem(this.disabledItems, name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes,
   ASPx.DisabledItemKind, disableApplyingStyleToLink, this.addIdToDisabledItemScheme, rootId);
 },
 addIdToDisabledItemScheme: function(rootId, childId) {
  if (!rootId)
   return;
  if (!this.disabledScheme[rootId])
   this.disabledScheme[rootId] = [rootId];
  if (childId && (rootId != childId) && ASPx.Data.ArrayIndexOf(this.disabledScheme[rootId], childId) == -1)
   this.disabledScheme[rootId].push(childId);
 },
 removeIdFromDisabledItemScheme: function(rootId, childId) {
  if (!rootId || !this.disabledScheme[rootId])
   return;
  ASPx.Data.ArrayRemove(this.disabledScheme[rootId], childId);
  if (this.disabledScheme[rootId].length == 0)
   delete this.disabledScheme[rootId];
 },
 AddItem: function (items, name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, kind, disableApplyingStyleToLink, onAdd, rootId) {
  var stateItem = new ASPxStateItem(name, classNames, cssTexts, postfixes, imageObjs, imagePostfixes, kind, disableApplyingStyleToLink);
  if (postfixes && postfixes.length > 0) {
   for (var i = 0; i < postfixes.length; i++) {
    items[name + postfixes[i]] = stateItem;
    if (onAdd)
     onAdd.call(this, rootId, name + postfixes[i]);
   }
  }
  else {
   if (onAdd)
    onAdd.call(this, rootId, name);
   items[name] = stateItem;
  }
  ASPx.StateItemsExist = true;
 },
 RemoveHoverItem: function(name, postfixes){
  this.RemoveItem(this.hoverItems, name, postfixes);
  this.RemoveItem(this.focusedItems, name, postfixes);
 },
 RemovePressedItem: function(name, postfixes){
  this.RemoveItem(this.pressedItems, name, postfixes);
 },
 RemoveSelectedItem: function(name, postfixes){
  this.RemoveItem(this.selectedItems, name, postfixes);
 },
 RemoveDisabledItem: function (name, postfixes, rootId) {
  this.RemoveItem(this.disabledItems, name, postfixes, this.removeIdFromDisabledItemScheme, rootId);
 },
 RemoveItem: function (items, name, postfixes, onRemove, rootId) {
  if (postfixes && postfixes.length > 0) {
   for (var i = 0; i < postfixes.length; i++) {
    delete items[name + postfixes[i]];
    if (onRemove)
     onRemove.call(this, rootId, name + postfixes[i]);
   }
  }
  else {
   delete items[name];
   if (onRemove)
    onRemove.call(this, rootId, name);
  }
 },
 RemoveDisposedItems: function(){
  this.RemoveDisposedItemsByType(this.hoverItems);
  this.RemoveDisposedItemsByType(this.pressedItems);
  this.RemoveDisposedItemsByType(this.focusedItems);
  this.RemoveDisposedItemsByType(this.selectedItems);
  this.RemoveDisposedItemsByType(this.disabledItems);
  this.RemoveDisposedItemsByType(this.disabledScheme);
 },
 RemoveDisposedItemsByType: function(items){
  for(var key in items) {
   if(items.hasOwnProperty(key)) {
    var item = items[key];
    var element = document.getElementById(key);
    if(!element || !ASPx.IsValidElement(element))
     delete items[key];
    try {
     if(item && item.elements) {
      for(var i = 0; i < item.elements.length; i++) {
       if(!ASPx.IsValidElements(item.links[i]))
        item.links[i] = null;
      }
     }
    }
    catch(e) {
    }
   }
  }
 },
 GetFocusedElement: function(srcElement){
  return this.GetItemElement(srcElement, this.focusedItems, ASPx.FocusedItemKind);
 },
 GetHoverElement: function(srcElement){
  return this.GetItemElement(srcElement, this.hoverItems, ASPx.HoverItemKind);
 },
 GetPressedElement: function(srcElement){
  return this.GetItemElement(srcElement, this.pressedItems, ASPx.PressedItemKind);
 },
 GetSelectedElement: function(srcElement){
  return this.GetItemElement(srcElement, this.selectedItems, ASPx.SelectedItemKind);
 },
 GetDisabledElement: function(srcElement){
  return this.GetItemElement(srcElement, this.disabledItems, ASPx.DisabledItemKind);
 },
 GetItemElement: function(srcElement, items, kind){
  if(srcElement && srcElement[ASPx.CachedStatePrefix + kind]){
   var cachedElement = srcElement[ASPx.CachedStatePrefix + kind];
   if(cachedElement != ASPx.EmptyObject)
    return cachedElement;
   return null;
  }
  var element = srcElement;
  while(element != null) {
   var item = items[element.id];
   if(item){
    this.CacheItemElement(srcElement, kind, element);
    element[kind] = item;
    return element;
   }
   element = element.parentNode;
  }
  this.CacheItemElement(srcElement, kind, ASPx.EmptyObject);
  return null;
 },
 CacheItemElement: function(srcElement, kind, value){
  if(srcElement && !srcElement[ASPx.CachedStatePrefix + kind])
   srcElement[ASPx.CachedStatePrefix + kind] = value;
 },
 DoSetFocusedState: function(element, fromElement){
  var item = element[ASPx.FocusedItemKind];
  if(item){
   var args = new ASPxClientStateEventArgs(item, element);
   args.fromElement = fromElement;
   this.BeforeSetFocusedState.FireEvent(this, args);
   item.Apply(element);
   this.AfterSetFocusedState.FireEvent(this, args);
  }
 },
 DoClearFocusedState: function(element, toElement){
  var item = element[ASPx.FocusedItemKind];
  if(item){
   var args = new ASPxClientStateEventArgs(item, element);
   args.toElement = toElement;
   this.BeforeClearFocusedState.FireEvent(this, args);
   item.Cancel(element);
   this.AfterClearFocusedState.FireEvent(this, args);
  }
 },
 DoSetHoverState: function(element, fromElement){
  var item = element[ASPx.HoverItemKind];
  if(item){
   var args = new ASPxClientStateEventArgs(item, element);
   args.fromElement = fromElement;
   this.BeforeSetHoverState.FireEvent(this, args);
   item.Apply(element);
   this.AfterSetHoverState.FireEvent(this, args);
  }
 },
 DoClearHoverState: function(element, toElement){
  var item = element[ASPx.HoverItemKind];
  if(item){
   var args = new ASPxClientStateEventArgs(item, element);
   args.toElement = toElement;
   this.BeforeClearHoverState.FireEvent(this, args);
   item.Cancel(element);
   this.AfterClearHoverState.FireEvent(this, args);
  }
 },
 DoSetPressedState: function(element){
  var item = element[ASPx.PressedItemKind];
  if(item){
   var args = new ASPxClientStateEventArgs(item, element);
   this.BeforeSetPressedState.FireEvent(this, args);
   item.Apply(element);
   this.AfterSetPressedState.FireEvent(this, args);
  }
 },
 DoClearPressedState: function(element){
  var item = element[ASPx.PressedItemKind];
  if(item){
   var args = new ASPxClientStateEventArgs(item, element);
   this.BeforeClearPressedState.FireEvent(this, args);
   item.Cancel(element);
   this.AfterClearPressedState.FireEvent(this, args);
  }
 },
 SetCurrentFocusedElement: function(element){
  if(this.currentFocusedElement && !ASPx.IsValidElement(this.currentFocusedElement)){
   this.currentFocusedElement = null;
   this.currentFocusedItemName = "";
  }
  if(this.currentFocusedElement != element){
   var oldCurrentFocusedElement = this.currentFocusedElement;
   var item = (element != null) ? element[ASPx.FocusedItemKind] : null;
   var itemName = (item != null) ? item.name : "";
   if(this.currentFocusedItemName != itemName){
    if(this.currentHoverItemName != "")
     this.SetCurrentHoverElement(null);
    if(this.currentFocusedElement != null)
     this.DoClearFocusedState(this.currentFocusedElement, element);
    this.currentFocusedElement = element;
    item = (element != null) ? element[ASPx.FocusedItemKind] : null;
    this.currentFocusedItemName = (item != null) ? item.name : "";
    if(this.currentFocusedElement != null)
     this.DoSetFocusedState(this.currentFocusedElement, oldCurrentFocusedElement);
   }
  }
 },
 SetCurrentHoverElement: function(element){
  if(this.currentHoverElement && !ASPx.IsValidElement(this.currentHoverElement)){
   this.currentHoverElement = null;
   this.currentHoverItemName = "";
  }
  var item = (element != null) ? element[ASPx.HoverItemKind] : null;
  if(item && !item.enabled) { 
   element = this.GetItemElement(element.parentNode, this.hoverItems, ASPx.HoverItemKind);
   item = (element != null) ? element[ASPx.HoverItemKind] : null;
  }
  if(this.currentHoverElement != element){
   var oldCurrentHoverElement = this.currentHoverElement,
    itemName = (item != null) ? item.name : "";
   if(this.currentHoverItemName != itemName || (item != null && item.needRefreshBetweenElements)){
    if(this.currentHoverElement != null)
     this.DoClearHoverState(this.currentHoverElement, element);
    item = (element != null) ? element[ASPx.HoverItemKind] : null;
    if(item == null || item.enabled){
     this.currentHoverElement = element;
     this.currentHoverItemName = (item != null) ? item.name : "";
     if(this.currentHoverElement != null)
      this.DoSetHoverState(this.currentHoverElement, oldCurrentHoverElement);
    }
   }
  }
 },
 SetCurrentPressedElement: function(element){
  if(this.currentPressedElement && !ASPx.IsValidElement(this.currentPressedElement)){
   this.currentPressedElement = null;
   this.currentPressedItemName = "";
  }
  if(this.currentPressedElement != element){
   if(this.currentPressedElement != null)
    this.DoClearPressedState(this.currentPressedElement);
   var item = (element != null) ? element[ASPx.PressedItemKind] : null;
   if(item == null || item.enabled){
    this.currentPressedElement = element;
    this.currentPressedItemName = (item != null) ? item.name : "";
    if(this.currentPressedElement != null)
     this.DoSetPressedState(this.currentPressedElement);
   }
  }
 },
 SetCurrentFocusedElementBySrcElement: function(srcElement){
  var element = this.GetFocusedElement(srcElement);
  this.SetCurrentFocusedElement(element);
 },
 SetCurrentHoverElementBySrcElement: function(srcElement){
  var element = this.GetHoverElement(srcElement);
  this.SetCurrentHoverElement(element);
 },
 SetCurrentPressedElementBySrcElement: function(srcElement){
  var element = this.GetPressedElement(srcElement);
  this.SetCurrentPressedElement(element);
 },
 SetPressedElement: function (element) {
  this.SetCurrentHoverElement(null);
  this.SetCurrentPressedElementBySrcElement(element);
  this.savedCurrentPressedElement = this.currentPressedElement;
 },
 SelectElement: function (element) {
  var item = element[ASPx.SelectedItemKind];
  if(item)
   item.Apply(element);
 }, 
 SelectElementBySrcElement: function(srcElement){
  var element = this.GetSelectedElement(srcElement);
  if(element != null) this.SelectElement(element);
 }, 
 DeselectElement: function(element){
  var item = element[ASPx.SelectedItemKind];
  if(item)
   item.Cancel(element);
 }, 
 DeselectElementBySrcElement: function(srcElement){
  var element = this.GetSelectedElement(srcElement);
  if(element != null) this.DeselectElement(element);
 },
 SetElementEnabled: function(element, enable){
  if(enable)
   this.EnableElement(element);
  else
   this.DisableElement(element);
 },
 SetElementWithChildNodesEnabled: function (parentName, enabled) {
  var procFunct = (enabled ? this.EnableElement : this.DisableElement);
  var childItems = this.disabledScheme[parentName];
  if (childItems && childItems.length > 0)
   for (var i = 0; i < childItems.length; i++) {
    procFunct.call(this, document.getElementById(childItems[i]));
   }
 },
 DisableElement: function (element) {
  var element = this.GetDisabledElement(element);
  if(element != null) {
   var item = element[ASPx.DisabledItemKind];
   if(item){
    var args = new ASPxClientStateEventArgs(item, element);
    this.BeforeDisabled.FireEvent(this, args);
    if(item.name == this.currentPressedItemName)
     this.SetCurrentPressedElement(null);
    if(item.name == this.currentHoverItemName)
     this.SetCurrentHoverElement(null);
    item.Apply(element);
    this.SetMouseStateItemsEnabled(item.name, item.postfixes, false);
    this.AfterDisabled.FireEvent(this, args);
   }
  }
 }, 
 EnableElement: function(element){
  var element = this.GetDisabledElement(element);
  if(element != null) {
   var item = element[ASPx.DisabledItemKind];
   if(item){
    var args = new ASPxClientStateEventArgs(item, element);
    this.BeforeEnabled.FireEvent(this, args);
    item.Cancel(element);
    this.SetMouseStateItemsEnabled(item.name, item.postfixes, true);
    this.AfterEnabled.FireEvent(this, args);
   }
  }
 }, 
 SetMouseStateItemsEnabled: function(name, postfixes, enabled){   
  if(postfixes && postfixes.length > 0){
   for(var i = 0; i < postfixes.length; i ++){
    this.SetItemsEnabled(this.hoverItems, name + postfixes[i], enabled);
    this.SetItemsEnabled(this.pressedItems, name + postfixes[i], enabled);
    this.SetItemsEnabled(this.focusedItems, name + postfixes[i], enabled);
   }
  }
  else{
   this.SetItemsEnabled(this.hoverItems, name, enabled);
   this.SetItemsEnabled(this.pressedItems, name, enabled);
   this.SetItemsEnabled(this.focusedItems, name, enabled);
  }  
 },
 SetItemsEnabled: function(items, name, enabled){   
  if(items[name])
   items[name].enabled = enabled;
 },
 OnFocusMove: function(evt){
  var element = ASPx.Evt.GetEventSource(evt);
  aspxGetStateController().SetCurrentFocusedElementBySrcElement(element);
 },
 OnMouseMove: function(evt, checkElementChanged){
  var srcElement = ASPx.Evt.GetEventSource(evt);
  if(checkElementChanged && srcElement == this.savedCurrentMouseMoveSrcElement) return;
  this.savedCurrentMouseMoveSrcElement = srcElement;
  if(ASPx.Browser.IE && !ASPx.Evt.IsLeftButtonPressed(evt) && this.savedCurrentPressedElement != null)
   this.ClearSavedCurrentPressedElement();
  if(this.savedCurrentPressedElement == null)
   this.SetCurrentHoverElementBySrcElement(srcElement);
  else{
   var element = this.GetPressedElement(srcElement);
   if(element != this.currentPressedElement){
    if(element == this.savedCurrentPressedElement)
     this.SetCurrentPressedElement(this.savedCurrentPressedElement);
    else
     this.SetCurrentPressedElement(null);
   }
  }
 },
 OnMouseDown: function(evt){
  if(!ASPx.Evt.IsLeftButtonPressed(evt)) return;
  var srcElement = ASPx.Evt.GetEventSource(evt);
  this.OnMouseDownOnElement(srcElement);
 },
 OnMouseDownOnElement: function (element) {
  if(this.GetPressedElement(element) == null) return;
  this.SetPressedElement(element);
 },
 OnMouseUp: function(evt){
  var srcElement = ASPx.Evt.GetEventSource(evt);
  this.OnMouseUpOnElement(srcElement);
 },
 OnMouseUpOnElement: function(element){
  if(this.savedCurrentPressedElement == null) return;
  this.ClearSavedCurrentPressedElement();
  this.SetCurrentHoverElementBySrcElement(element);
 },
 OnMouseOver: function(evt){
  var element = ASPx.Evt.GetEventSource(evt);
  if(element && element.tagName == "IFRAME")
   this.OnMouseMove(evt, true);
 },
 OnKeyDown: function(evt){
  var element = this.GetFocusedElement(ASPx.Evt.GetEventSource(evt));
  if(element != null && element == this.currentFocusedElement) {
   var item = element[ASPx.FocusedItemKind];
   if(item){
    var args = new ASPxClientStateEventArgs(item, element);
    args.htmlEvent = evt;
    this.FocusedItemKeyDown.FireEvent(this, args);
   }
  }
 },
 OnKeyUpOnElement: function(evt) {
  if(this.savedCurrentPressedElement != null && ASPx.Evt.IsActionKeyPressed(evt))
   this.ClearSavedCurrentPressedElement();
 },
 OnSelectStart: function(evt){
  if(this.savedCurrentPressedElement) {
   ASPx.Selection.Clear();
   return false;
  }
 },
 ClearSavedCurrentPressedElement: function() {
  this.savedCurrentPressedElement = null;
  this.SetCurrentPressedElement(null);
 },
 ClearCache: function(srcElement, kind) {
  if(srcElement[ASPx.CachedStatePrefix + kind])
   srcElement[ASPx.CachedStatePrefix + kind] = null;
 },
 ClearElementCache: function(srcElement) {
  this.ClearCache(srcElement, ASPx.FocusedItemKind);
  this.ClearCache(srcElement, ASPx.HoverItemKind);
  this.ClearCache(srcElement, ASPx.PressedItemKind);
  this.ClearCache(srcElement, ASPx.SelectedItemKind);
  this.ClearCache(srcElement, ASPx.DisabledItemKind);
 },
 LockForceRedrawAppearance: function() {
  this.forceRedrawAppearanceLockCount++;
 },
 UnlockForceRedrawAppearance: function() {
  this.forceRedrawAppearanceLockCount--;
 },
 IsForceRedrawAppearanceLocked: function() {
  return this.forceRedrawAppearanceLockCount > 0;
 }
});
var stateController = null;
function aspxGetStateController(){
 if(stateController == null)
  stateController = new ASPxStateController();
 return stateController;
}
function aspxAddStateItems(method, namePrefix, classes, disableApplyingStyleToLink){
 for(var i = 0; i < classes.length; i ++){
  for(var j = 0; j < classes[i][2].length; j ++) {
   var name = namePrefix;
   if(classes[i][2][j])
    name += "_" + classes[i][2][j];
   var postfixes = classes[i][3] || null;
   var imageObjs = (classes[i][4] && classes[i][4][j]) || null;
   var imagePostfixes = classes[i][5] || null;
   method.call(aspxGetStateController(), name, classes[i][0], classes[i][1], postfixes, imageObjs, imagePostfixes, disableApplyingStyleToLink, namePrefix);
  }
 }
}
ASPx.AddHoverItems = function(namePrefix, classes, disableApplyingStyleToLink){
 aspxAddStateItems(aspxGetStateController().AddHoverItem, namePrefix, classes, disableApplyingStyleToLink);
};
ASPx.AddPressedItems = function(namePrefix, classes, disableApplyingStyleToLink){
 aspxAddStateItems(aspxGetStateController().AddPressedItem, namePrefix, classes, disableApplyingStyleToLink);
};
ASPx.AddSelectedItems = function(namePrefix, classes, disableApplyingStyleToLink){
 aspxAddStateItems(aspxGetStateController().AddSelectedItem, namePrefix, classes, disableApplyingStyleToLink);
};
ASPx.AddDisabledItems = function(namePrefix, classes, disableApplyingStyleToLink){
 aspxAddStateItems(aspxGetStateController().AddDisabledItem, namePrefix, classes, disableApplyingStyleToLink);
};
function aspxRemoveStateItems(method, namePrefix, classes){
 for(var i = 0; i < classes.length; i ++){
  for(var j = 0; j < classes[i][0].length; j ++) {
   var name = namePrefix;
   if(classes[i][0][j])
    name += "_" + classes[i][0][j];
   method.call(aspxGetStateController(), name, classes[i][1], namePrefix);
  }
 }
}
ASPx.RemoveHoverItems = function(namePrefix, classes){
 aspxRemoveStateItems(aspxGetStateController().RemoveHoverItem, namePrefix, classes);
};
ASPx.RemovePressedItems = function(namePrefix, classes){
 aspxRemoveStateItems(aspxGetStateController().RemovePressedItem, namePrefix, classes);
};
ASPx.RemoveSelectedItems = function(namePrefix, classes){
 aspxRemoveStateItems(aspxGetStateController().RemoveSelectedItem, namePrefix, classes);
};
ASPx.RemoveDisabledItems = function(namePrefix, classes){
 aspxRemoveStateItems(aspxGetStateController().RemoveDisabledItem, namePrefix, classes);
};
ASPx.AddAfterClearFocusedState = function(handler){
 aspxGetStateController().AfterClearFocusedState.AddHandler(handler);
};
ASPx.AddAfterSetFocusedState = function(handler){
 aspxGetStateController().AfterSetFocusedState.AddHandler(handler);
};
ASPx.AddAfterClearHoverState = function(handler){
 aspxGetStateController().AfterClearHoverState.AddHandler(handler);
};
ASPx.AddAfterSetHoverState = function(handler){
 aspxGetStateController().AfterSetHoverState.AddHandler(handler);
};
ASPx.AddAfterClearPressedState = function(handler){
 aspxGetStateController().AfterClearPressedState.AddHandler(handler);
};
ASPx.AddAfterSetPressedState = function(handler){
 aspxGetStateController().AfterSetPressedState.AddHandler(handler);
};
ASPx.AddAfterDisabled = function(handler){
 aspxGetStateController().AfterDisabled.AddHandler(handler);
};
ASPx.AddAfterEnabled = function(handler){
 aspxGetStateController().AfterEnabled.AddHandler(handler);
};
ASPx.AddBeforeClearFocusedState = function(handler){
 aspxGetStateController().BeforeClearFocusedState.AddHandler(handler);
};
ASPx.AddBeforeSetFocusedState = function(handler){
 aspxGetStateController().BeforeSetFocusedState.AddHandler(handler);
};
ASPx.AddBeforeClearHoverState = function(handler){
 aspxGetStateController().BeforeClearHoverState.AddHandler(handler);
};
ASPx.AddBeforeSetHoverState = function(handler){
 aspxGetStateController().BeforeSetHoverState.AddHandler(handler);
};
ASPx.AddBeforeClearPressedState = function(handler){
 aspxGetStateController().BeforeClearPressedState.AddHandler(handler);
};
ASPx.AddBeforeSetPressedState = function(handler){
 aspxGetStateController().BeforeSetPressedState.AddHandler(handler);
};
ASPx.AddBeforeDisabled = function(handler){
 aspxGetStateController().BeforeDisabled.AddHandler(handler);
};
ASPx.AddBeforeEnabled = function(handler){
 aspxGetStateController().BeforeEnabled.AddHandler(handler);
};
ASPx.AddFocusedItemKeyDown = function(handler){
 aspxGetStateController().FocusedItemKeyDown.AddHandler(handler);
};
ASPx.SetHoverState = function(element){
 aspxGetStateController().SetCurrentHoverElementBySrcElement(element);
};
ASPx.ClearHoverState = function(evt){
 aspxGetStateController().SetCurrentHoverElementBySrcElement(null);
};
ASPx.UpdateHoverState = function(evt){
 aspxGetStateController().OnMouseMove(evt, false);
};
ASPx.SetFocusedState = function(element){
 aspxGetStateController().SetCurrentFocusedElementBySrcElement(element);
};
ASPx.ClearFocusedState = function(evt){
 aspxGetStateController().SetCurrentFocusedElementBySrcElement(null);
};
ASPx.UpdateFocusedState = function(evt){
 aspxGetStateController().OnFocusMove(evt);
};
ASPx.AccessibilityMarkerClass = "dxalink";
ASPx.AssignAccessibilityEventsToChildrenLinks = function(container, clearFocusedStateOnMouseOut){
 var links = ASPx.GetNodesByPartialClassName(container, ASPx.AccessibilityMarkerClass);
 for(var i = 0; i < links.length; i++)
  ASPx.AssignAccessibilityEventsToLink(links[i], clearFocusedStateOnMouseOut);
};
ASPx.AssignAccessibilityEventsToLink = function(link, clearFocusedStateOnMouseOut) {
 if(!ASPx.ElementContainsCssClass(link, ASPx.AccessibilityMarkerClass))
  return;
 ASPx.AssignAccessibilityEventsToLinkCore(link, clearFocusedStateOnMouseOut);
};
ASPx.AssignAccessibilityEventsToLinkCore = function (link, clearFocusedStateOnMouseOut) {
 ASPx.Evt.AttachEventToElement(link, "focus", function (e) { ASPx.UpdateFocusedState(e); });
 var clearFocusedStateHandler = function (e) { ASPx.ClearFocusedState(e); };
 ASPx.Evt.AttachEventToElement(link, "blur", clearFocusedStateHandler);
 if(clearFocusedStateOnMouseOut)
  ASPx.Evt.AttachEventToElement(link, "mouseout", clearFocusedStateHandler);
};
ASPx.Evt.AttachEventToDocument("mousemove", function(evt) {
 if(ASPx.classesScriptParsed && ASPx.StateItemsExist)
  aspxGetStateController().OnMouseMove(evt, true);
});
ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseDownEventName, function(evt) {
 if(ASPx.classesScriptParsed && ASPx.StateItemsExist)
  aspxGetStateController().OnMouseDown(evt);
});
ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseUpEventName, function(evt) {
 if(ASPx.classesScriptParsed && ASPx.StateItemsExist)
  aspxGetStateController().OnMouseUp(evt);
});
ASPx.Evt.AttachEventToDocument("mouseover", function(evt) {
 if(ASPx.classesScriptParsed && ASPx.StateItemsExist)
  aspxGetStateController().OnMouseOver(evt);
});
ASPx.Evt.AttachEventToDocument("keydown", function(evt) {
 if(ASPx.classesScriptParsed && ASPx.StateItemsExist)
  aspxGetStateController().OnKeyDown(evt);
});
ASPx.Evt.AttachEventToDocument("selectstart", function(evt) {
 if(ASPx.classesScriptParsed && ASPx.StateItemsExist)
  return aspxGetStateController().OnSelectStart(evt);
});
ASPx.GetStateController = aspxGetStateController;
})();
(function () {
 var ASPx = window.ASPx || {};
 ASPx.ASPxImageLoad = {};
 ASPx.ASPxImageLoad.dxDefaultLoadingImageCssClass = "dxe-loadingImage";
 ASPx.ASPxImageLoad.dxDefaultLoadingImageCssClassRegexp = new RegExp("dx\\w+-loadingImage");
 ASPx.ASPxImageLoad.OnLoad = function (image, customLoadingImage, isOldIE, customBackgroundImageUrl) {
  image.dxCustomBackgroundImageUrl = "";
  image.dxShowLoadingImage = true;
  image.dxCustomLoadingImage = customLoadingImage;
  if (customBackgroundImageUrl != "")
   image.dxCustomBackgroundImageUrl = "url('" + customBackgroundImageUrl + "')";
  ASPx.ASPxImageLoad.prepareImageBackground(image, isOldIE);
  ASPx.ASPxImageLoad.removeHandlers(image);
  image.className = image.className.replace(ASPx.ASPxImageLoad.dxDefaultLoadingImageCssClassRegexp, "");
 };
 ASPx.ASPxImageLoad.removeASPxImageBackground = function (image, isOldIE) {
  if (isOldIE) 
   image.style.removeAttribute("background-image");
  else 
   image.style.backgroundImage = "";
 };
 ASPx.ASPxImageLoad.prepareImageBackground = function (image, isOldIE) {
  ASPx.ASPxImageLoad.removeASPxImageBackground(image, isOldIE);
  if (image.dxCustomBackgroundImageUrl != "")
   image.style.backgroundImage = image.dxCustomBackgroundImageUrl;
 };
 ASPx.ASPxImageLoad.removeHandlers = function (image) {
  image.removeAttribute("onload");
  image.removeAttribute("onabort");
  image.removeAttribute("onerror");
 };
 window.ASPx = ASPx;
})();
(function() {
var CheckingScriptObjectCommand = ASPx.CreateClass(null, {
 constructor: function(scriptName, markerObjectName) {
  this.scriptName = scriptName;
  this.markerObjectName = markerObjectName;
  this.isExisted = false;
 },
 Run: function() {
  var markerObj = this.GetMarkerObject();
  this.isExisted = !!markerObj;
  if(this.isExisted)
   markerObj.DXPatched = true;
 },
 GetErrorMessage: function() {
  return this.GetErrorMessageCore(true);
 },
 GetErrorMessageCore: function(isScriptRequired){
  var markerObj = this.GetMarkerObject();
  if(this.isExisted && markerObj && markerObj.DXPatched || !isScriptRequired && !markerObj)
   return null;
  if(isScriptRequired && !this.GetMarkerObject()){
   if(this.isExisted)
    return this.scriptName + " script was attached but has been overridden.";
   else
    return this.scriptName + " script was not attached.";
  }
  if(!this.isExisted)
   return this.scriptName + " script was attached after DevExpress scripts.";
  return this.scriptName + " script was attached multiple times and mixed up with DevExpress scripts.";
 },
 GetMarkerObject: function() {
  return ASPx.GetGlobalObject(this.markerObjectName);
 }
});
var PatchScriptCommand = ASPx.CreateClass(CheckingScriptObjectCommand, {
 constructor: function(scriptName, markerObjectName, patchMethod, required) {
  this.constructor.prototype.constructor.call(this, scriptName, markerObjectName);
  this.required = required;
  this.patchMethod = patchMethod;
 },
 Run: function() {
  CheckingScriptObjectCommand.prototype.Run.call(this);
  if(this.isExisted)
   this.patchMethod();
 },
 GetErrorMessage: function() {  
  return this.GetErrorMessageCore(this.required);
 }
});
var ExternalScriptProcessor = ASPx.CreateClass(null, {
 constructor: function() {
  this.commands = {};
 },
 Process: function(scriptName, markerObjectName, patchMethod, required) {
  var newCommand = this.CreateCommand(scriptName, markerObjectName, patchMethod, !!required);
  var oldCommand = this.commands[markerObjectName];
  if(oldCommand) {
   if(!oldCommand.patchMethod && !newCommand.patchMethod)
    newCommand = null;
   else if(newCommand.patchMethod && (!oldCommand.patchMethod || oldCommand.required))
    newCommand.required = true;
   else if(oldCommand.patchMethod && !newCommand.patchMethod) {
    oldCommand.required = true;
    newCommand = null;
   }
  }
  if(newCommand) {
   this.commands[markerObjectName] = newCommand;
   newCommand.Run();
  }
 },
 CreateCommand: function(scriptName, markerObjectName, patchMethod, required) {
  if(patchMethod)
   return new PatchScriptCommand(scriptName, markerObjectName, patchMethod, required);
  return new CheckingScriptObjectCommand(scriptName, markerObjectName);
 },
 ShowErrorMessages: function() {
  var messages = this.GetErrorMessages();
  var console = window.console;
  if(!messages.length || !console || !ASPx.IsFunction(console.error))
   return;
  for(var i = 0; i < messages.length; i++) {
   console.error(messages[i]);
  }
  ASPx.ShowKBErrorMessage("Please check the correctness of script registration on the page. For details, see ", "T272309");
 },
 GetErrorMessages: function() {
  var messages = [];
  for (var key in this.commands) {
   if (this.commands.hasOwnProperty(key)) {
    var message = this.commands[key].GetErrorMessage();
    if (message)
     messages.push(message);
   }
  }
  return messages;
 }
});
ExternalScriptProcessor.Instance = null;
ExternalScriptProcessor.getInstance = function() {
 if(!ExternalScriptProcessor.Instance)
  ExternalScriptProcessor.Instance = new ExternalScriptProcessor();
 return ExternalScriptProcessor.Instance;
};
ASPx.ExternalScriptProcessor = ExternalScriptProcessor;
})();
(function () {
var ASPxClientBeginCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(command){
  this.constructor.prototype.constructor.call(this);
  this.command = command;
 }
});
var ASPxClientGlobalBeginCallbackEventArgs = ASPx.CreateClass(ASPxClientBeginCallbackEventArgs, {
 constructor: function(control, command){
  this.constructor.prototype.constructor.call(this, command);
  this.control = control;
 }
});
var ASPxClientEndCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(){
  this.constructor.prototype.constructor.call(this);
 }
});
var ASPxClientGlobalEndCallbackEventArgs = ASPx.CreateClass(ASPxClientEndCallbackEventArgs, {
 constructor: function(control){
  this.constructor.prototype.constructor.call(this);
  this.control = control;
 }
});
var ASPxClientCustomDataCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(result) {
  this.constructor.prototype.constructor.call(this);
  this.result = result;
 }
});
var ASPxClientCallbackErrorEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function (message, callbackId) {
  this.constructor.prototype.constructor.call(this);
  this.message = message;
  this.handled = false;
  this.callbackId = callbackId;
 }
});
var ASPxClientGlobalCallbackErrorEventArgs = ASPx.CreateClass(ASPxClientCallbackErrorEventArgs, {
 constructor: function (control, message, callbackId) {
  this.constructor.prototype.constructor.call(this, message, callbackId);
  this.control = control;
 }
});
var ASPxClientValidationCompletedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function (container, validationGroup, invisibleControlsValidated, isValid, firstInvalidControl, firstVisibleInvalidControl) {
  this.constructor.prototype.constructor.call(this);
  this.container = container;
  this.validationGroup = validationGroup;
  this.invisibleControlsValidated = invisibleControlsValidated;
  this.isValid = isValid;
  this.firstInvalidControl = firstInvalidControl;
  this.firstVisibleInvalidControl = firstVisibleInvalidControl;
 }
});
var ASPxClientControlsInitializedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(isCallback) {
  this.isCallback = isCallback;
 }
});
var ASPxClientControlBeforePronounceEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(messageParts, control){
  this.constructor.prototype.constructor.call(this);
  this.messageParts = messageParts;
  this.control = control;
 }
});
var ASPxClientControlUnloadEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(control){
  this.constructor.prototype.constructor.call(this);
  this.control = control;
 }
});
var BeforeInitCallbackEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(callbackOwnerID){
  this.constructor.prototype.constructor.call(this);
  this.callbackOwnerID = callbackOwnerID;
 }
});
ASPx.createControl = function(type, name, windowName, properties, events, setupMethod, data){
 var dxo = new type(name);
 dxo.InitGlobalVariable(windowName && windowName.length > 0 ? windowName : name);
 if(properties)
  dxo.SetProperties(properties);
 if(events)
  dxo.SetEvents(events);
 if(setupMethod)
  setupMethod.call(dxo);
 if(data)
  dxo.SetData(data);
 dxo.AfterCreate();
};
var ASPxClientControlBase = ASPx.CreateClass(null, {
 constructor: function(name){
  this.name = name;
  this.uniqueID = name;   
  this.globalName = name;
  this.stateObject = null;
  this.encodeHtml = true;
  this.enabled = true;
  this.clientEnabled = true;
  this.savedClientEnabled = true;
  this.clientVisible = true;
  this.accessibilityCompliant = false;
  this.autoPostBack = false;
  this.allowMultipleCallbacks = true;
  this.callBack = null;
  this.enableCallbackAnimation = false;
  this.enableSlideCallbackAnimation = false;
  this.slideAnimationDirection = null;
  this.beginCallbackAnimationProcessing = false;
  this.endCallbackAnimationProcessing = false;
  this.savedCallbackResult = null;
  this.savedCallbacks = null;
  this.isCallbackAnimationPrevented = false;
  this.lpDelay = 300;
  this.lpTimer = -1;
  this.requestCount = 0;
  this.enableSwipeGestures = false;
  this.disableSwipeGestures = false;
  this.supportGestures = false;
  this.repeatedGestureValue = 0;
  this.repeatedGestureCount = 0;
  this.isInitialized = false;
  this.initialFocused = false;
  this.leadingAfterInitCall = ASPxClientControl.LeadingAfterInitCallConsts.None; 
  this.serverEvents = [];
  this.loadingPanelElement = null;
  this.loadingDivElement = null;  
  this.hasPhantomLoadingElements = false;
  this.mainElement = null;
  this.touchUIMouseScroller = null;
  this.hiddenFields = { };
  this.callbackHandlersQueue = new ASPx.ControlCallbackHandlersQueue(this);
  this.Init = new ASPxClientEvent();
  this.BeginCallback = new ASPxClientEvent();
  this.EndCallback = new ASPxClientEvent();
  this.EndCallbackAnimationStart = new ASPxClientEvent();
  this.CallbackError = new ASPxClientEvent();
  this.CustomDataCallback = new ASPxClientEvent();
  this.BeforePronounce = new ASPxClientEvent();
  this.Unload = new ASPxClientEvent();
  aspxGetControlCollection().Add(this);
 },
 Initialize: function() {
  if(this.callBack != null)
   this.InitializeCallBackData();
  if (this.useCallbackQueue())
   this.callbackQueueHelper = new ASPx.ControlCallbackQueueHelper(this);
  ASPx.AccessibilityUtils.createAccessibleBackgrounds(this);
  if(this.accessibilityCompliant)
   ASPx.AccessibilityPronouncer.EnsureInitialize();
 },
 InlineInitialize: function() {
  this.savedClientEnabled = this.clientEnabled;
 },
 InitializeGestures: function() {
  if(this.isSwipeGesturesEnabled() && this.supportGestures) {
   ASPx.GesturesHelper.AddSwipeGestureHandler(this.name, 
    function() { return this.GetCallbackAnimationElement(); }.aspxBind(this), 
    function(evt) { return this.CanHandleGestureCore(evt); }.aspxBind(this), 
    function(value) { return this.AllowStartGesture(); }.aspxBind(this),
    function(value) { return this.StartGesture(); }.aspxBind(this),
    function(value) { return this.AllowExecuteGesture(value); }.aspxBind(this),
    function(value) { this.ExecuteGesture(value); }.aspxBind(this),
    function(value) { this.CancelGesture(value); }.aspxBind(this),
    this.GetDefaultanimationEngineType()
   );
   if(ASPx.Browser.MSTouchUI)
    this.touchUIMouseScroller = ASPx.MouseScroller.Create(
     function() { return this.GetCallbackAnimationElement(); }.aspxBind(this),
     function() { return null; },
     function() { return this.GetCallbackAnimationElement(); }.aspxBind(this),
     function(element) { return this.NeedPreventTouchUIMouseScrolling(element); }.aspxBind(this),
     true
    );
  }
 },
 isSwipeGesturesEnabled: function() {
  return !this.disableSwipeGestures && (this.enableSwipeGestures || ASPx.Browser.TouchUI);
 },
 isSlideCallbackAnimationEnabled: function() {
  return this.enableSlideCallbackAnimation || this.isSwipeGesturesEnabled(); 
 },
 InitGlobalVariable: function(varName){
  if(!window) return;
  this.globalName = varName;
  window[varName] = this;
 },
 SetProperties: function(properties, obj){
  if(!obj) obj = this;
  for(var name in properties){
   if(properties.hasOwnProperty(name))
    obj[name] = properties[name];
  }
 },
 SetEvents: function(events, obj){
  if(!obj) obj = this;
  for(var name in events){
   if(events.hasOwnProperty(name) && obj[name] && obj[name].AddHandler)
    obj[name].AddHandler(events[name]);
  }
 },
 SetData: function(data){
 },
 useCallbackQueue: function(){
  return false;
 },
 NeedPreventTouchUIMouseScrolling: function(element) {
  return false;
 },
 InitailizeFocus: function() {
  if(this.initialFocused && this.IsVisible())
   this.Focus();
 },
 AfterCreate: function() { 
  this.InlineInitialize();
  this.InitializeGestures();
 },
 AfterInitialize: function() {
  this.initializeAriaDescriptor();
  this.InitailizeFocus();
  this.isInitialized = true;
  this.RaiseInit();
  if(this.savedCallbacks) {
   for(var i = 0; i < this.savedCallbacks.length; i++) 
    this.CreateCallbackInternal(this.savedCallbacks[i].arg, this.savedCallbacks[i].command, 
     false, this.savedCallbacks[i].callbackInfo);
   this.savedCallbacks = null;
  }
 },
 InitializeCallBackData: function() {
 },
 IsDOMDisposed: function() { 
  return !ASPx.IsExistsElement(this.GetMainElement());
 },
 initializeAriaDescriptor: function() {
  if(this.ariaDescription) {
   var descriptionObject = ASPx.Json.Eval(this.ariaDescription);
   if(descriptionObject) {
    this.ariaDescriptor = new AriaDescriptor(this, descriptionObject);
    this.applyAccessibilityAttributes(this.ariaDescriptor); 
   }
  }
 },
 applyAccessibilityAttributes: function() { },
 setAriaDescription: function(selector, argsList) {
  if(this.ariaDescriptor)
   this.ariaDescriptor.setDescription(selector, argsList || [[]]);
 },
 allowRestoreFocusOnCallbacks: function(){
  return this.accessibilityCompliant;
 },
 HtmlEncode: function(text) {
  return this.encodeHtml ? ASPx.Str.EncodeHtml(text) : text;
 },
 IsServerEventAssigned: function(eventName){
  return ASPx.Data.ArrayIndexOf(this.serverEvents, eventName) >= 0;
 },
 OnPost: function(args){
  this.UpdateStateObject();
  if(this.stateObject != null) 
   this.UpdateStateHiddenField();
 },
 OnPostFinalization: function(args){
 },
 UpdateStateObject: function(){
 },
 UpdateStateObjectWithObject: function(obj){
  if(!obj) return;
  if(!this.stateObject)
   this.stateObject = { };
  for(var key in obj)
   if(obj.hasOwnProperty(key))
    this.stateObject[key] = obj[key];
 },
 UpdateStateHiddenField: function(){
  var stateHiddenField = this.GetStateHiddenField();
  if(stateHiddenField) {
   var stateObjectStr = ASPx.Json.ToJson(this.stateObject);
   stateHiddenField.value = ASPx.Str.EncodeHtml(stateObjectStr);
  }
 },
 GetStateHiddenField: function() {
  return this.GetHiddenField(this.GetStateHiddenFieldName(), this.GetStateHiddenFieldID(), 
   this.GetStateHiddenFieldParent(), this.GetStateHiddenFieldOrigin());
 },
 GetStateHiddenFieldName: function() {
  return this.uniqueID;
 },
 GetStateHiddenFieldID: function() {
  return this.name + "_State";
 },
 GetStateHiddenFieldOrigin: function() {
  return this.GetMainElement();
 },
 GetStateHiddenFieldParent: function() {
  var element = this.GetStateHiddenFieldOrigin();
  return element ? element.parentNode : null;
 },
 GetHiddenField: function(name, id, parent, beforeElement) {
  var hiddenField = this.hiddenFields[id];
  if(!hiddenField || !ASPx.IsValidElement(hiddenField)) {
   if(parent) {
    var existingHiddenField = ASPx.GetElementById(this.GetStateHiddenFieldID());
    this.hiddenFields[id] = hiddenField = existingHiddenField || ASPx.CreateHiddenField(name, id);
    if(existingHiddenField)
     return existingHiddenField;
    if(beforeElement)
     parent.insertBefore(hiddenField, beforeElement);
    else
     parent.appendChild(hiddenField);
   }
  }
  return hiddenField;
 },
 GetChildElement: function(idPostfix){
  var mainElement = this.GetMainElement();
  if(idPostfix.charAt && idPostfix.charAt(0) !== "_")
   idPostfix = "_" + idPostfix;
  return mainElement ? ASPx.CacheHelper.GetCachedChildById(this, mainElement, this.name + idPostfix) : null;
 },
 getChildControl: function(idPostfix) {
  var result = null;
  var childControlId = this.getChildControlUniqueID(idPostfix);
  ASPx.GetControlCollection().ProcessControlsInContainer(this.GetMainElement(), function(control) {
   if(control.uniqueID == childControlId)
    result = control;
  });
  return result;  
 },
 getChildControlUniqueID: function(idPostfix) {
  idPostfix = idPostfix.split("_").join("$");
  if(idPostfix.charAt && idPostfix.charAt(0) !== "$")
   idPostfix = "$" + idPostfix;
  return this.uniqueID + idPostfix;  
 },
 getInnerControl: function(idPostfix) {
  var name = this.name + idPostfix;
  var result = window[name];
  return result && Ident.IsASPxClientControl(result)
   ? result
   : null;
 },
 GetParentForm: function(){
  return ASPx.GetParentByTagName(this.GetMainElement(), "FORM");
 },
 GetMainElement: function(){
  if(!ASPx.IsExistsElement(this.mainElement))
   this.mainElement = ASPx.GetElementById(this.GetMainElementId());
  return this.mainElement;
 },
 GetMainElementId: function() {
  return this.name;
 },
 IsLoadingContainerVisible: function(){
  return this.IsVisible();
 },
 GetLoadingPanelElement: function(){
  return ASPx.GetElementById(this.name + "_LP");
 },
 GetClonedLoadingPanel: function(){
  return document.getElementById(this.GetLoadingPanelElement().id + "V"); 
 },
 CloneLoadingPanel: function(element, parent) {
  var clone = element.cloneNode(true);
  clone.id = element.id + "V";
  parent.appendChild(clone);
  return clone;
 },
 CreateLoadingPanelWithoutBordersInsideContainer: function(container) {
  var loadingPanel = this.CreateLoadingPanelInsideContainer(container, false, true, true);
  var contentStyle = ASPx.GetCurrentStyle(container);
  if(!loadingPanel || !contentStyle)
   return;
  var elements = [ ];
  var table = (loadingPanel.tagName == "TABLE") ? loadingPanel : ASPx.GetNodeByTagName(loadingPanel, "TABLE", 0);
  if(table != null)
   elements.push(table);
  else
   elements.push(loadingPanel);
  var cells = ASPx.GetNodesByTagName(loadingPanel, "TD");
  if(!cells) cells = [ ];
  for(var i = 0; i < cells.length; i++)
   elements.push(cells[i]);
  for(var i = 0; i < elements.length; i++) {
   var el = elements[i];
   el.style.backgroundColor = contentStyle.backgroundColor;
   ASPx.RemoveBordersAndShadows(el);
  }
 },
 CreateLoadingPanelInsideContainer: function(parentElement, hideContent, collapseHeight, collapseWidth) {
  if(this.ShouldHideExistingLoadingElements())
   this.HideLoadingPanel();
  if(parentElement == null)
   return null;
  if(!this.IsLoadingContainerVisible()) {
   this.hasPhantomLoadingElements = true;
   return null;
  }
  var element = this.GetLoadingPanelElement();
  if(element != null){
   var width = collapseWidth ? 0 : ASPx.GetClearClientWidth(parentElement);
   var height = collapseHeight ? 0 : ASPx.GetClearClientHeight(parentElement);
   if(hideContent){
    for(var i = parentElement.childNodes.length - 1; i > -1; i--){
     if(parentElement.childNodes[i].style)
      parentElement.childNodes[i].style.display = "none";
     else if(parentElement.childNodes[i].nodeType == 3) 
      parentElement.removeChild(parentElement.childNodes[i]);
    }
   }
   else
    parentElement.innerHTML = "";
   var table = document.createElement("TABLE");
   parentElement.appendChild(table);
   table.border = 0;
   table.cellPadding = 0;
   table.cellSpacing = 0;
   ASPx.SetStyles(table, {
    width: (width > 0) ? width : "100%",
    height: (height > 0) ? height : "100%"
   });
   var tbody = document.createElement("TBODY");
   table.appendChild(tbody);
   var tr = document.createElement("TR");
   tbody.appendChild(tr);
   var td = document.createElement("TD");
   tr.appendChild(td);
   td.align = "center";
   td.vAlign = "middle";
   element = this.CloneLoadingPanel(element, td);
   ASPx.SetElementDisplay(element, true, true);
   this.loadingPanelElement = element;
   return element;
  } else
   parentElement.innerHTML = "&nbsp;";
  return null;
 },
 CreateLoadingPanelWithAbsolutePosition: function(parentElement, offsetElement) {
  if(this.ShouldHideExistingLoadingElements())
   this.HideLoadingPanel();
  if(parentElement == null)
   return null;
  if(!this.IsLoadingContainerVisible()) {
   this.hasPhantomLoadingElements = true;
   return null;
  }
  if(!offsetElement)
   offsetElement = parentElement;
  var element = this.GetLoadingPanelElement();
  if(element != null) {
   element = this.CloneLoadingPanel(element, parentElement);
   ASPx.SetStyles(element, {
    position: "absolute"
   });
   ASPx.SetElementDisplay(element, true, true);
   ASPx.Evt.AttachEventToElement(element, ASPx.Evt.GetMouseWheelEventName(), ASPx.Evt.PreventEvent);
   this.SetLoadingPanelLocation(offsetElement, element);
   this.loadingPanelElement = element;
   return element;
  }
  return null;
 },
 CreateLoadingPanelInline: function(parentElement, centerInParent){
  if(this.ShouldHideExistingLoadingElements())
   this.HideLoadingPanel();
  if(parentElement == null)
   return null;
  if(!this.IsLoadingContainerVisible()) {
   this.hasPhantomLoadingElements = true;
   return null;
  }
  var element = this.GetLoadingPanelElement();
  if(element != null) {
   element = this.CloneLoadingPanel(element, parentElement);
   if(centerInParent){
    ASPx.SetElementDisplay(element, true, true, true);
    parentElement.style.textAlign = "center";
   }
   else
    ASPx.SetElementDisplay(element, true, true);
   this.loadingPanelElement = element;
   return element;
  }
  return null;
 },
 ShowLoadingPanel: function() {
 },
 ShowLoadingElements: function() {
  if(this.InCallback() || this.lpTimer > -1) return;
  this.ShowLoadingDiv();
  if(this.IsCallbackAnimationEnabled())
   this.StartBeginCallbackAnimation();
  else
   this.ShowLoadingElementsInternal();
 },
 ShowLoadingElementsInternal: function() {
  if(this.lpDelay > 0 && !this.IsCallbackAnimationEnabled()) 
   this.lpTimer = window.setTimeout(function() { 
    this.ShowLoadingPanelOnTimer(); 
   }.aspxBind(this), this.lpDelay);
  else {
   this.RestoreLoadingDivOpacity();
   this.ShowLoadingPanel();
  }
 },
 GetLoadingPanelOffsetElement: function (baseElement) {
  if(this.IsCallbackAnimationEnabled()) {
   var element = this.GetLoadingPanelCallbackAnimationOffsetElement();
   if(element) {
    var container = typeof(ASPx.AnimationHelper) != "undefined" ? ASPx.AnimationHelper.findSlideAnimationContainer(element) : null;
    if(container)
     return container.parentNode.parentNode;
    else
     return element;
   }
  }
  return baseElement;
 },
 GetLoadingPanelCallbackAnimationOffsetElement: function () {
  return this.GetCallbackAnimationElement();
 },
 IsCallbackAnimationEnabled: function () {
  return (this.enableCallbackAnimation || this.isSlideCallbackAnimationEnabled()) && !this.isCallbackAnimationPrevented;
 },
 GetDefaultanimationEngineType: function() {
  return ASPx.AnimationEngineType.DEFAULT;
 },
 StartBeginCallbackAnimation: function () {
  this.beginCallbackAnimationProcessing = true;
  this.isCallbackFinished = false;
  var element = this.GetCallbackAnimationElement();
  if(element && this.isSlideCallbackAnimationEnabled() && this.slideAnimationDirection) 
   ASPx.AnimationHelper.slideOut(element, this.slideAnimationDirection, this.FinishBeginCallbackAnimation.aspxBind(this), this.GetDefaultanimationEngineType());
  else if(element && this.enableCallbackAnimation) 
   ASPx.AnimationHelper.fadeOut(element, this.FinishBeginCallbackAnimation.aspxBind(this));
  else
   this.FinishBeginCallbackAnimation();
 },
 CancelBeginCallbackAnimation: function() {
  if(this.beginCallbackAnimationProcessing) {
   this.beginCallbackAnimationProcessing = false;
   var element = this.GetCallbackAnimationElement();
   ASPx.AnimationHelper.cancelAnimation(element);
  }
 },
 FinishBeginCallbackAnimation: function () {
  this.beginCallbackAnimationProcessing = false;
  if(!this.isCallbackFinished)
   this.ShowLoadingElementsInternal();
  else {
   this.DoCallback(this.savedCallbackResult);
   this.savedCallbackResult = null;
  }
 },
 CheckBeginCallbackAnimationInProgress: function(callbackResult) {
  if(this.beginCallbackAnimationProcessing) {
   this.savedCallbackResult = callbackResult;
   this.isCallbackFinished = true;
   return true;
  }
  return false;
 },
 StartEndCallbackAnimation: function () {
  this.HideLoadingPanel();
  this.SetInitialLoadingDivOpacity();
  this.RaiseEndCallbackAnimationStart();
  this.endCallbackAnimationProcessing = true;
  var element = this.GetCallbackAnimationElement();
  if(element && this.isSlideCallbackAnimationEnabled() && this.slideAnimationDirection) 
   ASPx.AnimationHelper.slideIn(element, this.slideAnimationDirection, this.FinishEndCallbackAnimation.aspxBind(this), this.GetDefaultanimationEngineType());
  else if(element && this.enableCallbackAnimation) 
   ASPx.AnimationHelper.fadeIn(element, this.FinishEndCallbackAnimation.aspxBind(this));
  else
   this.FinishEndCallbackAnimation();
  this.slideAnimationDirection = null;
 },
 FinishEndCallbackAnimation: function () {
  this.DoEndCallback();
  this.endCallbackAnimationProcessing = false;
  this.CheckRepeatGesture();
 },
 CheckEndCallbackAnimationNeeded: function() {
  if(!this.endCallbackAnimationProcessing && this.requestCount == 1) {
   this.StartEndCallbackAnimation();
   return true;
  }
  return false;
 },
 PreventCallbackAnimation: function() {
  this.isCallbackAnimationPrevented = true;
 },
 GetCallbackAnimationElement: function() {
  return null;
 },
 AssignSlideAnimationDirectionByPagerArgument: function(arg, currentPageIndex) {
  this.slideAnimationDirection = null;
  if(this.isSlideCallbackAnimationEnabled() && typeof(ASPx.AnimationHelper) != "undefined") {
   if(arg == PagerCommands.Next || arg == PagerCommands.Last)
    this.slideAnimationDirection = ASPx.AnimationHelper.SLIDE_LEFT_DIRECTION;
   else if(arg == PagerCommands.First || arg == PagerCommands.Prev)
    this.slideAnimationDirection = ASPx.AnimationHelper.SLIDE_RIGHT_DIRECTION;
   else if(!isNaN(currentPageIndex) && arg.indexOf(PagerCommands.PageNumber) == 0) {
    var newPageIndex = parseInt(arg.substring(2));
    if(!isNaN(newPageIndex))
     this.slideAnimationDirection = newPageIndex < currentPageIndex ? ASPx.AnimationHelper.SLIDE_RIGHT_DIRECTION : ASPx.AnimationHelper.SLIDE_LEFT_DIRECTION;
   }
  }
 },
 TryShowPhantomLoadingElements: function () {
  if(this.hasPhantomLoadingElements && this.InCallback()) {
   this.hasPhantomLoadingElements = false;
   this.ShowLoadingDivAndPanel();
  }
 },
 ShowLoadingDivAndPanel: function () {
  this.ShowLoadingDiv();
  this.RestoreLoadingDivOpacity();
  this.ShowLoadingPanel();
 },
 HideLoadingElements: function() {
  this.CancelBeginCallbackAnimation();
  this.HideLoadingPanel();
  this.HideLoadingDiv();
 },
 ShowLoadingPanelOnTimer: function() {
  this.ClearLoadingPanelTimer();
  if(!this.IsDOMDisposed()) {
   this.RestoreLoadingDivOpacity();
   this.ShowLoadingPanel();
  }
 },
 ClearLoadingPanelTimer: function() {
  this.lpTimer = ASPx.Timer.ClearTimer(this.lpTimer);  
 },
 HideLoadingPanel: function() {
  this.ClearLoadingPanelTimer();
  this.hasPhantomLoadingElements = false;
  if(ASPx.IsExistsElement(this.loadingPanelElement)) {
   ASPx.RemoveElement(this.loadingPanelElement);
   this.loadingPanelElement = null;
  }
 },
 SetLoadingPanelLocation: function(offsetElement, loadingPanel, x, y, offsetX, offsetY) {
  if(!ASPx.IsExists(x) || !ASPx.IsExists(y)){
   var x1 = ASPx.GetAbsoluteX(offsetElement);
   var y1 = ASPx.GetAbsoluteY(offsetElement);
   var x2 = x1;
   var y2 = y1;
   if(offsetElement == document.body) {
    x1 = 0;
    y1 = 0;
    x2 = ASPx.GetDocumentMaxClientWidth();
    y2 = ASPx.GetDocumentMaxClientHeight();
   }
   else{
    x2 += offsetElement.offsetWidth;
    y2 += offsetElement.offsetHeight;
   }
   if(x1 < ASPx.GetDocumentScrollLeft())
    x1 = ASPx.GetDocumentScrollLeft();
   if(y1 < ASPx.GetDocumentScrollTop())
    y1 = ASPx.GetDocumentScrollTop();
   if(x2 > ASPx.GetDocumentScrollLeft() + ASPx.GetDocumentClientWidth())
    x2 = ASPx.GetDocumentScrollLeft() + ASPx.GetDocumentClientWidth();
   if(y2 > ASPx.GetDocumentScrollTop() + ASPx.GetDocumentClientHeight())
    y2 = ASPx.GetDocumentScrollTop() + ASPx.GetDocumentClientHeight();
   x = x1 + ((x2 - x1 - loadingPanel.offsetWidth) / 2);
   y = y1 + ((y2 - y1 - loadingPanel.offsetHeight) / 2);
  }
  if(ASPx.IsExists(offsetX) && ASPx.IsExists(offsetY)){
   x += offsetX;
   y += offsetY;
  }
  x = ASPx.PrepareClientPosForElement(x, loadingPanel, true);
  y = ASPx.PrepareClientPosForElement(y, loadingPanel, false);
  if(ASPx.Browser.IE && ASPx.Browser.Version > 8 && (y - Math.floor(y) === 0.5))
   y = Math.ceil(y);
  ASPx.SetStyles(loadingPanel, { left: x, top: y });
 },
 GetLoadingDiv: function(){
  return ASPx.GetElementById(this.name + "_LD");
 },
 CreateLoadingDiv: function(parentElement, offsetElement){
  if(this.ShouldHideExistingLoadingElements())
   this.HideLoadingDiv();
  if(parentElement == null) 
   return null;
  if(!this.IsLoadingContainerVisible()) {
   this.hasPhantomLoadingElements = true;
   return null;
  }
  if(!offsetElement)
   offsetElement = parentElement;
  var div = this.GetLoadingDiv();
  if(div != null){
   div = div.cloneNode(true);
   parentElement.appendChild(div);
   ASPx.SetElementDisplay(div, true, true);
   ASPx.Evt.AttachEventToElement(div, ASPx.TouchUIHelper.touchMouseDownEventName, ASPx.Evt.PreventEvent);
   ASPx.Evt.AttachEventToElement(div, ASPx.TouchUIHelper.touchMouseMoveEventName, ASPx.Evt.PreventEvent);
   ASPx.Evt.AttachEventToElement(div, ASPx.TouchUIHelper.touchMouseUpEventName, ASPx.Evt.PreventEvent);
   ASPx.Evt.AttachEventToElement(div, ASPx.Evt.GetMouseWheelEventName(), ASPx.Evt.PreventEvent);
   this.SetLoadingDivBounds(offsetElement, div);
   this.loadingDivElement = div;
   this.SetInitialLoadingDivOpacity();
   return div;
  }
  return null;
 },
 SetInitialLoadingDivOpacity: function() {
  if(!this.loadingDivElement) return;
  ASPx.Attr.SaveStyleAttribute(this.loadingDivElement, "opacity");
  ASPx.Attr.SaveStyleAttribute(this.loadingDivElement, "filter");
  ASPx.SetElementOpacity(this.loadingDivElement, 0.01);
 },
 RestoreLoadingDivOpacity: function() {
  if(!this.loadingDivElement) return;
  ASPx.Attr.RestoreStyleAttribute(this.loadingDivElement, "opacity");
  ASPx.Attr.RestoreStyleAttribute(this.loadingDivElement, "filter");
 },
 SetLoadingDivBounds: function(offsetElement, loadingDiv) {
  var absX = (offsetElement == document.body) ? 0 : ASPx.GetAbsoluteX(offsetElement);
  var absY = (offsetElement == document.body) ? 0 : ASPx.GetAbsoluteY(offsetElement);
  ASPx.SetStyles(loadingDiv, {
   left: ASPx.PrepareClientPosForElement(absX, loadingDiv, true),
   top: ASPx.PrepareClientPosForElement(absY, loadingDiv, false)
  });
  var width = (offsetElement == document.body) ? ASPx.GetDocumentWidth() : offsetElement.offsetWidth;
  var height = (offsetElement == document.body) ? ASPx.GetDocumentHeight() : offsetElement.offsetHeight;
  if(height < 0) 
   height = 0;
  ASPx.SetStyles(loadingDiv, { width: width, height: height });
  var correctedWidth = 2 * width - loadingDiv.offsetWidth;
  if(correctedWidth <= 0) correctedWidth = width;
  var correctedHeight = 2 * height - loadingDiv.offsetHeight;
  if(correctedHeight <= 0) correctedHeight = height;
  ASPx.SetStyles(loadingDiv, { width: correctedWidth, height: correctedHeight });
 },
 ShowLoadingDiv: function() {
 },
 HideLoadingDiv: function() {
  this.hasPhantomLoadingElements = false;
  if(ASPx.IsExistsElement(this.loadingDivElement)){
   ASPx.RemoveElement(this.loadingDivElement);
   this.loadingDivElement = null;
  }
 },
 CanHandleGesture: function(evt) {
  return false;
 },
 CanHandleGestureCore: function(evt) {
  var source = ASPx.Evt.GetEventSource(evt);
  if(ASPx.GetIsParent(this.loadingPanelElement, source) || ASPx.GetIsParent(this.loadingDivElement, source))
   return true; 
  var callbackAnimationElement = this.GetCallbackAnimationElement();
  if(!callbackAnimationElement)
   return false;
  var animationContainer = ASPx.AnimationHelper.getSlideAnimationContainer(callbackAnimationElement, false, false);
  if(animationContainer && ASPx.GetIsParent(animationContainer, source) && !ASPx.GetIsParent(animationContainer.childNodes[0], source))
   return true; 
  return this.CanHandleGesture(evt); 
 },
 AllowStartGesture: function() {
  return !this.beginCallbackAnimationProcessing && !this.endCallbackAnimationProcessing;
 },
 StartGesture: function() {
 },
 AllowExecuteGesture: function(value) {
  return false;
 },
 ExecuteGesture: function(value) {
 },
 CancelGesture: function(value) {
  if(this.repeatedGestureCount === 0) {
   this.repeatedGestureValue = value;
   this.repeatedGestureCount = 1;
  }
  else {
   if(this.repeatedGestureValue * value > 0)
    this.repeatedGestureCount++;
   else
    this.repeatedGestureCount--;
   if(this.repeatedGestureCount === 0)
    this.repeatedGestureCount = 0;
  }
 },
 CheckRepeatGesture: function() {
  if(this.repeatedGestureCount !== 0) {
   if(this.AllowExecuteGesture(this.repeatedGestureValue))
    this.ExecuteGesture(this.repeatedGestureValue, this.repeatedGestureCount);
   this.repeatedGestureValue = 0;
   this.repeatedGestureCount = 0;
  }
 },
 AllowExecutePagerGesture: function (pageIndex, pageCount, value) {
  if(pageIndex < 0) return false;
  if(pageCount <= 1) return false;
  if(value > 0 && pageIndex === 0) return false;
  if(value < 0 && pageIndex === pageCount - 1) return false;
  return true;
 },
 ExecutePagerGesture: function(pageIndex, pageCount, value, count, method) {
  if(!count) count = 1;
  var pageIndex = pageIndex + (value < 0 ? count : -count);
  if(pageIndex < 0) pageIndex = 0;
  if(pageIndex > pageCount - 1) pageIndex = pageCount - 1;
  method(PagerCommands.PageNumber + pageIndex);
 },
 RaiseInit: function(){
  if(!this.Init.IsEmpty()){
   var args = new ASPxClientEventArgs();
   this.Init.FireEvent(this, args);
  }
 },
 RaiseBeginCallbackInternal: function(command){
  if(!this.BeginCallback.IsEmpty()){
   var args = new ASPxClientBeginCallbackEventArgs(command);
   this.BeginCallback.FireEvent(this, args);
  }
 },
 RaiseEndCallbackInternal: function() {
  if(!this.EndCallback.IsEmpty()){
   var args = new ASPxClientEndCallbackEventArgs();
   this.EndCallback.FireEvent(this, args);
  }
 },
 RaiseCallbackErrorInternal: function(message, callbackId) {
  if(!this.CallbackError.IsEmpty()) {
   var args = new ASPxClientCallbackErrorEventArgs(message, callbackId);
   this.CallbackError.FireEvent(this, args);
   if(args.handled)
    return { isHandled: true, errorMessage: args.message };
  }
 },
 RaiseBeginCallback: function(command){
  this.RaiseBeginCallbackInternal(command);    
  aspxGetControlCollection().RaiseBeginCallback(this, command);
 },
 RaiseEndCallback: function(){
  this.RaiseEndCallbackInternal();
  aspxGetControlCollection().RaiseEndCallback(this);
 },
 RaiseCallbackError: function (message, callbackId) {
  var result = this.RaiseCallbackErrorInternal(message, callbackId);
  if(!result) 
   result = aspxGetControlCollection().RaiseCallbackError(this, message, callbackId);
  return result;
 },
 RaiseEndCallbackAnimationStart: function(){
  if(!this.EndCallbackAnimationStart.IsEmpty()){
   var args = new ASPxClientEventArgs();
   this.EndCallbackAnimationStart.FireEvent(this, args);
  }
 },
 RaiseBeforePronounce: function(message) {
  var args = new ASPxClientControlBeforePronounceEventArgs(message, this);
  if(!this.BeforePronounce.IsEmpty())
   this.BeforePronounce.FireEvent(this, args);
  return args;
 },
 RaiseUnload: function() {
  var args = new ASPxClientControlUnloadEventArgs(this);
  if(!this.Unload.IsEmpty())
   this.Unload.FireEvent(this, args);
 },
 SendMessageToAssistiveTechnology: function(message) {
  if(!this.accessibilityCompliant)
   return;
  this.PronounceMessageInternal(message, ASPx.AccessibilityPronouncerType.live);
 },
 PronounceMessageInternal: function(messageArg, type) {
  var message = messageArg;
  if(!ASPx.Ident.IsArray(messageArg))
   message = [messageArg];
  var args = this.RaiseBeforePronounce(message);
  ASPx.AccessibilityPronouncer.Pronounce(args, type);
 },
 IsVisible: function() {
  var element = this.GetMainElement();
  return ASPx.IsElementVisible(element);
 },
 IsDisplayedElement: function(element) {
  while(element && element.tagName != "BODY") {
   if(!ASPx.GetElementDisplay(element)) 
    return false;
   element = element.parentNode;
  }
  return true;
 },
 IsDisplayed: function() {
  return this.IsDisplayedElement(this.GetMainElement());
 },
 IsHiddenElement: function(element) {
  return element && element.offsetWidth == 0 && element.offsetHeight == 0;
 },
 IsHidden: function() {
  return this.IsHiddenElement(this.GetMainElement());
 },
 GetParentControl: function() {
  var mainElement = this.GetMainElement() || (this.GetCurrentWindowElement && this.GetCurrentWindowElement());
  var popupPostfix = ASPx.PCWIdSuffix + "-1";
  var result = null;
  ASPx.GetParent(mainElement, function(element) {
   if(element === mainElement || !element.id)
    return false;
   var controlName = element.id.replace(popupPostfix, "");
   result = ASPx.GetControlCollection().Get(controlName);
   return !!result;
  });
  return result;
 },
 Focus: function() {
 },
 GetClientVisible: function(){
  return this.GetVisible();
 },
 SetClientVisible: function(visible){
  this.SetVisible(visible);
 },
 GetVisible: function(){
  return this.clientVisible;
 },
 SetVisible: function(visible){
  if(this.clientVisible != visible){
   this.clientVisible = visible;
   ASPx.SetElementDisplay(this.GetMainElement(), visible);
   if(visible) {
    this.AdjustControl();
    var mainElement = this.GetMainElement();
    if(mainElement)
     aspxGetControlCollection().AdjustControls(mainElement);
   }
  }
 },
 GetEnabled: function() {
  return this.clientEnabled;
 },
 SetEnabled: function(enabled) {
  this.clientEnabled = enabled;
  if(ASPxClientControl.setEnabledLocked)
   return;
  else
   ASPxClientControl.setEnabledLocked = true;
  this.savedClientEnabled = enabled;
  aspxGetControlCollection().ProcessControlsInContainer(this.GetMainElement(), function(control) {
   if(ASPx.IsFunction(control.SetEnabled))
    control.SetEnabled(enabled && control.savedClientEnabled);
  });
  delete ASPxClientControl.setEnabledLocked;
 },
 InCallback: function() {
  return this.requestCount > 0;
 },
 DoBeginCallback: function(command) {
  this.RaiseBeginCallback(command || "");
  aspxGetControlCollection().Before_WebForm_InitCallback(this.name);
  if(typeof(WebForm_InitCallback) != "undefined" && WebForm_InitCallback) {
   __theFormPostData = "";
   __theFormPostCollection = [ ];
   this.ClearPostBackEventInput("__EVENTTARGET");
   this.ClearPostBackEventInput("__EVENTARGUMENT");
   WebForm_InitCallback();
   this.savedFormPostData = __theFormPostData;   
   this.savedFormPostCollection = __theFormPostCollection;
  }
 },
 ClearPostBackEventInput: function(id){
  var element = ASPx.GetElementById(id);
  if(element != null) element.value = "";
 },
 PerformDataCallback: function(arg, handler) {
  this.CreateCustomDataCallback(arg, "", handler);
 },
 sendCallbackViaQueue: function (prefix, arg, showLoadingPanel, context, handler) {
  if (!this.useCallbackQueue())
   return false;
  var context = context || this;
  var token = this.callbackQueueHelper.sendCallback(ASPx.FormatCallbackArg(prefix, arg), context, handler || context.OnCallback, prefix);
  if (showLoadingPanel)
   this.callbackQueueHelper.showLoadingElements();
  return token;
 },
 CreateCallback: function (arg, command, handler) {
  var callbackInfo = this.CreateCallbackInfo(ASPx.CallbackType.Common, handler || null);
  var callbackID = this.CreateCallbackByInfo(arg, command, callbackInfo);
  return callbackID;
 },
 CreateCustomDataCallback: function(arg, command, handler) {
  var callbackInfo = this.CreateCallbackInfo(ASPx.CallbackType.Data, handler);
  this.CreateCallbackByInfo(arg, command, callbackInfo);
 },
 CreateCallbackByInfo: function(arg, command, callbackInfo) {
  if(!this.CanCreateCallback()) return;
  var callbackID;
  if(typeof(WebForm_DoCallback) != "undefined" && WebForm_DoCallback && ASPx.documentLoaded || ASPx.Platform === "NETCORE")
   callbackID = this.CreateCallbackInternal(arg, command, true, callbackInfo);
  else {
   if(!this.savedCallbacks)
    this.savedCallbacks = [];
   var callbackInfo = { arg: arg, command: command, callbackInfo: callbackInfo };
   if(this.allowMultipleCallbacks)
    this.savedCallbacks.push(callbackInfo);
   else
    this.savedCallbacks[0] = callbackInfo;
  }
  return callbackID;
 },
 CreateCallbackInternal: function(arg, command, viaTimer, callbackInfo) {
  var watcher = ASPx.ControlUpdateWatcher.getInstance();
  if(watcher && !watcher.CanSendCallback(this, arg)) {
   this.CancelCallbackInternal();
   return;
  }
  this.requestCount++;
  this.DoBeginCallback(command);
  if(typeof(arg) == "undefined")
   arg = "";
  if(typeof(command) == "undefined")
   command = "";
  var callbackID = this.SaveCallbackInfo(callbackInfo);
  if(viaTimer)
   window.setTimeout(function() { this.CreateCallbackCore(arg, command, callbackID); }.aspxBind(this), 0);
  else
   this.CreateCallbackCore(arg, command, callbackID);
  return callbackID;
 },
 CancelCallbackInternal: function() {
  this.CancelCallbackCore();
  this.HideLoadingElements();
 },
 CancelCallbackCore: function() {
 },
 CreateCallbackCore: function(arg, command, callbackID) {
  var callBackMethod = this.GetCallbackMethod(command);
  __theFormPostData = this.savedFormPostData;
  __theFormPostCollection = this.savedFormPostCollection;
  callBackMethod.call(this, this.GetSerializedCallbackInfoByID(callbackID) + arg);
 },
 GetCallbackMethod: function(command){
  return this.callBack;
 },
 CanCreateCallback: function() {
  return !this.InCallback() || (this.allowMultipleCallbacks && !this.beginCallbackAnimationProcessing && !this.endCallbackAnimationProcessing);
 },
 DoLoadCallbackScripts: function() {
  ASPx.ProcessScriptsAndLinks(this.name, true);
 },
 DoEndCallback: function() {
  if(this.IsCallbackAnimationEnabled() && this.CheckEndCallbackAnimationNeeded()) 
   return;
  this.requestCount--;
  if (this.requestCount < 1) 
   this.callbackHandlersQueue.executeCallbacksHandlers();
  if(this.HideLoadingPanelOnCallback() && this.requestCount < 1) 
   this.HideLoadingElements();
  if(this.isSwipeGesturesEnabled() && this.supportGestures) {
   ASPx.GesturesHelper.UpdateSwipeAnimationContainer(this.name);
   if(this.touchUIMouseScroller)
    this.touchUIMouseScroller.update();
  }
  this.isCallbackAnimationPrevented = false;
  this.OnCallbackFinalized();
  this.AssignEllipsisTooltips();
  this.RaiseEndCallback();
 },
 DoFinalizeCallback: function() {
 },
 OnCallbackFinalized: function() {
 },
 AssignEllipsisTooltips: function() { },
 HideLoadingPanelOnCallback: function() {
  return true;
 },
 ShouldHideExistingLoadingElements: function() {
  return true;
 },
 EvalCallbackResult: function(resultString){
  return eval(resultString);
 },
 ParseJSProperties: function(resultObj) {
  if(resultObj.cp) {
   for(var name in resultObj.cp)
    if(resultObj.cp.hasOwnProperty(name))
     this[name] = resultObj.cp[name];
  }
 },
 DoCallback: function(result) {
  if(this.IsCallbackAnimationEnabled() && this.CheckBeginCallbackAnimationInProgress(result))
   return;
  result = ASPx.Str.Trim(result);
  if(result.indexOf(ASPx.CallbackResultPrefix) != 0) 
   this.ProcessCallbackGeneralError(result, false);
  else {
   var resultObj = null;
   try {
    resultObj = this.EvalCallbackResult(result);
   } 
   catch(e) {
   }
   if(resultObj) {
    ASPx.CacheHelper.DropCache(this);
    if(resultObj.redirect) {
     this.ParseJSProperties(resultObj); 
     ASPx.Url.Redirect(resultObj.redirect);
    }
    else if(ASPx.IsExists(resultObj.generalError)) {
     this.ProcessCallbackGeneralError(resultObj.generalError, true);
    }
    else {
     var errorObj = resultObj.error;
     if(errorObj)
      this.ProcessCallbackError(errorObj,resultObj.id);
     else {
      this.ParseJSProperties(resultObj);
      var callbackInfo = this.DequeueCallbackInfo(resultObj.id);
      if(callbackInfo && callbackInfo.type == ASPx.CallbackType.Data)
       this.ProcessCustomDataCallback(resultObj.result, callbackInfo);
      else {
       if (this.useCallbackQueue() && this.callbackQueueHelper.getCallbackInfoById(resultObj.id))
        this.callbackQueueHelper.processCallback(resultObj.result, resultObj.id);
       else {
        this.ProcessCallback(resultObj.result, resultObj.id);
        if(callbackInfo && callbackInfo.handler) {
         var handlerInfo = { handler: callbackInfo.handler, result: resultObj.result.data };
         this.callbackHandlersQueue.addCallbackHandler(handlerInfo);
        }
       }
      }
     }
    }
   } 
  }
  this.DoLoadCallbackScripts();
 },
 DoCallbackError: function(result) {
  this.HideLoadingElements();
  this.ProcessCallbackGeneralError(result, false); 
 },
 DoControlClick: function(evt) {
  this.OnControlClick(ASPx.Evt.GetEventSource(evt), evt);
 },
 ProcessCallback: function (result, callbackId) {
  this.OnCallback(result, callbackId);
 },
 ProcessCustomDataCallback: function(result, callbackInfo) {
  if(callbackInfo.handler != null)
   callbackInfo.handler(this, result);
  this.RaiseCustomDataCallback(result);
 },
 RaiseCustomDataCallback: function(result) {
  if(!this.CustomDataCallback.IsEmpty()) {
   var arg = new ASPxClientCustomDataCallbackEventArgs(result);
   this.CustomDataCallback.FireEvent(this, arg);
  }
 },
 OnCallback: function(result) {
 },
 CreateCallbackInfo: function(type, handler) {
  return { type: type, handler: handler };
 },
 GetSerializedCallbackInfoByID: function(callbackID) {
  return this.GetCallbackInfoByID(callbackID).type + callbackID + ASPx.CallbackSeparator;
 },
 SaveCallbackInfo: function(callbackInfo) {
  var activeCallbacksInfo = this.GetActiveCallbacksInfo();
  for(var i = 0; i < activeCallbacksInfo.length; i++) {
   if(activeCallbacksInfo[i] == null) {
    activeCallbacksInfo[i] = callbackInfo;
    return i;
   }
  }
  activeCallbacksInfo.push(callbackInfo);
  return activeCallbacksInfo.length - 1;
 },
 GetActiveCallbacksInfo: function() {
  var persistentProperties = this.GetPersistentProperties();
  if(!persistentProperties.activeCallbacks)
   persistentProperties.activeCallbacks = [ ];
  return persistentProperties.activeCallbacks;
 },
 GetPersistentProperties: function() {
  var storage = _aspxGetPersistentControlPropertiesStorage();
  var persistentProperties = storage[this.name];
  if(!persistentProperties) {
   persistentProperties = { };
   storage[this.name] = persistentProperties;
  }
  return persistentProperties;
 },
 GetCallbackInfoByID: function(callbackID) {
  return this.GetActiveCallbacksInfo()[callbackID];
 },
 DequeueCallbackInfo: function(index) {
  var activeCallbacksInfo = this.GetActiveCallbacksInfo();
  if(index < 0 || index >= activeCallbacksInfo.length)
   return null;
  var result = activeCallbacksInfo[index];
  activeCallbacksInfo[index] = null;
  return result;
 },
 ProcessCallbackError: function (errorObj, callbackId) {
  var data = ASPx.IsExists(errorObj.data) ? errorObj.data : null;
  var result = this.RaiseCallbackError(errorObj.message, callbackId);
  if(result.isHandled)
   this.OnCallbackErrorAfterUserHandle(result.errorMessage, data); 
  else
   this.OnCallbackError(result.errorMessage, data); 
 },
 OnCallbackError: function(errorMessage, data) {
  if(errorMessage)
   ASPx.ShowErrorAlert(errorMessage);
 },
 OnCallbackErrorAfterUserHandle: function(errorMessage, data) {
 },
 ProcessCallbackGeneralError: function(errorMessage, serverExceptionOnLastCallback) {
  this.serverExceptionOnLastCallback = serverExceptionOnLastCallback;
  var result = this.RaiseCallbackError(errorMessage);
  if(!result.isHandled)
   this.OnCallbackGeneralError(result.errorMessage);
 },
 OnCallbackGeneralError: function(errorMessage) {
  this.OnCallbackError(errorMessage, null);
 },
 SendPostBack: function(params) {
  if(typeof(__doPostBack) != "undefined")
   __doPostBack(this.uniqueID, params);
  else{
   var form = this.GetParentForm();
   if(form) form.submit();
  }
 },
 IsValidInstance: function () {
  return aspxGetControlCollection().GetByName(this.name) === this;
 },
 OnDispose: function() { 
  var varName = this.globalName;
  if(varName && varName !== "" && window && window[varName] && window[varName] == this){
   try{
    delete window[varName];
   }
   catch(e){  }
  }
  if(this.callbackQueueHelper)
   this.callbackQueueHelper.detachEvents();
 },
 OnGlobalControlsInitialized: function(args) { 
 },
 OnGlobalBrowserWindowResized: function(args) { 
 },
 OnGlobalBeginCallback: function(args) { 
 },
 OnGlobalEndCallback: function(args) { 
 },
 OnGlobalCallbackError: function(args) { 
 },
 OnGlobalValidationCompleted: function(args) { 
 },
 DOMContentLoaded: function() { },
 IsStateControllerEnabled: function() { return false; },
 InitializeDOM: function() {
  var mainElement = this.GetMainElement();
  if(mainElement)
   mainElement["dxinit"] = true;
 },
 IsDOMInitialized: function() {
  var mainElement = this.GetMainElement();
  return mainElement && mainElement["dxinit"];
 },
 AdjustControl: function(nestedCall) { },
 OnBrowserWindowResizeInternal: function(e) { },
 RegisterInControlTree: function(tree) { }
});
ASPxClientControlBase.Cast = function(obj) {
 if(typeof obj == "string")
  return window[obj];
 return obj;
};
var persistentControlPropertiesStorage = null;
function _aspxGetPersistentControlPropertiesStorage() {
 if(persistentControlPropertiesStorage == null)
  persistentControlPropertiesStorage = { };
 return persistentControlPropertiesStorage;
}
var ELLIPSIS_MARKER_CLASS = "dx-ellipsis";
var ELLIPSIS_TOOLTIP_MARKER_ATTR = "dxEllipsisTitle";
var ASPxClientControl = ASPx.CreateClass(ASPxClientControlBase, {
 constructor: function(name){
  this.constructor.prototype.constructor.call(this, name);
  this.rtl = false;
  this.enableEllipsis = false;
  this.isNative = false;
  this.isControlCollapsed = false;
  this.isInsideHierarchyAdjustment = false;
  this.controlOwner = null;
  this.adjustedSizes = { };
  this.dialogContentHashTable = { };
  this.renderIFrameForPopupElements = false;
  this.widthValueSetInPercentage = false;
  this.heightValueSetInPercentage = false;
  this.verticalAlignedElements = { };
  this.wrappedTextContainers = { };
  this.scrollPositionState = { };
  this.sizingConfig = {
   allowSetWidth: true,
   allowSetHeight: true,
   correction : false,
   adjustControl : false,
   supportPercentHeight: false,
   supportAutoHeight: false
  };
  this.percentSizeConfig = {
   width: -1,
   height: -1,
   markerWidth: -1,
   markerHeight: -1
  };  
 },
 InlineInitialize: function() {
  this.InitializeDOM();
  ASPxClientControlBase.prototype.InlineInitialize.call(this);
 },
 AfterCreate: function() { 
  ASPxClientControlBase.prototype.AfterCreate.call(this);
  if(!this.CanInitializeAdjustmentOnDOMContentLoaded() || ASPx.IsStartupScriptsRunning())
   this.InitializeAdjustment();
 },
 DOMContentLoaded: function() {
  if(this.CanInitializeAdjustmentOnDOMContentLoaded()) 
   this.InitializeAdjustment();
 },
 CanInitializeAdjustmentOnDOMContentLoaded: function() {
  return !ASPx.Browser.IE || ASPx.Browser.Version >= 10; 
 },
 InitializeAdjustment: function() {
  this.UpdateAdjustmentFlags();
  this.AdjustControl();
 },
 AfterInitialize: function() {
  this.AdjustControl();
  ASPxClientControlBase.prototype.AfterInitialize.call(this);
 },
 IsStateControllerEnabled: function(){
  return typeof(ASPx.GetStateController) != "undefined" && ASPx.GetStateController();
 },
 GetWidth: function() {
  return this.GetMainElement().offsetWidth;
 },
 GetHeight: function() {
  return this.GetMainElement().offsetHeight;
 },
 SetWidth: function(width) {
  if(this.sizingConfig.allowSetWidth)
   this.SetSizeCore("width", width, "GetWidth", false);
 },
 SetHeight: function(height) {
  if(this.sizingConfig.allowSetHeight)
   this.SetSizeCore("height", height, "GetHeight", false);
 },
 SetSizeCore: function(sizePropertyName, size, getFunctionName, corrected) {
  if(size < 0)
   return;
  this.GetMainElement().style[sizePropertyName] = size + "px";
  this.UpdateAdjustmentFlags(sizePropertyName);
  if(this.sizingConfig.adjustControl)
   this.AdjustControl(true);
  if(this.sizingConfig.correction && !corrected) {
   var realSize = this[getFunctionName]();
   if(realSize != size) {
    var correctedSize = size - (realSize - size);
    this.SetSizeCore(sizePropertyName, correctedSize, getFunctionName, true);
   }
  }
 },
 AdjustControl: function(nestedCall) {
  if(this.IsAdjustmentRequired() && (!ASPxClientControl.adjustControlLocked || nestedCall)) {
   ASPxClientControl.adjustControlLocked = true;
   try {
    if(!this.IsAdjustmentAllowed())
     return;
    this.AdjustControlCore();
    this.UpdateAdjustedSizes();
   } 
   finally {
    delete ASPxClientControl.adjustControlLocked;
   }
  }
  this.AssignEllipsisTooltips();
  this.TryShowPhantomLoadingElements();
 },
 ResetControlAdjustment: function () {
  this.adjustedSizes = { };
 },
 UpdateAdjustmentFlags: function(sizeProperty) {
  var mainElement = this.GetMainElement();
  if(mainElement) {
   var mainElementStyle = ASPx.GetCurrentStyle(mainElement);
   this.UpdatePercentSizeConfig([mainElementStyle.width, mainElement.style.width], [mainElementStyle.height, mainElement.style.height], sizeProperty);
  }
 },
 UpdatePercentSizeConfig: function(widths, heights, modifyStyleProperty) {
  switch(modifyStyleProperty) {
   case "width":
    this.UpdatePercentWidthConfig(widths);
    break;
   case "height":
    this.UpdatePercentHeightConfig(heights);
    break;
   default:
    this.UpdatePercentWidthConfig(widths);
    this.UpdatePercentHeightConfig(heights);
    break;
  }
  this.ResetControlPercentMarkerSize();
 },
 UpdatePercentWidthConfig: function(widths) {
  this.widthValueSetInPercentage = false;
  for(var i = 0; i < widths.length; i++) {
   if(this.IsPercentageWidth(widths[i])) {
    this.percentSizeConfig.width = widths[i];
    this.widthValueSetInPercentage = true;
    break;
   }
  }
 },
 IsPercentageWidth: function(width) { return ASPx.IsPercentageSize(width); },
 UpdatePercentHeightConfig: function(heights) {
  this.heightValueSetInPercentage = false;
    for(var i = 0; i < heights.length; i++) {
   if(ASPx.IsPercentageSize(heights[i])) {
    this.percentSizeConfig.height = heights[i];
    this.heightValueSetInPercentage = true;
    break;
   }
  }
 },
 GetAdjustedSizes: function() {
  var mainElement = this.GetMainElement();
  if(mainElement) 
   return { width: mainElement.offsetWidth, height: mainElement.offsetHeight };
  return { width: 0, height: 0 };
 },
 IsAdjusted: function() {
  return (this.adjustedSizes.width && this.adjustedSizes.width > 0) && (this.adjustedSizes.height && this.adjustedSizes.height > 0);
 },
 IsAdjustmentRequired: function() {
  if(!this.IsAdjusted())
   return true;
  if(this.widthValueSetInPercentage)
   return true;
  if(this.heightValueSetInPercentage)
   return true;
  var sizes = this.GetAdjustedSizes();
  for(var name in sizes){
   if(this.adjustedSizes[name] !== sizes[name])
    return true;
  }
  return false;
 },
 IsAdjustmentAllowed: function() {
  var mainElement = this.GetMainElement();
  return mainElement && this.IsDisplayed() && !this.IsHidden() && this.IsDOMInitialized();
 },
 UpdateAdjustedSizes: function() {
  var sizes = this.GetAdjustedSizes();
  for(var name in sizes)
   if(sizes.hasOwnProperty(name))
    this.adjustedSizes[name] = sizes[name];
 },
 AdjustControlCore: function() {
 },
 AdjustAutoHeight: function() {
 },
 IsControlCollapsed: function() {
  return this.isControlCollapsed;
 },
 NeedCollapseControl: function() {
  return this.NeedCollapseControlCore() && this.IsAdjustmentRequired() && this.IsAdjustmentAllowed();
 },
 NeedCollapseControlCore: function() {
  return false;
 },
 CollapseEditor: function() {
 },
 CollapseControl: function() {
  this.SaveScrollPositions();
  var mainElement = this.GetMainElement(),
   marker = this.GetControlPercentSizeMarker();
  marker.style.height = this.heightValueSetInPercentage && this.sizingConfig.supportPercentHeight
   ? this.percentSizeConfig.height 
   : (mainElement.offsetHeight + "px");
  mainElement.style.display = "none";
  this.isControlCollapsed = true;
 },
 ExpandControl: function() {
  var mainElement = this.GetMainElement();
  mainElement.style.display = "";
  this.GetControlPercentSizeMarker().style.height = "0px";
  this.isControlCollapsed = false;
  this.RestoreScrollPositions();
 },
 CanCauseReadjustment: function() {
  return this.NeedCollapseControlCore();
 },
 IsExpandableByAdjustment: function() {
  return false;
 },
 HasFixedPosition: function() {
  return false;
 },
 SaveScrollPositions: function() {
  var mainElement = this.GetMainElement();
  this.scrollPositionState.outer = ASPx.GetOuterScrollPosition(mainElement.parentNode);
  this.scrollPositionState.inner = ASPx.GetInnerScrollPositions(mainElement);
 },
 RestoreScrollPositions: function() {
  ASPx.RestoreOuterScrollPosition(this.scrollPositionState.outer);
  ASPx.RestoreInnerScrollPositions(this.scrollPositionState.inner);
 },
 GetControlPercentSizeMarker: function() {
  if(this.percentSizeMarker === undefined) {
   this.percentSizeMarker = ASPx.CreateHtmlElementFromString("<div style='height:0px;font-size:0px;line-height:0;width:100%;'></div>");
   ASPx.InsertElementAfter(this.percentSizeMarker, this.GetMainElement());
  }
  return this.percentSizeMarker;
 },
 KeepControlPercentSizeMarker: function(needCollapse, needCalculateHeight) {
  var marker = this.GetControlPercentSizeMarker(),
   markerHeight;
  if(needCollapse)
   this.CollapseControl();
  if(this.widthValueSetInPercentage && marker.style.width !== this.percentSizeConfig.width)
   marker.style.width = this.percentSizeConfig.width;
  if(needCalculateHeight) {
   if(this.IsControlCollapsed())
    markerHeight = marker.style.height;
   marker.style.height = this.percentSizeConfig.height;
  }
  this.percentSizeConfig.markerWidth = marker.offsetWidth;
  if(needCalculateHeight) {
   this.percentSizeConfig.markerHeight = marker.offsetHeight;
   if(this.IsControlCollapsed())
    marker.style.height = markerHeight;
   else
    marker.style.height = "0px";
  }
  if(needCollapse)
   this.ExpandControl();
 },
 ResetControlPercentMarkerSize: function() {
  this.percentSizeConfig.markerWidth = -1;
  this.percentSizeConfig.markerHeight = -1;
 },
 GetControlPercentMarkerSize: function(hideControl, force) {
  var needCalculateHeight = this.heightValueSetInPercentage && this.sizingConfig.supportPercentHeight;
  if(force || this.percentSizeConfig.markerWidth < 1 || (needCalculateHeight && this.percentSizeConfig.markerHeight < 1))
   this.KeepControlPercentSizeMarker(hideControl && !this.IsControlCollapsed(), needCalculateHeight);
  return {
   width: this.percentSizeConfig.markerWidth,
   height: this.percentSizeConfig.markerHeight
  };
 },
 AssignEllipsisTooltips: function() {
  if(this.RequireAssignTooltips())
   this.AssignEllipsisTooltipsCore();
 },
 AssignEllipsisTooltipsCore: function(rootElement, reassingExistingTooltips) {
  var requirePaddingManipulation = ASPx.Browser.IE || ASPx.Browser.Edge || ASPx.Browser.Firefox;
  rootElement = rootElement || this.GetMainElement();
  var nodes = this.GetEllipsisNodes(rootElement);
  var nodeInfos = [];
  var nodesCount = nodes.length;
  for(var i = 0; i < nodesCount; i++) {
   var node = nodes[i];
   var info = { node: node };
   if(requirePaddingManipulation) {
    var style = ASPx.GetCurrentStyle(node);
    info.paddingLeft = node.style.paddingLeft;
    info.totalPadding = ASPx.GetLeftRightPaddings(node, style);
   }
   nodeInfos.push(info);
  }
  if(requirePaddingManipulation) {
   for(var i = 0; i < nodesCount; i++) {
    var info = nodeInfos[i];
    ASPx.SetStyles(info.node, { paddingLeft: info.totalPadding }, true);
   }
  }
  for(var i = 0; i < nodesCount; i++) {
   var info = nodeInfos[i];
   var node = info.node;
   info.isTextShortened = node.scrollWidth > node.clientWidth;
   info.hasTitle = ASPx.Attr.GetAttribute(node, "title") !== null;
   if(!info.hasTitle || reassingExistingTooltips)
    info.title = this.GetEllipsisTooltipText(node);
  }
  for(var i = 0; i < nodesCount; i++) {
   var info = nodeInfos[i];
   var node = info.node;
   if(info.isTextShortened && info.title) {
    ASPx.Attr.SetAttribute(node, "title", info.title);
    ASPx.Attr.SetAttribute(node, ELLIPSIS_TOOLTIP_MARKER_ATTR, true);
   }
   if(!info.isTextShortened && info.hasTitle)
    ASPx.Attr.RemoveAttribute(node, "title");
  }
  if(requirePaddingManipulation) {
   for(var i = 0; i < nodesCount; i++) {
    var info = nodeInfos[i];
    var node = info.node;
    node.style.paddingLeft = info.paddingLeft;
   }
  }
 },
 GetEllipsisNodes: function(element) {
  var ellipsibleNodes = ASPx.Data.CollectionToArray(ASPx.GetNodesByClassName(element, ELLIPSIS_MARKER_CLASS));
  if(ASPx.ElementHasCssClass(element, ELLIPSIS_MARKER_CLASS))
   ellipsibleNodes.push(element);
  return ellipsibleNodes.filter(function(node) {
   return !ASPx.Attr.IsExistsAttribute(node, "title") || ASPx.Attr.IsExistsAttribute(node, ELLIPSIS_TOOLTIP_MARKER_ATTR);
  });
 },
 GetEllipsisTooltipText: function(element) {
  if(element && ASPx.IsExists(element.innerText))
   return element.innerText;
  return ASPx.GetInnerText(element);
 },
 RequireAssignTooltips: function() {
  return this.enableEllipsis && !ASPx.Browser.MobileUI;
 },
 OnBrowserWindowResize: function(e) {
 },
 OnBrowserWindowResizeInternal: function(e){
  if(this.BrowserWindowResizeSubscriber()) 
   this.OnBrowserWindowResize(e);
 },
 BrowserWindowResizeSubscriber: function() {
  return this.widthValueSetInPercentage || !this.IsAdjusted();
 },
 ShrinkWrappedText: function(getElements, key, reCorrect) {
  if(!ASPx.Browser.Safari) return;
  var elements = ASPx.CacheHelper.GetCachedElements(this, key, getElements, this.wrappedTextContainers);
  for(var i = 0; i < elements.length; i++)
   this.ShrinkWrappedTextInContainer(elements[i], reCorrect);
 },
 ShrinkWrappedTextInContainer: function(container, reCorrect) {
  if(!ASPx.Browser.Safari || !container || (container.dxWrappedTextShrinked && !reCorrect) || container.offsetWidth === 0) return;
  ASPx.ShrinkWrappedTextInContainer(container);
  container.dxWrappedTextShrinked = true;
 },
 CorrectWrappedText: function(getElements, key, reCorrect) {
  var elements = ASPx.CacheHelper.GetCachedElements(this, key, getElements, this.wrappedTextContainers);
  for(var i = 0; i < elements.length; i++)
   this.CorrectWrappedTextInContainer(elements[i], reCorrect);
 },
 CorrectWrappedTextInContainer: function(container, reCorrect) {
  if(!container || (container.dxWrappedTextCorrected && !reCorrect) || container.offsetWidth === 0) return;
  ASPx.AdjustWrappedTextInContainer(container);
  container.dxWrappedTextCorrected = true;
 },
 CorrectVerticalAlignment: function(alignMethod, getElements, key, reAlign) {
  var elements = ASPx.CacheHelper.GetCachedElements(this, key, getElements, this.verticalAlignedElements);
  for(var i = 0; i < elements.length; i++)
   this.CorrectElementVerticalAlignment(alignMethod, elements[i], reAlign);
 },
 CorrectElementVerticalAlignment: function(alignMethod, element, reAlign) {
  if(!element || (element.dxVerticalAligned && !reAlign) || element.offsetHeight === 0) return;
  alignMethod(element);
  element.dxVerticalAligned = true;
 },
 ClearVerticalAlignedElementsCache: function() {
  ASPx.CacheHelper.DropCache(this.verticalAlignedElements);
 },
 ClearWrappedTextContainersCache: function() {
  ASPx.CacheHelper.DropCache(this.wrappedTextContainers);
 },
 AdjustPagerControls: function() {
  if(typeof(ASPx.GetPagersCollection) != "undefined")
   ASPx.GetPagersCollection().AdjustControls(this.GetMainElement());
 },
 RegisterInControlTree: function(tree) {
  var mainElement = this.GetMainElement();
  if(mainElement && mainElement.id)
   tree.createNode(mainElement.id, this);
 },
 GetItemElementName: function(element) {
  var name = "";
  if(element.id)
   name = element.id.substring(this.name.length + 1);
  return name;
 },
 GetLinkElement: function(element) {
  if(element == null) return null;
  return (element.tagName == "A") ? element : ASPx.GetNodeByTagName(element, "A", 0);
 },
 GetInternalHyperlinkElement: function(parentElement, index) {
  var element = ASPx.GetNodeByTagName(parentElement, "A", index);
  if(element == null) 
   element = ASPx.GetNodeByTagName(parentElement, "SPAN", index);
  return element;
 },
 OnControlClick: function(clickedElement, htmlEvent) {
 }
});
ASPxClientControl.Cast = function(obj) {
 if(typeof obj == "string")
  return window[obj];
 return obj;
};
ASPxClientControl.AdjustControls = function(container, collapseControls){
 aspxGetControlCollection().AdjustControls(container, collapseControls);
};
ASPxClientControl.GetControlCollection = function(){
 return aspxGetControlCollection();
};
ASPxClientControl.LeadingAfterInitCallConsts = {
 None: 0,
 Direct: 1,
 Reverse: 2
};
var ASPxClientComponent = ASPx.CreateClass(ASPxClientControl, {
 constructor: function (name) {
  this.constructor.prototype.constructor.call(this, name);
 },
 IsDOMDisposed: function() { 
  return false;
 }
});
var ASPxClientControlCollection = ASPx.CreateClass(ASPx.CollectionBase, {
 constructor: function(){
  this.constructor.prototype.constructor.call(this);
  this.prevWndWidth = "";
  this.prevWndHeight = "";
  this.requestCountInternal = 0; 
  this.BeforeInitCallback = new ASPxClientEvent();
  this.ControlsInitialized = new ASPxClientEvent();
  this.BrowserWindowResized = new ASPxClientEvent();
  this.BeginCallback = new ASPxClientEvent();
  this.EndCallback = new ASPxClientEvent();
  this.CallbackError = new ASPxClientEvent();
  this.ValidationCompleted = new ASPxClientEvent();
  aspxGetControlCollectionCollection().Add(this);
 },
 Add: function(element) {
  var existsElement = this.Get(element.name);
  if(existsElement && existsElement !== element) 
   this.Remove(existsElement);
  ASPx.CollectionBase.prototype.Add.call(this, element.name, element);
 },
 Remove: function(element) {
  if(element && element instanceof ASPxClientControl)
   element.OnDispose();
  ASPx.CollectionBase.prototype.Remove.call(this, element.name);
 },
 GetGlobal: function(name) {
  var result = window[name];
  return result && Ident.IsASPxClientControl(result)
   ? result
   : null;
 },
 GetByName: function(name){
  return this.Get(name) || this.GetGlobal(name);
 },
 GetCollectionType: function(){
  return ASPxClientControlCollection.BaseCollectionType;
 },
 GetControlsByPredicate: function(predicate) {
  var result = [];
  this.ForEachControl(function(control) {
   if(!predicate || predicate(control))
    result.push(control);
  });
  return result;
 },
 GetControlsByType: function(type) {
  return this.GetControlsByPredicate(function(control) { 
   return type && (control instanceof type);
  });
 },
 ForEachControl: function(action, context) {
  context = context || this;
  this.elementsMap.forEachEntry(function(name, control) {
   if(Ident.IsASPxClientControl(control))
    return action.call(context, control);
  }, context);
 },
 forEachControlHierarchy: function(container, context, collapseControls, processFunc) {
  context = context || this;
  var controlTree = new ASPx.ControlTree(this, container);
  controlTree.forEachControl(collapseControls, function(control) {
   processFunc.call(context, control);
  });
 },
 AdjustControls: function(container, collapseControls) {
  container = container || null;
  window.setTimeout(function() {
   this.AdjustControlsCore(container, collapseControls);
  }.aspxBind(this), 0);
 },
 AdjustControlsCore: function(container, collapseControls) {
  this.forEachControlHierarchy(container, this, collapseControls, function(control) {
   control.AdjustControl();
  });
 },
 CollapseControls: function(container) {
  this.ProcessControlsInContainer(container, function(control) {
   if(control.isASPxClientEdit)
    control.CollapseEditor();
   else if(!!window.ASPxClientRibbon && control instanceof ASPxClientRibbon)
    control.CollapseControl();
  });
 },
 AtlasInitialize: function(isCallback) {
  if(ASPx.Browser.IE && ASPx.Browser.MajorVersion < 9) {
   var func = function() {
    if(_aspxIsLinksLoaded())
     ASPx.ProcessScriptsAndLinks("", isCallback); 
    else
     setTimeout(func, 100);
   };   
   func();
  }
  else
   ASPx.ProcessScriptsAndLinks("", isCallback);
 },
 DOMContentLoaded: function() {
  this.ForEachControl(function(control){
    control.DOMContentLoaded();
  });
 },
 OnDocumentUnload: function() {
  this.ForEachControl(function(control) {
   control.RaiseUnload();
  });
 },
 Initialize: function() {
  ASPx.GetPostHandler().Post.AddHandler(
   function(s, e) { this.OnPost(e); }.aspxBind(this)
  );
  ASPx.GetPostHandler().PostFinalization.AddHandler(
   function(s, e) { this.OnPostFinalization(e); }.aspxBind(this)
  );
  this.InitializeElements(false );
  if(typeof(Sys) != "undefined" && typeof(Sys.Application) != "undefined") {
   var checkIsInitialized = function() {
    if(Sys.Application.get_isInitialized())
     Sys.Application.add_load(aspxCAInit);
    else
     setTimeout(checkIsInitialized, 0);
   };
   checkIsInitialized();
  }
  this.InitWindowSizeCache();
 },
 InitializeElements: function(isCallback) {
  this.ForEachControl(function(control){
   if(!control.isInitialized)
    control.Initialize();
  });
  this.AfterInitializeElementsLeadingCall();
  this.AfterInitializeElements();
  this.RaiseControlsInitialized(isCallback);
 },
 AfterInitializeElementsLeadingCall: function() {
  var controls = {};
  controls[ASPxClientControl.LeadingAfterInitCallConsts.Direct] = [];
  controls[ASPxClientControl.LeadingAfterInitCallConsts.Reverse] = [];
  this.ForEachControl(function(control) {
   if(control.leadingAfterInitCall != ASPxClientControl.LeadingAfterInitCallConsts.None && !control.isInitialized)
    controls[control.leadingAfterInitCall].push(control);
  });
  var directInitControls = controls[ASPxClientControl.LeadingAfterInitCallConsts.Direct],
   reverseInitControls = controls[ASPxClientControl.LeadingAfterInitCallConsts.Reverse];
  for(var i = 0, control; control = directInitControls[i]; i++)
   control.AfterInitialize();
  for(var i = reverseInitControls.length - 1, control; control = reverseInitControls[i]; i--)
   control.AfterInitialize();
 },
 AfterInitializeElements: function() {
  this.ForEachControl(function(control) {
   if(control.leadingAfterInitCall == ASPxClientControl.LeadingAfterInitCallConsts.None && !control.isInitialized)
    control.AfterInitialize();
  });
  ASPx.RippleHelper.Init();
 },
 DoFinalizeCallback: function() {
  this.ForEachControl(function(control){
   control.DoFinalizeCallback();
  });
 },
 ProcessControlsInContainer: function(container, processFunc) {
  this.ForEachControl(function(control){
   if(!container || this.IsControlInContainer(container, control))
    processFunc(control);
  });
 },
 IsControlInContainer: function(container, control) {
  if(control.GetMainElement) {
   var mainElement = control.GetMainElement();
   if(mainElement && (mainElement != container)) {
    if(ASPx.GetIsParent(container, mainElement))
     return true;
   }
  }
  return false;
 },
 RaiseControlsInitialized: function(isCallback) {
  if(typeof(isCallback) == "undefined")
   isCallback = true;
  var args = new ASPxClientControlsInitializedEventArgs(isCallback);
  if(!this.ControlsInitialized.IsEmpty())  
   this.ControlsInitialized.FireEvent(this, args);
  this.ForEachControl(function(control){
   control.OnGlobalControlsInitialized(args);
  });
 },
 RaiseBrowserWindowResized: function() {
  var args = new ASPxClientEventArgs();
  if(!this.BrowserWindowResized.IsEmpty())
   this.BrowserWindowResized.FireEvent(this, args);
  this.ForEachControl(function(control){
   control.OnGlobalBrowserWindowResized(args);
  });
 },
 RaiseBeginCallback: function (control, command) {
  var args = new ASPxClientGlobalBeginCallbackEventArgs(control, command);
  if(!this.BeginCallback.IsEmpty())
   this.BeginCallback.FireEvent(this, args);
  this.ForEachControl(function(control){
   control.OnGlobalBeginCallback(args);
  });
  this.IncrementRequestCount();
 },
 RaiseEndCallback: function (control) {
  var args = new ASPxClientGlobalEndCallbackEventArgs(control);
  if (!this.EndCallback.IsEmpty()) 
   this.EndCallback.FireEvent(this, args);
  this.ForEachControl(function(control){
   control.OnGlobalEndCallback(args);
  });
  this.DecrementRequestCount();
 },
 InCallback: function() {
  return this.requestCountInternal > 0;
 },
 RaiseCallbackError: function (control, message, callbackId) {
  var args = new ASPxClientGlobalCallbackErrorEventArgs(control, message, callbackId);
  if (!this.CallbackError.IsEmpty()) 
   this.CallbackError.FireEvent(this, args);
  this.ForEachControl(function(control){
   control.OnGlobalCallbackError(args);
  });
  if(args.handled)
   return { isHandled: true, errorMessage: args.message };  
  return { isHandled: false, errorMessage: message };
 },
 RaiseValidationCompleted: function (container, validationGroup, invisibleControlsValidated, isValid, firstInvalidControl, firstVisibleInvalidControl) {
  var args = new ASPxClientValidationCompletedEventArgs(container, validationGroup, invisibleControlsValidated, isValid, firstInvalidControl, firstVisibleInvalidControl);
  if (!this.ValidationCompleted.IsEmpty()) 
   this.ValidationCompleted.FireEvent(this, args);
  this.ForEachControl(function(control){
   control.OnGlobalValidationCompleted(args);
  });
 },
 Before_WebForm_InitCallback: function(callbackOwnerID){
  var args = new BeforeInitCallbackEventArgs(callbackOwnerID);
  this.BeforeInitCallback.FireEvent(this, args);
 },
 InitWindowSizeCache: function(){
  this.prevWndWidth = ASPx.GetDocumentClientWidth();
  this.prevWndHeight = ASPx.GetDocumentClientHeight();
 },
 OnBrowserWindowResize: function(evt){
  var shouldIgnoreNestedEvents = ASPx.Browser.IE && ASPx.Browser.MajorVersion == 8;
  if(shouldIgnoreNestedEvents) {
   if(this.prevWndWidth === "" || this.prevWndHeight === "" || this.browserWindowResizeLocked)
    return;
   this.browserWindowResizeLocked = true;
  }
  this.OnBrowserWindowResizeCore(evt);
  if(shouldIgnoreNestedEvents)
   this.browserWindowResizeLocked = false;
 },
 OnBrowserWindowResizeCore: function(htmlEvent){
  var args = this.CreateOnBrowserWindowResizeEventArgs(htmlEvent);
  if(this.CalculateIsBrowserWindowSizeChanged()) {
   this.forEachControlHierarchy(null, this, true, function(control) {
    if(control.IsDOMInitialized())
     control.OnBrowserWindowResizeInternal(args);
   });
   this.RaiseBrowserWindowResized();
  }
 },
 CreateOnBrowserWindowResizeEventArgs: function(htmlEvent){
  return {
   htmlEvent: htmlEvent,
   wndWidth: ASPx.GetDocumentClientWidth(),
   wndHeight: ASPx.GetDocumentClientHeight(),
   prevWndWidth: this.prevWndWidth,
   prevWndHeight: this.prevWndHeight
  };
 },
 CalculateIsBrowserWindowSizeChanged: function(){
  var wndWidth = ASPx.GetDocumentClientWidth();
  var wndHeight = ASPx.GetDocumentClientHeight();
  var isBrowserWindowSizeChanged = (this.prevWndWidth != wndWidth) || (this.prevWndHeight != wndHeight);
  if(isBrowserWindowSizeChanged){
   this.prevWndWidth = wndWidth;
   this.prevWndHeight = wndHeight;
   return true;
  }
  return false;
 },
 OnPost: function(args){
  this.ForEachControl(function(control) {
   control.OnPost(args);
  }, null);
 },
 OnPostFinalization: function(args){
  this.ForEachControl(function(control) {
   control.OnPostFinalization(args);
  }, null);
 },
 IncrementRequestCount: function() {
  this.requestCountInternal++;
 },
 DecrementRequestCount: function() {
  this.requestCountInternal--;
 },
 ResetRequestCount: function() {
  this.requestCountInternal = 0;
 }
});
ASPxClientControlCollection.BaseCollectionType = "Control";
var controlCollection = null;
function aspxGetControlCollection(){
 if(controlCollection == null) 
  controlCollection = new ASPxClientControlCollection();
 return controlCollection;
}
var ControlCollectionCollection = ASPx.CreateClass(ASPx.CollectionBase, {
 constructor: function(){
  this.constructor.prototype.constructor.call(this);
 },
 Add: function(element) {
  var key = element.GetCollectionType();
  if(!key) throw "The collection type isn't specified.";
  if(this.Get(key)) throw "The collection with type='" + key + "' already exists.";
  ASPx.CollectionBase.prototype.Add.call(this, key, element);
 },
 RemoveDisposedControls: function(){
  var baseCollection = this.Get(ASPxClientControlCollection.BaseCollectionType);
  var disposedControls = [];
  baseCollection.elementsMap.forEachEntry(function(name, control) {
   if(!ASPx.Ident.IsASPxClientControl(control)) return;
   if(control.IsDOMDisposed())
    disposedControls.push(control);
  });
  for(var i = 0; i < disposedControls.length; i++) {
   this.elementsMap.forEachEntry(function(key, collection) {
    if(ASPx.Ident.IsASPxClientCollection(collection))
     collection.Remove(disposedControls[i]);
   });
  }
 }
});
var controlCollectionCollection = null;
function aspxGetControlCollectionCollection(){
 if(controlCollectionCollection == null)
  controlCollectionCollection = new ControlCollectionCollection();
 return controlCollectionCollection;
}
var AriaDescriptionAttributes = {
 Role: "0",
 AriaLabel: "1",
 TabIndex: "2",
 AriaOwns: "3",
 AriaDescribedBy: "4",
 AriaDisabled: "5",
 AriaHasPopup: "6",
 AriaLevel: "7"
};
var AriaDescriptor = ASPx.CreateClass(null, {
 constructor: function(ownerControl, description) {
  this.ownerControl = ownerControl;
  this.rootElement = ownerControl.GetMainElement();
  this.description = description;
 },
 setDescription: function(name, argList) {
  var description = this.findChildDescription(name);
  if(description) {
   var elements = name ? this.rootElement.querySelectorAll(this.getDescriptionSelector(description)) : [this.rootElement];
   for(var i = 0; i < elements.length; i++)
    this.applyDescriptionToElement(elements[i], description, argList[i] || argList[0]);
  }
 },
 getDescriptionName: function(description) {
  return description.n;
 },
 getDescriptionSelector: function(description) {
  return description.s;
 },
 findChildDescription: function(name) {
  if(name === this.getDescriptionName(this.description))
   return this.description;
  var childCollection = this.description.c || [];
  for(var i = 0; i < childCollection.length; i++) {
   var childDescription = childCollection[i];
   if(this.getDescriptionName(childDescription) === name)
    return childDescription;
  }
  return null;
 },
 applyDescriptionToElement: function(element, description, args) {
  if(!description || !element)
   return;
  this.trySetAriaOwnsAttribute(element, description);
  this.trySetAriaDescribedByAttribute(element, description);
  this.trySetAttribute(element, description, AriaDescriptionAttributes.Role, "role");
  this.trySetAttribute(element, description, AriaDescriptionAttributes.TabIndex, "tabindex");
  this.trySetAttribute(element, description, AriaDescriptionAttributes.AriaLevel, "aria-level");
  this.executeOnDescription(description, AriaDescriptionAttributes.AriaLabel, function(value) {
   ASPx.Attr.SetAttribute(element, "aria-label", ASPx.Str.ApplyReplacement(value, args));
  });
  this.executeOnDescription(description, AriaDescriptionAttributes.AriaDisabled, function(value) {
   ASPx.Attr.SetAttribute(element, "aria-disabled", !!value); 
  });
  this.executeOnDescription(description, AriaDescriptionAttributes.AriaHasPopup, function(value) {
   ASPx.Attr.SetAttribute(element, "aria-haspopup", !!value);
  });
 },
 trySetAriaDescribedByAttribute: function(element, description) {
  this.executeOnDescription(description, AriaDescriptionAttributes.AriaDescribedBy, function(selectorInfo) {
   var descriptor = this.getNodesBySelector(element, selectorInfo.descriptorSelector)[0];
   var target = this.getNodesBySelector(element, selectorInfo.targetSelector)[0];
   if(!target || !descriptor)
    return;
   ASPx.Attr.SetAttribute(target, "aria-describedby", this.getNodeId(descriptor));
  });
 },
 trySetAriaOwnsAttribute: function(element, description) {
  this.executeOnDescription(description, AriaDescriptionAttributes.AriaOwns, function(selector) {
   var ownedNodes = this.getNodesBySelector(element, selector);
   var ariaOwnsAttributeValue = "";
   for(var i = 0; i < ownedNodes.length; i++)
    ariaOwnsAttributeValue += (this.getNodeId(ownedNodes[i]) + (i != ownedNodes.length - 1 ? " " : ""));
   ASPx.Attr.SetAttribute(element, "aria-owns", ariaOwnsAttributeValue);
  });
 },
 trySetAttribute: function(element, description, ariaAttribute, attributeName) {
  this.executeOnDescription(description, ariaAttribute, function(value) { 
   ASPx.Attr.SetAttribute(element, attributeName, description[ariaAttribute]); 
  });
 },
 executeOnDescription: function(description, ariaDescAttr, callback) {
  var descInfo = description[ariaDescAttr];
  if(ASPx.IsExists(descInfo))
   callback.aspxBind(this)(descInfo);
 },
 getNodesBySelector: function(element, selector) {
  var id = element.id || "";
  var childNodes = element.querySelectorAll("#" + this.getNodeId(element) + " > " + selector);
  ASPx.Attr.SetOrRemoveAttribute(element, "id", id);
  return childNodes;
 },
 getNodeId: function(node) {
  if(!node.id)
   node.id = this.createRandomId();
  return node.id; 
 },
 createRandomId: function() {
  return "r" + ASPx.CreateGuid();
 }
});
PagerCommands = {
 Next : "PBN",
 Prev : "PBP",
 Last : "PBL",
 First : "PBF",
 PageNumber : "PN",
 PageSize : "PSP"
};
ASPx.Callback = function(result, context){
 var collection = aspxGetControlCollection();
 collection.DoFinalizeCallback();
 var control = collection.Get(context);
 if(control != null)
  control.DoCallback(result);
 ASPx.RippleHelper.ReInit();
};
ASPx.CallbackError = function(result, context){
 var control = aspxGetControlCollection().Get(context);
 if(control != null)
  control.DoCallbackError(result, false);
};
ASPx.CClick = function(name, evt) {
 var control = aspxGetControlCollection().Get(name);
 if(control != null) control.DoControlClick(evt);
};
function aspxCAInit() {
 var isAppInit = typeof(Sys$_Application$initialize) != "undefined" &&
  ASPx.FunctionIsInCallstack(arguments.callee, Sys$_Application$initialize, 10 );
 aspxGetControlCollection().AtlasInitialize(!isAppInit);
}
ASPx.Evt.AttachEventToElement(window, "resize", aspxGlobalWindowResize);
function aspxGlobalWindowResize(evt){
 aspxGetControlCollection().OnBrowserWindowResize(evt); 
}
ASPx.Evt.AttachEventToElement(window, "unload", aspxClassesUnload);
function aspxClassesUnload(evt) {
 aspxGetControlCollection().OnDocumentUnload();
}
ASPx.Evt.AttachEventToElement(window.document, "DOMContentLoaded", aspxClassesDOMContentLoaded);
function aspxClassesDOMContentLoaded(evt){
 aspxGetControlCollection().DOMContentLoaded();
}
ASPx.GetControlCollection = aspxGetControlCollection;
ASPx.GetControlCollectionCollection = aspxGetControlCollectionCollection;
ASPx.GetPersistentControlPropertiesStorage = _aspxGetPersistentControlPropertiesStorage;
ASPx.PagerCommands = PagerCommands;
window.ASPxClientBeginCallbackEventArgs = ASPxClientBeginCallbackEventArgs;
window.ASPxClientGlobalBeginCallbackEventArgs = ASPxClientGlobalBeginCallbackEventArgs;
window.ASPxClientEndCallbackEventArgs = ASPxClientEndCallbackEventArgs;
window.ASPxClientGlobalEndCallbackEventArgs = ASPxClientGlobalEndCallbackEventArgs;
window.ASPxClientCallbackErrorEventArgs = ASPxClientCallbackErrorEventArgs;
window.ASPxClientGlobalCallbackErrorEventArgs = ASPxClientGlobalCallbackErrorEventArgs;
window.ASPxClientCustomDataCallbackEventArgs = ASPxClientCustomDataCallbackEventArgs;
window.ASPxClientValidationCompletedEventArgs = ASPxClientValidationCompletedEventArgs;
window.ASPxClientControlsInitializedEventArgs = ASPxClientControlsInitializedEventArgs;
window.ASPxClientControlBeforePronounceEventArgs = ASPxClientControlBeforePronounceEventArgs;
window.ASPxClientControlUnloadEventArgs = ASPxClientControlUnloadEventArgs;
window.ASPxClientControlCollection = ASPxClientControlCollection;
window.ASPxClientControlBase = ASPxClientControlBase;
window.ASPxClientControl = ASPxClientControl;
window.ASPxClientComponent = ASPxClientComponent;
})();
(function () {
 var PositionAnimationTransition = ASPx.CreateClass(ASPx.AnimationTransitionBase, {
  constructor: function (element, options) {
   this.constructor.prototype.constructor.call(this, element, options);
   this.direction = options.direction;
   this.animationTransition = this.createAnimationTransition();
   AnimationHelper.appendWKAnimationClassNameIfRequired(this.element);
  },
  Start: function (to) {
   var from = this.GetValue();
   if(ASPx.AnimationUtils.CanUseCssTransform()) {
    from = this.convertPosToCssTransformPos(from);
    to = this.convertPosToCssTransformPos(to);
   }
   this.animationTransition.Start(from, to);
  },
  SetValue: function (value) {
   ASPx.AnimationUtils.SetTransformValue(this.element, value, this.direction == AnimationHelper.SLIDE_VERTICAL_DIRECTION);
  },
  GetValue: function () {
   return ASPx.AnimationUtils.GetTransformValue(this.element, this.direction == AnimationHelper.SLIDE_VERTICAL_DIRECTION);
  },
  createAnimationTransition: function () {
   var transition = ASPx.AnimationUtils.CanUseCssTransform() ? this.createTransformAnimationTransition() : this.createPositionAnimationTransition();
   transition.transition = ASPx.AnimationConstants.Transitions.POW_EASE_OUT;
   return transition;
  },
  createTransformAnimationTransition: function () {
   return ASPx.AnimationUtils.createCssAnimationTransition(this.element, {
    property: ASPx.AnimationUtils.CanUseCssTransform(),
    duration: this.duration,
    onComplete: this.onComplete
   });
  },
  createPositionAnimationTransition: function () {
   return AnimationHelper.createAnimationTransition(this.element, {
    property: this.direction == AnimationHelper.SLIDE_VERTICAL_DIRECTION ? "top" : "left",
    unit: "px",
    duration: this.duration,
    onComplete: this.onComplete
   });
  },
  convertPosToCssTransformPos: function (position) {
   return ASPx.AnimationUtils.GetTransformCssText(position, this.direction == AnimationHelper.SLIDE_VERTICAL_DIRECTION);
  }
 });
 var AnimationHelper = {
  SLIDE_HORIZONTAL_DIRECTION: 0,
  SLIDE_VERTICAL_DIRECTION: 1,
  SLIDE_TOP_DIRECTION: 0,
  SLIDE_RIGHT_DIRECTION: 1,
  SLIDE_BOTTOM_DIRECTION: 2,
  SLIDE_LEFT_DIRECTION: 3,
  SLIDE_CONTAINER_CLASS: "dxAC",
  MAXIMUM_DEPTH: 3,
  createAnimationTransition: function (element, options) {
   if(options.onStep) 
    options.animationEngine = "js";
   switch (options.animationEngine) {
    case "js":
     return ASPx.AnimationUtils.createJsAnimationTransition(element, options);
    case "css":
     return ASPx.AnimationUtils.createCssAnimationTransition(element, options);
    default:
     return ASPx.AnimationUtils.CanUseCssTransition() ? ASPx.AnimationUtils.createCssAnimationTransition(element, options) :
      ASPx.AnimationUtils.createJsAnimationTransition(element, options);
   }
  },
  createMultipleAnimationTransition: function (element, options) {
   return ASPx.AnimationUtils.createMultipleAnimationTransition(element, options);
  },
  createSimpleAnimationTransition: function (options) {
   return ASPx.AnimationUtils.createSimpleAnimationTransition(options);
  },
  cancelAnimation: function (element) {
   ASPx.AnimationTransitionBase.Cancel(element);
  },
  fadeIn: function (element, onComplete, duration) {
   AnimationHelper.fadeTo(element, {
    from: 0, to: 1,
    onComplete: onComplete,
    duration: duration || ASPx.AnimationConstants.Durations.DEFAULT
   });
  },
  fadeOut: function (element, onComplete, duration) {
   AnimationHelper.fadeTo(element, {
    from: ASPx.GetElementOpacity(element), to: 0,
    onComplete: onComplete,
    duration: duration || ASPx.AnimationConstants.Durations.DEFAULT
   });
  },
  fadeTo: function (element, options) {
   options.property = "opacity";
   if(!options.duration)
    options.duration = ASPx.AnimationConstants.Durations.SHORT;
   var transition = AnimationHelper.createAnimationTransition(element, options);
   if(!ASPx.IsExists(options.from))
    options.from = transition.GetValue();
   transition.Start(options.from, options.to);
  },
  slideIn: function (element, direction, onComplete, animationEngineType) {
   AnimationHelper.setOpacity(element, 1);
   var animationContainer = AnimationHelper.getSlideAnimationContainer(element, true, true);
   var pos = AnimationHelper.getSlideInStartPos(animationContainer, direction);
   var transition = AnimationHelper.createSlideTransition(animationContainer, direction,
    function (el) {
     AnimationHelper.resetSlideAnimationContainerSize(animationContainer);
     if(onComplete)
      onComplete(el);
    }, animationEngineType);
   transition.Start(pos, 0);
  },
  slideOut: function (element, direction, onComplete, animationEngineType) {
   var animationContainer = AnimationHelper.getSlideAnimationContainer(element, true, true);
   var pos = AnimationHelper.getSlideOutFinishPos(animationContainer, direction);
   var transition = AnimationHelper.createSlideTransition(animationContainer, direction,
    function (el) {
     AnimationHelper.setOpacity(el.firstChild, 0);
     if(onComplete)
      onComplete(el);
    }, animationEngineType);
   transition.Start(pos);
  },
  slideTo: function (element, options) {
   if(!ASPx.IsExists(options.direction))
    options.direction = AnimationHelper.SLIDE_HORIZONTAL_DIRECTION;
   var transition = new PositionAnimationTransition(element, options);
   transition.Start(options.to);
  },
  setOpacity: function (element, value) {
   ASPx.AnimationUtils.setOpacity(element, value);
  },
  appendWKAnimationClassNameIfRequired: function (element) {
   if(ASPx.AnimationUtils.CanUseCssTransform() && ASPx.Browser.WebKitFamily && !ASPx.ElementHasCssClass(element, "dx-wbv"))
    element.className += " dx-wbv";
  },
  findSlideAnimationContainer: function (element) {
   var container = element;
   for(var i = 0; i < AnimationHelper.MAXIMUM_DEPTH; i++) {
    if(container.tagName == "BODY")
     return null;
    if(ASPx.ElementHasCssClass(container, AnimationHelper.SLIDE_CONTAINER_CLASS))
     return container;
    container = container.parentNode;
   }
   return null;
  },
  createSlideAnimationContainer: function (element) {
   var rootContainer = document.createElement("DIV");
   ASPx.SetStyles(rootContainer, {
    className: AnimationHelper.SLIDE_CONTAINER_CLASS,
    overflow: "hidden"
   });
   var elementContainer = document.createElement("DIV");
   rootContainer.appendChild(elementContainer);
   var parentNode = element.parentNode;
   parentNode.insertBefore(rootContainer, element);
   elementContainer.appendChild(element);
   return rootContainer;
  },
  getSlideAnimationContainer: function (element, create, fixSize) {
   if(!element) return;
   var width = element.offsetWidth;
   var height = element.offsetHeight;
   var container;
   if(element.className == AnimationHelper.SLIDE_CONTAINER_CLASS)
    container = element;
   if(!container)
    container = AnimationHelper.findSlideAnimationContainer(element);
   if(!container && create)
    container = AnimationHelper.createSlideAnimationContainer(element);
   if(container && fixSize) {
    ASPx.SetStyles(container, {
     width: width, height: height
    });
    ASPx.SetStyles(container.firstChild, {
     width: width, height: height
    });
   }
   return container;
  },
  resetSlideAnimationContainerSize: function (container) {
   ASPx.SetStyles(container, {
    width: "", height: ""
   });
   ASPx.SetStyles(container.firstChild, {
    width: "", height: ""
   });
  },
  getModifyProperty: function (direction) {
   if(direction == AnimationHelper.SLIDE_TOP_DIRECTION || direction == AnimationHelper.SLIDE_BOTTOM_DIRECTION)
    return "marginTop";
   return "marginLeft";
  },
  createSlideTransition: function (animationContainer, direction, complete, animationEngineType) {
   var animationEngine = "";
   switch(animationEngineType) {
    case AnimationEngineType.JS:
     animationEngine = "js";
     break;
    case AnimationEngineType.CSS:
     animationEngine = "css";
     break;
   }
   return AnimationHelper.createAnimationTransition(animationContainer.firstChild, {
    unit: "px",
    property: AnimationHelper.getModifyProperty(direction),
    onComplete: complete,
    animationEngine: animationEngine
   });
  },
  getSlideInStartPos: function (animationContainer, direction) {
   switch (direction) {
    case AnimationHelper.SLIDE_TOP_DIRECTION:
     return animationContainer.offsetHeight;
    case AnimationHelper.SLIDE_LEFT_DIRECTION:
     return animationContainer.offsetWidth;
    case AnimationHelper.SLIDE_RIGHT_DIRECTION:
     return -animationContainer.offsetWidth;
    case AnimationHelper.SLIDE_BOTTOM_DIRECTION:
     return -animationContainer.offsetHeight;
   }
  },
  getSlideOutFinishPos: function (animationContainer, direction) {
   switch (direction) {
    case AnimationHelper.SLIDE_TOP_DIRECTION:
     return -animationContainer.offsetHeight;
    case AnimationHelper.SLIDE_LEFT_DIRECTION:
     return -animationContainer.offsetWidth;
    case AnimationHelper.SLIDE_RIGHT_DIRECTION:
     return animationContainer.offsetWidth;
    case AnimationHelper.SLIDE_BOTTOM_DIRECTION:
     return animationContainer.offsetHeight;
   }
  }
 };
 var GestureHandler = ASPx.CreateClass(null, {
  constructor: function (getAnimationElement, canHandle, allowStart) {
   this.getAnimationElement = getAnimationElement;
   this.canHandle = canHandle;
   this.allowStart = allowStart;
   this.startMousePosX = 0;
   this.startMousePosY = 0;
   this.startTime = null;
   this.isEventsPrevented = false;
   this.savedElements = [];
  },
  OnSelectStart: function(evt) {
   ASPx.Evt.PreventEvent(evt); 
  },
  OnDragStart: function(evt) {
   ASPx.Evt.PreventEvent(evt);  
  },
  OnMouseDown: function (evt) {
   this.startMousePosX = ASPx.Evt.GetEventX(evt);
   this.startMousePosY = ASPx.Evt.GetEventY(evt);
   this.startTime = new Date();
  },
  OnMouseMove: function(evt) {
   if(!ASPx.Browser.MobileUI)
    ASPx.Selection.Clear();
   if(Math.abs(this.GetCurrentDistanceX(evt)) < GestureHandler.SLIDER_MIN_START_DISTANCE && Math.abs(this.GetCurrentDistanceY(evt)) < GestureHandler.SLIDER_MIN_START_DISTANCE)
    GesturesHelper.isExecutedGesture = false;
  },
  OnMouseUp: function (evt) {
  },
  CanHandleEvent: function (evt) {
   return !this.canHandle || this.canHandle(evt);
  },
  IsStartAllowed: function(value) {
   return !this.allowStart || this.allowStart(value);
  },
  RollbackGesture: function () {
  },
  GetRubberPosition: function (position) {
   return position / GestureHandler.FACTOR_RUBBER;
  },
  GetCurrentDistanceX: function (evt) {
   return ASPx.Evt.GetEventX(evt) - this.startMousePosX;
  },
  GetCurrentDistanceY: function (evt) {
   return ASPx.Evt.GetEventY(evt) - this.startMousePosY;
  },
  GetDistanceLimit: function () {
   return (new Date() - this.startTime) < GestureHandler.MAX_TIME_SPAN ? GestureHandler.MIN_DISTANCE_LIMIT : GestureHandler.MAX_DISTANCE_LIMIT;
  },
  GetContainerElement: function () {
  },
  AttachPreventEvents: function (evt) {
   if(!this.isEventsPrevented) {
    var element = ASPx.Evt.GetEventSource(evt);
    var container = this.GetContainerElement();
    while(element && element != container) {
     ASPx.Evt.AttachEventToElement(element, "mouseup", ASPx.Evt.PreventEvent);
     ASPx.Evt.AttachEventToElement(element, "click", ASPx.Evt.PreventEvent);
     this.savedElements.push(element);
     element = element.parentNode;
    }
    this.isEventsPrevented = true;
   }
  },
  DetachPreventEvents: function () {
   if(this.isEventsPrevented) {
    window.setTimeout(function () {
     while(this.savedElements.length > 0) {
      var element = this.savedElements.pop();
      ASPx.Evt.DetachEventFromElement(element, "mouseup", ASPx.Evt.PreventEvent);
      ASPx.Evt.DetachEventFromElement(element, "click", ASPx.Evt.PreventEvent);
     }
    }.aspxBind(this), 0);
    this.isEventsPrevented = false;
   }
  }
 });
 GestureHandler.MAX_DISTANCE_LIMIT = 70;
 GestureHandler.MIN_DISTANCE_LIMIT = 10;
 GestureHandler.MIN_START_DISTANCE = 0;
 GestureHandler.SLIDER_MIN_START_DISTANCE = 5;
 GestureHandler.MAX_TIME_SPAN = 300;
 GestureHandler.FACTOR_RUBBER = 4;
 GestureHandler.RETURN_ANIMATION_DURATION = 150;
 var SwipeSlideGestureHandler = ASPx.CreateClass(GestureHandler, {
  constructor: function (getAnimationElement, direction, canHandle, backward, forward, rollback, move) {
   this.constructor.prototype.constructor.call(this, getAnimationElement, canHandle);
   this.slideElement = this.getAnimationElement();
   this.container = this.slideElement.parentNode;
   this.direction = direction;
   this.backward = backward;
   this.forward = forward;
   this.rollback = rollback;
   this.slideElementSize = 0;
   this.containerElementSize = 0;
   this.startSliderElementPosition = 0;
   this.centeredSlideElementPosition = 0;
  },
  OnMouseDown: function (evt) {
   GestureHandler.prototype.OnMouseDown.call(this, evt);
   this.slideElementSize = this.GetElementSize();
   this.startSliderElementPosition = this.GetElementPosition();
   this.containerElementSize = this.GetContainerElementSize();
   if(this.slideElementSize <= this.containerElementSize)
    this.centeredSlideElementPosition = (this.containerElementSize - this.slideElementSize) / 2;
  },
  OnMouseMove: function (evt) {
   GestureHandler.prototype.OnMouseMove.call(this, evt);
   if(!ASPx.Browser.TouchUI && !ASPx.GetIsParent(this.container, ASPx.Evt.GetEventSource(evt))) {
    GesturesHelper.OnDocumentMouseUp(evt);
    return;
   }
   var distance = this.GetCurrentDistance(evt);
   if(Math.abs(distance) < GestureHandler.SLIDER_MIN_START_DISTANCE || ASPx.TouchUIHelper.isGesture)
    return;
   this.SetElementPosition(this.GetCalculatedPosition(distance));
   this.AttachPreventEvents(evt);
   ASPx.Evt.PreventEvent(evt);
  },
  GetCalculatedPosition: function (distance) {
   ASPx.AnimationTransitionBase.Cancel(this.slideElement);
   var position = this.startSliderElementPosition + distance,
    maxPosition = -(this.slideElementSize - this.containerElementSize),
    minPosition = 0;
   if(this.centeredSlideElementPosition > 0)
    position = this.GetRubberPosition(distance) + this.centeredSlideElementPosition;
   else if(position > minPosition)
    position = this.GetRubberPosition(distance);
   else if(position < maxPosition)
    position = this.GetRubberPosition(distance) + maxPosition;
   return position;
  },
  OnMouseUp: function (evt) {
   this.DetachPreventEvents();
   if(this.GetCurrentDistance(evt) != 0)
    this.OnMouseUpCore(evt);
  },
  OnMouseUpCore: function (evt) {
   var distance = this.GetCurrentDistance(evt);
   if(this.centeredSlideElementPosition > 0 || this.CheckSlidePanelIsOutOfBounds())
    this.PerformRollback();
   else
    this.PerformAction(distance);
  },
  PerformAction: function (distance) {
   if(Math.abs(distance) < this.GetDistanceLimit())
    this.PerformRollback();
   else if(distance < 0)
    this.PerformForward();
   else
    this.PerformBackward();
  },
  PerformBackward: function () {
   this.backward();
  },
  PerformForward: function () {
   this.forward();
  },
  PerformRollback: function () {
   this.rollback();
  },
  CheckSlidePanelIsOutOfBounds: function () {
   var minOffset = -(this.slideElementSize - this.containerElementSize), maxOffset = 0;
   var slideElementPos = this.GetElementPosition();
   if(slideElementPos > maxOffset || slideElementPos < minOffset)
    return true;
   return false;
  },
  GetContainerElement: function () {
   return this.container;
  },
  GetElementSize: function () {
   return this.IsHorizontalDirection() ? this.slideElement.offsetWidth : this.slideElement.offsetHeight;
  },
  GetContainerElementSize: function () {
   return this.IsHorizontalDirection() ? ASPx.GetClearClientWidth(this.container) : ASPx.GetClearClientHeight(this.container);
  },
  GetCurrentDistance: function (evt) {
   return this.IsHorizontalDirection() ? this.GetCurrentDistanceX(evt) : this.GetCurrentDistanceY(evt);
  },
  GetElementPosition: function () {
   return ASPx.AnimationUtils.GetTransformValue(this.slideElement, !this.IsHorizontalDirection());
  },
  SetElementPosition: function (position) {
   ASPx.AnimationUtils.SetTransformValue(this.slideElement, position, !this.IsHorizontalDirection());
  },
  IsHorizontalDirection: function () {
   return this.direction == AnimationHelper.SLIDE_HORIZONTAL_DIRECTION;
  }
 });
 var SwipeSimpleSlideGestureHandler = ASPx.CreateClass(SwipeSlideGestureHandler, {
  constructor: function (getAnimationElement, direction, canHandle, backward, forward, rollback, updatePosition) {
   this.constructor.prototype.constructor.call(this, getAnimationElement, direction, canHandle, backward, forward, rollback);
   this.container = this.slideElement;
   this.updatePosition = updatePosition;
   this.prevDistance = 0;
  },
  OnMouseDown: function (evt) {
   GestureHandler.prototype.OnMouseDown.call(this, evt);
   this.prevDistance = 0;
  },
  OnMouseUpCore: function (evt) {
   this.PerformAction(this.GetCurrentDistance(evt));
  },
  PerformAction: function (distance) {
   if(Math.abs(distance) < this.GetDistanceLimit())
    this.PerformRollback();
   else if(distance < 0)
    this.PerformForward();
   else
    this.PerformBackward();
  },
  GetCalculatedPosition: function (distance) {
   var position = distance - this.prevDistance;
   this.prevDistance = distance;
   return position;
  },
  SetElementPosition: function (position) {
   this.updatePosition(position);
  }
 });
 var SwipeGestureHandler = ASPx.CreateClass(GestureHandler, {
  constructor: function (getAnimationElement, canHandle, allowStart, start, allowComplete, complete, cancel, animationEngineType) {
   this.constructor.prototype.constructor.call(this, getAnimationElement, canHandle, allowStart);
   this.start = start;
   this.allowComplete = allowComplete;
   this.complete = complete;
   this.cancel = cancel;
   this.animationTween = null;
   this.currentDistanceX = 0;
   this.currentDistanceY = 0;
   this.tryStartGesture = false;
   this.tryStartScrolling = false;
   this.animationEngineType = animationEngineType;
   this.UpdateAnimationContainer();
  },
  UpdateAnimationContainer: function () {
   this.animationContainer = AnimationHelper.getSlideAnimationContainer(this.getAnimationElement(), true, false);
  },
  CanHandleEvent: function (evt) {
   if(GestureHandler.prototype.CanHandleEvent.call(this, evt))
    return true;
   return this.animationTween && this.animationContainer && ASPx.GetIsParent(this.animationContainer, ASPx.Evt.GetEventSource(evt));
  },
  OnMouseDown: function (evt) {
   GestureHandler.prototype.OnMouseDown.call(this, evt);
   if(this.animationTween)
    this.animationTween.Cancel();
   this.currentDistanceX = 0;
   this.currentDistanceY = 0;
   this.tryStartGesture = false;
   this.tryStartScrolling = false;
  },
  OnMouseMove: function (evt) {
   GestureHandler.prototype.OnMouseMove.call(this, evt);
   var isZoomGestureConflict = evt.touches && evt.touches.length > 1;
   if (isZoomGestureConflict)
    return false;
   this.currentDistanceX = this.GetCurrentDistanceX(evt);
   this.currentDistanceY = this.GetCurrentDistanceY(evt);
   if(!this.animationTween && !this.tryStartScrolling && (Math.abs(this.currentDistanceX) >
    GestureHandler.MIN_START_DISTANCE || Math.abs(this.currentDistanceY) > GestureHandler.MIN_START_DISTANCE)) {
    if(Math.abs(this.currentDistanceY) < Math.abs(this.currentDistanceX)) {
     this.tryStartGesture = true;
     if(this.IsStartAllowed(this.currentDistanceX)) {
      this.animationContainer = AnimationHelper.getSlideAnimationContainer(this.getAnimationElement(), true, true);
      this.animationTween = AnimationHelper.createSlideTransition(this.animationContainer, AnimationHelper.SLIDE_LEFT_DIRECTION,
       function () {
        AnimationHelper.resetSlideAnimationContainerSize(this.animationContainer);
        this.animationContainer = null;
        this.animationTween = null;
       }.aspxBind(this), this.animationEngineType);
      this.PerformStart(this.currentDistanceX);
      this.AttachPreventEvents(evt);
     }
    }
    else
     this.tryStartScrolling = true;
   }
   if(this.animationTween) {
    if(this.allowComplete && !this.allowComplete(this.currentDistanceX))
     this.currentDistanceX = this.GetRubberPosition(this.currentDistanceX);
    this.animationTween.SetValue(this.currentDistanceX);
   }
   if(!this.tryStartScrolling && !ASPx.TouchUIHelper.isGesture && evt.touches && evt.touches.length < 2)
    ASPx.Evt.PreventEvent(evt);
  },
  OnMouseUp: function (evt) {
   if(!this.animationTween) {
    if(this.tryStartGesture)
     this.PerformCancel(this.currentDistanceX);
   }
   else {
    if(Math.abs(this.currentDistanceX) < this.GetDistanceLimit())
     this.RollbackGesture();
    else {
     if(this.IsCompleteAllowed(this.currentDistanceX)) {
      this.PerformComplete(this.currentDistanceX);
      this.animationContainer = null;
      this.animationTween = null;
     }
     else
      this.RollbackGesture();
    }
   }
   this.DetachPreventEvents();
   this.tryStartGesture = false;
   this.tryStartScrolling = false;
  },
  PerformStart: function (value) {
   if(this.start)
    this.start(value);
  },
  IsCompleteAllowed: function (value) {
   return !this.allowComplete || this.allowComplete(value);
  },
  PerformComplete: function (value) {
   if(this.complete)
    this.complete(value);
  },
  PerformCancel: function (value) {
   if(this.cancel)
    this.cancel(value);
  },
  RollbackGesture: function () {
   this.animationTween.Start(this.currentDistanceX, 0);
  },
  ResetGestureElementPosition: function () {
   if (this.currentDistanceX === 0) return;
   var container = AnimationHelper.getSlideAnimationContainer(this.getAnimationElement());
   var onComplete = function () {  AnimationHelper.resetSlideAnimationContainerSize(container);  };
   var animation = AnimationHelper.createSlideTransition(container, AnimationHelper.SLIDE_LEFT_DIRECTION, onComplete, this.animationEngineType);
   animation.Start(this.currentDistanceX, 0);
  },
  GetContainerElement: function () {
   return this.animationContainer;
  }
 });
 var GesturesHelper = {
  handlers: {},
  activeHandler: null,
  isAttachedEvents: false,
  isExecutedGesture: false,
  AddSwipeGestureHandler: function (id, getAnimationElement, canHandle, allowStart, start, allowComplete, complete, cancel, animationEngineType) {
   this.handlers[id] = new SwipeGestureHandler(getAnimationElement, canHandle, allowStart, start, allowComplete, complete, cancel, animationEngineType);
  },
  UpdateSwipeAnimationContainer: function (id) {
   if(this.handlers[id])
    this.handlers[id].UpdateAnimationContainer();
  },
  AddSwipeSlideGestureHandler: function (id, getAnimationElement, direction, canHandle, backward, forward, rollback, updatePosition) {
   if(updatePosition)
    this.handlers[id] = new SwipeSimpleSlideGestureHandler(getAnimationElement, direction, canHandle, backward, forward, rollback, updatePosition);
   else
    this.handlers[id] = new SwipeSlideGestureHandler(getAnimationElement, direction, canHandle, backward, forward, rollback);
  },
  getParentDXEditorWithSwipeGestures: function(element) {
     return ASPx.GetParent(element, function(parent) {
      var parentObj = ASPx.GetControlCollection().Get(parent.id);
      return parentObj && parentObj.supportGestures && parentObj.isSwipeGesturesEnabled();
   });
  },
  canHandleMouseDown: function(evt) {
   if(!ASPx.Evt.IsLeftButtonPressed(evt))
    return false;
   var element = ASPx.Evt.GetEventSource(evt);
   var dxFocusedEditor = ASPx.Ident.scripts.ASPxClientEdit && ASPx.GetFocusedEditor();
   if(dxFocusedEditor && dxFocusedEditor.IsEditorElement(element)) {
    var elementParentDXEditorWithSwipeGestures = GesturesHelper.getParentDXEditorWithSwipeGestures(element);
    if(!elementParentDXEditorWithSwipeGestures || !dxFocusedEditor.IsEditorElement(elementParentDXEditorWithSwipeGestures))
     return false;
   }
   var isTextEditor = element.tagName == "TEXTAREA" || element.tagName == "INPUT" && ASPx.Attr.GetAttribute(element, "type") == "text";
   if(isTextEditor && document.activeElement == element)
    return false;
   return true;  
  },
  OnDocumentDragStart: function(evt) {
   if(GesturesHelper.activeHandler)
    GesturesHelper.activeHandler.OnDragStart(evt);
  },
  OnDocumentSelectStart: function(evt) {
   if(GesturesHelper.activeHandler)
    GesturesHelper.activeHandler.OnSelectStart(evt);
  },
  OnDocumentMouseDown: function (evt) {
   if(!GesturesHelper.canHandleMouseDown(evt))
    return;
   GesturesHelper.activeHandler = GesturesHelper.FindHandler(evt);
   if(GesturesHelper.activeHandler)
    GesturesHelper.activeHandler.OnMouseDown(evt);
  },
  OnDocumentMouseMove: function (evt) {
   if(GesturesHelper.activeHandler) {
    GesturesHelper.isExecutedGesture = true;
    GesturesHelper.activeHandler.OnMouseMove(evt);
   }
  },
  OnDocumentMouseUp: function (evt) {
   if(GesturesHelper.activeHandler) {
    GesturesHelper.activeHandler.OnMouseUp(evt);
    GesturesHelper.activeHandler = null;
    window.setTimeout(function () { GesturesHelper.isExecutedGesture = false; }, 0);
   }
  },
  AttachEvents: function () {
   if(!GesturesHelper.isAttachedEvents) {
    GesturesHelper.Attach(ASPx.Evt.AttachEventToElement);
    GesturesHelper.isAttachedEvents = true;
   }
  },
  DetachEvents: function () {
   if(GesturesHelper.isAttachedEvents) {
    GesturesHelper.Attach(ASPx.Evt.DetachEventFromElement);
    GesturesHelper.isAttachedEvents = false;
   }
  },
  Attach: function (changeEventsMethod) {
   var doc = window.document;
   changeEventsMethod(doc, ASPx.TouchUIHelper.touchMouseDownEventName, GesturesHelper.OnDocumentMouseDown);
   changeEventsMethod(doc, ASPx.TouchUIHelper.touchMouseMoveEventName, GesturesHelper.OnDocumentMouseMove);
   changeEventsMethod(doc, ASPx.TouchUIHelper.touchMouseUpEventName, GesturesHelper.OnDocumentMouseUp);
   if(!ASPx.Browser.MobileUI) {
    changeEventsMethod(doc, "selectstart", GesturesHelper.OnDocumentSelectStart);
    changeEventsMethod(doc, "dragstart", GesturesHelper.OnDocumentDragStart);
   }
  },
  FindHandler: function (evt) {
   var handlers = [];
   for(var id in GesturesHelper.handlers) {
    if(GesturesHelper.handlers.hasOwnProperty(id)) {
     var handler = GesturesHelper.handlers[id];
     if(handler.CanHandleEvent && handler.CanHandleEvent(evt))
      handlers.push(handler);
    }
   }
   if(!handlers.length)
    return null;
   handlers.sort(function (a, b) {
    return ASPx.GetIsParent(a.getAnimationElement(), b.getAnimationElement()) ? 1 : -1;
   });
   return handlers[0];
  },
  IsExecutedGesture: function () {
   return GesturesHelper.isExecutedGesture;
  }
 };
 GesturesHelper.AttachEvents();
 var AnimationEngineType = {
  "JS": 0,
  "CSS": 1,
  "DEFAULT" : 2
 };
 ASPx.AnimationEngineType = AnimationEngineType;
 ASPx.AnimationHelper = AnimationHelper;
 ASPx.GesturesHelper = GesturesHelper;
})();

(function() {
 var customScrollableElementsCollection = [];
 var SCROLLBAR_CLASSNAMES = {
  VERTICAL: "dxTouchVScrollHandle",
  HORIZONTAL: "dxTouchHScrollHandle",
  SHOWN_VERTICAL: "dxTouchScrollHandleVisible",
  SHOWN_HORIZONTAL: "dxTouchScrollHandleVisible",
  CUSTOMIZED_NATIVE: "dxTouchNativeScrollHandle"
 };
 ASPx.Evt.AttachEventToDocument("gesturestart", function() { 
  ASPx.TouchUIHelper.isGesture = true; 
 });
 ASPx.Evt.AttachEventToDocument("gestureend", function() { 
  ASPx.TouchUIHelper.isGesture = false; 
 });
 ASPx.TouchUIHelper.MakeScrollable = function(element, options) {
  return new ASPx.TouchUIHelper.ScrollExtender(element, options);
 };
 ASPx.TouchUIHelper.ScrollExtender = function(element, options) {
  this.parseOptions(options ? options : {});
  this.create(element);
 };
 ASPx.TouchUIHelper.preventScrollOnEvent = function(evt){
  evt.ASPxTouchUIScrollOff = true;
 };
 var isCustomScroll = function(elem) { return ASPx.Data.ArrayContains(customScrollableElementsCollection, elem); };
 var isNativeScroll = function(elem) {
  var style = window.getComputedStyle(elem);
  return ["overflow", "overflow-x", "overflow-y"].some(function(prop) {
   return ASPx.Data.ArrayContains(["scroll","auto"], style[prop]);
  });
 };
 var requirePreventCustomScroll = function(elem, scrollElement) {
  if(!scrollElement)
   return;
  while(elem && elem !== scrollElement && elem.tagName !== 'BODY') {
   if(isNativeScroll(elem) || isCustomScroll(elem))
    return true;
   elem = elem.parentNode;
  }
  return false;
 };
 ASPx.TouchUIHelper.RequirePreventCustomScroll = requirePreventCustomScroll;
 ASPx.TouchUIHelper.InitNativeScrolling = function(element, options) {
  if(options.showHorizontalScrollbar || options.showVerticalScrollbar){
   element.style["overflow"] = "scroll";
   element.style["overflow-x"] = options.showHorizontalScrollbar ? "scroll" : "hidden";
   element.style["overflow-y"] = options.showVerticalScrollbar ? "scroll" : "hidden";
   element.style["-webkit-overflow-scrolling"] = "touch";
   if(options.customizeNativeScrolling)
    ASPx.AddClassNameToElement(element, SCROLLBAR_CLASSNAMES.CUSTOMIZED_NATIVE);
  }
 };
 ASPx.TouchUIHelper.ScrollExtender.prototype = {
  ChangeElement: function(element){
   this.Destroy();
   this.create(element);
  },
  Destroy: function () {
   this.destroyScrollHandlers();
   this.detachEventHandlers();
   ASPx.Data.ArrayRemove(customScrollableElementsCollection, this.element);
  },
  acceptElement: function(element) {
   if(typeof(element) == "string")
    element = document.getElementById(element);
   this.element = element;
   this.touchEventHandlersElement = this.options.touchEventHandlersElement ? this.options.touchEventHandlersElement : this.element;
   if(ASPx.Browser.AndroidMobilePlatform){
    element.style["overflow-x"] = "hidden";
    element.style["overflow-y"] = "hidden";
   }
   return element;
  },
  create: function(element) {
   this.acceptElement(element);
   if(this.options.nativeScrolling) {
    ASPx.TouchUIHelper.InitNativeScrolling(this.element, this.options);
   } else {
    customScrollableElementsCollection.push(this.element);
    if(ASPx.Browser.IE) {
     this.msGesture = new MSGesture();
     this.msGesture.target = this.element;
     this.pointerCount = 0;
    }
    this.createScrollHandlers();
    this.createEventHandlers();
    this.updateInitData();
    this.updateScrollHandles();
    this.attachEventHandlers();
   }
  },
  parseOptions: function(options) {
   this.options = {};
   this.options.showHorizontalScrollbar = options.showHorizontalScrollbar !== false;
   this.options.showVerticalScrollbar = options.showVerticalScrollbar !== false;
   this.options.acceleration = options.acceleration || 0.8;
   this.options.timeStep = options.timeStep || 50;
   this.options.minScrollbarSize = options.minScrollbarSize || 20;
   this.options.vScrollClassName = options.vScrollClassName || SCROLLBAR_CLASSNAMES.VERTICAL;
   this.options.hScrollClassName = options.hScrollClassName || SCROLLBAR_CLASSNAMES.HORIZONTAL;
   this.options.vScrollClassNameShown = [
    this.options.vScrollClassName, 
    options.vScrollClassNameShown || SCROLLBAR_CLASSNAMES.SHOWN_VERTICAL
   ].join(" ");
   this.options.hScrollClassNameShown = [
    this.options.hScrollClassName, 
    options.hScrollClassNameShown || SCROLLBAR_CLASSNAMES.SHOWN_HORIZONTAL
   ].join(" ");
   this.options.forceCustomScroll = options.forceCustomScroll === true;
   var nativeScrollPossible = !options.acceleration && !options.timeStep && !options.minScrollbarSize && !options.vScrollClassName && !options.hScrollClassName && !options.forceCustomScroll;
   if (nativeScrollPossible && ASPx.TouchUIHelper.IsNativeScrolling())
    this.options.nativeScrolling = true;
   if(ASPx.Browser.AndroidMobilePlatform && ASPx.Browser.WebKitFamily)
    this.options.customizeNativeScrolling = true;
   this.options.touchEventHandlersElement = options.touchEventHandlersElement;
   this.options.scrollPageIfCannotScrollDiv = options.scrollPageIfCannotScrollDiv === true;
  },
  createEventHandlers: function() {
   var instance = this;
   this.onTouchStart = function(e) {
    if(ASPx.Browser.IE) {
     instance.pointerCount++;
     instance.msGesture.addPointer(e.pointerId);
     if(instance.pointerCount != 1) return;
    }
    if(!ASPx.TouchUIHelper.isGesture){
     if(!ASPx.TouchUIHelper.ScrollExtender.activeScrolling) {
      if(requirePreventCustomScroll(ASPx.Evt.GetEventSource(e), instance.touchEventHandlersElement)) {
       e.stopPropagation();
       return;
      }
      ASPx.TouchUIHelper.ScrollExtender.activeScrolling = instance;
      instance.startScroll(e);
     }
    }
   };
   this.onTouchMove = function(e) {
    if(ASPx.Browser.IE && instance.pointerCount != 1) return;
    if(!ASPx.TouchUIHelper.isGesture && instance.ScrollingActive(e)) {
     var scrolled = instance.scroll(e);
     var alwaysPreventDefault = !instance.options.scrollPageIfCannotScrollDiv;
     if((instance.scrollBarsShown && alwaysPreventDefault) || (!alwaysPreventDefault && scrolled))
      e.preventDefault();
    }
   };
   this.onTouchEnd = function(e) {
    if(ASPx.Browser.IE) {
     if(instance.pointerCount == 0) return;
     instance.pointerCount--;
    }
    if(!ASPx.TouchUIHelper.isGesture) {
     instance.scrollLeft = instance.element.scrollLeft;
     instance.scrollTop = instance.element.scrollTop;
     instance.stopScroll();
     if(ASPx.TouchUIHelper.ScrollExtender.activeScrolling && ASPx.TouchUIHelper.ScrollExtender.activeScrolling.initTouchX == instance.initTouchX && ASPx.TouchUIHelper.ScrollExtender.activeScrolling.initTouchY == instance.initTouchY)
      instance.MouseEventEmulationProtectHelper.onTouchEnd(instance.initTouchX, instance.initTouchY, e);
     instance.ReleaseScrolling();
    }
   };
   this.onScroll = function(e) {
    if(ASPx.TouchUIHelper.isGesture && instance.ScrollingActive(e)) {
     instance.showScrollBars();
     instance.updateScrollHandles();
    }
   };
   this.onClick = function() {
    instance.MouseEventEmulationProtectHelper.onClick();
   };
  },
  createScrollHandlers: function() {
   if(this.options.showHorizontalScrollbar) {
    this.hScrollHandleElement = document.createElement("DIV");
    this.hScrollHandleElement.className = this.options.hScrollClassName;
    this.element.appendChild(this.hScrollHandleElement);
    this.hEndMargin = this.options.showVerticalScrollbar ? ASPx.PxToInt(ASPx.GetCurrentStyle(this.hScrollHandleElement).marginRight) : 0;
   }
   if(this.options.showVerticalScrollbar) {
    this.vScrollHandleElement = document.createElement("DIV");
    this.vScrollHandleElement.className = this.options.vScrollClassName;
    this.element.appendChild(this.vScrollHandleElement);
    this.vEndMargin = this.options.showHorizontalScrollbar ? ASPx.PxToInt(ASPx.GetCurrentStyle(this.vScrollHandleElement).marginBottom) : 0;
   }
  },
  destroyScrollHandlers: function() {
   if(this.hScrollHandleElement && this.hScrollHandleElement.parentNode)
    this.hScrollHandleElement.parentNode.removeChild(this.hScrollHandleElement);
   if(this.vScrollHandleElement && this.vScrollHandleElement.parentNode)
    this.vScrollHandleElement.parentNode.removeChild(this.vScrollHandleElement);
   this.hScrollHandleElement = null;
   this.vScrollHandleElement = null;
  },
  attachEventHandlers: function() {
   if(ASPx.Browser.WebKitTouchUI) {
    this.touchEventHandlersElement.addEventListener("touchstart", this.onTouchStart, false);
    this.touchEventHandlersElement.addEventListener("touchend"  , this.onTouchEnd  , false);
    this.touchEventHandlersElement.addEventListener("touchmove" , this.onTouchMove , false);
   } else if (ASPx.Browser.IE) {
    this.touchEventHandlersElement.addEventListener(ASPx.TouchUIHelper.pointerDownEventName  , this.onTouchStart, false);
    this.touchEventHandlersElement.addEventListener('MSGestureEnd'         , this.onTouchEnd  , false);
    this.touchEventHandlersElement.addEventListener(ASPx.TouchUIHelper.pointerUpEventName , this.onTouchEnd  , false);
    this.touchEventHandlersElement.addEventListener(ASPx.TouchUIHelper.pointerCancelEventName, this.onTouchEnd  , false);
    this.touchEventHandlersElement.addEventListener(ASPx.TouchUIHelper.pointerMoveEventName  , this.onTouchMove , false);
   }
   this.touchEventHandlersElement.addEventListener("scroll", this.onScroll, false);
   this.touchEventHandlersElement.addEventListener("click" , this.onClick , false);
  },
  detachEventHandlers: function() {
   if(ASPx.Browser.WebKitTouchUI) {
    this.touchEventHandlersElement.removeEventListener("touchstart", this.onTouchStart, false);
    this.touchEventHandlersElement.removeEventListener("touchend"  , this.onTouchEnd  , false);
    this.touchEventHandlersElement.removeEventListener("touchmove" , this.onTouchMove , false);
   } else if (ASPx.Browser.IE) {
    this.touchEventHandlersElement.removeEventListener(ASPx.TouchUIHelper.pointerDownEventName  , this.onTouchStart, false);
    this.touchEventHandlersElement.removeEventListener('MSGestureEnd'         , this.onTouchEnd  , false);
    this.touchEventHandlersElement.removeEventListener(ASPx.TouchUIHelper.pointerUpEventName , this.onTouchEnd  , false);
    this.touchEventHandlersElement.removeEventListener(ASPx.TouchUIHelper.pointerCancelEventName, this.onTouchEnd  , false);
    this.touchEventHandlersElement.removeEventListener(ASPx.TouchUIHelper.pointerMoveEventName  , this.onTouchMove , false);
   }
   this.touchEventHandlersElement.removeEventListener("scroll", this.onScroll, false);
   this.touchEventHandlersElement.removeEventListener("click" , this.onClick , false);
  },
  updateInitData: function() {
   window.clearTimeout(this.inertialStopTimerId);
   this.initScrollLeft = this.element.scrollLeft;
   this.initScrollTop = this.element.scrollTop;
   this.scrollLeft = this.initScrollLeft;
   this.scrollTop = this.initScrollTop;
   this.initElementX = ASPx.GetAbsoluteX(this.element);
   this.initElementY = ASPx.GetAbsoluteY(this.element);
   this.scrollTime = new Date();
   this.vx = 0;
   this.vy = 0;
   this.vxs = [];
   this.vys = [];
  },
  ScrollingActive: function(e){
   return (!e || !e.ASPxTouchUIScrollOff) && ASPx.TouchUIHelper.ScrollExtender.activeScrolling == this;
  },
  ReleaseScrolling: function(){
   if(this.ScrollingActive())
    ASPx.TouchUIHelper.ScrollExtender.activeScrolling = null;
  },
  startScroll: function(e) {
   this.initTouchX = ASPx.TouchUIHelper.getEventX(e);
   this.initTouchY = ASPx.TouchUIHelper.getEventY(e);
   this.lastTouchX = this.initTouchX;
   this.lastTouchY = this.initTouchY;
   this.updateInitData();
   this.updateScrollHandles();
   this.showScrollBars();
  },
  scroll: function(e) {
   var el = this.element;
   var opts = this.options;
   var currentTouchX = ASPx.TouchUIHelper.getEventX(e);
   var currentTouchY = ASPx.TouchUIHelper.getEventY(e);
   var newX = this.initScrollLeft + (this.initTouchX - currentTouchX);
   var newY = this.initScrollTop  + (this.initTouchY - currentTouchY);
   var dt = (new Date() - this.scrollTime);
   if(dt < 1) dt = 1;
   var dx = this.lastTouchX - currentTouchX;
   var dy = this.lastTouchY - currentTouchY;
   this.lastTouchX = currentTouchX;
   this.lastTouchY = currentTouchY;
   this.vx = dx / dt;
   this.vy = dy / dt;
   this.vxs.push(this.vx);
   this.vys.push(this.vy);
   var applyScrollX = opts.showHorizontalScrollbar;
   var applyScrollY = opts.showVerticalScrollbar;
   var stuck = false;
   if (opts.scrollPageIfCannotScrollDiv) {
    var sensitivity = 5;
    var dxSignificant = Math.abs(dx) > sensitivity;
    var dySignificant = Math.abs(dy) > sensitivity;
    var xStuck = !applyScrollX;
    var yStuck = !applyScrollY;
    xStuck = xStuck || (this.scrollLeft == 0 && dx < 0);
    xStuck = xStuck || (this.scrollLeft == el.scrollWidth - el.clientWidth && dx > 0);
    xStuck = xStuck && dxSignificant && Math.abs(dx) > Math.abs(dy);
    yStuck = yStuck || (this.scrollTop == 0 && dy < 0);
    yStuck = yStuck || (this.scrollTop == el.scrollHeight - el.clientHeight && dy > 0);
    yStuck = yStuck && dySignificant && Math.abs(dy) > Math.abs(dx);
    stuck = xStuck || yStuck;
    applyScrollX = !stuck;
    applyScrollY = !stuck;
   }
   if (applyScrollX) {
    this.scrollLeft = newX;
    el.scrollLeft = newX;
   }
   if (applyScrollY) {
    this.scrollTop = newY;
    el.scrollTop = newY;
   }
   if(stuck) {
    this.scrollLeft = el.scrollLeft;
    this.scrollTop = el.scrollTop;
   }
   this.updateScrollHandles();
   this.scrollTime = new Date();
   var scrolled = applyScrollX || applyScrollY;
   return scrolled;
  },
  stopScroll: function() {
   var instance = this;
   var element = this.element;
   var acceleration = this.options.acceleration;
   var timeStep = this.options.timeStep;
   if(this.vxs && this.vxs.length === 0) return;
   if(this.vxs){
    var countToSmooth = 3;
    var lenToSlice = Math.max(this.vxs.length - countToSmooth, 0);
    this.vxs = this.vxs.slice(lenToSlice);
    this.vys = this.vys.slice(lenToSlice);
    this.vx = Math.min.apply(null, this.vxs);
    if(this.vx < 0)
     this.vx = Math.max.apply(null, this.vxs);
    this.vy = Math.min.apply(null, this.vys);
    if(this.vy < 0)
     this.vy = Math.max.apply(null, this.vys);
    delete this.vxs;
    delete this.vys;
   }
   this.inertialStopTimerId = window.setTimeout(function() {
    instance.vx *= acceleration;
    instance.vy *= acceleration;
    if(Math.abs(instance.vx) < 0.1)
     instance.vx = 0;
    if(Math.abs(instance.vy) < 0.1) 
     instance.vy = 0;
    if(instance.vx == 0 && instance.vy == 0) {
     instance.hideScrollBars();
     return;
    }
    var dx = Math.ceil(instance.vx * timeStep);
    var dy = Math.ceil(instance.vy * timeStep);
    if(instance.options.showHorizontalScrollbar){
     instance.scrollLeft += dx;
     element.scrollLeft = instance.scrollLeft;
    }
    if(instance.options.showVerticalScrollbar){
     instance.scrollTop += dy;
     element.scrollTop = instance.scrollTop;
    }
    if(element.scrollLeft + element.clientWidth >= element.scrollWidth || element.scrollLeft <= 0)
     instance.vx = 0;
    if(element.scrollTop + element.clientHeight>= element.scrollHeight || element.scrollTop <= 0)
     instance.vy = 0;
    instance.updateScrollHandles();
    instance.stopScroll();
   }, timeStep);
  },
  updateScrollHandles: function() {
   if(this.hScrollHandleElement) {
    var scrollHandler = this.calcScrollHandles(this.element.scrollWidth, this.element.clientWidth,
     this.options.minScrollbarSize, this.element.scrollLeft, this.hEndMargin);
    this.hScrollHandleElement.style.width = scrollHandler.size + "px";
    ASPx.SetAbsoluteX(this.hScrollHandleElement, this.initElementX + scrollHandler.pos);
    ASPx.SetAbsoluteY(this.hScrollHandleElement, this.initElementY + this.element.clientHeight - 
     this.hScrollHandleElement.offsetHeight);
   }
   if(this.vScrollHandleElement) {
    var scrollHandler = this.calcScrollHandles(this.element.scrollHeight, this.element.clientHeight,
     this.options.minScrollbarSize, this.element.scrollTop, this.vEndMargin);
    this.vScrollHandleElement.style.height = scrollHandler.size + "px";
    ASPx.SetAbsoluteX(this.vScrollHandleElement, this.initElementX + this.element.clientWidth - this.vScrollHandleElement.offsetWidth);
    ASPx.SetAbsoluteY(this.vScrollHandleElement, this.initElementY + scrollHandler.pos);
   }
  },
  calcScrollHandles: function(scrollSize, clientSize, scrollBarMinSize, scrollPos, endMargin) {
   var scrollBarSize = clientSize * clientSize / scrollSize;
   scrollBarSize = scrollBarSize > scrollBarMinSize ? scrollBarSize : scrollBarMinSize;
   var k = (scrollSize == clientSize) ? 0 :
    (clientSize - scrollBarSize - endMargin) / (scrollSize - clientSize);
   return {size:scrollBarSize, pos:scrollPos * k};
  },
  showScrollBars: function() {
   var needVScrollHandle = this.element.scrollHeight > this.element.clientHeight;
   var needHScrollHandle = this.element.scrollWidth > this.element.clientWidth;
   if(this.vScrollHandleElement && needVScrollHandle)
    this.vScrollHandleElement.className = this.options.vScrollClassNameShown;
   if(this.hScrollHandleElement && needHScrollHandle)
    this.hScrollHandleElement.className = this.options.hScrollClassNameShown;
   this.scrollBarsShown = needVScrollHandle || needHScrollHandle;
  },
  hideScrollBars: function() {
   if(this.vScrollHandleElement)
    this.vScrollHandleElement.className = this.options.vScrollClassName;
   if(this.hScrollHandleElement)
    this.hScrollHandleElement.className = this.options.hScrollClassName;
   this.scrollBarsShown = false;
  },
  MouseEventEmulationProtectHelper: {
   onTouchEnd: function(initTouchX, initTouchY, e) {
    var difX = initTouchX - ASPx.TouchUIHelper.getEventX(e);
    var difY = initTouchY - ASPx.TouchUIHelper.getEventY(e);
    if(Math.abs(difX) > ASPx.TouchUIHelper.clickSensetivity || Math.abs(difY) > ASPx.TouchUIHelper.clickSensetivity){
     ASPx.TouchUIHelper.isMouseEventFromScrolling = true;
     window.setTimeout(function(){ ASPx.TouchUIHelper.isMouseEventFromScrolling = false; }, 100);
    }
   },
   onClick: function(){
    if(ASPx.TouchUIHelper.isMouseEventFromScrolling){
     window.setTimeout(function(){ ASPx.TouchUIHelper.isMouseEventFromScrolling = false; }, 0);
    }
   }
  }
 };
 ASPx.TouchUIHelper.FastTapHelper = (function() {
  var actions = [];
  var DISTANCE_LIMIT = 10;
  var startX;
  var startY;
  var preventCommonClickEvents = false;
  var invokeActions = function(actions) {
   for(var i = 0; i < actions.length; i++)
    actions[i]();
  };
  var onTouchStart = function(e) {
   if(preventCommonClickEvents)
    e.stopPropagation();
   if(actions.length > 1)
    return;
   startX = e.touches[0].clientX;
   startY = e.touches[0].clientY;
   if(ASPx.Browser.AndroidDefaultBrowser)
    e.currentTarget.addEventListener("click", onClick, false);
   else
    e.currentTarget.addEventListener("touchend", onTouchEnd, false);
  };
  if(ASPx.Browser.AndroidDefaultBrowser) {
   var onClick = function(e) {
    invokeActions(actions);
    actions = [];
    e.currentTarget.removeEventListener("click", onClick, false);
   };
  } else {
   var onTouchEnd = function(e) {
    if(preventCommonClickEvents) {
     e.preventDefault();
     e.stopPropagation();
    }
    var stopX = e.changedTouches[0].clientX;
    var stopY = e.changedTouches[0].clientY;
    var distanceX = Math.abs(startX - stopX);
    var distanceY = Math.abs(startY - stopY);
    var allowClick = distanceX < DISTANCE_LIMIT && distanceY < DISTANCE_LIMIT;
    if(allowClick) {
     var actionsToInvoke = actions;
     setTimeout(function() { invokeActions(actionsToInvoke); }, 0);
    }
    actions = [];
    e.currentTarget.removeEventListener("touchend", onTouchEnd, false);
   };
  }
  return {
   HandleFastTap: function(e, tapAction, preventClickEvents) {
    if(e.touches.length > 1)
     return;
    preventCommonClickEvents = preventClickEvents;
    actions.push(tapAction);
    onTouchStart(e);
   }
  };
 })();
 ASPx.TouchUIHelper.doubleTapEventName = "dxDoubleTap";
 ASPx.TouchUIHelper.allowDoubleTapProcessing = function(e) {
  var DOUBLE_TAP_DELAY = 600;
  var DISTANCE_LIMIT = 10;
  var currentTapTime = e.timeStamp;
  var currentX = e.changedTouches[0].clientX;
  var currentY = e.changedTouches[0].clientY;
  var lastTapTime = this["lastTap"] || currentTapTime;
  var lastX = this["lastX"] || currentX;
  var lastY = this["lastY"] || currentY;
  this["lastTap"] = currentTapTime;
  this["lastX"] = currentX;
  this["lastY"] = currentY;
  var delay = currentTapTime - lastTapTime;
  return delay && delay <= DOUBLE_TAP_DELAY && e.touches.length === 1 &&
   Math.abs(currentX - lastX) <= DISTANCE_LIMIT &&
   Math.abs(currentY - lastY) <= DISTANCE_LIMIT;
 };
 ASPx.TouchUIHelper.AttachDoubleTapEventToElement = function(element, action) {
  var onTouchEnd = function(e) {
   e.currentTarget.removeEventListener("touchend", onTouchEnd, false);
   e[ASPx.TouchUIHelper.doubleTapEventName] = true;
   var startActionAfterFastTap = function() {
    window.setTimeout(function(){ action(e); }, 0);
   };
   startActionAfterFastTap();
  };
  var onTouchStart = function(e) {
   if(ASPx.TouchUIHelper.allowDoubleTapProcessing(e)) {
    var preventZoom = function() { e.preventDefault(); };
    preventZoom();
    e.currentTarget.addEventListener("touchend", onTouchEnd, false);
   }
  };
  element.addEventListener("touchstart", onTouchStart, false);
 };
 window.ASPxClientTouchUI = {};
 window.ASPxClientTouchUI.MakeScrollable = ASPx.TouchUIHelper.MakeScrollable;
 window.ASPxClientTouchUI.ScrollExtender = ASPx.TouchUIHelper.ScrollExtender;
})();
(function() {
var RelatedControlManager = {
 storage: { },
 GetRelatedCollection: function(masterName) {
  if(!this.storage[masterName])
   this.storage[masterName] = [ ];
  return this.storage[masterName];
 },
 RegisterRelatedControl: function(masterName, name) {
  this.GetRelatedCollection(masterName)[name] = name;
 },
 RegisterRelatedControls: function(masterName, names) {
  var relatedCollection = this.GetRelatedCollection(masterName);
  var name;
  for(var i = 0; i < names.length; i++) {
   name = names[i];
   relatedCollection[name] = name;
  }
 },
 GetLinkedControls: function(masterControl) {
  var result = [masterControl];
  var collection = this.GetRelatedCollection(masterControl.name); 
  for(var name in collection) {
   if(collection.hasOwnProperty(name)) {
    var control = ASPx.GetControlCollection().Get(name);
    if(control)
     result.push(control);
   }
  }
  return result;
 },
 coverCache: { },
 panelCache: { },
 timers: { },
 Shade: function(masterControl) {  
  this.ShadeCore(masterControl, true);
  this.timers[masterControl.name] = window.setTimeout(function() { ASPx.RelatedControlManager.ShadeTransition(masterControl.name); }, 750);
 },
 ShadeCore: function(masterControl, isTransparent) {
  if(!isTransparent) {
   this.panelCache[masterControl.name] = masterControl.ShowLoadingPanel();
  } 
  var controls = this.GetLinkedControls(masterControl);
  for(var i = 0; i < controls.length; i++) {
   var control = controls[i];
   var cover = control.CreateLoadingDiv(document.body, control.GetMainElement());
   if(ASPx.IsExistsElement(cover)) {
    if(isTransparent) {
     cover.className = "";
     cover.style.background = "white";         
     if(ASPx.Browser.IE)
      cover.style.filter = "alpha(opacity=1)";
     else
      cover.style.opacity = "0.01";
    }
    this.coverCache[control.name] = cover;
   }
  }  
 },
 ShadeTransition: function(masterName) {
  var obj = ASPx.GetControlCollection().Get(masterName);
  if(obj) {
   this.Unshade(obj);
   this.ShadeCore(obj, false);
  }
 },
 Unshade: function(masterControl) {
  var masterName = masterControl.name;
  ASPx.Timer.ClearTimer(this.timers[masterName]);
  delete this.timers[masterName];
  var panel = this.panelCache[masterName];
  if(ASPx.IsExistsElement(panel))
   ASPx.RemoveElement(panel);
  delete this.panelCache[masterName];
  var controls = this.GetLinkedControls(masterControl);
  for(var i = 0; i < controls.length; i++) {
   var control = controls[i];
   var cover = this.coverCache[control.name];
   if(ASPx.IsExistsElement(cover))
    ASPx.RemoveElement(cover);    
   delete this.coverCache[control.name];
  }
 },
 CreateInfo: function() {
  return { 
   clientObjectName:   "",
   elementId:    "",
   innerHtml:    "",
   parameters:   ""
  }; 
 },
 ProcessInfo: function(info) {
  var control = ASPx.GetControlCollection().Get(info.clientObjectName);  
  if(!control || !ASPx.IsFunction(control.ProcessCallbackResult))
   this.ProcessCallbackResultDefault(info.elementId, info.innerHtml, info.parameters);
  else
   control.ProcessCallbackResult(info.elementId, info.innerHtml, info.parameters);
 },
 ProcessCallbackResultDefault: function(elementId, innerHtml, parameters) {
  var element = ASPx.GetElementById(elementId);
  if(ASPx.IsExistsElement(element))
   element.innerHTML = innerHtml;  
 },
 ParseResult: function(result) {  
  var prevIndex = 0;
  var index;
  var lens;
  var info;
  while(true) {
   index = result.indexOf("|", prevIndex);
   if(index < 0)
    break;
   lens = result.substring(prevIndex, index).split(",");
   prevIndex = index + 1;
   info = this.CreateInfo();
   info.clientObjectName = result.substr(prevIndex, lens[0]);
   prevIndex += parseInt(lens[0]);
   info.elementId = result.substr(prevIndex, lens[1]);
   prevIndex += parseInt(lens[1]);
   info.innerHtml = result.substr(prevIndex, lens[2]);
   prevIndex += parseInt(lens[2]);
   info.parameters = result.substr(prevIndex, lens[3]);
   prevIndex += parseInt(lens[3]);
   this.ProcessInfo(info);
  }
 }
};
ASPx.RelatedControlManager = RelatedControlManager;
})();
(function() {
var HyperlinkSource = ASPx.CreateClass(null, {
 constructor: function(hyperlink) {
  this.hyperlink = hyperlink;
 }
});
function ChartHitRectangle(left, top, right, bottom) {
 this.left = left;
 this.top = top;
 this.right = right;
 this.bottom = bottom;
}
ChartHitRectangle.prototype = {
 IsVisible: function(x, y) {
  return (x >= this.left) && (x < this.right) && (y >= this.top) && (y < this.bottom);
 }
}
ChartHitRectangle.prototype.constructor = ChartHitRectangle;
function ChartHitEmpty() {
}
ChartHitEmpty.prototype = {
 IsVisible: function(x, y) {
  return false;
 } 
}
ChartHitEmpty.prototype.constructor = ChartHitEmpty;
function ChartHitExpression(leftOperand, rightOperand) {
 if(ChartHitExpression.AsProrotype)
  return delete ChartHitExpression.AsProrotype;
 this.leftOperand = leftOperand;
 this.rightOperand = rightOperand;
}
ChartHitExpression.prototype = {
 IsVisible: function(x, y) {
  throw "ChartHitExpression abstract error";
 }
}
ChartHitExpression.prototype.constructor = ChartHitExpression;
function ChartHitUnion(leftOperand, rightOperand) {
 ChartHitExpression.call(this, leftOperand, rightOperand);
}
ChartHitExpression.AsPrototype = true;
ChartHitUnion.prototype = new ChartHitExpression();
ChartHitUnion.prototype.constructor = ChartHitUnion;
ChartHitUnion.prototype.IsVisible = function(x, y) {
 return this.leftOperand.IsVisible(x, y) || this.rightOperand.IsVisible(x, y);
}
function ChartHitIntersection(leftOperand, rightOperand) {
 ChartHitExpression.call(this, leftOperand, rightOperand);
}
ChartHitExpression.AsPrototype = true;
ChartHitIntersection.prototype = new ChartHitExpression();
ChartHitIntersection.prototype.constructor = ChartHitIntersection;
ChartHitIntersection.prototype.IsVisible = function(x, y) {
 return this.leftOperand.IsVisible(x, y) && this.rightOperand.IsVisible(x, y);
}
function ChartHitExclusion(leftOperand, rightOperand) {
 ChartHitExpression.call(this, leftOperand, rightOperand);
}
ChartHitExpression.AsPrototype = true;
ChartHitExclusion.prototype = new ChartHitExpression();
ChartHitExclusion.prototype.constructor = ChartHitExclusion;
ChartHitExclusion.prototype.IsVisible = function(x, y) {
 return this.leftOperand.IsVisible(x, y) && !this.rightOperand.IsVisible(x, y);
}
function ChartHitXor(leftOperand, rightOperand) {
 ChartHitExpression.call(this, leftOperand, rightOperand);
}
ChartHitExpression.AsPrototype = true;
ChartHitXor.prototype = new ChartHitExpression();
ChartHitXor.prototype.constructor = ChartHitXor;
ChartHitXor.prototype.IsVisible = function(x, y) {
 return this.leftOperand.IsVisible(x, y) ^ this.rightOperand.IsVisible(x, y);
}
function ChartHitPath(lineSegments, alternate) {
 this.lineSegments = lineSegments;
 this.alternate = alternate;
}
ChartHitPath.prototype = {
 IsVisible: function(x, y) {
  if(this.lineSegments.length == 0)
   return false;
  var isVisible = this.IsVisibleInternal(x - 0.01, y);
  if(!isVisible)
   isVisible = this.IsVisibleInternal(x + 0.01, y);
  return isVisible;
 },
 IsVisibleInternal: function(x, y) { 
  var filteredLineSegments = this.FilterLineSegments(x, y);
  if(filteredLineSegments.length == 0)
   return false;
  var xIntersections = new ChartXIntersections(filteredLineSegments, x);
  var indicator = this.CalcIndicator(filteredLineSegments, xIntersections, y);
  return this.alternate ? (indicator % 2) != 0 : indicator != 0;
 },
 FilterLineSegments: function(x, y) {
  var filteredLineSegments = [];
  for(var i = 0; i < this.lineSegments.length; i++) {
   var lineSegment = this.lineSegments[i];
   if(this.ShouldFilterLineSegmentByX(lineSegment, x))
    continue;
   if(this.ShouldFilterLineSegmentByY(lineSegment, y))
    continue;
   filteredLineSegments.push(lineSegment);
  }
  return filteredLineSegments;
 },
 ShouldFilterLineSegmentByX: function(lineSegment, x) {
  return ((lineSegment.startX < x) && (lineSegment.finishX < x)) || 
   ((lineSegment.startX > x) && (lineSegment.finishX > x));
 },
 ShouldFilterLineSegmentByY: function(lineSegment, y) {
  return (lineSegment.startY < y) && (lineSegment.finishY < y);
 },
 CalcIndicator: function(lineSegments, xIntersections, y) {
  var indicator = 0;
  for(var i = 0; i < xIntersections.intersections.length; i++) {
   if(xIntersections.intersections[i] < y)
    continue;
   if(lineSegments[i].LeftToRight())
    indicator++;
   else if(lineSegments[i].RightToLeft())
    indicator--;
   else
    throw ChartLineSegment.err;
  }
  return indicator;
 }
}
ChartHitPath.prototype.constructor = ChartHitPath;
function ChartLineSegment(startX, startY, finishX, finishY) {
 this.startX = startX;
 this.startY = startY;
 this.finishX = finishX;
 this.finishY = finishY;
}
ChartLineSegment.err = "Invalid line segment";
ChartLineSegment.prototype = {
 LeftToRight : function() {
  return this.startX < this.finishX;
 },
 RightToLeft : function() {
  return this.startX > this.finishX;
 }
}
ChartLineSegment.prototype.constructor = ChartLineSegment;
function ChartXIntersections(lineSegments, x) {
 this.intersections = new Array(lineSegments.length);
 for(var i = 0; i < lineSegments.length; i++)
  this.intersections[i] = this.CalcIntersection(lineSegments[i], x);
}
ChartXIntersections.prototype = {
 CalcIntersection: function(lineSegment, x) {
  var delta = lineSegment.finishX - lineSegment.startX;
  if(delta == 0)
   throw ChartLineSegment.err;
  var k = (lineSegment.finishY - lineSegment.startY) / delta;
  var b = (lineSegment.startY * lineSegment.finishX - lineSegment.finishY * lineSegment.startX) / delta;
  return k * x + b;
 }
}
ChartXIntersections.prototype.constructor = ChartXIntersections;
function ChartHitTestController(hitInfo) {
 this.objects = [];
 this.additionalObjects = [];
 var hitInfoLoader = new ChartHitInfoLoader(hitInfo);
 this.regions = hitInfoLoader.regions;
}
ChartHitTestController.prototype = {
 HitTest: function(x, y) {
  var hitRegions = this.CreateHitRegions(x, y);
  return this.CreateHitObjects(hitRegions, x, y);
 },
 CreateHitRegions: function(x, y) {
  var hitRegions = [];
  for(var i = 0; i < this.regions.length; i++)
   if(this.regions[i].IsVisible(x, y))
    hitRegions.push(this.regions[i]);
  return hitRegions;
 },
 CreateHitObjects: function(hitRegions, x, y) {
  var hitObjects = [];
  for(var i = 0; i < hitRegions.length; i++) {
   var hitRegion = hitRegions[i];
   hitObjects.push(this.CreateHitObject(hitRegion, x, y));
  }
  return hitObjects;
 },
 CreateHitObject: function(hitRegion, x, y) {
  var hitObject = this.objects[hitRegion.id];
  var additionalHitObject = 
   hitRegion.additionalId != -1 ? 
   this.additionalObjects[hitRegion.additionalId] : 
   null;
  if (ASPx.IsExists(hitRegion.toolTipPoint) && additionalHitObject != null)
   additionalHitObject.toolTipPoint = hitRegion.toolTipPoint;
  if (ASPx.IsExists(hitRegion.legendItemsHitRegions))
   additionalHitObject = this.CreateLegendItemHitObject(hitRegion.legendItemsHitRegions, x, y);
  if (ASPx.IsExists(hitRegion.hyperlink) && hitObject != null)
   additionalHitObject = new HyperlinkSource(hitRegion.hyperlink);
  return new ASPxClientHitObject(hitObject, additionalHitObject);
 },
 CreateLegendItemHitObject: function (legendItemsHitRegions, x, y) {
  for (i = 0; i < legendItemsHitRegions.length; i++) {
   if (legendItemsHitRegions[i].IsVisible(x, y))
    return new ASPxClientLegendCheckBox(legendItemsHitRegions[i].id);
  }
  return null;
 }
}
ChartHitTestController.prototype.constructor = ChartHitTestController;
function ChartHitRegion(primitive, id, additionalId, toolTipPoint, legendItemsHitRegions, hyperlink) {
 this.primitive = primitive;
 this.id = id;
 this.additionalId = additionalId;
 this.toolTipPoint = toolTipPoint;
 this.legendItemsHitRegions = legendItemsHitRegions;
 this.hyperlink = hyperlink;
}
ChartHitRegion.prototype = {
 IsVisible: function(x, y) {
  return this.primitive.IsVisible(x, y); 
 }
}
ChartHitRegion.prototype.constructor = ChartHitRegion;
function ChartHitInfoLoader(hitInfo) {
 this.regions = [];
 this.LoadHitInfo(hitInfo);
}
ChartHitInfoLoader.errPrefix = "ChartHitTestController loading error: ";
ChartHitInfoLoader.errRegionType = ChartHitTestController.errPrefix + "Invalid hit region type";
ChartHitInfoLoader.errRegionFormat = ChartHitTestController.errPrefix + "Invalid hit region format";
ChartHitInfoLoader.prototype = {
 LoadHitInfo: function(hitInfo) {
  for(var i = 0; i < hitInfo.length; i++)
   this.LoadHitRegion(hitInfo[i]);
 },
 LoadHitRegion: function(interimHitRegion) {
  var id = interimHitRegion.hi;    
  var additionalId = ASPx.IsExists(interimHitRegion.hia) ? interimHitRegion.hia: -1;
  var primitive = this.LoadPrimitive(interimHitRegion.r);
  var toolTipPoint = interimHitRegion.ttp;
  var hyperlink = interimHitRegion.l;
  if (ASPx.IsExists(interimHitRegion.legChbRegns))
   var legendItemCheckboxRegions = this.LoadLegendItemsRegionsArray(interimHitRegion.legChbRegns);
  this.regions.unshift(new ChartHitRegion(primitive, id, additionalId, toolTipPoint, legendItemCheckboxRegions, hyperlink));
 },
 LoadLegendItemsRegionsArray: function (legendItemsInterimRegionsArray) {
  var result = [];
  for (i = 0 ; i < legendItemsInterimRegionsArray.length; i++) {
   var interimLegendItemObject = legendItemsInterimRegionsArray[i];
   var legendItemId = interimLegendItemObject.legItmId;
   var primitive = this.LoadPrimitive(interimLegendItemObject.r);
   var legendItemHitRegion = new ChartHitRegion(primitive, legendItemId, -1, null, null, null);
   result.push(legendItemHitRegion);
  }
  return result;
 },
 LoadPrimitive: function(interimPrimitive) {
  if(interimPrimitive.t == "R")
   return this.LoadRectangle(interimPrimitive);
  else if(interimPrimitive.t == "O")
   return new ChartHitEmpty();
  else if(interimPrimitive.t == "U")
   return this.LoadUnion(interimPrimitive);
  else if(interimPrimitive.t == "I")
   return this.LoadIntersection(interimPrimitive);
  else if(interimPrimitive.t == "E")
   return this.LoadExclusion(interimPrimitive);
  else if(interimPrimitive.t == "X")
   return this.LoadXor(interimPrimitive);
  else if(interimPrimitive.t == "P")
   return this.LoadPath(interimPrimitive);   
  throw ChartHitInfoLoader.errRegionType;
 },
 LoadRectangle: function(interimRectangle) {
  if(interimRectangle.r.length != 4)
   throw ChartHitInfoLoader.errRegionFormat;
  return new ChartHitRectangle(interimRectangle.r[0], interimRectangle.r[1], interimRectangle.r[2], interimRectangle.r[3]);
 },
 LoadUnion: function(interimExpression) {
  var leftOperand = this.LoadPrimitive(interimExpression.l);
  var rightOperand = this.LoadPrimitive(interimExpression.r);
  return new ChartHitUnion(leftOperand, rightOperand);
 },
 LoadIntersection: function(interimExpression) {
  var leftOperand = this.LoadPrimitive(interimExpression.l);
  var rightOperand = this.LoadPrimitive(interimExpression.r);
  return new ChartHitIntersection(leftOperand, rightOperand);
 },
 LoadExclusion: function(interimExpression) {
  var leftOperand = this.LoadPrimitive(interimExpression.l);
  var rightOperand = this.LoadPrimitive(interimExpression.r);
  return new ChartHitExclusion(leftOperand, rightOperand);
 },
 LoadXor: function(interimExpression) {
  var leftOperand = this.LoadPrimitive(interimExpression.l);
  var rightOperand = this.LoadPrimitive(interimExpression.r);
  return new ChartHitXor(leftOperand, rightOperand);
 },
 LoadPath: function(interimPath) {    
  var lineSegments = [];
  var points = [];
  var bezierPoints = [];
  var indexInStartArray = 0;
  var indexInBezierArray = 0;
  for(var pointIndex = 0; pointIndex < interimPath.p.length; pointIndex++) {
   if(this.IsStartPoint(interimPath, pointIndex, indexInStartArray)) {
    indexInStartArray++;
    this.UpdateLineSegments(lineSegments, points);
    points.length = 0;
   }
   else if(this.IsBezierPoint(interimPath, pointIndex, indexInBezierArray)) {
    indexInBezierArray++;
    if(bezierPoints.length == 0)
     bezierPoints.push(interimPath.p[pointIndex - 1]);     
    bezierPoints.push(interimPath.p[pointIndex]);
    if(bezierPoints.length == 4) {
     this.CalcBezierApproximation(
      bezierPoints[0][0], bezierPoints[0][1], 
      bezierPoints[1][0], bezierPoints[1][1], 
      bezierPoints[2][0], bezierPoints[2][1],
      bezierPoints[3][0], bezierPoints[3][1], points);
     bezierPoints.length = 0;
    }
    continue;
   }
   points.push(interimPath.p[pointIndex]);    
  }
  this.UpdateLineSegments(lineSegments, points);
  return new ChartHitPath(lineSegments, interimPath.a);
 },
 UpdateLineSegments: function(lineSegments, points) {
  if(points.length < 2)
   return;
  for(var i = 0; i < points.length - 1; i++)
   lineSegments.push(new ChartLineSegment(
    points[i][0], 
    points[i][1], 
    points[i + 1][0], 
    points[i + 1][1]));
  lineSegments.push(new ChartLineSegment(
   points[points.length - 1][0], 
   points[points.length - 1][1], 
   points[0][0], 
   points[0][1]));  
 },
 CreatePoint: function(x, y) {
  return [x, y];
 },
 IsStartPoint: function(interimPath, pointIndex, indexInStartArray) {
  return (indexInStartArray < interimPath.s.length) && (interimPath.s[indexInStartArray] == pointIndex);
 },
 IsBezierPoint: function(interimPath, pointIndex, indexInBezierArray) {
  return (indexInBezierArray < interimPath.b.length) && (interimPath.b[indexInBezierArray] == pointIndex);
 },
 CalcBezierApproximation: function(x1, y1, x2, y2, x3, y3, x4, y4, points) {
  var dx1 = x2 - x1;
  var dy1 = y2 - y1;
  var dx2 = x3 - x2;
  var dy2 = y3 - y2;
  var dx3 = x4 - x3;
  var dy3 = y4 - y3;
  var length = Math.sqrt(dx1 * dx1 + dy1 * dy1) + Math.sqrt(dx2 * dx2 + dy2 * dy2) + Math.sqrt(dx3 * dx3 + dy3 * dy3);
  var stepCount = Math.round(length * 0.25);
  var step = 1 / (stepCount + 1);
  var step2 = step * step;
  var step3 = step * step * step;
  var step13 = step * 3;
  var step23 = step2 * 3;
  var step26 = step2 * 6;
  var step36 = step3 * 6;
  var tempX1 = x1 - x2 * 2 + x3;
  var tempY1 = y1 - y2 * 2 + y3;
  var tempX2 = (x2 - x3) * 3 - x1 + x4;
  var tempY2 = (y2 - y3) * 3 - y1 + y4;
  var dx = (x2 - x1) * step13 + tempX1 * step23 + tempX2 * step3;
  var dy = (y2 - y1) * step13 + tempY1 * step23 + tempY2 * step3;
  var ddx = tempX1 * step26 + tempX2 * step36;
  var ddy = tempY1 * step26 + tempY2 * step36;
  var dddx = tempX2 * step36;
  var dddy = tempY2 * step36;
  var x = x1;
  var y = y1;
  for(var i = 0; i < stepCount; i++) {
   x += dx;
   y += dy;
   points.push(this.CreatePoint(x, y));
   dx += ddx;
   dy += ddy;
   ddx += dddx;
   ddy += dddy;
  }
  points.push(this.CreatePoint(x4, y4));
 }
}
ChartHitInfoLoader.prototype.constructor = ChartHitInfoLoader;
ASPx.ChartHitRectangle = ChartHitRectangle;
ASPx.ChartHitEmpty = ChartHitEmpty;
ASPx.ChartHitExpression = ChartHitExpression;
ASPx.ChartHitUnion = ChartHitUnion;
ASPx.ChartHitIntersection = ChartHitIntersection;
ASPx.ChartHitExclusion = ChartHitExclusion;
ASPx.ChartHitXor = ChartHitXor;
ASPx.ChartHitPath = ChartHitPath;
ASPx.ChartLineSegment = ChartLineSegment;
ASPx.ChartXIntersections = ChartXIntersections;
ASPx.ChartHitTestController = ChartHitTestController;
ASPx.ChartHitRegion = ChartHitRegion;
ASPx.ChartHitInfoLoader = ChartHitInfoLoader;
ASPx.HyperlinkSource = HyperlinkSource;
})();
(function () {
 var ASPxClientWebChartControl = ASPx.CreateClass(ASPxClientControl, {
  constructor: function (name) {
   this.constructor.prototype.constructor.call(this, name);
   this.ObjectHotTracked = new ASPxClientEvent();
   this.ObjectSelected = new ASPxClientEvent();
   this.CustomDrawCrosshair = new ASPxClientEvent();
   this.printHelper = this.createPrintHelper();
   this.exportWindow = null;
   this.printOptions = new ASPxClientChartPrintOptions();
   var mainDOMElement = this.GetMainDOMElement();
   ASPx.Evt.AttachEventToElement(mainDOMElement, "mouseout", function(evt) { this.HideElements(evt); }.aspxBind(this));
   ASPx.Evt.AttachEventToElement(mainDOMElement, "touchstart", function(evt) { this.TouchStart(evt); }.aspxBind(this));
   ASPx.Evt.AttachEventToElement(mainDOMElement, "touchend", function(evt) { this.TouchEnd(evt); }.aspxBind(this));
   ASPx.Evt.AttachEventToElement(mainDOMElement, "touchmove", function(evt) { this.TouchMove(evt); }.aspxBind(this));
  },
  HideElements: function (evt) {
   var target;
   if (ASPx.IsExists(evt.toElement)) {
    target = evt.toElement;
   }
   else {
    if (ASPx.IsExists(evt.relatedTarget)) {
     target = evt.relatedTarget;
    }
   }
   if (ASPx.IsExists(target)) {
    var parent = ASPx.GetParentById(target, this.name);
    if (ASPx.IsExists(parent)) {
     return;
    }
   }
   this.HideInteractiveElements();
  },
  HideInteractiveElements: function() {
   this.hideCrosshair();
   if (ASPx.IsExists(this.chart) && ASPx.IsExists(this.chart.toolTipController)) {
    this.chart.toolTipController.Hide();
   }
  },
  CalculateEventX: function (clickedElement, mouseEventX) {
   var left = ASPx.GetAbsoluteX(clickedElement);
   return Math.abs(mouseEventX - left);
  },
  CalculateEventY: function (clickedElement, mouseEventY) {
   var top = ASPx.GetAbsoluteY(clickedElement);
   return Math.abs(mouseEventY - top);
  },
  OnClick: function (evt) {
   var processOnServer = this.IsServerEventAssigned("ObjectSelected");
   var showToolTip = ASPx.IsExists(this.chart.toolTipController);
   var raiseObjectSelected = ASPx.IsExists(this.RaiseObjectSelected);
   var eventParams = this.getEventParams(evt, showToolTip || raiseObjectSelected);
   if (ASPx.Browser.HardwareAcceleration) {
    eventParams.chartX = Math.ceil(eventParams.chartX);
    eventParams.chartY = Math.ceil(eventParams.chartY);
   }
   if (raiseObjectSelected)
    processOnServer = this.RaiseObjectSelected(eventParams.chartX, eventParams.chartY, eventParams.htmlElement, eventParams.eventX, eventParams.eventY, eventParams.hitObjects, eventParams.hitInfo);
   if (processOnServer || this.chart.selectionMode != "" && (eventParams.hitInfo != null && (eventParams.hitInfo.inSeries || eventParams.hitInfo.inSeriesPoint))) {
    var ctrlPressed = 0;
    var shiftPressed = 0;
    if (parseInt(navigator.appVersion) > 3) {
     if (document.layers && navigator.appName == "Netscape" && parseInt(navigator.appVersion) == 4) {
      var mString = (evt.modifiers + 32).toString(2).substring(3, 6);
      shiftPressed = (mString.charAt(0) == "1");
      ctrlPressed = (mString.charAt(1) == "1");
     }
     else {
      shiftPressed = evt.shiftKey;
      ctrlPressed = evt.ctrlKey;
     }
    }
    var eventParams = "SELECT:" + eventParams.chartX + ":" + eventParams.chartY + ":" + shiftPressed + ":" + ctrlPressed;
    if (this.autoPostBack)
     this.SendPostBack(eventParams);
    else if (ASPx.IsExists(this.callBack))
     this.ChartCallback(eventParams);
   }
   if (showToolTip && this.chart.toolTipController.openMode == "OnClick")
    this.showTooltip(eventParams);
   if (this.chart.legend.useCheckBoxes) {
    for (var i = 0; i < eventParams.hitObjects.length; i++) {
     if (eventParams.hitObjects[i].object instanceof ASPxClientLegend) {
      var legendCheckboxObj = eventParams.hitObjects[i].additionalObject;
      if (ASPx.IsExists(legendCheckboxObj) && (legendCheckboxObj instanceof ASPxClientLegendCheckBox)) {
       var checkableLegendItemID = legendCheckboxObj.legendItemId;
       var eventArgs = "CHANGE_CHECKED_IN_LEGEND:" + checkableLegendItemID;
       this.ChartCallback(eventArgs);
      }
     }
    }
   }
  },
  OnMouseMove: function(evt) {
   if (this.touchEndRaised) {
    this.touchEndRaised = false;
    return;
   }
   var raiseObjectHotTracked = ASPx.IsExists(this.RaiseObjectHotTracked);
   var showToolTip = ASPx.IsExists(this.chart) ? ASPx.IsExists(this.chart.toolTipController) : false;
   var showCrosshair = ASPx.IsExists(this.chart) ? this.chart.showCrosshair : false;
   if (raiseObjectHotTracked || showToolTip || showCrosshair) {
    var eventParams = this.getEventParams(evt, true);
    if (eventParams.hitInfo == null)
     return;
    if (raiseObjectHotTracked)
     this.RaiseObjectHotTracked(eventParams.chartX, eventParams.chartY, eventParams.htmlElement, eventParams.eventX, eventParams.eventY, eventParams.hitObjects, eventParams.hitInfo);
    if (showCrosshair)
     this.showCrosshair(eventParams.chartX, eventParams.chartY);
    if (showToolTip && this.chart.toolTipController.openMode == "OnHover")
     this.showTooltip(eventParams);
   }
  },
  TouchEnd: function(evt) {
   if (evt.touches.length == 0)
    this.multiTouchStarted = false;
   if (ASPx.IsExists(this.crosshairRenderer))
    this.crosshairRenderer.Hide();
   if (ASPx.IsExists(this.chart.toolTipController)) {
    var eventParams = this.getEventParams(evt, true);
    this.showTooltip(eventParams);
   }
   if (ASPx.Browser.WebKitTouchUI)
    this.touchEndRaised = true;
  },
  TouchMove: function(evt) {
   if (!this.multiTouchStarted && this.showCrosshairForTouch(evt))
    evt.preventDefault();
  },
  TouchStart: function(evt) {
   this.touchEndRaised = false;
   this.multiTouchStarted = evt.touches.length >= 2;
   if (this.multiTouchStarted)
    this.hideCrosshair();
   else
    this.showCrosshairForTouch(evt);
  },
  getEventParams: function(evt, shouldCalculateHitInfo) {
   var mouseEventX = ASPx.Evt.GetEventX(evt);
   var mouseEventY = ASPx.Evt.GetEventY(evt);
   var htmlElement = ASPx.Evt.GetEventSource(evt);
   if (ASPx.GetIsParent(this.GetMainDOMElement(), htmlElement))
    htmlElement = this.GetChartElement();
   var x = this.CalculateEventX(htmlElement, mouseEventX);
   var y = this.CalculateEventY(htmlElement, mouseEventY);
   var hitObjects, hitInfo;
   if (shouldCalculateHitInfo) {
    hitObjects = this.HitTest(x, y);
    if (hitObjects != null)
     hitInfo = new ASPxClientWebChartHitInfo(hitObjects);
   }
   return { eventX: mouseEventX, eventY: mouseEventY, chartX: x, chartY: y, htmlElement: htmlElement, hitInfo: hitInfo, hitObjects: hitObjects };
  },
  showCrosshairForTouch: function(evt) {
   var showCrosshair = ASPx.IsExists(this.chart) && this.chart.showCrosshair;
   if (showCrosshair) {
    var eventParams = this.getEventParams(evt, false);
    this.showCrosshair(eventParams.chartX, eventParams.chartY);
   }
   return showCrosshair;
  },
  showCrosshairForced: function(x, y) {
   if (ASPx.IsExists(this.chart)) {
    if (this.chart.showCrosshair || ASPx.IsExists(this.crosshairRenderer))
     this.showCrosshair(x, y);
    else
     this.ChartCallback("SHOW_CROSSHAIR:" + x + ":" + y);
   }
  },
  showCrosshair: function(x, y) {
   if (!ASPx.IsExists(this.crosshairRenderer))
    this.crosshairRenderer = new ASPx.CrosshairRenderer(this, this.name + '_CH');
   this.crosshairRenderer.UpdateCrosshair(x, y, this);
  },
  hideCrosshair: function() {
   if (ASPx.IsExists(this.crosshairRenderer) && ASPx.IsExists(this.chart) && this.chart.showCrosshair) {
    this.crosshairRenderer.Hide();
   }
  },
  showTooltip: function (eventParams) {
   if (eventParams.hitInfo != null) {
    var htmlElement = eventParams.htmlElement;
    this.chart.toolTipController.Show(eventParams.eventX, eventParams.eventY, eventParams.hitInfo, ASPx.GetAbsoluteX(htmlElement), ASPx.GetAbsoluteY(htmlElement));
   }
  },
  createPrintHelper: function() {
   if (ASPx.Browser.Opera && ASPx.Browser.Version < 28)
    return new ASPx.WebChartPrintHelperOpera();
   else
    return new ASPx.WebChartPrintHelper();
  },
  CallbackSaveToDisk: function (result) {
   this.printHelper.exportTo(result);
  },
  CallbackSaveToWindow: function (result) {
   if (this.exportWindow != null && !this.exportWindow.closed) {
    this.exportWindow.location = result;
   }
  },
  CallbackPrint: function(result) {
   var chartImage = this.GetChartElement();
   this.printHelper.print(result, chartImage.clientWidth, chartImage.clientHeight);
  },
  OnCallback: function(resultObj) {
   this.HideInteractiveElements();
   var result = resultObj.result;
   if (result) {
    var printSign = "PRINT:";
    if (result.indexOf(printSign) >= 0) {
     this.CallbackPrint(result.substring(printSign.length));
     return;
    }
    var saveToDiskSign = "SAVETODISK:";
    if (result.indexOf(saveToDiskSign) >= 0) {
     this.CallbackSaveToDisk(result.substring(saveToDiskSign.length));
     return;
    }
    var saveToWindowSign = "SAVETOWINDOW:";
    if (result.indexOf(saveToWindowSign) >= 0) {
     this.CallbackSaveToWindow(result.substring(saveToWindowSign.length));
     return;
    }
   }
   if (resultObj.img) {
    var image = new Image();
    for (var attribute in resultObj.img)
     image.setAttribute(attribute, resultObj.img[attribute]);
    image.chart = this.GetChartElement();
    image.onload = function () {
     image.chart.innerHTML = "";
     image.chart.insertBefore(image, null);
    }
   }
   if (resultObj.svg) {
    var chartContainer = this.GetChartElement();
    chartContainer.innerHTML = resultObj.svg;
   }
   if (resultObj.hitInfo)
    this.LoadHitInfo(eval(resultObj.hitInfo));
   if (resultObj.objectModel)
    this.InitObjectModel(eval("(" + resultObj.objectModel + ")"));
   this.UpdateStateObjectWithObject(resultObj.stateObject);
   if (result && result.indexOf("SHOW_CROSSHAIR") >= 0) {
    var stringItems = result.split(":");
    var x = parseFloat(stringItems[1]);
    var y = parseFloat(stringItems[2]);
    this.showCrosshair(x, y);
   }
  },
  LoadHitInfo: function (hitInfo) {
   this.hitTestController = new ASPx.ChartHitTestController(hitInfo);
  },
  InitObjectModel: function (objectModel) {
   this.chart = new ASPxClientWebChart(this, objectModel);
   this.ResetCrosshairRenderer();
  },
  ResetCrosshairRenderer: function () {
   if (ASPx.IsExists(this.crosshairRenderer)) {
    this.crosshairRenderer.Hide();
    this.crosshairRenderer = null;
   }
  },
  SetOperaCursor: function (cursor, htmlElement) {
   var divId = this.name + "_DIV";
   var div = ASPx.GetElementById(divId);
   if (!ASPx.IsExists(div) || (div.tagName != "DIV") || (div != htmlElement.parentNode))
    div = null;
   oldCursor = div != null ? div.style.cursor : htmlElement.style.cursor;
   if (!ASPx.IsExists(oldCursor))
    oldCursor = "default";
   if (cursor != oldCursor) {
    if (div == null) {
     div = document.createElement("div");
     div.id = divId;
     div.style.backgroundColor = "transparent";
     div.style.border = "none";
     div.style.cursor = cursor;
     htmlElement.parentNode.replaceChild(div, htmlElement);
     div.appendChild(htmlElement);
    }
    else
     div.parentNode.replaceChild(htmlElement, div);
   }
  },
  ChartCallback: function (eventParams, command, handler) {
   if (ASPx.IsExists(this.callBack)) {
    this.ResetCrosshairRenderer();
    if (ASPx.IsExists(this.chart) && ASPx.IsExists(this.chart.toolTipController)) {
     this.chart.toolTipController.Hide();
    }
    this.ShowLoadingElements();
    this.CreateCallback(eventParams, command, handler);
   }
   else
    this.SendPostBack(eventParams);
  },
  ShowLoadingPanel: function () {
   this.CreateLoadingPanelWithAbsolutePosition(this.GetMainElement().parentNode, this.GetMainElement());
  },
  GetCallbackAnimationElement: function () {
   return this.GetMainElement();
  },
  GetChartElement: function () {
   return document.getElementById(this.name);
  }
 });
 ASPx.chartClick = function (evt, name) {
  var control = ASPx.GetControlCollection().Get(name);
  if (control != null)
   control.OnClick(evt);
 }
 ASPx.chartMouseMove = function (evt, name) {
  var control = ASPx.GetControlCollection().Get(name);
  if (control != null)
   control.OnMouseMove(evt);
 }
 var ASPxClientScaleType = ASPx.CreateClass(null, {});
 ASPxClientScaleType.Qualitative = "Qualitative";
 ASPxClientScaleType.Numerical = "Numerical";
 ASPxClientScaleType.DateTime = "DateTime";
 var ASPxClientControlCoordinatesVisibility = ASPx.CreateClass(null, {});
 ASPxClientControlCoordinatesVisibility.Visible = "Visible";
 ASPxClientControlCoordinatesVisibility.Hidden = "Hidden";
 ASPxClientControlCoordinatesVisibility.Undefined = "Undefined";
 ASPxClientWebChartControl.Cast = ASPxClientControl.Cast;
 ASPxClientWebChartControl.prototype.GetChart = function () {
  return this.chart;
 };
 ASPxClientWebChartControl.prototype.GetPrintOptions = function () {
  return this.printOptions;
 };
 ASPxClientWebChartControl.prototype.SetCursor = function (cursor) {
  var htmlElement = this.GetMainElement();
  if (ASPx.IsExists(htmlElement)) {
   if (ASPx.Browser.Opera)
    this.SetOperaCursor(cursor, htmlElement);
   else
    htmlElement.style.cursor = cursor;
  }
 };
 ASPxClientWebChartControl.prototype.RaiseObjectHotTracked = function (x, y, htmlElement, absoluteX, absoluteY, hitObjects, hitInfo) {
  for (var i = 0; i < hitObjects.length; i++) {
   var args = new ASPxClientWebChartControlHotTrackEventArgs(
    false,
    hitObjects[i].object,
    hitObjects[i].additionalObject,
    hitInfo,
    this.chart,
    htmlElement,
    x, y,
    absoluteX, absoluteY);
   this.ObjectHotTracked.FireEvent(this, args);
   if (!args.cancel)
    break;
  }
 };
 ASPxClientWebChartControl.prototype.RaiseCustomDrawCrosshair = function (CursorCrosshairAxisLabelElements, CursorCrosshairLineElement, CrosshairElementGroups) {
  var args = new ASPxClientWebChartControlCustomDrawCrosshairEventArgs(
   false,
   CursorCrosshairAxisLabelElements,
   CursorCrosshairLineElement,
   CrosshairElementGroups);
  this.CustomDrawCrosshair.FireEvent(this, args);
 };
 ASPxClientWebChartControl.prototype.RaiseObjectSelected = function (x, y, htmlElement, absoluteX, absoluteY, hitObjects, hitInfo) {
  var processOnServer = this.IsServerEventAssigned("ObjectSelected");
  if (hitObjects == null)
   return processOnServer;
  for (var i = 0; i < hitObjects.length; i++) {
   var args = new ASPxClientWebChartControlHotTrackEventArgs(
    processOnServer,
    hitObjects[i].object,
    hitObjects[i].additionalObject,
    hitInfo,
    this.chart,
    htmlElement,
    x, y,
    absoluteX, absoluteY);
   this.ObjectSelected.FireEvent(this, args);
   processOnServer = args.processOnServer;
   if (!args.cancel)
    break;
  }
  return processOnServer;
 };
 ASPxClientWebChartControl.prototype.HitTest = function (x, y) {
  if (ASPx.IsExists(this.hitTestController))
   return this.hitTestController.HitTest(x, y);
  else
   return null;
 };
 ASPxClientWebChartControl.prototype.PerformCallback = function (args, onSuccess) {
  if (!ASPx.IsExists(args)) args = "";
  this.ChartCallback("CUSTOMCALLBACK:" + args, "CUSTOMCALLBACK", onSuccess);
 };
 ASPxClientWebChartControl.prototype.Print = function () {
  if (!ASPx.IsExists(this.callBack)) return;
  var options = this.printOptions.createEventParameters();
  this.ChartCallback("PRINT:" + this.printHelper.getPrintDocumentFormat() + ":" + options);
 };
 ASPxClientWebChartControl.prototype.LoadFromObjectModel = function (serializedChartObjectModel) {
  if (!ASPx.IsExists(this.callBack)) return;
  this.ChartCallback("LOAD_LAYOUT:" + serializedChartObjectModel);
 };
 ASPxClientWebChartControl.prototype.SaveToDisk = function (format, filename) {
  if (!ASPx.IsExists(this.callBack)) return;
  var options = this.printOptions.createEventParameters();
  if (filename == undefined)
   this.ChartCallback("SAVETODISK:" + format + ":" + options + ":");
  else
   this.ChartCallback("SAVETODISK:" + format + ":" + options + ":" + filename);
 };
 ASPxClientWebChartControl.prototype.SaveToWindow = function (format) {
  if (!ASPx.IsExists(this.callBack)) return;
  this.exportWindow = window.open('', '_blank', 'toolbars=no, resizable=yes, scrollbars=yes');
  var options = this.printOptions.createEventParameters();
  this.ChartCallback("SAVETOWINDOW:" + format + ":" + options);
 };
 ASPxClientWebChartControl.prototype.GetMainDOMElement = function () {
  return this.GetMainElement();
 }
 var ASPxClientWebChartControlCustomDrawCrosshairEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
  constructor: function (processOnServer, cursorCrosshairAxisLabelElements, cursorCrosshairLineElement, crosshairElementGroups) {
   this.constructor.prototype.constructor.call(this, processOnServer);
   this.crosshairElements = [];
   for (var i = 0; i < crosshairElementGroups.length; i++)
    for (var j = 0; j < crosshairElementGroups[i].CrosshairElements.length; j++)
     this.crosshairElements.push(crosshairElementGroups[i].CrosshairElements[j]);
   this.cursorCrosshairAxisLabelElements = cursorCrosshairAxisLabelElements;
   this.cursorCrosshairLineElement = cursorCrosshairLineElement;
   this.crosshairGroupHeaderElements = [];
   for (var i = 0; i < crosshairElementGroups.length; i++)
    if (crosshairElementGroups[i].HeaderElement != null)
     this.crosshairGroupHeaderElements.push(crosshairElementGroups[i].HeaderElement);
   this.crosshairElementGroups = crosshairElementGroups;
  }
 });
 var ASPxClientCrosshairDrawInfoList = ASPx.CreateClass(null, {
  constructor: function (crosshairDrawInfos, crosshairGroups) {
   if (crosshairDrawInfos.length < 1)
    return;
   this.CrosshairElementGroups = [];
   if (crosshairGroups.length > 0)
    for (var i = 0; i < crosshairGroups.length; i++) {
     var headerElement = crosshairGroups[i].crosshairGroupHeaderElement;
     var elementGroup = new ASPxClientCrosshairElementGroup(headerElement, crosshairGroups[i].crosshairElements);
     this.CrosshairElementGroups.push(elementGroup);
    }
   else {
    for (var i = 0; i < crosshairDrawInfos.length; i++) {
     var crosshairDrawInfo = crosshairDrawInfos[i];
     for (var j = 0; j < crosshairDrawInfo.CrosshairElements.length; j++) {
      var elements = [];
      elements.push(crosshairDrawInfo.CrosshairElements[j]);
      var elementGroup = new ASPxClientCrosshairElementGroup(null, elements);
      this.CrosshairElementGroups.push(elementGroup);
     }
    }
   }
   cursorCrosshairLineElement = crosshairDrawInfos[0].CursorCrosshairLineElement;
   for (var i = 0; i < crosshairDrawInfos.length; i++) {
    if (ASPx.IsExists(crosshairDrawInfos[i].CursorCrosshairLineDrawInfo)) {
     crosshairDrawInfos[i].CursorCrosshairLineElement = cursorCrosshairLineElement;
     crosshairDrawInfos[i].CursorCrosshairLineDrawInfo = { cursorCrosshairLineElement: cursorCrosshairLineElement, crosshairLine: crosshairDrawInfos[i].CursorCrosshairLineDrawInfo.crosshairLine };
    }
   }
   this.CrosshairDrawInfoList = crosshairDrawInfos;
   this.CursorCrosshairLineElement = cursorCrosshairLineElement;
   this.CursorCrosshairAxisLabelElements = [];
   for (var i = 0; i < this.CrosshairDrawInfoList.length; i++) {
    var crosshairDrawInfo = this.CrosshairDrawInfoList[i];
    for (var j = 0; j < crosshairDrawInfo.CursorCrosshairAxisLabelElements.length; j++) {
     this.CursorCrosshairAxisLabelElements.push(crosshairDrawInfo.CursorCrosshairAxisLabelElements[j]);
    }
   }
  }
 });
 var ASPxClientCrosshairDrawInfo = ASPx.CreateClass(null, {
  constructor: function (chartControl) {
   this.chartControl = chartControl;
   this.CrosshairElements = [];
   this.CursorCrosshairAxisLabelElements = [];
   this.CursorCrosshairAxisLabelDrawInfos = [];
  },
  AddPaneCrosshairInfo: function (paneCrosshairInfo, rotated) {
   crosshairOptions = this.chartControl.chart.crosshairOptions;
   this.labelsBounds = paneCrosshairInfo.labelsBounds;
   for (var i = 0; i < paneCrosshairInfo.pointsInfo.length; i++) {
    var point = paneCrosshairInfo.pointsInfo[i];
    var crosshairLineElement = new ASPxClientCrosshairLineElement(crosshairOptions, point.crosshairLine, rotated);
    var crosshairAxisLabelElement = this.CreateCrosshairAxisLabelElement(point.crosshairLabel, crosshairOptions, rotated);
    var crosshairSeriesLabelElement = new ASPxClientCrosshairSeriesLabelElement(point, crosshairOptions.showCrosshairLabels, crosshairOptions.crosshairLabelTextOptions);
    var crosshairElement = new ASPxClientCrosshairElement(point, crosshairLineElement, crosshairAxisLabelElement, crosshairSeriesLabelElement);
    this.CrosshairElements.push(crosshairElement);
   }
   if (ASPx.IsExists(paneCrosshairInfo.cursorLine)) {
    this.CursorCrosshairLineElement = new ASPxClientCrosshairLineElement(crosshairOptions, paneCrosshairInfo.cursorLine, rotated);
    this.CursorCrosshairLineDrawInfo = { cursorCrosshairLineElement: this.CursorCrosshairLineElement, crosshairLine: paneCrosshairInfo.cursorLine };
   }
   for (var i = 0; i < paneCrosshairInfo.cursorLabel.length; i++) {
    var crosshairAxisLabelElement = this.CreateCrosshairAxisLabelElement(paneCrosshairInfo.cursorLabel[i], crosshairOptions, rotated);
    this.CursorCrosshairAxisLabelElements.push(crosshairAxisLabelElement);
    this.CursorCrosshairAxisLabelDrawInfos.push({ cursorCrosshairAxisLabelElement: crosshairAxisLabelElement, crosshairAxisLabel: paneCrosshairInfo.cursorLabel[i] });
   }
  },
  CreateCrosshairAxisLabelElement: function(crosshairLabel, crosshairOptions, rotated) {
   var option;
   if (crosshairLabel.isHorizontal ^ rotated)
    option = this.chartControl.chart.diagram.axisY.crosshairAxisLabelOptions;
   else
    option = this.chartControl.chart.diagram.axisX.crosshairAxisLabelOptions;
   return new ASPxClientCrosshairAxisLabelElement(option, crosshairLabel, this.chartControl.chart.diagram.rotated);
  }
 });
 var ASPxClientCrosshairElement = ASPx.CreateClass(null, {
  constructor: function (point, crosshairLineElement, crosshairAxisLabelElement, crosshairSeriesLabelElement) {
   this.Series = point.point.series;
   this.Point = point;
   this.LineElement = crosshairLineElement;
   this.AxisLabelElement = crosshairAxisLabelElement;
   this.LabelElement = crosshairSeriesLabelElement;
   this.visible = true;
  }
 });
 var ASPxClientCrosshairLineElement = ASPx.CreateClass(null, {
  constructor: function (crosshairOptions, crosshairLine, rotated) {
   if (crosshairLine.isHorizontal ^ rotated) {
    this.visible = crosshairOptions.showValueLine;
    this.color = crosshairOptions.valueLineColor;
    this.lineStyle = crosshairOptions.valueLineStyle;
   }
   else {
    this.visible = crosshairOptions.showArgumentLine;
    this.color = crosshairOptions.argumentLineColor;
    this.lineStyle = crosshairOptions.argumentLineStyle;
   }
  }
 });
 var ASPxClientCrosshairAxisLabelElement = ASPx.CreateClass(null, {
  constructor: function(crosshairAxisLabelOptions, crosshairLabel, rotated) {
   this.backColor = crosshairAxisLabelOptions.backColor;
   this.textColor = crosshairAxisLabelOptions.textColor;
   var axisValuePair = crosshairLabel.axisValuePair;
   var isValueAxis = crosshairLabel.isHorizontal ? !rotated : rotated;
   this.font = crosshairAxisLabelOptions.font;
   this.text = "";
   this.visible = false;
   var value = axisValuePair.axis.GetNativeArgument(axisValuePair.internalValue);
   if (value != null) {
    this.text = ASPx.ToolTipPatternHelper.GetAxisLabelText(axisValuePair.axis, isValueAxis, value);
    this.visible = crosshairAxisLabelOptions.visibility;
   }
  }
 });
 var ASPxClientCrosshairGroupHeaderElement = ASPx.CreateClass(null, {
  constructor: function (group, textOptions) {
   this.seriesPoints = [];
   this.text = group.headerText;
   this.visible = true;
   if (textOptions != null && ASPx.IsExists(textOptions.font))
    this.font = textOptions.font.CreateCustomDrawElement();
   else
    this.font = { fontSize: 12, fontFamily: "Tahoma" };
   if (textOptions != null && ASPx.IsExists(textOptions.textColor))
    this.textColor = textOptions.textColor;
   else
    this.textColor = "#000000";
  }
 });
 var ASPxClientCrosshairSeriesLabelElement = ASPx.CreateClass(null, {
  constructor: function (point, visible, chartTextOptions) {
   var series = point.point.series;
   var color = (ASPx.IsExists(point.point.color) ? point.point.color : series.color);
   this.defaultMarker = "<div style='width:15px; height:12px; background-color:" + color + "' />"
   this.marker = this.defaultMarker;
   this.text = ASPx.ToolTipPatternHelper.GetPointToolTipText(series.crosshairLabelPattern, point.point, series);
   this.headerText = "";
   this.footerText = "";
   this.visible = series.actualCrosshairLabelVisibility;
   this.markerVisible = true;
   this.markerColor = color;
   this.textVisible = true;
   this.font = this.getActualFont(series.crosshairTextOptions, chartTextOptions);
   this.textColor = this.getActualTextColor(series.crosshairTextOptions, chartTextOptions);
  },
  getActualFont: function(seriesTextOptions, chartTextOptions) {
   if (seriesTextOptions != null && ASPx.IsExists(seriesTextOptions.font))
    return seriesTextOptions.font.CreateCustomDrawElement();
   else if (chartTextOptions != null && ASPx.IsExists(chartTextOptions.font))
    return chartTextOptions.font.CreateCustomDrawElement();
   else
    return { fontSize: 12, fontFamily: "Tahoma" };
  },
  getActualTextColor: function (seriesTextOptions, chartTextOptions) {
   if (seriesTextOptions != null && ASPx.IsExists(seriesTextOptions.textColor))
    return seriesTextOptions.textColor;
   else if (chartTextOptions != null && ASPx.IsExists(chartTextOptions.textColor))
    return chartTextOptions.textColor;
   else
    return "#000000";
  }
 });
 var ASPxClientCrosshairElementGroup = ASPx.CreateClass(null, {
  constructor: function (headerElement, crosshairElements) {
   this.HeaderElement = headerElement;
   this.CrosshairElements = crosshairElements;
  }
 });
 var ASPxClientWebChartControlHotTrackEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
  constructor: function (processOnServer, hitObject, additionalHitObject, hitInfo, chart, htmlElement, x, y, absoluteX, absoluteY) {
   this.constructor.prototype.constructor.call(this, processOnServer);
   this.hitObject = hitObject;
   this.additionalHitObject = additionalHitObject;
   this.hitInfo = hitInfo;
   this.chart = chart;
   this.htmlElement = htmlElement;
   this.x = x;
   this.y = y;
   if (typeof (absoluteX) != "undefined")
    this.absoluteX = absoluteX;
   else
    this.absoluteX = 0;
   if (typeof (absoluteY) != "undefined")
    this.absoluteY = absoluteY;
   else
    this.absoluteY = 0;
   this.cancel = false;
  }
 });
 var ASPxClientHitObject = ASPx.CreateClass(null, {
  constructor: function (object, additionalObject) {
   this.object = object;
   this.additionalObject = additionalObject;
  }
 });
 var ASPxClientWebChartHitInfo = ASPx.CreateClass(null, {
  constructor: function (hitObjects) {
   this.inChart = false;
   this.inChartTitle = false;
   this.inAxis = false;
   this.inAxisLabelItem = false;
   this.inAxisTitle = false;
   this.inConstantLine = false;
   this.inDiagram = false;
   this.inNonDefaultPane = false;
   this.inLegend = false;
   this.inCustomLegendItem = false;
   this.inSeries = false;
   this.inSeriesLabel = false;
   this.inSeriesPoint = false;
   this.inSeriesTitle = false;
   this.inTrendLine = false;
   this.inFibonacciIndicator = false;
   this.inRegressionLine = false;
   this.inIndicator = false;
   this.inAnnotation = false;
   this.inHyperlink = false;
   this.chart = null;
   this.chartTitle = null;
   this.axis = null;
   this.constantLine = null;
   this.diagram = null;
   this.nonDefaultPane = null;
   this.legend = null;
   this.customLegendItem = null;
   this.series = null;
   this.seriesLabel = null;
   this.seriesTitle = null;
   this.trendLine = null;
   this.fibonacciIndicator = null;
   this.regressionLine = null;
   this.indicator = null;
   this.annotation = null;
   this.seriesPoint = null;
   this.axisLabelItem = null;
   this.axisTitle = null;
   this.hyperlink = null;
   for (var i = 0; i < hitObjects.length; i++) {
    var obj = hitObjects[i].object;
    this.ProcessPrimaryObject(obj);
    var additionalObj = hitObjects[i].additionalObject;
    if (additionalObj != null)
     this.ProcessAdditionalObject(obj, additionalObj);
   }
  },
  ProcessPrimaryObject: function (obj) {
   if (obj instanceof ASPxClientWebChart) {
    if (!this.inChart) {
     this.inChart = true;
     this.chart = obj;
    }
   }
   else if (obj instanceof ASPxClientChartTitle) {
    if (!this.inChartTitle) {
     this.inChartTitle = true;
     this.chartTitle = obj;
    }
   }
   else if ((obj instanceof ASPxClientAxis) || (obj instanceof ASPxClientSwiftPlotDiagramAxis) ||
      (obj instanceof ASPxClientAxis3D) || (obj instanceof ASPxClientRadarAxis)) {
    if (!this.inAxis) {
     this.inAxis = true;
     this.axis = obj;
    }
   }
   else if (obj instanceof ASPxClientConstantLine) {
    if (!this.inConstantLine) {
     this.inConstantLine = true;
     this.constantLine = obj;
    }
   }
   else if ((obj instanceof ASPxClientXYDiagram) || (obj instanceof ASPxClientSwiftPlotDiagram) ||
      (obj instanceof ASPxClientXYDiagram3D) || (obj instanceof ASPxClientRadarDiagram)) {
    if (!this.inDiagram) {
     this.inDiagram = true;
     this.diagram = obj;
    }
   }
   else if (obj instanceof ASPxClientXYDiagramPane) {
    if (!this.inNonDefaultPane) {
     this.inNonDefaultPane = true;
     this.nonDefaultPane = obj;
    }
   }
   else if (obj instanceof ASPxClientLegend) {
    if (!this.inLegend) {
     this.inLegend = true;
     this.legend = obj;
    }
   }
   else if (obj instanceof ASPxClientSeries) {
    if (!this.inSeries) {
     this.inSeries = true;
     this.series = obj;
    }
   }
   else if (obj instanceof ASPxClientSeriesLabel) {
    if (!this.inSeriesLabel) {
     this.inSeriesLabel = true;
     this.seriesLabel = obj;
    }
   }
   else if (obj instanceof ASPxClientSeriesTitle) {
    if (!this.inSeriesTitle) {
     this.inSeriesTitle = true;
     this.seriesTitle = obj;
    }
   }
   else if (obj instanceof ASPxClientIndicator) {
    this.inIndicator = true;
    this.indicator = obj;
    if (obj instanceof ASPxClientTrendLine) {
     if (!this.inTrendLine) {
      this.inTrendLine = true;
      this.trendLine = obj;
     }
    }
    else if (obj instanceof ASPxClientFibonacciIndicator) {
     if (!this.inFibonacciIndicator) {
      this.inFibonacciIndicator = true;
      this.fibonacciIndicator = obj;
     }
    }
    else if (obj instanceof ASPxClientRegressionLine) {
     if (!this.inRegressionLine) {
      this.inRegressionLine = true;
      this.regressionLine = obj;
     }
    }
   }
   else if (obj instanceof ASPxClientAnnotation) {
    if (!this.inAnnotation) {
     this.inAnnotation = true;
     this.annotation = obj;
    }
   }
  },
  ProcessAdditionalObject: function (obj, additionalObj) {
   if (obj instanceof ASPxClientLegend) {
    if (additionalObj instanceof ASPxClientSeriesPoint) {
     if (!this.inSeriesPoint)
      this.seriesPoint = additionalObj;
    }
    else if (additionalObj instanceof ASPxClientConstantLine) {
     if (!this.inConstantLine)
      this.constantLine = additionalObj;
    }
    else if (additionalObj instanceof ASPxClientSeries) {
     if (!this.inSeries)
      this.series = additionalObj;
    }
    else if (additionalObj instanceof ASPxClientIndicator) {
     if (!this.inIndicator)
      this.indicator = additionalObj;
    }
    else if (additionalObj instanceof ASPxClientCustomLegendItem) {
     this.customLegendItem = additionalObj;
     this.inCustomLegendItem = true;
    }
   }
   else {
    if (additionalObj instanceof ASPxClientSeriesPoint) {
     if (!this.inSeriesPoint) {
      this.inSeriesPoint = true;
      this.seriesPoint = additionalObj;
     }
    }
    if (additionalObj instanceof ASPxClientAxisLabelItem) {
     if (!this.inAxisLabelItem) {
      this.inAxisLabelItem = true;
      this.axisLabelItem = additionalObj;
     }
    }
    if (additionalObj instanceof ASPxClientAxisTitle) {
     if (!this.inAxisTitle) {
      this.inAxisTitle = true;
      this.axisTitle = additionalObj;
     }
    }
   }
   if (additionalObj instanceof ASPx.HyperlinkSource) {
    this.inHyperlink = true;
    this.hyperlink = additionalObj.hyperlink;
   }
  }
 });
 var ASPxClientDiagramCoordinates = ASPx.CreateClass(null, {
  constructor: function () {
   this.argumentScaleType = '';
   this.valueScaleType = '';
   this.qualitativeArgument = '';
   this.numericalArgument = 0;
   this.dateTimeArgument = null;
   this.numericalValue = 0;
   this.dateTimeValue = null;
   this.axisX = null;
   this.axisY = null;
   this.pane = null;
   this.axisValueList = [];
  },
  SetAxisValue: function (axis, valueInternal) {
   var value = axis.GetNativeArgument(valueInternal);
   var axisValue = new ASPxClientAxisValue();
   axisValue.axis = axis;
   if (typeof (value) == 'string') {
    axisValue.qualitativeValue = value;
    axisValue.scaleType = ASPxClientScaleType.Qualitative;
   }
   else if (value instanceof Date) {
    axisValue.dateTimeValue = value;
    axisValue.scaleType = ASPxClientScaleType.DateTime;
   }
   else {
    axisValue.numericalValue = value;
    axisValue.scaleType = ASPxClientScaleType.Numerical;
   }
   this.axisValueList.push(axisValue);
  },
  SetArgumentAndValue: function (axisX, axisY, argumentInternal, valueInternal) {
   var argument = axisX.GetNativeArgument(argumentInternal);
   var value = axisY.GetNativeArgument(valueInternal);
   if (typeof (argument) == 'string') {
    this.qualitativeArgument = argument;
    this.argumentScaleType = ASPxClientScaleType.Qualitative;
   }
   else if (argument instanceof Date) {
    this.dateTimeArgument = argument;
    this.argumentScaleType = ASPxClientScaleType.DateTime;
   }
   else {
    this.numericalArgument = argumentInternal;
    this.argumentScaleType = ASPxClientScaleType.Numerical;
   }
   if (value instanceof Date) {
    this.dateTimeValue = value;
    this.valueScaleType = ASPxClientScaleType.DateTime;
   }
   else {
    this.numericalValue = valueInternal;
    this.valueScaleType = ASPxClientScaleType.Numerical;
   }
   this.SetAxisValue(axisX, argumentInternal);
   this.SetAxisValue(axisY, valueInternal);
  },
  IsEmpty: function () {
   return this.argumentScaleType == '';
  },
  GetAxisValue: function (axis) {
   for (var i = 0; i < this.axisValueList.length; i++)
    if (axis == this.axisValueList[i].axis)
     return this.axisValueList[i];
   return null;
  }
 });
 var ASPxClientAxisValue = ASPx.CreateClass(null, {
  constructor: function () {
   this.scaleType = '';
   this.qualitativeValue = '';
   this.numericalValue = 0;
   this.dateTimeValue = null;
   this.axis = null;
  }
 });
 var ASPxClientControlCoordinates = ASPx.CreateClass(null, {
  constructor: function () {
   this.pane = null;
   this.x = 0;
   this.y = 0;
   this.visibility = ASPxClientControlCoordinatesVisibility.Undefined;
  },
  GetValueSign: function (value) {
   if (value < 0)
    return -1;
   if (value > 0)
    return 1;
   return 0;
  },
  StrongRound: function (value) {
   return this.GetValueSign(value) * Math.floor(Math.abs(value) + 0.5);
  },
  SetPoint: function (x, y) {
   this.x = this.StrongRound(x);
   this.y = this.StrongRound(y);
  }
 });
 var ASPxClientLegendCheckBox = ASPx.CreateClass(null, {
  constructor: function (legendItemId) {
   this.legendItemId = legendItemId;
  }
 });
 var ASPxClientWebChartElement = ASPx.CreateClass(null, {
  constructor: function (chart, interimObject) {
   this.chart = chart;
   if (ASPx.IsExists(interimObject)) {
    this.InitializeProperties(interimObject);
    this.InitializeHitObjects(interimObject);
   }
   else
    this.InitializeDefault();
  },
  InitializeProperties: function (interimObject) {
   throw "ASPxClientWebChartElement abstract error";
  },
  InitializeDefault: function () {
   throw "ASPxClientWebChartElement abstract error";
  },
  InitializeHitObjects: function (interimObject) {
   var chartControl = this.chart != null ? this.chart.chartControl : this.chartControl;
   if (ASPx.IsExists(chartControl)) {
    if (ASPx.IsExists(chartControl.hitTestController)) {
     var hitTestController = chartControl.hitTestController;
     if (ASPx.IsExists(interimObject.hi))
      hitTestController.objects[interimObject.hi] = this;
     if (ASPx.IsExists(interimObject.hia))
      hitTestController.additionalObjects[interimObject.hia] = this;
    }
   }
  },
  CreateArray: function (interimArray, createArrayItem) {
   if (!ASPx.IsExists(interimArray))
    return [];
   if (!(interimArray instanceof Array))
    throw ASPxClientWebChartElement.objectModelError;
   var result = [];
   for (var i = 0; i < interimArray.length; i++)
    result.push(createArrayItem(this.chart, this, interimArray[i]));
   return result;
  }
 });
 ASPxClientWebChartElement.objectModelError = "Client object model error";
 var ASPxClientWebChartEmptyElement = ASPx.CreateClass(ASPxClientWebChartElement, {
  constructor: function (chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
  },
  InitializeProperties: function (interimObject) {
  },
  InitializeDefault: function () {
  }
 });
 var ASPxClientWebChartRequiredElement = ASPx.CreateClass(ASPxClientWebChartElement, {
  constructor: function (chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
  },
  InitializeDefault: function () {
   throw ASPxClientWebChartElement.objectModelError;
  }
 });
 var ASPxClientWebChartElementNamed = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.n))
    throw ASPxClientWebChartElement.objectModelError;
   this.name = interimObject.n;
  }
 });
 var ASPxClientWebChart = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chartControl, interimChart) {
   this.chartControl = chartControl;
   this.constructor.prototype.constructor.call(this, null, interimChart);
  },
  InitializeProperties: function (interimObject) {
   this.diagram =
    ASPx.IsExists(interimObject.d) ?
    this.CreateXYDiagram(interimObject.d) :
    new ASPxClientSimpleDiagram(this);
   this.series = this.CreateSeriesArray(interimObject.s);
   this.titles = this.CreateTitles(interimObject.ti);
   this.annotations = this.CreateAnnotations(interimObject.a);
   this.legend = new ASPxClientLegend(this, interimObject.l);
   this.legends = this.CreateLegendsArray(interimObject.al);
   this.appearanceName = interimObject.an;
   this.paletteName = interimObject.pn;
   this.showSeriesToolTip = ASPx.IsExists(interimObject.sst) ? interimObject.sst : false;
   this.showPointToolTip = ASPx.IsExists(interimObject.spt) ? interimObject.spt : false;
   this.showCrosshair = ASPx.IsExists(interimObject.sc) ? interimObject.sc : false;
   this.toolTipPosition = this.CreateToolTipPosition(this, interimObject.ttp);
   this.toolTipController = this.CreateToolTipController(this, interimObject.ttc);
   this.crosshairOptions = this.CreateCrosshairOptions(this, interimObject.co);
   this.cssPostfix = ASPx.IsExists(interimObject.css) ? interimObject.css : "";
   this.selectionMode = ASPx.IsExists(interimObject.sm) ? interimObject.sm : "";
  },
  CreateXYDiagram: function (interimXYDiagram) {
   if (interimXYDiagram.t == "XYD")
    return new ASPxClientXYDiagram(this, interimXYDiagram);
   else if (interimXYDiagram.t == "SPD")
    return new ASPxClientSwiftPlotDiagram(this, interimXYDiagram);
   else if (interimXYDiagram.t == "XYD3")
    return new ASPxClientXYDiagram3D(this, interimXYDiagram);
   else if (interimXYDiagram.t == "RD")
    return new ASPxClientRadarDiagram(this, interimXYDiagram);
   else
    throw ASPxClientWebChartElement.objectModelError;
  },
  CreateSeriesArray: function (interimSeriesArray) {
   return this.CreateArray(interimSeriesArray, function (nullChart, chart, intermSeries) {
    return new ASPxClientSeries(chart, intermSeries);
   });
  },
  CreateLegendsArray: function(interimLegendsArray) {
   return this.CreateArray(interimLegendsArray, function(nullChart, chart, interimLegend) {
    return new ASPxClientLegend(chart, interimLegend);
   });
  },
  CreateTitles: function (interimTitles) {
   return this.CreateArray(interimTitles, function (nullChart, chart, interimTitle) {
    return new ASPxClientChartTitle(chart, interimTitle);
   });
  },
  CreateAnnotations: function (interimAnnotations) {
   return this.CreateArray(interimAnnotations, function (nullChart, chart, interimAnnotation) {
    if (interimAnnotation.t == "TA")
     return new ASPxClientTextAnnotation(chart, interimAnnotation);
    else if (interimAnnotation.t == "IA")
     return new ASPxClientImageAnnotation(chart, interimAnnotation);
    else
     throw ASPxClientWebChartElement.objectModelError;
   });
  },
  CreateToolTipPosition: function (chart, interimPosition) {
   if (ASPx.IsExists(interimPosition) && (chart.showSeriesToolTip || chart.showPointToolTip)) {
    if (interimPosition.t == "FP")
     return new ASPxClientToolTipFreePosition(interimPosition);
    else if (interimPosition.t == "RP")
     return new ASPxClientToolTipRelativePosition(interimPosition);
    else if (interimPosition.t == "MP")
     return new ASPxClientToolTipMousePosition(interimPosition);
   }
   return null;
  },
  CreateToolTipController: function (chart, interimToolTipController) {
   if (ASPx.IsExists(interimToolTipController) && (chart.showSeriesToolTip || chart.showPointToolTip))
    return new ASPxClientToolTipController(chart, interimToolTipController);
   return null;
  },
  CreateCrosshairOptions: function(chart, interimCrosshairOptions) {
   if (ASPx.IsExists(interimCrosshairOptions))
    return new ASPxClientCrosshairOptions(chart, interimCrosshairOptions);
   return null;
  }
 });
 var ASPxClientSimpleDiagram = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function (chart) {
   this.constructor.prototype.constructor.call(this, chart);
  }
 });
 var ASPxClientXYDiagramBase = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, interimXYDiagram) {
   this.constructor.prototype.constructor.call(this, chart, interimXYDiagram);
  },
  InitializeProperties: function (interimObject) {
   this.axisX = this.CreateAxis(interimObject.x);
   this.axisY = this.CreateAxis(interimObject.y);
  },
  CreateAxis: function (interimAxis) {
   throw "ASPxClientXYDiagramBase abstract error";
  }
 });
 var ASPxClientXYDiagram2D = ASPx.CreateClass(ASPxClientXYDiagramBase, {
  constructor: function (chart, interimXYDiagram) {
   this.constructor.prototype.constructor.call(this, chart, interimXYDiagram);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientXYDiagramBase.prototype.InitializeProperties.call(this, interimObject);
   this.secondaryAxesX = this.CreateSecondaryAxes(interimObject.sx);
   this.secondaryAxesY = this.CreateSecondaryAxes(interimObject.sy);
   this.defaultPane = new ASPxClientXYDiagramPane(this.chart, this, interimObject.dp);
   this.panes = this.CreatePanes(interimObject.pa);
   if (ASPx.IsExists(interimObject.pld))
    this.paneLayoutDirection = interimObject.pld;
  },
  CreateSecondaryAxes: function (interimSecondaryAxes) {
   throw "ASPxClientXYDiagramBase abstract error";
  },
  CreatePanes: function (interimPanes) {
   return this.CreateArray(interimPanes, function (chart, diagram, interimPane) {
    return new ASPxClientXYDiagramPane(chart, diagram, interimPane);
   });
  },
  FindPaneByXY: function (x, y) {
   if (this.defaultPane.InPane(x, y))
    return this.defaultPane;
   for (var i = 0; i < this.panes.length; i++) {
    if (this.panes[i].InPane(x, y))
     return this.panes[i];
   }
   return null;
  },
  FindPaneByID: function (paneID) {
   if (paneID == -1)
    return this.defaultPane;
   if (this.panes != null) {
    for (var pane in this.panes) {
     if (this.panes[pane].paneID == paneID)
      return this.panes[pane];
    }
   }
   return null;
  },
  FindAxisXByID: function (axisID) {
   if (this.axisX.axisID == axisID)
    return this.axisX;
   for (var i = 0; i < this.secondaryAxesX.length; i++) {
    if (this.secondaryAxesX[i].axisID == axisID)
     return this.secondaryAxesX[i];
   }
   return null;
  },
  FindAxisYByID: function (axisID) {
   if (this.axisY.axisID == axisID)
    return this.axisY;
   for (var i = 0; i < this.secondaryAxesY.length; i++) {
    if (this.secondaryAxesY[i].axisID == axisID)
     return this.secondaryAxesY[i];
   }
   return null;
  },
  CalculateAxisValues: function (pane, axis, location, length) {
   if (axis == null || !ASPx.IsExists(axis.intervalBoundsCaches))
    return null;
   if (axis.reverse)
    location = length - location;
   var cacheItem = axis.intervalBoundsCaches.GetIntervalBoundsCacheItemByPaneID(pane.paneID);
   if (cacheItem == null)
    return null;
   var index = cacheItem.GetIntervalBoundsIndexByLocation(location);
   if (index < 0 || index >= axis.intervals.length)
    return null;
   var intervalBounds = cacheItem.intervalBoundsArray[index];
   var ratio = (location - intervalBounds.position) / intervalBounds.length;
   var interval = axis.intervals[index];
   var valueInternal = interval.GetInternalValue(ratio);
   if (ASPx.IsExists(axis.scale) && ASPx.IsExists(axis.scale.logarithmic))
    if (axis.scale.logarithmic)
     valueInternal = this.GetNativeValueForLogarithmic(ratio, interval.minLimit, interval.maxLimit, axis.scale);
   return valueInternal;
  },
  GetNativeValueForLogarithmic: function (ratio, minLimit, maxLimit, scale) {
   var logMinLimit = scale.TransformForward(minLimit);
   var logMaxLimit = scale.TransformForward(maxLimit);
   var logValue = (logMaxLimit - logMinLimit) * ratio + logMinLimit;
   return scale.TransformBackward(logValue);
  },
  GetNativeFromLogarithmicValue: function (value, minLimit, maxLimit, logarithmicBase) {
   var nativeValue = 0;
   var logMinLimit = minLimit == 0 ? 0 : Math.log(Math.abs(minLimit)) / Math.log(logarithmicBase)
   var logMaxLimit = maxLimit == 0 ? 0 : Math.log(Math.abs(maxLimit)) / Math.log(logarithmicBase)
   var logValue = Math.log(Math.abs(value)) / Math.log(logarithmicBase)
   nativeValue = maxLimit * (logValue - logMinLimit) / (logMaxLimit - logMinLimit);
   return nativeValue;
  },
  AddAxisValueToAxisValueList: function (axisValues, pane, axis, location, length) {
   valueInternal = this.CalculateAxisValues(pane, axis, location, length);
   if (valueInternal != null)
    axisValues.push(new ASPx.AxisValuePair(axis, valueInternal, location));
  },
  MapPointToInternal: function (pane, x, y) {
   var axisValues = [];
   var axesCoords = this.GetAxesCoordinates(pane, x, y);
   if (axesCoords == null)
    return axisValues;
   this.AddAxisValueToAxisValueList(axisValues, pane, this.FindAxisXByID(pane.primaryAxisXID), axesCoords.xLocation, axesCoords.xLength);
   this.AddAxisValueToAxisValueList(axisValues, pane, this.FindAxisYByID(pane.primaryAxisYID), axesCoords.yLocation, axesCoords.yLength);
   for (var i = 0; i < this.secondaryAxesX.length; i++)
    this.AddAxisValueToAxisValueList(axisValues, pane, this.secondaryAxesX[i], axesCoords.xLocation, axesCoords.xLength);
   for (var i = 0; i < this.secondaryAxesY.length; i++)
    this.AddAxisValueToAxisValueList(axisValues, pane, this.secondaryAxesY[i], axesCoords.yLocation, axesCoords.yLength);
   return axisValues;
  },
  AddAxisValue: function (coordinates, pane, axis, location, length) {
   var valueInternal = this.CalculateAxisValues(pane, axis, location, length);
   if (valueInternal != null)
    coordinates.SetAxisValue(axis, valueInternal);
  },
  GetAxesCoordinates: function (pane, x, y) {
   x -= pane.boundsLeft;
   y -= pane.boundsTop;
   if (x < 0 || x > pane.boundsWidth || y < 0 || y > pane.boundsHeight)
    return null;
   y = pane.boundsHeight - y;
   if (this.rotated)
    return { xLocation: y, yLocation: x, xLength: pane.boundsHeight, yLength: pane.boundsWidth };
   else
    return { xLocation: x, yLocation: y, xLength: pane.boundsWidth, yLength: pane.boundsHeight };
  },
  PointToDiagram: function (x, y) {
   var coordinates = new ASPxClientDiagramCoordinates();
   var pane = this.FindPaneByXY(x, y);
   if (pane == null)
    return coordinates;
   coordinates.pane = pane;
   var axesCoords = this.GetAxesCoordinates(pane, x, y);
   if (axesCoords == null)
    return coordinates;
   coordinates.axisX = this.FindAxisXByID(pane.primaryAxisXID);
   coordinates.axisY = this.FindAxisYByID(pane.primaryAxisYID);
   var argumentInternal = this.CalculateAxisValues(pane, coordinates.axisX, axesCoords.xLocation, axesCoords.xLength);
   var valueInternal = this.CalculateAxisValues(pane, coordinates.axisY, axesCoords.yLocation, axesCoords.yLength);
   if (argumentInternal != null && valueInternal != null)
    coordinates.SetArgumentAndValue(coordinates.axisX, coordinates.axisY, argumentInternal, valueInternal);
   for (var i = 0; i < this.secondaryAxesX.length; i++)
    this.AddAxisValue(coordinates, pane, this.secondaryAxesX[i], axesCoords.xLocation, axesCoords.xLength);
   for (var i = 0; i < this.secondaryAxesY.length; i++)
    this.AddAxisValue(coordinates, pane, this.secondaryAxesY[i], axesCoords.yLocation, axesCoords.yLength);
   return coordinates;
  },
  CalcIntervalIndexes: function (value, intervals, scale) {
   if (scale.logarithmic)
    value = scale.TransformBackward(value);
   var resultIndexes = [];
   var aboveIndex = -1;
   var belowIndex = -1;
   for (var i = 0; i < intervals.length; i++) {
    if (intervals[i].minLimit <= value && value <= intervals[i].maxLimit) {
     resultIndexes.push(i);
     return { indexes: resultIndexes, inRange: true };
    }
    if (value > intervals[i].maxLimit) {
     if (belowIndex == -1)
      belowIndex = i;
     else if (intervals[belowIndex].maxLimit < intervals[i].maxLimit)
      belowIndex = i;
    }
    if (value < intervals[i].minLimit) {
     if (aboveIndex == -1)
      aboveIndex = i;
     else if (intervals[aboveIndex].minLimit > intervals[i].minLimit)
      aboveIndex = i;
    }
   }
   if (belowIndex != -1)
    resultIndexes.push(belowIndex);
   if (aboveIndex != -1)
    resultIndexes.push(aboveIndex);
   return { indexes: resultIndexes, inRange: false };
  },
  CalcCoordWithinAndOutRange: function (value, intervals, cacheItem, index, scale) {
   var min = intervals[index].minLimit;
   var max = intervals[index].maxLimit;
   if (scale.logarithmic) {
    min = scale.TransformForward(min);
    max = scale.TransformForward(max);
   }
   var factor = max - min != 0 ? (value - min) / (max - min) : 0;
   var intervalBounds = cacheItem.intervalBoundsArray[index];
   return factor * intervalBounds.length + intervalBounds.position;
  },
  CalcCoordInScaleBreak: function (value, intervals, cacheItem, index1, index2) {
   var min = intervals[index1].maxLimit;
   var max = intervals[index2].minLimit;
   var factor = max - min != 0 ? (value - min) / (max - min) : 0;
   var intervalBoundsMin = cacheItem.intervalBoundsArray[index1];
   var intervalBoundsMax = cacheItem.intervalBoundsArray[index2];
   return factor * (intervalBoundsMax.position - intervalBoundsMin.highBound) + intervalBoundsMin.highBound;
  },
  CalcCoord: function (value, indexes, axis, cacheItem, length) {
   var coord;
   if (indexes.length == 1)
    coord = this.CalcCoordWithinAndOutRange(value, axis.intervals, cacheItem, indexes[0], axis.scale);
   else
    coord = this.CalcCoordInScaleBreak(value, axis.intervals, cacheItem, indexes[0], indexes[1]);
   if (axis.reverse)
    coord = length - coord;
   return coord;
  },
  CheckIndexes: function (indexes, intervals, cacheItem) {
   if (indexes.length < 1 || indexes.length > 2)
    return false;
   for (var i = 0; i < indexes.length; i++) {
    if (indexes[i] < 0 || indexes[i] >= intervals.length || indexes[i] >= cacheItem.intervalBoundsArray.length)
     return false;
   }
   return true;
  },
  IsAxisValueVisible: function (pane, axis, value) {
   if (axis.scale.logarithmic)
    value = axis.scale.TransformForward(value);
   var cacheItem = axis.intervalBoundsCaches.GetIntervalBoundsCacheItemByPaneID(pane.paneID);
   if (cacheItem == null)
    return false;
   var result = this.CalcIntervalIndexes(value, axis.intervals, axis.scale);
   if (!result.inRange)
    return false;
   var indexes = result.indexes;
   if (!this.CheckIndexes(indexes, axis.intervals, cacheItem))
    return false;
   return true;
  },
  MapInternalToPoint: function (pane, axis, value) {
   var isHorizontal = axis.isArgumentAxis ^ this.rotated;
   if (axis.scale.logarithmic)
    value = axis.scale.TransformForward(value);
   var cacheItem = axis.intervalBoundsCaches.GetIntervalBoundsCacheItemByPaneID(pane.paneID);
   if (cacheItem == null)
    return null;
   var result = this.CalcIntervalIndexes(value, axis.intervals, axis.scale);
   if (!result.inRange)
    return null;
   var indexes = result.indexes;
   if (!this.CheckIndexes(indexes, axis.intervals, cacheItem))
    return null;
   var length = isHorizontal ? pane.boundsWidth : pane.boundsHeight;
   var pointValue = this.CalcCoord(value, indexes, axis, cacheItem, length);
   if (isHorizontal)
    pointValue += pane.boundsLeft;
   else
    pointValue = pane.boundsHeight - pointValue + pane.boundsTop;
   return pointValue;
  },
  DiagramToPoint: function (argument, value, axisX, axisY, pane) {
   var coordinates = new ASPxClientControlCoordinates();
   if (!ASPx.IsExists(axisX.intervalBoundsCaches) || !ASPx.IsExists(axisY.intervalBoundsCaches))
    return coordinates;
   coordinates.pane = pane;
   var cacheItemX = axisX.intervalBoundsCaches.GetIntervalBoundsCacheItemByPaneID(pane.paneID);
   var cacheItemY = axisY.intervalBoundsCaches.GetIntervalBoundsCacheItemByPaneID(pane.paneID);
   if (cacheItemX == null || cacheItemY == null)
    return coordinates;
   var argumentInternal = axisX.GetInternalArgument(argument);
   if (axisX.scale instanceof ASPxClientQualitativeMap
    && (argumentInternal < axisX.intervals[0].minLimit || argumentInternal > axisX.intervals[axisX.intervals.length - 1].maxLimit))
    return coordinates;
   var valueInternal = axisY.GetInternalArgument(value);
   var resultsX = this.CalcIntervalIndexes(argumentInternal, axisX.intervals, axisX.scale);
   var resultsY = this.CalcIntervalIndexes(valueInternal, axisY.intervals, axisY.scale);
   var indexesX = resultsX.indexes;
   var indexesY = resultsY.indexes;
   if (!this.CheckIndexes(indexesX, axisX.intervals, cacheItemX)
    || !this.CheckIndexes(indexesY, axisY.intervals, cacheItemY))
    return coordinates;
   coordinates.visibility = resultsX.inRange && resultsY.inRange ? ASPxClientControlCoordinatesVisibility.Visible
    : ASPxClientControlCoordinatesVisibility.Hidden;
   var x, y;
   if (!this.rotated) {
    x = this.CalcCoord(argumentInternal, indexesX, axisX, cacheItemX, pane.boundsWidth);
    y = this.CalcCoord(valueInternal, indexesY, axisY, cacheItemY, pane.boundsHeight);
   }
   else {
    x = this.CalcCoord(valueInternal, indexesY, axisY, cacheItemY, pane.boundsWidth);
    y = this.CalcCoord(argumentInternal, indexesX, axisX, cacheItemX, pane.boundsHeight);
   }
   coordinates.SetPoint(x + pane.boundsLeft, pane.boundsTop + pane.boundsHeight - y);
   return coordinates;
  },
  ShowCrosshair: function(screenX, screenY) {
   if (ASPx.IsExists(this.chart) && ASPx.IsExists(this.chart.chartControl))
    this.chart.chartControl.showCrosshairForced(screenX, screenY);
  }
 });
 var ASPxClientXYDiagram = ASPx.CreateClass(ASPxClientXYDiagram2D, {
  constructor: function (chart, interimXYDiagram) {
   this.constructor.prototype.constructor.call(this, chart, interimXYDiagram);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientXYDiagram2D.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.dr))
    throw ASPxClientWebChartElement.objectModelError;
   this.rotated = interimObject.dr;
  },
  CreateAxis: function (interimAxis) {
   return new ASPxClientAxis(this.chart, this, interimAxis);
  },
  CreateSecondaryAxes: function (interimSecondaryAxes) {
   return this.CreateArray(interimSecondaryAxes, function (chart, diagram, interimSecondaryAxis) {
    return new ASPxClientAxis(chart, diagram, interimSecondaryAxis);
   });
  }
 });
 var ASPxClientSwiftPlotDiagram = ASPx.CreateClass(ASPxClientXYDiagram2D, {
  constructor: function (chart, interimXYDiagram) {
   this.constructor.prototype.constructor.call(this, chart, interimXYDiagram);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientXYDiagram2D.prototype.InitializeProperties.call(this, interimObject);
  },
  CreateAxis: function (interimAxis) {
   return new ASPxClientSwiftPlotDiagramAxis(this.chart, this, interimAxis);
  },
  CreateSecondaryAxes: function (interimSecondaryAxes) {
   return this.CreateArray(interimSecondaryAxes, function (chart, diagram, interimSecondaryAxis) {
    return new ASPxClientSwiftPlotDiagramAxis(chart, diagram, interimSecondaryAxis);
   });
  }
 });
 var ASPxClientXYDiagramPane = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, diagram, interimPane) {
   this.constructor.prototype.constructor.call(this, chart, interimPane);
   this.diagram = diagram;
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
   this.primaryAxisXID = interimObject.paxi;
   this.primaryAxisYID = interimObject.payi;
   this.paneID = interimObject.id;
   if (ASPx.IsExists(interimObject.dx))
    this.boundsLeft = interimObject.dx;
   if (ASPx.IsExists(interimObject.dy))
    this.boundsTop = interimObject.dy;
   if (ASPx.IsExists(interimObject.dw))
    this.boundsWidth = interimObject.dw;
   if (ASPx.IsExists(interimObject.dh))
    this.boundsHeight = interimObject.dh;
   if (ASPx.IsExists(interimObject.dh))
    this.visible = interimObject.vsb;
   if (ASPx.IsExists(interimObject.lb))
    this.axisLabelBounds = this.CreateAxisLabelBounds(interimObject.lb);
  },
  CreateAxisLabelBounds: function (interimAxisLabelBounds) {
   return this.CreateArray(interimAxisLabelBounds, function (chart, pane, interimObject) {
    return new ASPxClientAxisLabelBounds(chart, pane, interimObject);
   });
  },
  InPane: function (x, y) {
   if (ASPx.IsExists(this.boundsLeft) && ASPx.IsExists(this.boundsTop) &&
    ASPx.IsExists(this.boundsWidth) && ASPx.IsExists(this.boundsHeight) &&
    (this.boundsWidth > 0) && (this.boundsHeight > 0)) {
    x -= this.boundsLeft;
    y -= this.boundsTop;
    return (x >= 0) && (x <= this.boundsWidth) && (y >= 0) && (y <= this.boundsHeight);
   }
   return false;
  }
 });
 var ASPxClientXYDiagram3D = ASPx.CreateClass(ASPxClientXYDiagramBase, {
  constructor: function (chart, interimXYDiagram) {
   this.constructor.prototype.constructor.call(this, chart, interimXYDiagram);
  },
  CreateAxis: function (interimAxis) {
   return new ASPxClientAxis3D(this.chart, this, interimAxis);
  }
 });
 var ASPxClientRadarDiagram = ASPx.CreateClass(ASPxClientXYDiagramBase, {
  constructor: function (chart, interimXYDiagram) {
   this.constructor.prototype.constructor.call(this, chart, interimXYDiagram);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientXYDiagramBase.prototype.InitializeProperties.call(this, interimObject);
   if (ASPx.IsExists(interimObject.m))
    this.mapping = new ASPxClientRadarDiagramMapping(interimObject.m);
  },
  CreateAxis: function (interimAxis) {
   return new ASPxClientRadarAxis(this.chart, this, interimAxis);
  },
  CorrectAngle: function (angle) {
   if (this.mapping.revertAngle && angle != 0)
    angle = 2 * Math.PI - angle;
   if (this.mapping.diagramStartAngle >= 0) {
    if (angle >= this.mapping.diagramStartAngle)
     angle -= this.mapping.diagramStartAngle;
    else
     angle = 2 * Math.PI - this.mapping.diagramStartAngle + angle;
   }
   else {
    if (angle < 2 * Math.PI + this.mapping.diagramStartAngle)
     angle -= this.mapping.diagramStartAngle;
    else
     angle = angle - 2 * Math.PI - this.mapping.diagramStartAngle;
   }
   return angle;
  },
  CalcArgumentAndValueForPolygon: function (angle, dx, dy) {
   if (this.mapping.vertices.length <= 1)
    return null;
   var k = angle / (2 * Math.PI / (this.mapping.vertices.length - 1));
   var index = Math.floor(k);
   if (index < 0 || index >= this.mapping.vertices.length - 1)
    return null;
   var min = this.mapping.vertices[index];
   var max = this.mapping.vertices[index + 1];
   var divisor1 = (min.x - max.x) * dy - (min.y - max.y) * dx;
   if (divisor1 == 0)
    return null;
   var maxFactor = (min.x * dy - min.y * dx) / divisor1;
   var dist;
   var divisor2 = (min.x - max.x) * maxFactor - min.x;
   var divisor3 = (min.y - max.y) * maxFactor - min.y;
   if (dx != 0 && divisor2 != 0)
    dist = dx / divisor2;
   else if (dy != 0 && divisor3 != 0)
    dist = dy / divisor3;
   else
    return null;
   if (dist > this.mapping.radius)
    return null;
   valueInternal = dist / this.mapping.valueScaleFactor + this.mapping.minValue;
   argumentInternal = (max.argument - min.argument) * maxFactor + min.argument;
   return { argument: argumentInternal, value: valueInternal }
  },
  PointToDiagram: function (x, y) {
   var coordinates = new ASPxClientDiagramCoordinates();
   if (!ASPx.IsExists(this.mapping))
    return coordinates;
   if (this.axisX == null || this.axisY == null)
    return coordinates;
   coordinates.axisX = this.axisX;
   coordinates.axisY = this.axisY;
   var dy = this.mapping.centerY - y;
   var dx = this.mapping.centerX - x;
   var distance = Math.sqrt(dy * dy + dx * dx);
   if (this.mapping.radius == 0 || distance > this.mapping.radius)
    return coordinates;
   var argumentInternal, valueInternal;
   if (distance == 0) {
    argumentInternal = this.mapping.minArgument;
    valueInternal = this.mapping.minValue;
   }
   else {
    var angleCos = dy / distance;
    if (angleCos > 1 || angleCos < -1)
     return coordinates;
    var angle = Math.acos(angleCos);
    if (x < this.mapping.centerX)
     angle = Math.PI * 2 - angle;
    angle = this.CorrectAngle(angle);
    if (this.mapping.circle) {
     valueInternal = distance / this.mapping.valueScaleFactor + this.mapping.minValue;
     argumentInternal = angle / Math.PI / 2.0 * this.mapping.argumentDiapason + this.mapping.minArgument;
    }
    else {
     var values = this.CalcArgumentAndValueForPolygon(angle, dx, dy);
     if (values == null)
      return coordinates;
     argumentInternal = values.argument;
     valueInternal = values.value;
    }
   }
   if (this.axisX.scale instanceof ASPxClientQualitativeMap)
    if (argumentInternal > this.mapping.minArgument + this.mapping.argumentDiapason - this.mapping.argumentDelta / 2)
     argumentInternal -= this.mapping.argumentDiapason;
   if (this.axisX.scale.logarithmic)
    argumentInternal = this.axisX.scale.TransformBackward(argumentInternal);
   if (this.axisY.scale.logarithmic)
    valueInternal = this.axisY.scale.TransformBackward(valueInternal);
   coordinates.SetArgumentAndValue(this.axisX, this.axisY, argumentInternal, valueInternal);
   return coordinates;
  },
  DiagramToPoint: function (argument, value) {
   var coordinates = new ASPxClientControlCoordinates();
   if (!ASPx.IsExists(this.mapping))
    return coordinates;
   var argumentInternal = this.axisX.GetInternalArgument(argument);
   var valueInternal = this.axisY.GetInternalArgument(value);
   var point = this.mapping.GetGetScreenPoint(argumentInternal, valueInternal);
   if (point == null)
    return coordinates;
   coordinates.visibility = valueInternal > this.mapping.maxValue ? ASPxClientControlCoordinatesVisibility.Hidden : ASPxClientControlCoordinatesVisibility.Visible;
   coordinates.SetPoint(point.x, point.y);
   return coordinates;
  }
 });
 var ASPxClientRadarDiagramMapping = ASPx.CreateClass(null, {
  constructor: function (interimMapping) {
   if (ASPx.IsExists(interimMapping.r))
    this.radius = interimMapping.r;
   if (ASPx.IsExists(interimMapping.cx))
    this.centerX = interimMapping.cx;
   if (ASPx.IsExists(interimMapping.cy))
    this.centerY = interimMapping.cy;
   if (ASPx.IsExists(interimMapping.ma))
    this.minArgument = interimMapping.ma;
   if (ASPx.IsExists(interimMapping.mv))
    this.minValue = interimMapping.mv;
   if (ASPx.IsExists(interimMapping.ra))
    this.revertAngle = interimMapping.ra;
   if (ASPx.IsExists(interimMapping.a))
    this.diagramStartAngle = interimMapping.a;
   if (ASPx.IsExists(interimMapping.f))
    this.valueScaleFactor = interimMapping.f;
   if (ASPx.IsExists(interimMapping.d))
    this.argumentDiapason = interimMapping.d;
   if (ASPx.IsExists(interimMapping.ad))
    this.argumentDelta = interimMapping.ad;
   if (ASPx.IsExists(interimMapping.ci))
    this.circle = interimMapping.ci;
   if (ASPx.IsExists(interimMapping.c))
    this.clipArgument = interimMapping.c;
   if (ASPx.IsExists(interimMapping.mxa))
    this.maxArgument = interimMapping.mxa;
   if (ASPx.IsExists(interimMapping.mxv))
    this.maxValue = interimMapping.mxv;
   if (ASPx.IsExists(interimMapping.sa))
    this.startAngle = interimMapping.sa;
   this.vertices = this.CreateArray(interimMapping.v, function (interimVertex) {
    return new ASPxClientVertex(interimVertex);
   });
  },
  CreateArray: function (interimArray, createArrayItem) {
   if (!ASPx.IsExists(interimArray))
    return [];
   if (!(interimArray instanceof Array))
    throw ASPxClientWebChartElement.objectModelError;
   var result = [];
   for (var i = 0; i < interimArray.length; i++)
    result.push(createArrayItem(interimArray[i]));
   return result;
  },
  GetGetScreenPoint: function (argument, value) {
   if (this.clipArgument && (argument < this.minArgument || argument > this.maxArgument))
    return null;
   while (argument < this.minArgument)
    argument += this.argumentDiapason;
   while (argument > this.maxArgument)
    argument -= this.argumentDiapason;
   if (value < this.minValue)
    value = this.minValue;
   var x, y;
   if (this.circle) {
    var distance = (value - this.minValue) * this.valueScaleFactor;
    var angle = (argument - this.minArgument) / this.argumentDiapason * Math.PI * 2.0;
    if (this.revertAngle)
     angle = -angle;
    angle += this.startAngle;
    x = Math.cos(angle) * distance + this.centerX;
    y = Math.sin(angle) * distance + this.centerY;
   }
   else {
    var distance = (value - this.minValue) * this.valueScaleFactor;
    var coord = (argument - this.minArgument) / this.argumentDelta;
    var index = Math.floor(coord);
    if (index < 0)
     index = 0;
    else if (index >= this.vertices.length - 1)
     index = this.vertices.length - 2;
    var min = this.vertices[index];
    var max = this.vertices[index + 1];
    var maxFactor = (argument - min.argument) / (max.argument - min.argument);
    var minFactor = 1.0 - maxFactor;
    x = (min.x * minFactor + max.x * maxFactor) * distance + this.centerX;
    y = (min.y * minFactor + max.y * maxFactor) * distance + this.centerY;
   }
   return { x: x, y: y };
  }
 });
 var ASPxClientVertex = ASPx.CreateClass(null, {
  constructor: function (interimVertex) {
   if (!ASPx.IsExists(interimVertex.a))
    throw ASPxClientWebChartElement.objectModelError;
   this.argument = interimVertex.a;
   if (!ASPx.IsExists(interimVertex.x))
    throw ASPxClientWebChartElement.objectModelError;
   this.x = interimVertex.x;
   if (!ASPx.IsExists(interimVertex.y))
    throw ASPxClientWebChartElement.objectModelError;
   this.y = interimVertex.y;
  }
 });
 var ASPxClientQualitativeMap = ASPx.CreateClass(null, {
  constructor: function (interimMap) {
   if (!ASPx.IsExists(interimMap.vl))
    throw ASPxClientWebChartElement.objectModelError;
   this.values = interimMap.vl;
  },
  GetNativeValue: function (internalValue) {
   var roundedValue = Math.round(internalValue);
   return (roundedValue < 0 || roundedValue >= this.values.length) ? null : this.values[roundedValue];
  },
  GetInternalValue: function (value) {
   for (var i = 0; i < this.values.length; i++) {
    if (this.values[i] == value)
     return i;
   }
   return -1;
  }
 });
 var ASPxClientNumericalMap = ASPx.CreateClass(null, {
  constructor: function (interimMap) {
   if (!ASPx.IsExists(interimMap.l))
    throw ASPxClientWebChartElement.objectModelError;
   this.logarithmic = interimMap.l;
   if (this.logarithmic) {
    if (!ASPx.IsExists(interimMap.lb) || !ASPx.IsExists(interimMap.mlv))
     throw ASPxClientWebChartElement.objectModelError;
    this.logarithmicBase = interimMap.lb;
    this.minLogValue = interimMap.mlv;
   }
  },
  GetValueSign: function (value) {
   if (value < 0)
    return -1;
   if (value > 0)
    return 1;
   return 0;
  },
  TransformBackward: function (value) {
   return isFinite(value) ? Math.pow(this.logarithmicBase, Math.abs(value) + this.minLogValue) * this.GetValueSign(value) : value;
  },
  TransformForward: function (value) {
   if (!isFinite(value))
    return value;
   var transformedAbsValue = Math.log(Math.abs(value)) / Math.log(this.logarithmicBase) - this.minLogValue;
   if (transformedAbsValue < 0)
    transformedAbsValue = 0;
   return this.GetValueSign(value) * transformedAbsValue;
  },
  GetNativeValue: function (internalValue) {
   return this.logarithmic ? this.TransformBackward(internalValue) : internalValue;
  },
  GetInternalValue: function (value) {
   return this.logarithmic ? this.TransformForward(value) : value;
  }
 });
 var ASPxClientDateTimeMap = ASPx.CreateClass(null, {
  constructor: function (interimMap) {
   if (!ASPx.IsExists(interimMap.su) || !ASPx.IsExists(interimMap.sa) || !ASPx.IsExists(interimMap.sv))
    throw ASPxClientWebChartElement.objectModelError;
   this.measureUnit = interimMap.su;
   this.gridAlignment = interimMap.sa;
   this.startDate = this.ParseStartDate(interimMap.sv);
   if (ASPx.IsExists(interimMap.swo))
    this.workdaysOnly = interimMap.swo;
   else
    this.workdaysOnly = false;
   if (this.workdaysOnly) {
    if (!ASPx.IsExists(interimMap.sw))
     throw ASPxClientWebChartElement.objectModelError;
    this.workdays = interimMap.sw;
    this.holidaysCount = this.CalcHolidaysCountInWeek();
    this.workdaysCount = 7 - this.holidaysCount;
    if (ASPx.IsExists(interimMap.sh))
     this.holidays = interimMap.sh;
    else
     this.holidays = [];
    if (ASPx.IsExists(interimMap.sew))
     this.exactWorkdays = interimMap.sew;
    else
     this.exactWorkdays = [];
   }
  },
  ParseStartDate: function (startDateString) {
   var date = new Date(1, 1, 1);
   var year = startDateString.substring(0, 4);
   var month = startDateString.substring(5, 7) - 1;
   var day = startDateString.substring(8, 10);
   date.setFullYear(year, month, day);
   return date;
  },
  CalcHolidaysCountInWeek: function () {
   var result = 0;
   var dayFlag = 1;
   for (var i = 0; i < 7; i++) {
    if ((this.workdays & dayFlag) == 0)
     result++;
    dayFlag <<= 1;
   }
   return result;
  },
  AddDays: function (dateTime, count) {
   return new Date(dateTime.getTime() + count * 1000 * 60 * 60 * 24);
  },
  GetTotalDays: function (fromDate, toDate) {
   return (toDate.getTime() - fromDate.getTime()) / 24 / 60 / 60 / 1000;
  },
  GetDate: function (n) {
   var diffMinutes = this.startDate.getTimezoneOffset() - new Date(this.startDate.getTime() + n).getTimezoneOffset();
   var diffMilliseconds = diffMinutes * 60 * 1000;
   return new Date(this.startDate.getTime() + n - diffMilliseconds);
  },
  GetMonth: function (n, date) {
   var fromDate = ASPx.IsExists(date) ? date : this.startDate;
   var monthsCount = Math.abs(n);
   var years = Math.floor(monthsCount / 12);
   var monthsFractional = monthsCount - years * 12;
   var months = Math.floor(monthsFractional);
   var fraction = monthsFractional - months;
   if (n < 0) {
    years = -years;
    months = -months;
    fraction = -fraction;
   }
   var year = fromDate.getFullYear() + years;
   var month = fromDate.getMonth() + months;
   if (month < 0) {
    year = year - 1;
    month = month + 12;
   }
   else if (month >= 12) {
    year = year + 1;
    month = month - 12;
   }
   var result = new Date(1, 1, 1);
   result.setFullYear(year, month, 1);
   if (fraction < 0) {
    var previousMonth;
    if (month == 0)
     previousMonth = new Date(year - 1, 11, 1);
    else
     previousMonth = new Date(year, month - 1, 1);
    return new Date(result.getTime() + (result.getTime() - previousMonth.getTime()) * fraction);
   }
   else {
    var nextMonth;
    if (month == 11)
     nextMonth = new Date(year + 1, 1, 1);
    else
     nextMonth = new Date(year, month + 1, 1);
    return new Date(result.getTime() + (nextMonth.getTime() - result.getTime()) * fraction);
   }
  },
  TruncateTime: function (date) {
   var truncatedDate = new Date(1, 1, 1);
   truncatedDate.setFullYear(date.getFullYear(), date.getMonth(), date.getDate());
   return truncatedDate;
  },
  IsHoliday: function (dateTime, applyHolidays, applyExactWorkdays) {
   if (!this.workdaysOnly)
    return false;
   var isHoliday = (this.workdays & (1 << dateTime.getDay())) == 0;
   if (applyHolidays || applyExactWorkdays) {
    var date = new Date(1, 1, 1);
    date.setFullYear(dateTime.getFullYear(), dateTime.getMonth(), dateTime.getDate());
    var time = date.getTime();
    if (applyHolidays)
     for (holiday in this.holidays)
      if (time == this.holidays[holiday].getTime()) {
       isHoliday = true;
       break;
      }
    if (applyExactWorkdays)
     for (exactWorkDay in this.exactWorkdays)
      if (time == this.exactWorkdays[exactWorkDay].getTime()) {
       isHoliday = false;
       break;
      }
   }
   return isHoliday;
  },
  SkipHoliday: function (dateTime) {
   var result = new Date(dateTime.getTime());
   if (this.workdays == 0)
    return result;
   while (this.IsHoliday(result, true, true)) {
    var newDate = this.AddDays(result, 1);
    if (newDate.getDate() == result.getDate()) {
     newDate = new Date(result.getTime() + 1000 * 60 * 60 * 26);
    }
    result = this.TruncateTime(newDate);
   }
   return result;
  },
  Floor: function (dateTime) {
   return this.FloorToDateTimeMeasureUnit(dateTime, this.measureUnit);
  },
  FloorToDateTimeMeasureUnit: function (dateTime, dateTimeMeasureUnit) {
   var result = new Date(dateTime.getTime());
   switch (dateTimeMeasureUnit) {
    case 'Year':
     result.setMonth(0, 1);
     result = this.TruncateTime(result);
     break;
    case 'Month':
     result.setDate(1);
     result = this.TruncateTime(result);
     break;
    case 'Day':
     result = this.TruncateTime(result);
     break;
    case 'Hour':
     result.setMinutes(0, 0, 0);
     break;
    case 'Minute':
     result.setSeconds(0, 0);
     break;
    case 'Second':
     result.setMilliseconds(0);
     break;
    case 'Quarter':
     result = this.GetMonth(-(result.getMonth() % 3), result);
     result.setDate(1);
     break;
    case 'Week': {
     var offset = result.getDay() - this.startDate.getDay();
     result = this.TruncateTime(this.AddDays(result, -(offset >= 0 ? offset : (offset + 7))));
     break;
    }
   }
   return result;
  },
  Round: function (dateTime) {
   if (this.measureUnit != 'Millisecond') {
    if (dateTime.getMilliseconds() >= 500)
     dateTime.setSeconds(dateTime.getSeconds() + 1);
    dateTime.setMilliseconds(0);
    if (this.measureUnit != 'Second') {
     if (dateTime.getSeconds() >= 30)
      dateTime.setMinutes(dateTime.getMinutes() + 1);
     dateTime.setSeconds(0);
     if (this.measureUnit != 'Minute') {
      if (dateTime.getMinutes() >= 30)
       dateTime.setHours(dateTime.getHours() + 1);
      dateTime.setMinutes(0);
      if (this.measureUnit != 'Hour') {
       if (dateTime.getHours() >= 12)
        dateTime.setDate(dateTime.getDate() + 1);
       dateTime.setHours(0);
       if (this.measureUnit != 'Day') {
        if (this.measureUnit == 'Week') {
         var date = dateTime.getDate() - dateTime.getDay() + this.startDate.getDay();
         if (dateTime.getDay() >= this.startDate.getDay())
          dateTime.setDate(date);
         else
          dateTime.setDate(date - 7);
        }
        else {
         var half;
         if (dateTime.getMonth() == 2)
          half = 15;
         else
          half = 16;
         if (dateTime.getDate() >= half)
          dateTime.setMonth(dateTime.getMonth() + 1);
         dateTime.setDate(1);
         if (this.measureUnit != 'Month') {
          if (this.measureUnit == 'Quarter')
           dateTime.setMonth(Math.floor(dateTime.getMonth() / 3) * 3);
          else if (this.measureUnit == 'Year') {
           if (dateTime.getMonth() >= 6)
            dateTime.setFullYear(dateTime.getFullYear() + 1);
           dateTime.setMonth(0);
          }
          else
           return initialDate;
         }
        }
       }
      }
     }
    }
   }
   return dateTime;
  },
  AddUnits: function (range, factor) {
   range = range * factor;
   var integerRange = Math.floor(range);
   var remain = range - integerRange;
   var result = this.GetMonth(integerRange, this.startDate);
   var daysInMonth = this.GetTotalDays(result, this.GetMonth(1, result));
   if (this.workdaysOnly) {
    var dayCount = 0;
    var currentDate = new Date(result.getTime());
    for (var i = 0; i < daysInMonth; i++) {
     if (!this.IsHoliday(currentDate, true, true))
      dayCount++;
     currentDate = this.AddDays(currentDate, 1);
    }
    remain *= dayCount;
    while (remain >= 0.5) {
     if (!this.IsHoliday(result, true, true))
      remain -= 1;
     result = this.AddDays(result, 1);
    }
    if (remain > 0)
     while (this.IsHoliday(result, true, true))
      result = this.AddDays(result, 1);
    return this.SkipHoliday(this.AddDays(result, remain));
   }
   else
    return this.AddDays(result, daysInMonth * remain);
  },
  CorrectRangeBasedOnHolidays: function (range, multiplier) {
   if (range == 0 || this.holidaysCount == 7)
    return range;
   var fromDate = this.TruncateTime(this.startDate);
   var actualDate = new Date(fromDate.getTime());
   var dayRange = Math.floor((range + (this.startDate.getTime() - actualDate.getTime()) / (1000 * 60 * 60 * 24) * multiplier) / multiplier);
   var remain = range - (dayRange * multiplier);
   if (dayRange > 0) {
    var fullWeeks = Math.floor(dayRange / this.workdaysCount);
    var remainWeekDays = dayRange % this.workdaysCount;
    for (; remainWeekDays > 0;) {
     if (this.IsHoliday(actualDate, false, false))
      dayRange++;
     else
      remainWeekDays--;
     actualDate = this.AddDays(actualDate, 1);
    }
    dayRange += fullWeeks * this.holidaysCount;
    actualDate = this.AddDays(fromDate, dayRange);
    while (this.IsHoliday(actualDate, false, false)) {
     dayRange++;
     actualDate = this.AddDays(actualDate, 1);
    }
    for (holiday in this.holidays) {
     var holidayDate = this.holidays[holiday];
     if (holidayDate >= fromDate && holidayDate <= actualDate && !this.IsHoliday(holidayDate, false, false))
      do {
       dayRange++;
       actualDate = this.AddDays(actualDate, 1);
      } while (this.IsHoliday(actualDate, false, false));
    }
    for (workday in this.exactWorkdays) {
     var workDate = this.exactWorkdays[workday];
     if (workDate >= fromDate && workDate <= actualDate && this.IsHoliday(workDate, true, false))
      do {
       dayRange--;
       actualDate = this.AddDays(actualDate, -1);
      } while (this.IsHoliday(actualDate, true, true));
    }
    range = dayRange * multiplier + remain;
   }
   else {
    var fullWeeks = Math.ceil(dayRange / this.workdaysCount);
    var remainWeekDays = dayRange % this.workdaysCount;
    for (; remainWeekDays < 0;) {
     if (this.IsHoliday(actualDate, false, false))
      dayRange--;
     else
      remainWeekDays++;
     actualDate = this.AddDays(actualDate, -1);
    }
    dayRange += fullWeeks * this.holidaysCount;
    actualDate = this.AddDays(fromDate, dayRange);
    while (this.IsHoliday(actualDate, false, false)) {
     dayRange--;
     actualDate = this.AddDays(actualDate, -1);
    }
    var revertedHolidays = [];
    for (holiday in this.holidays)
     revertedHolidays.unshift(this.holidays[holiday]);
    for (holiday in revertedHolidays) {
     var holidayDate = revertedHolidays[holiday];
     if (holidayDate >= actualDate && holidayDate <= fromDate && !this.IsHoliday(holidayDate, false, false))
      do {
       dayRange--;
       actualDate = this.AddDays(actualDate, -1);
      } while (this.IsHoliday(actualDate, false, false));
    }
    for (workday in this.exactWorkdays) {
     var workDate = this.exactWorkdays[workday];
     if (workDate >= actualDate && workDate <= fromDate && this.IsHoliday(workDate, true, false))
      do {
       dayRange++;
       actualDate = this.AddDays(actualDate, 1);
      } while (this.IsHoliday(actualDate, true, true));
    }
    range = dayRange * multiplier + remain;
   }
   return range;
  },
  GetNativeValue: function (internalValue) {
   var nativeValue;
   switch (this.measureUnit) {
    case 'Year':
     nativeValue = this.AddUnits(internalValue, 12);
     break;
    case 'Quarter':
     nativeValue = this.AddUnits(internalValue, 3);
     break;
    case 'Month':
     nativeValue = this.AddUnits(internalValue, 1);
     break;
    case 'Week':
     if (this.workdaysOnly) {
      var fullWeeks = Math.floor(internalValue);
      var remain = internalValue - fullWeeks;
      nativeValue = this.AddDays(this.startDate, fullWeeks * 7);
      var weekDaysCount = 0;
      for (var i = 0; i < 7; i++)
       if (!this.IsHoliday(this.AddDays(nativeValue, i), true, true))
        weekDaysCount++;
      remain *= weekDaysCount;
      while (remain >= 0.5) {
       if (!this.IsHoliday(nativeValue, true, true))
        remain -= 1;
       nativeValue = this.AddDays(nativeValue, 1);
      }
      nativeValue = this.SkipHoliday(this.AddDays(nativeValue, remain));
     }
     else
      nativeValue = this.GetDate(internalValue * 1000 * 60 * 60 * 24 * 7);
     break;
    case 'Day':
     if (this.workdaysOnly)
      internalValue = this.CorrectRangeBasedOnHolidays(internalValue, 1)
     nativeValue = this.AddDays(this.startDate, internalValue);
     break;
    case 'Hour':
     if (this.workdaysOnly)
      internalValue = this.CorrectRangeBasedOnHolidays(internalValue, 24)
     nativeValue = this.GetDate(internalValue * 1000 * 60 * 60);
     break;
    case 'Minute':
     if (this.workdaysOnly)
      internalValue = this.CorrectRangeBasedOnHolidays(internalValue, 24 * 60)
     nativeValue = this.GetDate(internalValue * 1000 * 60);
     break;
    case 'Second':
     if (this.workdaysOnly)
      internalValue = this.CorrectRangeBasedOnHolidays(internalValue, 24 * 60 * 60)
     nativeValue = this.GetDate(internalValue * 1000);
     break;
    case 'Millisecond':
     if (this.workdaysOnly)
      internalValue = this.CorrectRangeBasedOnHolidays(internalValue, 24 * 60 * 60 * 1000)
     nativeValue = this.GetDate(internalValue);
     break;
    default:
     nativeValue = this.GetDate(0);
     break;
   }
   return this.Round(nativeValue);
  },
  TotalUnits: function (dateTime, majorUnit) {
   var monthRounded = this.FloorToDateTimeMeasureUnit(dateTime, 'Month');
   var dayRounded = this.FloorToDateTimeMeasureUnit(dateTime, 'Day');
   var daysInMonth = this.GetTotalDays(monthRounded, this.GetMonth(1, monthRounded));
   var monthAddition;
   if (this.workdaysOnly) {
    var dayCount = 0;
    var actualDaysInMonth = 0;
    var currentDate = new Date(monthRounded.getTime());
    for (var i = 0; i < daysInMonth; i++) {
     if (!this.IsHoliday(currentDate, true, true)) {
      actualDaysInMonth++;
      if (currentDate < dayRounded)
       dayCount++;
     }
     currentDate = this.AddDays(currentDate, 1);
    }
    monthAddition = actualDaysInMonth == 0 ? 0 : (dayCount / actualDaysInMonth);
    daysInMonth = actualDaysInMonth;
   }
   else
    monthAddition = this.GetTotalDays(monthRounded, dayRounded) / daysInMonth;
   var divider = daysInMonth * 24 * 60 * 60 * 1000;
   return (monthRounded.getFullYear() * 12 + monthRounded.getMonth() - 1 + monthAddition +
     (dateTime.getTime() - dayRounded.getTime()) / divider) / majorUnit;
  },
  CorrectDifferenceBasedOnHolidays: function (value, multiplier) {
   if (this.holidaysCount == 7)
    return value;
   var actualDate = this.TruncateTime(this.startDate);
   var totalDays = Math.floor((value + this.GetTotalDays(actualDate, this.startDate) * multiplier) / multiplier);
   if (totalDays > 0) {
    var fullWeeks = Math.floor(totalDays / 7);
    value -= fullWeeks * this.holidaysCount * multiplier;
    var remainWeekDays = totalDays % 7;
    for (var i = 0; i < remainWeekDays; i++) {
     if (this.IsHoliday(actualDate, false, false))
      value -= multiplier;
     actualDate = this.AddDays(actualDate, 1);
    }
   }
   else if (totalDays < 0) {
    var fullWeeks = Math.ceil(totalDays / 7);
    value -= fullWeeks * this.holidaysCount * multiplier;
    var remainWeekDays = totalDays % 7;
    for (var i = 0; i > remainWeekDays; i--) {
     if (this.IsHoliday(actualDate, false, false))
      value += multiplier;
     actualDate = this.AddDays(actualDate, -1);
    }
   }
   actualDate = this.TruncateTime(this.startDate);
   var finishDate = this.AddDays(actualDate, totalDays);
   if (finishDate < actualDate) {
    for (holiday in this.holidays) {
     var holidayDate = this.holidays[holiday];
     if (holidayDate <= actualDate && holidayDate > finishDate && !this.IsHoliday(holidayDate, false, false))
      value += multiplier;
    }
    for (exactWorkdate in this.exactWorkdays) {
     var workDate = this.exactWorkdays[exactWorkdate];
     if (workDate <= actualDate && workDate > finishDate && this.IsHoliday(workDate, true, false))
      value -= multiplier;
    }
   }
   else {
    for (holiday in this.holidays) {
     var holidayDate = this.holidays[holiday];
     if (holidayDate >= actualDate && holidayDate < finishDate && !this.IsHoliday(holidayDate, false, false))
      value -= multiplier;
    }
    for (exactWorkdate in this.exactWorkdays) {
     var workDate = this.exactWorkdays[exactWorkdate];
     if (workDate >= actualDate && workDate < finishDate && this.IsHoliday(workDate, true, false))
      value += multiplier;
    }
   }
   return value;
  },
  GetTimeDifference: function (date1, date2) {
   return date1.getTime() - date2.getTime() - (date1.getTimezoneOffset() - date2.getTimezoneOffset()) * 60 * 1000;
  },
  GetInternalValue: function (value) {
   if (this.workdaysOnly)
    value = this.SkipHoliday(value);
   var roundedToDate = this.Floor(value);
   switch (this.measureUnit) {
    case 'Year':
     return this.TotalUnits(roundedToDate, 12) - this.TotalUnits(this.startDate, 12);
    case 'Quarter':
     return this.TotalUnits(roundedToDate, 3) - this.TotalUnits(this.startDate, 3);
    case 'Month':
     return this.TotalUnits(roundedToDate, 1) - this.TotalUnits(this.startDate, 1);
    case 'Week': {
     if (!this.workdaysOnly)
      return (roundedToDate.getTime() - this.startDate.getTime()) / 7 / 24 / 60 / 60 / 1000;
     var roundedToWeek = this.FloorToDateTimeMeasureUnit(value, 'Week');
     var roundedToDay = this.FloorToDateTimeMeasureUnit(value, 'Day');
     var weekDaysCount = 0;
     var spentDaysCount = 0;
     var tempDate = roundedToWeek;
     for (var i = 0; i < 7; i++) {
      if (!this.IsHoliday(tempDate, true, true)) {
       weekDaysCount++;
       if (tempDate < roundedToDay)
        spentDaysCount++;
      }
      tempDate = this.AddDays(tempDate, 1);
     }
     return this.GetTotalDays(this.startDate, roundedToWeek) / 7 +
        (spentDaysCount + this.GetTotalDays(roundedToDay, value)) / weekDaysCount;
    }
    case 'Day': {
     var totalDays = this.GetTotalDays(this.startDate, roundedToDate);
     if (this.workdaysOnly)
      totalDays = this.CorrectDifferenceBasedOnHolidays(totalDays, 1);
     return totalDays;
    }
    case 'Hour': {
     var totalHours = this.GetTimeDifference(roundedToDate, this.startDate) / 60 / 60 / 1000;
     if (this.workdaysOnly)
      totalHours = this.CorrectDifferenceBasedOnHolidays(totalHours, 24);
     return totalHours;
    }
    case 'Minute': {
     var totalMinutes = this.GetTimeDifference(roundedToDate, this.startDate) / 60 / 1000;
     if (this.workdaysOnly)
      totalMinutes = this.CorrectDifferenceBasedOnHolidays(totalMinutes, 24 * 60);
     return totalMinutes;
    }
    case 'Second': {
     var totalSeconds = this.GetTimeDifference(roundedToDate, this.startDate) / 1000;
     if (this.workdaysOnly)
      totalSeconds = this.CorrectDifferenceBasedOnHolidays(totalSeconds, 24 * 60 * 60);
     return totalSeconds;
    }
    case 'Millisecond': {
     var totalMilliseconds = this.GetTimeDifference(roundedToDate, this.startDate);
     if (this.workdaysOnly)
      totalMilliseconds = this.CorrectDifferenceBasedOnHolidays(totalMilliseconds, 24 * 60 * 60 * 1000);
     return totalMilliseconds;
    }
    default:
     return 0;
   }
  }
 });
 var ASPxClientAxisBase = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, diagram, interimAxis) {
   this.constructor.prototype.constructor.call(this, chart, interimAxis);
   this.diagram = diagram;
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.r))
    throw ASPxClientWebChartElement.objectModelError;
   this.range = new ASPxClientAxisRange(this.chart, this, interimObject.r);
   if (ASPx.IsExists(interimObject.m))
    this.scale = this.CreateMap(interimObject.m);
   if (ASPx.IsExists(interimObject.l))
    this.labelItems = this.CreateLabelItems(interimObject.l);
  },
  CreateMap: function (interimMap) {
   if (interimMap.t == "N")
    return new ASPxClientNumericalMap(interimMap);
   if (interimMap.t == "Q")
    return new ASPxClientQualitativeMap(interimMap);
   if (interimMap.t == "D")
    return new ASPxClientDateTimeMap(interimMap);
   throw ASPxClientWebChartElement.objectModelError;
  },
  CreateLabelItems: function (interimLabelItems) {
   return this.CreateArray(interimLabelItems, createLabelItem = function (chart, axis, interimLabelItem) {
    return new ASPxClientAxisLabelItem(chart, axis, interimLabelItem);
   });
  },
  GetNativeArgument: function (value) {
   return (this.scale == null) ? value : this.scale.GetNativeValue(value);
  },
  GetInternalArgument: function (value) {
   return (this.scale == null) ? value : this.scale.GetInternalValue(value);
  }
 });
 var ASPxClientAxis2D = ASPx.CreateClass(ASPxClientAxisBase, {
  constructor: function (chart, diagram, interimAxis) {
   this.constructor.prototype.constructor.call(this, chart, diagram, interimAxis);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientAxisBase.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.t))
    throw ASPxClientWebChartElement.objectModelError;
   this.axisTitle = new ASPxClientAxisTitle(this.chart, this, interimObject.t);
   this.strips = this.CreateStrips(interimObject.s);
   this.constantLines = this.CreateConstantLines(interimObject.cl);
   this.intervals = this.CreateIntervals(interimObject.i);
   if (ASPx.IsExists(interimObject.ibc))
    this.intervalBoundsCaches = new ASPxClientIntervalBoundsCache(interimObject.ibc);
   this.axisID = interimObject.id;
   this.isArgumentAxis = interimObject.x;
   if (ASPx.IsExists(interimObject.cao))
    this.crosshairAxisLabelOptions = new ASPxClientCrosshairAxisLabelOptions(this.chart, interimObject.cao);
  },
  CreateStrips: function (interimStrips) {
   return this.CreateArray(interimStrips, createStrip = function (chart, axis, interimStrip) {
    return new ASPxClientStrip(chart, axis, interimStrip);
   });
  },
  CreateConstantLines: function (interimConstantLines) {
   return this.CreateArray(interimConstantLines, function (chart, axis, interimConstantLine) {
    return new ASPxClientConstantLine(chart, axis, interimConstantLine);
   });
  },
  CreateIntervals: function (interimIntervals) {
   return this.CreateArray(interimIntervals, function (chart, axis, interimInterval) {
    return new ASPxClientAxisInterval(interimInterval);
   });
  }
 });
 var ASPxClientAxis = ASPx.CreateClass(ASPxClientAxis2D, {
  constructor: function (chart, diagram, interimAxis) {
   this.constructor.prototype.constructor.call(this, chart, diagram, interimAxis);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientAxis2D.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.ar))
    throw ASPxClientWebChartElement.objectModelError;
   this.reverse = interimObject.ar;
  }
 });
 var ASPxClientSwiftPlotDiagramAxis = ASPx.CreateClass(ASPxClientAxis2D, {
  constructor: function (chart, diagram, interimAxis) {
   this.constructor.prototype.constructor.call(this, chart, diagram, interimAxis);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientAxis2D.prototype.InitializeProperties.call(this, interimObject);
  }
 });
 var ASPxClientAxis3D = ASPx.CreateClass(ASPxClientAxisBase, {
  constructor: function (chart, diagram, interimAxis) {
   this.constructor.prototype.constructor.call(this, chart, diagram, interimAxis);
  }
 });
 var ASPxClientRadarAxis = ASPx.CreateClass(ASPxClientAxisBase, {
  constructor: function (chart, diagram, interimAxis) {
   this.constructor.prototype.constructor.call(this, chart, diagram, interimAxis);
  }
 });
 var ASPxClientAxisTitle = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, axis, interimAxisTitle) {
   this.constructor.prototype.constructor.call(this, chart, interimAxisTitle);
   this.axis = axis;
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.tx))
    throw ASPxClientWebChartElement.objectModelError;
   this.text = interimObject.tx;
  }
 });
 var ASPxClientAxisLabelItem = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, axis, interimLabelItem) {
   this.constructor.prototype.constructor.call(this, chart, interimLabelItem);
   this.axis = axis;
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.tx) || !ASPx.IsExists(interimObject.av) || !ASPx.IsExists(interimObject.iv))
    throw ASPxClientWebChartElement.objectModelError;
   this.text = interimObject.tx;
   this.axisValue = interimObject.av;
   this.axisValueInternal = interimObject.iv;
  }
 });
 var ASPxClientAxisRange = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, axis, interimRange) {
   this.constructor.prototype.constructor.call(this, chart, interimRange);
   this.axis = axis;
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.ii) || !ASPx.IsExists(interimObject.ia))
    throw ASPxClientWebChartElement.objectModelError;
   this.minValue = interimObject.mi;
   this.maxValue = interimObject.ma;
   this.minValueInternal = interimObject.ii;
   this.maxValueInternal = interimObject.ia;
  }
 });
 var ASPxClientAxisInterval = ASPx.CreateClass(null, {
  constructor: function (interimInterval) {
   this.minLimit = interimInterval.mi;
   this.maxLimit = interimInterval.ma;
  },
  GetInternalValue: function (ratio) {
   return this.minLimit + (this.maxLimit - this.minLimit) * ratio;
  }
 });
 var ASPxClientIntervalBoundsCache = ASPx.CreateClass(null, {
  constructor: function (interimCache) {
   this.items = this.CreateItems(interimCache.i);
  },
  CreateItems: function (interimItems) {
   var result = [];
   for (var i = 0; i < interimItems.length; i++)
    result.push(new ASPxClientIntervalBoundsCacheItem(interimItems[i]));
   return result;
  },
  GetIntervalBoundsCacheItemByPaneID: function (paneID) {
   for (var i = 0; i < this.items.length; i++)
    if (this.items[i].paneID == paneID)
     return this.items[i];
   return null;
  }
 });
 var ASPxClientIntervalBoundsCacheItem = ASPx.CreateClass(null, {
  constructor: function (interimCacheItem) {
   this.paneID = interimCacheItem.pid;
   this.intervalBoundsArray = this.CreateIntervalBoundsArray(interimCacheItem.ibl);
  },
  CreateIntervalBoundsArray: function (interimIntervalBoundsArray) {
   var result = [];
   for (var i = 0; i < interimIntervalBoundsArray.length; i++)
    result.push(new ASPxClientIntervalBounds(interimIntervalBoundsArray[i]));
   return result;
  },
  GetIntervalBoundsIndexByLocation: function (location) {
   for (var i = 0; i < this.intervalBoundsArray.length; i++)
    if (location >= this.intervalBoundsArray[i].position && location <= this.intervalBoundsArray[i].highBound)
     return i;
   return -1;
  }
 });
 var ASPxClientIntervalBounds = ASPx.CreateClass(null, {
  constructor: function (interimBounds) {
   this.position = interimBounds.p;
   this.length = interimBounds.l;
   this.highBound = this.position + this.length;
  }
 });
 var ASPxClientStrip = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, axis, interimStrip) {
   this.constructor.prototype.constructor.call(this, chart, interimStrip);
   this.axis = axis;
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
   if (ASPx.IsExists(interimObject.mi))
    this.minValue = interimObject.mi;
   if (ASPx.IsExists(interimObject.ma))
    this.maxValue = interimObject.ma;
  }
 });
 var ASPxClientConstantLine = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, axis, interimConstantLine) {
   this.constructor.prototype.constructor.call(this, chart, interimConstantLine);
   this.axis = axis;
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.v))
    throw ASPxClientWebChartElement.objectModelError;
   this.value = interimObject.v;
   this.title = ASPx.IsExists(interimObject.ti) ? interimObject.ti : "";
  }
 });
 var ASPxClientSeries = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, interimSeries) {
   this.constructor.prototype.constructor.call(this, chart, interimSeries);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
   this.viewType = ASPx.IsExists(interimObject.v) ? interimObject.v : "Bar";
   this.argumentScaleType = ASPx.IsExists(interimObject.as) ? interimObject.as : "Qualitative";
   this.valueScaleType = ASPx.IsExists(interimObject.vs) ? interimObject.vs : "Numerical";
   if (ASPx.IsExists(interimObject.ax))
    this.axisX = interimObject.ax;
   if (ASPx.IsExists(interimObject.ay))
    this.axisY = interimObject.ay;
   if (ASPx.IsExists(interimObject.pa))
    this.pane = interimObject.pa;
   this.visible = !ASPx.IsExists(interimObject.nvi);
   this.toolTipEnabled = ASPx.IsExists(interimObject.tte);
   this.toolTipText = interimObject.st;
   this.toolTipImage = interimObject.tti;
   this.label = new ASPxClientSeriesLabel(this.chart, this, interimObject.l);
   this.points = this.CreatePoints(interimObject.p);
   if (ASPx.IsExists(interimObject.ti))
    this.titles = this.CreateTitles(interimObject.ti);
   if (ASPx.IsExists(interimObject.id))
    this.indicators = this.CreateIndicators(interimObject.id);
   this.regressionLines = this.indicators;
   this.trendLines = this.indicators;
   this.fibonacciIndicators = this.indicators;
   if (ASPx.IsExists(interimObject.scc)) {
    this.color = interimObject.scc;
   }
   if (ASPx.IsExists(interimObject.sg))
    this.stackedGroup = interimObject.sg;
   if (ASPx.IsExists(interimObject.clp)) {
    this.crosshairLabelPattern = interimObject.clp;
   }
   this.groupedElementsPattern = ASPx.IsExists(interimObject.gep) ? interimObject.gep : "";
   this.crosshairValueItems = this.CreateCrosshairValueItemsArray(interimObject.cvi);
   if (ASPx.IsExists(interimObject.ace)) {
    this.actualCrosshairEnabled = interimObject.ace;
   }
   if (ASPx.IsExists(interimObject.aclv)) {
    this.actualCrosshairLabelVisibility = interimObject.aclv;
   }
   if (ASPx.IsExists(interimObject.cto))
    this.crosshairTextOptions = new ASPxClientTextOptions(this.chart, interimObject.cto);
   if (ASPx.IsExists(interimObject.is)) {
    this.invertedStep = interimObject.is;
   }
   if (ASPx.IsExists(interimObject.axi))
    this.axisXID = interimObject.axi;
   if (ASPx.IsExists(interimObject.ayi))
    this.axisYID = interimObject.ayi;
   if (ASPx.IsExists(interimObject.pi))
    this.paneID = interimObject.pi;
  },
  CreatePoints: function (interimPoints) {
   return this.CreateArray(interimPoints, createPoint = function (chart, series, interimPoint) {
    return new ASPxClientSeriesPoint(chart, series, interimPoint);
   });
  },
  CreateCrosshairValueItemsArray: function (interimValueItems) {
   return this.CreateArray(interimValueItems, createValueItem = function (chart, series, interimValueItem) {
    return new ASPxClientCrosshairValueItem(interimValueItem);
   });
  },
  CreateTitles: function (interimTitles) {
   return this.CreateArray(interimTitles, createTitle = function (chart, series, interimTitle) {
    return new ASPxClientSeriesTitle(chart, series, interimTitle);
   });
  },
  CreateIndicators: function (interimIndicators) {
   return this.CreateArray(interimIndicators, createIndicator = function (chart, series, interimIndicator) {
    if (interimIndicator.t == "RL")
     return new ASPxClientRegressionLine(chart, series, interimIndicator);
    if (interimIndicator.t == "TL")
     return new ASPxClientTrendLine(chart, series, interimIndicator);
    if (interimIndicator.t == "FI")
     return new ASPxClientFibonacciIndicator(chart, series, interimIndicator);
    if (interimIndicator.t == "SMA")
     return new ASPxClientSimpleMovingAverage(chart, series, interimIndicator);
    if (interimIndicator.t == "EMA")
     return new ASPxClientExponentialMovingAverage(chart, series, interimIndicator);
    if (interimIndicator.t == "WMA")
     return new ASPxClientWeightedMovingAverage(chart, series, interimIndicator);
    if (interimIndicator.t == "TMA")
     return new ASPxClientTriangularMovingAverage(chart, series, interimIndicator);
    if (interimIndicator.t == "TEMA")
     return new ASPxClientTripleExponentialMovingAverageTema(chart, series, interimIndicator);
    if (interimIndicator.t == "BB")
     return new ASPxClientBollingerBands(chart, series, interimIndicator);
    if (interimIndicator.t == "MP")
     return new ASPxClientMedianPrice(chart, series, interimIndicator);
    if (interimIndicator.t == "TP")
     return new ASPxClientTypicalPrice(chart, series, interimIndicator);
    if (interimIndicator.t == "WC")
     return new ASPxClientWeightedClose(chart, series, interimIndicator);
    if (interimIndicator.t == "ATR")
     return new ASPxClientAverageTrueRange(chart, series, interimIndicator);
    if (interimIndicator.t == "ChV")
     return new ASPxClientChaikinsVolatility(chart, series, interimIndicator);
    if (interimIndicator.t == "CCI")
     return new ASPxClientCommodityChannelIndex(chart, series, interimIndicator);
    if (interimIndicator.t == "DPO")
     return new ASPxClientDetrendedPriceOscillator(chart, series, interimIndicator);
    if (interimIndicator.t == "MI")
     return new ASPxClientMassIndex(chart, series, interimIndicator);
    if (interimIndicator.t == "MACD")
     return new ASPxClientMovingAverageConvergenceDivergence(chart, series, interimIndicator);
    if (interimIndicator.t == "RoC")
     return new ASPxClientRateOfChange(chart, series, interimIndicator);
    if (interimIndicator.t == "RSI")
     return new ASPxClientRelativeStrengthIndex(chart, series, interimIndicator);
    if (interimIndicator.t == "StdDev")
     return new ASPxClientStandardDeviation(chart, series, interimIndicator);
    if (interimIndicator.t == "TRIX")
     return new ASPxClientTripleExponentialMovingAverageTrix(chart, series, interimIndicator);
    if (interimIndicator.t == "WR")
     return new ASPxClientWilliamsR(chart, series, interimIndicator);
    if (interimIndicator.t == "FVEB")
     return new ASPxClientFixedValueErrorBars(chart, series, interimIndicator);
    if (interimIndicator.t == "PEB")
     return new ASPxClientPercentageErrorBars(chart, series, interimIndicator);
    if (interimIndicator.t == "StdDevEB")
     return new ASPxClientStandardDeviationErrorBars(chart, series, interimIndicator);
    if (interimIndicator.t == "StdEB")
     return new ASPxClientStandardErrorBars(chart, series, interimIndicator);
    if (interimIndicator.t == "DSBEB")
     return new ASPxClientDataSourceBasedErrorBars(chart, series, interimIndicator);
    throw ASPxClientWebChartElement.objectModelError;
   });
  }
 });
 var ASPxClientSeriesLabel = ASPx.CreateClass(ASPxClientWebChartElement, {
  constructor: function (chart, series, interimSeriesLabel) {
   this.constructor.prototype.constructor.call(this, chart, interimSeriesLabel);
   this.series = series;
  },
  InitializeProperties: function (interimObject) {
  },
  InitializeDefault: function () {
   this.text = "";
  }
 });
 var ASPxClientSeriesPoint = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, series, interimSeriesPoint) {
   this.constructor.prototype.constructor.call(this, chart, interimSeriesPoint);
   this.series = series;
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.x) || !ASPx.IsExists(interimObject.y) || !(interimObject.y instanceof Array))
    throw ASPxClientWebChartElement.objectModelError;
   this.argument = interimObject.x;
   this.values = interimObject.y;
   this.toolTipText = interimObject.pt;
   if (ASPx.IsExists(interimObject.pcc)) {
    this.color = interimObject.pcc;
   }
   if (ASPx.IsExists(interimObject.pv)) {
    this.percentValue = interimObject.pv;
   }
   if (ASPx.IsExists(interimObject.h)) {
    this.toolTipHint = interimObject.h;
   }
   if (ASPx.IsExists(interimObject.chv)) {
    this.crosshairValues = interimObject.chv;
   }
   if (ASPx.IsExists(interimObject.o)) {
    this.offset = interimObject.o;
   }
   if (ASPx.IsExists(interimObject.fo)) {
    this.fixedOffset = interimObject.fo;
   }
   if (ASPx.IsExists(interimObject.bw)) {
    this.barWidth = interimObject.bw;
   }
   if (ASPx.IsExists(interimObject.ie)) {
    this.isEmpty = interimObject.ie;
   }
   if (ASPx.IsExists(interimObject.tv)) {
    this.totalValue = interimObject.tv;
   }
  }
 });
 var ASPxClientLegend = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function (chart, interimLegend) {
   this.constructor.prototype.constructor.call(this, chart, interimLegend);
  },
  InitializeProperties: function(interimObject) {
   this.useCheckBoxes = ASPx.IsExists(interimObject) && ASPx.IsExists(interimObject.chb);
   this.customItems = this.CreateCustomItems(interimObject.c);
   this.name = ASPx.IsExists(interimObject.n) ? interimObject.n : '';
  },
  CreateCustomItems: function(interimCustomItems) {
   return this.CreateArray(interimCustomItems, createCustomItem = function(chart, legend, interimCustomItem) {
    return new ASPxClientCustomLegendItem(chart, interimCustomItem);
   });
  }
 });
 var ASPxClientTitleBase = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, interimTitle) {
   this.constructor.prototype.constructor.call(this, chart, interimTitle);
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.l) || !(interimObject.l instanceof Array))
    throw ASPxClientWebChartElement.objectModelError;
   this.lines = interimObject.l;
   this.alignment = interimObject.a;
   this.dock = interimObject.d;
  }
 });
 var ASPxClientChartTitle = ASPx.CreateClass(ASPxClientTitleBase, {
  constructor: function (chart, interimChartTitle) {
   this.constructor.prototype.constructor.call(this, chart, interimChartTitle);
  }
 });
 var ASPxClientSeriesTitle = ASPx.CreateClass(ASPxClientTitleBase, {
  constructor: function (chart, series, interimSeriesTitle) {
   this.constructor.prototype.constructor.call(this, chart, interimSeriesTitle);
   this.series = series;
  }
 });
 var ASPxClientIndicator = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, interimIndicator);
   this.series = series;
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
  }
 });
 var ASPxClientFinancialIndicator = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimFinancialIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimFinancialIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.p1) || !ASPx.IsExists(interimObject.p2))
    throw ASPxClientWebChartElement.objectModelError;
   this.point1 = new ASPxClientFinancialIndicatorPoint(this.chart, this, interimObject.p1);
   this.point2 = new ASPxClientFinancialIndicatorPoint(this.chart, this, interimObject.p2);
  }
 });
 var ASPxClientTrendLine = ASPx.CreateClass(ASPxClientFinancialIndicator, {
  constructor: function (chart, series, interimTrendLine) {
   this.constructor.prototype.constructor.call(this, chart, series, interimTrendLine);
  }
 });
 var ASPxClientFibonacciIndicator = ASPx.CreateClass(ASPxClientFinancialIndicator, {
  constructor: function (chart, series, interimFibonacciIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimFibonacciIndicator);
  }
 });
 var ASPxClientFinancialIndicatorPoint = ASPx.CreateClass(ASPxClientWebChartRequiredElement, {
  constructor: function (chart, financialIndicator, interimFinancialIndicatorPoint) {
   this.constructor.prototype.constructor.call(this, chart, interimFinancialIndicatorPoint);
   this.financialIndicator = financialIndicator;
  },
  InitializeProperties: function (interimObject) {
   if (!ASPx.IsExists(interimObject.a) || !ASPx.IsExists(interimObject.vl))
    throw ASPxClientWebChartElement.objectModelError;
   this.argument = interimObject.a;
   this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientSingleLevelIndicator = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.vl))
    throw ASPxClientWebChartElement.objectModelError;
   this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientRegressionLine = ASPx.CreateClass(ASPxClientSingleLevelIndicator, {
  constructor: function (chart, series, interimRegressionLine) {
   this.constructor.prototype.constructor.call(this, chart, series, interimRegressionLine);
  }
 });
 var ASPxClientMovingAverage = ASPx.CreateClass(ASPxClientSingleLevelIndicator, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientSingleLevelIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc) || !ASPx.IsExists(interimObject.ki))
    throw ASPxClientWebChartElement.objectModelError;
   this.pointsCount = interimObject.pc;
   this.kind = interimObject.ki;
   if (this.kind == "Envelope" || this.kind == "MovingAverageAndEnvelope") {
    if (!ASPx.IsExists(interimObject.ep))
     throw ASPxClientWebChartElement.objectModelError;
    this.envelopePercent = interimObject.ep;
   }
  }
 });
 var ASPxClientSimpleMovingAverage = ASPx.CreateClass(ASPxClientMovingAverage, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  }
 });
 var ASPxClientExponentialMovingAverage = ASPx.CreateClass(ASPxClientMovingAverage, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  }
 });
 var ASPxClientWeightedMovingAverage = ASPx.CreateClass(ASPxClientMovingAverage, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  }
 });
 var ASPxClientTriangularMovingAverage = ASPx.CreateClass(ASPxClientMovingAverage, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  }
 });
 var ASPxClientTripleExponentialMovingAverageTema = ASPx.CreateClass(ASPxClientMovingAverage, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  }
 });
 var ASPxClientBollingerBands = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
   if (ASPx.IsExists(interimObject.vl))
    this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientMedianPrice = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  }
 });
 var ASPxClientTypicalPrice = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  }
 });
 var ASPxClientWeightedClose = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  }
 });
 var ASPxSeparatePaneIndicator = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimMovingAverage) {
   this.constructor.prototype.constructor.call(this, chart, series, interimMovingAverage);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.ayi) || !ASPx.IsExists(interimObject.pi))
    throw ASPxClientWebChartElement.objectModelError;
   this.axisYID = interimObject.ayi;
   this.paneID = interimObject.pi;
   this.axisY = interimObject.ay;
   this.pane = interimObject.pa;
  }
 });
 var ASPxClientAverageTrueRange = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
  }
 });
 var ASPxClientChaikinsVolatility = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
  }
 });
 var ASPxClientCommodityChannelIndex = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
  }
 });
 var ASPxClientDetrendedPriceOscillator = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
   if (!ASPx.IsExists(interimObject.vl))
    this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientMassIndex = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.mapc))
    this.movingAveragePointsCount = interimObject.mapc;
   if (!ASPx.IsExists(interimObject.spc))
    this.sumPointsCount = interimObject.spc;
  }
 });
 var ASPxClientMovingAverageConvergenceDivergence = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.shp))
    this.shortPeriod = interimObject.shp;
   if (!ASPx.IsExists(interimObject.lp))
    this.longPeriod = interimObject.lp;
   if (!ASPx.IsExists(interimObject.ssp))
    this.signalSmoothingPeriod = interimObject.ssp;
  }
 });
 var ASPxClientRateOfChange = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
   if (!ASPx.IsExists(interimObject.vl))
    this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientRelativeStrengthIndex = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
   if (!ASPx.IsExists(interimObject.vl))
    this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientStandardDeviation = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
   if (!ASPx.IsExists(interimObject.vl))
    this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientTripleExponentialMovingAverageTrix = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
   if (!ASPx.IsExists(interimObject.vl))
    this.valueLevel = interimObject.vl;
  }
 });
 var ASPxClientWilliamsR = ASPx.CreateClass(ASPxSeparatePaneIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxSeparatePaneIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pc))
    this.pointsCount = interimObject.pc;
  }
 });
 var ASPxClientFixedValueErrorBars = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.pe))
    this.positiveError = interimObject.pe;
   if (!ASPx.IsExists(interimObject.ne))
    this.negativeError = interimObject.ne;
  }
 });
 var ASPxClientPercentageErrorBars = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.prcnt))
    this.percent = interimObject.prcnt;
  }
 });
 var ASPxClientStandardDeviationErrorBars = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.mtpl))
    this.positiveError = interimObject.mtpl;
  }
 });
 var ASPxClientStandardErrorBars = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
  }
 });
 var ASPxClientDataSourceBasedErrorBars = ASPx.CreateClass(ASPxClientIndicator, {
  constructor: function (chart, series, interimIndicator) {
   this.constructor.prototype.constructor.call(this, chart, series, interimIndicator);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientIndicator.prototype.InitializeProperties.call(this, interimObject);
  }
 });
 var ASPxClientAnnotation = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function (chart, interimAnnotation) {
   this.constructor.prototype.constructor.call(this, chart, interimAnnotation);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
  }
 });
 var ASPxClientTextAnnotation = ASPx.CreateClass(ASPxClientAnnotation, {
  constructor: function (chart, interimTextAnnotation) {
   this.constructor.prototype.constructor.call(this, chart, interimTextAnnotation);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientAnnotation.prototype.InitializeProperties.call(this, interimObject);
   if (!ASPx.IsExists(interimObject.l) || !(interimObject.l instanceof Array))
    throw ASPxClientWebChartElement.objectModelError;
   this.lines = interimObject.l;
  }
 });
 var ASPxClientImageAnnotation = ASPx.CreateClass(ASPxClientAnnotation, {
  constructor: function (chart, interimImageAnnotation) {
   this.constructor.prototype.constructor.call(this, chart, interimImageAnnotation);
  },
  InitializeProperties: function (interimObject) {
   ASPxClientAnnotation.prototype.InitializeProperties.call(this, interimObject);
  }
 });
 var ASPxClientCrosshairValueItem = ASPx.CreateClass(null, {
  constructor: function (interimObject) {
   this.value = interimObject.v;
   this.pointIndex = interimObject.pi;
  }
 });
 var ASPxClientToolTipController = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function (chart, interimToolTipController) {
   this.constructor.prototype.constructor.call(this, chart, interimToolTipController);
   this.showImage = interimToolTipController.si;
   this.showText = interimToolTipController.st;
   this.imagePosition = interimToolTipController.ip;
   this.openMode = interimToolTipController.om;
   this.toolTipObject = null;
   this.toolTip = null;
  },
  Show: function (x, y, hitInfo, htmlElementX, htmlElementY) {
   var newObject = null;
   if (hitInfo.seriesPoint != null && this.chart.showPointToolTip) {
    newObject = hitInfo.seriesPoint;
   }
   else {
    if (hitInfo.series != null && this.chart.showSeriesToolTip) {
     newObject = hitInfo.series;
    }
   }
   if (this.toolTipObject != newObject) {
    this.toolTipObject = newObject;
    if (this.toolTipObject == null) {
     this.Hide();
     return;
    }
    var series = hitInfo.series != null ? hitInfo.series : hitInfo.seriesPoint.series;
    if (!series.toolTipEnabled) {
     this.Hide();
     return;
    }
    var showForPoint = hitInfo.inSeriesPoint && this.chart.showPointToolTip;
    var showForSeries = !hitInfo.inSeriesPoint && hitInfo.inSeries && this.chart.showSeriesToolTip;
    if (showForPoint || showForSeries) {
     if (this.toolTip == null) {
      this.toolTip = ASPx.CreateChartToolTip(this.chart.chartControl, ASPx.chartToolTipID, 0);
     }
     if (showForPoint) {
      var image = series != null ? series.toolTipImage : null;
      this.setToolTipContent(image, this.toolTipObject.toolTipText);
      this.showToolTip(x, y, hitInfo, htmlElementX, htmlElementY);
      return;
     }
     if (showForSeries) {
      this.setToolTipContent(this.toolTipObject.toolTipImage, this.toolTipObject.toolTipText);
      this.showToolTip(x, y, hitInfo, htmlElementX, htmlElementY);
      return;
     }
    }
    this.toolTipObject = null;
   }
  },
  Hide: function () {
   if (this.toolTip != null) {
    ASPx.RemoveChartDiv(this.chart.chartControl, ASPx.chartToolTipID, 0);
    this.toolTip = null;
    this.toolTipObject = null;
   }
  },
  getImageHTML: function (image) {
   return "<img src='" + image + "' style='display:block;' />";
  },
  getVerticalTable: function (cell1, cell2) {
   return "<table><tr><td>" + cell1 + "</td></tr><tr><td>" + cell2 + "</td></tr></table>";
  },
  setToolTipContent: function (image, text) {
   var toolTipContent = "";
   if (this.showText && this.showImage && image != null) {
    var imageHTML = this.getImageHTML(image);
    switch (this.imagePosition) {
     case "Right":
      toolTipContent = ASPx.ChartGetHorizontalTable(text, imageHTML);
      break;
     case "Top":
      toolTipContent = this.getVerticalTable(imageHTML, text);
      break;
     case "Bottom":
      toolTipContent = this.getVerticalTable(text, imageHTML);
      break;
     default:
      toolTipContent = ASPx.ChartGetHorizontalTable(imageHTML, text);
      break;
    }
   }
   else if (this.showImage && image != null) {
    toolTipContent = this.getImageHTML(image);
   }
   else if (this.showText) {
    toolTipContent = text;
   }
   this.toolTip.innerHTML = toolTipContent;
  },
  showToolTip: function (x, y, hitInfo, htmlElementX, htmlElementY) {
   var minIndent = 5;
   var chartImage = this.chart.chartControl.GetChartElement();
   var diff = htmlElementX + chartImage.clientWidth - (x + this.toolTip.clientWidth + minIndent);
   if (diff < 0)
    x += diff;
   if (this.chart.toolTipPosition instanceof ASPxClientToolTipMousePosition) {
    ASPx.ChartSetDivPosition(this.toolTip, x, y);
    return;
   }
   if (this.chart.toolTipPosition instanceof ASPxClientToolTipFreePosition) {
    ASPx.ShowInFreePosition(this.toolTip, this.chart, this.chart.toolTipPosition, htmlElementX, htmlElementY);
    return;
   }
   if (this.chart.toolTipPosition instanceof ASPxClientToolTipRelativePosition) {
    this.showToolTipInRelativePosition(x, y, hitInfo, htmlElementX, htmlElementY);
   }
  },
  showToolTipInRelativePosition: function (x, y, hitInfo, htmlElementX, htmlElementY) {
   var left;
   var top;
   if (hitInfo.seriesPoint != null && !hitInfo.inLegend) {
    left = htmlElementX + hitInfo.seriesPoint.toolTipPoint[0] - this.toolTip.offsetWidth / 2 + this.chart.toolTipPosition.offsetX;
    top = htmlElementY + hitInfo.seriesPoint.toolTipPoint[1] - this.toolTip.offsetHeight + this.chart.toolTipPosition.offsetY;
   }
   else {
    left = x + this.chart.toolTipPosition.offsetX;
    top = y + this.chart.toolTipPosition.offsetY;
   }
   ASPx.ChartSetDivPosition(this.toolTip, left, top);
  }
 });
 var ASPxClientToolTipPosition = ASPx.CreateClass(null, {
  constructor: function (interimObject) {
  }
 });
 var ASPxClientToolTipMousePosition = ASPx.CreateClass(ASPxClientToolTipPosition, {
  constructor: function (interimObject) {
   this.constructor.prototype.constructor.call(this, interimObject);
  }
 });
 var ASPxClientToolTipRelativePosition = ASPx.CreateClass(ASPxClientToolTipPosition, {
  constructor: function (interimObject) {
   this.constructor.prototype.constructor.call(this, interimObject);
   this.offsetX = interimObject.ox;
   this.offsetY = interimObject.oy;
  }
 });
 var ASPxClientToolTipFreePosition = ASPx.CreateClass(ASPxClientToolTipPosition, {
  constructor: function (interimObject) {
   this.constructor.prototype.constructor.call(this, interimObject);
   this.offsetX = interimObject.ox;
   this.offsetY = interimObject.oy;
   this.paneID = interimObject.dt;
   this.dockPosition = interimObject.dp;
  }
 });
 var ASPxClientCrosshairPosition = ASPx.CreateClass(null, {
  constructor: function (interimObject) {
   this.offsetX = interimObject.ox;
   this.offsetY = interimObject.oy;
  }
 });
 var ASPxClientCrosshairMousePosition = ASPx.CreateClass(ASPxClientCrosshairPosition, {
  constructor: function (interimObject) {
   this.constructor.prototype.constructor.call(this, interimObject);
  }
 });
 var ASPxClientCrosshairFreePosition = ASPx.CreateClass(ASPxClientCrosshairPosition, {
  constructor: function (interimObject) {
   this.constructor.prototype.constructor.call(this, interimObject);
   this.paneID = interimObject.dt;
   this.dockPosition = interimObject.dp;
  }
 });
 var ASPxClientLineStyle = ASPx.CreateClass(ASPxClientWebChartElement, {
  constructor: function (chart, interimLineStyle) {
   this.constructor.prototype.constructor.call(this, chart, interimLineStyle);
  },
  InitializeProperties: function (interimObject) {
   this.dashStyle = interimObject.ds;
   this.thickness = interimObject.th;
   this.lineJoin = interimObject.lj;
  }
 });
 var ASPxClientCrosshairOptions = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function (chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
   this.showArgumentLabels = interimObject.sx;
   this.showValueLabels = interimObject.sy;
   this.showCrosshairLabels = interimObject.sl;
   this.showArgumentLine = interimObject.sxl;
   this.showValueLine = interimObject.syl;
   this.showOnlyInFocusedPane = interimObject.sfp;
   this.snapMode = interimObject.sm;
   this.crosshairLabelMode = interimObject.lm;
   this.showGroupHeaders = interimObject.sgh;
   this.groupHeaderPattern = ASPx.IsExists(interimObject.ghp) ? interimObject.ghp : "";
   this.actualGroupHeaderPattern = interimObject.aghp;
   this.showOutOfRangePoints = interimObject.sorp;
   this.valueSelectionMode = interimObject.vsm;
   if (ASPx.IsExists(interimObject.clp)) {
    this.crosshairLabelPosition = this.CreateCrosshairPosition(interimObject.clp);
   }
   if (ASPx.IsExists(interimObject.alc)) {
    this.argumentLineColor = interimObject.alc;
   }
   if (ASPx.IsExists(interimObject.vlc)) {
    this.valueLineColor = interimObject.vlc;
   }
   if (ASPx.IsExists(interimObject.als)) {
    this.argumentLineStyle = new ASPxClientLineStyle(chart, interimObject.als);
   }
   if (ASPx.IsExists(interimObject.vls)) {
    this.valueLineStyle = new ASPxClientLineStyle(chart, interimObject.vls);
   }
   if (ASPx.IsExists(interimObject.gho))
    this.groupHeaderTextOptions = new ASPxClientTextOptions(chart, interimObject.gho);
   if (ASPx.IsExists(interimObject.clo))
    this.crosshairLabelTextOptions = new ASPxClientTextOptions(chart, interimObject.clo);
   if (ASPx.IsExists(interimObject.lbc))
    this.crosshairLabelBackColor = interimObject.lbc;
  },
  CreateCrosshairPosition: function (interimPosition) {
   if (interimPosition.t == "CFP")
    return new ASPxClientCrosshairFreePosition(interimPosition);
   else if (interimPosition.t == "CMP")
    return new ASPxClientCrosshairMousePosition(interimPosition);
   return null;
  }
 });
 var ASPxClientAxisLabelBounds = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function (chart, pane, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
   this.pane = pane;
   this.axisID = interimObject.ai;
   this.isArgumentAxis = interimObject.ax;
   this.axis = null;
   this.left = interimObject.ll;
   this.top = interimObject.lt;
   this.height = interimObject.lh;
   this.width = interimObject.lw;
  },
  GetAxis: function () {
   if (this.axis == null) {
    var diagram = this.pane.diagram;
    this.axis = this.isArgumentAxis ? diagram.FindAxisXByID(this.axisID) : diagram.FindAxisYByID(this.axisID);
   }
   return this.axis;
  }
 });
 var ASPxClientFont = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function (chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
   this.fontSize = interimObject.fs;
   this.fontFamily = interimObject.ff;
   this.italic = interimObject.fi;
   this.bold = interimObject.fb;
   this.underline = interimObject.fu;
   this.strikeout = interimObject.fso;
  },
  CreateCustomDrawElement: function () {
   return { fontSize: this.fontSize, fontFamily: this.fontFamily, italic: this.italic, bold: this.bold, underline: this.underline, strikeout: this.strikeout };
  }
 });
 var ASPxClientTextOptions = ASPx.CreateClass(ASPxClientWebChartEmptyElement, {
  constructor: function(chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
   if (ASPx.IsExists(interimObject.tc))
    this.textColor = interimObject.tc;
   if (ASPx.IsExists(interimObject.f))
    this.font = new ASPxClientFont(chart, interimObject.f);
  }
 });
 var ASPxClientCrosshairAxisLabelOptions = ASPx.CreateClass(ASPxClientTextOptions, {
  constructor: function (chart, interimObject) {
   this.constructor.prototype.constructor.call(this, chart, interimObject);
   if (ASPx.IsExists(interimObject.clp)) {
    this.pattern = interimObject.clp;
   }
   this.visibility = interimObject.clv;
   if (ASPx.IsExists(interimObject.clbc)) {
    this.backColor = interimObject.clbc;
   }
  }
 });
 var ASPxClientChartPrintOptions = ASPx.CreateClass(null, {
  constructor: function () {
   this.sizeMode = "None";
   this.landscape = false;
   this.marginLeft = "";
   this.marginTop = "";
   this.marginRight = "";
   this.marginBottom = "";
   this.paperKind = "";
   this.customPaperWidth = "";
   this.customPaperHeight = "";
   this.customPaperName = "";
  },
  createEventParameters: function () {
   return this.concatParameters([this.sizeMode, this.landscape, this.paperKind, this.customPaperName, this.customPaperWidth, this.customPaperHeight,
    this.marginLeft, this.marginTop, this.marginRight, this.marginBottom]);
  },
  concatParameters: function (options) {
   var length = options.length;
   if (length == 0)
    return "";
   var optionsString = options[0];
   for (var i = 1; i < options.length; i++) {
    optionsString = optionsString + "&" + options[i];
   }
   return optionsString;
  },
  GetSizeMode: function () {
   return this.sizeMode;
  },
  SetSizeMode: function (sizeMode) {
   this.sizeMode = sizeMode;
  },
  GetLandscape: function () {
   return this.landscape;
  },
  SetLandscape: function (landscape) {
   this.landscape = landscape;
  },
  GetMarginLeft: function () {
   return this.marginLeft;
  },
  SetMarginLeft: function (marginLeft) {
   this.marginLeft = marginLeft;
  },
  GetMarginTop: function () {
   return this.marginTop;
  },
  SetMarginTop: function (marginTop) {
   this.marginTop = marginTop;
  },
  GetMarginRight: function () {
   return this.marginRight;
  },
  SetMarginRight: function (marginRight) {
   this.marginRight = marginRight;
  },
  GetMarginBottom: function () {
   return this.marginBottom;
  },
  SetMarginBottom: function (marginBottom) {
   this.marginBottom = marginBottom;
  },
  GetPaperKind: function () {
   return this.paperKind;
  },
  SetPaperKind: function (paperKind) {
   this.paperKind = paperKind;
  },
  GetCustomPaperWidth: function () {
   return this.customPaperWidth;
  },
  SetCustomPaperWidth: function (customPaperWidth) {
   this.customPaperWidth = customPaperWidth;
  },
  GetCustomPaperHeight: function () {
   return this.customPaperHeight;
  },
  SetCustomPaperHeight: function (customPaperHeight) {
   this.customPaperHeight = customPaperHeight;
  },
  GetCustomPaperName: function () {
   return this.customPaperName;
  },
  SetCustomPaperName: function (customPaperName) {
   this.customPaperName = customPaperName;
  }
 });
 var ASPxClientCustomLegendItem = ASPx.CreateClass(ASPxClientWebChartElementNamed, {
  constructor: function(chart, interimLegendItem) {
   this.constructor.prototype.constructor.call(this, chart, interimLegendItem);
  },
  InitializeProperties: function(interimObject) {
   ASPxClientWebChartElementNamed.prototype.InitializeProperties.call(this, interimObject);
   if (ASPx.IsExists(interimObject.t))
    this.text = interimObject.t;
  }
 });
 window.ASPxClientWebChartControl = ASPxClientWebChartControl;
 window.ASPxClientScaleType = ASPxClientScaleType;
 window.ASPxClientControlCoordinatesVisibility = ASPxClientControlCoordinatesVisibility;
 window.ASPxClientWebChartControlCustomDrawCrosshairEventArgs = ASPxClientWebChartControlCustomDrawCrosshairEventArgs;
 window.ASPxClientCrosshairDrawInfoList = ASPxClientCrosshairDrawInfoList;
 window.ASPxClientCrosshairDrawInfo = ASPxClientCrosshairDrawInfo;
 window.ASPxClientCrosshairElement = ASPxClientCrosshairElement;
 window.ASPxClientCrosshairLineElement = ASPxClientCrosshairLineElement;
 window.ASPxClientCrosshairAxisLabelElement = ASPxClientCrosshairAxisLabelElement;
 window.ASPxClientCrosshairGroupHeaderElement = ASPxClientCrosshairGroupHeaderElement;
 window.ASPxClientCrosshairSeriesLabelElement = ASPxClientCrosshairSeriesLabelElement;
 window.ASPxClientWebChartControlHotTrackEventArgs = ASPxClientWebChartControlHotTrackEventArgs;
 window.ASPxClientHitObject = ASPxClientHitObject;
 window.ASPxClientWebChartHitInfo = ASPxClientWebChartHitInfo;
 window.ASPxClientDiagramCoordinates = ASPxClientDiagramCoordinates;
 window.ASPxClientAxisValue = ASPxClientAxisValue;
 window.ASPxClientControlCoordinates = ASPxClientControlCoordinates;
 window.ASPxClientLegendCheckBox = ASPxClientLegendCheckBox;
 window.ASPxClientWebChartElement = ASPxClientWebChartElement;
 window.ASPxClientWebChartEmptyElement = ASPxClientWebChartEmptyElement;
 window.ASPxClientWebChartRequiredElement = ASPxClientWebChartRequiredElement;
 window.ASPxClientWebChartElementNamed = ASPxClientWebChartElementNamed;
 window.ASPxClientWebChart = ASPxClientWebChart;
 window.ASPxClientSimpleDiagram = ASPxClientSimpleDiagram;
 window.ASPxClientXYDiagramBase = ASPxClientXYDiagramBase;
 window.ASPxClientXYDiagram2D = ASPxClientXYDiagram2D;
 window.ASPxClientXYDiagram = ASPxClientXYDiagram;
 window.ASPxClientSwiftPlotDiagram = ASPxClientSwiftPlotDiagram;
 window.ASPxClientXYDiagramPane = ASPxClientXYDiagramPane;
 window.ASPxClientXYDiagram3D = ASPxClientXYDiagram3D;
 window.ASPxClientRadarDiagram = ASPxClientRadarDiagram;
 window.ASPxClientRadarDiagramMapping = ASPxClientRadarDiagramMapping;
 window.ASPxClientVertex = ASPxClientVertex;
 window.ASPxClientQualitativeMap = ASPxClientQualitativeMap;
 window.ASPxClientNumericalMap = ASPxClientNumericalMap;
 window.ASPxClientDateTimeMap = ASPxClientDateTimeMap;
 window.ASPxClientAxisBase = ASPxClientAxisBase;
 window.ASPxClientAxis2D = ASPxClientAxis2D;
 window.ASPxClientAxis = ASPxClientAxis;
 window.ASPxClientSwiftPlotDiagramAxis = ASPxClientSwiftPlotDiagramAxis;
 window.ASPxClientAxis3D = ASPxClientAxis3D;
 window.ASPxClientRadarAxis = ASPxClientRadarAxis;
 window.ASPxClientAxisTitle = ASPxClientAxisTitle;
 window.ASPxClientAxisLabelItem = ASPxClientAxisLabelItem;
 window.ASPxClientAxisRange = ASPxClientAxisRange;
 window.ASPxClientAxisInterval = ASPxClientAxisInterval;
 window.ASPxClientIntervalBoundsCache = ASPxClientIntervalBoundsCache;
 window.ASPxClientIntervalBoundsCacheItem = ASPxClientIntervalBoundsCacheItem;
 window.ASPxClientIntervalBounds = ASPxClientIntervalBounds;
 window.ASPxClientStrip = ASPxClientStrip;
 window.ASPxClientConstantLine = ASPxClientConstantLine;
 window.ASPxClientSeries = ASPxClientSeries;
 window.ASPxClientSeriesLabel = ASPxClientSeriesLabel;
 window.ASPxClientSeriesPoint = ASPxClientSeriesPoint;
 window.ASPxClientLegend = ASPxClientLegend;
 window.ASPxClientCustomLegendItem = ASPxClientCustomLegendItem;
 window.ASPxClientTitleBase = ASPxClientTitleBase;
 window.ASPxClientChartTitle = ASPxClientChartTitle;
 window.ASPxClientSeriesTitle = ASPxClientSeriesTitle;
 window.ASPxClientIndicator = ASPxClientIndicator;
 window.ASPxClientFinancialIndicator = ASPxClientFinancialIndicator;
 window.ASPxClientTrendLine = ASPxClientTrendLine;
 window.ASPxClientFibonacciIndicator = ASPxClientFibonacciIndicator;
 window.ASPxClientFinancialIndicatorPoint = ASPxClientFinancialIndicatorPoint;
 window.ASPxClientSingleLevelIndicator = ASPxClientSingleLevelIndicator;
 window.ASPxClientRegressionLine = ASPxClientRegressionLine;
 window.ASPxClientMovingAverage = ASPxClientMovingAverage;
 window.ASPxClientSimpleMovingAverage = ASPxClientSimpleMovingAverage;
 window.ASPxClientExponentialMovingAverage = ASPxClientExponentialMovingAverage;
 window.ASPxClientWeightedMovingAverage = ASPxClientWeightedMovingAverage;
 window.ASPxClientTriangularMovingAverage = ASPxClientTriangularMovingAverage;
 window.ASPxClientTripleExponentialMovingAverageTema = ASPxClientTripleExponentialMovingAverageTema;
 window.ASPxClientAnnotation = ASPxClientAnnotation;
 window.ASPxClientTextAnnotation = ASPxClientTextAnnotation;
 window.ASPxClientImageAnnotation = ASPxClientImageAnnotation;
 window.ASPxClientCrosshairValueItem = ASPxClientCrosshairValueItem;
 window.ASPxClientToolTipController = ASPxClientToolTipController;
 window.ASPxClientToolTipPosition = ASPxClientToolTipPosition;
 window.ASPxClientToolTipMousePosition = ASPxClientToolTipMousePosition;
 window.ASPxClientToolTipRelativePosition = ASPxClientToolTipRelativePosition;
 window.ASPxClientToolTipFreePosition = ASPxClientToolTipFreePosition;
 window.ASPxClientCrosshairPosition = ASPxClientCrosshairPosition;
 window.ASPxClientCrosshairMousePosition = ASPxClientCrosshairMousePosition;
 window.ASPxClientCrosshairFreePosition = ASPxClientCrosshairFreePosition;
 window.ASPxClientLineStyle = ASPxClientLineStyle;
 window.ASPxClientCrosshairOptions = ASPxClientCrosshairOptions;
 window.ASPxClientAxisLabelBounds = ASPxClientAxisLabelBounds;
 window.ASPxClientFont = ASPxClientFont;
 window.ASPxClientCrosshairAxisLabelOptions = ASPxClientCrosshairAxisLabelOptions;
 window.ASPxClientChartPrintOptions = ASPxClientChartPrintOptions;
})();
(function() {
ASPx.crosshairVDivID = "_CHV-";
ASPx.crosshairHDivID = "_CHH-";
ASPx.crosshairLabelID = "_CHL-";
ASPx.crosshairVLabelID = "_CHVL-";
ASPx.crosshairHLabelID = "_CHHL-";
ASPx.chartToolTipID = "_CTT-";
var chartToolTipClassName = "dxchartsuiTooltip";
var chartCrosshairVLineClassName = "dxchartsuiCrosshairVLine";
var chartCrosshairHLineClassName = "dxchartsuiCrosshairHLine";
var chartCrosshairLabelClassName = "dxchartsuiCrosshairLabel";
var crosshairHBeakCorrection = 10;
var crosshairVBeakCorrection = 20;
function __aspxCrosshairValueItemsComparer(arrayElement, index, value) {
 if (arrayElement[index].value == value)
  return 0;
 else
  return arrayElement[index].value < value ? -1 : 1;
};
function __aspxSortPointInfoByArgument(p1, p2) {
 if (p1.argument < p2.argument)
  return 1;
 if (p1.argument > p2.argument)
  return -1;
 return p1.value > p2.value ? -1 : 1;
};
function __aspxSortPointInfoByValue(p1, p2) {
 if (p1.value < p2.value)
  return 1;
 if (p1.value > p2.value)
  return -1;
 return p1.argument > p2.argument ? -1 : 1;
};
function __aspxSortCrosshairElementByValue(p1, p2) {
 if (p1.Point.value < p2.Point.value)
  return 1;
 if (p1.Point.value > p2.Point.value)
  return -1;
 return p1.Point.argument > p2.Point.argument ? -1 : 1;
};
function __aspxSortCrosshairElementByArgument(p1, p2) {
 if (p1.Point.argument < p2.Point.argument)
  return 1;
 if (p1.Point.argument > p2.Point.argument)
  return -1;
 return p1.Point.value > p2.Point.value ? -1 : 1;
};
function __aspxChartGetHorizontalTable(cell1, cell2) {
 return "<table><tr><td>" + cell1 + "</td><td>" + cell2 + "</td></tr></table>";
};
function __aspxChartGetVerticalTable(row1, row2, row3) {
 return "<table><tr><td>" + row1 + "</td></tr><tr><td>" + row2 + "</td></tr><tr><td>" + row3 + "</td></tr></table>";
};
function __aspxGetToolTipX(dockPosition, dockTargetWidth, width, dockTargetX, offset) {
 if (dockPosition.indexOf("Right") > -1) {
  return dockTargetX + dockTargetWidth - width - offset;
 }
 else {
  return dockTargetX + offset;
 }
};
function __aspxGetToolTipY(dockPosition, dockTargetHeight, height, dockTargetY, offset) {
 if (dockPosition.indexOf("Bottom") > -1) {
  return dockTargetY + dockTargetHeight - height - offset;
 }
 else {
  return dockTargetY + offset;
 }
};
function __aspxSetCssClassName(object, chartControl, className) {
 if (chartControl.chart.cssPostfix != "") {
  className += "_" + chartControl.chart.cssPostfix;
 }
 object.className = className;
};
function __aspxCreateChartDiv(chartControl, prefix, index) {
 var div = document.createElement("div");
 div.onselectstart = function() { return false; };
 div.id = __aspxGetChartDivId(chartControl, prefix, index);
 div.style.textAlign = chartControl.rtl ? "right" : "left";
 chartControl.mainElement.appendChild(div);
 return div;
};
function __aspxGetChartDivId(chartControl, prefix, index) {
 return chartControl.uniqueID + prefix + index;
};
function __aspxCreateChartToolTip(chartControl, prefix, index) {
 var div = __aspxCreateChartDiv(chartControl, prefix, index);
 __aspxSetCssClassName(div, chartControl, chartToolTipClassName);
 return div;
};
function __aspxRemoveChartDiv(chartControl, prefix, index) {
 var id = __aspxGetChartDivId(chartControl, prefix, index);
 var mainElement = chartControl.GetMainDOMElement();
 var element = ASPx.GetChildById(chartControl.GetMainDOMElement(), id);
 mainElement.removeChild(element);
};
function __aspxChartSetDivPosition(div, x, y) {
 ASPx.SetAbsoluteX(div, x);
 ASPx.SetAbsoluteY(div, y);
};
function __aspxShowInFreePosition(div, chart, position, htmlElementX, htmlElementY) {
 var left;
 var top;
 if (ASPx.IsExists(position.paneID) && chart.diagram instanceof ASPxClientXYDiagram2D) {
  var pane = chart.diagram.FindPaneByID(position.paneID);
  if (ASPx.IsExists(pane)) {
   left = __aspxGetToolTipX(position.dockPosition, pane.boundsWidth, div.offsetWidth, htmlElementX + pane.boundsLeft, position.offsetX);
   top = __aspxGetToolTipY(position.dockPosition, pane.boundsHeight, div.offsetHeight, htmlElementY + pane.boundsTop, position.offsetY);
  }
 }
 else {
  left = __aspxGetToolTipX(position.dockPosition, chart.chartControl.GetWidth(), div.offsetWidth, htmlElementX, position.offsetX);
  top = __aspxGetToolTipY(position.dockPosition, chart.chartControl.GetHeight(), div.offsetHeight, htmlElementY, position.offsetY);
 }
 __aspxChartSetDivPosition(div, left, top);
}
var CrosshairElementsGroup = ASPx.CreateClass(null, {
 constructor: function(seriesPoint, snapsToArgument) {
  this.headerText="";
  this.anchorValue = snapsToArgument ? seriesPoint.argument : seriesPoint.values[0];
  this.crosshairElements = [];
  this.crosshairGroupHeaderElement = null;
 }
});
var CrosshairRenderer = ASPx.CreateClass(ASPxClientControl, {
 constructor: function (chartControl, name) {
  this.constructor.prototype.constructor.call(this, name);
  this.chart = chartControl;
  this.hDivs = [];
  this.vDivs = [];
  this.labelDivs = [];
  this.hLabelDivs = [];
  this.vLabelDivs = [];
  this.diagram = chartControl.chart.diagram;
  this.snapToNearestArgument = this.chart.chart.crosshairOptions.snapMode == "NearestArgument";
  this.isHorizontal = this.snapToNearestArgument ^ this.diagram.rotated;
  this.indent = 2;
 },
 CreateVerticalLineDiv: function (index) {
  var div = __aspxCreateChartDiv(this.chart, ASPx.crosshairVDivID, index);
  __aspxSetCssClassName(div, this.chart, chartCrosshairVLineClassName);
  this.vDivs.push(div);
  return div;
 },
 CreateHorizontalLineDiv: function (index) {
  var div = __aspxCreateChartDiv(this.chart, ASPx.crosshairHDivID, index);
  __aspxSetCssClassName(div, this.chart, chartCrosshairHLineClassName);
  this.hDivs.push(div);
  return div;
 },
 CreateVerticalLabelDiv: function (index) {
  var div = __aspxCreateChartDiv(this.chart, ASPx.crosshairVLabelID, index);
  __aspxSetCssClassName(div, this.chart, chartCrosshairLabelClassName);
  this.vLabelDivs.push(div);
  return div;
 },
 CreateHorizontalLabelDiv: function (index) {
  var div = __aspxCreateChartDiv(this.chart, ASPx.crosshairHLabelID, index);
  __aspxSetCssClassName(div, this.chart, chartCrosshairLabelClassName);
  this.hLabelDivs.push(div);
  return div;
 },
 CreateMainLabelDiv: function (index) {
  var div = __aspxCreateChartToolTip(this.chart, ASPx.crosshairLabelID, index);
  this.labelDivs.push(div);
  return div;
 },
 GetPane: function (x, y) {
  if (this.diagram != null && this.diagram instanceof ASPxClientXYDiagram2D){
   if (this.diagram.defaultPane.visible && this.diagram.defaultPane.InPane(x, y))
    return this.diagram.defaultPane;
   for (var i = 0; i < this.diagram.panes.length; i++) {
    if (this.diagram.panes[i].InPane(x, y))
     return this.diagram.panes[i];
   }
   return null;
  }
  return null;
 },
 ClearDivArray: function (divArray, prefix, index) {
  var length = divArray.length;
  if (index < length) {
   for (var i = index; i < length; i++) {
    divArray.pop();
    __aspxRemoveChartDiv(this.chart, prefix, i);
   }
  }
 },
 Hide: function () {
  this.ClearDivs(0, 0, 0, 0, 0);
 },
 ClearDivs: function (hLineIndex, vLineIndex, hLabelIndex, vLabelIndex, labelIndex) {
  this.ClearDivArray(this.hDivs, ASPx.crosshairHDivID, hLineIndex);
  this.ClearDivArray(this.vDivs, ASPx.crosshairVDivID, vLineIndex);
  this.ClearDivArray(this.hLabelDivs, ASPx.crosshairHLabelID, hLabelIndex);
  this.ClearDivArray(this.vLabelDivs, ASPx.crosshairVLabelID, vLabelIndex);
  this.ClearDivArray(this.labelDivs, ASPx.crosshairLabelID, labelIndex);
 },
 GetVerticalDiv: function (index) {
  if (index < this.vDivs.length)
   return this.vDivs[index];
  return this.CreateVerticalLineDiv(index);
 },
 GetHorizontalDiv: function (index) {
  if (index < this.hDivs.length)
   return this.hDivs[index];
  return this.CreateHorizontalLineDiv(index);
 },
 GetVerticalLabelDiv: function (index) {
  if (index < this.vLabelDivs.length)
   return this.vLabelDivs[index];
  return this.CreateVerticalLabelDiv(index);
 },
 GetHorizontalLabelDiv: function (index) {
  if (index < this.hLabelDivs.length)
   return this.hLabelDivs[index];
  return this.CreateHorizontalLabelDiv(index);
 },
 GetLabelDiv: function (index) {
  if (index < this.labelDivs.length)
   return this.labelDivs[index];
  return this.CreateMainLabelDiv(index);
 },
 GetCrosshairSeries: function (pane) {
  var crosshairSeries = [];
  for (var i = 0; i < this.chart.chart.series.length; i++) {
   var series = this.chart.chart.series[i];
   if (series.paneID == pane.paneID && series.visible)
    crosshairSeries.push(series);
  }
  return crosshairSeries;
 },
 ClampCoord: function (coord, start, length) {
  if (coord < start)
   coord = start;
  else {
   if (coord > start + length)
    coord = start + length;
  }
  return coord;
 },
 GetAxisByID: function (id, isXAxis) {
  if (isXAxis) {
   return this.diagram.FindAxisXByID(id);
  }
  return this.diagram.FindAxisYByID(id);
 },
 GetDiff: function (value1, value2) {
  return value1 > value2 ? value1 - value2 : value2 - value1;
 },
 GetValueItemsByValue: function (series, index) {
  var items = [];
  var crosshairValueItem = series.crosshairValueItems[index];
  items.push(crosshairValueItem);
  for (var i = index - 1; i >= 0; i--) {
   if (series.crosshairValueItems[i].value == crosshairValueItem.value) {
    items.push(series.crosshairValueItems[i]);
   }
   else {
    break;
   }
  }
  for (var i = index + 1; i < series.crosshairValueItems.length; i++) {
   if (series.crosshairValueItems[i].value == crosshairValueItem.value) {
    items.push(series.crosshairValueItems[i]);
   }
   else {
    break;
   }
  }
  return items;
 },
 GetAxisValue: function (axisValues, axis) {
  for (var i = 0; i < axisValues.length; i++) {
   if (axisValues[i].axis == axis) {
    return axisValues[i].internalValue;
   }
  }
  return null;
 },
 FindNearestPoint: function (pane, series, valueItems, axisValues, primaryAxis, secondaryAxis) {
  var axisValue = this.GetAxisValue(axisValues, secondaryAxis);
  var value = null;
  var valueItem = null;
  for (var i = 0; i < valueItems.length; i++) {
   var point = series.points[valueItems[i].pointIndex];
   if (ASPx.IsExists(point.isEmpty))
    if (point.isEmpty)
     continue;
   if (this.snapToNearestArgument) {
    for (var j = 0; j < point.values.length; j++) {
     var pointValue = point.crosshairValues[j];
     var isVisible = this.diagram.IsAxisValueVisible(pane, secondaryAxis, pointValue) || this.chart.chart.crosshairOptions.showOutOfRangePoints;
     if (isVisible && (value == null || this.GetDiff(axisValue, pointValue) < this.GetDiff(axisValue, value))) {
      value = pointValue;
      valueItem = valueItems[i];
     }
    }
   }
   else {
    var pointValue = secondaryAxis.GetInternalArgument(point.argument);
    var isVisible = this.diagram.IsAxisValueVisible(pane, secondaryAxis, pointValue) || this.chart.chart.crosshairOptions.showOutOfRangePoints;
    if (isVisible && (value == null || this.GetDiff(axisValue, pointValue) < this.GetDiff(axisValue, value))) {
     value = pointValue;
     valueItem = valueItems[i];
    }
   }
  }
  if (value == null || valueItem == null) {
   return null;
  }
  var point = series.points[valueItem.pointIndex];
  var argument = this.snapToNearestArgument ? valueItem.value : value;
  if (ASPx.IsExists(point.offset)) {
   argument += point.offset;
  }
  value = this.snapToNearestArgument ? value : valueItem.value;
  var argumentAxis = this.snapToNearestArgument ? primaryAxis : secondaryAxis;
  var valueAxis = this.snapToNearestArgument ? secondaryAxis : primaryAxis;
  var x = this.diagram.MapInternalToPoint(pane, argumentAxis, argument);
  var y = this.diagram.MapInternalToPoint(pane, valueAxis, value);
  if (ASPx.IsExists(point.fixedOffset)) {
   x += point.fixedOffset;
  }
  var ax = this.diagram.rotated ? y : x;
  var ay = this.diagram.rotated ? x : y;
  return { point: point, x: ax, y: ay, argument: argument, value: value };
 },
 AddCursorCrosshairItems: function (paneCrosshairInfo, value, isArgument, isHorizontal, axis) {
  paneCrosshairInfo.AddCursorCrosshairLine(value, isHorizontal, this.snapToNearestArgument ^ isArgument);
  paneCrosshairInfo.AddCursorCrosshairLabel(value, isHorizontal);
 },
 AddCrosshairItems: function (paneCrosshairInfo, point, value, isArgument, isHorizontal, axis) {
  point.axisValue = value;
  paneCrosshairInfo.AddPoint(point);
  paneCrosshairInfo.AddCrosshairLine(point, value, isHorizontal, this.snapToNearestArgument ^ isArgument);
  paneCrosshairInfo.AddCrosshairLabel(point, value, isHorizontal);
 },
 GetRange: function (pane, percent, maxValue) {
  var range = this.isHorizontal ? pane.boundsWidth : pane.boundsHeight;
  range *= percent;
  if (maxValue > 0 && range > maxValue)
   range = maxValue;
  return range;
 },
 AddCrosshairPointItems: function (paneCrosshairInfo, secondaryItem) {
  var value = this.isHorizontal ? secondaryItem.pointInfo.y : secondaryItem.pointInfo.x;
  var internalValue = this.snapToNearestArgument ? secondaryItem.pointInfo.value : secondaryItem.pointInfo.argument;
  this.AddCrosshairItems(paneCrosshairInfo, secondaryItem.pointInfo, new AxisValuePair(secondaryItem.secondaryAxis, internalValue, value), !this.snapToNearestArgument, this.isHorizontal, secondaryItem.secondaryAxis);
 },
 GetCrosshairValueItemIndex: function (series, axisValue) {
  var index = ASPx.Data.ArrayBinarySearch(series.crosshairValueItems, axisValue, __aspxCrosshairValueItemsComparer, 0, series.crosshairValueItems.length);
  if (index < 0) {
   index = -1 * index - 1;
   if (index >= series.crosshairValueItems.length)
    index = series.crosshairValueItems.length - 1;
   else {
    if (index > 0) {
     var prev = this.GetDiff(series.crosshairValueItems[index - 1].value, axisValue);
     var next = this.GetDiff(series.crosshairValueItems[index].value, axisValue);
     if (!ASPx.IsExists(series.invertedStep)) {
      if (prev < next)
       index--;
     }
     else
      if (!series.invertedStep && index > 0)
       index--;
    }
   }
  }
  return index;
 },
 IsBarSeries: function (series) {
  if (series.viewType == "Bar" ||
   series.viewType == "StackedBar" ||
   series.viewType == "FullStackedBar" ||
   series.viewType == "SideBySideStackedBar" ||
   series.viewType == "SideBySideFullStackedBar" ||
   series.viewType == "SideBySideRangeBar" ||
   series.viewType == "RangeBar" ||
   series.viewType == "SideBySideGantt" ||
   series.viewType == "Gantt") {
   return true;
  }
  return false;
 },
 IsContinuousSeries: function (series) {
  if (series.viewType == "Bar" ||
   series.viewType == "Line" ||
   series.viewType == "StackedLine" ||
   series.viewType == "FullStackedLine" ||
   series.viewType == "StepLine" ||
   series.viewType == "Spline" ||
   series.viewType == "ScatterLine" ||
   series.viewType == "SwiftPlot" ||
   series.viewType == "Area" ||
   series.viewType == "StepArea" ||
   series.viewType == "SplineArea" ||
   series.viewType == "StackedArea" ||
   series.viewType == "StackedSplineArea" ||
   series.viewType == "StackedStepArea" ||
   series.viewType == "FullStackedArea" ||
   series.viewType == "FullStackedSplineArea" ||
   series.viewType == "FullStackedStepArea" ||
   series.viewType == "RangeArea") {
   return true;
  }
  return false;
 },
 GetBarRange: function (pane, series, point, smallRange) {
  var barRange = smallRange;
  if (this.snapToNearestArgument) {
   if (ASPx.IsExists(point.point.barWidth)) {
    var pointArgument = point.argument;
    var barWidth = point.point.barWidth;
    var pointValue = pointArgument;
    var axisX = this.GetAxisByID(series.axisXID, true);
    var barSidePoint = this.diagram.MapInternalToPoint(pane, axisX, pointValue + barWidth * 0.5);
    if (ASPx.IsExists(point.point.fixedOffset))
     barSidePoint += point.point.fixedOffset;
    barRange = this.isHorizontal ? barSidePoint - point.x : barSidePoint - point.y;
    barRange = barRange > 0 ? barRange : -barRange;
    barRange = barRange < smallRange ? smallRange : barRange;
   }
  }
  return barRange;
 },
 GetContinuousSeriesRange: function (pane, series, point, crosshairPosition, smallRange, maxRange, primaryAxis) {
  var continuousRange = maxRange;
  if (point.argument == series.crosshairValueItems[0].value) {
   if (this.isHorizontal) {
    if (!primaryAxis.reverse && crosshairPosition < point.x || primaryAxis.reverse && crosshairPosition > point.x)
     continuousRange = smallRange;
   }
   else
    if (!primaryAxis.reverse && crosshairPosition > point.y || primaryAxis.reverse && crosshairPosition < point.y)
     continuousRange = smallRange;
  }
  else
   if (point.argument == series.crosshairValueItems[series.crosshairValueItems.length - 1].value) {
    if (this.isHorizontal) {
     if (!primaryAxis.reverse && crosshairPosition > point.x || primaryAxis.reverse && crosshairPosition < point.x)
      continuousRange = smallRange;
    }
    else
     if (!primaryAxis.reverse && crosshairPosition < point.y || primaryAxis.reverse && crosshairPosition > point.y)
      continuousRange = smallRange;
   }
  return continuousRange;
 },
 AreArgumentsEqual: function (argument1, argument2) {
  if (argument1 instanceof Date && argument2 instanceof Date) {
   return argument1.toString() == argument2.toString();
  }
  else
   return argument1 == argument2;
 },
 FindConnectedPoint: function (series, nearestPoint, pane) {
  var connectedPoint;
  var secondaryAxisID = this.snapToNearestArgument ? series.axisYID : series.axisXID;
  var secondaryAxis = this.GetAxisByID(secondaryAxisID, !this.snapToNearestArgument);
  if (this.snapToNearestArgument) {
   var pointInfo = nearestPoint.pointInfo;
   var offset = ASPx.IsExists(pointInfo.point.offset) ? pointInfo.point.offset : 0;
   var index = ASPx.Data.ArrayBinarySearch(series.crosshairValueItems, pointInfo.argument - offset, __aspxCrosshairValueItemsComparer, 0, series.crosshairValueItems.length);
   if (index < 0)
    index = -1 * index - 1;
   if (index >= series.crosshairValueItems.length)
    index = series.crosshairValueItems.length - 1;
   if (index >= 0) {
    var seriesPoint = series.points[series.crosshairValueItems[index].pointIndex];
    if (ASPx.IsExists(seriesPoint.isEmpty))
     if (seriesPoint.isEmpty)
      return null;
    var pointVisible = false;
    for (var j = 0; j < seriesPoint.crosshairValues.length; j++) {
     var pointValue = seriesPoint.crosshairValues[j];
     var isVisible = this.diagram.IsAxisValueVisible(pane, secondaryAxis, pointValue) || this.chart.chart.crosshairOptions.showOutOfRangePoints;
     if (isVisible)
      pointVisible = true;
    }
    if (!pointVisible)
     return null;
    if (this.AreArgumentsEqual(pointInfo.point.argument, seriesPoint.argument))
     connectedPoint = seriesPoint;
   }
  }
  return connectedPoint;
 },
 CreatePointInfo: function(point, pane, series, axisValues, secondaryAxis) {
  var primaryAxisID = this.snapToNearestArgument ? series.axisXID : series.axisYID;
  var primaryAxis = this.GetAxisByID(primaryAxisID, this.snapToNearestArgument);
  var primaryAxisValue = this.GetAxisValue(axisValues, primaryAxis);
  var primaryScreenAxisValue = this.diagram.MapInternalToPoint(pane, primaryAxis, primaryAxisValue);
  if (!series.actualCrosshairEnabled || series.crosshairValueItems.length == 0)
   return;
  var index = this.GetCrosshairValueItemIndex(series, primaryAxisValue);
  var valueItems = this.GetValueItemsByValue(series, index);
  var axisValue = this.GetAxisValue(axisValues, secondaryAxis);
  var value = null;
  var valueItem = null;
  for (var i = 0; i < valueItems.length; i++) {
   if (point == series.points[valueItems[i].pointIndex]) {
    if (this.snapToNearestArgument) {
     for (var j = 0; j < point.values.length; j++) {
      var pointValue = point.crosshairValues[j];
      var isVisible = this.diagram.IsAxisValueVisible(pane, secondaryAxis, pointValue) || this.chart.chart.crosshairOptions.showOutOfRangePoints;
      if (isVisible) {
       value = pointValue;
       valueItem = valueItems[i];
      }
     }
    }
    else {
     value = secondaryAxis.GetInternalArgument(point.argument);
     valueItem = valueItems[i];
    }
   }
  }
  if (value == null || valueItem == null) {
   return null;
  }
  var point = series.points[valueItem.pointIndex];
  var argument = this.snapToNearestArgument ? valueItem.value : value;
  if (ASPx.IsExists(point.offset)) {
   argument += point.offset;
  }
  value = this.snapToNearestArgument ? value : valueItem.value;
  var x = this.diagram.MapInternalToPoint(pane, this.snapToNearestArgument ? primaryAxis : secondaryAxis, argument);
  var y = this.diagram.MapInternalToPoint(pane, this.snapToNearestArgument ? secondaryAxis : primaryAxis, value);
  if (ASPx.IsExists(point.fixedOffset)) {
   x += point.fixedOffset;
  }
  var ax = this.diagram.rotated ? y : x;
  var ay = this.diagram.rotated ? x : y;
  return { point: point, x: ax, y: ay, argument: argument, value: value };
 },
 AddSortedCrosshairPointItems: function (paneCrosshairInfo, pane, x, y, crosshairSeries, secondaryItems) {
  for (var i = 0; i < crosshairSeries.length; i++) {
   var series = crosshairSeries[i];
   for (var j = 0; j < secondaryItems.length; j++) {
    if (secondaryItems[j].series == series) {
     this.AddCrosshairPointItems(paneCrosshairInfo, secondaryItems[j]);
     break;
    }
   }
  }
  return paneCrosshairInfo;
 },
 FindConnectedPointItems: function (nearestPoint, crosshairSeries, pane, axisValues) {
  var connectedItems = [];
  for (var i = 0; i < crosshairSeries.length; i++) {
   var series = crosshairSeries[i];
   if (series != nearestPoint.series) {
    var seriesConnectedPoint = this.FindConnectedPoint(series, nearestPoint, pane);
    if (seriesConnectedPoint != null) {
     var secondaryAxisID = this.snapToNearestArgument ? series.axisYID : series.axisXID;
     var secondaryAxis = this.GetAxisByID(secondaryAxisID, !this.snapToNearestArgument);
     var pointInfo = this.CreatePointInfo(seriesConnectedPoint, pane, series, axisValues, secondaryAxis);
     if (pointInfo != null)
      connectedItems.push({ pointInfo: pointInfo, secondaryAxis: secondaryAxis, series: series });
    }
   }
  }
  return connectedItems;
 },
 CalculatePaneCrosshairInfo: function (pane, x, y) {
  x = this.ClampCoord(x, pane.boundsLeft, pane.boundsWidth);
  y = this.ClampCoord(y, pane.boundsTop, pane.boundsHeight);
  var paneCrosshairInfo = new PaneCrosshairInfo(pane, x, y);
  var crosshairSeries = this.GetCrosshairSeries(pane);
  var axisValues = this.diagram.MapPointToInternal(pane, x, y);
  var smallRange = this.GetRange(pane, 0.08, 20);
  var secondaryItems = [];
  var nearestPoint = null;
  var minDiff = -1;
  var primaryAxisID = this.snapToNearestArgument ? pane.primaryAxisXID : pane.primaryAxisYID;
  var primaryAxis = this.GetAxisByID(primaryAxisID, this.snapToNearestArgument);
  var primaryAxisValue = this.GetAxisValue(axisValues, primaryAxis);
  var primaryScreenAxisValue = this.diagram.MapInternalToPoint(pane, primaryAxis, primaryAxisValue);
  this.AddCursorCrosshairItems(paneCrosshairInfo, new AxisValuePair(primaryAxis, primaryAxisValue, primaryScreenAxisValue), this.snapToNearestArgument, !this.isHorizontal, primaryAxis);
  for (var i = 0; i < crosshairSeries.length; i++) {
   var series = crosshairSeries[i];
   if (!series.actualCrosshairEnabled || series.crosshairValueItems.length == 0)
    continue;
   primaryAxisID = this.snapToNearestArgument ? series.axisXID : series.axisYID;
   primaryAxis = this.GetAxisByID(primaryAxisID, this.snapToNearestArgument);
   primaryAxisValue = this.GetAxisValue(axisValues, primaryAxis);
   var index = this.GetCrosshairValueItemIndex(series, primaryAxisValue);
   var valueItems = this.GetValueItemsByValue(series, index);
   var secondaryAxisID = this.snapToNearestArgument ? series.axisYID : series.axisXID;
   var secondaryAxis = this.GetAxisByID(secondaryAxisID, !this.snapToNearestArgument);
   var pointInfo = this.FindNearestPoint(pane, series, valueItems, axisValues, primaryAxis, secondaryAxis);
   if (pointInfo != null && ((this.chart.chart.crosshairOptions.showOutOfRangePoints && this.chart.chart.crosshairOptions.crosshairLabelMode == "ShowCommonForAllSeries") || pane.InPane(pointInfo.x, pointInfo.y))) {
    var diff = this.GetDiff(this.isHorizontal ? x : y, this.isHorizontal ? pointInfo.x : pointInfo.y);
    var correctedRange = smallRange;
    if (this.IsBarSeries(series)) {
     correctedRange = this.GetBarRange(pane, series, pointInfo, smallRange);
    }
    else {
     if (this.IsContinuousSeries(series)) {
      correctedRange = this.GetContinuousSeriesRange(pane, series, pointInfo, this.isHorizontal ? x : y, correctedRange, this.isHorizontal ? pane.boundsWidth : pane.boundsHeight, primaryAxis);
     }
    }
    if (diff <= correctedRange) {
     if (this.chart.chart.crosshairOptions.crosshairLabelMode != "ShowForNearestSeries" &&
      (series.argumentScaleType == "Qualitative" && this.chart.chart.crosshairOptions.valueSelectionMode == "Default" ||
      this.IsBarSeries(series) || 
      this.chart.chart.crosshairOptions.valueSelectionMode == "Value")) {
      if (minDiff == -1 || (minDiff != -1 && diff < minDiff)) {
       minDiff = diff;
       nearestPoint = { pointInfo: pointInfo, secondaryAxis: secondaryAxis, series: series };
      }
     }
     else
      if (this.chart.chart.crosshairOptions.crosshairLabelMode == "ShowForNearestSeries" && secondaryItems.length > 0) {
       var pointDiff = this.CalcSquareLength(x, y, pointInfo.x, pointInfo.y);
       for (var secondaryItemIndex = 0; secondaryItemIndex < secondaryItems.length; secondaryItemIndex++) {
        var secondaryItem = secondaryItems[secondaryItemIndex];
        var itemDiff = this.CalcSquareLength(x, y, secondaryItem.pointInfo.x, secondaryItem.pointInfo.y);
        if (pointDiff < itemDiff) {
         secondaryItems = [];
         secondaryItems.push({ pointInfo: pointInfo, secondaryAxis: secondaryAxis, series: series });
        }
       }
      }
      else
       secondaryItems.push({ pointInfo: pointInfo, secondaryAxis: secondaryAxis, series: series });
    }
   }
  }
  if (nearestPoint != null) {
   secondaryItems.push(nearestPoint);
   var connectedPoints = this.FindConnectedPointItems(nearestPoint, crosshairSeries, pane, axisValues);
   for (var i = 0; i < connectedPoints.length; i++)
    secondaryItems.push(connectedPoints[i]);
  }
  paneCrosshairInfo = this.AddSortedCrosshairPointItems(paneCrosshairInfo, pane, x, y, crosshairSeries, secondaryItems);
  return paneCrosshairInfo;
 },
 AddUniqueValue: function (uniqueValues, value) {
  for (var i = 0; i < uniqueValues.length; i++) {
   if (uniqueValues[i] == value)
    return false;
  }
  uniqueValues.push(value);
  return true;
 },
 FindAxisLabelBounds: function(pane, axis) {
  if (ASPx.IsExists(pane.axisLabelBounds)) {
   for (var i = 0; i < pane.axisLabelBounds.length; i++) {
    if (pane.axisLabelBounds[i].GetAxis() == axis)
     return pane.axisLabelBounds[i];
   }
  }
  return null;
 },
 GetLineLabelHtml: function (axisValuePair, isValueAxis) {
  var value = axisValuePair.axis.GetNativeArgument(axisValuePair.internalValue);
  return ASPx.ToolTipPatternHelper.GetAxisLabelText(axisValuePair.axis, isValueAxis, value);
 },
 GetLineThickness: function (horizontal) {
  horizontal = horizontal ^ this.diagram.rotated;
  if (horizontal) {
   lineStyle = this.chart.chart.crosshairOptions.valueLineStyle;
  }
  else {
   lineStyle = this.chart.chart.crosshairOptions.argumentLineStyle;
  }
  if (lineStyle != null) {
   return lineStyle.thickness;
  }
  else {
   return 0;
  }
 },
 DrawCrosshairLineElements: function(crosshairDrawInfo) {
  var chartImage = this.chart.GetChartElement();
  var chartX = ASPx.GetAbsoluteX(chartImage);
  var chartY = ASPx.GetAbsoluteY(chartImage);
  for (var i = 0; i < crosshairDrawInfo.CrosshairElements.length; i++) {
   if (crosshairDrawInfo.CrosshairElements[i].visible) {
    var crosshairLine = crosshairDrawInfo.CrosshairElements[i].Point.crosshairLine;
    var crosshairLineElement = crosshairDrawInfo.CrosshairElements[i].LineElement;
    this.DrawCrosshairLine(crosshairLine, crosshairDrawInfo.pane, chartX, chartY, crosshairLineElement);
   }
  }
  if (!ASPx.IsExists(crosshairDrawInfo.CursorCrosshairLineDrawInfo))
   return;
  var cursorCrosshairLine = crosshairDrawInfo.CursorCrosshairLineDrawInfo.crosshairLine;
  var crosshairLineElement = crosshairDrawInfo.CursorCrosshairLineDrawInfo.cursorCrosshairLineElement;
  this.DrawCrosshairLine(cursorCrosshairLine, crosshairDrawInfo.pane, chartX, chartY, crosshairLineElement);
 },
 SetLineStyle: function (lineDiv, crosshairLineElement) {
  var lineStyle = crosshairLineElement.lineStyle;
  lineDiv.style.borderRight = "0px";
  lineDiv.style.borderLeft = "0px";
  lineDiv.style.borderTop = "0px";
  lineDiv.style.borderBottom = "0px";
  if (lineStyle != null) {
   lineDiv.style.borderTop = lineStyle.thickness + "px";
   lineDiv.style.borderLeft = lineStyle.thickness + "px";
  }
  else {
   lineDiv.style.borderTop = "1px";
   lineDiv.style.borderLeft = "1px";
  }
  if (crosshairLineElement.color != null) {
   lineDiv.style.borderColor = crosshairLineElement.color;
  }
  var dashStyle;
  if (lineStyle != null) {
   switch (lineStyle.dashStyle) {
    case "Empty":
     dashStyle = "none";
     break;
    case "Solid":
     dashStyle = "solid";
     break;
    case "Dash":
     dashStyle = "dashed";
     break;
    default:
     dashStyle = "dotted";
   }
  }
  else {
   dashStyle = "solid";
  }
  lineDiv.style.borderStyle = dashStyle;
 },
 DrawCrosshairLine: function (crosshairLine, pane, chartX, chartY, crosshairLineElement) {
  var axisValuePair = crosshairLine.axisValuePair;
  if (!crosshairLineElement.visible)
   return;
  if (crosshairLine.isHorizontal) {
   var lineDiv = this.GetHorizontalDiv(this.hLineIndex);
   var offsetY = Math.floor(this.GetLineThickness(true) / 2);
   __aspxChartSetDivPosition(lineDiv, chartX + pane.boundsLeft, chartY + axisValuePair.screenValue - offsetY);
   lineDiv.style.width = pane.boundsWidth + "px";
   this.SetLineStyle(lineDiv, crosshairLineElement);
   this.hLineIndex++;
  }
  else {
   var lineDiv = this.GetVerticalDiv(this.vLineIndex);
   var offsetX = Math.floor(this.GetLineThickness(false) / 2);
   __aspxChartSetDivPosition(lineDiv, chartX + axisValuePair.screenValue - offsetX, chartY + pane.boundsTop);
   lineDiv.style.height = pane.boundsHeight + "px";
   this.SetLineStyle(lineDiv, crosshairLineElement);
   this.vLineIndex++;
  }
 },
 DrawCrosshairAxisLabelElements: function(crosshairDrawInfo) {
  var chartImage = this.chart.GetChartElement();
  var chartX = ASPx.GetAbsoluteX(chartImage);
  var chartY = ASPx.GetAbsoluteY(chartImage);
  for (var i = 0; i < crosshairDrawInfo.CrosshairElements.length; i++) {
   if (crosshairDrawInfo.CrosshairElements[i].visible) {
    var crosshairAxisLabel = crosshairDrawInfo.CrosshairElements[i].Point.crosshairLabel;
    var crosshairAxisLabelElement = crosshairDrawInfo.CrosshairElements[i].AxisLabelElement;
    this.DrawCrosshairAxisLabel(crosshairAxisLabel, crosshairDrawInfo.pane, chartX, chartY, crosshairAxisLabelElement);
   }
  }
  for (var i = 0; i < crosshairDrawInfo.CursorCrosshairAxisLabelDrawInfos.length; i++) {
   var crosshairAxisLabel = crosshairDrawInfo.CursorCrosshairAxisLabelDrawInfos[i].crosshairAxisLabel;
   var crosshairAxisLabelElement = crosshairDrawInfo.CursorCrosshairAxisLabelDrawInfos[i].cursorCrosshairAxisLabelElement;
   this.DrawCrosshairAxisLabel(crosshairAxisLabel, crosshairDrawInfo.pane, chartX, chartY, crosshairAxisLabelElement);
  }
 },
 SetCrosshairAxisLabelOptions: function (labelDiv, crosshairAxisLabelElement) {
  if (crosshairAxisLabelElement.backColor != null) {
   labelDiv.style.background = crosshairAxisLabelElement.backColor;
  }
  this.SetTextOptions(labelDiv, crosshairAxisLabelElement);
 },
 SetTextOptions: function (labelDiv, element) {
  if (element.textColor != null)
   labelDiv.style.color = element.textColor;
  if (element.font != null) {
   var font = element.font;
   labelDiv.style.fontSize = font.fontSize + "pt";
   labelDiv.style.fontFamily = font.fontFamily;
   if (font.bold)
    labelDiv.style.fontWeight = "bold";
   if (font.italic)
    labelDiv.style.fontStyle = "italic";
   var decoration = "";
   if (font.underline)
    decoration += "underline";
   if (font.strikeout)
    decoration += " line-through";
   labelDiv.style.textDecoration = decoration;
  }
 },
 CreateTextSettingsStyle: function (element) {
  var style = "";
  if (element.textColor != null)
   style += "color:" + element.textColor + ";";
  if (element.font != null) {
   var font = element.font;
   if (font.bold)
    style += "font-weight:bold;";
   if (font.italic)
    style += "font-style:italic;";
   var decoration = "";
   if (font.underline)
    decoration += "underline";
   if (font.strikeout) {
    if (decoration != "")
     decoration += " ";
    decoration += "line-through";
   }
   if (decoration != "")
    style += "text-decoration:" + decoration + ";"
   style += "font-size:" + font.fontSize + "pt;font-family:" + font.fontFamily + ";";
  }
  return style != "" ? "style =' " + style + "'" : style;
 },
 DrawCrosshairAxisLabel: function (crosshairAxisLabel, pane, chartX, chartY, crosshairAxisLabelElement) {
  var axisValuePair = crosshairAxisLabel.axisValuePair;
  if (!crosshairAxisLabelElement.visible)
   return;
  if (crosshairAxisLabel.isHorizontal) {
   var axisLabelBounds = this.FindAxisLabelBounds(pane, axisValuePair.axis);
   if (axisLabelBounds != null) {
    var labelDiv = this.GetHorizontalLabelDiv(this.hLabelIndex);
    this.SetCrosshairAxisLabelOptions(labelDiv, crosshairAxisLabelElement);
    labelDiv.innerHTML = crosshairAxisLabelElement.text; 
    var offset = axisLabelBounds.left;
    if (axisLabelBounds.left < pane.boundsLeft)
     offset += axisLabelBounds.width - labelDiv.offsetWidth;
    __aspxChartSetDivPosition(labelDiv, chartX + offset, chartY + axisValuePair.screenValue - labelDiv.offsetHeight / 2);
    this.hLabelIndex++;
   }
  }
  else {
   var axisLabelBounds = this.FindAxisLabelBounds(pane, axisValuePair.axis);
   if (axisLabelBounds != null) {
    var labelDiv = this.GetVerticalLabelDiv(this.vLabelIndex);
    this.SetCrosshairAxisLabelOptions(labelDiv, crosshairAxisLabelElement);
    labelDiv.innerHTML = crosshairAxisLabelElement.text; 
    var offset = axisLabelBounds.top;
    if (axisLabelBounds.top < pane.boundsTop)
     offset += axisLabelBounds.height - labelDiv.offsetHeight;
    __aspxChartSetDivPosition(labelDiv, chartX + axisValuePair.screenValue - labelDiv.offsetWidth / 2, chartY + offset);
    this.vLabelIndex++;
   }
  }
 },
 DrawCrosshairSeriesLabel: function (pane, labelsBounds, pointsInfo, pointInfo, seriesLabelElement, isSingle) {
  if (!seriesLabelElement.visible)
   return;
  var labelDiv = this.GetLabelDiv(this.labelIndex);
  var marker = "";
  var text = "";
  if (seriesLabelElement.textVisible)
   text = seriesLabelElement.text;
  if (seriesLabelElement.markerVisible)
   marker = seriesLabelElement.marker;
  var textContent = __aspxChartGetHorizontalTable(marker, text);
  var content = __aspxChartGetVerticalTable(seriesLabelElement.headerText, textContent, seriesLabelElement.footerText);
  labelDiv.innerHTML = content;
  this.SetTextOptions(labelDiv, seriesLabelElement);
  var crosshairOptions = this.chart.chart.crosshairOptions;
  if (ASPx.IsExists(crosshairOptions.crosshairLabelBackColor))
   labelDiv.style.backgroundColor = crosshairOptions.crosshairLabelBackColor;
  var x = pointInfo.x - pane.boundsLeft;
  var y = pointInfo.y - pane.boundsTop;
  var labelBounds = { x: x, y: y, width: labelDiv.offsetWidth, height: labelDiv.offsetHeight };
  var direction = { x: 1, y: -1 };
  direction = this.CheckCrosshairSeriesLabelDirection(direction, pointInfo.x, pointInfo.y, labelDiv);
  this.SetDirection(labelBounds, x, y, direction.x, direction.y);
  if (!isSingle) {
   direction = this.CorrectCrosshairSeriesLabelBounds(labelsBounds, pane, labelBounds, pointsInfo, x, y, direction.x, direction.y);
  }
  var verticalPrefix = direction.y > 0 ? "Top" : "Bottom";
  var horizontalPrefix = direction.x > 0 ? "Left" : "Right";
  labelsBounds.push(labelBounds);
  var chartImage = this.chart.GetChartElement();
  var offsetX = ASPx.GetAbsoluteX(chartImage) + pane.boundsLeft;
  var offsetY = ASPx.GetAbsoluteY(chartImage) + pane.boundsTop;
  __aspxSetCssClassName(labelDiv, this.chart, chartToolTipClassName + "_" + verticalPrefix + horizontalPrefix);
  __aspxChartSetDivPosition(labelDiv, offsetX + labelBounds.x, offsetY + labelBounds.y);
  this.labelIndex++;
 },
 CalcSquareLength: function (x1, y1, x2, y2) {
  return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
 },
 DrawCrosshairSeriesLabels: function (crosshairDrawInfo, paneCrosshairInfo) {
  if (this.diagram.rotated) {
   crosshairDrawInfo.CrosshairElements.sort(__aspxSortCrosshairElementByValue);
  }
  else {
   crosshairDrawInfo.CrosshairElements.sort(__aspxSortCrosshairElementByArgument);
  }
  if (crosshairDrawInfo.CrosshairElements.length < 1)
   return;
  var pointsInfo = [];
  for (var i = 0; i < crosshairDrawInfo.CrosshairElements.length; i++) {
   pointsInfo.push(crosshairDrawInfo.CrosshairElements[i].Point);
  }
  switch (this.chart.chart.crosshairOptions.crosshairLabelMode) {
   case "ShowForEachSeries":
    for (var i = 0; i < crosshairDrawInfo.CrosshairElements.length; i++) {
     if (crosshairDrawInfo.CrosshairElements[i].visible) {
      var pointInfo = crosshairDrawInfo.CrosshairElements[i].Point;
      var seriesLabelElement = crosshairDrawInfo.CrosshairElements[i].LabelElement;
      this.DrawCrosshairSeriesLabel(crosshairDrawInfo.pane, crosshairDrawInfo.labelsBounds, pointsInfo, pointInfo, seriesLabelElement, false);
     }
    }
    break;
   case "ShowForNearestSeries":
    var min = this.CalcSquareLength(paneCrosshairInfo.x, paneCrosshairInfo.y, pointsInfo[0].x, pointsInfo[0].y);
    var index = 0;
    for (var i = 1; i < pointsInfo.length; i++) {
     var distance = this.CalcSquareLength(paneCrosshairInfo.x, paneCrosshairInfo.y, pointsInfo[i].x, pointsInfo[i].y);
     if (distance < min) {
      min = distance;
      index = i;
     }
    }
    if (crosshairDrawInfo.CrosshairElements[index].visible) {
     var seriesLabelElement = crosshairDrawInfo.CrosshairElements[index].LabelElement;
     this.DrawCrosshairSeriesLabel(crosshairDrawInfo.pane, crosshairDrawInfo.labelsBounds, pointsInfo, pointsInfo[index], seriesLabelElement, true);
    }
    break;
  }
 },
 DrawCommonSeriesPointLabel: function(crosshairElementGroups, paneCrosshairInfoList) {
  var crosshairOptions = this.chart.chart.crosshairOptions;
  var content = this.GetCommonSeriesLabelContent(crosshairElementGroups);
  if (!ASPx.IsExists(content))
   return;
  var chartImage = this.chart.GetChartElement();
  var chartX = ASPx.GetAbsoluteX(chartImage);
  var chartY = ASPx.GetAbsoluteY(chartImage);
  var labelDiv = this.GetLabelDiv(this.labelIndex);
  labelDiv.innerHTML = content;
  if (ASPx.IsExists(crosshairOptions.crosshairLabelBackColor))
   labelDiv.style.backgroundColor = crosshairOptions.crosshairLabelBackColor;
  if (crosshairOptions.crosshairLabelPosition instanceof ASPxClientCrosshairFreePosition) {
   __aspxShowInFreePosition(labelDiv, this.chart.chart, crosshairOptions.crosshairLabelPosition, chartX, chartY);
  }
  else {
   var paneCrosshairInfo;
   for (var i = 0; i < paneCrosshairInfoList.length; i++) {
    if (paneCrosshairInfoList[i].pane == this.focusedPane) {
     paneCrosshairInfo = paneCrosshairInfoList[i];
     break;
    }
   }
   var offsetX = crosshairOptions.crosshairLabelPosition.offsetX;
   var offsetY = crosshairOptions.crosshairLabelPosition.offsetY;
   var x = paneCrosshairInfo.x + offsetX;
   var chartWidth = this.chart.GetMainElement().scrollWidth;
   if (x + labelDiv.offsetWidth > chartWidth) {
    x -= labelDiv.offsetWidth + 2 * offsetX;
   }
   var y = paneCrosshairInfo.y - labelDiv.offsetHeight - offsetY;
   if (y < 0) {
    y += labelDiv.offsetHeight + 2 * offsetY;
   }
   __aspxChartSetDivPosition(labelDiv, chartX + x, chartY + y);
  }
  this.labelIndex++;
 },
 GetCommonSeriesLabelContent: function (crosshairElementGroups) {
  var content = "";
  for (var j = 0; j < crosshairElementGroups.length; j++) {
   var group = crosshairElementGroups[j];
   var groupHeaderElement = group.HeaderElement;
   if (groupHeaderElement != null && groupHeaderElement.text != "" && groupHeaderElement.visible)
    content += this.GetGroupHeaderContent(groupHeaderElement);
   for (var pointIndex = 0; pointIndex < group.CrosshairElements.length; pointIndex++) {
    content += this.GetSingleLabelContent(group.CrosshairElements[pointIndex]);
   }
  }
  return content != "" ? "<table>" + content + "</table>" : null;
 },
 GetSingleLabelContent: function (crosshairElement) {
  var content = "";
  var seriesLabelElement = crosshairElement.LabelElement;
  if (!crosshairElement.visible || !seriesLabelElement.visible)
   return "";
  var style = this.CreateTextSettingsStyle(seriesLabelElement);
  if (seriesLabelElement.headerText != "")
   content += "<tr><td colspan='2' " + style + ">" + seriesLabelElement.headerText + "</td></tr>"
  if (seriesLabelElement.markerVisible) {
   var markerStyle;
   if (seriesLabelElement.marker != seriesLabelElement.defaultMarker)
    markerStyle = seriesLabelElement.marker;
   else
    markerStyle = "<div style='width:19px; height:14px; text-align:center'><div style='width:15px; height:12px; margin-top:5px; background-color:" + seriesLabelElement.markerColor + "'/></div>"
   content += "<tr><td style='vertical-align:top'>" + markerStyle + "</td>";
  }
  else
   content += "<tr><td></td>";
  if (seriesLabelElement.textVisible)
   content += "<td " + style + ">" + seriesLabelElement.text + "</td></tr>";
  else
   content += "<td></td></tr>";
  if (seriesLabelElement.footerText != "")
   content += "<tr><td colspan='2' " + style + ">" + seriesLabelElement.footerText + "</td></tr>";
  return content;
 },
 GetGroupHeaderContent: function (crosshairGroupHeaderElement) {
  var style = this.CreateTextSettingsStyle(crosshairGroupHeaderElement);
  return "<tr><td colspan='2' " + style + ">" + crosshairGroupHeaderElement.text + "</td></tr>"
 },
 PointBelongsToGroup: function (point, group, snapsToArgument) {
  if (snapsToArgument)
   return point.argument.toString() == group.anchorValue.toString();
  else
   return point.values.length > 1 ? false : point.values[0].toString() == group.anchorValue.toString();
 },
 HasIntersection: function (v1, l1, v2, l2) {
  v1 -= this.indent;
  l1 += 2 * this.indent;
  var v12 = v1 + l1;
  var v22 = v2 + l2;
  return !(v1 <= v2 && v1 <= v22 && v12 <= v2 && v12 <= v22 || v1 >= v2 && v1 >= v22 && v12 >= v2 && v12 >= v22);
 },
 CalcIntersectionArea: function (bounds1, bounds2) {
  var x1 = bounds1.x > bounds2.x ? bounds1.x : bounds2.x;
  var right1 = bounds1.x + bounds1.width;
  var right2 = bounds2.x + bounds2.width;
  var x2 = right1 < right2 ? right1 : right2;
  var y1 = bounds1.y > bounds2.y ? bounds1.y : bounds2.y;
  var bottom1 = bounds1.y + bounds1.height;
  var bottom2 = bounds2.y + bounds2.height;
  var y2 = bottom1 < bottom2 ? bottom1 : bottom2;
  var width = x2 - x1;
  var height = y2 - y1;
  return width * height;
 },
 CheckWithLabelIntersection: function (labelsBounds, bounds) {
  var intersectionAreas = [];
  for (var i = 0; i < labelsBounds.length; i++) {
   var hasXIntersection = this.HasIntersection(bounds.x, bounds.width, labelsBounds[i].x, labelsBounds[i].width);
   var hasYIntersection = this.HasIntersection(bounds.y, bounds.height, labelsBounds[i].y, labelsBounds[i].height);
   if (hasXIntersection && hasYIntersection) {
    intersectionAreas.push(this.CalcIntersectionArea(bounds, labelsBounds[i]));
   }
   else {
    intersectionAreas.push(0);
   }
  }
  var sum = 0;
  for (var i = 0; i < intersectionAreas.length; i++) {
   sum += intersectionAreas[i];
  }
  return sum;
 },
 CheckWithPointIntersection: function (pane, bounds, pointsInfo) {
  for (var i = 0; i < pointsInfo.length; i++) {
   var x = pointsInfo[i].x - pane.boundsLeft;
   var y = pointsInfo[i].y - pane.boundsTop;
   if (x > bounds.x && x < bounds.x + bounds.width && y > bounds.y && y < bounds.y + bounds.height) {
    return false;
   }
  }
  return true;
 },
 SetDirection: function (bounds, x, y, dirX, dirY) {
  bounds.x = x;
  bounds.x += dirX > 0 ? -crosshairHBeakCorrection : crosshairHBeakCorrection - bounds.width;
  bounds.y = y;
  bounds.y += dirY > 0 ? crosshairVBeakCorrection : -crosshairVBeakCorrection - bounds.height;
 },
 CheckCrosshairSeriesLabelDirection: function (direction, x, y, labelDiv) {
  if ((y - crosshairVBeakCorrection - labelDiv.offsetHeight) < 0)
   direction = { x: direction.x, y: -direction.y };
  if ((x - crosshairHBeakCorrection + labelDiv.offsetWidth) > this.chart.GetWidth())
   direction = { x: -direction.x, y: direction.y };
  return direction;
 },
 CorrectCrosshairSeriesLabelBounds: function (labelsBounds, pane, bounds, pointsInfo, x, y, dirX, dirY) {
  var directions = [];
  directions.push({ x: dirX, y: dirY });
  directions.push({ x: dirX, y: -dirY });
  directions.push({ x: -dirX, y: dirY });
  directions.push({ x: -dirX, y: -dirY });
  var intersections = [];
  for (var i = 0; i < directions.length; i++) {
   this.SetDirection(bounds, x, y, directions[i].x, directions[i].y);
   var intersection = this.CheckWithLabelIntersection(labelsBounds, bounds);
   if (intersection == 0 && this.CheckWithPointIntersection(pane, bounds, pointsInfo)) {
    return directions[i];
   }
   else {
    intersections.push(intersection);
   }
  }
  var min = intersections[0];
  var index = 0;
  for (var i = 1; i < intersections.length; i++) {
   if (intersections[i] < min) {
    min = intersections[i];
    index = i;
   }
  }
  this.SetDirection(bounds, x, y, directions[index].x, directions[index].y);
  return directions[index];
 },
 ExtractGroups: function (crosshairDrawInfoList) {
  var options = this.chart.chart.crosshairOptions;
  var snapsToArgument = options.snapMode == "NearestArgument";
  var totalCrosshairElements = [];
  for (var i = 0; i < crosshairDrawInfoList.length; i++)
   for (var j = 0; j < crosshairDrawInfoList[i].CrosshairElements.length; j++)
    totalCrosshairElements.push(crosshairDrawInfoList[i].CrosshairElements[j]);
  var groups = [];
  for (var elementIndex = 0; elementIndex < totalCrosshairElements.length; elementIndex++) {
   var crosshairElement = totalCrosshairElements[elementIndex];
   var point = crosshairElement.Point.point;
   var isInGroup = false;
   if (options.showGroupHeaders) {
    for (var groupIndex = 0; groupIndex < groups.length; groupIndex++) {
     var group = groups[groupIndex];
     if (this.PointBelongsToGroup(point, group, snapsToArgument)) {
      isInGroup = true;
      group.crosshairElements.push(crosshairElement);
      break;
     }
    }
   }
   if (!isInGroup) {
    var group = new CrosshairElementsGroup(point, snapsToArgument);
    group.crosshairElements.push(crosshairElement);
    groups.push(group);
   }
  }
  var converter = new ASPx.CrosshairGroupHeaderValueToStringConverter(snapsToArgument, !snapsToArgument);
  var hasHeader = (groups.length != totalCrosshairElements.length || options.groupHeaderPattern != "") && options.showGroupHeaders;
  for (var groupIndex = 0; groupIndex < groups.length; groupIndex++) {
   var group = groups[groupIndex];
   var basePoint = group.crosshairElements[0].Point.point;
   group.headerText = hasHeader ? ASPx.ToolTipPatternHelper.GetPointToolTipTextByConverter(options.actualGroupHeaderPattern, basePoint, basePoint.series, converter) : "";
   var groupHeaderElement = options.showGroupHeaders ? new ASPxClientCrosshairGroupHeaderElement(group, options.groupHeaderTextOptions) : null;
   group.crosshairGroupHeaderElement = groupHeaderElement;
   for (var elementIndex = 0; elementIndex < group.crosshairElements.length; elementIndex++) {
    var crosshairElement = group.crosshairElements[elementIndex];
    var point = crosshairElement.Point.point;
    var pattern = hasHeader ? point.series.groupedElementsPattern : point.series.crosshairLabelPattern;
    var seriesLabelElement = crosshairElement.LabelElement;
    seriesLabelElement.text = ASPx.ToolTipPatternHelper.GetPointToolTipText(pattern, point, point.series);
    if (groupHeaderElement != null)
     groupHeaderElement.seriesPoints.push(crosshairElement.Point);
   }
  }
  return groups;
 },
 UpdateCrosshair: function (x, y, chartControl) {
  this.focusedPane = this.GetPane(x, y);
  if (this.focusedPane == null) {
   this.Hide();
   return;
  }
  var panes = [];
  if (!this.chart.chart.crosshairOptions.showOnlyInFocusedPane &&
   ((this.diagram.paneLayoutDirection == "Vertical" && this.isHorizontal) ||
   (this.diagram.paneLayoutDirection == "Horizontal" && !this.isHorizontal))) {
   panes.push(this.diagram.defaultPane);
   for (var i = 0; i < this.diagram.panes.length; i++) {
    panes.push(this.diagram.panes[i]);
   }
  }
  else {
   panes.push(this.focusedPane);
  }
  var paneCrosshairInfoList = [];
  var crosshairDrawInfoList = [];
  for (var i = 0; i < panes.length; i++) {
   if (!panes[i].visible)
    continue;
   var paneCrosshairInfo = this.CalculatePaneCrosshairInfo(panes[i], x, y)
   paneCrosshairInfoList.push(paneCrosshairInfo);
   crosshairDrawInfo = new ASPxClientCrosshairDrawInfo(this.chart);
   crosshairDrawInfo.AddPaneCrosshairInfo(paneCrosshairInfo, chartControl.chart.diagram.rotated);
   crosshairDrawInfo.pane = panes[i];
   crosshairDrawInfoList.push(crosshairDrawInfo);
  }
  var crosshairGroups = [];
  if (this.chart.chart.crosshairOptions.crosshairLabelMode == "ShowCommonForAllSeries")
   crosshairGroups = this.ExtractGroups(crosshairDrawInfoList);
  if (ASPx.IsExists(chartControl.RaiseCustomDrawCrosshair)) {
   var crosshairDrawInfo = new ASPxClientCrosshairDrawInfoList(crosshairDrawInfoList, crosshairGroups);
   chartControl.RaiseCustomDrawCrosshair(crosshairDrawInfo.CursorCrosshairAxisLabelElements, crosshairDrawInfo.CursorCrosshairLineElement, crosshairDrawInfo.CrosshairElementGroups);
  }
  this.hLineIndex = 0;
  this.hLabelIndex = 0;
  this.vLineIndex = 0;
  this.vLabelIndex = 0;
  this.labelIndex = 0;
  for (var i = 0; i < paneCrosshairInfoList.length; i++) {
   this.DrawCrosshairLineElements(crosshairDrawInfoList[i]);
   this.DrawCrosshairAxisLabelElements(crosshairDrawInfoList[i]);
   if (this.chart.chart.crosshairOptions.crosshairLabelMode != "ShowCommonForAllSeries") {
    this.DrawCrosshairSeriesLabels(crosshairDrawInfoList[i], paneCrosshairInfoList[i]);
   }
  }
  if (this.chart.chart.crosshairOptions.crosshairLabelMode == "ShowCommonForAllSeries") {
   this.DrawCommonSeriesPointLabel(crosshairDrawInfo.CrosshairElementGroups, paneCrosshairInfoList);
  }
  this.ClearDivs(this.hLineIndex, this.vLineIndex, this.hLabelIndex, this.vLabelIndex, this.labelIndex);
 }
});
var PaneCrosshairInfo = ASPx.CreateClass(null, {
 constructor: function(pane, x, y) {
  this.pane = pane;
  this.horizontalLines = [];
  this.verticalLines = [];
  this.horizontalLabels = [];
  this.verticalLabels = [];
  this.pointsInfo = [];
  this.labelsBounds = [];
  this.x = x;
  this.y = y;
  this.cursorLabel = [];
 },
 AddCursorCrosshairLine: function(axisValuePair, isHorizontal, isSingle) {
  this.cursorLine = this.GetCrosshairLine(axisValuePair, isHorizontal);
 },
 AddCursorCrosshairLabel: function(axisValuePair, isHorizontal) {
  this.cursorLabel.push({ axisValuePair: axisValuePair, isHorizontal: isHorizontal });
 },
 AddCrosshairLine: function(point, axisValuePair, isHorizontal, isSingle) {
  if (this.Contains(this.pointsInfo, point)) {
   point.crosshairLine = this.GetCrosshairLine(axisValuePair, isHorizontal);
  }
 },
 AddCrosshairLabel: function(point, axisValuePair, isHorizontal) {
  if (this.Contains(this.pointsInfo, point)) {
   point.crosshairLabel = { axisValuePair: axisValuePair, isHorizontal: isHorizontal };
  }
 },
 GetCrosshairLine: function(axisValuePair, isHorizontal) {
  return { axisValuePair: axisValuePair, isHorizontal: isHorizontal };
 },
 AddPoint: function(point) {
  if (!this.Contains(this.pointsInfo, point)) {
   this.pointsInfo.push(point);
  }
 },
 Contains: function(array, crosshairPoint) {
  for (var i = 0; i < array.length; i++) {
   if (array[i].axisValue.axis == crosshairPoint.axisValue.axis && array[i].axisValue.internalValue == crosshairPoint.axisValue.internalValue
    && array[i].point.series.name == crosshairPoint.point.series.name) {
    return true;
   }
  }
  return false;
 }
});
var AxisValuePair = ASPx.CreateClass(null, {
 constructor: function(axis, internalValue, screenValue) {
  this.axis = axis;
  this.internalValue = internalValue;
  this.screenValue = screenValue;
 }
});
ASPx.ChartGetHorizontalTable = __aspxChartGetHorizontalTable;
ASPx.GetChartDivId = __aspxGetChartDivId;
ASPx.CreateChartToolTip = __aspxCreateChartToolTip;
ASPx.RemoveChartDiv = __aspxRemoveChartDiv;
ASPx.ChartSetDivPosition = __aspxChartSetDivPosition;
ASPx.ShowInFreePosition = __aspxShowInFreePosition;
ASPx.CrosshairRenderer = CrosshairRenderer;
ASPx.AxisValuePair = AxisValuePair;
})();
(function() {
var _argumentPattern = "A";
var _valuePattern = "V";
var _seriesNamePattern = "S";
var _stackedGroupPattern = "G";
var _value1Pattern = "V1";
var _value2Pattern = "V2";
var _valueDurationPattern = "VD";
var _valueDurationTotalDaysPattern = "VDTD";
var _valueDurationTotalHoursPattern = "VDTH";
var _valueDurationTotalMinutesPattern = "VDTM";
var _valueDurationTotalSecondsPattern = "VDTS";
var _valueDurationTotalMillisecondsPattern = "VDTMS";
var _weightPattern = "W";
var _highValuePattern = "HV";
var _lowValuePattern = "LV";
var _openValuePattern = "OV";
var _closeValuePattern = "CV";
var _percentValuePattern = "VP";
var _pointHintPattern = "HINT";
var _totalValuePattern = "TV";
var PointDataToStringConverter = ASPx.CreateClass(null, {
 constructor: function () {
  this.allowArgument = ASPx.IsExists(this.allowArgument) ? this.allowArgument : true;
  this.allowValue = ASPx.IsExists(this.allowValue) ? this.allowValue : true;
 },
 GetHintText: function (seriesPoint) {
  return seriesPoint.toolTipHint != null ? seriesPoint.toolTipHint : "";
 },
 FormatValue: function(format, value) {
  return ASPx.Formatter.Format("{0:" + format + "}", value);
 },
 GetArgumentText: function (seriesPoint, series, format) {
  if (seriesPoint.argument == null)
   return "";
  if (series.argumentScaleType == ASPxClientScaleType.Qualitative)
   return seriesPoint.argument;
  else {
   if (series.argumentScaleType == ASPxClientScaleType.DateTime && format == "q") {
    var monthNum = Math.floor(seriesPoint.argument.getMonth() / 3) + 1;
    return "Q" + monthNum + " " + seriesPoint.argument.getFullYear();
   }
   else
    return this.FormatValue(format, [seriesPoint.argument]);
  }
 },
 GetValueTextByIndex: function(valueIndex, seriesPoint, format) {
  var formattedValue = this.FormatValue(format, seriesPoint.values[valueIndex]);
  return valueIndex >= seriesPoint.values.length ? "" : formattedValue;
 }
});
var ValueToStringConverter = ASPx.CreateClass(PointDataToStringConverter, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetValueText: function(seriesPoint, format) {
  return this.GetValueTextByIndex(0, seriesPoint, format);
 }
});
var RangeValueToStringConverter = ASPx.CreateClass(PointDataToStringConverter, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetValue1Text: function(seriesPoint, format) {
  return this.GetValueTextByIndex(0, seriesPoint, format);
 },
 GetValue2Text: function(seriesPoint, format) {
  return this.GetValueTextByIndex(1, seriesPoint, format);
 },
 GetValueDurationText: function(seriesPoint, series, format) {
  if (seriesPoint.values.length < 2)
   return '';
  var valueDuration = Math.abs(seriesPoint.values[1] - seriesPoint.values[0]);
  return this.FormatValue(format, valueDuration); 
 }
});
var RangeDateTimeValueToStringConverter = ASPx.CreateClass(RangeValueToStringConverter, {
 GetTimeSpanValueDuration: function(seriesPoint) {
  var valueDuration = Math.abs(seriesPoint.values[1] - seriesPoint.values[0]);
  return new ASPx.TimeSpan(valueDuration);
 },
 GetValueDurationText: function(seriesPoint, series, format) {
  if (seriesPoint.values.length < 2)
   return '';
  var timeSpan = this.GetTimeSpanValueDuration(seriesPoint);
  return timeSpan.format(format);
 },
 GetTotalDaysValueDurationText: function(seriesPoint, format) {
  var timeSpan = this.GetTimeSpanValueDuration(seriesPoint);
  return this.FormatValue(format, timeSpan.totalDays);
 },
 GetTotalHoursValueDurationText: function(seriesPoint, format) {
  var timeSpan = this.GetTimeSpanValueDuration(seriesPoint);
  return this.FormatValue(format, timeSpan.totalHours);
 },
 GetTotalMinutesValueDurationText: function(seriesPoint, format) {
  var timeSpan = this.GetTimeSpanValueDuration(seriesPoint);
  return this.FormatValue(format, timeSpan.totalMinutes);
 },
 GetTotalSecondsValueDurationText: function(seriesPoint, format) {
  var timeSpan = this.GetTimeSpanValueDuration(seriesPoint);
  return this.FormatValue(format, timeSpan.totalSeconds);
 },
 GetTotalMillisecondsValueDurationText: function(seriesPoint, format) {
  var timeSpan = this.GetTimeSpanValueDuration(seriesPoint);
  return this.FormatValue(format, timeSpan.totalMilliseconds);
 },
});
var BubbleValueToStringConverter = ASPx.CreateClass(ValueToStringConverter, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetWeightText: function(seriesPoint, format) {
  return this.GetValueTextByIndex(1, seriesPoint, format);
 }
});
var FinancialValueToStringConverter = ASPx.CreateClass(PointDataToStringConverter, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetLowValueText: function(seriesPoint, format) {
  return this.GetValueTextByIndex(0, seriesPoint, format);
 },
 GetHighValueText: function(seriesPoint, format) {
  return this.GetValueTextByIndex(1, seriesPoint, format);
 },
 GetOpenValueText: function(seriesPoint, format) {
  return this.GetValueTextByIndex(2, seriesPoint, format);
 },
 GetCloseValueText: function(seriesPoint, format) {
  return this.GetValueTextByIndex(3, seriesPoint, format);
 }
});
var TotalValueToStringConverter = ASPx.CreateClass(ValueToStringConverter, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetTotalValueText: function(seriesPoint, format) {
  if (ASPx.IsExists(seriesPoint.totalValue))
   return this.FormatValue(format, seriesPoint.totalValue);
  return format;
 }
});
var PercentValueToStringConverter = ASPx.CreateClass(TotalValueToStringConverter, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetPercentValueText: function(seriesPoint, format) {
  if (seriesPoint.percentValue == null)
   return format;
  return this.FormatValue(format, seriesPoint.percentValue);
 }
});
var CrosshairGroupHeaderValueToStringConverter = ASPx.CreateClass(ValueToStringConverter, {
 constructor: function(allowArgument, allowValue) {
  this.allowValue = allowValue;
  this.allowArgument = allowArgument;
  this.constructor.prototype.constructor.call(this);
 }
});
var ToolTipPatternHelper = {
 ReplacePatternToValue: function(fragment, series, seriesPoint, converter) {
  var preparedFragment = this.PrepareFragment(fragment);
  if (preparedFragment == null)
   return fragment;
  var format = preparedFragment[0];
  var pattern = preparedFragment[1];
  var allowAllPatterns = converter != null ? (converter.allowArgument && converter.allowValue) : true;
  switch (pattern) {
   case _seriesNamePattern:
    return allowAllPatterns ? series.name : fragment;
   case _stackedGroupPattern:
    return series.stackedGroup != null && allowAllPatterns ? series.stackedGroup : fragment;
  }
  if (seriesPoint != null) {
   switch (pattern) {
    case _argumentPattern:
     return converter.allowArgument ? converter.GetArgumentText(seriesPoint, series, format) : fragment;
    case _valuePattern:
     return (converter instanceof ValueToStringConverter) && converter.allowValue ? converter.GetValueText(seriesPoint, format) : fragment;
    case _value1Pattern:
     return (converter instanceof RangeValueToStringConverter) && allowAllPatterns ? converter.GetValue1Text(seriesPoint, format) : fragment;
    case _value2Pattern:
     return (converter instanceof RangeValueToStringConverter) && allowAllPatterns ? converter.GetValue2Text(seriesPoint, format) : fragment;
    case _valueDurationPattern:
     return (converter instanceof RangeValueToStringConverter) && allowAllPatterns ? converter.GetValueDurationText(seriesPoint, series, format) : fragment;
    case _valueDurationTotalDaysPattern:
     return (converter instanceof RangeDateTimeValueToStringConverter) && allowAllPatterns ? converter.GetTotalDaysValueDurationText(seriesPoint, format) : fragment;
    case _valueDurationTotalHoursPattern:
     return (converter instanceof RangeDateTimeValueToStringConverter) && allowAllPatterns ? converter.GetTotalHoursValueDurationText(seriesPoint, format) : fragment;
    case _valueDurationTotalMinutesPattern:
     return (converter instanceof RangeDateTimeValueToStringConverter) && allowAllPatterns ? converter.GetTotalMinutesValueDurationText(seriesPoint, format) : fragment;
    case _valueDurationTotalSecondsPattern:
     return (converter instanceof RangeDateTimeValueToStringConverter) && allowAllPatterns ? converter.GetTotalSecondsValueDurationText(seriesPoint, format) : fragment;
    case _valueDurationTotalMillisecondsPattern:
     return (converter instanceof RangeDateTimeValueToStringConverter) && allowAllPatterns ? converter.GetTotalMillisecondsValueDurationText(seriesPoint, format) : fragment;
    case _weightPattern:
     return (converter instanceof BubbleValueToStringConverter) && allowAllPatterns ? converter.GetWeightText(seriesPoint, format) : fragment;
    case _highValuePattern:
     return (converter instanceof FinancialValueToStringConverter) && allowAllPatterns ? converter.GetHighValueText(seriesPoint, format) : fragment;
    case _lowValuePattern:
     return (converter instanceof FinancialValueToStringConverter) && allowAllPatterns ? converter.GetLowValueText(seriesPoint, format) : fragment;
    case _openValuePattern:
     return (converter instanceof FinancialValueToStringConverter) && allowAllPatterns ? converter.GetOpenValueText(seriesPoint, format) : fragment;
    case _closeValuePattern:
     return (converter instanceof FinancialValueToStringConverter) && allowAllPatterns ? converter.GetCloseValueText(seriesPoint, format) : fragment;
    case _percentValuePattern:
     return (converter instanceof PercentValueToStringConverter) && allowAllPatterns ? converter.GetPercentValueText(seriesPoint, format) : fragment;
    case _totalValuePattern:
     return (converter instanceof TotalValueToStringConverter) && allowAllPatterns ? converter.GetTotalValueText(seriesPoint, format) : fragment;
    case _pointHintPattern:
     return allowAllPatterns ? converter.GetHintText(seriesPoint) : fragment;
   }
  }
  return fragment;
 },
 PrepareFragment: function(fragment) {
  var pattern = "";
  var format = "";
  if (!(fragment.charAt(0) == "{" && fragment.charAt(fragment.length - 1) == "}"))
   return null;
  pattern = fragment.substring(1, fragment.length - 1);
  var formatIndex = pattern.indexOf(":");
  if (formatIndex >= 0) {
   format = pattern.substring(formatIndex + 1).replace(/^\s*/, "").replace(/\s*$/, "");
   pattern = pattern.substring(0, formatIndex);
  }
  pattern = pattern.replace(/^\s*/, "").replace(/\s*$/, "").toUpperCase();
  return [format, pattern];
 },
 SplitString: function(splitingString, leftSeparator, rightSeparator) {
  var substrings = [];
  var leftStringIndex = 0;
  var rightStringIndex = 0;
  var currentIndex = 0;
  if (splitingString != null && splitingString != "") {
   for (var i = 0; i < splitingString.length; i++) {
    var charElement = splitingString.charAt(i);
    if (charElement == leftSeparator) {
     leftStringIndex = currentIndex;
    }
    else {
     if (charElement == rightSeparator) {
      rightStringIndex = currentIndex;
      substrings.push(splitingString.substring(leftStringIndex, rightStringIndex + 1));
     }
    }
    currentIndex++;
   }
   return substrings;
  }
  else
   return null;
 },
 GetPointToolTipText: function(seriesPointPattern, seriesPoint, series) {
  return this.GetPointToolTipTextByConverter(seriesPointPattern, seriesPoint, series, this.GetPatternConverter(series));
 },
 GetPointToolTipTextByConverter: function(seriesPointPattern, seriesPoint, series, converter) {
  if (converter == null)
   return "";
  parsedPattern = this.SplitString(seriesPointPattern, "{", "}");
  var result = seriesPointPattern;
  if (parsedPattern != null)
   for (var i = 0; i < parsedPattern.length; i++) {
    var fragment = parsedPattern[i];
    var formattedFragment = this.ReplacePatternToValue(fragment, series, seriesPoint, converter);
    result = result.replace(fragment, formattedFragment);
   }
  return result;
 },
 GetSeriesToolTipText: function(seriesPattern, series) {
  if (seriesPattern == null || seriesPattern == "")
   return "";
  parsedPattern = this.SplitString(seriesPattern, "{", "}");
  var result = seriesPattern;
  if (parsedPattern != null)
   for (var i = 0; i < parsedPattern.length; i++) {
    var fragment = parsedPattern[i];
    result = result.replace(fragment, this.ReplacePatternToValue(fragment, series, null, null));
   }
  return result;
 },
 GetPatternConverter: function(series) {
  var viewType = series.viewType;
  if (viewType == "Pie" || viewType == "Funnel" || viewType == "Doughnut" || viewType == "NestedDoughnut")
   return new PercentValueToStringConverter();
  if (viewType == "FullStackedArea" || viewType == "FullStackedBar" || viewType == "SideBySideFullStackedBar" || viewType == "FullStackedLine" || viewType == "FullStackedSplineArea" || viewType == "FullStackedStepArea")
   return new PercentValueToStringConverter();
  if (viewType == "StackedArea" || viewType == "StackedBar" || viewType == "SideBySideStackedBar" || viewType == "StackedLine" || viewType == "StackedSplineArea" || viewType == "StackedStepArea")
   return new TotalValueToStringConverter();
  if (viewType == "CandleStick" || viewType == "Stock")
   return new FinancialValueToStringConverter();
  if (viewType == "Bubble")
   return new BubbleValueToStringConverter();
  if (viewType == "RangeArea" || viewType == "RangeBar" || viewType == "SideBySideRangeBar" || viewType == "SideBySideRangeBar" || viewType == "Gantt" || viewType == "SideBySideGantt") {
   if (series.valueScaleType == ASPxClientScaleType.DateTime)
    return new RangeDateTimeValueToStringConverter();
   else
    return new RangeValueToStringConverter();
  }
  if (viewType.indexOf("3D") >= 0 || viewType.indexOf("Manhattan") >= 0)
   return null;
  return new ValueToStringConverter();
 },
 GetAxisLabelText: function(axis, isValueAxis, value) {
  parsedPattern = this.SplitString(axis.crosshairAxisLabelOptions.pattern, "{", "}");
  if (parsedPattern != null) {
   var result = axis.crosshairAxisLabelOptions.pattern;
   for (var i = 0; i < parsedPattern.length; i++) {
    var fragment = parsedPattern[i];
    var preparedFragment = this.PrepareFragment(fragment);
    if (preparedFragment == null)
     return fragment;
    var format = preparedFragment[0];
    var formattedFragment = fragment;
    var pattern = preparedFragment[1];
    if (pattern == _argumentPattern && !isValueAxis || isValueAxis && pattern == _valuePattern) {
     var isDateTime = axis.scale instanceof ASPxClientDateTimeMap;
     if (isDateTime || axis.scale instanceof ASPxClientNumericalMap) {
      formattedFragment = ASPx.Formatter.Format("{0:" + format + "}", [value]);
     }
     else {
      formattedFragment = value;
     }
    }
    result = result.replace(new RegExp(fragment, "g"), formattedFragment);
   }
   return result;
  }
  return value;
 }
};
var TimeSpan = ASPx.CreateClass(null, {
 constructor: function(mSecTotal) {
  this.constructor.prototype.constructor.call(this);
  var mSecPerSec = 1000;
  var mSecPerMin = 60 * mSecPerSec;
  var mSecPerHour = 60 * mSecPerMin;
  var mSecPerDay = 24 * mSecPerHour;
  this.totalDays = mSecTotal / mSecPerDay;
  this.days = Math.floor(this.totalDays);
  var mSecDays = this.days * mSecPerDay;
  this.totalHours = mSecTotal / mSecPerHour;
  this.hours = Math.floor((mSecTotal - mSecDays) / mSecPerHour);
  var mSecHours = this.hours * mSecPerHour;
  this.totalMinutes = mSecTotal / mSecPerMin;
  this.minutes = Math.floor((mSecTotal - mSecDays - mSecHours) / mSecPerMin);
  var mSecMinutes = this.minutes * mSecPerMin;
  this.totalSeconds = mSecTotal / mSecPerSec;
  this.seconds = Math.floor((mSecTotal - mSecDays - mSecHours - mSecMinutes) / mSecPerSec);
  var mSecSeconds = this.seconds * mSecPerSec;
  this.milliseconds = mSecTotal - mSecDays - mSecHours - mSecMinutes - mSecSeconds;
  this.totalMilliseconds = mSecTotal;
  this.allowedFormats = 'dhmsfF';
 },
 createTokenBySymbol: function(symbol) {
  if (this.allowedFormats.indexOf(symbol) >= 0)
   return new ValueToken();
  else if (symbol == '%')
   return new SingleValueToken();
  else if (symbol == '\'')
   return new CustomSequenceToken();
  else if (symbol == '\\')
   return new CustomSymbolToken();
  return null;
 },
 getFormattedValue: function(format) {
  var result = '';
  var symbolIndex = 0;
  var formatString = format.getFormatString();
  while (symbolIndex < formatString.length) {
   var symbol = formatString.charAt(symbolIndex);
   var token = this.createTokenBySymbol(symbol);
   var tokenResult = token != null ? token.replaceFragment(format, symbolIndex, this) : null;
   if (tokenResult == null)
    return this.totalMilliseconds;
   symbolIndex = tokenResult.index + 1;
   result += tokenResult.text;
  }
  return result;
 },
 createFormat: function(format) {
  if (format == 'g')
   return new TimeSpanGeneralShortFormat();
  else if (format == 'G')
   return new TimeSpanGeneralLongFormat();
  else if (format == 'c' || format == 'T' || format == 't' || format == '' || format == null)
   return new TimeSpanConstantFormat();
  else if (format.length > 1)
   return new TimeSpanCustomFormat(format);
  return null;
 },
 format: function(userFormat) {
  var format = this.createFormat(userFormat);
  if (format == null)
   return this.totalMilliseconds;
  return this.getFormattedValue(format);
 }
});
var Token = ASPx.CreateClass(null, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 GetSymbolSafe: function(source, index) {
  return (index < source.length) ? source.charAt(index) : null;
 }
});
var CustomSymbolToken = ASPx.CreateClass(Token, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 replaceFragment: function(format, startIndex, timeSpan) {
  var nextIndex = startIndex + 1;
  var symbol = this.GetSymbolSafe(format.getFormatString(), nextIndex);
  return (symbol != null) ? { index: nextIndex, text: symbol } : null;
 }
});
var CustomSequenceToken = ASPx.CreateClass(Token, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 replaceFragment: function(format, startIndex, timeSpan) {
  var index = startIndex;
  var formatString = format.getFormatString();
  var sequence = '';
  while (index < formatString.length) {
   index++;
   var symbol = this.GetSymbolSafe(formatString, index);
   if (symbol == '\'')
    break;
   else if (symbol == null) {
    sequence = null;
    break;
   }
   else
    sequence += symbol;
  }
  return (sequence != null) ? { index: index, text: sequence } : null;
 }
});
var ValueToken = ASPx.CreateClass(Token, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 getTextByToken: function(token, format, formatString, timeSpan) {
  switch (token) {
   case 'd':
    return format.formatDays(timeSpan, formatString);
   case 'h':
    return format.formatValue(timeSpan.hours, formatString);
   case 'm':
    return format.formatValue(timeSpan.minutes, formatString);
   case 's':
    return format.formatValue(timeSpan.seconds, formatString);
   case 'f':
   case 'F':
    return format.formatMilliseconds(timeSpan, formatString);
   default:
    return timeSpan.totalMilliseconds;
  };
 },
 getMaxFormatLengthByToken: function(token) {
  switch (token) {
   case 'd':
    return 8;
   case 'h':
   case 'm':
   case 's':
    return 2;
   case 'f':
   case 'F':
    return 7;
   default:
    return 0;
  };
 },
 createNumericFormatString: function(symbolsCount, symbol) {
  var formatSymbol = (symbol == 'F') ? '#' : '0';
  return this.createFormat(symbolsCount, formatSymbol);
 },
 createFormat: function(symbolsCount, symbol) {
  var result = '';
  for (var i = 0; i < symbolsCount; i++) {
   result += symbol;
  }
  return result;
 },
 readSequence: function(formatString, valueSymbol, startIndex) {
  var index = startIndex;
  var sequence = valueSymbol;
  while (index < formatString.length) {
   var nextIndex = index + 1;
   var symbol = this.GetSymbolSafe(formatString, nextIndex);
   if (symbol != valueSymbol)
    break;
   index = nextIndex;
   sequence += symbol;
  }
  return sequence;
 },
 replaceFragmentCore: function(format, startIndex, timeSpan) {
  var formatString = format.getFormatString();
  var valueSymbol = this.GetSymbolSafe(formatString, startIndex);
  if (valueSymbol == null)
   return null;
  var sequence = this.readSequence(formatString, valueSymbol, startIndex);
  if (sequence.length > this.getMaxFormatLengthByToken(valueSymbol))
   return null;
  var numericFormatString = this.createNumericFormatString(sequence.length, valueSymbol);
  var text = this.getTextByToken(valueSymbol, format, numericFormatString, timeSpan);
  return { index: startIndex + sequence.length - 1, text: text };
 },
 replaceFragment: function(format, startIndex, timeSpan) {
  return this.replaceFragmentCore(format, startIndex, timeSpan);
 }
});
var SingleValueToken = ASPx.CreateClass(ValueToken, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 replaceFragment: function(format, startIndex, timeSpan) {
  return this.replaceFragmentCore(format, startIndex + 1, timeSpan);
 }
});
var TimeSpanFormat = ASPx.CreateClass(null, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 formatMillisecondsCore: function(timeSpan, format) {
  var seconds = timeSpan.milliseconds / 1000.0;
  return ASPx.Formatter.Format('{0:#.' + format + '}', seconds);
 },
 formatValue: function(value, formatString) {
  return ASPx.Formatter.Format('{0:' + formatString + '}', value);
 }
});
var TimeSpanCustomFormat = ASPx.CreateClass(TimeSpanFormat, {
 constructor: function(format) {
  this.format = format;
  this.constructor.prototype.constructor.call(this);
 },
 formatMilliseconds: function(timeSpan, format) {
  var text = this.formatMillisecondsCore(timeSpan, format);
  return text.substring(1);
 },
 formatDays: function(timeSpan, format) {
  return this.formatValue(timeSpan.days, format);
 },
 getFormatString: function() {
  return this.format;
 }
});
var TimeSpanConstantFormat = ASPx.CreateClass(TimeSpanFormat, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 formatMilliseconds: function(timeSpan, format) {
  if (timeSpan.milliseconds == 0)
   return '';
  var text = this.formatMillisecondsCore(timeSpan, format);
  return '.' + text.substring(1);
 },
 formatDays: function(timeSpan, format) {
  if (timeSpan.days == 0)
   return '';
  return this.formatValue(timeSpan.days, format) + '.';
 },
 getFormatString: function() {
  return 'dhh\\:mm\\:ssfffffff';
 }
});
var TimeSpanGeneralShortFormat = ASPx.CreateClass(TimeSpanFormat, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 formatMilliseconds: function(timeSpan, format) {
  if (timeSpan.milliseconds == 0)
   return '';
  return this.formatMillisecondsCore(timeSpan, format);
 },
 formatDays: function(timeSpan, format) {
  if (timeSpan.days == 0)
   return '';
  return this.formatValue(timeSpan.days, format) + ':';
 },
 getFormatString: function() {
  return 'dh\\:mm\\:ssFFFFFFF';
 }
});
var TimeSpanGeneralLongFormat = ASPx.CreateClass(TimeSpanFormat, {
 constructor: function() {
  this.constructor.prototype.constructor.call(this);
 },
 formatMilliseconds: function(timeSpan, format) {
  return this.formatMillisecondsCore(timeSpan, format);
 },
 formatDays: function(timeSpan, format) {
  return this.formatValue(timeSpan.days, format);
 },
 getFormatString: function() {
  return 'd\\:hh\\:mm\\:ssfffffff';
 }
});
ASPx.TimeSpan = TimeSpan;
ASPx.CrosshairGroupHeaderValueToStringConverter = CrosshairGroupHeaderValueToStringConverter;
ASPx.ToolTipPatternHelper = ToolTipPatternHelper;
})();
(function() {
 var WebChartPrintHelperBase = ASPx.CreateClass(null, {
  constructor: function() {
   this.printFrame = null;
   this.exportFormID = 'DXChartExportForm';
  },
  createPrintContent: function(imageSource, imageWidth, imageHeight) {
   var printSettings = JSON.parse(imageSource);
   var pageBuilder = this.createPageBuilder();
   var usablePageWidth = printSettings.pageWidth;
   var usablePageHeight = printSettings.pageHeight;
   var pageWidth = usablePageWidth + printSettings.left + printSettings.right;
   var pageHeight = usablePageHeight + printSettings.top + printSettings.bottom;
   var pageParams = ['pageWidth', 'pageHeight', 'imageWidth', 'imageHeight', 'url'];
   var pageParamsValues = [pageWidth, pageHeight, imageWidth, imageHeight, printSettings.url];
   var tileParams = ['tileWidth', 'tileHeight', 'tileOffsetX', 'tileOffsetY', 'pageBreakAfter'];
   var pageMarginParams = ['leftMargin', 'topMargin', 'rightMargin', 'bottomMargin'];
   var pageMarginParamsValues = [printSettings.left, printSettings.top, printSettings.right, printSettings.bottom];
   var hTilesCount = Math.ceil(imageWidth / usablePageWidth);
   var vTilesCount = Math.ceil(imageHeight / usablePageHeight);
   var content = '<body>';
   content += pageBuilder.createPageStyle(printSettings);
   for (var vTileIndex = 0; vTileIndex < vTilesCount; vTileIndex++) {
    for (var hTileIndex = 0; hTileIndex < hTilesCount; hTileIndex++) {
     var hTileOffset = hTileIndex * usablePageWidth;
     var vTileOffset = vTileIndex * usablePageHeight;
     var tileWidth = Math.min(usablePageWidth, imageWidth - hTileOffset);
     var tileHeight = Math.min(usablePageHeight, imageHeight - vTileOffset);
     var isLastTile = (vTileIndex == vTilesCount - 1) && (hTileIndex == hTilesCount - 1);
     var isFirstTile = (vTileIndex == 0) && (hTileIndex == 0);
     var pageBreakAfter = isLastTile ? 'avoid' : 'always';
     var tileParamsValues = [tileWidth, tileHeight, -hTileOffset, -vTileOffset, pageBreakAfter];
     var pageHtml = isFirstTile ? pageBuilder.createFirstPagePattern() : pageBuilder.createPagePattern();
     pageHtml = pageBuilder.applyPattern(pageHtml, pageParams, pageParamsValues);
     pageHtml = pageBuilder.applyPattern(pageHtml, pageMarginParams, pageMarginParamsValues);
     pageHtml = pageBuilder.applyPattern(pageHtml, tileParams, tileParamsValues);
     content += pageHtml;
    }
   }
   content += '</body>';
   return content;
  },
  ensurePrintFrame: function() {
   if (this.frameElement != null && ASPx.Browser.IE) {
    this.frameElement.parentNode.removeChild(this.frameElement);
    this.frameElement = null;
   }
   if (this.frameElement == null)
    this.frameElement = this.createFrameElement("DXPrinter");
   this.printFrame = window.frames[this.frameElement.id];
  },
  createFrameElement: function(name) {
   var frame = document.createElement("iframe");
   frame.frameBorder = "0";
   frame.style.overflow = "hidden";
   var frameSize = ASPx.Browser.Safari ? "1px" : "0px";
   var position = ASPx.Browser.Safari ? "0px" : "-100px";
   frame.style.width = frameSize;
   frame.style.height = frameSize;
   frame.name = name;
   frame.id = name;
   frame.style.position = "absolute";
   frame.style.top = position;
   frame.style.left = position;
   if (ASPx.Browser.Safari)
    frame.style.opacity = 0;
   document.body.appendChild(frame);
   return frame;
  },
  getPrintFrame: function() {
   this.ensurePrintFrame();
   return this.printFrame;
  },
  createExportFormTag: function() {
   return '<form ID=\'' + this.exportFormID + '\' method=\'POST\'></form>';
  },
  createExportForm: function() {
   var container = document.createElement('div');
   container.style.overflow = 'hidden';
   container.style.width = '0px';
   container.style.height = '0px';
   container.innerHTML = this.createExportFormTag();
   document.body.appendChild(container);
   return document.getElementById(this.exportFormID);
  },
  exportTo: function(result) {
   if (ASPx.Browser.WebKitTouchUI) {
    var exportForm = document.getElementById(this.exportFormID);
    if (!exportForm)
     exportForm = this.createExportForm();
    if (exportForm) {
     exportForm.action = result;
     exportForm.submit();
    }
   }
   else {
    this.ensurePrintFrame();
    this.printFrame.location = result;
   }
  },
  print: function(result, imageWidth, imageHeight) {
   if (this.pdfExists())
    this.exportTo(result);
   else {
    this.ensurePrintElement();
    this.fillPrintElement(result, imageWidth, imageHeight);
    this.printCore();
   }
  },
  getPrintDocumentFormat: function() {
   if (this.pdfExists())
    return "pdf";
   else
    return "png";
  },
  pdfExists: function() {
   if (!ASPx.IsExists(this.pdf)) {
    this.pdf = this.existsIEPlugin() || this.existsFFPlugin() || ASPx.Browser.WebKitTouchUI;
   }
   return this.pdf;
  },
  existsIEPlugin: function() {
   return this.createActiveXObject("PDF.PdfCtrl.5")
    || this.createActiveXObject("PDF.PdfCtrl.6")
    || this.createActiveXObject("AcroPDF.PDF.1");
  },
  createActiveXObject: function(classid) {
   if (!Object.hasOwnProperty.call(window, "ActiveXObject")) {
    return null;
   }
   try {
    return new ActiveXObject(classid);
   } catch (ex) {
    return null;
   }
  },
  existsFFPlugin: function() {
   var plugins = navigator.mimeTypes["application/pdf"];
   var plugin = plugins && plugins.enabledPlugin;
   return plugin
    && (plugin.name === "Chrome PDF Viewer" || (plugin.description.indexOf("Adobe") !== -1)
     && (plugin.description.indexOf("Version") === -1 || parseFloat(plugin.description.split("Version")[1]) >= 6));
  }
 });
 var WebChartPrintHelper = ASPx.CreateClass(WebChartPrintHelperBase, {
  constructor: function() {
   this.constructor.prototype.constructor.call(this);
  },
  printCore: function() {
   if (ASPx.Browser.IE || ASPx.Browser.Edge || ASPx.Browser.Chrome)
    this.printIEChromeEdge();
   else {
    this.printFrame.focus();
    this.printFrame.print();
   }
  },
  createPageBuilder: function() {
   return ASPx.Browser.Safari ? new ASPx.SafariPrintPageHtmlBuilder() : new ASPx.PrintPageHtmlBuilder();
  },
  fillPrintElement: function(content, imageWidth, imageHeight) {
   var printDocument = this.printFrame.document;
   printDocument.open();
   var content = this.createPrintContent(content, imageWidth, imageHeight);
   printDocument.write(content);
   printDocument.close();
  },
  ensurePrintElement: function() {
   this.ensurePrintFrame();
  },
  printIEChromeEdge: function() {
   var printDocument = this.printFrame.document;
   ASPx.Evt.AttachEventToElement(printDocument, "readystatechange", function() {
    if (printDocument.readyState === "complete") {
     this.printFrame.focus();
     this.printFrame.document.execCommand('print', false, null);
    }
   }.aspxBind(this));
  }
 });
 var WebChartPrintHelperOpera = ASPx.CreateClass(WebChartPrintHelperBase, {
  constructor: function() {
   this.constructor.prototype.constructor.call(this);
   this.printElementName = "DXOperaPrinter";
   this.printElement = null;
  },
  printCore: function() {
   this.runAfterImagesLoaded(function() { self.print(); });
  },
  createPageBuilder: function() {
   return new ASPx.OperaPrintPageHtmlBuilder();
  },
  fillPrintElement: function(content, imageWidth, imageHeight) {
   this.printElement.innerHTML = this.createPrintContent(content, imageWidth, imageHeight);
  },
  ensurePrintElement: function() {
   if (!ASPx.IsExists(this.printElement)) {
    this.printElement = this.createDivElement(this.printElementName);
    this.ensurePrintStyleElement();
   }
  },
  ensurePrintStyleElement: function() {
   if (ASPx.GetElementById(this.printElementName + "Style")) {
    return;
   }
   var htmlElement = document.getElementsByTagName("HTML")[0];
   var elements = htmlElement.getElementsByTagName("HEAD");
   var headElement = (elements && elements.length > 0) ? elements[0] : htmlElement.appendChild(document.createElement("HEAD"));
   var styleElement = headElement.appendChild(document.createElement("STYLE"));
   styleElement.innerText = "@media print {div." + this.printElementName + " { display: block } body>* { display: none } } @media screen,projection {div." + this.printElementName + " { display: none }}";
   styleElement.id = this.printElementName + "Style";
  },
  createDivElement: function(name) {
   var d = document.createElement("div");
   d.name = name;
   d.id = name;
   d.className = name;
   document.body.appendChild(d);
   return d;
  },
  runAfterImagesLoaded: function(func) {
   var reqs = [];
   reqs.remove = function(req) {
    for (var i = 0; i < this.length; i++) {
     if (this[i] == req) {
      this.splice(i, 1);
     }
    }
   };
   var onReadyStateChangeHandler = function() {
    if (this.readyState === 4) {
     reqs.remove(this);
     if (reqs.length === 0) {
      func();
     }
    }
   };
   var runRequest = function() {
    var req = new XMLHttpRequest();
    req.open("GET", images[i].src, true);
    req.send(null);
    req.onreadystatechange = onReadyStateChangeHandler;
    return req;
   };
   var images = this.printElement.getElementsByTagName("IMG");
   for (var i = 0; i < images.length; i++) {
    if (!images[i].complete) {
     reqs.push(runRequest());
    }
   }
   if (reqs.length === 0) {
    func();
   }
  }
 });
 var PrintPageHtmlBuilder = ASPx.CreateClass(null, {
  createFirstPagePattern: function() {
   return this.createPagePattern();
  },
  createPagePattern: function() {
   var pattern = '';
   pattern += '<div style=\'width:{tileWidth}px;height:{tileHeight}px;page-break-after:{pageBreakAfter};page-break-inside:avoid;vertical-align:top;overflow:hidden;\'>';
   pattern += '<img style=\'width:{imageWidth}px;height:{imageHeight}px;margin-left:{tileOffsetX}px;margin-top:{tileOffsetY}px;vertical-align:top;\' src=\'{url}\' />';
   pattern += '</div>';
   return pattern;
  },
  createMarginsPattern: function() {
   return 'margin-left:{leftMargin}px; margin-top:{topMargin}px;margin-right:{rightMargin}px;margin-bottom:{bottomMargin}px;';
  },
  createPageStylePattern: function() {
   return '<style>@page { ' + this.createMarginsPattern() + ' }</style>';
  },
  applyPattern: function(pattern, params, values) {
   var result = pattern;
   for (var i = 0; i < params.length; i++) {
    var paramName = '{' + params[i] + '}';
    result = result.replace(paramName, values[i]);
   }
   return result;
  },
  createPageStyle: function(pageSettings) {
   var pattern = this.createPageStylePattern();
   return this.applyPattern(pattern, ['leftMargin', 'topMargin', 'rightMargin', 'bottomMargin'], [pageSettings.left, pageSettings.top, pageSettings.right, pageSettings.bottom]);
  }
 });
 var SafariPrintPageHtmlBuilder = ASPx.CreateClass(PrintPageHtmlBuilder, {
  createPagePattern: function() {
   var pattern = '';
   pattern += '<div style=\'width:{pageWidth}px;height:{pageHeight}px;page-break-after:{pageBreakAfter};page-break-inside:avoid;vertical-align:top;overflow:hidden\'>';
   pattern += '<div style=\'width:{tileWidth}px;height:{tileHeight}px;' + this.createMarginsPattern() + 'vertical-align:top;overflow:hidden;\'>';
   pattern += '<img style=\'width:{imageWidth}px;height:{imageHeight}px;margin-left:{tileOffsetX}px;margin-top:{tileOffsetY}px;vertical-align:top;\' src=\'{url}\' />';
   pattern += '</div>';
   pattern += '</div>';
   return pattern;
  },
  createPageStylePattern: function() {
   return '';
  }
 });
 var OperaPrintPageHtmlBuilder = ASPx.CreateClass(PrintPageHtmlBuilder, {
  createFirstPagePattern: function() {
   var pattern = '';
   pattern += '<div style=\'width:{tileWidth}px;height:{tileHeight}px;page-break-after:{pageBreakAfter};page-break-inside:avoid;vertical-align:top;overflow:hidden;\'>';
   pattern += '<div style="width:{imageWidth}px;height:{imageHeight}px;margin-left:{tileOffsetX}px;margin-top:{tileOffsetY}px;vertical-align:top;background-image: url(\'{url}\');">';
   pattern += '</div>';
   pattern += '</div>';
   return pattern;
  }
 });
 ASPx.WebChartPrintHelperBase = WebChartPrintHelperBase;
 ASPx.WebChartPrintHelper = WebChartPrintHelper;
 ASPx.WebChartPrintHelperOpera = WebChartPrintHelperOpera;
 ASPx.PrintPageHtmlBuilder = PrintPageHtmlBuilder;
 ASPx.SafariPrintPageHtmlBuilder = SafariPrintPageHtmlBuilder;
 ASPx.OperaPrintPageHtmlBuilder = OperaPrintPageHtmlBuilder;
})();
(function() {
var DateFormatter = ASPx.CreateClass(null, {
 constructor: function() {
  this.date = new Date(2000, 0, 1);
  this.mask = "";
  this.specifiers = {};     
  this.spPositions = [];    
  this.parserKeys = [];
  this.knownSpecifiers = ["d", "M", "y", "H", "h", "m", "s", "f", "F", "g", "t"];
  this.savedYear = -1;
  this.isYearParsed = false;
  this.parsedMonth = -1;
  this.replacers = {
   "d": this.ReplaceDay,
   "M": this.ReplaceMonth,
   "y": this.ReplaceYear,
   "H": this.ReplaceHours23,
   "h": this.ReplaceHours12,
   "m": this.ReplaceMinutes,
   "s": this.ReplaceSeconds,
   "F": this.ReplaceMsTrimmed,
   "f": this.ReplaceMs,
   "g": this.ReplaceEra,
   "t": this.ReplaceAmPm
  };
  this.parsers = {
   "d": this.ParseDay,
   "M": this.ParseMonth,
   "y": this.ParseYear,
   "H": this.ParseHours,
   "h": this.ParseHours,
   "m": this.ParseMinutes,
   "s": this.ParseSeconds,
   "F": this.ParseMs,
   "f": this.ParseMs,
   "g": this.ParseEra,
   "t": this.ParseAmPm
  };
 },
 Format: function(date) {
  this.date = date;
  var sp;
  var pos;
  var replacerKey;
  var result = this.mask;
  for(var i = 0; i < this.spPositions.length; i++) {
   pos = this.spPositions[i];
   sp = this.specifiers[pos];
   replacerKey = sp.substr(0, 1);
   if(this.replacers[replacerKey]) {
    result = result.substr(0, pos) + this.replacers[replacerKey].call(this, sp.length) + result.substr(pos + sp.length);
   }
  }
  return result;
 }, 
 Parse: function(str, rememberParserKeys) {
  var now = new Date();  
  this.savedYear = now.getFullYear();
  this.isYearParsed = false;
  this.parsedMonth = -1;
  this.date = new Date(2000, 0, now.getDate());    
  this.strToParse = str;
  this.catchNumbers(str);  
  var parserKey;
  var sp;
  var pos;
  var parseResult;
  var error = false;
  this.hasAmPm = false;
  for(var i = 0; i < this.spPositions.length; i++) {
   pos = this.spPositions[i];
   sp = this.specifiers[pos];
   parserKey = sp.substr(0, 1);
   if(this.parsers[parserKey]) {
    if(rememberParserKeys)
     this.parserKeys.push(parserKey);
    parseResult = this.parsers[parserKey].call(this, sp.length);
    if(!parseResult) {
     error = true;
     break;
    }
   }
  }
  if(error)
   return false;
  if(this.hasAmPm) {
   if(!this.fixHours())
    return false;
  }
  if(!this.isYearParsed)
   this.date.setYear(this.savedYear);
  if(this.parsedMonth < 0)
   this.parsedMonth = now.getMonth();   
  this.ApplyMonth();
  return this.date;  
 },
 ParseAndMergeWithDate: function(str, sourceDate) {
  this.parserKeys = [];
  var date = this.Parse(str, true);
  if(date && sourceDate)
   date = new Date(
        this.HasYear() ? date.getFullYear() : sourceDate.getFullYear(),
        this.HasMonth() ? date.getMonth() : sourceDate.getMonth(),
        this.HasDay() ? date.getDate() : sourceDate.getDate(),
        this.HasHours() ? date.getHours() : sourceDate.getHours(),
        this.HasMinutes() ? date.getMinutes() : sourceDate.getMinutes(),
        this.HasSeconds() ? date.getSeconds() : sourceDate.getSeconds(),
        this.HasMilliseconds() ? date.getMilliseconds() : sourceDate.getMilliseconds()
        );
  this.parserKeys = [];
  return date;
 },
 HasYear: function() { return this.HasParserKey("y"); },
 HasMonth: function() { return this.HasParserKey("M"); },
 HasDay: function() { return this.HasParserKey("d"); },
 HasHours: function() { return this.HasParserKey("h") || this.HasParserKey("H"); },
 HasMinutes: function() { return this.HasParserKey("m"); },
 HasSeconds: function() { return this.HasParserKey("s"); },
 HasMilliseconds: function() { return this.HasParserKey("f") || this.HasParserKey("F"); },
 HasParserKey: function(key) { return ASPx.Data.ArrayIndexOf(this.parserKeys, key) !== -1; },
 ApplyMonth: function() {
  var trial;
  var day = this.date.getDate();
  while(true) {
   trial = new Date();
   trial.setTime(this.date.getTime());   
   trial.setMonth(this.parsedMonth);
   if(trial.getMonth() == this.parsedMonth)
    break;
   --day;
   this.date.setDate(day);
  }
  ASPx.DateUtils.FixTimezoneGap(this.date, trial);
  this.date = trial;
 },
 SetFormatString: function(mask) {
  if(mask.length == 2 && mask.charAt(0) == "%")
   mask = mask.charAt(1);
  this.specifiers = {}; 
  this.spPositions = [];
  this.mask = "";
  var subt = 0;
  var pos = 0;
  var startPos = 0;
  var ch;
  var prevCh = "";
  var skip = false;
  var backslash = false;
  var sp = "";    
  var isDsFound = false;
  while(true) {
   ch = mask.charAt(pos);
   if(ch == "") {
    if(sp.length > 0) {
     var correctedStartPos = startPos;
     if(isDsFound && ASPx.CultureInfo.ds.length > 1)
      var correctedStartPos = startPos + ASPx.CultureInfo.ds.length - 1;
     this.RegisterSpecifier(correctedStartPos, sp);
    }
    break;
   }
   if(ch == "\\" && !backslash) {
    backslash = true;
    subt++;
   } else {
    if(!backslash && (ch == "'" || ch == '"')) {
     skip = !skip;
     subt++;
    } else {     
     if(!skip) {
      if(ch == "/") {
       ch = ASPx.CultureInfo.ds;       
       isDsFound = true;
      }
      else if(ch == ":")
       ch = ASPx.CultureInfo.ts;
      else if(this.IsKnownSpecifier(ch)) {
       if(prevCh.length == 0)
        prevCh = ch;
       if(ch == prevCh)
        sp += ch;
       else {
        if(sp.length > 0)
         this.RegisterSpecifier(startPos, sp);
        sp = ch;
        startPos = pos - subt;
       }
      }
     }     
     this.mask += ch;
    }      
    backslash = false;
   }            
   prevCh = ch;
   pos++;
  }
  this.spPositions.reverse();
 },
 RegisterSpecifier: function(pos, sp) {
  this.spPositions.push(pos);
  this.specifiers[pos] = sp; 
 },
 ReplaceDay: function(length) {
  if(length < 3) {
   var value = this.date.getDate().toString();
   return length == 2 ? this.padLeft(value, 2) : value;  
  } else if(length == 3) {
   return ASPx.CultureInfo.abbrDayNames[this.date.getDay()];
  } else {
   return ASPx.CultureInfo.dayNames[this.date.getDay()];
  }
 }, 
 ReplaceMonth: function(length) {
  var value = 1 + this.date.getMonth();
  switch(length) {
   case 1:
    return value.toString();
   case 2:
    return this.padLeft(value.toString(), 2);
   case 3:
    return ASPx.CultureInfo.abbrMonthNames[value - 1];
   default:
    for(var i in this.specifiers) {
     if(this.specifiers.hasOwnProperty(i)) {
      var spec = this.specifiers[i];
      if(spec == "d" || spec == "dd")
       return ASPx.CultureInfo.genMonthNames[value - 1];
     }
    }
    return ASPx.CultureInfo.monthNames[value - 1];
  }
 },
 ReplaceYear: function(length) {
  var value = this.date.getFullYear();
  if(length <= 2)
   value = value % 100;
  return this.padLeft(value.toString(), length);
 },
 ReplaceHours23: function(length) {
  var value = this.date.getHours().toString();
  return length > 1 ? this.padLeft(value, 2) : value;
 },
 ReplaceHours12: function(length) {
  var value = this.date.getHours() % 12;
  if(value == 0)
   value = 12;
  value = value.toString();
  return length > 1 ? this.padLeft(value, 2) : value;
 },
 ReplaceMinutes: function(length) {
  var value = this.date.getMinutes().toString();
  return length > 1 ? this.padLeft(value, 2) : value;
 },
 ReplaceSeconds: function(length) {
  var value = this.date.getSeconds().toString();
  return length > 1 ? this.padLeft(value, 2) : value;
 },
 ReplaceMsTrimmed: function(length) {   
  return this.formatMs(length, true);
 },
 ReplaceMs: function(length) { 
  return this.formatMs(length, false);
 },
 ReplaceEra: function(length) {
  return "A.D.";
 },
 ReplaceAmPm: function(length) {
  var value = this.date.getHours() < 12 ? ASPx.CultureInfo.am : ASPx.CultureInfo.pm;
  return length < 2 ? value.charAt(0) : value;
 },
 catchNumbers: function(str) {
  this.parseNumbers = [];  
  var regex = /\d+/g;  
  var match;
  for(;;) {
   match = regex.exec(str);
   if(!match)
    break;
   this.parseNumbers.push(this.parseDecInt(match[0]));
  }  
  var spCount = 0;
  var now = new Date();
  for(var i in this.specifiers) {
   if(this.specifiers.hasOwnProperty(i)) {
    var sp = this.specifiers[i];
    if (sp.constructor != String || !this.IsNumericSpecifier(sp)) continue;
    spCount++;
    if(this.parseNumbers.length < spCount) {
     var defaultValue = 0;
     if (sp.charAt(0) == "y") defaultValue = now.getFullYear();
     this.parseNumbers.push(defaultValue);
    }
   }
  }
  var excess = this.parseNumbers.length - spCount;
  if(excess > 0)
   this.parseNumbers.splice(spCount, excess);  
  this.currentParseNumber = this.parseNumbers.length - 1;
 },
 popParseNumber: function() {
  return this.parseNumbers[this.currentParseNumber--];
 },
 findAbbrMonth: function() {
  return this.findMonthCore(ASPx.CultureInfo.abbrMonthNames);
 },
 findFullMonth: function() {
  return this.findMonthCore(ASPx.CultureInfo.genMonthNames);
 }, 
 findMonthCore: function(monthNames) {
  var inputLower = this.strToParse.toLowerCase();
  for(var i = 0; i < monthNames.length; i++) {
   var monthName = monthNames[i].toLowerCase();
   if(monthName.length > 0 &&  inputLower.indexOf(monthName) > -1) {
    var empty = "";
    for(var j = 0; j < monthName.length; j++) empty += " ";
    this.strToParse = this.strToParse.replace(new RegExp(monthName, "gi"), empty);
    return 1 + parseInt(i);
   }
  }
  return false;
 },
 ParseDay: function(length) {
  if(length < 3) {
   var value = this.popParseNumber();
   if(value < 1 || value > 31)
    return false;
   this.date.setDate(value);
  }
  return true;
 },
 ParseMonth: function(length) {
  var value;
  switch(length){
   case 1:
   case 2:
    value = this.popParseNumber();
    break; 
   case 3:
    value = this.findAbbrMonth();
    break;
   default:
    value = this.findFullMonth();
    break;
  }
  if(value < 1 || value > 12)
   return false;
  this.parsedMonth = value - 1;
  return true;
 }, 
 ParseYear: function(length) {  
  var value = this.popParseNumber();
  if(value > 9999)
   return false;
  if(value < 100)
   value = ASPx.DateUtils.ExpandTwoDigitYear(value);
  this.date.setFullYear(value);
  this.isYearParsed = true;
  return true;
 },
 ParseHours: function(length) {
  var value = this.popParseNumber();
  if(value > 23)
   return false;
  this.date.setHours(value);
  return true;
 },
 ParseMinutes: function(length) {
  var value = this.parseMinSecCore();
  if(value == -1)
   return false;
  this.date.setMinutes(value);
  return true;
 },
 ParseSeconds: function(length) {
  var value = this.parseMinSecCore();
  if(value == -1)
   return false;
  this.date.setSeconds(value);
  return true;
 },
 ParseMs: function(length) {
  if(length > 3)
   length = 3;
  var thr = 1;
  for(var i = 0; i < length; i++)
   thr *= 10;
  thr -= 1;
  var value = this.popParseNumber();
  while(value > thr)
   value /= 10;
  this.date.setMilliseconds(Math.round(value));
  return true;
 },
 ParseEra: function(length) {
  return true;
 },
 ParseAmPm: function(length) {
  this.hasAmPm = ASPx.CultureInfo.am.length > 0 && ASPx.CultureInfo.pm.length > 0;
  return true;
 },
 parseDecInt: function(str) {
  return parseInt(str, 10);
 },
 padLeft: function(str, length) {
  while(str.length < length)
   str = "0" + str;
  return str;
 },
 formatMs: function(length, trim) {
  var value = Math.floor(this.date.getMilliseconds() * Math.pow(10, length - 3));
  value = this.padLeft(value.toString(), length);    
  if(trim) {
   var pos = value.length - 1;
   var req = false;
   while(value.charAt(pos) == "0") {
    req = true;
    pos--;
   }
   if(req)
    value = value.substring(0, pos + 1);   
  }
  return value;
 },
 parseMinSecCore: function() {
  var value = this.popParseNumber();
  return value > 59 ? -1 : value;
 },
 fixHours: function() {
  var state = this.getAmPmState(this.strToParse);
  if(!state) return true;
  var h = this.date.getHours();
  switch(state) {
   case "P":
    if(h > 12) return false;
    if(h < 12)
     this.date.setHours(12 + h);
    break;
   case "A":
    if(h == 12)
     this.date.setHours(0);
  }
  return true;
 },
 getAmPmState: function(str, skipCorrection) {
  var am = ASPx.CultureInfo.am.charAt(0).toLowerCase();
  var pm = ASPx.CultureInfo.pm.charAt(0).toLowerCase();
  var amMatches = new RegExp(am, "gi").exec(str);
  var pmMatches = new RegExp(pm, "gi").exec(str);
  var amCount = amMatches ? amMatches.length : 0;
  var pmCount = pmMatches ? pmMatches.length : 0;
  var hasAm = amCount > 0;
  var hasPm = pmCount > 0;
  if(hasAm ^ hasPm && amCount < 2 && pmCount < 2)
   return hasAm ? "A" : "P";
  if(!skipCorrection) {
   str = str.replace(new RegExp(this.getDayMonthNameReplacePattern(), "gi"), "");
   return this.getAmPmState(str, true);
  }
  return null;
 },
 getDayMonthNameReplacePattern: function() {
  if(!this.dayMonthNameReplacePattern)
   return this.createDayMonthNameReplacePattern();
  return this.dayMonthNameReplacePattern;
 },
 createDayMonthNameReplacePattern: function() {
  var parts = [ ] ;
  parts.push("(?:");
  parts.push(this.createReplacePattern(ASPx.CultureInfo.monthNames));
  parts.push(this.createReplacePattern(ASPx.CultureInfo.genMonthNames));
  parts.push(this.createReplacePattern(ASPx.CultureInfo.abbrMonthNames));
  parts.push(this.createReplacePattern(ASPx.CultureInfo.abbrDayNames));
  parts.push(this.createReplacePattern(ASPx.CultureInfo.dayNames));
  parts.push(")");
  return parts.join("");
 },
 createReplacePattern: function(names) {
  return names && names.length > 0 ? "\\b" + names.join("\\b|\\b") + "\\b" : "";
 },
 IsNumericSpecifier: function(sp) {
  var ch = sp.charAt(0);
  if(ch == "g" || ch == "t" || ((ch == "M" || ch == "d") && sp.length > 2))
   return false;
  return true;
 },
 IsKnownSpecifier: function(sp) {
  if(sp.length > 1)
   sp = sp.charAt(0);
  for(var i = 0; i < this.knownSpecifiers.length; i++) {
   if(this.knownSpecifiers[i] == sp)
    return true;
  }
  return false;
 }
});
DateFormatter.Create = function(format) {
 var instance = new DateFormatter();
 instance.SetFormatString(format);
 return instance;
};
DateFormatter.ExpandPredefinedFormat = function(format) {
 switch(format) {
  case "d":
   return ASPx.CultureInfo.shortDate;
  case "D":
   return ASPx.CultureInfo.longDate;
  case "t":
   return ASPx.CultureInfo.shortTime;
  case "T":
   return ASPx.CultureInfo.longTime;
  case "g":
   return ASPx.CultureInfo.shortDate + " " + ASPx.CultureInfo.shortTime;   
  case "f":
   return ASPx.CultureInfo.longDate + " " + ASPx.CultureInfo.shortTime;
  case "G":
   return ASPx.CultureInfo.shortDate + " " + ASPx.CultureInfo.longTime;
  case "F":
  case "U":
   return ASPx.CultureInfo.longDate + " " + ASPx.CultureInfo.longTime;   
  case "M":
  case "m":
   return ASPx.CultureInfo.monthDay;
  case "Y":
  case "y":
   return ASPx.CultureInfo.yearMonth;   
  case "O":
  case "o":
   return "yyyy'-'MM'-'dd'T'HH':'mm':'ss.fffffff";
  case "R":
  case "r":
   return "ddd, dd MMM yyyy HH':'mm':'ss 'GMT'";
  case "s":
   return "yyyy'-'MM'-'dd'T'HH':'mm':'ss";
  case "u":
    return "yyyy'-'MM'-'dd HH':'mm':'ss'Z'";
 }
 return format;
};
ASPx.DateFormatter = DateFormatter;
})();
(function() {
ASPx.Formatter = {
 Format: function() {
  if(arguments.length < 1) 
   return "";
  var format = arguments[0];
  if(format == null)
   return "";
  var args;
  if(arguments.length > 1 && arguments[1] != null && arguments[1].constructor == Array) {
   args = arguments[1];
  } else {
   args = [ ];
   for(var i = 1; i < arguments.length; i++)
    args.push(arguments[i]);
  }
  var bag = [ ];
  var pos = 0;
  var savedPos = 0;  
  while(pos < format.length) {
   var ch = format.charAt(pos);
   pos++;
   if(ch == '{') {
    bag.push(format.substr(savedPos, pos - savedPos - 1));    
    if(format.charAt(pos) == "{") {
     savedPos = pos;
     pos++;
     continue;
    }
    var spec = this.ParseSpec(format, pos);
    var pos = spec.pos;
    var arg = args[spec.index];
    var argString;
    if(arg == null) {
     argString = "";
    } else if(typeof arg == "number") {
     argString = ASPx.NumberFormatter.Format(spec.format, arg);
    } else if(arg.constructor == Date) {     
     if(spec.format != this.activeDateFormat) {
      this.activeDateFormat = spec.format;
      if(spec.format == "")
       spec.format = "G";      
      if(spec.format.length == 1)
       spec.format = ASPx.DateFormatter.ExpandPredefinedFormat(spec.format);
      this.GetDateFormatter().SetFormatString(spec.format);
     }
     if(this.activeDateFormat == "U")
      arg = ASPx.DateUtils.ToUtcTime(arg);
     argString = this.GetDateFormatter().Format(arg);
    } else {
     argString = String(arg);     
     if(spec.format != "" && argString.length > 0) {
      var num = Number(argString.replace(",", "."));
      if(!isNaN(num))
       argString = ASPx.NumberFormatter.Format(spec.format, num);
     }
    }
    var padLen = spec.width - argString.length;
    if(padLen > 0) {
     if(spec.left)
      bag.push(argString);
     for(var i = 0; i < padLen; i++)
      bag.push(" ");
     if(!spec.left)
      bag.push(argString);
    } else {
     bag.push(argString);
    }
    savedPos = pos;
   }
   else if(ch == "}" && pos < format.length && format.charAt(pos) == "}") {
    bag.push(format.substr(savedPos, pos - savedPos - 1));
    savedPos = pos;
    pos++;
   }
   else if (ch == "}") {
    return "";
   }
  }
  if(savedPos < format.length)
   bag.push(format.substr(savedPos));   
  return bag.join("");
 },
 ParseSpec: function(format, pos) {
  var result = {
   index: -1,   
   left: false,
   width: 0,
   format: "",
   pos: 0
  };
  var savedPos, ch;
  savedPos = pos;
  while(true) {   
   ch = format.charAt(pos);
   if(ch < "0" || ch > "9")
    break;
   pos++;
  }  
  if(pos > savedPos)
   result.index = Number(format.substr(savedPos, pos - savedPos));  
  if(format.charAt(pos) == ",") {
   pos++;
   while(true) {
    ch = format.charAt(pos);
    if(ch != " " && ch != "\t")
     break;
    pos++;
   }
   result.left = format.charAt(pos) == "-";
   if(result.left)
    pos++;   
   savedPos = pos;
   while(true) {
    ch = format.charAt(pos);
    if(ch < "0" || ch > "9")
     break;
    pos++;
   }
   if(pos > savedPos)
    result.width = Number(format.substr(savedPos, pos - savedPos));
  }
  if(format.charAt(pos) == ":") {
   pos++;
   savedPos = pos;
   while(format.charAt(pos) != "}")
    pos++;
   result.format = format.substr(savedPos, pos - savedPos);
  }
  pos++;
  result.pos = pos;
  return result;
 },
 activeDateFormat: null,
 GetDateFormatter: function() {
  if(!this.__dateFormatter)
   this.__dateFormatter = new ASPx.DateFormatter();
  return this.__dateFormatter;
 }
};
ASPx.NumberFormatter = {
 Format: function(format, value) {
  if(isNaN(value))
   return ASPx.CultureInfo.numNan;
  if(!isFinite(value)) {
   return value > 0 
    ? ASPx.CultureInfo.numPosInf 
    : ASPx.CultureInfo.numNegInf;
  }
  this.FillFormatInfo(format);
  if(this.spec == "X")
   return this.FormatHex(value);
  this.FillDigitInfo(value);  
  switch(this.spec) {
   case "C":
    return this.FormatCurrency();
   case "D":
    return this.FormatDecimal();
   case "E":
    return this.FormatExp();
   case "F":
    return this.FormatFixed();
   case "G":   
    return this.FormatGeneral();
   case "N":
    return this.FormatNumber();
   case "P":
    return this.FormatPercent();
   default:
    if(this.custom)
     return this.FormatCustom(format);
    return "?";
  }
 },
 positive: true,
 digits: null,
 pointPos: 0, 
 spec: "",
 prec: -1,  
 upper: true,
 custom: false,
 FormatCurrency: function() {  
  if(this.prec < 0)
   this.prec = ASPx.CultureInfo.currPrec;
  this.Round(this.prec);
  var bag = [ ];
  if(this.positive) {
   switch(ASPx.CultureInfo.currPosPattern) {
    case 0:
     bag.push(ASPx.CultureInfo.currency);
     break;
    case 2:
     bag.push(ASPx.CultureInfo.currency, " ");     
     break;     
   }
  } else {
   switch(ASPx.CultureInfo.currNegPattern) {
    case 0:
     bag.push("(", ASPx.CultureInfo.currency);
     break;
    case 1:
     bag.push("-", ASPx.CultureInfo.currency);
     break;
    case 2:
     bag.push(ASPx.CultureInfo.currency, "-");
     break;
    case 3:
     bag.push(ASPx.CultureInfo.currency);
     break;
    case 4:
     bag.push("(");
     break;
    case 5:
    case 8:
     bag.push("-");
     break;
    case 9:
     bag.push("-", ASPx.CultureInfo.currency, " ");
     break;
    case 11:
     bag.push(ASPx.CultureInfo.currency, " ");
     break;
    case 12:
     bag.push(ASPx.CultureInfo.currency, " -");
     break;
    case 14:
     bag.push("(", ASPx.CultureInfo.currency, " ");
     break;
    case 15:
     bag.push("(");
     break;
   }
  }
  this.AppendGroupedInteger(bag, ASPx.CultureInfo.currGroups, ASPx.CultureInfo.currGroupSeparator);
  if(this.prec > 0) {
   bag.push(ASPx.CultureInfo.currDecimalPoint);
   this.AppendDigits(bag, this.pointPos, this.pointPos + this.prec);
  }
  if(this.positive) {
   switch(ASPx.CultureInfo.currPosPattern) {
    case 1:
     bag.push(ASPx.CultureInfo.currency);
     break;
    case 3:
     bag.push(" ", ASPx.CultureInfo.currency);
     break;     
   }   
  } else {
   switch(ASPx.CultureInfo.currNegPattern) {
    case 0:
    case 14:
     bag.push(")");
     break;
    case 3:
     bag.push("-");
     break;
    case 4:
     bag.push(ASPx.CultureInfo.currency, ")");
     break;
    case 5:
     bag.push(ASPx.CultureInfo.currency);
     break;
    case 6:
     bag.push("-", ASPx.CultureInfo.currency);
     break;
    case 7:
     bag.push(ASPx.CultureInfo.currency, "-");
     break;
    case 8:
     bag.push(" ", ASPx.CultureInfo.currency);
     break;
    case 10:
     bag.push(" ", ASPx.CultureInfo.currency, "-");
     break;
    case 11:
     bag.push("-");
     break;
    case 13:
     bag.push("- ", ASPx.CultureInfo.currency);
     break;
    case 15:
     bag.push(" ", ASPx.CultureInfo.currency, ")");
     break;
   }
  }
  return bag.join("");
 }, 
 FormatDecimal: function() {
  if(this.prec < this.pointPos)
   this.prec = this.pointPos;
  if(this.prec < 1)
   return "0";
  var bag = [ ];
  if(!this.positive)
   bag.push("-");
  this.AppendDigits(bag, this.pointPos - this.prec, this.pointPos);
  return bag.join("");
 },
 FormatExp: function() {  
  if(this.prec < 0)
   this.prec = 6;
  this.Round(1 - this.pointPos + this.prec);
  return this.FormatExpCore(3);
 },
 FormatExpCore: function(minExpDigits) {
  var bag = [ ];
  if(!this.positive)
   bag.push("-");
  this.AppendDigits(bag, 0, 1);
  if(this.prec > 0) {
   bag.push(ASPx.CultureInfo.numDecimalPoint);
   this.AppendDigits(bag, 1, 1 + this.prec);
  }
  bag.push(this.upper ? "E" : "e");
  var order = this.pointPos - 1;  
  if(order >= 0) {
   bag.push("+");
  } else {
   bag.push("-");
   order = -order;
  }
  var orderStr = String(order);
  for(var i = orderStr.length; i < minExpDigits; i++)
   bag.push(0);
  bag.push(orderStr);
  return bag.join("");
 },
 FormatFixed: function() {
  if(this.prec < 0)
   this.prec = ASPx.CultureInfo.numPrec;
  this.Round(this.prec);
  var bag = [ ];
  if(!this.positive)
   bag.push("-");
  if(this.pointPos < 1)
   bag.push(0);
  else
   this.AppendDigits(bag, 0, this.pointPos);
  if(this.prec > 0) {
   bag.push(ASPx.CultureInfo.numDecimalPoint);
   this.AppendDigits(bag, this.pointPos, this.pointPos + this.prec);
  }
  return bag.join(""); 
 },
 FormatGeneral: function() {
  var hasFrac = this.pointPos < this.digits.length;
  var allowExp;
  if(this.prec < 0) {
   allowExp = hasFrac;
   this.prec = hasFrac ? 15 : 10;
  } else {   
   allowExp = true;
   if(this.prec < 1)
    this.prec = hasFrac ? 15 : 10;
   this.Round(this.prec - this.pointPos);
  }
  if(allowExp) {
   if(this.pointPos > this.prec || this.pointPos <= -4) {
    this.prec = this.digits.length - 1;
    return this.FormatExpCore(2);
   }
  }
  this.prec = Math.min(this.prec, Math.max(1, this.digits.length)) - this.pointPos;
  return this.FormatFixed();
 },
 FormatNumber: function() {
  if(this.prec < 0)
   this.prec = ASPx.CultureInfo.numPrec;
  this.Round(this.prec);
  var bag = [ ];
  if(!this.positive) {
   switch(ASPx.CultureInfo.numNegPattern) {
    case 0:
     bag.push("(");
     break;
    case 1:
     bag.push("-");
     break;
    case 2:
     bag.push("- ");
     break;
   }
  }
  this.AppendGroupedInteger(bag, ASPx.CultureInfo.numGroups, ASPx.CultureInfo.numGroupSeparator);
  if(this.prec > 0) {
   bag.push(ASPx.CultureInfo.numDecimalPoint);
   this.AppendDigits(bag, this.pointPos, this.pointPos + this.prec);
  }
  if(!this.positive) {
   switch(ASPx.CultureInfo.numNegPattern) {
    case 0:
     bag.push(")");
     break;
    case 3:
     bag.push("-");
     break;
    case 4:
     bag.push(" -");
     break;
   }
  }
  return bag.join("");
 },
 FormatPercent: function() {
  if(this.prec < 0)
   this.prec = ASPx.CultureInfo.numPrec;
  if(this.digits.length > 0)
   this.pointPos += 2;
  this.Round(this.prec);
  var bag = [ ];
  if(!this.positive)
   bag.push("-");
  if(ASPx.CultureInfo.percentPattern == 2)
   bag.push("%");    
  this.AppendGroupedInteger(bag, ASPx.CultureInfo.numGroups, ASPx.CultureInfo.numGroupSeparator);
  if(this.prec > 0) {
   bag.push(ASPx.CultureInfo.numDecimalPoint);
   this.AppendDigits(bag, this.pointPos, this.pointPos + this.prec);
  }  
  switch(ASPx.CultureInfo.percentPattern) {
   case 0:
    bag.push(" %");
    break;
   case 1:
    bag.push("%");
    break;
  }  
  return bag.join("");
 },
 FormatHex: function(value) {
  var result = value.toString(16);
  if(result.indexOf("(") > -1)
   return result;
  result = this.upper ? result.toUpperCase() : result.toLowerCase();
  if(this.prec <= result.length)
   return result;
  var bag = [ ];
  for(var i = result.length; i < this.prec; i++)
   bag.push(0);
  bag.push(result);
  return bag.join("");
 },
 FormatCustom: function(format) {
  var sectionList = this.GetCustomFormatSections(format);
  var section = this.SelectCustomFormatSection(sectionList);
  if(section == "")
   return this.positive ? "" : "-";
  var info = this.ParseCustomFormatSection(section);
  var lists = this.CreateCustomFormatLists(info);
  if(sectionList.length > 2 && section != sectionList[2]) {
   var zero = lists.i.concat(lists.f).join("").split(0).join("") == "";
   if(zero) {
    section = sectionList[2];
    info = this.ParseCustomFormatSection(section);
    lists = this.CreateCustomFormatLists(info);   
   }   
  }
  return this.FormatCustomCore(section, info, lists);
 },
 GetCustomFormatSections: function(format) {
  var sections = [ ];
  var escaping = false;
  var quote = "";
  var length = 0;
  var prevPos = 0;
  for(var i = 0; i < format.length; i++) {
   var ch = format.charAt(i);
   if(!escaping && quote == "" && ch == ";") {
    sections.push(format.substr(prevPos, length));
    length = 0;
    prevPos = i + 1;
    if(sections.length > 2)
     break;
   } else {
    if(escaping)
     escaping = false;
    else if(ch == quote)
     quote = quote == "" ? ch : "";
    else if(ch == "\\")
     escaping = true;
    else if(ch == "'" || ch == '"')
     quote = ch;
    ++length;
   }
  }
  if(length > 0)
   sections.push(format.substr(prevPos, length));
  if(sections.length < 1)
   sections.push(format);
  return sections;
 },
 SelectCustomFormatSection: function(sections) {
  if(!this.positive && sections.length > 1 && sections[1] != "") {
   this.positive = true;
   return sections[1];
  }
  if(this.digits.length < 1 && sections.length > 2 && sections[2] != "")
   return sections[2];
  return sections[0];
 },
 CreateCustomFormatInfo: function() {
  return {
   pointPos: -1,
   grouping: false,
   exp: false,
   expShowPlus: false,
   percent: false,
   scaling: 0,
   intDigits: 0,
   fracDigits: 0,
   expDigits: 0,
   intSharps: 0,
   fracSharps: 0, 
   expSharps: 0
  };
 },
 ParseCustomFormatSection: function(section) {  
  var quote = "";
  var area = "i"; 
  var canParseIntSharps = true;
  var result = this.CreateCustomFormatInfo();
  var groupSeparators = 0;  
  for(var i = 0; i < section.length; i++) {
   var ch = section.charAt(i);   
   if(ch == quote) {
    quote = "";    
    continue;
   }
   if(quote != "")
    continue;
   if(area == "e" && ch != "0" && ch != "#") {
    area = result.pointPos < 0 ? "i" : "f";
    i--;
    continue;
   }
   switch(ch) {
    case "\\":
     i++;
     continue;
    case "'":
    case '"':
     quote = ch;
     continue;
    case "#":
    case "0":
     if(ch == "#") {
      switch(area) {
       case "i":
        if(canParseIntSharps)
         result.intSharps++;
        break;
       case "f":
        result.fracSharps++;
        break;
       case "e":
        result.expSharps++;
        break;
      }
     } else {
      canParseIntSharps = false;
      switch(area) {
       case "f":
        result.fracSharps = 0;        
        break;
       case "e":
        result.expSharps = 0;
        break;
      }
     }
     switch(area) {
      case "i":
       result.intDigits++;
       if(groupSeparators > 0)
        result.grouping = true;
       groupSeparators = 0;
       break;
      case "f":
       result.fracDigits++;  
       break;
      case "e":
       result.expDigits++;
       break;
     }
     break;
    case "e":
    case "E":
     if(result.exp)
      break;
     result.exp = true;     
     area = "e"; 
     if(i < section.length - 1) {
      var next = section.charAt(1 + i);
      if(next == "+" || next == "-") {
       if(next == "+")
        result.expShowPlus = true;
       i++;
      }
      else if(next != "0" && next != "#") {
       result.exp = false;
       if(result.pointPos < 0)
        area = "i";       
      }
     }
     break;
    case ".":
     area = "f";
     if(result.pointPos < 0)
      result.pointPos = i;
     break;
    case "%":
     result.percent = true;     
     break;
    case ",":
     if(area == "i" && result.intDigits > 0)
      groupSeparators++;
     break;
    default:
     break;
   }
  }
  if(result.expDigits < 1)
   result.exp = false;
  else
   result.intSharps = 0;
  if(result.fracDigits < 1)
   result.pointPos = -1;
  result.scaling = 3 * groupSeparators;  
  return result;
 },
 CreateCustomFormatLists: function(info) {
  var intList = [ ];
  var fracList = [ ];
  var expList = [ ];
  if(this.digits.length > 0) {
   if(info.percent)
    this.pointPos += 2;
   this.pointPos -= info.scaling;
  }
  var expPositive = true;
  if(info.exp && (info.intDigits > 0 || info.fracDigits > 0)) {
   var diff = 0;
   if(this.digits.length > 0) {
    this.Round(info.intDigits + info.fracDigits - this.pointPos);
    diff -= this.pointPos - info.intDigits;
    this.pointPos = info.intDigits;
   }
   expPositive = diff <= 0;   
   expList = String(diff < 0 ? -diff : diff).split("");
  } else {
   this.Round(info.fracDigits);
  }
  if(this.digits.length < 1 || this.pointPos < 1)
   intList = [ 0 ];
  else
   this.AppendDigits(intList, 0, this.pointPos);
  this.AppendDigits(fracList, this.pointPos, this.digits.length);
  if(info.exp) {
   while(intList.length < info.intDigits)
    intList.unshift(0);
   while(expList.length < info.expDigits - info.expSharps)
    expList.unshift(0);
   if(expPositive && info.expShowPlus)
    expList.unshift("+");
   else if(!expPositive)
    expList.unshift("-");
  } else {
   while(intList.length < info.intDigits - info.intSharps)
    intList.unshift(0);    
   if(info.intSharps >= info.intDigits) {
    var zero = true;
    for(var i = 0; i < intList.length; i++) {
     if(intList[i] != 0) {
      zero = false;
      break;
     }
    }
    if(zero)
     intList = [ ];
   }
  }
  while(fracList.length < info.fracDigits - info.fracSharps)
   fracList.push(0);
  return {
   i: intList,
   f: fracList,
   e: expList
  };
 },
 FormatCustomCore: function(section, info, lists) {
  var intLen = 0; 
  var total = 0;
  var groupIndex = 0; 
  var counter = 0;
  var groupSize = 0;
  if(info.grouping && ASPx.CultureInfo.numGroups.length > 0) {
   intLen = lists.i.length;
   for(var i = 0; i < ASPx.CultureInfo.numGroups.length; i++) {
    if(total + ASPx.CultureInfo.numGroups[i] <= intLen) {
     total += ASPx.CultureInfo.numGroups[i];
     groupIndex = i;
    }
   }
   groupSize = ASPx.CultureInfo.numGroups[groupIndex];
   var fraction = intLen > total ? intLen - total : 0;
   if(groupSize == 0) {
    while(groupIndex >= 0 && ASPx.CultureInfo.numGroups[groupIndex] == 0)
     groupIndex--;
    groupSize = fraction > 0 ? fraction : ASPx.CultureInfo.numGroups[groupIndex];
   }
   if(fraction == 0) {
    counter = groupSize;
   } else {
    groupIndex += Math.floor(fraction / groupSize);
    counter = fraction % groupSize;
    if(counter == 0)
     counter = groupSize;
    else
     groupIndex++;
   }
  } else {
   info.grouping = false;
  }
  var bag = [ ];
  var area = "i";
  var intSharps = 0;
  var intListIndex = 0;
  var fracListIndex = 0;
  var savedCh = "";
  for(var i = 0; i < section.length; i++) {
   var ch = section.charAt(i);
   if(ch == savedCh) {
    savedCh = "";
    continue;
   }
   if(savedCh != "") {
    bag.push(ch);
    continue;
   }
   switch(ch) {
    case "\\":
     ++i;
     if(i < section.length)
      bag.push(section.charAt(i));
     continue;
    case "'":
    case '"':     
     savedCh = ch;
     continue;
    case "#":     
    case "0":
     if(area == "i") {
      intSharps++;
      if(ch == "0" || info.intDigits - intSharps < lists.i.length + intListIndex) {
       while(info.intDigits - intSharps + intListIndex < lists.i.length) {
        bag.push(lists.i[intListIndex]);
        intListIndex++;
        if(info.grouping && --intLen > 0 && --counter == 0) {
         bag.push(ASPx.CultureInfo.numGroupSeparator);
         if(--groupIndex < ASPx.CultureInfo.numGroups.length && groupIndex >= 0)
          groupSize = ASPx.CultureInfo.numGroups[groupIndex];
         counter = groupSize;
        }
       }
      }
     } else if(area == "f") {
      if(fracListIndex < lists.f.length) {
       bag.push(lists.f[fracListIndex]);
       fracListIndex++;
      }
     }
     break;
    case "e":
    case "E":
     if(lists.e == null || !info.exp) {
      bag.push(ch);
      break;
     }
     for(var q = i + 1; q < section.length; q++) {
      if(q == i + 1 && (section.charAt(q) == "+" || section.charAt(q) == "-"))
       continue;                   
      if(section.charAt(q) == "0" || section.charAt(q) == "#")
       continue;
      break;
     }
     i = q - 1;
     area = info.pointPos < 0 ? "i" : "f";
     bag.push(ch);
     bag = bag.concat(lists.e);
     lists.e = null;      
     break;
    case ".":
     if(info.pointPos == i && lists.f.length > 0)
      bag.push(ASPx.CultureInfo.numDecimalPoint);
     area = "f";
     break;
    case ",":
     break;
    default:
     bag.push(ch);
     break;
   }
  }
  if(!this.positive)
   bag.unshift("-");
  return bag.join("");
 },
 FillDigitInfo: function(value) {
  this.positive = true;
  if(value < 0) {
   value = -value;
   this.positive = false;   
  }
  this.digits = [ ];
  this.pointPos = 0;    
  if(value == 0 || !isFinite(value) || isNaN(value)) {
   this.pointPos = 1;
   return;
  }
  var list = String(value).split("e");
  var str = list[0];
  if(list.length > 1) {   
   this.pointPos = Number(list[1]);
  }
  var frac = false;
  var decimalCount = 0;
  for(var i = 0; i < str.length; i++) {
   var ch = str.charAt(i);
   if(ch == ".") {
    frac = true;
   } else {
    if(frac)
     decimalCount++;     
    if(ch != "0" || this.digits.length > 0)
     this.digits.push(Number(ch));
   }
  }
  this.pointPos += this.digits.length - decimalCount;
 },
 FillFormatInfo: function(format) {
  this.upper = true;
  this.custom = false;
  this.prec = -1;
  var spec;
  if(format == null || format.length < 1)
   spec = "G";
  else
   spec = format.charAt(0);
  if(spec >= "a" && spec <= "z") {
   spec = spec.toUpperCase();
   this.upper = false;
  }
  if(spec >= "A" && spec <= "Z") {   
   if(format != null && format.length > 1) {
    var prec = Number(format.substr(1));
    if(!isNaN(prec))
     this.prec = prec;
    else
     this.custom = true;
   }
  } else {
   this.custom = true;   
  }  
  this.spec = this.custom ? "0" : spec;
 },
 Round: function(shift) {
  var amount = this.digits.length - this.pointPos - shift;
  if(amount <= 0) 
   return;
  var cutPos = this.pointPos + shift;
  if(cutPos < 0) {
   this.digits = [ ];
   this.pointPos = 0;
   return;
  }
  var digit = this.digits[cutPos];
  if(digit > 4) { 
   for(var i = 0; i < amount; i++) {
    var index = cutPos - 1 - i;
    if(index < 0) {
     this.digits.unshift(0);
     this.pointPos++;
     cutPos++;
     index++;
    }
    digit = this.digits[index];    
    if(digit < 9) {
     this.digits[index] = 1 + digit;
     break;
    } else {
     this.digits[index] = 0;
     amount++;
    }
   }
  }
  for(var i = cutPos - 1; i >= 0; i--) {
   if(this.digits[i] > 0) break;
   cutPos--;
  }
  this.digits.splice(cutPos, this.digits.length - cutPos);
 },
 AppendGroupedInteger: function(list, groups, separator) { 
  if(this.pointPos < 1) {
   list.push(0);
   return;
  }
  var total = 0;
  var groupIndex = 0;
  for(var i = 0; i < groups.length; i++) {
   if(total + groups[i] <= this.pointPos) {
    total += groups[i];
    groupIndex = i;
   }
   else
    break;
  }
  if(groups.length > 0 && total > 0) {
   var counter;
   var groupSize = groups[groupIndex];
   var fraction = this.pointPos > total ? this.pointPos - total : 0;
   if(groupSize == 0) {
    while(groupIndex >= 0 && groups[groupIndex] == 0)
     groupIndex--;
    groupSize = fraction > 0 ? fraction : groups[groupIndex];
   }
   if(fraction == 0) {
    counter = groupSize;
   } else {
    groupIndex += Math.floor(fraction / groupSize);
    counter = fraction % groupSize;
    if(counter == 0)
     counter = groupSize;
    else
     groupIndex++;
   }
   var i = 0;
   while(true) {
    if(this.pointPos - i <= counter || counter == 0) {
     this.AppendDigits(list, i, this.pointPos);
     break;
    }
    this.AppendDigits(list, i, i + counter);
    list.push(separator);
    i += counter;    
    groupIndex--;     
    if(groupIndex < groups.length && groupIndex >= 0)
     groupSize = groups[groupIndex];
    counter = groupSize;
   }
  } else {
   this.AppendDigits(list, 0, this.pointPos);   
  }  
 },
 AppendDigits: function(list, start, end) {
  for(var i = start; i < end; i++) {
   if(i < 0 || i >= this.digits.length)
    list.push(0);
   else
    list.push(this.digits[i]);
  }
 }
};
})();
var MVCx = {};
(function(jQuery) {
var RunStartupScriptBlockID = "dxrssb";
var $ = jQuery;
MVCx.CallbackHtmlContentPrefix = "/*DXHTML*/";
MVCx.CallbackHtmlContentPlaceholder = "<%html%>";
MVCx.EditorsValuesKey = "DXMVCEditorsValues";
MVCx.ScriptNames = {
 MicrosoftMvcAjax: 'Microsoft Mvc Ajax',
 JQuery: 'jQuery',
 JQueryValidation: 'jQuery Validation',
 JQueryUnobtrusiveValidation: 'jQuery Unobtrusive Validation'
};
MVCx.PerformControlCallback = function(name, url, arg, params, customParams) {
 if(ASPx.GetPostHandler().cancelPostProcessing)
  return;
 var data = {};
 data.DXCallbackName = name;
 data["__DXCallbackArgument"] = arg;
 ASPx.Data.MergeHashTables(data, params);
 ASPx.Data.MergeHashTables(data, customParams);
 $.ajax({
  type: 'POST',
  url: url,
  dataType: 'html',
  data: data,
  error: function(response) {
   var ctrl = ASPx.GetControlCollection().Get(data.DXCallbackName);
   if (ctrl != null) {
    if(typeof(response.responseText) == "string" && response.responseText != "")
     ctrl.DoCallbackError(response.responseText);
    else if(typeof(response) == "string" && response != "")
     ctrl.DoCallbackError(response);
   }
  },
  success: function(response) {
   var ctrl = ASPx.GetControlCollection().Get(data.DXCallbackName);
   if (ctrl != null) ctrl.DoCallback(response);
  }
 });
};
MVCx.ThrowExceptionOnCallback = function() {
 ASPx.ShowKBErrorMessage("Invalid server response. It is required that a Partial View contains only the extension definition code, without any additional markup. To learn more, see ", "KA20010");
};
MVCx.IsCustomCallback = function(command) {
 return command && command.toUpperCase() == "CUSTOMCALLBACK";
};
MVCx.IsCustomDataCallback = function(command) {
 var commandInUpperCase = command.toUpperCase();
 return commandInUpperCase == "CUSTOMDATACALLBACK" || commandInUpperCase == "CUSTOMVALUES";
};
MVCx.GetCustomActionCallBackMethod = function(control) {
 return control.customActionCallBack || control.callBack;
};
MVCx.AddCallbackParam = function(params, input) {
 if(!params || !input || input.name == "undefined" || input.disabled) return;
 if(params.hasOwnProperty(input.name))
  return;
 switch(input.type) {
  case "checkbox":
   params[input.name] = input.checked;
   break;
  case "radio":
   if(input.checked)
    params[input.name] = input.value;
   break;
  case "select-multiple":
   var values = $(input).val() || [];
   params[input.name] = values.join ? values.join(',') : values;
   break;
  default:
   params[input.name] = input.value;
 }
};
MVCx.AddCallbackParamsInContainer = function(params, container) {
 if(!params || !container) return;
 var requireCollectEditorValues = true;
 var dxEditorValues = { };
 var $form = $(container).closest("form");
 if($form.length > 0){
  dxEditorValues = GetCachedVisibleEditorValues($form[0].DXEditorValues);
  requireCollectEditorValues = false;
 }
 $(container).find("input,textarea,select").each(function() {
  MVCx.AddCallbackParam(params, this);
  if(requireCollectEditorValues){
   var dxEditor = ASPx.GetControlCollection().Get(this.name);
   if(IsPossiblePassEditorValue(dxEditor))
    dxEditorValues[this.name] = MVCx.GetEditorValueByControl(dxEditor);
  }
 });
 params[MVCx.EditorsValuesKey] = ASPx.Json.ToJson(dxEditorValues);
};
MVCx.AddDXEditorValuesInContainer = function(params, container) {
 if(!params || !container || !ASPx.ProcessEditorsInContainer)
  return;
 var editorValues = {};
 ASPx.ProcessEditorsInContainer(container, function(control) {
  editorValues[control.name] = MVCx.GetEditorValueByControl(control);
 }, null, null, true, false);
 params[MVCx.EditorsValuesKey] = ASPx.Json.ToJson(editorValues);
};
function GetCachedVisibleEditorValues(editorValues) {
 var result = { };
 for(var key in editorValues) {
  if(!editorValues.hasOwnProperty(key)) continue;
  var editor = ASPx.GetControlCollection().GetByName(key);
  if(editor && ASPx.IsValidElement(editor.GetMainElement()))
   result[key] = editorValues[key];
 }
 return result;
}
function IsPossiblePassEditorValue(dxEditor){
 if(!dxEditor || !dxEditor.GetEnabled || !dxEditor.GetEnabled())
  return false;
 if(dxEditor.InCallback() || !dxEditor.GetValueString)
  return false;
 if(ASPx.IsGridLookup(dxEditor))
  return !dxEditor.GetGridView().InCallback();
 return true;
}
MVCx.EditorValuesSynchronizer = {
 RefreshFormsCache: function(){
  ASPx.GetControlCollection().ForEachControl(function(control){ this.UpdateFormValue(control); }.aspxBind(this));
  this.CacheAllFormValues();
 },
 UpdateFormValue: function(control, isPushValueToCache){
  if(!control || !control.GetMainElement) return;
  var mainElement = control.GetMainElement();
  var form = ASPx.GetParentByTagName(mainElement, "FORM");
  if(!form || !MVCx.IsExistingClientEdit(control) || !mainElement || !ASPx.IsValidElement(mainElement)){
   this.RemoveFormCacheValue(form);
   return;
  }
  var newEditorValue = control.GetEnabled() ? MVCx.GetEditorValueByControl(control) : null;
  this.SetFormCacheValue(form, control.name, newEditorValue);
  if(isPushValueToCache)
   this.CacheFormValues(form);
 },
 CacheAllFormValues: function(){
  for(var i = 0; i < document.forms.length; i++){
   this.CacheFormValues(document.forms[i]);
  }
 },
 CacheFormValues: function(form){
  if(!form || !form.DXEditorValues || !form.dxRequireCache)
   return;
  if(!ASPx.IsValidElement(form.DXEditorValuesField)){
   form.DXEditorValuesField = ASPx.CreateHiddenField(MVCx.EditorsValuesKey, "");
   form.appendChild(form.DXEditorValuesField);
  }
  if(form.DXEditorValuesField)
   form.DXEditorValuesField.value = ASPx.Json.ToJson(form.DXEditorValues);
 },
 SetFormCacheValue: function(form, controlName, value){
  if(!form.DXEditorValues)
   form.DXEditorValues = {};
  if(form.DXEditorValues[controlName] !== value){
   form.DXEditorValues[controlName] = value;
   form.dxRequireCache = true;
  }
 },
 RemoveFormCacheValue: function(form, controlName){
  if(!form || !form.DXEditorValues) return;
  if(ASPx.IsExistsElement(form.DXEditorValues[controlName])){
   delete form.DXEditorValues[controlName];
   form.dxRequireCache = true;
  }
 }
};
MVCx.IsExistingClientEdit = function(control) {
 if(!ASPx.Ident.IsASPxClientEdit(control))
  return false;
 var getValueInputMethod = MVCx.GetValueInputMethod(control);
 return getValueInputMethod ? ASPx.IsExistsElement(getValueInputMethod.call(control)) : true;
};
MVCx.GetValueInputElement = function(control) {
 var method = MVCx.GetValueInputMethod(control);
 return method ? method.call(control) : null;
};
MVCx.GetValueInputMethod = function(control) {
 return control.FindStateInputElement || control.GetStateInput || control.GetInputElement;
};
MVCx.GetEditorValueByControl = function(control) { 
 return ASPx.GetEditorValueByControl(control, true);
};
MVCx.EditorValueChanged = function(s, e) {
 MVCx.EditorValuesSynchronizer.UpdateFormValue(s, true);
 if(s.context) s.context.validate("blur");
};
MVCx.GetEditorByElements = function(elements) {
 for(var i = 0; i < elements.length; i++) {
  var control = MVCx.GetEditorByElement(elements[i]);
  if(control)
   return control;
 }
 return null;
};
MVCx.GetEditorByElement = function(element) {
 var control = MVCx.GetControlByElement(element);
 return control && ASPx.Ident.IsASPxClientEdit(control) ? control : null;
};
MVCx.GetControlByElement = function(element) {
 var valueInputPostfixes = ["", "_I", "_S", "_VI", "_STATE", "_KBS"];
 for(var j = 0; j < valueInputPostfixes.length; j++) {
  var regexp = new RegExp("(\S*)" + valueInputPostfixes[j] + "$");
  var controlName = regexp.test(element.id) ? element.id.replace(regexp, function(a, b) { return b; }) : "";
  var control = ASPx.GetControlCollection().Get(controlName);
  if(control)
   return control;
 }
 return null;
};
MVCx.JQueryValidation = {
 IsEnabled: function(control) {
  return !!($.validator && control.GetParentForm());
 },
 Validate:function(control){
  var valueInput = MVCx.GetValueInputElement(control);
  return $(valueInput).valid();
 },
 SetUVAttributes: function(editor, rules){
  if(!editor || !rules) return;
  $input = $(MVCx.GetValueInputElement(editor));
  $.each(rules, function(ruleName, ruleValue){
   if(ruleName === 'data-val-remote-dxfieldsmap')
    editor.uvRemoteAdditionalFields = ASPx.GetObjectKeys(ruleValue);
   var attrValue = ruleName === 'data-val-remote-dxfieldsmap' ? JSON.stringify(ruleValue) : ruleValue; 
   $input.attr(ruleName, attrValue);
  });
 },
 PrepareUVRules: function(control, prepareMethod){
  var form = control.GetParentForm();
  if(form.dxUVExecuted)
   return;
  if(prepareMethod)
   prepareMethod();
  var $form = $(form);
  if($form.off)
   $form.off(".validate");
  $form.removeData("validator");
  $.validator.unobtrusive.parse(form);
  form.dxUVExecuted = true;
 },
 ResetUVRules: function(control){
  var form = control.GetParentForm();
  if(form && typeof(form.dxUVExecuted) !== "undefined")
   delete form.dxUVExecuted;
 },
 HasPendingRequests: function(control){
  var validator = this.GetValidator(control);
  return validator && validator.pendingRequest;
 },
 SetOnStopRequestHandler: function(control, handler){
  var validator = this.GetValidator(control);
  if(validator)
   validator.dxOnStopRequestHandler = handler;
 },
 GetValidator: function(control){
  var form = control.GetParentForm();
  return form ? $(form).data('validator') : null;
 },
 EnsureStopRequestHandling: function(validator){
  if(!validator || validator.pendingRequest || !validator.dxOnStopRequestHandler) return;
  validator.dxOnStopRequestHandler();
  delete validator.dxOnStopRequestHandler;
 },
 GetValidationErrorMessage: function(editor) { 
   var validator = this.GetValidator(editor); 
   return validator && validator.errorMap && validator.errorMap[editor.uniqueID]; 
  }
};
function PatchScript(scriptName, markerObjectName, patchMethod, required) {
 var externalScriptProcessor = ASPx.GetExternalScriptProcessor();
 if(externalScriptProcessor)
  externalScriptProcessor.Process(scriptName, markerObjectName, patchMethod, required);
 else if (ASPx.GetGlobalObject(markerObjectName))
  patchMethod();
}
PatchScript(MVCx.ScriptNames.MicrosoftMvcAjax, 'Sys.Mvc', function() {
 MVCx.RequiredValidator = function MVCx_RequiredValidator() {
  MVCx.RequiredValidator.initializeBase(this);
 };
 MVCx.RequiredValidator.prototype = {
  editor: null,
  getEditor: function(context){
   if(!this.editor)
    this.editor = MVCx.GetEditorByElements(context.fieldContext.elements);
   return this.editor;
  },
  validate: function(value, context){
   var editor = this.getEditor(context);
   if(editor)
    return value != null && String(value).length > 0;
   return MVCx.RequiredValidator.callBaseMethod(this, 'validate', [value, context]);
  }
 };
 MVCx.RequiredValidator.registerClass('MVCx.RequiredValidator', Sys.Mvc.RequiredValidator);
 MVCx.RequiredValidator.create = function (rule) {
  return Function.createDelegate(new MVCx.RequiredValidator(), new MVCx.RequiredValidator().validate);
 };
 Sys.Mvc.ValidatorRegistry.validators["required"] = MVCx.RequiredValidator.create;
 MVCx.FieldContext = function MVCx_FieldContext(formContext){
  MVCx.FieldContext.initializeBase(this);
 };
 MVCx.FieldContext.prototype = {
  editor: null,
  getEditor: function(){
   if(!this.editor)
    this.editor = MVCx.GetEditorByElements(this.elements);
   return this.editor;
  },
  getDisabled: function() {
   var editor = this.getEditor();
   return this.elements[0].disabled || editor && !editor.GetEnabled();
  },
  enableDynamicValidation: function(){
   MVCx.FieldContext.callBaseMethod(this, 'enableDynamicValidation');
   var editor = this.getEditor(this.elements);
   if(editor) editor.context = this;
  },
  _getStringValue: function(){
   var editor = this.getEditor();
   if(editor)
    return editor.GetValueString();
   return MVCx.FieldContext.callBaseMethod(this, '_getStringValue');
  },
  $12: function(){
   var editor = this.getEditor();
   if(editor)
    return editor.GetValueString();
   return MVCx.FieldContext.callBaseMethod(this, '$12');
  },
  validate: function(eventName) {
   var errors = MVCx.FieldContext.callBaseMethod(this, 'validate', [eventName]);
   var editor = this.getEditor();
   if(editor){
    var errorMessage = errors.length == 0 ? null : errors[0];
    MVCx.SetEditorValidationParameters(editor, errorMessage);
   }
   return errors;
  }
 };
 MVCx.FieldContext.registerClass('MVCx.FieldContext', Sys.Mvc.FieldContext);
 if(Sys.Mvc.FormContext){
  if(Sys.Mvc.FormContext._parseJsonOptions)
   eval("Sys.Mvc.FormContext._parseJsonOptions = " + Sys.Mvc.FormContext._parseJsonOptions.toString().replace("Sys.Mvc.FieldContext", "MVCx.FieldContext"));
  else if(Sys.Mvc.FormContext.$12)
   eval("Sys.Mvc.FormContext.$12 = " + Sys.Mvc.FormContext.$12.toString().replace("Sys.Mvc.FieldContext", "MVCx.FieldContext"));
  if(Sys.Mvc.FormContext.prototype.validate)
   eval("Sys.Mvc.FormContext.prototype.validate = " + Sys.Mvc.FormContext.prototype.validate.toString().replace("elements[0].disabled", "getDisabled()"));
 }
 if(typeof(ASPx.ClearProcessingProc) != "undefined"){
  MVCx.ClearProcessingProc = ASPx.ClearProcessingProc;
  ASPx.ClearProcessingProc = function(edit) {
   MVCx.ClearProcessingProc(edit);
   if(edit.context) edit.context.clearErrors();
  };
 }
 if(typeof(Sys.Mvc.MvcHelpers) != "undefined"){
  var _asyncRequestInternal = Sys.Mvc.MvcHelpers._asyncRequest || Sys.Mvc.MvcHelpers.$2;
  Sys.Mvc.MvcHelpers._asyncRequest = Sys.Mvc.MvcHelpers.$2 = function(url, verb, body, triggerElement, ajaxOptions){
   ASPx.ResourceManager.SynchronizeResources(
    function(name, resource) { 
     if(body && body.length > 0 && !body.endsWith('&'))
      body += '&';
     body += (name + "=" + resource);
    }
   );
   var customMethodOnSuccess = ajaxOptions.onSuccess;
   ajaxOptions.onSuccess = function(ajaxContext){
    if(customMethodOnSuccess)
     customMethodOnSuccess(ajaxContext);
    ASPx.ProcessScriptsAndLinks('', true);
   };
   _asyncRequestInternal(url, verb, body, triggerElement, ajaxOptions);
  };
 }
});
PatchScript(MVCx.ScriptNames.JQueryValidation, 'jQuery.validator', function(){
  MVCx.getValueOfEditor = function(element){
   var control = MVCx.GetEditorByElement(element);
   return control ? control.GetValueString() : element.value.replace(/\r/g, "");
  };
  var elementsInternal = $.validator.prototype.elements;
  $.validator.prototype.elements = function(){
   var $elements = elementsInternal.call(this);
   var $dxElements = $();
   ASPxClientControl.GetControlCollection().ProcessControlsInContainer(this.currentForm, function(control){
    if(!MVCx.IsExistingClientEdit(control))
     return;
    var input = MVCx.GetValueInputElement(control);
    if(input && $.inArray(input, $elements) == -1)
     $dxElements = $dxElements.add(input);
   });
   $elements = $.merge($elements, $dxElements);
   if($dxElements.length){
    var allFormInputElements = Array.prototype.slice.call(this.currentForm.getElementsByTagName("INPUT"));
    $elements.sort(function(a, b) {
     return allFormInputElements.indexOf(a) - allFormInputElements.indexOf(b);
    });
   }
   return $elements;
  };
  var validationTargetForBase = $.validator.prototype.validationTargetFor;
  $.validator.prototype.validationTargetFor = function(element){
   return MVCx.GetEditorByElement(element) ? element : validationTargetForBase.call(this, element);
  };
  var checkInternal = $.validator.prototype.check;
  $.validator.prototype.check = function(element){
   var control = MVCx.GetEditorByElement(element);
   if(control && (!control.GetEnabled() || !MVCx.validateInvisibleEditors && !control.IsVisible()))
    return;
   var isValid = checkInternal.call(this, element, $);
   if(control)
    MVCx.SetEditorValidationParameters(control, this.errorMap[element.name]);
   return isValid;
  };
  var elementValueBase = $.validator.prototype.elementValue;
  $.validator.prototype.elementValue = elementValueBase && function(element){
   var dxControl = MVCx.GetEditorByElement(element);
   return dxControl ? GetStringValue(dxControl): elementValueBase.call(this, element);
  };
  var GetStringValue = function(dxControl){
   var value = dxControl.GetValueString();
   return value == null ? '' : value;
  };
  var showLabelInternal = $.validator.prototype.showLabel;
  $.validator.prototype.showLabel = function(element, message){
   var control = MVCx.GetEditorByElement(element);
   if(control)
    MVCx.SetEditorValidationParameters(control, message);
   if(control && !$.validator.unobtrusive)
    element = control.GetMainElement();
   if(!control || !control.GetErrorCell() && !control.dxgvColumnIndex)
    showLabelInternal.call(this, element, message);
  };
  var optionalInternal = $.validator.prototype.optional;
  $.validator.prototype.optional = function(element){
   var dxControl = MVCx.GetEditorByElement(element);
   if(!this.elementValue && dxControl)
    return !$.validator.methods.required.call(this, dxControl.GetValueString(), element) && "dependency-mismatch";
   return optionalInternal.call(this, element);
  };
  if (!$.validator.prototype.elementValue){
   var requiredInternal = $.validator.methods.required;
   $.validator.methods.required = function(value, element, param){
    return requiredInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var rangeInternal = $.validator.methods.range;
   $.validator.methods.range = function(value, element, param){
    return rangeInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
   var minlengthInternal = $.validator.methods.minlength;
   $.validator.methods.minlength = function(value, element, param){
    return minlengthInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
   var maxlengthInternal = $.validator.methods.maxlength;
   $.validator.methods.maxlength = function(value, element, param){
    return maxlengthInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
   var rangelengthInternal = $.validator.methods.rangelength;
   $.validator.methods.rangelength = function(value, element, param){
    return rangelengthInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
   var minInternal = $.validator.methods.min;
   $.validator.methods.min = function(value, element, param){
    return minInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
   var maxInternal = $.validator.methods.max;
   $.validator.methods.max = function(value, element, param){
    return maxInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
   var emailInternal = $.validator.methods.email;
   $.validator.methods.email = function(value, element){
    return emailInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var urlInternal = $.validator.methods.url;
   $.validator.methods.url = function(value, element){
    return urlInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var dateISOInternal = $.validator.methods.dateISO;
   $.validator.methods.dateISO = function(value, element){
    return dateISOInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var numberInternal = $.validator.methods.number;
   $.validator.methods.number = function(value, element){
    return numberInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var digitsInternal = $.validator.methods.digits;
   $.validator.methods.digits = function(value, element){
    return digitsInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var creditcardInternal = $.validator.methods.creditcard;
   $.validator.methods.creditcard = function(value, element){
    return creditcardInternal.call(this, MVCx.getValueOfEditor(element), element);
   };
   var acceptInternal = $.validator.methods.accept;
   $.validator.methods.accept = function(value, element, param){
    return acceptInternal.call(this, MVCx.getValueOfEditor(element), element, param);
   };
  }
  var dateInternal = $.validator.methods.date;
  $.validator.methods.date = function(value, element){
   var editor = MVCx.GetEditorByElement(element);
   if(editor)
    value = editor.GetValue();
   return dateInternal.call(this, value, element);
  };
  var equalToInternal = $.validator.methods.equalTo;
  $.validator.methods.equalTo = function(value, element, param){
   var target = $(param).unbind(".validate-equalTo").bind("blur.validate-equalTo", function() {
    $(element).valid();
   });
   var dxEditor;
   if(target.length > 0)
    dxEditor = MVCx.GetEditorByElement(target[0]);
   return dxEditor ? value == dxEditor.GetValue() : equalToInternal.call(this, value, element, param);
  };
  var remoteInternal = $.validator.methods.remote;
  $.validator.methods.remote = function(value, element, param){
   if(param && param.data){
    $.each(param.data, function(fieldName){
     var editorName = param.dxfieldsmap && param.dxfieldsmap[fieldName] || fieldName;
     var dxeditor = ASPx.GetControlCollection().Get(editorName);
     if(dxeditor)
      param.data[fieldName] = dxeditor.GetValueString();
    });
   }
   return remoteInternal.call(this, value, element, param);
  };
  var stopRequestInternal = $.validator.prototype.stopRequest;
  $.validator.prototype.stopRequest = function(element, valid) {
   stopRequestInternal.call(this, element, valid);
   MVCx.JQueryValidation.EnsureStopRequestHandling(this);
  };
  var focusInvalidInternal = $.validator.prototype.focusInvalid;
  $.validator.prototype.focusInvalid = function() {
   if(!this.settings.focusInvalid)
    return;
   var firstInvalidElement = this.errorList.length && this.errorList[0].element;
   var control = firstInvalidElement && MVCx.GetEditorByElement(firstInvalidElement);
   if(control)
    control.SetFocus();
   else
    focusInvalidInternal.call(this);
  };
  $.validator.addMethod("dxmask", function (value, element, params) {
   var control = MVCx.GetEditorByElement(element);
   if(control && control.maskInfo)
    return control.maskInfo.IsValid();
   return true;
  });
  $.validator.addMethod("dxdaterange", function (value, element, params) {
   var control = MVCx.GetEditorByElement(element);
   if(!control || !control.GetStartDateEdit)
    return;
   if(control.MinOrMaxRangeExist && !control.MinOrMaxRangeExist())
    return true;
   var pattern = new ASPx.DateRangeValidationPattern(control.GetStartDateEdit(), control);
   return pattern && pattern.EvaluateIsValid();
  });
});
PatchScript(MVCx.ScriptNames.JQueryUnobtrusiveValidation, 'jQuery.validator.unobtrusive', function(){
  $.validator.unobtrusive.adapters.add("dxmask", [], function (options) {
   options.rules["dxmask"] = { };
   options.messages["dxmask"] = options.message;
  });
  $.validator.unobtrusive.adapters.add("dxdaterange", [], function (options) {
   options.rules["dxdaterange"] = { };
   options.messages["dxdaterange"] = options.message;
  });
  $.each($.validator.unobtrusive.adapters, function (i, adapter) {
   if (adapter.name != "remote") return;
   adapter.params.push("dxfieldsmap");
   adapter.adaptCore = adapter.adapt;
   adapter.adapt = function (options) {
    this.adaptCore(options);
    if (options.params.dxfieldsmap)
     $.extend(options.rules["remote"], { dxfieldsmap: ASPx.Json.Eval(options.params.dxfieldsmap) });
   };
  });
  $.validator.unobtrusive.prototype = {
   parseElement: $.validator.unobtrusive.parseElement
  };
  $.validator.unobtrusive.parseElement = function (element, skipAttach) {
   $.validator.unobtrusive.prototype.parseElement.call(this, element, skipAttach);
   var editor = MVCx.GetEditorByElement(element);
   if (editor && ASPx.IsExists(editor.validationPatterns))
    editor.validationPatterns = [ ];
  };
});
PatchScript(MVCx.ScriptNames.JQuery, 'jQuery', function(){
 if($.expr && $.expr[":"] && $.expr[":"].tabbable) {
    var tabbableCore = $.expr[":"].tabbable;
    $.expr[":"].tabbable = function(element) {
   return tabbableCore.call(this, element) || isInternalTabbableInput(element);
  };
    var isInternalTabbableInput = function(element) {
     if(!element || element.tagName != 'INPUT') return false;
     var tabIndex = ASPx.Attr.GetAttribute(element, ASPx.Attr.GetTabIndexAttributeName());
     return (!tabIndex || tabIndex >= 0) && IsVisibleControlInput(element);
    };
    var IsVisibleControlInput = function(element) {
     var control = MVCx.GetControlByElement(element);
     return control && control.IsVisible();
    };
 }
 $.prototype.ajax = $.ajax;
 $.ajax = function(url, settings){
  if(typeof url === "object"){
   settings = url;
   url = undefined;
  }
  if(typeof url === "string" && !ASPx.IsExists(settings)){
   settings = { url: url };
   url = undefined;
  }
  if(isPassDXHeaders(settings)){
   var baseBeforeSendMethod = settings.beforeSend || jQuery.ajaxSettings.beforeSend;
   settings.beforeSend = function(jqXHR, options){
    var result;
    if(baseBeforeSendMethod)
     result = baseBeforeSendMethod.call(this, jqXHR, options);
    ASPx.ResourceManager.SynchronizeResources(
     function(name, resource) { 
      jqXHR.setRequestHeader(name, resource); 
     }
    );
    return result;
   };
  }
  var baseCompleteMethod = settings.complete;
  settings.complete = function(jqXHR, status) {
   $("[data-ajax=true]")
   .filter(function() { return (this.action || this.href) === settings.url; })
   .each(function() {
    var insertionMode = ($(this).attr("data-ajax-mode") || "").toUpperCase();
    if(insertionMode && insertionMode != "REPLACE" && MVCx.isDXScriptInitializedOnLoad)
     ASPx.RunStartupScripts();
   });
   var result;
   if(baseCompleteMethod)
    result = baseCompleteMethod.call(this, jqXHR, status);
   return result;
  };
  var params = [ ];
  if(url)
   params.push(url);
  params.push(settings);
  return $.prototype.ajax.apply(this, params);
 };
 if(compareJQueryVersion("1.12") < 0){
  $.prototype.clean = $.clean;
  $.clean = function(elems, context, fragment, scripts){
   var result = $.prototype.clean.call(this, elems, context, fragment, scripts);
   for(var i=0; scripts && i < scripts.length; i++){
    var script = scripts[i];
    if(isDXScriptElement(script)){
     fragment.appendChild(script);
     scripts.splice(i--, 1);
    }
   }
   return result;
  };
  var mapBase = $.map;
  $.map = function (elems, callback, arg){
   function calbackInternal(element, index, arg){
    if(isDXScriptElement(element))
     return;
    return callback(element, index, arg);
   }
   return mapBase.call(this, elems, calbackInternal, arg);
  };
  $.fn.prototype = {
   domManip: $.fn.domManip
  };
  $.fn.domManip = function (args, table, callback) {
   var result = $.fn.prototype.domManip.apply(this, arguments);
   if(MVCx.isDXScriptInitializedOnLoad && haveElementsDXScript(args))
    ASPx.RunStartupScripts();
   return result;
  };
 }
 if(compareJQueryVersion("1.12") >= 0){
  var mapBase = $.map;
  $.map = function (elems, callback, arg){
   var reenableScripts = [ ];
   function calbackInternal(element, index, arg){
    var disabledDXScript = isDXScriptElement(element) && element.type.indexOf("true") == 0;
    var ret = callback(element, index, arg);
    if(disabledDXScript && element.type.indexOf("true") < 0)
     reenableScripts.push(element);
    return ret;
   }
   var ret = mapBase.call(this, elems, calbackInternal, arg);
   var lastIndex = -1;
   for(var i = 0; i < reenableScripts.length; i++){
    lastIndex = elems.indexOf(reenableScripts[i]);
    elems[lastIndex] = document.createElement("script");
   }
   if(lastIndex > -1){
    ASPxClientUtils.ArrayRemoveAt(elems, lastIndex);
    elems.push(createRunStartupScriptBlock());
    window.setTimeout(function(){ disposeRunStartupScriptBlock(); }, 0);
   }
   return ret;
  };
 }
 function compareJQueryVersion(version){
  if(!$.fn.jquery)
   return 1;
  var jQVersionParts = $.fn.jquery.split('.');
  var versionParts = version.split('.');
  var count = Math.max(jQVersionParts.length, versionParts.length);
  for(var i = 0; i < count; i++){
   var jQPart = i < jQVersionParts.length ? parseInt(jQVersionParts[i]) : 0;
   var vPart = i < versionParts.length ? parseInt(versionParts[i]) : 0;
   var cmp = (jQPart > vPart) - (jQPart < vPart);
   if(cmp != 0)
    return cmp;
  }
  return 0;
 }
 function isDXScriptElement(element){
  return element && element.id && element.id.indexOf && element.id.indexOf(ASPx.startupScriptPrefix) == 0;
 }
 function haveElementsDXScript(elements){
  if(!elements || !elements.length)
   return false;
  var isDXScriptFound = false;
  var dxScriptSelector = "script[id^=" + ASPx.startupScriptPrefix + "]";
  var isHtmlExpression = /<|&#?\w+;/;
  for(var i = 0; i < elements.length && !isDXScriptFound; i++){
   var element = elements[i];
   if ($.type(element) != "object" && !isHtmlExpression.test(element)) continue;
   var $element = element instanceof $ ? element : $("<div>" + element + "</div>");
   $element.each(function() {
    var $this = $(this);
    if($this.is(dxScriptSelector) || $this.find(dxScriptSelector).length) {
     isDXScriptFound = true;
     return false;
    }
   });
  }
  return isDXScriptFound;
 }
 function createRunStartupScriptBlock(){
  var script = document.getElementById(RunStartupScriptBlockID);
  if(script)
   return script;
  var script = document.createElement("script");
  script.id = RunStartupScriptBlockID;
  script.type = "dx/script";
  script.text = "MVCx.isDXScriptInitializedOnLoad && ASPx.RunStartupScripts();";
  document.body.appendChild(script);
  script.type = "text/javascript";
  return script;
 }
 function disposeRunStartupScriptBlock(){
  var script = ASPx.GetElementById(RunStartupScriptBlockID);
  ASPx.RemoveElement(script);
 }
 function isPassDXHeaders(ajaxOptions){
  if(!ajaxOptions)
   return true;
  if(ajaxOptions.hasOwnProperty("passDXHeaders"))
   return ajaxOptions.passDXHeaders;
  var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
  if(ajaxOptions.accepts && ajaxOptions.accepts.json && ajaxOptions.accepts.json.indexOf(JSON_VERBOSE_MIME_TYPE) > -1)
   return false;
  if(ajaxOptions.headers && ajaxOptions.headers.hasOwnProperty("accepts") && ajaxOptions.headers.accepts.indexOf(JSON_VERBOSE_MIME_TYPE) > -1)
   return false;
  return true;
 }
}, true);
MVCx.isDXScriptInitializedOnLoad = false;
MVCx.validateInvisibleEditors = false;
MVCx.EditorSetValue = function(value){
 if(this.oldSetValue)
  this.oldSetValue(value);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.SetEditorValidationParameters = function(control, errorText){
 var isValid = !errorText;
 if(control.GetIsValid() == isValid && (isValid || control.GetErrorText() == errorText))
  return;
 if(!isValid)
  control.SetErrorText(errorText, true);
 if(ASPx.Ident.scripts.ASPxClientValidationSummary)
  ASPx.GetClientValidationSummaryCollection().AllowNewErrorsAccepting();
 control.SetIsValid(isValid);
 if(ASPx.Ident.scripts.ASPxClientValidationSummary)
  ASPx.GetClientValidationSummaryCollection().ForbidNewErrorsAccepting();
};
MVCx.MultipleEditorSelectValues = function(values){
 if(this.oldSelectValues)
  this.oldSelectValues(values);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.MultipleEditorSelectAll = function(){
 if(this.oldSelectAll)
  this.oldSelectAll();
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.MultipleEditorUnselectAll = function(){
 if(this.oldUnselectAll)
  this.oldUnselectAll();
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.ListBoxSetSelectedIndex = function(index){
 if(this.oldSetSelectedIndex)
  this.oldSetSelectedIndex(index);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.ListBoxSetIndicesSelectionState = function(indices, selected){
 if(this.oldSetIndicesSelectionState){
  this.oldSetIndicesSelectionState(indices, selected);
 }
 MVCx.EditorValueChanged(this.listBoxControl, new ASPxClientEventArgs());
};
MVCx.ComboBoxSelectIndex = function(index, initialize){
 if(this.oldSelectIndex)
  this.oldSelectIndex(index, initialize);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
 MVCx.EditorValueChanged(this.GetListBoxControl(), new ASPxClientEventArgs());
};
MVCx.TokenBoxAddToken = function(text) {
 if(this.oldAddToken)
  this.oldAddToken(text);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.TokenBoxRemoveToken = function(text) {
 if(this.oldRemoveToken)
  this.oldRemoveToken(text);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.TokenBoxClearTokenCollection = function() {
 if(this.oldClearTokenCollection)
  this.oldClearTokenCollection();
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
MVCx.TokenBoxSetTokenCollection = function(collection) {
 if(this.oldSetTokenCollection)
  this.oldSetTokenCollection(collection);
 MVCx.EditorValueChanged(this, new ASPxClientEventArgs());
};
function aspxMVCControlsInitialized(s, e){
 ASPx.GetControlCollection().ForEachControl(function(control){
  if(!MVCx.IsExistingClientEdit(control) || control.AreSyncHandlersAdded || !control.ValueChanged)
   return;
  if(ASPx.IsTokenBox(control))
   InitializeTokenBoxHandlers(control);
  else
   control.ValueChanged.InsertFirstHandler(MVCx.EditorValueChanged);
  control.EnabledChanged.InsertFirstHandler(MVCx.EditorValueChanged);
  control.LostFocus.InsertFirstHandler(function(){ MVCx.EditorValuesSynchronizer.RefreshFormsCache(); });
  if (ASPx.IsMultipleValueOwner(control))
   control.SelectedIndexChanged.InsertFirstHandler(MVCx.EditorValueChanged);
  if(!control.oldSetValue){
   control.oldSetValue = control.SetValue;
   control.SetValue = MVCx.EditorSetValue;
  }
  if(ASPx.IsMultipleValueOwner(control) && !control.oldSelectValues){
   control.oldSelectValues = control.SelectValues;
   control.SelectValues = MVCx.MultipleEditorSelectValues;
  }
  if(ASPx.IsMultipleValueOwner(control) && !control.oldSelectAll){
   control.oldSelectAll = control.SelectAll;
   control.SelectAll = MVCx.MultipleEditorSelectAll;
  }
  if(ASPx.IsMultipleValueOwner(control) && !control.oldUnselectAll){
   control.oldUnselectAll = control.UnselectAll;
   control.UnselectAll = MVCx.MultipleEditorUnselectAll;
  }
  if(ASPx.IsListBox(control)){
   if(!control.oldSetSelectedIndex){
    control.oldSetSelectedIndex = control.SetSelectedIndex;
    control.SetSelectedIndex = MVCx.ListBoxSetSelectedIndex;
   }
   var itemSelectionHelper = control.GetItemSelectionHelper();
   if(itemSelectionHelper && !itemSelectionHelper.oldSetIndicesSelectionState){
    itemSelectionHelper.oldSetIndicesSelectionState = itemSelectionHelper.SetIndicesSelectionState;
    itemSelectionHelper.SetIndicesSelectionState = MVCx.ListBoxSetIndicesSelectionState;
   }
  }
  if(ASPx.IsComboBox(control) && !control.oldSelectIndex){
   control.oldSelectIndex = control.SelectIndex;
   control.SelectIndex = MVCx.ComboBoxSelectIndex;
  }
  if($.validator && (ASPx.IsGridLookup(control) || ASPx.IsSpinEdit(control) || HasControlDxMaskAttribute(control))){ 
   control.ValueChanged.AddHandler(function(s, e){
    if(MVCx.JQueryValidation.IsEnabled(s))
     MVCx.JQueryValidation.Validate(s);
   });
  }
  control.AreSyncHandlersAdded = true;
 });
 ASPx.GetPostHandler().SetBeforeOnSubmit(function() {
  if(!ASPx.GetFocusedEditor)
   return;
  var focusedEditor = ASPx.GetFocusedEditor();
  if(focusedEditor)
   MVCx.EditorValuesSynchronizer.UpdateFormValue(focusedEditor, true);
 });
 ASPx.GetPostHandler().Update();
 MVCx.EditorValuesSynchronizer.RefreshFormsCache();
}
function InitializeTokenBoxHandlers(tokenBox) {
 tokenBox.TokensChanged.InsertFirstHandler(MVCx.EditorValueChanged);
 if(!tokenBox.oldAddToken){
  tokenBox.oldAddToken = tokenBox.AddToken;
  tokenBox.AddToken = MVCx.TokenBoxAddToken;
 }
 if(!tokenBox.oldRemoveToken){
  tokenBox.oldRemoveToken = tokenBox.RemoveToken;
  tokenBox.RemoveToken = MVCx.TokenBoxRemoveToken;
 }
 if(!tokenBox.oldClearTokenCollection){
  tokenBox.oldClearTokenCollection = tokenBox.ClearTokenCollection;
  tokenBox.ClearTokenCollection = MVCx.TokenBoxClearTokenCollection;
 }
 if(!tokenBox.oldSetTokenCollection){
  tokenBox.oldSetTokenCollection = tokenBox.SetTokenCollection;
  tokenBox.SetTokenCollection = MVCx.TokenBoxSetTokenCollection;
 }
}
function HasControlDxMaskAttribute(control){
 var inputElement = MVCx.GetValueInputElement(control);
 return inputElement && inputElement.getAttribute("data-val-dxmask");
}
ASPx.GetControlCollection().ControlsInitialized.AddHandler(aspxMVCControlsInitialized);
ASPx.Evt.AttachEventToElement(window, "load", function (evt) { 
 MVCx.isDXScriptInitializedOnLoad = true;
});
var MVCxClientUtils = {};
MVCxClientUtils.FinalizeCallback = function(){
 ASPx.ProcessScriptsAndLinks('', true);
};
MVCxClientUtils.GetSerializedEditorValuesInContainer = function(containerOrId, processInvisibleEditors) {
 return ASPxClientUtils.GetEditorValuesInContainer(containerOrId, processInvisibleEditors, true);
};
var MVCxClientBeginCallbackEventArgs = ASPx.CreateClass(ASPxClientBeginCallbackEventArgs, {
 constructor: function(command){
  this.constructor.prototype.constructor.call(this, command);
  this.customArgs = {};
 }
});
var MVCxClientGlobalBeginCallbackEventArgs = ASPx.CreateClass(ASPxClientGlobalBeginCallbackEventArgs, {
 constructor: function(control, command){
  this.constructor.prototype.constructor.call(this, control, command);
  this.customArgs = {};
 }
});
var MVCxClientGlobalEvents = {
 ControlsInitialized: new ASPxClientEvent(),
 BeginCallback: new ASPxClientEvent(),
 EndCallback: new ASPxClientEvent(),
 CallbackError: new ASPxClientEvent(),
 OnControlsInitialized: function(sender, args) {
  if(!this.ControlsInitialized.IsEmpty())
   this.ControlsInitialized.FireEvent(this, args);
 },
 OnBeginCallback: function(sender, args) {
  if(!this.BeginCallback.IsEmpty()){
   args = new MVCxClientGlobalBeginCallbackEventArgs(args.control, args.command);
   this.BeginCallback.FireEvent(this, args);
   if(args.control && args.control.callbackCustomArgs)
    ASPx.Data.MergeHashTables(args.control.callbackCustomArgs, args.customArgs);
  }
 },
 OnEndCallback: function(sender, args) {
  if(!this.EndCallback.IsEmpty())
   this.EndCallback.FireEvent(this, args);
 },
 OnCallbackError: function(sender, args) {
  if(!this.CallbackError.IsEmpty())
   this.CallbackError.FireEvent(this, args);
 }
};
MVCxClientGlobalEvents.AddControlsInitializedEventHandler = function(handler) {
 this.ControlsInitialized.AddHandler(handler);
};
MVCxClientGlobalEvents.AddBeginCallbackEventHandler = function(handler) {
 this.BeginCallback.AddHandler(handler);
};
MVCxClientGlobalEvents.AddEndCallbackEventHandler = function(handler) {
 this.EndCallback.AddHandler(handler);
};
MVCxClientGlobalEvents.AddCallbackErrorHandler = function(handler) {
 this.CallbackError.AddHandler(handler);
};
var collection = ASPx.GetControlCollection();
if(collection){
 var AddHandlerToCollection = function(eventName) {
  collection[eventName].AddHandler(MVCxClientGlobalEvents["On" + eventName].aspxBind(MVCxClientGlobalEvents));
 };
 AddHandlerToCollection("ControlsInitialized");
 AddHandlerToCollection("BeginCallback");
 AddHandlerToCollection("EndCallback");
 AddHandlerToCollection("CallbackError");
}
window.MVCxClientUtils = MVCxClientUtils;
window.MVCxClientGlobalEvents = MVCxClientGlobalEvents;
window.MVCxClientBeginCallbackEventArgs = MVCxClientBeginCallbackEventArgs;
})(window.jQuery);

(function() {
var MVCxClientChart = ASPx.CreateClass(ASPxClientWebChartControl, {
 constructor: function(name) {
  this.constructor.prototype.constructor.call(this, name);
  this.callbackUrl = "";
  this.customActionUrl = "";
  this.callbackCustomArgs = {};
  this.customActionCallBack = null;
 },
 PerformCallback: function(data, onSuccess){
  ASPx.Data.MergeHashTables(this.callbackCustomArgs, data);
  ASPxClientWebChartControl.prototype.PerformCallback.call(this, data, onSuccess);
 },
 InlineInitialize: function() {
  if (this.callbackUrl != "")
   this.callBack = function (arg) { MVCx.PerformControlCallback(this.name, this.callbackUrl, arg, this.GetCallbackParams(arg), this.callbackCustomArgs); };
  if (this.customActionUrl != "")
   this.customActionCallBack = function (arg) { MVCx.PerformControlCallback(this.name, this.customActionUrl, arg, this.GetCallbackParams(arg), this.callbackCustomArgs); };
  ASPxClientWebChartControl.prototype.InlineInitialize.call(this);
 },
 RaiseBeginCallbackInternal: function(command) {
  var args = new MVCxClientBeginCallbackEventArgs(command);
  if(!this.BeginCallback.IsEmpty())
   this.BeginCallback.FireEvent(this, args);
  ASPx.Data.MergeHashTables(this.callbackCustomArgs, args.customArgs);
 },
 CreateCallbackByInfo: function(arg, command, callbackInfo) {
  this.CreateCallbackInternal(arg, command, true, callbackInfo);
 },
 CreateCallbackCore: function(arg, command, callbackID){
  if(this.callbackCustomArgs != {})
   window.setTimeout(function(){ this.callbackCustomArgs = {}; }.aspxBind(this), 0);
  ASPxClientWebChartControl.prototype.CreateCallbackCore.call(this, arg, command, callbackID);
 },
 GetCallbackMethod: function(command){
  return MVCx.IsCustomCallback(command) ? MVCx.GetCustomActionCallBackMethod(this) : this.callBack;
 },
 GetCallbackParams: function () {
  var params = {};
  MVCx.AddCallbackParam(params, this.GetStateHiddenField());
  MVCx.AddCallbackParamsInContainer(params, this.GetMainElement());
  return params;
 },
 EvalCallbackResult: function(resultString) {
  var resultStringParts = resultString.split(MVCx.CallbackHtmlContentPrefix);
  if (resultStringParts.length == 2) {
   var resultObj = ASPxClientWebChartControl.prototype.EvalCallbackResult.call(this, resultStringParts[0]);
   resultObj.result.html = resultStringParts[1];
   return resultObj;
  }
  return ASPxClientWebChartControl.prototype.EvalCallbackResult.call(this, resultString);
 }
});
MVCxClientChart.Cast = ASPxClientControl.Cast;
window.MVCxClientChart = MVCxClientChart;
})();

